<?php

/**
 * This is the model class for table "{{purchasingcredit}}".
 *
 * The followings are the available columns in table '{{purchasingcredit}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $crm_user_id
 * @property string $vendor_id
 * @property integer $contact_id
 * @property double $exchange_rate
 * @property string $reference
 * @property string $currency_id
 * @property double $credited_amount
 * @property integer $credit_date
 * @property integer $reason
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property string $Iscreditnote_or_goodsreturn
 * @property string $isActive
 */
class Creditnote extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $customer_name;
    public $title;
    public $searchstartdate;
    public $searchenddate;
    public $value;
    public $country;
    public $lead_owner;
    public $invoice_no;

    public function tableName() {
        return '{{creditnote}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('crm_user_id,invoice_no,reason,customer_id, credit_date,warehouse_id', 'required'),
            array('file_id,order_id, crm_user_id,invoice_no, contact_id', 'numerical', 'integerOnly' => true),
            array('exchange_rate, credited_amount', 'numerical'),
            array('customer_id', 'length', 'max' => 20),
            array('reference,reason,currency_id,sales_group', 'length', 'max' => 255),
            array('Iscreditnote_or_goodsreturn, isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, file_id, crm_user_id,invoice_no, customer_id, contact_id, exchange_rate, reference, currency_id,sales_group,credited_amount, credit_date, reason, notes, terms_and_conditions, remarks, Iscreditnote_or_goodsreturn, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'items' => array(self::HAS_MANY, 'CreditnoteItem', 'creditnote_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'netAmount' => array(self::STAT, 'CreditnoteItem', 'creditnote_id', 'select' => 'SUM(net_amount)'),
            'netVat' => array(self::STAT, 'CreditnoteItem', 'creditnote_id', 'select' => 'SUM(tax_amount)'),
            'adItems' => array(self::HAS_MANY, 'CreditnoteAddition', 'creditnote_id'),
            'dedItems' => array(self::HAS_MANY, 'CreditnoteDeduction', 'creditnote_id'),
            'adTotal' => array(self::STAT, 'CreditnoteAddition', 'creditnote_id', 'select' => 'SUM(calculated_value)'),
            'dedTotal' => array(self::STAT, 'CreditnoteDeduction', 'creditnote_id', 'select' => 'SUM(calculated_value)'),
            'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group'),
            'invoice' => array(self::BELONGS_TO, 'DirectOrder', 'order_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'file_id' => 'File',
            'crm_user_id' => 'Crm User',
            'invoice_no' => 'Invoice Number',
            'customer_id' => 'Customer',
            'contact_id' => 'Contact',
            'exchange_rate' => 'Exchange Rate',
            'reference' => 'Reference',
            'currency_id' => 'Currency',
            'credited_amount' => 'Credited Amount',
            'credit_date' => 'Credit Date',
            'reason' => 'Reason',
            'notes' => 'Notes',
            'terms_and_conditions' => 'Terms And Conditions',
            'remarks' => 'Remarks',
            'Iscreditnote_or_goodsreturn' => 'Iscreditnote Or Goodsreturn',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'file.company');
        if (!empty($this->customer_id))
            $condition[] = 't.customer_id="' . $this->customer_id . '"';
        if (!empty($this->sales_group))
            $condition[] = 'sales_group="' . $this->sales_group . '"';
        if (!empty($this->lead_owner_id))
            $condition[] = 'file.lead_owner_id="' . $this->lead_owner_id . '"';
        if (!empty($this->country))
            $condition[] = 'company.billing_country="' . $this->country . '"';
        if (!empty($this->value))
            $condition[] = 'credited_amount<="' . $this->value . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('credit_date', $this->searchstartdate, $this->searchenddate);
        }
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.credit_date DESC,t.id DESC,t.file_id DESC,t.customer_id DESC',
            ),
            'pagination' => false
        ));
    }

    public function search($searchterm = null) {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('credit_search')) : $searchterm;
        $criteria->with = array('file', 'file.company', 'file.leadowner',);
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        // $userModel = User::model()->findByPK(Yii::app()->user->id);
        //$criteria->addCondition('file.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')', 'AND');
        (int) Yii::app()->session['customer_id'] > 0 ? $criteria->addCondition('t.customer_id=' . Yii::app()->session['customer_id'], 'AND') : '';
        
        $user = User::model()->findByPK(Yii::app()->user->id);
        /* if((int) Yii::app()->user->havePermissionOn['sop_credit_notes_viewall']==1 || Yii::app()->user->authorised_user == 1)
        {
            
        }
        else {
        $criteria->addCondition('t.crm_user_id=' . Yii::app()->user->id.' OR file.lead_owner_id='. Yii::app()->user->id, 'AND');
        } */
        
        if(!isset(Yii::app()->user->havePermissionOn['sop_credit_notes_viewall']) &&  Yii::app()->user->authorised_user != 1)
        {
        	$criteria->addCondition('file.crm_user_id=' . Yii::app()->user->id.' OR file.lead_owner_id='. Yii::app()->user->id, 'AND');
        }
        
        
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        t.invoice_no like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%" OR
                                        leadowner.first_name like "%' . $searchterm . '%" OR
                                        leadowner.last_name like "%' . $searchterm . '%"
                                            ', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.file_id DESC,t.customer_id,t.credit_date DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Purchasingcredits the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

 /*    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(credited_amount) FROM `crm_creditnote` where id in ($ids)");
            return $command->queryScalar();
        }
        else
            return "";
    } */
        
        public function getTotals($ids) {
        	$ids = implode(",", $ids);
        	if (!empty($ids)) {
        		$SQL = "SELECT SUM(credited_amount) AS credited_amount, I.exchange_rate FROM `crm_creditnote` AS CN INNER JOIN `crm_invoice` AS I ON invoice_no=I.id  WHERE CN.id IN ($ids)";
        		$arr_credit_note	=	Yii::app()->db->createCommand($SQL)->queryAll();
        
        		$credited_amount 	=	$arr_credit_note[0]['credited_amount'];
        		$exchange_rate		=	$arr_credit_note[0]['exchange_rate'];
        
        		return ($credited_amount * $exchange_rate);
        	}
        	else
        		return "";
        }

}
