<?php

/**
 * This is the model class for table "crm_company_temp".
 *
 * The followings are the available columns in table 'crm_company_temp':
 * @property integer $id
 * @property string $company_name
 * @property string $genral_phno
 * @property string $genral_fax
 * @property string $genral_email
 * @property string $genral_web
 * @property string $genral_industry
 * @property string $genral_location
 * @property string $billing_address
 * @property string $billing_city
 * @property string $billing_state
 * @property string $billing_country
 * @property string $billing_postalcode
 * @property string $billing_pinzip
 * @property string $shipping_address
 * @property string $shipping_city
 * @property string $shipping_state
 * @property string $shipping_country
 * @property string $shipping_postalcode
 * @property string $shipping_pinzip
 * @property string $bank__name
 * @property string $bank__branch
 * @property string $bank_account_name
 * @property string $bank_acno
 * @property string $bank__taxid
 * @property string $bank_iban
 * @property string $bank_swift
 * @property string $bank_ifsc
 * @property string $facebook
 * @property string $twitter
 * @property string $instagram
 * @property string $googleplus
 * @property string $youtube
 * @property string $linkedin
 * @property string $myspace
 * @property string $skype
 */
class CompanyTemp extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    public $genral_latitude;
    public $genral_longitude;
    public $types;
    public $company_type;
    public $shipping_address_same_as_billing;
    public $bank_others;
    public $currency;
    public $genral_payment_term;
    public $credit_limit;
    public $misc_notes;
    public $misc_status;
    
	public function tableName()
	{
		 return '{{company_temp}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('company_name, genral_phno, genral_fax, genral_email, genral_web, genral_industry, genral_location, billing_address, billing_city, billing_state, billing_country, billing_postalcode, billing_pinzip, shipping_address, shipping_city, shipping_state, shipping_country, shipping_postalcode, shipping_pinzip, bank__name, bank__branch, bank_account_name, bank_acno, bank__taxid, bank_iban, bank_swift, bank_ifsc, facebook, twitter, instagram, googleplus, youtube, linkedin, myspace, skype', 'required'),
			array('company_name, genral_phno, genral_fax, genral_email, genral_web, genral_industry, genral_location, billing_address, billing_city, billing_state, billing_country, billing_postalcode, billing_pinzip, shipping_address, shipping_city, shipping_state, shipping_country, shipping_postalcode, shipping_pinzip, bank__name, bank__branch, bank_account_name, bank_acno, bank__taxid, bank_iban, bank_swift, bank_ifsc,misc_email, facebook, twitter, instagram, googleplus, youtube, linkedin, myspace, skype', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_name, genral_phno, genral_fax, genral_email, genral_web, genral_industry, genral_location, billing_address, billing_city, billing_state, billing_country, billing_postalcode, billing_pinzip, shipping_address, shipping_city, shipping_state, shipping_country, shipping_postalcode, shipping_pinzip, bank__name,bank_id,bank__branch,bank_account_name, bank_acno, bank__taxid, bank_iban, bank_swift, bank_ifsc,misc_email, facebook, twitter, instagram, googleplus, youtube, linkedin, myspace, skype,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_name' => 'Company Name',
			'genral_phno' => 'Phone no',
			'genral_fax' => 'Fax',
			'genral_email' => 'E-mail',
			'genral_web' => 'Website',
			'genral_industry' => 'Industry',
			'genral_location' => 'Location',
			'billing_address' => 'Street Address',
			'billing_city' => 'City',
			'billing_state' => 'State',
			'billing_country' => 'Country',
			'billing_postalcode' => 'PO Box',
			'billing_pinzip' => 'Pin Code',
			'shipping_address' => 'Street Address',
			'shipping_city' => 'City',
			'shipping_state' => 'State',
			'shipping_country' => 'Country',
			'shipping_postalcode' => 'PO Box',
			'shipping_pinzip' => 'Pin Code',
			'bank__name' => 'Bank Name',
			'bank__branch' => 'Bank Branch',
			'bank_account_name' => 'Account Name',
			'bank_acno' => 'Account No',
			'bank__taxid' => 'TaxId',
			'bank_iban' => 'IBAN No.',
			'bank_swift' => 'Swift Code',
			'bank_ifsc' => 'IFSC Code',
                        'misc_email' => 'Other Email',
			'facebook' => 'Facebook',
			'twitter' => 'Twitter',
			'instagram' => 'Instagram',
			'googleplus' => 'Googleplus',
			'youtube' => 'Youtube',
			'linkedin' => 'Linkedin',
			'myspace' => 'Myspace',
			'skype' => 'Skype',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_name',$this->company_name,true);
		$criteria->compare('genral_phno',$this->genral_phno,true);
		$criteria->compare('genral_fax',$this->genral_fax,true);
		$criteria->compare('genral_email',$this->genral_email,true);
		$criteria->compare('genral_web',$this->genral_web,true);
		$criteria->compare('genral_industry',$this->genral_industry,true);
		$criteria->compare('genral_location',$this->genral_location,true);
		$criteria->compare('billing_address',$this->billing_address,true);
		$criteria->compare('billing_city',$this->billing_city,true);
		$criteria->compare('billing_state',$this->billing_state,true);
		$criteria->compare('billing_country',$this->billing_country,true);
		$criteria->compare('billing_postalcode',$this->billing_postalcode,true);
		$criteria->compare('billing_pinzip',$this->billing_pinzip,true);
		$criteria->compare('shipping_address',$this->shipping_address,true);
		$criteria->compare('shipping_city',$this->shipping_city,true);
		$criteria->compare('shipping_state',$this->shipping_state,true);
		$criteria->compare('shipping_country',$this->shipping_country,true);
		$criteria->compare('shipping_postalcode',$this->shipping_postalcode,true);
		$criteria->compare('shipping_pinzip',$this->shipping_pinzip,true);
		$criteria->compare('bank__name',$this->bank__name,true);
		$criteria->compare('bank__branch',$this->bank__branch,true);
		$criteria->compare('bank_account_name',$this->bank_account_name,true);
		$criteria->compare('bank_acno',$this->bank_acno,true);
		$criteria->compare('bank__taxid',$this->bank__taxid,true);
		$criteria->compare('bank_iban',$this->bank_iban,true);
		$criteria->compare('bank_swift',$this->bank_swift,true);
		$criteria->compare('bank_ifsc',$this->bank_ifsc,true);
		$criteria->compare('facebook',$this->facebook,true);
		$criteria->compare('twitter',$this->twitter,true);
		$criteria->compare('instagram',$this->instagram,true);
		$criteria->compare('googleplus',$this->googleplus,true);
		$criteria->compare('youtube',$this->youtube,true);
		$criteria->compare('linkedin',$this->linkedin,true);
		$criteria->compare('myspace',$this->myspace,true);
		$criteria->compare('skype',$this->skype,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CrmCompanyTemp the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
