<?php

/**
 * This is the model class for table "{{company}}".
 *
 * The followings are the available columns in table '{{company}}':
 * @property string $id
 * @property integer $crm_user_id
 * @property string $company_name
 * @property string $billing_address
 * @property string $billing_city
 * @property string $billing_postalcode
 * @property string $billing_state
 * @property string $billing_country
 * @property string $billing_pinzip
 * @property string $shipping_address
 * @property string $shipping_city
 * @property string $shipping_state
 * @property string $shipping_country
 * @property string $shipping_postalcode
 * @property string $shipping_pinzip
 * @property string $facebook
 * @property string $skype
 * @property string $twitter
 * @property string $linkedin
 * @property string $instagram
 * @property string $myspace
 * @property string $youtube
 * @property string $googleplus
 * @property string $bank__taxid
 * @property string $bank_acno
 * @property string $bank_swift
 * @property string $bank_account_name
 * @property string $bank__name
 * @property string $bank__branch
 * @property string $bank_iban
 * @property string $bank_others
 * @property string $misc_notes
 * @property string $misc_email
 * @property string $misc_status
 * @property integer $pricing_group
 * @property string $genral_phno
 * @property string $genral_email
 * @property string $genral_location
 * @property string $genral_payment_term
 * @property string $genral_fax
 * @property string $genral_web
 * @property string $genral_industry
 * @property string $genral_latitude
 * @property string $genral_longitude
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property User $crmUser
 * @property CompanyContact[] $companyContacts
 * @property CreditNote[] $creditNotes
 * @property DeliveryNotes[] $deliveryNotes
 * @property Documents[] $documents
 * @property Event[] $events
 * @property GoodsReturn[] $goodsReturns
 * @property Invoice[] $invoices
 * @property Lead[] $leads
 * @property MasterFile[] $masterFiles
 * @property Order[] $orders
 * @property Quotes[] $quotes
 */
class Company extends CActiveRecord {

    public $company_type;
    public $genral_industry_name;
    public $genral_payment_term_name;
    public $pricing_group_name;
    public $is_approved;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{company}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('company_name', 'filter', 'filter' => 'trim'),
            array('crm_user_id, company_name,  company_type ,genral_phno,
                genral_payment_term, billing_country,currency,genral_email,isActive', 'required'),
            array('crm_user_id, company_name,  company_type ,genral_phno,genral_fax,
                genral_location, billing_address,shipping_address,              
                genral_payment_term, billing_country,code_for_customer
                isActive', 'safe'),
            array('crm_user_id, pricing_group', 'numerical', 'integerOnly' => true),
            array('company_name, billing_city, billing_postalcode, billing_state,billing_address, billing_country, 
                billing_pinzip, shipping_address, shipping_city, shipping_state, shipping_country, 
                shipping_postalcode, shipping_pinzip, facebook, skype, twitter, linkedin, instagram, 
                myspace, youtube, googleplus, bank__taxid, bank_acno, bank_swift, bank_account_name, 
                bank__name, bank__branch, bank_iban, bank_others, misc_email, misc_status, genral_phno, 
                genral_email, genral_location, genral_payment_term,currency,genral_fax, genral_web, genral_industry, 
                genral_latitude,bank_ifsc, genral_longitude, company_type', 'length', 'max' => 255),
            array('credit_limit,bank_id', 'numerical'),
            array('misc_notes', 'length', 'max' => 5000),
            array('isActive,shipping_address_same_as_billing', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('crm_user_id, company_name,
                shipping_state, shipping_country, shipping_postalcode, shipping_pinzip, pricing_group, genral_phno, 
                genral_industry, isActive,company_type,created_by,updated_by,created_datetime,updated_datetime','safe', 'on' => 'search'),
                //array('facebook,youtube,genral_web', 'url', 'defaultScheme' => 'http'),
                //array('misc_email,genral_email', 'email')
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'industry' => array(self::BELONGS_TO, 'MasIndustry', 'genral_industry'),
            'countryBilling' => array(self::BELONGS_TO, 'MasCountry', 'billing_country'),
            'countryShipping' => array(self::BELONGS_TO, 'MasCountry', 'shipping_country'),
            'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'ownerCompany' => array(self::BELONGS_TO, 'MasCompany', 'own_company_id'),
            'companyContacts' => array(self::HAS_MANY, 'CompanyContact', 'company_id'),
            'priceGroup' => array(self::BELONGS_TO, 'MasPricingGroup', 'pricing_group'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'genral_payment_term'),
            'companyTypeRelation' => array(self::HAS_MANY, 'CompanyTypeRelation', 'company_id'),
            'creditNotes' => array(self::HAS_MANY, 'CreditNote', 'company_id'),
            'deliveryNotes' => array(self::HAS_MANY, 'DeliveryNotes', 'company_id'),
            'documents' => array(self::HAS_MANY, 'Documents', 'company_id'),
            'events' => array(self::HAS_MANY, 'Event', 'company_id'),
            'goodsReturns' => array(self::HAS_MANY, 'GoodsReturn', 'company_id'),
            'invoices' => array(self::HAS_MANY, 'Invoice', 'company_id'),
            'leads' => array(self::HAS_MANY, 'Lead', 'company_id'),
            'masterFiles' => array(self::HAS_MANY, 'MasterFile', 'company_id'),
            'orders' => array(self::HAS_MANY, 'Order', 'company_id'),
            'quotes' => array(self::HAS_MANY, 'Quotes', 'company_id'),
            'purchaseorder' => array(self::HAS_MANY, 'PurchasingOrder', 'vendor_id'),
            'materialreceipt' => array(self::HAS_MANY, 'PurchasingMaterialreceipt', 'vendor_id'),
            'billingcountry' => array(self::BELONGS_TO, 'MasCountry', 'billing_country'),
            'shippingcountry' => array(self::BELONGS_TO, 'MasCountry', 'shipping_country'),
            'bank' => array(self::BELONGS_TO, 'MasBank', 'bank_id'),
            'currency_code' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'company_name' => 'Company Name',
            'company_type' => 'Company type',
            'billing_address' => 'Street Address',
            'billing_city' => 'City',
            'billing_postalcode' => 'PO Box',
            'billing_state' => 'State/Province',
            'billing_country' => 'Country',
            'billing_pinzip' => 'PIN/Postal Code',
            'shipping_address' => 'Street Address',
            'shipping_city' => 'City',
            'shipping_state' => 'State/Province',
            'shipping_country' => 'Country',
            'shipping_postalcode' => 'PO Box',
            'shipping_pinzip' => 'PIN/Postal Code',
            'facebook' => 'Facebook',
            'skype' => 'Skype',
            'twitter' => 'Twitter',
            'linkedin' => 'Linkedin',
            'instagram' => 'Instagram',
            'myspace' => 'Myspace',
            'youtube' => 'Youtube',
            'googleplus' => 'Googleplus',
            'bank__taxid' => 'TAX ID',
            'bank_acno' => 'Account No.',
            'bank_swift' => 'Swift Code',
            'bank_account_name' => 'Account Name',
            'bank__name' => 'Bank Name',
            'bank__branch' => 'Branch',
            'bank_iban' => 'IBAN No.',
            'bank_ifsc' => 'IFSC Code',
            'bank_others' => 'Other Details',
            'misc_notes' => 'Notes',
            'misc_email' => 'Other E-mail',
            'misc_status' => 'Status',
            'pricing_group' => 'Pricing Group',
            'genral_phno' => 'Phone No.',
            'genral_email' => 'E-mail',
            'genral_location' => 'Location',
            'genral_payment_term' => 'Payment Terms',
            'genral_fax' => 'Fax',
            'genral_web' => 'Website',
            'genral_industry' => 'Industry',
            'genral_latitude' => 'Latitude',
            'genral_longitude' => 'Longitude',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('comp_search')) : $searchterm;
        $industrysearch = trim(Yii::app()->request->getParam('industry'));
        $countrysearch = trim(Yii::app()->request->getParam('country'));
        $criteria = new CDbCriteria;
        $criteria->with = "companyTypeRelation";
        $criteria->together = true;
        if (strlen(trim($searchterm)) == 0)
            $criteria->addCondition('t.misc_status="Y" AND t.isActive="Y"', 'AND');
        //$criteria->addCondition('own_company_id=' . Yii::app()->user->master_user_company_id . ' AND own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');
        if (!empty($searchterm)) {
            $criteria->addCondition('t.id like "%' . $searchterm . '%" OR company_name like "%' . $searchterm . '%"', 'AND');
        }
        if (!empty($countrysearch)) {
            $criteria->addCondition('billing_country=' . $countrysearch . ' OR shipping_country=' . $countrysearch, 'AND');
        }
        if (!empty($industrysearch)) {
            $criteria->addCondition('genral_industry=' . $industrysearch, 'AND');
        }
        if (!(int) Yii::app()->user->havePermissionOn['masters_company_view_customer'])
            $criteria->addCondition('companyTypeRelation.type_id<>1', 'AND');
        if (!(int) Yii::app()->user->havePermissionOn['masters_company_view_vendor'])
            $criteria->addCondition('companyTypeRelation.type_id<>2', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id,t.company_name',
            ),
            
            //   'pagination'=>false,

            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    public function report() {
        /* $criteria = new CDbCriteria;
          if (!empty($this->company_type))
          $condition[] = 'companyType.type="' . $this->company_type . '"';
          if (!empty($this->isActive))
          $condition[] = 't.isActive="' . $this->isActive . '"';
          if (!empty($this->genral_industry))
          $condition[] = 't.genral_industry=' . $this->genral_industry;
          if (!empty($this->billing_country))
          $condition[] = 't.billing_country=' . $this->billing_country;
          if (is_array($condition))
          $criteria->condition = implode(' AND ', $condition);
          else
          $criteria->condition = '';
          $criteria->with = 'companyTypeRelation.companyType'; */
        $criteria = new CDbCriteria;
        //$criteria->with = 'companyTypeRelation.companyType';
        $criteria->with = 'companyTypeRelation';
        if (!empty($this->company_type))
            $criteria->addCondition('companyTypeRelation.type_id=' . $this->company_type, 'AND');
        //if (!empty($this->isActive))
        //  $criteria->addCondition('t.isActive=' . $this->isActive, 'AND');
        if (!empty($this->genral_industry))
            $criteria->addCondition('t.genral_industry=' . $this->genral_industry, 'AND');
        if (!empty($this->billing_country))
            $criteria->addCondition('t.billing_country=' . $this->billing_country, 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.company_name',
            ),
            'pagination' => false
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Company the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getCompanies($type = array("C")) {
        $company_types = implode('","', $type);
        $condition = 'company.isActive =  "Y" and companyType.type in ("' . $company_types . '")';
        //$condition = 'company.isActive =  "Y" and companyType.type in ("' . $company_types . '") and company.own_branch_id='.Yii::app()->user->master_user_branch_id;
        $model = CompanyTypeRelation::model()
                ->with(array('companyType', 'company'))
                ->findAll(array('condition' => $condition, 'order' => 'company.company_name ASC'));
        return CHtml::listData($model, 'company.id', 'company.company_name');
    }

    public static function getVendors($type = array("V")) {
        $company_types = implode('","', $type);
        $condition = 'company.isActive =  "Y" and companyType.type in ("' . $company_types . '")';
        $model = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'company.id', 'company.company_name');
    }

    /* retuns full billing address */

    public function getBillingAddress() {
        $address = array();
        $address[] = $this->billing_address;
        if (!empty($this->billing_postalcode))
            $address[] = "PO Box:" . $this->billing_postalcode;
        if (!empty($this->billing_pinzip))
            $address[] = "Post Code:" . $this->billing_pinzip;
        $address[] = ($this->billing_city ) ? $this->billing_city . ',' : '';
        $address[] = $this->billingcountry->country_name;
        return (implode('<br/>', array_filter($address)));
    }

    public function getBankdetails() {
        $address = array();
        $address[] = $this->bank->bank_name;
        if (!empty($this->bank_acno))
            $address[] = "Account No:" . $this->bank_acno;
        //$address[] = $this->billing_pinzip;
        return (implode('<br/>', array_filter($address)));
    }

    /* retuns full shipping address */

    public function getShippingAddress() {
        $address = array();
        $address[] = $this->shipping_address;
        //$address[] = $this->shipping_city;
        //$address[] = $this->shipping_postalcode;
        if (!empty($this->shipping_postalcode))
            $address[] = "PO Box:" . $this->shipping_postalcode;
        if (!empty($this->shipping_pinzip))
            $address[] = "Post Code:" . $this->shipping_pinzip;
            $address[] = ($this->shipping_city ) ? $this->shipping_city . ',' : '';
            $address[] =  $this->shippingcountry->country_name;
        //$address[] = $this->shipping_pinzip;
        return (implode('<br/>', array_filter($address)));
    }

    /* retuns geo location */

    public function getGeoLoc() {
        return ($this->genral_latitude . ', ' .
                $this->genral_longitude
                );
    }

    public function getTypes() {
        $types = array();
        $models = CompanyTypeRelation::model()->findAll('company_id=' . $this->id);
        foreach ($models as $eachType) {
            $types[] = $eachType->type_id;
        }
        /* if (is_array($types))
          $types = implode(',', $types); */
        return $types;
    }

    public function getCompany_name_short() {
        if (strlen($this->company_name) > 31)
            return substr($this->company_name, 0, 33) . '..';
        else
            return $this->company_name;
    }
  
public function getIdF() {
        return "c" . $this->id;
    }
 public function getIdFV() {
        return "v" . $this->id;
    }
}
