<?php

/**
 * This is the model class for table "{{audit_log}}".
 *
 * The followings are the available columns in table '{{audit_log}}':
 * @property integer $id
 * @property integer $form_id
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $action
 */
class AuditLog extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $audit_log_start_date="";
	public $audit_log_end_date="";
	public $audit_log_type="";
	
	public function tableName()
	{
		return '{{audit_log}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('form_id, created_by, created_date_time, action', 'required'),
			array('form_id, created_by', 'numerical', 'integerOnly'=>true),
			array('action', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, form_id, created_by, created_date_time, action', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'form_id' => 'Form',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'action' => 'Action',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('form_id',$this->form_id);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('action',$this->action,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public function report() {
		$criteria = new CDbCriteria;
		if (!empty($this->audit_log_start_date) && !empty($this->audit_log_end_date))
			 $criteria->addCondition('date(t.created_date_time)>="' . $this->audit_log_start_date . '" AND date(t.created_date_time)<="' . $this->audit_log_end_date . '"'," AND");
		
		if (!empty($this->audit_log_type))
			$criteria->addCondition('t.form_id="' . $this->audit_log_type . '"'," AND");
		

		 return new CActiveDataProvider($this, array(
		 		'criteria' => $criteria,
		 		'sort' => array(
		 				'defaultOrder' => 't.created_date_time DESC',
            ),
            'pagination' => false
		 		));
    }

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AuditLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function getAuditLogFormName($form_id=0)
	{
		switch ($form_id) {
			case '1':
				return 'Customer';
				break;
			case '2':
				return 'Entry Invoice';
				break;
			case '3':
				return 'Exit Invoice';
				break;
			default:
				return "";
				break;
		}
	}
}
