<?php

/**
 * This is the model class for table "{{mas_file}}".
 *
 * The followings are the available columns in table '{{mas_company}}':
 * @property string $id
 * @property string $alert


 * @property string $isActive
 */
class Advance extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{advance}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('customer_id, advance, advance_date', 'required'),
  
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('customer_id, advance, advance_date, remarks', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        		'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'customer_id' => 'Customer',
            'advance' => 'Advance',
            'advance_date' => 'Advance Date',
            'remarks' => 'Remarks',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $searchterm = trim(Yii::app()->request->getParam('searchterm'));

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('customer_id', $this->customer_id, true);
        $criteria->compare('advance', $this->advance, true);
        $criteria->compare('advance_date', $this->advance_date, true);
        $criteria->compare('remarks', $this->remarks, true);
        if (!empty($searchterm)) {
            $criteria->addCondition(' t.advance like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }
   

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompany the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
	
   

}