<?php

class WebsitelinkController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','Save','Delete'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasUrl();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
                   1 =>'name',
                   2 =>'url',
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (name LIKE '%".$searchString."%' OR url  LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                
                foreach ($model as $row)
                {
                    $div = '';
                    if (isset(Yii::app()->user->havePermissionOn['website_link_edit']) ||  Yii::app()->user->authorised_user == 1) {
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'websitelink/create&id='.$row['id'].'\',\'Edit Website Link\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if (isset(Yii::app()->user->havePermissionOn['website_link_delete']) ||  Yii::app()->user->authorised_user == 1) {
                        $div .= ' <button class="btn btn-danger btn-xs" onclick="deleteWebsiteLink('.$row['id'].')"><i class="fa fa-trash"></i></button>';
                    }
                    $rowData[]=array($m,$row['name'],$row['url'],'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasUrl();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('websitelink', array('model' => $model), false, false);
        }
  
  
        public function actionSave()
        {
            $model = new MasUrl();
            if (isset($_POST['MasUrl']))
            {
    		    if ((int) @$_POST['MasUrl']['id'] > 0)
                {  
                    $id= (int) @$_POST['MasUrl']['id'];
                    $model=$model->findByPk($id);  
                }
                $model->attributes=$_POST['MasUrl'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['rack_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDelete(){
		    $id = $_POST['id'];
                $model=new MasUrl();
                $model->deleteByPk($id);
                echo "success";
        }
}