<?php

class UnitController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteUnit','SaveUnit','GetUnitList','DirectAdd','DirectAddTax'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        $this->render('index');
         }
         
        public function actionGetUnitList()
         {
 
                $model=new Unit();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'unit_name',
                   1 =>'symbol',
                   2=>'unit_type'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (unit_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                
                foreach ($model as $row)
                {
                    $div = '';
                        if($row->unit_type==1)
                        $type="Integer";
                    else if($row->unit_type==2)
                        $type="Decimal";
                    else $type=" ";
                    
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_unit_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'unit/create&id='.$row['id'].'\',\'Edit Unit\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_unit_delete"])){
                    //    $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUnit('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                        $rowData[]=array($m,$row['unit_name'],$row['symbol'],$type,'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                
                
                
//                foreach ($model as $row)
//                {
//                    if($row->unit_type==1)
//                        $type="Integer";
//                    else if($row->unit_type==2)
//                        $type="Decimal";
//                    else $type=" ";
//                    
//                    $rowData[]=array($m,$row['unit_name'],$row['symbol'],$type,
//              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'unit/create&id='.$row['id'].'\',\'Edit Unit\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUnit('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new Unit(); 
        $id=(int) Yii::app()->request->getParam('id');
         $from=(int) Yii::app()->request->getParam('from');
            if($id>0){
                $model=$model->findByPk($id);
            }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('unit_form', array('model' => $model,'from' => $from), false, true);
    }
    public function actionSaveUnit()
        {
            $model = new Unit();
            if (isset($_POST['Unit']))
            {   $model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['Unit']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['Unit']['id'];
                    $model=$model->findByPk($id); 
                }
                $model->attributes=$_POST['Unit'];
                $model->unit_type=$_POST['Unit']['unit_type'];
                if($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['unit_form'];
                        $jsonData['from'] = $_POST['from'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                       // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
               // $this->render('bank_form', array('model' => $model), false, true);

            }
        }
        public function actionDeleteUnit()
    {
		$id = $_POST['id'];
                $model_s = Store::model()->findAll(array('condition'=>'unit_id='.$id.' '));
                if(empty($model_s)){
                    $model=new Unit();
                    $model->deleteByPk($id);
                    echo "success";  
                }else{
                    echo "fail";  
                }
               
    }
    
         public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $symbol = $_POST['symbol'];
           $type = $_POST['type'];
           if($name != '' && $symbol != '' && $type !=''){
               $modelUnit = new Unit;
               $modelUnit->unit_name = $name;
               $modelUnit->symbol = $symbol;
               $modelUnit->unit_type = $type;
               if($modelUnit->save()){
                    $data  = Unit::getUnits();
                    if($from == 'inventory'){
                        $model = new Store;
                        $field_name = 'unit_id';
                    }
                    $model->$field_name = $modelUnit->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Unit <span style="color:red;">*<span>'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                   $error = CActiveForm::validate($modelUnit, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
           
            
         }
         
          public function actionDirectAddTax(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $percent = $_POST['percent'];
           if($name != '' && $percent !=''){
                    $modelTax = new MasInvTax;
                    $modelTax->tax_code = $name;
                    $modelTax->percentage = $percent;
                    if($modelTax->save()){
                         $data  = MasInvTax::getTax();
                    if($from == 'inventory'){
                        $model = new Store;
                        $field_name = 'tax_code';
                    }
                    if($from == 'inventory_1'){
                        $model = new Store;
                        $field_name = 'tax_code_1';
                    }
                    if($from == 'inventory_2'){
                        $model = new Store;
                        $field_name = 'tax_code_2';
                    }
                    if($from == 'inventory_3'){
                        $model = new Store;
                        $field_name = 'tax_code_3';
                    }
                    $model->$field_name = $modelTax->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Tax Code <span style="color:red;">*<span>'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                   $error = CActiveForm::validate($modelTax, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
         
            
         }
        
        
  
}