<?php
class ShiftController extends Controller
{
    public $layout = 'layout';
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','GetList','Create','SaveShift','Close' ,'PrintShift', 'Expense', 'Saveexpense', 'Expenselist', 'Getexpenselist',
                                        'Printvoucher', 'Getincomelist', 'Incomelist', 'Saveincome', 'Income'),
                                                'expression' => '$user->isMember()',
                ),
                array('deny', // deny all users
                        'users' => array('*'),
                ),
        );
    }
        public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
    public function actionIndex(){
        $loc_id=(int) Yii::app()->request->getParam('loc_id');
    	$type=Yii::app()->request->getParam('type');
    	$this->render('index',array('type'=>$type,'loc_id'=>$loc_id));
    }

    public function actionGetList(){

        $model=new Shift();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $loc_id=$_POST['loc_id'];
    	$type=$_POST['type'];
        $columns = array(
        // datatable column index  => database column name
        0 =>'t.id',
        1 =>'opening_date',
        2 =>'opening_time',
        3 =>'first_name',
        4 =>'opening_balance',
        5 =>'closing_time',6 =>'closing_balance',7 =>'t.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        if(Yii::app()->user->authorised_user == 1){
            $condition = '1=1 ';
        }else{
            $condition = 'user_id="'.Yii::app()->user->id.'" ';
        }
        if($loc_id>0){
             $condition .= ' AND location_id="'.$loc_id.'" ';
        }
        if($type!=''){
             $condition .= ' AND entry_or_exit="'.$type.'" ';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!=""){
            $searchString = $_POST['search']['value'];
            $condition.=" and (t.closing_balance LIKE '%".$searchString."%' OR t.opening_balance LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'opening_date DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m = 1;
        $printType = ( $type == 'EN' ) ? 0 : 1;
        foreach ($model as $row){

            $status  = "";

            
            $div = '';
			if($row['status']=='SC'){ 
			 $div .=   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'shift/close&id='.$row['id'].'\',\'Close Shift\',\'lg\')"><i class="fa fa-eye"></i></button>';
			}else{

           $div .=   ' <div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'shift/close&id='.$row['id'].'&loc_id='.$row['location_id'].'&type='.$row['entry_or_exit'].'\',\'Close Shift\',\'lg\')"><i class="fa fa-pencil"></i></button>';
			}
            
            $div .= ' <button class="btn btn-primary btn-xs" onclick="return print_shift('.$row['id'].', '.$printType.' )" ><i class="fa fa-print"></i>';
            $rowData[]=array($m,date("d/m/Y",strtotime($row['opening_date'])),$row['opening_time'],$row['user']['first_name'].' '.$row['user']['last_name'],$row['opening_balance'],$row['closing_time'],$row['closing_balance']
                                    ,'<div class="btn-wrap text-center">'.$div.'</div>');

            $m++;

        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $id=(int) Yii::app()->request->getParam('id');
    	$model = new Shift();
        $location_id=(int) Yii::app()->request->getParam('loc_id');
        $entry_or_exit=Yii::app()->request->getParam('type');
        $old_shift_bal = Shift::model()->find(array('condition'=>'location_id="'.$location_id.'" AND entry_or_exit="'.$entry_or_exit.'" AND status="SC"','order'=>'id DESC','select'=>'closing_balance'))->closing_balance;
        $model->location_id=(int) Yii::app()->request->getParam('loc_id');
        $model->entry_or_exit=Yii::app()->request->getParam('type');
        if($old_shift_bal>0)
        $model->opening_balance=$old_shift_bal;
    	Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
    	$this->renderPartial('create', array('model' => $model), false, true);

    }
    public function actionClose()
    {
        $id=(int) Yii::app()->request->getParam('id');
    	$loc_id=(int) Yii::app()->request->getParam('loc_id');
    	$type=Yii::app()->request->getParam('type');
    	$model = new Shift();
    	if($id > 0)
    	{
            $model  = Shift::model()->findByPk($id);
            if($model->status=='SO'){
                $condn = 'created_by="'.$model->user_id.'" AND created_date >= "'.$model->created_date_time.'"';
                $condn2 = 'created_by="'.$model->user_id.'" AND DATE(created_datetime) >= "'.date('Y-m-d', strtotime($model->created_date_time)).'"';
                $exit_inv = ExitInvoice::model()->find(array('condition'=>$condn,'select'=>'IFNULL(SUM(grand_total),0)AS grand_total'))->grand_total;
                $cashCollected_exit = (float) ExitInvoice::model()->find(array('condition'=>$condn.' AND payment_terms=1','select'=>'IFNULL(SUM(grand_total),0)AS grand_total'))->grand_total;
                $cashCollected_entry = (float) EntryInvoice::model()->find(array('condition'=>$condn.' AND payment_terms=1','select'=>'IFNULL(SUM(grand_total),0)AS grand_total'))->grand_total;
                $entry_inv = EntryInvoice::model()->find(array('condition'=>$condn,'select'=>'IFNULL(SUM(grand_total),0)AS grand_total'))->grand_total;
                $model->invoice_amount=$exit_inv+$entry_inv;
                $model->cash_collected = ($cashCollected_exit+$cashCollected_entry);
                $model->credit_amount=$model->invoice_amount-$model->cash_collected-$model->cheque_collected;
                $expenses = Expense::model()->find(array('condition'=>$condn2,'select'=>'IFNULL(SUM(amount),0)AS amount'))->amount;
                $income = Income::model()->find(array('condition'=>$condn2,'select'=>'IFNULL(SUM(amount),0)AS amount'))->amount;
                $model->expenses = $expenses;
                $model->income = $income;
            }
    	}
    	Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
    	$this->renderPartial('close', array('model' => $model), false, true);

    }
    public function actionSaveShift()
    {
    	$model = new Shift();
        $h = "4";// Hour for time zone goes here e.g. +7 or -4, just remove the + or -
        $hm = $h * 60;
        $ms = $hm * 60;
        $gmdate = gmdate("m/d/Y g:i:s A", time()+($ms));
    	if (isset($_POST['Shift'])) {
            if ((int) @$_POST['Shift']['id'] > 0){
                $model=$model->findByPk((int)$_POST['Shift']['id']);
                $model->scenario = 'update';
		$model->attributes = $_POST['Shift'];
                $model->status='SC';
                $model->closing_date=date('Y-m-d');
                $model->closing_time=gmdate("g:i:s A", time()+($ms));
            }else{
                $model->scenario = 'add';
		$model->status='SO';
                $model->attributes = $_POST['Shift'];
                $model->opening_date=date('Y-m-d');
                $model->opening_time=gmdate("g:i:s A", time()+($ms));
                date_default_timezone_set("Asia/Dubai");
                $model->created_date_time=date('Y-m-d H:i:s');
            }
            $model->location_id=$_POST['Shift']['location_id'];
            $model->entry_or_exit=$_POST['Shift']['entry_or_exit'];
                
            $valid =$model->validate();
			
			
			
            if ($valid) {
                $model->save();
                $model_id = $model->id;
                $model->refresh();
                $modelAuditLog = new AuditLog();
                if($model->id > 0)
                {
                        $action_audit_log = "Shift [Id: ".$model->id."] updated by ".$user_full_name." on ".date('d/m/Y')." at ".date('h:i A');
                }
                else
                {
                        $action_audit_log = "New Shift [Id: ".$model->id."] added by ".$user_full_name." on ".date('d/m/Y')." at ".date('h:i A');
                }

                $modelAuditLog->form_id=4;//shift
                $modelAuditLog->created_by=Yii::app()->user->id;
                $modelAuditLog->created_date_time=date('Y-m-d H:i:s');
                $modelAuditLog->action=$action_audit_log;

                $modelAuditLog->save(false);

                /****************** End Save data into Audit Log **************/





                    $jsonData['model'] = $model;
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
            } else {

                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                            echo $error;
            }
            Yii::app()->end();
        }
    }

    public function actionPrintShift() {
        $id=(int) Yii::app()->request->getParam('id');
        $from=Yii::app()->request->getParam('from');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.shift.print_shift', array('id' => $id, 'from' => $from ), true));

        $mPDF1->Output("print_shift.pdf", 'I');

    }

    public function actionExpense(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('expense_form');
    }

    public function actionSaveexpense(){
        if(isset($_POST['Expense'])){
            date_default_timezone_set("Asia/Dubai");
            $expense = new Expense;
            $expense->attributes = $_POST['Expense'];
            $expense->location_id = Yii::app()->user->user_location;
            $expense->created_by = Yii::app()->user->id;
            $expense->created_datetime  = date('Y-m-d H:i:s');
            $expense->save(false);
        }
        echo json_encode(array('status' => 'success'));
    }

    public function actionExpenselist(){
        $this->render('expense_list');
    }
    
    public function actionGetexpenselist(){
        $model=new Expense();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            // 0 =>'t.id',
            // 1 =>'opening_date',
            // 2 =>'opening_time',
            // 3 =>'first_name',
            // 4 =>'opening_balance',
            // 5 =>'closing_time',6 =>'closing_balance',7 =>'t.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        if(Yii::app()->user->authorised_user == 1){
            $condition = '1=1 ';
        }else{
            $condition = 'created_by="'.Yii::app()->user->id.'" ';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!=""){
            $searchString = $_POST['search']['value'];
            $condition.=" and (narration LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m = 1;
        foreach ($model as $row){

         
            $div = ' <a class="btn btn-primary btn-xs" target="_blank" href="index.php?r=shift/printvoucher&type=1&id=' . $row['id'] . '"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            $rowData[]=array($m,date("d/m/Y",strtotime($row['created_datetime'])),$row['narration'],$row['amount'],'<div class="btn-wrap text-center">'.$div.'</div>');

            $m++;

        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionPrintvoucher(){

       
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $model = ($type == 1 ) ? new Expense : new Income;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.expense', array('model' => $model, 'id' => $id), true));
        $mPDF1->Output("expense.pdf", 'I');
    }

    public function actionIncome(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('income_form');
    }

    public function actionSaveincome(){
        if(isset($_POST['Income'])){
            date_default_timezone_set("Asia/Dubai");
            $expense = new Income;
            $expense->attributes = $_POST['Income'];
            $expense->location_id = Yii::app()->user->user_location;
            $expense->created_by = Yii::app()->user->id;
            $expense->created_datetime  = date('Y-m-d H:i:s');
            $expense->save(false);
        }
        echo json_encode(array('status' => 'success'));
    }

    public function actionIncomelist(){
        $this->render('income_list');
    }
    
    public function actionGetincomelist(){
        $model=new Income();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            // 0 =>'t.id',
            // 1 =>'opening_date',
            // 2 =>'opening_time',
            // 3 =>'first_name',
            // 4 =>'opening_balance',
            // 5 =>'closing_time',6 =>'closing_balance',7 =>'t.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        if(Yii::app()->user->authorised_user == 1){
            $condition = '1=1 ';
        }else{
            $condition = 'created_by="'.Yii::app()->user->id.'" ';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!=""){
            $searchString = $_POST['search']['value'];
            $condition.=" and (narration LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m = 1;
        foreach ($model as $row){

         
            $div = ' <a class="btn btn-primary btn-xs" target="_blank" href="index.php?r=shift/printvoucher&type=2&id=' . $row['id'] . '"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            $rowData[]=array($m,date("d/m/Y",strtotime($row['created_datetime'])),$row['narration'],$row['amount'],'<div class="btn-wrap text-center">'.$div.'</div>');

            $m++;

        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

}
