<?php

class ReportsController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','LoadMasterReportFilter','PrintInventoryReport','PrintCustomerReport','PrintCustomerContactReport',
                    'PrintDailyEntry','PrintDailyExit','PrintAuditlog','PrintInvoiceReport','PrintAdminTransactionlist','PrintClearingTransactionList','PrintTransactionList','PrintRecieptofPayments','PrintCustomeradvancepayment','printDaybook',
                'PrintGLReport', 'PrintGLStatementReport', 'PrintGLSummaryReport', 'PrintTrialBalance', 'PrintfinDayBook', 'PrintAgeingReport', 'BalanceSheetViewPdf', 'PrintProfitLoss', 'PrintVatFinalSummary', 'PrintVatSummary'
                ,'PrintGLReportcash','PrintAdminTransactionListPDF','PrintSecurityDeposit','PrintRefundList','PrintEntryAdminTransactionList','PrintExitAdminTransactionList','PrintEntryAdminTransactionListPDF','PrintExitAdminTransactionListPDF'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $frm = Yii::app()->request->getParam('frm');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false );
        $this->render('master_report', array('frm' => $frm));
    }

    public function actionLoadMasterReportFilter() {
        $report_from = Yii::app()->request->getparam('report_from');       
        if ($report_from == 'inventorylist') {

            $this->renderPartial('//reports/filter_inventorylist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'customerlist') {

            $this->renderPartial('//reports/filter_customerlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'invoicelist') {

            $this->renderPartial('//reports/filter_invoicelist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'dailyentry') {

            $this->renderPartial('//reports/filter_dailyentry', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'dailyexit') {

            $this->renderPartial('//reports/filter_dailyexit', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'auditlog') {

            $this->renderPartial('//reports/filter_auditlog', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'customercontactlist') {

            $this->renderPartial('//reports/filter_customercontactlist', array('report_from' => $report_from), false, true);
        }
		
		 if ($report_from == 'adminTransactionList') {

            $this->renderPartial('//reports/filter_admin_Transactionlist', array('report_from' => $report_from), false, true);
        }
		
		
		 if ($report_from == 'ClearingTransactionList') {

            $this->renderPartial('//reports/filter_clearing_Transactionlist', array('report_from' => $report_from), false, true);
        }
		
		
		if ($report_from == 'TransactionList') {

            $this->renderPartial('//reports/filter_Trasactionlist', array('report_from' => $report_from), false, true);
        }
		
		if ($report_from == 'RecieptofPayments') {

            $this->renderPartial('//reports/filter_RecieptofPayments', array('report_from' => $report_from), false, true);
        }
		
		if ($report_from == 'Customeradvancepayment') {

            $this->renderPartial('//reports/filter_Customeradvancepayment', array('report_from' => $report_from), false, true);
        }
		
		if ($report_from == 'daybook') {

            $this->renderPartial('//reports/filter_daybook', array('report_from' => $report_from), false, true);
        }
		
		
       if ($report_from == 'gl_report' ) {

           $this->renderPartial('//reports/filter_gllist', array('report_from' => $report_from), false, true);
       }
       if ( $report_from == 'gl_report_cash' ) {

        $this->renderPartial('//reports/filter_gllist_cash', array('report_from' => $report_from), false, true);
    }
       if ($report_from == 'gl_statement_report') {

           $this->renderPartial('//reports/filter_gl_statement_list', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'gl_summary') {

           $this->renderPartial('//reports/filter_gl_summary_list', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'ageing_report') {

           $this->renderPartial('//reports/filter_ageing_list', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'vat_report' || $report_from == 'vat_report_all') {

           $this->renderPartial('//reports/filter_vat_report', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'vat_summary' || $report_from == 'vat_summary_all' || $report_from == 'vat_detailed_all') {

           $this->renderPartial('//reports/filter_vat_summary', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'daybook_report') {

           $this->renderPartial('//reports/filter_daybook_list', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'trial_balance_report') {

           $this->renderPartial('//reports/filter_trial_balance', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'balance_sheet') {

           $this->renderPartial('//reports/filter_balance', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'trial_balance_report_ex') {

           $this->renderPartial('//reports/filter_trial_balance_ex', array('report_from' => $report_from), false, true);
       }
       if ($report_from == 'profit_loss') {

           $this->renderPartial('//reports/filter_profit_loss', array('report_from' => $report_from), false, true);
       }
       
        if ($report_from == 'security_deposit') {

            $this->renderPartial('//reports/filter_security_deposit', array('report_from' => $report_from), false, true);
        }
      
        if ($report_from == 'refund') {

            $this->renderPartial('//reports/filter_refund', array('report_from' => $report_from), false, true);
        }  
		
		 if ($report_from == 'adminTransactionList_entry') {

            $this->renderPartial('//reports/filter_admin_transactionlist_entry', array('report_from' => $report_from), false, true);
        }
		
		 if ($report_from == 'adminTransactionList_exit') {

            $this->renderPartial('//reports/filter_admin_transactionlist_exit', array('report_from' => $report_from), false, true);
        }
        
    }

   

    public function actionPrintCustomerReport() {

        $model = new Customer_vendor();

        $customer_name = $_POST['customer_name'];

        $country = $_POST['country'];
        $user = $_POST['user'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customer_list', array('model' => $model, 'customer_name' => $customer_name, 'country' => $country, 'title' => $title, 'user' => $user), false, true);
    }

    public function actionPrintCustomerContactReport() {

        $model = new CustomerContact();

        $customer_name = $_POST['customer_name'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customercontact_list', array('model' => $model, 'customer_name' => $customer_name, 'title' => $title), false, true);
    }

    

    public function actionPrintInventoryReport() {

        $model = new Store();
        $type = $_POST['type'];
        $part_number = $_POST['part_number'];
        $generic_name = $_POST['generic_name'];
        $tax_code = $_POST['tax_code'];
        $brand_id = $_POST['brand_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_inventory_list', array('model' => $model, 'type' => $type, 'part_number' => $part_number, 'generic_name' => $generic_name, 'tax_code' => $tax_code, 'title' => $title, 'brand_id' => $brand_id), false, true);
    }
	
	
    public function actionPrintDailyEntry() {

        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id=Yii::app()->request->getParam("customer_name");
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_dailyentry', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'customer_id' =>$customer_id), false, true);
        
    }
    public function actionPrintDailyExit() {

        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id=Yii::app()->request->getParam("customer_name");
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_dailyexit', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'customer_id' =>$customer_id), false, true);
        
    }
    public function actionPrintAuditlog() {

        $type    = $_POST['type'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_auditlog', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'type' =>$type), false, true);
    } 
    public function actionPrintInvoiceReport() {

        $type    = $_POST['type'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $customer_id=Yii::app()->request->getParam("customer_name");
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_invoicereport', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'type' =>$type,'customer_id' =>$customer_id), false, true);
    } 
    public function actionPrintAdminTransactionlist() {

        $type    = $_POST['type'];
        $item    = (int) $_POST['item'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $user    = $_POST['user'];
        $customer_id    = $_POST['customer_name'];
        $shipper    = $_POST['shipper'];
        $payment    = $_POST['payment'];
        $salesman    = $_POST['salesman'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_admin_transactionlist', array('model' => $model, 'user' => $user, 'from_date' => $from_date,'to_date' => $to_date,'type' =>$type,'customer_id' => $customer_id,'shipper' => $shipper,'payment' => $payment, 'salesman' => $salesman, 'item' => $item ), false, true);
    } 
    public function actionPrintClearingTransactionList() {

        $type    = $_POST['type'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $customer_name    = $_POST['customer_name'];
        $shipper    = $_POST['shipper'];
        $payment    = $_POST['payment'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_clearing_transactionList', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'type' =>$type,'customer_name' =>$customer_name,'shipper' =>$shipper,'payment' =>$payment), false, true);
    } 
    public function actionPrintTransactionList() {

        $type    = $_POST['type'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $customer_id    = $_POST['customer_id'];
        $shipper    = $_POST['shipper'];
        $payment    = $_POST['payment'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_transactionList', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'type' =>$type,'customer_id' =>$customer_id,'shipper' =>$shipper,'payment' =>$payment), false, true);
    } 
    public function actionPrintRecieptofPayments() {

        $company    = $_POST['company'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $payment    = $_POST['payment'];
        $realisation_from_date    = $_POST['realisation_from_date'];
        $realisation_to_date    = $_POST['realisation_to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_recieptof_payments', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'company' =>$company,'payment' =>$payment,'realisation_from_date' =>$realisation_from_date,'realisation_to_date' =>$realisation_to_date), false, true);
    } 
	
    public function actionPrintCustomeradvancepayment() {

        $customer_name    = $_POST['customer_name'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_customer_advancepayment', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'customer_name' =>$customer_name), false, true);
    } 
	
	
	 public function actionPrintDaybook() {

        // $customer    = $_POST['customer'];
        // $from_date  = $_POST['from_date'];
        // $to_date    = $_POST['to_date'];
        $date = ( (int) count(explode('/', $_POST['date'])) == 3 ) ? $_POST['date'] : date('d/m/Y');

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_daybook', array('date' => $date), false, true);
    } 

    public function actionPrintfinDayBook() {
        $date_from=$_REQUEST['from_date'];
        $date_to=$_REQUEST['to_date'];
        $date_from = str_replace('/', '-',$date_from);
        $date_from = date("Y-m-d", strtotime($date_from));
        $date_to = str_replace('/', '-',$date_to);
        $date_to = date("Y-m-d", strtotime($date_to));
        ini_set("memory_limit", -1);
        ini_set('max_execution_time', 1000);
        // $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.daybook_new", array('date_from'=>$date_from,'date_to'=>$date_to), true));
        $mPDF1->Output('Day Book.pdf', 'I');
    }

    public function actionPrintGLReport() {
        $account_no=$_REQUEST['ledger_id'];
        $company_id=$_REQUEST['subledger_id'];
        $rp_from_date=$_REQUEST['from_date'];
        $rp_to_date=$_REQUEST['to_date'];
        $rp_from_date = str_replace('/', '-', $rp_from_date);
        $rp_from_date = date("Y-m-d", strtotime($rp_from_date));
        $rp_to_date = str_replace('/', '-', $rp_to_date);
        $rp_to_date = date("Y-m-d", strtotime($rp_to_date));
        $item_type=$_REQUEST['item_type'];
        $item_id=$_REQUEST['item_id'];
        ini_set("memory_limit", "-1");
//        ini_set('max_execution_time', 1000);
        

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetTitle('GL Transaction Report');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_generalledger.css');
 
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.generalledger", array('account_no'=>$account_no,'company_id'=>$company_id,'date_from'=>$rp_from_date,'date_to'=>$rp_to_date,'item_id'=>$item_id,'item_type'=>$item_type,'title'=>'GL Transaction Report'), true));
        $mPDF1->Output('GL Report.pdf', 'I');
    }
    public function actionPrintGLReportcash() {
        $account_no=$_REQUEST['ledger_id'];
        $company_id='';
        $rp_from_date=$_REQUEST['from_date'];
        $rp_to_date=$_REQUEST['to_date'];
        $rp_from_date = str_replace('/', '-', $rp_from_date);
        $rp_from_date = date("Y-m-d", strtotime($rp_from_date));
        $rp_to_date = str_replace('/', '-', $rp_to_date);
        $rp_to_date = date("Y-m-d", strtotime($rp_to_date));
        $item_type=$_REQUEST['item_type'];
        $item_id=$_REQUEST['item_id'];
        ini_set("memory_limit", "-1");
//        ini_set('max_execution_time', 1000);
        

        // $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        $mPDF1->SetTitle('GL Transaction Report');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_generalledger.css');
 
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.generalledger_cash", array('account_no'=>$account_no,'company_id'=>$company_id,'date_from'=>$rp_from_date,'date_to'=>$rp_to_date,'item_id'=>$item_id,'item_type'=>$item_type,'title'=>'GL Transaction Report'), true));
        $mPDF1->Output('GL Report.pdf', 'I');
    }
    public function actionPrintGLStatementReport() {
        $date = str_replace('/', '-', $_REQUEST['from_date']);
        $searchstartdate = date("Y-m-d", strtotime($date));
        // $searchstartdate='2015-01-01';
        $date1 = str_replace('/', '-', $_REQUEST['to_date']);
        $searchenddate = date("Y-m-d", strtotime($date1));
        $company_id = $_REQUEST['subledger_id'];
        $account_id=$_REQUEST['ledger_id'];
        if($searchstartdate==null)
        {
         $searchstartdate=date('Y').'-01-01';
        }
        if($searchenddate==null)
        {
         $searchenddate=date('Y').'-12-31';
        }
         if (!empty($company_id) && !empty($searchstartdate) && !empty($searchenddate) && !empty($account_id))
        {
        $rp_to_date=$_POST['rp_to_date'];
ini_set("memory_limit", "-1");
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetTitle('Statement of Account');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.statement_of_account", array('subledger'=>$company_id,'date_to'=>$searchenddate,'date_from'=>$searchstartdate,'account'=>$account_id), true));
        $mPDF1->Output('Statement.pdf', 'I');
        }
        else {
        echo "Please Select Account";
        }
    }
    public function actionPrintGLSummaryReport() {
        $account_no=$_REQUEST['ledger_id'];
       if($account_no=='value'){
           $account_no="";
       }
       if($account_no!='')
       {
       $rp_to_date=$_REQUEST['to_date'];
       $rp_to_date = str_replace('/', '-', $rp_to_date);
       $rp_to_date = date("Y-m-d", strtotime($rp_to_date));
       ini_set("memory_limit", -1);
       ini_set('max_execution_time', 1000);
       $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
       $mPDF1->SetTitle('Ledger Summary');
       $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
       $mPDF1->showWatermarkImage = true;
       $mPDF1->watermarkImageAlpha = 0.09;
       $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
       $mPDF1->WriteHTML($stylesheet, 1);

       $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.generalledger_summary", array('account_no'=>$account_no,'date_to'=>$rp_to_date), true));
       $mPDF1->Output('GL Summary.pdf', 'I');
       }
       else {
       echo "Please Select Account";
       }
       }   

       public function actionPrintTrialBalance() {
        $date_from=$_REQUEST['to_date'];
        $date_from = str_replace('/', '-',$date_from);
        $date_from = date("Y-m-d", strtotime($date_from));
        ini_set("memory_limit", "256M");
      //  ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetTitle('Trial Balance');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.trial_bal", array('date_from'=>$date_from), true));
        $mPDF1->Output('Trial Balance.pdf', 'I');
    }

    public function actionPrintAgeingReport() {
        $date1 = str_replace('/', '-', $_REQUEST['to_date']);
        $searchenddate = date("Y-m-d", strtotime($date1));
        $company_id = (int)$_REQUEST['subledger_id'];
        $account_id=$_REQUEST['ledger_id'];
        if($searchenddate==null)
        {
         $searchenddate=date('Y-m-d');
        }
        if (!empty($searchenddate) && !empty($account_id))
       {
         if(!empty($company_id))
         {
            $opening_bal=FinOpeningBalance::model()->find(array('condition'=>'account_id='.$company_id.' AND mainacc='.$account_id));     
            $trs = array();
            $tds = array();
            $total_amt = 0;
            $total_pend = 0;
            $total_columns = 11;
            $pend1=0;
            $pend2=0;
            $pend3=0;
            $pend4=0;
            $pend5=0;
            $pend6=0;
            $pend7=0;
            $tot_pend=0;
            $trs[] = '<tr>
                        <th width="15%" class="bgblack">Ledger Name</th>
                        <th width="10%"> 0-30 Days</th>
                        <th width="10%"> 31-60 Days</th>
                        <th width="10%"> 61-90 Days</th>
                        <th width="10%"> 91-120 Days</th>
                        <th width="10%"> 121-150 Days</th>
                        <th width="10%"> 151-180 Days</th>
                        <th width="10%"> >180 Days</th>
                        <th width="10%">Total</th>
                    </tr>';
   
        $no_days_30=date('Y-m-d', strtotime($searchenddate . ' -30 day'));
        $no_days_60=date('Y-m-d', strtotime($searchenddate . ' -60 day'));
        $no_days_90=date('Y-m-d', strtotime($searchenddate . ' -90 day'));
        $no_days_120=date('Y-m-d', strtotime($searchenddate . ' -120 day'));
        $no_days_150=date('Y-m-d', strtotime($searchenddate . ' -150 day'));
        $no_days_180=date('Y-m-d', strtotime($searchenddate . ' -180 day'));  
        Yii::app()->db->createCommand("TRUNCATE TABLE ageing")->execute();
        $SQL11="INSERT INTO ageing (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT id,subledger,date,voucher_no,debit,credit,debit as db,credit as cr from crm_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";
        Yii::app()->db->createCommand($SQL11)->execute();
        Yii::app()->db->createCommand("CREATE OR REPLACE VIEW ss AS select * from ageing group by invoice_id order by db DESC,cr DESC")->execute();
        $SQL1="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_30' AND subledger like '$company_id'"; 
        $arr_sum_amount1  = Yii::app()->db->createCommand($SQL1)->queryAll();
        $SQL2="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_60' AND date < '$no_days_30' AND subledger=$company_id"; 
        $arr_sum_amount2  = Yii::app()->db->createCommand($SQL2)->queryAll();
        $SQL3="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_90' AND date < '$no_days_60' AND subledger=$company_id"; 
        $arr_sum_amount3  = Yii::app()->db->createCommand($SQL3)->queryAll();
        $SQL4="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_120' AND date < '$no_days_90' AND subledger=$company_id";
        $arr_sum_amount4  = Yii::app()->db->createCommand($SQL4)->queryAll();
        $SQL5="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_150' AND date < '$no_days_120' AND subledger=$company_id"; 
        $arr_sum_amount5  = Yii::app()->db->createCommand($SQL5)->queryAll();
        $SQL6="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_180' AND date < '$no_days_150' AND subledger=$company_id"; 
        $arr_sum_amount6  = Yii::app()->db->createCommand($SQL6)->queryAll();
        $SQL7="select subledger,sum(db)-sum(cr) as amt from ss where date < '$no_days_180' AND subledger=$company_id"; 
        $arr_sum_amount7  = Yii::app()->db->createCommand($SQL7)->queryAll();
        $total_inv_amnt = 0;
        $total_pend_amnt = 0;
        $tot=0;
        $due1=0;
        $due2=0;
        $due3=0;
        $due4=0;
        $due5=0;
        $due6=0;
        $due7=0;
        foreach ($arr_sum_amount1 as $eachInvoice1)
        {
        $due1+=$eachInvoice1['amt'];    
        }
        foreach ($arr_sum_amount2 as $eachInvoice2)
        {
        $due2=$eachInvoice2['amt'];    
        }
        foreach ($arr_sum_amount3 as $eachInvoice3)
        {
        $due3=$eachInvoice3['amt'];    
        }
        foreach ($arr_sum_amount4 as $eachInvoice4)
        {
        $due4=$eachInvoice4['amt'];    
        }
        foreach ($arr_sum_amount5 as $eachInvoice5)
        {
        $due5=$eachInvoice5['amt'];    
        }
        foreach ($arr_sum_amount6 as $eachInvoice6)
        {
        $due6=$eachInvoice6['amt'];    
        }
        foreach ($arr_sum_amount7 as $eachInvoice7)
        {
        if($opening_bal->type==1)
        {
        $amt7=$opening_bal->statement_op+$eachInvoice7['amt'];  
        $due7+=$opening_bal->statement_op+$eachInvoice7['amt']; 
        }
        else if($opening_bal->type==2){
        $amt7=$eachInvoice7['amt']-$opening_bal->statement_op;  
        $due7+=$eachInvoice7['amt']-$opening_bal->statement_op;
        }
        else {
        $amt7=$eachInvoice7['amt'];  
        $due7+=$eachInvoice7['amt'];          
        }   
        }
        $pend1+=$due1;
        $pend2+=$due2;
        $pend3+=$due3;
        $pend4+=$due4;
        $pend5+=$due5;
        $pend6+=$due6;
        $pend7+=$due7;
        $pnd=$due1+$due2+$due3+$due4+$due5+$due6+$due7;
        if($pnd!=0){
            $company=Subledger::model()->findByPk($company_id);
         $tds = '<td class="cell-left"><b>' . $company->description . '</b></td>';
            if($due1<0)
            {
            $due1=Yii::app()->numberFormatter->formatCurrency(abs($due1), "").' Cr';    
            }
            else {
            $due1=Yii::app()->numberFormatter->formatCurrency($due1, "").' Dr';    
            }
            if($due2<0)
            {
            $due2=Yii::app()->numberFormatter->formatCurrency(abs($due2), "").' Cr';    
            }
            else {
            $due2=Yii::app()->numberFormatter->formatCurrency($due2, "").' Dr';    
            }
            if($due3<0)
            {
            $due3=Yii::app()->numberFormatter->formatCurrency(abs($due3), "").' Cr';    
            }
            else {
            $due3=Yii::app()->numberFormatter->formatCurrency($due3, "").' Dr';    
            }
            if($due4<0)
            {
            $due4=Yii::app()->numberFormatter->formatCurrency(abs($due4), "").' Cr';    
            }
            else {
            $due4=Yii::app()->numberFormatter->formatCurrency($due4, "").' Dr';    
            }
            if($due5<0)
            {
            $due5=Yii::app()->numberFormatter->formatCurrency(abs($due5), "").' Cr';    
            }
            else {
            $due5=Yii::app()->numberFormatter->formatCurrency($due5, "").' Dr';    
            }
            if($due6<0)
            {
            $due6=Yii::app()->numberFormatter->formatCurrency(abs($due6), "").' Cr';    
            }
            else {
            $due6=Yii::app()->numberFormatter->formatCurrency($due6, "").' Dr';    
            }
            if($due7<0)
            {
            $due7=Yii::app()->numberFormatter->formatCurrency(abs($due7), "").' Cr';    
            }
            else {
            $due7=Yii::app()->numberFormatter->formatCurrency($due7, "").' Dr';    
            }
            if($pnd<0)
            {
            $pnd=Yii::app()->numberFormatter->formatCurrency(abs($pnd), "").' Cr';    
            }
            else {
            $pnd=Yii::app()->numberFormatter->formatCurrency($pnd, "").' Dr';    
            }
            $tds.='<td class="cell-right">' .$due1  . '</td>';
            $tds.='<td class="cell-right">' .  $due2  . '</td>';
            $tds.='<td class="cell-right">' . $due3. '</td>';
            $tds.='<td class="cell-right">' .$due4. '</td>';
            $tds.='<td class="cell-right">' .$due5. '</td>';
             $tds.='<td class="cell-right">' .$due6. '</td>';
             $tds.='<td class="cell-right">' .$due7 . '</td>';
            $tds.='<td class="cell-right litegray">' .$pnd. '</td>';
            $trs[] = '<tr>' . $tds . '</tr>';
            $total_amt+=$total_inv_amnt;
            $total_pend+=$total_pend_amnt;
            $tot_pend+=$pnd;
}

        $html_prepared = implode(' ', $trs);
         $html_prepared.='<tr><td><b>Grand Total</b></td><td class="cell-right"><b>'.$due1.'</b></td><td class="cell-right"><b>'.$due2.'</b></td><td class="cell-right"><b>'.$due3.'</b></td><td class="cell-right"><b>'.$due4.'</b></td><td class="cell-right"><b>'.$due5.'</b></td><td class="cell-right"><b>'.$due6.'</b></td><td class="cell-right"><b>'.$due7.'</b></td><td class="cell-right"><b>'.$pnd.'</b></td></tr>';
         $page_type="L";
         $this->report('', 'ageing-list', 'pdf_for_single', $html_prepared, 'LEDGER AGEING REPORT',$page_type);
    }
    else {
        $SQL="(SELECT sub.id,sub.description as description,sub.id as account_no FROM `crm_fin_general_ledger` as ledger left join crm_fin_subledger as sub on ledger.subledger=sub.id WHERE account_id=$account_id group by account_id,subledger order by sub.description) "
        . " order by description"; 
//            echo $SQL;die;
        $company  = Yii::app()->db->createCommand($SQL)->queryAll();


     $trs = array();
        $tds = array();
        $total_amt = 0;
        $total_pend = 0;
        $total_columns = 11;
        $pend1=0;
        $pend2=0;
        $pend3=0;
        $pend4=0;
        $pend5=0;
        $pend6=0;
        $pend7=0;
        $tot_pend=0;
        $no_days_30=date('Y-m-d', strtotime($searchenddate . ' -30 day'));
        $no_days_60=date('Y-m-d', strtotime($no_days_30 . ' -30 day'));
        $no_days_90=date('Y-m-d', strtotime($no_days_60 . ' -30 day'));
        $no_days_120=date('Y-m-d', strtotime($no_days_90 . ' -30 day'));
        $no_days_150=date('Y-m-d', strtotime($no_days_120 . ' -30 day'));
        $no_days_180=date('Y-m-d', strtotime($no_days_150 . ' -30 day')); 
$trs[] = '<tr>
                        <th width="15%" class="bgblack" >Customer Name</th>
                        <th width="10%" class="cell-right bgblack"> 0-30 Days</th>
                        <th width="10%" class="cell-right bgblack"> 31-60 Days</th>
                        <th width="10%" class="cell-right bgblack"> 61-90 Days</th>
                        <th width="10%" class="cell-right bgblack"> 91-120 Days</th>
                        <th width="10%" class="cell-right bgblack"> >120 Days</th>
                        <th width="10%" class="cell-right bgblack">Total</th>
                    </tr>';

//$SQL10="DROP VIEW IF EXISTS q1, q2,q3,q4,q5,q6,q7"; 
//Yii::app()->db->createCommand($SQL10)->execute();
Yii::app()->db->createCommand("TRUNCATE TABLE ageing")->execute();
//$SQL11="CREATE OR REPLACE VIEW q1 AS (SELECT A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT subledger,date,voucher_no,debit,credit,debit as db,credit as cr from crm_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";
$SQL11="INSERT INTO ageing (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT id,subledger,date,voucher_no,debit,credit,debit as db,credit as cr from crm_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";
//echo $SQL11;die;
Yii::app()->db->createCommand($SQL11)->execute();
//$SQL100="select subledger,sum(db)-sum(cr) as amt from q1 group by subledger";
//$arr_sum_amount100  = Yii::app()->db->createCommand($SQL100)->queryAll();
//print_r($arr_sum_amount100);die;
Yii::app()->db->createCommand("CREATE OR REPLACE VIEW ss AS select * from ageing group by invoice_id order by db DESC,cr DESC")->execute();
$SQL1="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_30' group by subledger"; 
$arr_sum_amount1  = Yii::app()->db->createCommand($SQL1)->queryAll();
$SQL2="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_60' AND date < '$no_days_30' group by subledger"; 
$arr_sum_amount2  = Yii::app()->db->createCommand($SQL2)->queryAll();
$SQL3="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_90' AND date < '$no_days_60' group by subledger"; 
$arr_sum_amount3  = Yii::app()->db->createCommand($SQL3)->queryAll();
$SQL4="select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_120' AND date < '$no_days_90' group by subledger";
$arr_sum_amount4  = Yii::app()->db->createCommand($SQL4)->queryAll();
//$SQL5="select subledger,sum(db)-sum(cr) as amt from q1 where date >= '$no_days_150' AND date < '$no_days_120' group by subledger"; 
//$arr_sum_amount5  = Yii::app()->db->createCommand($SQL5)->queryAll();
//$SQL6="select subledger,sum(db)-sum(cr) as amt from q1 where date >= '$no_days_180' AND date < '$no_days_150' group by subledger"; 
//$arr_sum_amount6  = Yii::app()->db->createCommand($SQL6)->queryAll();
$SQL7="select subledger,sum(db)-sum(cr) as amt from ss where date < '$no_days_120' group by subledger"; 
$arr_sum_amount7  = Yii::app()->db->createCommand($SQL7)->queryAll();
        $tot=0;
        $due1=0;
        $due2=0;
        $due3=0;
        $due4=0;
        $due5=0;
        $due6=0;
        $due7=0;

        $pnd=0;
foreach($company as $rowCompany)
{
 $amt=0;
 $amt1=0;
 $amt2=0;
 $amt3=0;
 $amt4=0;
 $amt5=0;
 $amt6=0;
 $amt7=0;
 $amt8=0;
 if($rowCompany['account_no']!='')
 {
 $opening_bal=FinOpeningBalance::model()->find(array('condition'=>'company_id='.$rowCompany['account_no'].' AND mainacc='.$account_id)); 
 }
 else {
 $opening_bal->type=0;
 $opening_bal->statement_op=0;
 }
 
$tds = '<td class="cell-left"><b>'. $rowCompany['description'].'('.$rowCompany['account_no'].')'. '</b></td>';
foreach ($arr_sum_amount1 as $eachInvoice1)
        {
  $amt8=$opening_bal->statement_op;
 if($rowCompany['id']==$eachInvoice1['subledger'])
 { 
     $amt1=$eachInvoice1['amt'];   
        $due1+=$eachInvoice1['amt'];    
        $amt8=$opening_bal->statement_op;  
 }
        }
        if($amt1<0)
        {
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency(abs($amt1), "")  . ' Cr</td>';    
        }
        else{
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency($amt1, "")  . ' Dr</td>';
        }
        foreach ($arr_sum_amount2 as $eachInvoice2)
        {
             if($rowCompany['id']==$eachInvoice2['subledger'])
 {
       $amt2=$eachInvoice2['amt'];
        $due2+=$eachInvoice2['amt']; 
        $amt8=$opening_bal->statement_op;  
        }
        }
        if($amt2<0)
        {
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency(abs($amt2), "")  . ' Cr</td>';
        }
        else {
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency($amt2, "")  . ' Dr</td>';    
        }
        foreach ($arr_sum_amount3 as $eachInvoice3)
        {
             if($rowCompany['id']==$eachInvoice3['subledger'])
 {
        $amt3=$eachInvoice3['amt'];  
        $due3+=$eachInvoice3['amt']; 
        $amt8=$opening_bal->statement_op;  
        }
        }
        if($amt3<0)
        {
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency(abs($amt3), "")  . ' Cr</td>';
        }
        else {
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency($amt3, "")  . ' Dr</td>';
        }
        foreach ($arr_sum_amount4 as $eachInvoice4)
        {
        if($rowCompany['id']==$eachInvoice4['subledger'])
        {
        $amt4=$eachInvoice4['amt'];  
        $due4+=$eachInvoice4['amt'];   
        $amt8=$opening_bal->statement_op;  
        }
        }
        if($amt4<0)
        {
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency(abs($amt4), "")  . ' Cr</td>';
        }
        else
        {
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency($amt4, "")  . ' Dr</td>';    
        }
        foreach ($arr_sum_amount7 as $eachInvoice7)
        {
        
        if($rowCompany['id']==$eachInvoice7['subledger'])
        {
        $amt7=$eachInvoice7['amt'];  
        $due7+=$eachInvoice7['amt'];
        $amt8=$opening_bal->statement_op;  
       
        }
        
        }
         if($opening_bal->type==1)
        {
             $amt7=$amt7+$amt8; 
                    $due7+=$amt8; 
        }
        else if($opening_bal->type==2){
        
        $amt7=$amt7-$amt8;  
        $due7=$due7-$amt8;
        }
        if($amt7<0)
        {
        $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency(abs($amt7), "")  . ' Cr</td>';
        }
        else
        {
         $tds.='<td class="cell-right">' .   Yii::app()->numberFormatter->formatCurrency($amt7, "")  . ' Dr</td>';   
        }
        $amt=$amt1+$amt2+$amt3+$amt4+$amt5+$amt6+$amt7;
        if($amt<0)
        {
        $tds.='<td class="cell-right"><b>' .   Yii::app()->numberFormatter->formatCurrency(abs($amt), "")  . ' Cr</b></td>';
        }
        else 
        {
        $tds.='<td class="cell-right"><b>' .   Yii::app()->numberFormatter->formatCurrency($amt, "")  . ' Dr</b></td>';    
        }
        if($amt!=0)
        {
        $pnd+=$amt;
        $trs[] = '<tr>' . $tds . '</tr>';
        }
}

        $pend1+=$due1;
        $pend2+=$due2;
        $pend3+=$due3;
        $pend4+=$due4;
//            $pend5+=$due5;
//            $pend6+=$due6;
        $pend7+=$due7;

    if($pend1<0)
    {
    $pend1= Yii::app()->numberFormatter->formatCurrency(abs($pend1), "").' Cr';   
    }
    else {
    $pend1= Yii::app()->numberFormatter->formatCurrency($pend1, "").' Dr';    
    }
    if($pend2<0)
    {
    $pend2= Yii::app()->numberFormatter->formatCurrency(abs($pend2), "").' Cr';   
    }
    else {
    $pend2= Yii::app()->numberFormatter->formatCurrency($pend2, "").' Dr';    
    }
    if($pend3<0)
    {
    $pend3= Yii::app()->numberFormatter->formatCurrency(abs($pend3), "").' Cr';   
    }
    else {
    $pend3= Yii::app()->numberFormatter->formatCurrency($pend3, "").' Dr';    
    }
    if($pend4<0)
    {
    $pend4= Yii::app()->numberFormatter->formatCurrency(abs($pend4), "").' Cr';   
    }
    else {
    $pend4= Yii::app()->numberFormatter->formatCurrency($pend4, "").' Dr';    
    }
    if($pend7<0)
    {
    $pend7= Yii::app()->numberFormatter->formatCurrency(abs($pend7), "").' Cr';   
    }
    else {
    $pend7= Yii::app()->numberFormatter->formatCurrency($pend7, "").' Dr';    
    }
    if($pnd<0)
    {
    $pnd= Yii::app()->numberFormatter->formatCurrency(abs($pnd), "").' Cr';   
    }
    else {
    $pnd= Yii::app()->numberFormatter->formatCurrency($pnd, "").' Dr';    
    }
        $html_prepared = implode(' ', $trs);
         $html_prepared.='<tr><th class="bgblack"><b>Grand Total</b></th><th class="cell-right br-top"><b>'.$pend1.'</b></th><th class="cell-right br-top bgblack"><b>'.$pend2.'</b></th><th class="cell-right br-top bgblack"><b>'.$pend3.'</b></th><th class="cell-right br-top bgblack"><b>'.$pend4.'</b></th><th class="cell-right br-top bgblack"><b>'.$pend7.'</b></th><th class="cell-right br-top bgblack"><b>'.$pnd.'</b></th></tr>';
         ini_set("memory_limit", "-1");
          $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
   // $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
    //$mPDF1->showWatermarkImage = true;
   // $mPDF1->watermarkImageAlpha = 0.09;
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_generalledger.css');
    $mPDF1->AddPage('L');
    $mPDF1->WriteHTML($stylesheet, 1);
    $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.ageing", array('content'=>$html_prepared,'date_to'=> $searchenddate,'account_no'=>$account_id), true));
    $mPDF1->Output('Ageing Report.pdf', 'I');
    
//        $this->report('', 'ledger-all', 'pdf_for_single', $html_prepared, 'Ageing Report');
//             $this->layout = 'pdf';
//    		$this->render('//pdf/ageing_report_html', array('date_to'=>$searchenddate,'account'=>$account_id,'content'=>$html_prepared), false, true);
    }
    }
    else {
    echo "Please Select Account";
    }   
}
public function report($model, $htmlTemplate, $css, $html_prepared = null, $title = null) {
    ini_set("memory_limit", "128G");
    ini_set('max_execution_time', 1000);
    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/' . $css . '.css');
    $mPDF1->WriteHTML($stylesheet, 1);
    //print_r($this->renderPartial('application.views.front.pdf.reports.' . $htmlTemplate, array('model' => $model, 'product_items' => $html_prepared, 'title' => $title),true));
    $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $htmlTemplate, array('model' => $model, 'product_items' => $html_prepared, 'title' => $title), true));
    $mPDF1->Output($htmlTemplate, 'I');
}
public function actionBalanceSheetViewPdf()
            {
//            $date_from=$_POST['rp_from_date'];
            $date_to = Yii::app()->request->getParam('to_date');
          //  $date_to=['to_date'];
ini_set("memory_limit", "256M");
      //  ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.balance_sheet", array('date_to'=>date('Y-m-d', strtotime(str_replace('/','-', $date_to )) )), true));
        $mPDF1->Output('Balance Sheet.pdf', 'I'); 
    }
    public function actionPrintProfitLoss()
            {
            $date_from=$_REQUEST['from_date'];
            $date_to=$_REQUEST['to_date'];
            $date_from = str_replace('/', '-',$date_from);
            $date_from = date("Y-m-d", strtotime($date_from));
            $date_to = str_replace('/', '-',$date_to);
            $date_to = date("Y-m-d", strtotime($date_to));
            ini_set("memory_limit", "256M");
      //  ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.profit_loss", array('date_from'=>$date_from,'date_to'=>$date_to), true));
        $mPDF1->Output('profit&loss.pdf', 'I'); 
    }
    public function actionPrintVatFinalSummary() {
        $date_from=$_REQUEST['from_date'];
      $date_to=$_REQUEST['to_date'];
      $date_from = str_replace('/', '-',$date_from);
      $date_from = date("Y-m-d", strtotime($date_from));
      $date_to = str_replace('/', '-',$date_to);
      $date_to = date("Y-m-d", strtotime($date_to));
      ini_set("memory_limit", -1);
      ini_set('max_execution_time', 1000);
      $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
      $mPDF1->SetTitle('VAT Summary');
      $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
      $mPDF1->showWatermarkImage = true;
      $mPDF1->watermarkImageAlpha = 0.09;
      $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
      $mPDF1->WriteHTML($stylesheet, 1);
      $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.vat_final_summary", array('date_from'=>$date_from,'date_to'=>$date_to), true));
      $mPDF1->Output('VATSUMMARY.pdf', 'I');
   }

   public function actionPrintVatSummary() {
    $date_from=$_REQUEST['from_date'];
    $date_to=$_REQUEST['to_date'];
    $date_from = str_replace('/', '-',$date_from);
    $date_from = date("Y-m-d", strtotime($date_from));
    $date_to = str_replace('/', '-',$date_to);
    $date_to = date("Y-m-d", strtotime($date_to));
    ini_set("memory_limit", -1);
    ini_set('max_execution_time', 1000);
    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
    $mPDF1->SetTitle('VAT Summary');
    $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
    $mPDF1->showWatermarkImage = true;
    $mPDF1->watermarkImageAlpha = 0.09;
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
    $mPDF1->WriteHTML($stylesheet, 1);
    $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.vat_summary", array('date_from'=>$date_from,'date_to'=>$date_to), true));
    $mPDF1->Output('VAT.pdf', 'I');
}
public function actionPrintAdminTransactionListPDF() {
    $date_from=$_REQUEST['from_date'];
    $date_to=$_REQUEST['to_date'];
    $date_from = str_replace('/', '-',$date_from);
    $from_date = date("Y-m-d", strtotime($date_from));
    $date_to = str_replace('/', '-',$date_to);
    $to_date = date("Y-m-d", strtotime($date_to));
    $customer_id = Yii::app()->request->getParam("customer_id");
    $shipper_id = Yii::app()->request->getParam("shipper_id");
    $user = Yii::app()->request->getParam("user");
    $type = Yii::app()->request->getParam("type");
    $payment = Yii::app()->request->getParam("payment");
    $salesman = Yii::app()->request->getParam("salesman");
    $item = Yii::app()->request->getParam("item");
        
    ini_set("memory_limit", -1);
    ini_set('max_execution_time', 1000);
    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
    $mPDF1->SetTitle('AdminTransactionList');
    $mPDF1->SetWatermarkImage('images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
    $mPDF1->showWatermarkImage = true;
    $mPDF1->watermarkImageAlpha = 0.09;
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
    $mPDF1->WriteHTML($stylesheet, 1);
    $mPDF1->WriteHTML($this->renderPartial("application.views.front.reports.pdf.admin_transaction_list", array('customer_id'=>$customer_id,'from_date' =>$from_date,'to_date' =>$to_date,'user' =>$user,'salesman' =>$salesman,'item' =>$item,'payment' =>$payment,'type' =>$type,'shipper_id' =>$shipper_id), true));
    $mPDF1->Output('AdminTransactionList.pdf', 'I');
}
    public function actionPrintSecurityDeposit() {

        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $status     = $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_security_deposit', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'status'=>$status), false, true);
    } 
    public function actionPrintRefundList() {

        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $status     = $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_refund_list', array('model' => $model, 'from_date' => $from_date,'to_date' => $to_date,'status'=>$status), false, true);
    } 
    public function actionPrintEntryAdminTransactionListPDF() {
        $date_from=$_REQUEST['from_date'];
        $date_to=$_REQUEST['to_date'];
        $date_from = str_replace('/', '-',$date_from);
        $from_date = date("Y-m-d", strtotime($date_from));
        $date_to = str_replace('/', '-',$date_to);
        $to_date = date("Y-m-d", strtotime($date_to));
        $customer_id = Yii::app()->request->getParam("customer_id");
        $shipper_id = Yii::app()->request->getParam("shipper_id");
        $user = Yii::app()->request->getParam("user");
        $type = Yii::app()->request->getParam("type");
        $payment = Yii::app()->request->getParam("payment");
        $salesman = Yii::app()->request->getParam("salesman");
        $item = Yii::app()->request->getParam("item");
            
        ini_set("memory_limit", -1);
        ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        $mPDF1->SetTitle('AdminTransactionList');
        $mPDF1->SetWatermarkImage('images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.reports.pdf.admin_transaction_list_entry", array('customer_id'=>$customer_id,'from_date' =>$from_date,'to_date' =>$to_date,'user' =>$user,'salesman' =>$salesman,'item' =>$item,'payment' =>$payment,'type' =>$type,'shipper_id' =>$shipper_id), true));
        $mPDF1->Output('AdminTransactionList.pdf', 'I');
    }
    
     public function actionPrintEntryAdminTransactionList() {

        $item    = (int) $_POST['item'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $user    = $_POST['user'];
        $customer_id    = $_POST['customer_name'];
        $shipper    = $_POST['shipper'];
        $payment    = $_POST['payment'];
        $salesman    = $_POST['salesman'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_entry_admin_transactionlist', array('model' => $model, 'user' => $user, 'from_date' => $from_date,'to_date' => $to_date,'type' =>$type,'customer_id' => $customer_id,'shipper' => $shipper,'payment' => $payment, 'salesman' => $salesman, 'item' => $item ), false, true);
    } 
    
     public function actionPrintExitAdminTransactionList() {

        $item    = (int) $_POST['item'];
        $from_date  = $_POST['from_date'];
        $to_date    = $_POST['to_date'];
        $user    = $_POST['user'];
        $customer_id    = $_POST['customer_name'];
        $shipper    = $_POST['shipper'];
        $payment    = $_POST['payment'];
        $salesman    = $_POST['salesman'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_exit_admin_transactionlist', array('model' => $model, 'user' => $user, 'from_date' => $from_date,'to_date' => $to_date,'type' =>$type,'customer_id' => $customer_id,'shipper' => $shipper,'payment' => $payment, 'salesman' => $salesman, 'item' => $item ), false, true);
    } 
    
    public function actionPrintExitAdminTransactionListPDF() {
        $date_from=$_REQUEST['from_date'];
        $date_to=$_REQUEST['to_date'];
        $date_from = str_replace('/', '-',$date_from);
        $from_date = date("Y-m-d", strtotime($date_from));
        $date_to = str_replace('/', '-',$date_to);
        $to_date = date("Y-m-d", strtotime($date_to));
        $customer_id = Yii::app()->request->getParam("customer_id");
        $shipper_id = Yii::app()->request->getParam("shipper_id");
        $user = Yii::app()->request->getParam("user");
        $type = Yii::app()->request->getParam("type");
        $payment = Yii::app()->request->getParam("payment");
        $salesman = Yii::app()->request->getParam("salesman");
        $item = Yii::app()->request->getParam("item");
            
        ini_set("memory_limit", -1);
        ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        $mPDF1->SetTitle('AdminTransactionList');
        $mPDF1->SetWatermarkImage('images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.reports.pdf.admin_transaction_list_exit", array('customer_id'=>$customer_id,'from_date' =>$from_date,'to_date' =>$to_date,'user' =>$user,'salesman' =>$salesman,'item' =>$item,'payment' =>$payment,'type' =>$type,'shipper_id' =>$shipper_id), true));
        $mPDF1->Output('AdminTransactionList.pdf', 'I');
    }
}
