<?php

class PostingController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('InvoiceAllocation','SearchInvoiceAllocation','SaveInvoiceUnAllocateForm','SaveInvoiceAllocateForm','Pdc','ChangeChequeStatus','PdcSent',
                    'ChangeChequeStatusReceived','Searchpdc','changePurchaseaccount','saveInvoicemappings'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
     public function actionInvoiceAllocation() {
        $model = new FinGeneralLedger;
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//posting/_invoice_allocation', array('model' => $model), false, true);
    }
     public function actionSearchInvoiceAllocation()
    {
   
        if($_POST['from_voucher_date']!='00/00/0000')
        {
            $from = str_replace('/', '-', $_POST['from_voucher_date']);
            $from=date("Y-m-d", strtotime($from));
        }
        else {
            $from=date('Y').'-01-01';
        }
        if($_POST['to_voucher_date']!='')
        {
            $to = str_replace('/', '-', $_POST['to_voucher_date']);
            $to=date("Y-m-d", strtotime($to));
        }
        else {
            $to=date('Y').'-12-31';
        }
      
        switch($_POST['voucher_type'])
        {
            case 1:
                $voucher="EN";
                break;
            case 2:
                $voucher="EX";
                break;
        }
      
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('/posting/_invoice_voucher_display', array('from'=>$from,'to'=>$to,'voucher'=>$voucher,'alloc_type'=>$_POST['allocate_type']), false, true);
    
    }

    public function actionSaveInvoiceUnAllocateForm()
    {
          if(is_array($_POST['ids'])){
              
              /*Voucher Type*/
              
               $voucher = $_POST['voucher'];
               foreach ($_POST['ids'] as $i => $each){
                   
                    /**
                    * Deleting Invoice from Finance Module
                    */
                    
                    FinGeneralLedgerHead::model()->deleteAll(array('condition'=>'voucher_no='.$each.' AND voucher_type="'.$voucher.'"'));
                    FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="'.$voucher.'/'.$each.'"'));
                    
                    /**
                     * Updating invoice status
                     */
                    
                    if( $voucher=='EN' ){
                        $model = EntryInvoice::model()->findByPk($each);
                    } else {
                        $model = ExitInvoice::model()->findByPk($each);
                    }

                    $model->posted = "N";
                    $model->save(false);
               }
          }
          Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
          $this->renderPartial('/posting/_invoice_voucher_display', array('from'=>$_POST['from_alloc_date'],'to'=>$_POST['to_alloc_date'],'voucher'=>$_POST['voucher']), false, true);
    }

    public function actionSaveInvoiceAllocateForm()
    {
        
        if(is_array($_POST['ids'])){
            $voucher = $_POST['voucher'];
            /**
             * Author Jo~
             * Invoice Import
             * Common Insert Function
             */
            function addLedger($form_ref_no,$date,$account_id,$subledger,$voucher_no,$narration,$debit = 0,$credit=0){
                $Ledger = new FinGeneralLedger;
                $Ledger->date = $date;
                $Ledger->form_ref_no = $form_ref_no;
                $Ledger->account_id = $account_id; /*Sundry Debtors*/
                if($subledger > 0){
                    $sub = Subledger::model()->find(array('condition' => 'respect_id='.$subledger)); 
                    if(!empty($sub))
                        $Ledger->subledger = $sub->id; /*Customer|Vendor*/
                }
                $Ledger->voucher_no = $voucher_no;
                $Ledger->item_description = $narration;
                $Ledger->narration =  $narration;
                $Ledger->isAllocated =  "Y";
                $Ledger->currency = 1;
                $Ledger->exchange_rate = 1;
                if($credit > 0){
                    $Ledger->credit = $credit;
                    $Ledger->cr_entered = $credit;
                }
                if($debit > 0){
                    $Ledger->debit = $debit;
                    $Ledger->db_entered = $debit;
                }
                $Ledger->save(false);
            }
            /**
             * For Each Invoices
             */
           
            foreach ($_POST['ids'] as $i => $each){
               $grand_total = 0;
               /**
                * SI - Sales Invoice
                * DI - Direct Sales
                * CN - Sales Retrun
                * PI - Purchase Invoice
                * DN - Purcahse Retrun
                */
               if($voucher=='EN'){
                    $model = EntryInvoice::model()->findByPk($each);
                    $date = $model->invoice_date; 
                    $narration = 'Inv # :'.$model->id.' Customer: '.$model->customer->customer_name;
                    $total = $model->grand_total;
                }  else {
                    $model = ExitInvoice::model()->findByPk($each);
                    $date = $model->invoice_date;
                    $narration = 'Inv # :'.$model->id.' Customer: '.$model->customer->customer_name;
                }
              
                if(!empty($model)){
                    /**
                     * General Ledger Head Insertion
                     * Common Table
                     */
                    $GeneralLedger = new FinGeneralLedgerHead;
                    $GeneralLedger->voucher_no = $each;
                    $GeneralLedger->voucher_date = $date;
                    $GeneralLedger->comment = $narration;
                    $GeneralLedger->comment2 = $narration;
                    $GeneralLedger->posted = "Y";
                    $GeneralLedger->invoice_id = $model->id; 
                    $GeneralLedger->type = $voucher;
                    $GeneralLedger->dt_posted = date('Y-m-d');
                    $GeneralLedger->voucher_type = $voucher;
                    $finSettings = FinSettings::model()->findAll();
                    
                    if($GeneralLedger->save(false)){
                        $cost = $model->grand_total - $model->total_vat_amount;
                        if( $cost > 0 )
                            addLedger($GeneralLedger->id, $date, FinSettings::getAccount(99999),0,$voucher.'/'.$each,$GeneralLedger->comment.' - Cost',0, $cost );
                        
                        if( $model->total_vat_amount > 0 )
                            addLedger($GeneralLedger->id, $date, FinSettings::getAccount(55556),0,$voucher.'/'.$each,$GeneralLedger->comment.' - VAT',0,$model->total_vat_amount);
                        
                        addLedger($GeneralLedger->id, $date,FinSettings::getAccount(99998),$model->customer_id,$voucher.'/'.$each,$GeneralLedger->comment.' - Sales',$model->grand_total,0);
                    }

                    $GeneralLedger->value = $model->grand_total;
                    $GeneralLedger->save(false);
                    $model->posted = "Y";
                    $model->save(false);
                }
            }
        }else{
            echo 'Select Atleast one Invoice!';
        }

    }
public function actionPdc() {
        $model = new FinGeneralLedger;
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//posting/_pdc_management', array('model' => $model), false, true);
    }
    public function actionChangeChequeStatus(){
        
        $date=$_POST['voucher_date'];
        $acc_id= (int) $_POST['fin_account_id_new'];
        $amount = 0;
        if($date!='' && $acc_id > 0 && is_array($_POST['data'])){
                $date=date("Y-m-d", strtotime(str_replace('/', '-', $date)));
                foreach ($_POST['data'] as $each){
                       $fin=FinGeneralLedger::model()->findByPk($each);
                       $sql2="update crm_pdc set bank_id='".$acc_id."',realisation_date='".$date."',cleared='Y' where voucher_no='".$fin->voucher_no."'";
                        Yii::app()->db->createCommand($sql2)->execute();
                        /**
                        * Contra Entry
                        * 
                        */
                        /*Debit*/
                       $DebitLedger = new FinGeneralLedger;
                       $DebitLedger->date = $date;
                       $DebitLedger->form_ref_no = $fin->form_ref_no;
                       $DebitLedger->account_id = $acc_id;
                       $DebitLedger->voucher_no = $fin->voucher_no;
                       $DebitLedger->form_id = $fin->form_id;
                       $DebitLedger->item_description = 'Cheques Cleard';
                       $DebitLedger->narration = 'Cheques Cleard';
                       $DebitLedger->debit = $fin->credit;
                       $DebitLedger->db_entered = $fin->credit;
                       $DebitLedger->isAllocated = 'Y';
                       $DebitLedger->save(false);
                       /*Credit*/
                       $CreditLedger = new FinGeneralLedger;
                       $CreditLedger->date = $date;
                       $CreditLedger->form_ref_no = $fin->form_ref_no;
                       $CreditLedger->account_id = FinSettings::getAccount(88887);
                       $CreditLedger->voucher_no = $fin->voucher_no;
                       $CreditLedger->form_id = $fin->form_id;
                       $CreditLedger->item_description = 'Cheques Cleard';
                       $CreditLedger->narration = 'Cheques Cleard';
                       $CreditLedger->credit = $fin->credit;
                       $CreditLedger->cr_entered = $fin->credit;
                       $CreditLedger->isAllocated = 'Y';
                       $CreditLedger->save(false);

                }
                
                echo 'success';
        }else
            echo 'fail';
    }
    public function actionPdcSent() {
        $model = new Pdc;
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//posting/_pdc_management_sent', array('model' => $model), false, true);
    }
    public function actionChangeChequeStatusReceived()
    {
        $date=$_POST['voucher_date'];
        $acc_id= (int) $_POST['fin_account_id_new'];
        $amount = 0;
        if($date!='' && $acc_id > 0 && is_array($_POST['data'])){
                $date=date("Y-m-d", strtotime(str_replace('/', '-', $date)));
                foreach ($_POST['data'] as $each){
                       $fin=FinGeneralLedger::model()->findByPk($each);
                       $amount += $fin->debit;
                       $sql2="update crm_pdc set bank_id='".$acc_id."',realisation_date='".$date."',cleared='Y' where voucher_no='".$fin->voucher_no."'";
                        Yii::app()->db->createCommand($sql2)->execute();
                        /**
                        * Contra Entry
                        * 
                        */
                        /*Debit*/
                       $DebitLedger = new FinGeneralLedger;
                       $DebitLedger->date = $date;
                       $DebitLedger->form_ref_no = $fin->form_ref_no;
                       $DebitLedger->account_id = $acc_id;
                       $DebitLedger->voucher_no = $fin->voucher_no;
                       $DebitLedger->form_id = $fin->form_ref_no;
                       $DebitLedger->item_description = 'Cheques Cleard';
                       $DebitLedger->narration = 'Cheques Cleard';
                       $DebitLedger->credit = $fin->debit;
                       $DebitLedger->cr_entered = $fin->debit;
                       $DebitLedger->isAllocated = 'Y';
                       $DebitLedger->save(false);
                       /*Credit*/
                       $CreditLedger = new FinGeneralLedger;
                       $CreditLedger->date = $date;
                       $CreditLedger->form_ref_no = $fin->form_ref_no;
                       $CreditLedger->account_id = FinSettings::getAccount(88887);
                       $CreditLedger->voucher_no = $fin->voucher_no;
                       $CreditLedger->form_id = $fin->form_ref_no;
                       $CreditLedger->item_description = 'Cheques Cleard';
                       $CreditLedger->narration = 'Cheques Cleard';
                       $CreditLedger->debit = $fin->debit;
                       $CreditLedger->db_entered = $fin->debit;
                       $CreditLedger->isAllocated = 'Y';
                       $CreditLedger->save(false);

                }
                
                  echo 'success';
        }else
           echo 'fail';
    }
    public function actionSearchpdc(){
        if(isset($_POST['pdc_date']) || isset($_POST['voucher'])){
            $date=date("Y-m-d", strtotime(str_replace('/', '-', $_POST['pdc_date'])));
            $con = 'type='.$_GET['type'].' AND cleared="N" AND apply_date <= "'.$date.'" ';
            if($_POST['voucher'] != '')
                $con = 'type=1 AND cleared="N" AND apply_date <= "'.$date.'" AND voucher_no="'.$_POST['voucher'].'" ';
            $pdc=Pdc::model()->findAll(array('condition'=>$con));
            $table = '<table class="table table-hover table-bordered personal-task">
     <tr>
        <th>'.CHtml::CheckBox('checkAll','',array('class'=>'checkall')).'</th>
        <th>Voc. Date</th>
        <th>Voucher No</th>
        <th>Subledger</th>
        <th>Amount</th>
        <th>Cheque Date</th>
        <th>Cheque No.</th>
        <th>Narration</th>
    </tr>';
  
        if(!empty($pdc)){
                foreach ($pdc as $i=>$row)
                {
                  
                    $subledger = '-';
                    if($row->customer_id > 0){
                        $subledger = $row->sub->description."(".$row->sub->account_no.")";
                    }
                    $ledger = FinGeneralLedger::model()->find(array('condition' => 'voucher_no="'.$row->voucher_no.'"'));
                    $table .= '<tr>';
                        $table .= '<td>'.CHtml::hiddenfield('data[]',$row->voucher_sub_id).CHtml::CheckBox($row->voucher_sub_id,'',array('class' => 'checkBoxClass')).'</td>';
                        $table .= '<td>'.date("d/m/Y",strtotime($row->voucher_date)).'</td>';
                        $table .= '<td>'.$row->voucher_no.'</td>';
                        $table .= '<td>'.$subledger.'</td>';
                        $table .= '<td>'.number_format($row->amount, 2, '.', '').'</td>';
                        $table .= '<td>'.date("d/m/Y",strtotime($row->apply_date)).'</td>';
                        $table .= '<td>'.$ledger->chk_no.'</td>';
                        $table .= '<td>'.$ledger->narration.'</td>';
                    $table .= '</tr>';
                }
        }else{
              $table .= '<tr>';
                      $table .= '<td colspan="8" class="text-center">No Data</td>';
              $table .= '</tr>';
        }

            $table .= '</table>';
        }
        
        echo $table;
        
    }

      public function actionChangePurchaseaccount(){
                $id = Yii::app()->request->getParam('id');
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
                $model = DirectPurchaseOrderItems::model()->findAll(array( 'condition' => 'purchase_order_id='.$id));
                $this->render('change_purchase_account',array('model'=>$model));
        }

        public function actionSaveInvoicemappings(){
                if(is_array($_POST['DirectPurchaseOrderItems'])){
                    
                    $modelArray = array();
                    $valid = true;
                    
                    foreach ( $_POST['DirectPurchaseOrderItems'] as $i => $each ){
                        if( (int) $each['id'] > 0 ){
                            $modelArray = DirectPurchaseOrderItems::model()->findbypk($each['id']);
                            $modelArray->fin_account_id = $each['fin_account_id'];
                            $modelArray->save(false);
                        }
                    }
                   
                    $data['status'] = 'success';
                    echo json_encode($data);
                }
            }
}