<?php

class MasinvoicetypeController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Getlist','Save','deleteInvoceType','getInvoiceTypeTax'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    public function actionIndex() {
    $this->render('index');
    }
    public function actionGetlist()
	{
        $model=new MasInvoiceType();
		$draw   = $_POST['draw'];
		$offset = $_POST['start'];
		$limit  = $_POST['length'];
		$columns = array(
				// datatable column index  => database column name
                1=>'inv_type',
                2=>'inv_name',
                3=>'tax',
                4=>'is_default',
		);
		$filterColumn = $columns[$_POST['order'][0]['column']];
		$filterOrder  = $_POST['order'][0]['dir'];
		$orderBy      = $filterColumn." ".$filterOrder;
		$condition = '';
		if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
		{
			$searchString = $_POST['search']['value'];
            if($_POST['search']['value'] == 'y' OR $_POST['search']['value'] == 'ye' OR $_POST['search']['value'] == 'yes'){
                $tax_string  = 'Y';
            }
            else if($_POST['search']['value'] == 'n' OR $_POST['search']['value'] == 'no'){
                $tax_string  = 'N';
            }
			$condition.=" ( t.inv_type LIKE '%".$searchString."%' OR t.inv_name LIKE '%".$searchString."%' OR t.tax LIKE '%".$tax_string."%')";
		}
		$count = $model->count(array('condition'=>$condition));
		$model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.inv_type'));
		$recordsTotal = $count;
		$recordsFiltered = $count;
		$data['draw'] = $draw;
		$data['recordsTotal'] = $recordsTotal;
		$data['recordsFiltered'] = $recordsFiltered;
		$rowData=array();
        $m = 1;        
		foreach ($model as $row)
		{
		  if($row['tax'] == 'Y'){
		      $tax  = "Yes";
		  }else{
		      $tax  = "No";
		  }
          
          if($row['inv_type'] == 'sales'){
		      $inv_type  = "Sales";
		  }else if($row['inv_type'] == 'purchase'){
		      $inv_type  = "Purchase";
		  }
          
           $div = '';
           $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'masinvoicetype/create&id='.$row['id'].'\',\'Update Invoice Type\',\'lg\');return false;"><i class="fa fa-pencil"></i></button>';
           //$div .= ' <a href ="#" class="btn btn-danger btn-xs" title="Delete" onclick="deleteInvoceType('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
          
                $rowData[]=array($m,$inv_type,$row['inv_name'],$tax,'<div class="btn-wrap text-center">'.$div.'</div>',$row['is_default']);
                    $m++;
		}
		$data['data'] = $rowData;
		echo json_encode($data);
        }
        
        public function actionCreate(){
            $model=new MasInvoiceType();
            $id = (int) Yii::app()->request->getParam('id');
            if($id > 0){
                $model=$model->findByPk($id);
            }   
            
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
            $this->render('tax_form',array('model'=>$model));
        }
        
        public function actionSave()
        {
            $model = new MasInvoiceType();
            
            if (isset($_POST['MasInvoiceType']))
            {
                $model->created_by        = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $model->updated_by = "0";
                $model->updated_datetime ="0000-00-00"; 
                if ((int) @$_POST['MasInvoiceType']['id'] > 0)
                {   
                    $id= (int) @$_POST['MasInvoiceType']['id']; 
                    $model=$model->findByPk($id); 
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');                                                          
                }
                $type   = $_POST['MasInvoiceType']['inv_type'];
                
                $error_count  = 0;
                
                
                
                if($_POST['MasInvoiceType']['is_default'] == "N"){
                    
                    $find_id  = "";
                    if ((int) @$_POST['MasInvoiceType']['id'] > 0){
                        $id  = (int) @$_POST['MasInvoiceType']['id'];
                        $find_id  = " AND NOT id=".$id;
                    }
                    $invc_count  = MasInvoiceType::model()->count('inv_type="'.$type.'" AND is_default="Y"'.$find_id);
                    if($invc_count<=0){
                        $error_count  = 1;
                    }
                }
                else if($_POST['MasInvoiceType']['is_default'] == "Y"){
                    
                    MasInvoiceType::model()->updateAll(array( 'is_default' => 'N' ), 'inv_type= "'.$type.'"' );
                }
                
                
                
                $model->attributes=$_POST['MasInvoiceType'];
                if($_POST['MasInvoiceType']['inv_name'] == 'Purchase Local'){
                    $model->warehouse_id  = "0";
                }
                else if($type == 'sales'){
                        if(is_array($_POST['MasInvoiceType']['warehouse_id'])){
                            $arr_warehouse = implode(",",array_filter($_POST['MasInvoiceType']['warehouse_id'])); 
                            $model->warehouse_id = $arr_warehouse;
                        }
                }
                else if($type == 'purchase'){
                    $model->warehouse_id = $_POST['MasInvoiceType']['warehouse_id'];
                   
                }
                $model->default_code =""; 
                $valid = $model->validate();
                
                if($valid AND $error_count == '0')
                {
                        $model->save();
                        $jsonData['status'] = 'success';
                        $jsonData['id'] = $model->id;
	                   echo CJSON::encode($jsonData);
                }
                else
                {
                    
                        $error1 = array();
                        $error2 =array();
                        if($error_count == '1'){
                            $error2[] = "Please select default invoice type is Yes";
                        }
                        $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                        $error = CJSON::encode(array_merge_recursive($error2,$error1));
                        
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
        
        /*public function actionSave()
        {
            $model = new MasInvoiceType();
            
            if (isset($_POST['MasInvoiceType']))
            {
                $model->created_by        = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $model->updated_by = "0";
                $model->updated_datetime ="0000-00-00"; 
                if ((int) @$_POST['MasInvoiceType']['id'] > 0)
                {   
                    $id= (int) @$_POST['MasInvoiceType']['id']; 
                    $model=$model->findByPk($id); 
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');                                                          
                }
                if($_POST['MasInvoiceType']['is_default'] == "Y"){
                    $type   = $_POST['MasInvoiceType']['inv_type'];
                    MasInvoiceType::model()->updateAll(array( 'is_default' => 'N' ), 'inv_type= "'.$type.'"' );
                }
                
                $model->attributes=$_POST['MasInvoiceType'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }*/
        public function actionDeleteInvoceType()
        {
            $id    = $_POST['id'];
            $model = new MasInvoiceType();
            $model->deleteByPk($id);
            echo "success";
        }
        public function actiongetInvoiceTypeTax()
        {
            $id    = $_POST['id'];
            if($id>0){
                $model = new MasInvoiceType();
                $model=$model->findByPk($id);
                
                $jsonData['tax'] = $model->tax;
                $jsonData['default_code'] = $model->default_code;
                $jsonData['status'] = 'success'; 
            }
            else{
                $jsonData['status'] = 'error';
            }            
            echo CJSON::encode($jsonData);
        }

}