<?php

class InvoiceController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('IndexEntry', 'GetEntryInvoiceList', 'GetCustomer', 'EntryInvoice', 'SaveEntryInvoice', 'Print','PrintLogo',
                    'getDropdown', 'Printnew','Printnewpp2','Printnewpp3'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndexEntry() {
        $this->render('index_entry');
    }

    public function actionGetCustomer() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = '(customer_name LIKE "%' . $searchTerm . '%" OR customs_code LIKE "%' . $searchTerm . '%") AND t.status=1';
        $model = new Customer();
        $model = $model->findAll(array('select' => 't.id,t.customer_name,t.alias_name,t.exit_clearing_charges,t.entry_clearing_charges,t.customs_code', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            //$modshipaddress = CompanyShippingDetails::model()->findByPk($eachModel->id);
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->customer_name." [".$eachModel->customs_code."]";
            $data[$i]['alias'] = $eachModel->alias_name;
            $data[$i]['exit_clear_charge'] = $eachModel->exit_clearing_charges;
            $data[$i]['entry_clear_charge'] = $eachModel->entry_clearing_charges;

            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionGetEntryInvoiceList() {

        $model = new EntryInvoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            1 => 'file_id',
            2 => 'customer_id',
            3 => 'invoice_date',
            4 => 'grand_total',
            5 => 'status',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.status="1"';



        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $from_date = ( count(explode('/', $_POST['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-d');
            $to_date = ( count(explode('/', $_POST['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-d');
            $condition .=' AND DATE(t.invoice_date)  BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        } else {
            $condition .= ' AND  t.invoice_date="' . date("Y-m-d") . '"';
        }



        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (t.id LIKE '%".$searchString."%' OR t.shipment_reference LIKE '%".$searchString."%' OR customer.customer_name LIKE '%".$searchString."%'  OR manifest LIKE '%".$searchString."%' OR trucks LIKE '%".$searchString."%' OR bill_of_lading LIKE '%".$searchString."%')";
        }


        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {

            $status = "";
            $model_file = MasterFile::model()->findbypk($row->file_id);
            if ($model_file->current_process_status == 'I') {
                $status = "Invoiced";
            }

            
            $div = '';
            if(Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn['entryinvoice_edit'])){
            $div .= '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'invoice/EntryInvoice&id=' . $row['id'] . '\',\'Edit Entry Invoice\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            }
            //if ($row['posted'] == "P" || $row['posted'] == "N")
            if($allPermissions->sales_entry_print_pp1 == 1)
            $div .= ' <a class="btn btn-primary btn-xs" title="PP1" target="_blank" href="index.php?r=invoice/Printnew&id=' . $row['id'] . '&logo=0 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';     
            if($allPermissions->sales_entry_print_pp2 == 1)
            $div .= ' <a class="btn btn-primary btn-xs" title="PP2" target="_blank" href="index.php?r=invoice/Printnewpp2&id=' . $row['id'] . '&logo=0 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            //$div .= ' <a class="btn btn-primary btn-xs" title="PP3" target="_blank" href="index.php?r=invoice/Printnewpp3&id=' . $row['id'] . '&logo=0 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            if(Yii::app()->user->mas_company_code == 'GLC001'){
                $div .=   ' <a class="btn btn-primary btn-xs" title="Print With Logo New" target="_blank" href="index.php?r=invoice/PrintLogo&id=' . $row['id'] .'"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }  
            $div .= ' <a class="btn btn-primary btn-xs" title="Print with Logo" target="_blank" href="index.php?r=invoice/Print&id=' . $row['id'] . '&logo=1 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            $div .= ' <a class="btn btn-primary btn-xs" title="Print Without Logo" target="_blank" href="index.php?r=invoice/Print&id=' . $row['id'] . '&logo=0 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
			
			//$div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'finance/receipt&type=EN&invoice=' . $row['id'] . '\',\'Add Receipt\',\'lg\')"><i class="fa fa-money"></i></button>';
			
			
			
			if(Yii::app()->user->mas_company_code=="ALMAS"){
                $rowData[] = array($m, 'EN '.str_pad( $row['id'], 8, '0', STR_PAD_LEFT), $row['customer']['customer_name'], date("d/m/Y", strtotime($row['invoice_date'])),
                date("h:i A", strtotime($row['created_date'])),$row['bill_of_lading'],Yii::app()->numberFormatter->formatCurrency($row['total_vat_amount'],''),
                Yii::app()->numberFormatter->formatCurrency($row['grand_total'],''), '<div class="btn-wrap text-center">' . $div . '</div>');
			}
			else{
			    $rowData[] = array($m, 'EN '.str_pad( $row['id'], 8, '0', STR_PAD_LEFT), $row['customer']['customer_name'], date("d/m/Y", strtotime($row['invoice_date'])),
                $row['manifest'],$row['shipment_reference'],Yii::app()->numberFormatter->formatCurrency($row['total_vat_amount'],''),
                Yii::app()->numberFormatter->formatCurrency($row['grand_total'],''), '<div class="btn-wrap text-center">' . $div . '</div>');
			}

            $m++;
        }
        $data['data'] = $rowData;
        //$data['condition'] = $condition;
        echo json_encode($data);
    }

    public function actionEntryInvoice() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new EntryInvoice();
        //$modelItem = array(new EntryInvoiceItem, new EntryInvoiceItem, new EntryInvoiceItem,new EntryInvoiceItem,new EntryInvoiceItem,new EntryInvoiceItem,new EntryInvoiceItem);
        $modelItem = array(new EntryInvoiceItem());
        //$modelTruckItem 	= array(new EntryInvoiceTruckNo, new EntryInvoiceTruckNo,  new EntryInvoiceTruckNo, new EntryInvoiceTruckNo, new EntryInvoiceTruckNo, new EntryInvoiceTruckNo, new EntryInvoiceTruckNo);
        $modelTruckItem = array(new EntryInvoiceTruckNo);
        $modelManifestItem = array(new EntryInvoiceManifestNo);

        if ($id > 0) {
            $model = EntryInvoice::model()->findByPk($id);
            $modelItem = EntryInvoiceItem::model()->findAll(array('condition' => 'entry_invoice_id=' . $id));
            $modelTruckItem = EntryInvoiceTruckNo::model()->findAll(array('condition' => 'entry_invoice_id=' . $id));
            $modelManifestItem = EntryInvoiceManifestNo::model()->findAll(array('condition' => 'entry_invoice_id=' . $id));

            $model->alias = $model->customer_id;
        } else {
            // $arr_prodcut_item_details = Store::model()->findAll(array('condition' => 'mark_up > 0 AND is_default="Y"', 'order' => 'mark_up ASC'));
            $arr_prodcut_item_details = Store::model()->findAll(array('condition' => 'is_default="Y"', 'order' => 'mark_up ASC'));
            $i = 0;
            if (!empty($arr_prodcut_item_details)) {
                foreach ($arr_prodcut_item_details as $i => $product_item) {
                    $modelItem[$i] = new EntryInvoiceItem();
                    if ($product_item->item_code == 'CL') {
                        if ((int) Yii::app()->request->getparam('customer_id')) {
                            $cust = Customer::model()->findByPk((int) Yii::app()->request->getparam('customer_id'));
                            $modelItem[$i]['amount'] = $cust->entry_clearing_charges;
                            $modelItem[$i]['rate'] = $cust->entry_clearing_charges;
                        }
                    }
                    $modelItem[$i]['product_id'] = $product_item->id;
                    $modelItem[$i]['product_name'] = $product_item->part_number;
                    $modelItem[$i]['description'] = $product_item->description;
                    $modelItem[$i]['quantity'] = 1;
                    $modelItem[$i]['item_code'] = $product_item->item_code;
                    $i++;
                }
            } else {
                $modelItem = array(new EntryInvoiceItem());
            }
        }

        if ((int) Yii::app()->request->getparam('customer_id')) {
            $customer_id = Yii::app()->request->getparam('customer_id');

            $modelCustomer = new Customer();

            $modelCustomer = Customer::model()->findByPk($customer_id);

            $model->customer_id = $customer_id;

            $model->customer_name = $modelCustomer->customer_name;
            $model->alias = $modelCustomer->alias_name;
            $contact = CompanyContact::model()->findAll(array('condition' => 'crm_user_id=' . $customer_id));
            foreach ($contact as $row) {
                $model->contact_id = $row->id;
            }
        }

        //Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        //$this->renderPartial('//site/_entryinvoiceform', array('modelInvoice' => $model, 'modelItem' => $modelItem, 'modelTruckItem' => $modelTruckItem, 'modelManifestItem' => $modelManifestItem), false, true);
        $this->renderPartial('entry_invoice_form', array('model' => $model, 'modelItem' => $modelItem, 'modelTruckItem' => $modelTruckItem, 'modelManifestItem' => $modelManifestItem), false, true);
    }

    public function actionSaveEntryInvoice() {
        $model = new EntryInvoice();
        $modelItem = array(new EntryInvoiceItem);
        $modelTruckItem = array(new EntryInvoiceTruckNo);
        $modelManifestItem = array(new EntryInvoiceManifestNo);


        if (isset($_POST['EntryInvoice'])) {

            date_default_timezone_set("Asia/Dubai");        
            $model->scenario = 'add';
            if ((int) @$_POST['EntryInvoice']['id'] > 0){
                  $model=$model->findByPK((int) @$_POST['EntryInvoice']['id'] );
                  $model->scenario = 'update';
                
                $ms = 4*60*60;
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d H:i:s');
              
            }else{
                    $ms = 4*60*60;
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date = date('Y-m-d H:i:s');
                    $exist = EntryInvoice::model()->find(array('condition'=>'location_id='.Yii::app()->user->user_location,'order'=>'id DESC'));
                    if(empty($exist)){
                        $value = MasLocation::model()->findByPk(Yii::app()->user->user_location)->entry_start_no;
                    }else{
                        $value =$exist->invoice_no;
                    }
                    $model->invoice_no = $value;
                }
            $model->attributes = $_POST['EntryInvoice'];
            $other_errors = array();
            $valid1 = true;

            if ($_POST['EntryInvoice']['invoice_date'] != '00/00/0000') {
                $model->invoice_date = str_replace('/', '-', $_POST['EntryInvoice']['invoice_date']);
                $model->invoice_date = date("Y-m-d H:i", strtotime($model->invoice_date));
            }
            
            $valid2 = true;
            $count = 0;
            foreach ($_POST['EntryInvoiceTruckNo'] as $i => $item) {
                if (!empty($item['truck_no'])) {
                    $modelTruckItem[$i] = new EntryInvoiceTruckNo;
                    $modelTruckItem[$i]->attributes = $_POST['EntryInvoiceTruckNo'][$i];
                    $valid = $modelTruckItem[$i]->validate() && $valid;
                    $count++;
                }
            }

            foreach ($_POST['EntryInvoiceItem'] as $i => $item) {
                if (!empty($item['product_id'])) {
                    $modelItem[$i] = new EntryInvoiceItem;
                    $modelItem[$i]->attributes = $_POST['EntryInvoiceItem'][$i];

                    //if($modelItem[$i]->product_id==3)
                    if ($item['item_code'] == 'CL') {
                        $cust_id = $_POST['EntryInvoice']['customer_id'];
                        //                                $count=count(array_filter($_POST['EntryInvoiceTruckNo']));
                        $cust_mode = Customer::model()->findByPk($cust_id);
                        switch ($cust_mode->entry_refund_type) {
                            case 0:
                                $commission = 0;
                                break;
                            case 1:
                                $commission = $count * $cust_mode->entry_clearing_charges * $cust_mode->entry_refund_value / 100;
                                break;
                            case 2:
                                //$commission=$count*$cust_mode->entry_refund_value;
                                $commission = ($count * $cust_mode->entry_clearing_charges) - ($count * $cust_mode->entry_refund_value);
                                break;
                            case 3:
                                $commission = ($count * $cust_mode->entry_clearing_charges) - (($count * $cust_mode->entry_clearing_charges) - ($count * $cust_mode->entry_refund_value));
                                break;
                        }
                        $modelItem[$i]->commission = $commission;
                    }
                    $amount = $_POST['EntryInvoiceItem'][$i]['amount'];
                    $model_store = Store::model()->findByPk($modelItem[$i]->product_id);
                    $vat_amount = 0.00;
                    $vat_start_date = "01-01-2018";
                    $invoice_date = date("d-m-Y", strtotime($_POST['EntryInvoice']['invoice_date']));
                    //if (strtotime($invoice_date) >= strtotime($vat_start_date)) {
                        $vat_amount=$_POST['EntryInvoiceItem'][$i]['vat'];
                    //}
                    if(!empty($vat_amount)){
                        $total_vat+=$vat_amount;
                    }
                    $modelItem[$i]->vat_amount = $vat_amount;
                    $modelItem[$i]->amount = $_POST['EntryInvoiceItem'][$i]['amount'];

                    $valid = $modelItem[$i]->validate() && $valid;
                }
            }
            $valid = is_array($modelItem) && $valid1;


            $valid = is_array($modelItem) && $valid2;

            $valid3 = true;
            foreach ($_POST['EntryInvoiceManifestNo'] as $i => $item) {
                if (!empty($item['manifest_no'])) {
                    $modelManifestItem[$i] = new EntryInvoiceManifestNo;
                    $modelManifestItem[$i]->attributes = $_POST['EntryInvoiceManifestNo'][$i];
                    $valid = $modelManifestItem[$i]->validate() && $valid;
                }
            }
            $valid = is_array($modelItem) && $valid2;
            if ($model->validate() && $valid) {
                $model->total_vat_amount = $total_vat;
                $company_id = (int) $model->file_id > 0 ? $model->file->company_id : $model->customer_id;


                $model->location_id = Yii::app()->user->user_location;
                

                $model->file_id = $this->masterFile($model->file_id, 'I', '', $company_id, 0);
                $file_remarks = $_POST['Document']['file_remarks'];
                $this->documents($model->file_id, 'I', $file_remarks);
                if ((int) $_POST['EntryInvoice']['id'] != 0)
                    $model->id = $_POST['EntryInvoice']['id'];
                $notification = false;
                if ((int) $model->id == 0) {// if id 0 means its a new record, otherwise needs to update the existing one
                    $notification = ($model->file->is_approved == "N");
                    $model->save();
                } else
                    $model->updateByPK($model->id, $model->attributes);

                $model_id = $model->id;
                $model->refresh();

                /*                 * **************** Start Save data into Audit Log ************* */
                $arr_user_details = User::model()->findByPk(Yii::app()->user->id);
                $user_full_name = $arr_user_details->first_name . " " . $arr_user_details->last_name;

                $modelAuditLog = new AuditLog();
                if ($model->id > 0) {
                    $action_audit_log = "Entry Invoice [Invoice No: " . $model->id . "] updated by " . $user_full_name . " on " . date('d/m/Y') . " at " . date('h:i A');
                } else {
                    $action_audit_log = "New Entry Invoice [Invoice No: " . $model->id . "] added by " . $user_full_name . " on " . date('d/m/Y') . " at " . date('h:i A');
                }

                $modelAuditLog->form_id = 2;
                $modelAuditLog->created_by = Yii::app()->user->id;
                $modelAuditLog->created_date_time = date('Y-m-d H:i:s');
                $modelAuditLog->action = $action_audit_log;

                $modelAuditLog->save(false);

                /*                 * **************** End Save data into Audit Log ************* */




                $grand_total = 0;
                $jsonData['shoratage'] = "";

                if ($model->id > 0) {
                    EntryInvoiceItem::model()->deleteAll('entry_invoice_id=:refer_id', array(':refer_id' => $model->id));
                    EntryInvoiceTruckNo::model()->deleteAll('entry_invoice_id=:refer_id', array(':refer_id' => $model->id));
                    EntryInvoiceManifestNo::model()->deleteAll('entry_invoice_id=:refer_id', array(':refer_id' => $model->id));
                }

                foreach ($modelItem as $eachItem) {
                    $eachItem->entry_invoice_id = $model->id;
                    $eachItem->cost_rate = Store::model()->findByPk($eachItem->product_id)->rate;
                    $eachItem->save(false);
                    
                    //save data into secure deposit in case of almas
                    
                    if(Yii::app()->user->mas_company_code=="ALMAS" && $eachItem->product_id==3 && $eachItem->rate!="" && (int) @$_POST['EntryInvoice']['id'] == 0){
                        
                        $modelServiceDeposit                            =   new Deposit();
                        $modelServiceDeposit->customer_id               =   $_POST['EntryInvoice']['customer_id'];
                        $modelServiceDeposit->bill_of_entry             =   $_POST['EntryInvoice']['bill_of_lading'];;
                        $modelServiceDeposit->invoice_no                =   $model->id;
                        $modelServiceDeposit->amount                    =   $eachItem->rate;
                        $modelServiceDeposit->issued_date               =   date('Y-m-d');
                        
                        if (!empty($_POST['EntryInvoice']['expiry_date'])) {
                            $modelServiceDeposit->expiry_date           =   str_replace('/', '-', $_POST['EntryInvoice']['expiry_date']);
                            $modelServiceDeposit->expiry_date           =   date("Y-m-d", strtotime($modelServiceDeposit->expiry_date));
                        }
                        else{
                            $modelServiceDeposit->expiry_date           =   "0000-00-00";
                        }
                        
                        $modelServiceDeposit->notes                     =   "Deposited by Entry Invoice";
                        $modelServiceDeposit->doc_submitted_date        =   "0000-00-00";
                        $modelServiceDeposit->customs_submitted_date    =   "0000-00-00";
                        $modelServiceDeposit->payment_collection_date   =   "0000-00-00";
                        $modelServiceDeposit->payment_delivery_date     =   "0000-00-00";
                        $modelServiceDeposit->statement_no              =   $_POST['EntryInvoice']['statement_no'];
                        $modelServiceDeposit->receipt_no                =   "";
                        $modelServiceDeposit->collected_cheque_no       =   "";
                        $modelServiceDeposit->delivered_cheque_no       =   "";
                        $modelServiceDeposit->isActive                  =   "Y";
                        $modelServiceDeposit->created_by                =   Yii::app()->user->id;
                        $modelServiceDeposit->created_datetime          =   date("Y-m-d h:i:s");
                        $modelServiceDeposit->save(false);
                        
                        
                    }
                    
                    //end
                    
                    if(!empty($vat_amount)){
                        $grand_total += $eachItem->amount;
                    }
                    if(!empty($eachItem->vat_amount)){
                        $grand_total += $eachItem->vat_amount;
                    }
                    if(!empty($eachItem->quantity)){
                        $invoiced_qty+=$eachItem->quantity;
                    }
                }
                $trucks = array();
                foreach ($modelTruckItem as $i => $eachTruckItem) {
                    $eachTruckItem->entry_invoice_id = $model->id;
                    //$entry = EntryInvoice::model()->findByPk($model->id);
                    if(!empty($_POST['EntryInvoiceTruckNo'][$i]['truck_no'])){
                        $trucks[$i] = $_POST['EntryInvoiceTruckNo'][$i]['truck_no'];
                    }
                    $eachTruckItem->save(false);
                }
                $manifest = array();
                foreach ($modelManifestItem as $i => $eachManifestItem) {
                    $eachManifestItem->entry_invoice_id = $model->id;
                    //$entry = EntryInvoice::model()->findByPk($model->id);
                    if(!empty($_POST['EntryInvoiceManifestNo'][$i]['manifest_no'])){
                        $manifest[$i] = $_POST['EntryInvoiceManifestNo'][$i]['manifest_no'];
                    }
                    $eachManifestItem->save(false);
                }
                /*if( count($manifest) > 0 )
                    $entry->manifest = implode(',', $manifest);
                if( count($trucks) > 0 )
                    $entry->trucks = implode(',', $trucks);
                $entry->save();
                foreach ($invoices as $eachInvoice)
                    $inoicedQantity+=$eachInvoice->netQuantity;
                if ($orderedQuantity <= $inoicedQantity)
                    $this->masterFile($model->file_id, "I");*/
                // $model->updateByPk($model->id, array('grand_total' => $grand_total));
                //echo $grand_total;
                $model->updateByPk($model_id, array('grand_total' => $grand_total,'manifest'=>implode(',', $manifest),'trucks'=>implode(',', $trucks)));
                Yii::app()->session['file_id'] = $model->file_id;
                $jsonData['file'] = $model->file_id;
                $jsonData['model'] = $model;
                $jsonData['modelItem'] = $modelItem;
                $jsonData['status'] = 'success';
                Yii::app()->session['company_id'] = $model->customer_id;
                echo CJSON::encode($jsonData);
            } else {

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (is_array($modelItem))
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                if (is_array($modelTruckItem))
                    $error3 = json_decode(CActiveForm::validateTabular($modelTruckItem, '', false), true);
                else
                    $error3[] = "Please add atleast one truck details";

                if (is_array($modelManifestItem))
                    $error4 = json_decode(CActiveForm::validateTabular($modelManifestItem, '', false), true);
                else
                    $error4[] = "Please add atleast one manifest details";

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other_errors));
                if ($error != '[]')
                    echo $error;
            }
            Yii::app()->end();
        }
    }

    public function masterFile($file_id, $current_process_status, $title = "", $company_id = 0, $lead_owner_id = 0, $approval = "N") {
        $model_master_file = new MasterFile;
        Yii::app()->session['company_id'] = "";
        if ((int) $file_id == 0) {
            $model_master_file->crm_user_id = Yii::app()->user->id;
            $model_master_file->start_from = $model_master_file->current_process_status = $current_process_status;
            $model_master_file->company_id = $company_id;
            $model_master_file->lead_owner_id = $lead_owner_id;
            $model_master_file->file_title = $title;
            //$model_master_file->own_company_id = Yii::app()->user->master_user_company_id;
            $u_id = (int) ($lead_owner_id) > 0 ? lead_owner_id : (Yii::app()->user->id);
            //$model_master_file->own_branch_id = User::model()->findByPK($u_id)->branch_id;
            if ($approval == 'Y') {
                $model_master_file->is_approved = 'Y';
                $model_master_file->approved_by = Yii::app()->user->id;
                $model_master_file->date_of_approval = date('Y-m-d');
            }
            $model_master_file->save(false);
            $model_master_file->refresh();
            $file_id = $model_master_file->id;
        } else {
            $model_master_file = $model_master_file->findByPK($file_id);
            if ($approval == 'Y') {
                $arrayToBeUpdated['is_approved'] = 'Y';
                $model_master_file['approved_by'] = Yii::app()->user->id;
                $model_master_file['date_of_approval'] = date('Y-m-d');
            }
        }
        if ($model_master_file->priority($current_process_status) >= $model_master_file->priority($model_master_file->current_process_status))
            $arrayToBeUpdated['current_process_status'] = $current_process_status;
        if ($lead_owner_id != 0) {
            $arrayToBeUpdated['lead_owner_id'] = $lead_owner_id;
            //$arrayToBeUpdated['own_branch_id'] = User::model()->findByPK($lead_owner_id)->branch_id;
        }
        if (!empty($title))
            $arrayToBeUpdated['file_title'] = $title;
        if ((int) $company_id != 0) {
            $arrayToBeUpdated['company_id'] = $company_id;
            Yii::app()->session['company_id'] = $model_master_file->company_id;
        }

        $model_master_file->updateByPK($file_id, $arrayToBeUpdated);

        return $file_id;
    }

    public function actionPrint() {

        $model = new EntryInvoice();
        $id = Yii::app()->request->getParam('id');
        $logo = Yii::app()->request->getParam('logo');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.entry_invoice_logo', array('model' => $model, 'id' => $id, 'logo' => $logo), true));
        $mPDF1->Output("entry_invoice.pdf", 'I');
    }
    public function actionPrintnew() {

        $model = new EntryInvoice();
        $id = Yii::app()->request->getParam('id');
        $logo = Yii::app()->request->getParam('logo');
        $modelmfno = new EntryInvoiceManifestNo();
        $modeltrucks = new EntryInvoiceTruckNo();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelmfno = $modelmfno->find(array('condition'=>'entry_invoice_id='.$id));
            $modeltruck = $modeltrucks->find(array('condition'=>'entry_invoice_id='.$id));
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.entry_invoice_new_2', array('model' => $model, 'id' => $id, 'logo' => $logo,'modelmfno'=>$modelmfno,'modeltruck'=>$modeltruck), true));
        $mPDF1->Output("entry_invoice.pdf", 'I');
    }
    public function actionPrintnewpp2() {

        $model = new EntryInvoice();
        $id = Yii::app()->request->getParam('id');
        $logo = Yii::app()->request->getParam('logo');
        $modelmfno = new EntryInvoiceManifestNo();
        $modeltrucks = new EntryInvoiceTruckNo();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelmfno = $modelmfno->find(array('condition'=>'entry_invoice_id='.$id));
            $modeltruck = $modeltrucks->find(array('condition'=>'entry_invoice_id='.$id));
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.entry_invoice_new_pp2', array('model' => $model, 'id' => $id, 'logo' => $logo,'modelmfno'=>$modelmfno,'modeltruck'=>$modeltruck), true));
        $mPDF1->Output("entry_invoice.pdf", 'I');
    }
    public function actionPrintnewpp3() {

        $model = new EntryInvoice();
        $id = Yii::app()->request->getParam('id');
        $logo = Yii::app()->request->getParam('logo');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.entry_invoice_new_pp3', array('model' => $model, 'id' => $id, 'logo' => $logo), true));
        $mPDF1->Output("entry_invoice.pdf", 'I');
    }

    public function actiongetDropdown(){
        $customer = $_POST['customer_id'];
        $type= $_POST['type'];
        $response = array();
        $model = ( $type == 'IN' ) ? new EntryInvoice : new ExitInvoice;
        $customerModel = Customer::model()->findBypk( (int) $customer );
        $model->salesman = $customerModel->salesman;
        $arr_data =  CustomerContact::getContacts( (int) $customer ); 
        $response['notes'] =  $customerModel->other_notes;  
        $response['drop'] = CHtml::activedropdownlist($model, 'salesman',User::getLeadOwners(), array('class' => 'tooltipster','data-label'=>'Salesman' ));
        $response['con'] = CHtml::activedropdownlist($model, 'contact_id', $arr_data, array('class' => '','data-label'=>'Contact Person <span style="color:red;">*<span> '));
        $response['status'] = 'success';
        echo json_encode($response);
    }
    public function actionPrintLogo() {

        $model = new EntryInvoice();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.entry_invoice_gulfcargo', array('model' => $model, 'id' => $id), true));
        $mPDF1->Output("entry_invoice.pdf", 'I');
    }
}
