<?php



class InventoryController extends Controller

{

        public function accessRules() {

            return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','getLevel1','SetWarehouse','Service','SaveEditedItem','CalculateVat', 'GetServiceItems','SaveEditedMaterial','rawmaterial','Create','CreateMaterial','SaveMaterial','GetList','GetServiceList','GetMaterialList','SaveItem','SaveServiceItem','DeleteItem','GetLocationList','CreateLocation','DeleteLocation','SaveLocation','CreateService','UploadInventoryImage','DeleteImage','CheckExistance','History','GetHistory'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

        }

	public function actionIndex()

	{

		$this->render('index');

	}
        public function actionService()

	{

		$this->render('service');

	}
        


	public function actionGetServiceItems() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%" AND t.isActive="Y" OR description LIKE "%' . $searchTerm . '%" AND t.status=1';
        $model = new Store();
        $model = $model->findAll(array('select' => 't.id,t.part_number,t.description,t.tax_code,t.default_clearing_charges', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number;
            $data[$i]['p_value'] = $eachModel->description;
            $data[$i]['tax'] = (float) $eachModel->taxCode->percentage;
            $data[$i]['exit_clear_charge'] = $eachModel->default_clearing_charges;
            $data[$i]['entry_clear_charge'] = $eachModel->default_clearing_charges;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionCalculateVat()
    {
    	$product_id= $_POST['product_id'];
        $amount= $_POST['amount'];
        $model_store= Store::model()->findByPk($product_id);
        $vat_amount=0.00; 
        $taxpercent=$model_store->taxCode->percentage/100;
        $percent=1+$taxpercent;
        $vat_amount= ($amount*$taxpercent)/$percent;                                                  
        $jsonData['amount'] =$vat_amount;
    	$jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    	 
    }

	

	public function filters()

        {

            return array(

                'accessControl', // perform access control for CRUD operations

                );

        }

        public function actionGetList()

        {

                $model=new Store();

                $draw    = $_POST['draw'];

                $offset = $_POST['start'];

                $limit  = $_POST['length'];

                $columns = array(

                // datatable column index  => database column name

                   0 =>'part_number',
                    1 => 'generic_name',
                   2 => 'description',
                    3 => 'brand_class_id',
                    4 => 'default_warehouse_id',
                    5 => 'inventory_item_type',
                   

                    

                   

                   );

                $filterColumn = $columns[$_POST['order'][0]['column']];

                $filterOrder  = $_POST['order'][0]['dir'];

                $orderBy   = $filterColumn." ".$filterOrder;

                $condition = 't.isActive="Y" AND inventory_item_type=1';

                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

                {

                  $searchString = $_POST['search']['value'];

                  $condition ="inventory_item_type=1 AND ( part_number LIKE '%".$searchString."%' OR description LIKE '%".$searchString."%' OR alias_name LIKE '%".$searchString."%') ";

                }

                $count = $model->count(array('condition'=>$condition));

                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'isActive,part_number'));

                $recordsTotal = $count;

                $recordsFiltered = $count;

                $data['draw'] = $draw;

                $data['recordsTotal'] = $recordsTotal;

                $data['recordsFiltered'] = $recordsFiltered;

                $rowData=array();

                $m = 1;

               
                
                
                foreach ($model as $row)
                {
                    $div = '';
                      $conditionx = 'stock_id = '.$row->id.'';
                    $model_temp = ProductLocation::model()->find(array(
                        'select' => 'SUM(quantity) AS quantity' ,  'condition' => $conditionx
                    ));
                   $quantity =  $model_temp->quantity;
                   
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["stock_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inventory/create&id='.$row['id'].'\',\'Item - '.$row['part_number'].' \',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                   
                       $rowData[]=array($m,$row['isActive'],$row['part_number'],$row['description'],$row['alias_name'],Yii::app()->numberFormatter->formatCurrency($quantity,""),$row->unit->symbol,'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                } 
                
                
//                foreach ($model as $row)
//
//                {
//                    
//                    $conditionx = 'stock_id = '.$row->id.'';
//                    $model_temp = ProductLocation::model()->find(array(
//                        'select' => 'SUM(quantity) AS quantity' ,  'condition' => $conditionx
//                    ));
//                   $quantity =  $model_temp->quantity;
//                   
//
//                    $rowData[]=array($m,$row['part_number'],$row['description'],$row->brand_detail->brand_class_name,$row->genericdetails->generic_name,Yii::app()->numberFormatter->formatCurrency($quantity,""),$row->unit->symbol,'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inventory/create&id='.$row['id'].'\',\'Edit\',\'lg\')"><i class="fa fa-pencil"></i></button>');
//
//                    $m++;
//
//                }

                $data['data'] = $rowData;

                echo json_encode($data);

        }
        public function actionGetServiceList()

        {

                $model=new Store();

                $draw    = $_POST['draw'];

                $offset = $_POST['start'];

                $limit  = $_POST['length'];

                $columns = array(

                // datatable column index  => database column name

                   0 =>'part_number',
                    1 => 'generic_name',
                   2 => 'description',
                    3 => 'brand_class_id',
                    4 => 'default_warehouse_id',
                    //5 => 'inventory_item_type'

                    

                   

                   );

                $filterColumn = $columns[$_POST['order'][0]['column']];

                $filterOrder  = $_POST['order'][0]['dir'];

                $orderBy   = $filterColumn." ".$filterOrder;

                //$condition = 't.isActive="Y" AND inventory_item_type=2';
                $condition = 't.isActive="Y"';

                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

                {

                  $searchString = $_POST['search']['value'];

                  $condition.=" and part_number LIKE '%".$searchString."%'";

                }

                $count = $model->count(array('condition'=>$condition));

                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));

                $recordsTotal = $count;

                $recordsFiltered = $count;

                $data['draw'] = $draw;

                $data['recordsTotal'] = $recordsTotal;

                $data['recordsFiltered'] = $recordsFiltered;

                $rowData=array();

                $m = 1;

               

                foreach ($model as $row)

                {
                   $delete_btn  = '';
                   /*if($row->inventory_type != '2'){
                       if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["service_delete"])){
                        $delete_btn  = '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteItem('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                       }
                   }*/

                    $div='';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["service_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inventory/createService&id='.$row['id'].'\',\'Service - '.$row['part_number'].'\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    $div=$div.$delete_btn;
                    $rowData[]=array($m,$row['part_number'],$row['description'],'<div class="btn-wrap text-center">'.$div.'</div>');

                    $m++;

                }
                

                $data['data'] = $rowData;

                echo json_encode($data);

        }
        
        public function actionGetMaterialList()

        {
                $model=new Store();

                $draw    = $_POST['draw'];

                $offset = $_POST['start'];

                $limit  = $_POST['length'];

                $columns = array(

                // datatable column index  => database column name

                   0 =>'part_number',
                    1 => 'generic_name',
                   2 => 'description',
                    3 => 'brand_class_id',
                    4 => 'default_warehouse_id',
                    5 => 'inventory_item_type',
                   
                 );

                $filterColumn = $columns[$_POST['order'][0]['column']];

                $filterOrder  = $_POST['order'][0]['dir'];

                $orderBy   = $filterColumn." ".$filterOrder;

                $condition = 't.isActive="Y" AND inventory_item_type=3';

                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

                {

                  $searchString = $_POST['search']['value'];

                   $condition ="inventory_item_type=3 AND ( part_number LIKE '%".$searchString."%' OR oem_number LIKE '%".$searchString."%' OR other_number LIKE '%".$searchString."%') ";

                }

                $count = $model->count(array('condition'=>$condition));

                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'isActive,part_number'));

                $recordsTotal = $count;

                $recordsFiltered = $count;

                $data['draw'] = $draw;

                $data['recordsTotal'] = $recordsTotal;

                $data['recordsFiltered'] = $recordsFiltered;

                $rowData=array();

                $m = 1;

               
                    
                foreach ($model as $row)

                {
                    
                    $conditionx = 'stock_id = '.$row->id.'';
                    $model_temp = ProductLocation::model()->find(array(
                        'select' => 'SUM(quantity) AS quantity' ,  'condition' => $conditionx
                    ));
                   $quantity =  $model_temp->quantity;
                   $div='';
                   if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["rawmaterial_edit"])){
                        $div .= '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inventory/createMaterial&id='.$row['id'].'\',\'Item - '.$row['part_number'].'\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                   }

                    $rowData[]=array($m,$row['isActive'],$row['part_number'],$row['description'],$row->brand_detail->product_class,$row->genericdetails->generic_name,Yii::app()->numberFormatter->formatCurrency($quantity,""),$row->unit->symbol,$div);

                    $m++;

                }

                $data['data'] = $rowData;

                echo json_encode($data);


        }

         public function actionCreate()

        {

            $model=new Store();
            $id = (int) Yii::app()->request->getParam('id');
            $model_location = new ProductLocation();
            if($id>0){
                $model=$model->findByPk($id);
                }

                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

            $this->render('inventory_form', array('model' => $model,'model_location' => $model_location,'id' => $id,'generic' => $generic,'brand' =>$brand,'tax' => $tax,'unit' => $unit), false, false);

        }
        public function actionCreateService()

        {

            $model=new Store();

            $id = (int) Yii::app()->request->getParam('id');

          
            if($id>0){

                $model=$model->findByPk($id);

            }

                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

            $this->render('service_form', array('model' => $model), false, false);

        }
        
        public function actionCreateLocation()

        {

            $model=new ProductLocation();

            $id = (int) Yii::app()->request->getParam('id');
            $stock_id = (int) Yii::app()->request->getParam('stock_id');
            if($id>0){

                $model=$model->findByPk($id);

            }

                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

            $this->render('location_add_details_2', array('model_location' => $model,'stock_id' => $stock_id), false, false);

        }
         public function actionCreateMaterial()

        {

            $model=new Store();

            $id = (int) Yii::app()->request->getParam('id');

            $model_location = new ProductLocation();

            if($id>0){

                $model=$model->findByPk($id);

            }

                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

            $this->render('inventory_form_2', array('model' => $model,'model_location' => $model_location,'id' => $id), false, false);

        }

  

  

        public function actionSaveItem()

        {
           
            $model = new Store();
            $model_location = new ProductLocation();
            $date = date("Y-m-d H:i:s");
            $model->scenario = 'add';
            $edit_flag=0;
            if (isset($_POST['Store'])){
                
                

    		if ($_POST['Store']['id'] > 0){

                    $id= $_POST['Store']['id'];
                    $model=$model->findByPk($id);  
                    $model->updated_by = Yii::app()->user->id; 
                    $model->updated_date_time = $date;
                    $edit_flag=1;

                }
                else{
                      $model->created_by = Yii::app()->user->id; 
                      $model->created_date_time = $date;
                      $edit_flag=0;
                }
                 $model->attributes=$_POST['Store'];
                 $model->inventory_item_type = 1;
                 $model->supercede_id = $_POST['Store']['supercede_id'];
                 $model_temp = MasInventoryWarehouse::model()->find(array('select' => 'id','condition'=>'isBaseWareHouse="Y"'));
                   if(!empty($model_temp)){
                       $model->default_warehouse_id = $model_temp->id;
                      
                   }
                   $valid = $model->validate();
               if(isset($_POST['ProductLocation']) && $_POST['Store']['id'] == ''){
                 
                if($_POST['ProductLocation']['id'] > 0){
                    $id_l = $_POST['ProductLocation']['id'];
                    $model_location=$model_location->findByPk($id_l);  
                    $model_location->updated_by = Yii::app()->user->id; 
                    $model_location->updated_date_time = $date;
                }
                else{
                    
                    $model_location->created_by = Yii::app()->user->id; 
                    $model_location->created_date_time = $date;
                }
                $model_location->attributes=$_POST['ProductLocation'];
				$model_location->is_default_warehouse_id="Y";
                             $valid =    $model_location->validate() && $valid;
               }
                $flag2 = 0;
                if(trim(strtolower($_POST['Store']['part_number'])) == 'memo'){
                    $valid = false;
                    $flag2 = 1;
                }
                if ($valid){
                        $model->save();
                        if($edit_flag == 0){
                            $mod_open = new OpeningBalance();
                            $mod_open->product_id = $model->id;
                            $mod_open->opening_quantity=0;
                            $mod_open->save(false);
                        }
                        $model_location->stock_id = $model->id;
                        if($_POST['Store']['id'] ==  '')
                            $model_location->save(false);
//                        $model_temp2 = ProductLocation::model()->find(array('select' => 'SUM(quantity) AS quantity','condition'=>'stock_id="'.$model->id.'"'));
//                        $model_store = Store::model()->findbyPK($model->id);
//                        if(!empty($model_store)){
//                            $model_store->default_warehouse_id = $_POST['ProductLocation']['warehouse_id'];
//                            $rate= $model_store->rate;
//                            $quantity=$model_temp2->quantity;
//                            $total=$quantity*$rate;
//                            $model_store->total_value=$total;
//                            $model_store->total_quantity = $quantity;
//                            $model_store->save(false);
                      //  }
                    
                    $jsonData['status'] = 'success';

                    $jsonData['frm'] = $_POST['inventory_form'];

                    $jsonData['id'] = $model->id;

	            echo CJSON::encode($jsonData);

                }
                
                else{
                    $error2 = array();
                    if($flag2 == 1){
                        $error2[] = 'Keyword memo is reserved!';
                    }
                    $error1 = json_decode(CActiveForm::validate(array($model_location,$model), '', false), true);
                    $error = CJSON::encode(array_merge_recursive($error1, $error2));

                        if ($error != '[]')

                            echo $error;

                }

          

            }

        }

        public function actionSaveMaterial()

        {

             
            $model = new Store();
            $model_location = new ProductLocation();
            $date = date("Y-m-d H:i:s");
            $model->scenario = 'add';
            if (isset($_POST['Store'])){
                
                

    		if ($_POST['Store']['id'] > 0){

                    $id= $_POST['Store']['id'];
                    $model=$model->findByPk($id);  
                    $model->updated_by = Yii::app()->user->id; 
                    $model->updated_date_time = $date;
                    

                }
                else{
                      $model->created_by = Yii::app()->user->id; 
                      $model->created_date_time = $date;
                }
                 $model->attributes=$_POST['Store'];
                 $model->inventory_item_type = 3;
                 $model->supercede_id = $_POST['Store']['supercede_id'];
                 $model_temp = MasInventoryWarehouse::model()->find(array('select' => 'id','condition'=>'isBaseWareHouse="Y"'));
                   if(!empty($model_temp)){
                       $model->default_warehouse_id = $model_temp->id;
                      
                   }
                   $valid = $model->validate();
               if(isset($_POST['ProductLocation'])){
                 
                if($_POST['ProductLocation']['id'] > 0){
                    $id_l = $_POST['ProductLocation']['id'];
                    $model_location=$model_location->findByPk($id_l);  
                    $model_location->updated_by = Yii::app()->user->id; 
                    $model_location->updated_date_time = $date;
                }
                else{
                    
                    $model_location->created_by = Yii::app()->user->id; 
                    $model_location->created_date_time = $date;
                }
                $model_location->attributes=$_POST['ProductLocation'];
				$model_location->is_default_warehouse_id="Y";
                             $valid =    $model_location->validate() && $valid;
               }
                
                
                if ($valid){
                        $model->save();
                        $model_location->stock_id = $model->id;
                        if($model->id == '')
                            $model_location->save(false);
//                        $model_temp2 = ProductLocation::model()->find(array('select' => 'SUM(quantity) AS quantity','condition'=>'stock_id="'.$model->id.'"'));
//                        $model_store = Store::model()->findbyPK($model->id);
//                        if(!empty($model_store)){
//                            $model_store->default_warehouse_id = $_POST['ProductLocation']['warehouse_id'];
//                            $rate= $model_store->rate;
//                            $quantity=$model_temp2->quantity;
//                            $total=$quantity*$rate;
//                            $model_store->total_value=$total;
//                            $model_store->total_quantity = $quantity;
//                            $model_store->save(false);
                      //  }
                    
                    $jsonData['status'] = 'success';

                    $jsonData['frm'] = $_POST['inventory_form'];

                    $jsonData['id'] = $model->id;

	            echo CJSON::encode($jsonData);

                }
                
                else{
                    $error = CActiveForm::validate(array($model_location,$model), '', false);

                        if ($error != '[]')

		               echo $error;

                }

          

            }

        }
        public function actionSaveServiceItem()

        {

            $model = new Store();
            $date = date("Y-m-d H:i:s");

            if (isset($_POST['Store']))

            {

    		

    		if ((int) @$_POST['Store']['id'] > 0)

                {

                    $id= (int) @$_POST['Store']['id'];

                    $model=$model->findByPk($id);  
                   // $model->updated_by = Yii::app()->user->id; 
                    //$model->updated_date_time = $date;

                }

                $model->attributes=$_POST['Store'];
                //ProductLocation::model()->stock_id = $model->id;
                $model->crm_user_id = Yii::app()->user->id; 
                //$model->created_date_time = $date;
                //$model->updated_by = Yii::app()->user->id; 
                //$model->updated_date_time = $date;
                   //$model->inventory_item_type = '2';
                $model->status = 1;
              
               
                
                

                if ($model->save())

                {

                        $jsonData['status'] = 'success';

                        $jsonData['frm'] = $_POST['inventory_form'];

                        $jsonData['id'] = $model->id;

	                echo CJSON::encode($jsonData);

                }

                else

                {

                        $error = CActiveForm::validate($model, '', false);

                        if ($error != '[]')

		               echo $error;

                }

          

            }

        }
        
        
        
        public function actionSaveLocation()

        {
            $model = new ProductLocation();
            $model_store = new Store();
            $date = date("Y-m-d H:i:s");
            if (isset($_POST['ProductLocation']))

            {
    		if ((int) @$_POST['ProductLocation']['id'] > 0)

                {
                    $id=$_POST['ProductLocation']['id'];
                    $model=$model->findByPk($id);  
                    $model->updated_by = Yii::app()->user->id; 
                    $model->updated_date_time = $date;                               
                }                        
                $model->attributes=$_POST['ProductLocation'];          
                $model->created_by = Yii::app()->user->id; 
                $model->created_date_time = $date;
                
                if ($model->save())

                {
                    $model_temp = ProductLocation::model()->find(array('select' => 'SUM(quantity) AS quantity','condition'=>'stock_id="'.$_POST['ProductLocation']['stock_id'].'"'));
                    $model_store = Store::model()->findbyPK($_POST['ProductLocation']['stock_id']);
                    if(!empty($model_store)){
                         if($_POST['ProductLocation']['isDefault'] == 1){
                                    $model_store->default_warehouse_id = $_POST['ProductLocation']['warehouse_id'];
                            }
                       $rate= $model_store->rate;
                       $quantity=$model_temp->quantity;
                       $total=$quantity*$rate;
                       $model_store->total_value=$total;
                       $model_store->total_quantity = $quantity;
                       $model_store->save(false);
                    }
                   // Store::model()->updateByPk($_POST['ProductLocation']['stock_id'],array('total_value' => $model_temp->quantity));

                        $jsonData['status'] = 'success';

                        $jsonData['frm'] = $_POST['location_add_details'];

                        $jsonData['id'] = $model->stock_id;

	                echo CJSON::encode($jsonData);

                }

                else

                {

                        $error = CActiveForm::validate($model, '', false);

                        if ($error != '[]')

		               echo $error;

                }
                

          

            }

        }

        public function actionDeleteItem(){

		$id = $_POST['id'];

                $model=new Store();

                $model->deleteByPk($id);

                echo "success";

    }
    
    public function actionSetWarehouse(){

		$id = $_POST['id'];
                $stock_id = $_POST['stock_id'];
                $warehouse_id = $_POST['warehouse_id'];
                $model_l = new ProductLocation();
                $t_name = $model_l ->tableSchema->name;
                $t_name2 = Store::model() ->tableSchema->name;
                $att = 'is_default_warehouse_id = "N"';
                $con = 'id = ' .$id . '';
                $connection=Yii::app()->db;
                $sql = 'UPDATE ' . $t_name . ' SET is_default_warehouse_id="N" WHERE stock_id = ' . $stock_id . '';
                $command = $connection->createCommand($sql);
                $command->execute();
                $sql2 = 'UPDATE ' . $t_name . '  SET is_default_warehouse_id="Y" WHERE id = ' . $id . '';
                $command2 = $connection->createCommand($sql2);
                $command2->execute();
                $sql3 = 'UPDATE ' . $t_name2 . '  SET default_warehouse_id= ' . $warehouse_id. ' WHERE id = ' . $stock_id . '';
                $command3 = $connection->createCommand($sql3);
                $command3->execute();
                //ProductLocation::model()->update( array( 'is_default_warehouse_id' => 'N' ), 'stock_id = 6' );

                //$model->deleteByPk($id);

                echo "success";

    }
    
    public function actionGetLocationList()

        {
                $id = $_POST['id'];
                $model=new ProductLocation();

                $draw    = $_POST['draw'];

                $offset = $_POST['start'];

                $limit  = $_POST['length'];

                $columns = array(

                // datatable column index  => database column name
                    0 => 'warehouse_id',

                   1 =>'bin',

                   2 => 'rack',
                    
                    3 => 'quantity',

                    

                   

                   );

                $filterColumn = $columns[$_POST['order'][0]['column']];

                $filterOrder  = $_POST['order'][0]['dir'];

                $orderBy   = $filterColumn." ".$filterOrder;
                if($id ==''){
                    $id=0;
               }
                $condition = 't.stock_id="'.$id.'"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

                {

                  $searchString = $_POST['search']['value'];

                  $condition.=" and (bin LIKE '%".$searchString."%' OR bin LIKE '%".$searchString."%' OR quantity LIKE '%".$searchString."%')";

                }

                $count = $model->count(array('condition'=>$condition));

                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));

                $recordsTotal = $count;

                $recordsFiltered = $count;

                $data['draw'] = $draw;

                $data['recordsTotal'] = $recordsTotal;

                $data['recordsFiltered'] = $recordsFiltered;

                $rowData=array();

                $m = 1;

               

                foreach ($model as $row)

                {
                    $class = 'danger';
                    if($row['is_default_warehouse_id'] == Y){
                        $class = 'theme';
                    }

                    $rowData[]=array($m,$row->warehouse->warehouse_name,$row->rack0->name,$row->bin0->name,$row['quantity'],'<div class="btn-wrap text-center"><a href ="#" class="btn btn-'. $class .' btn-xs" onclick="setWarehouse('.$row['id'].','.$row['stock_id'] .','. $row['warehouse_id'] . ')"><i class="fa fa-check "></i></a></div>');

                    $m++;

                }

                $data['data'] = $rowData;

                echo json_encode($data);

        }
        
         public function actiongetLevel1(){
            $id=Yii::app()->request->getparam("id");  
            $models = MasCategoryFirstLevel::getCategoryL1Details($id); 
            $modelx = MasCategorySecondLevel::getCategoryL2Details($id);
            if(!empty($models) || !empty($modelx)){                
                $drop='<li class="col-sm-6">';
                $model=new Store();
                $drop.=CHtml::activedropDownList($model,'category_level_1' , $models,  array('class' => 'tooltipster','data-label'=>'Category Level 1'));    
                $drop.='</li>';
               // $status=array("dt" => $drop);      
              //  echo CJSON::encode($status);
                 $drop2='<li class="col-sm-6">';
                
                $drop2.=CHtml::activedropDownList($model,'category_level_2' , $modelx,  array('class' => 'tooltipster','data-label'=>'Category Level 2'));    
                $drop2.='</li>';
                
            }
                $status=array("dt" => $drop,"dt2" => $drop2);    
                echo CJSON::encode($status);
            
         }
         
         
         public function actionUploadInventoryImage($folder = null) {

    	

    	Yii::import("ext.EAjaxUpload.qqFileUploader");

    

    	$field_id = "";

    	if(isset($_GET['field_id']))

    	{

    		$field_id = Yii::app()->request->getParam('field_id');

    	}

    

    

    	$folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

    	// make the directory to store the pic:

    	if (!is_dir($folder)) {

    		mkdir($folder, 0777, TRUE);

    	}

    	$allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...

    	$sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes

    	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);

    	$result = $uploader->handleUpload($folder);

    	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

    	$result['field_id'] = $field_id;

    	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

    

    	$fileName = $result['filename']; //GETTING FILE NAME

    	 

    

    	$imagename	=	Yii::app()->basePath.'/../uploads/inventoryimages/'.$fileName;

    

    	$imagename_thumb	=	Yii::app()->basePath.'/../uploads/inventoryimages/thumbs/'.$fileName;

    	Yii::import("ext.EPhpThumb.EPhpThumb");

    

    	$thumb=new EPhpThumb();

    	$thumb->init(); //this is needed

    	//chain functions

    	$thumb->create($imagename)->resize(100,100)->save($imagename_thumb);

    

    	echo $return; // it's array

    }
        public function actionDeleteImage(){
		$id = $_POST['id'];
                $model= Store::model()->findByPk($id);
                if($model->item_image!=''){
                    $path = Yii::getPathOfAlias('webroot')."/uploads/inventoryimages/".$model->item_image;
                    if(file_exists($path)){
                            unlink($path);
                    }
                }
                $model->item_image= '';
                $model->save(false);
                echo "success";
                
                
    }
    
    public function actionCheckExistance(){
        $term = $_POST['item'];
        $status=array();    
        if($term != ''){
            $store = Store::model()->findAll(array('condition' => 'part_number = "'.$term.'"'));
            if(!empty($store)){
                $status['status'] = 'exist';
            }else if(trim(strtolower ($term)) == 'memo'){
                 $status['status'] = 'exist';
            }else{
                $status['status'] = 'not_exist';
            }
        }
        echo CJSON::encode($status);
    }
        public function actionHistory(){
            $this->render('history');
        }
   
         public function actionGetHistory(){
                $product = $_POST['product'];
                $from_date = $_POST['from'];
                $to_date = $_POST['to'];
                $type = $_POST['type'];
                $con_one = 'B.product_id='.$product.' AND A.file_id > 0';
                $con_two = 'B.product_id='.$product.' AND A.file_id > 0';
                $con_three = 'D.product_id='.$product.' AND C.file_id > 0';
                if($from_date != '' && $to_date == ''){
                     $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
                     $con_one .= ' AND (A.mrv_receipt_date > "'.$start_date.'")';
                     $con_two .= ' AND (A.invoice_date > "'.$start_date.'")';
                     $con_three .= ' AND (C.invoice_date > "'.$start_date.'")';
                }else if($from_date == '' && $to_date != ''){
                     $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $$to_date)));
                     $con_one .= ' AND (A.mrv_receipt_date < "'.$end_date.'")';
                     $con_two .= ' AND (A.invoice_date < "'.$end_date.'")';
                     $con_three .= ' AND (C.invoice_date < "'.$end_date.'")';
                }else if($from_date != '' && $to_date != ''){
                     $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
                     $end_date =date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
                     $con_one .= ' AND (A.mrv_receipt_date BETWEEN "'.$start_date.'" AND "'.$end_date.'")';
                     $con_two .= ' AND (A.invoice_date BETWEEN "'.$start_date.'" AND "'.$end_date.'")';
                     $con_three .= ' AND (C.invoice_date BETWEEN "'.$start_date.'" AND "'.$end_date.'")';
                }else{
                     $con_one .= ' AND 1=1';
                     $con_two .= ' AND 1=1';
                     $con_three .= ' AND 1=1';
                }
                $model_settings        = MasCompanySettings::model()->find();
                if(!empty($model_settings)){
                    $qualitycontrol = $model_settings->qualitycontrol;
                    $stock_update_on     = $model_settings->stock_updates_on;
                }
                if($stock_update_on=="MR"){
                    if($qualitycontrol == "Y"){
                        $which_q = 'qcchecked_quantity';
                    }else{
                        $which_q = 'received_quantity';
                    }
                    $purchase = 'SELECT A.id AS bill_no,A.mrv_receipt_date AS req_date,S.part_number AS item,V.vendor_name AS name,B.'.$which_q.' AS quantity,F.current_process_status AS status,B.rate AS rate FROM crm_purchasing_material_receipt AS A '
                                . ' LEFT JOIN crm_purchasing_material_receipt_item AS B ON A.id=B.purchasing_materialreceipt_id LEFT JOIN crm_store AS S ON B.product_id=S.id'
                                . ' LEFT JOIN crm_vendor AS V ON A.vendor_id = V.id LEFT JOIN crm_master_file AS F ON A.file_id=F.id WHERE '.$con_one.' ';
                }else{
                   
                    $purchase = 'SELECT A.id AS bill_no,A.invoice_date AS req_date,S.part_number AS item,V.vendor_name AS name,B.quantity AS quantity,F.current_process_status AS status,B.rate AS rate FROM crm_purchasinginvoice AS A '
                                . ' LEFT JOIN crm_purchasinginvoice_item AS B ON A.id=B.purchasing_invoice_id LEFT JOIN crm_store AS S ON B.product_id=S.id'
                                . ' LEFT JOIN crm_vendor AS V ON A.vendor_id = V.id LEFT JOIN crm_master_file AS F ON A.file_id=F.id WHERE '.$con_two.'';
                }
                $sales = 'SELECT C.id AS bill_no,C.invoice_date AS req_date,S.part_number AS item,CU.customer_name AS name,D.quantity AS quantity,F.current_process_status AS status,D.rate AS rate FROM crm_invoice AS C LEFT JOIN crm_invoice_item AS D ON C.id=D.invoice_id'
                         . ' LEFT JOIN crm_store AS S ON D.product_id=S.id LEFT JOIN crm_customer AS CU ON C.company_id=CU.id LEFT JOIN crm_master_file AS F ON C.file_id=F.id WHERE '.$con_three.'';
                if($type == 1){
                    $sql = $purchase.' ORDER BY req_date DESC';
                }else if($type == 2){
                    $sql = $sales.' ORDER BY req_date DESC';
                }else{
                    $sql = $purchase.' UNION ALL '.$sales.' ORDER BY req_date DESC';
                }
                $model = Yii::app()->db->createCommand($sql)->queryAll();
                $stock = Store::model()->findBypk($product);
                //echo $sql;
                //print_r($model);
               // die();
                $this->render('history_table', array('model' => $model,'type' => $type,'stock' => $stock));
        }

}