<?php
class ExitController extends Controller
{
    public $layout = 'layout';
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','GetExitInvoiceList','GetCustomer','ExitInvoice','SaveExitInvoice','Print'
                            ,'PrintPP1','PrintPP2','PrintPP3','PrintLogo','updateExitInvoiceManifest','updateExitInvoiceTrucks'),
                                                'expression' => '$user->isMember()',
                ),
                array('deny', // deny all users
                        'users' => array('*'),
                ),
        );
    }
        public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
    public function actionIndex(){
        $this->render('index');
    }
    
    public function actionGetExitInvoiceList(){
        
        $model=new ExitInvoice();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
        1 =>'file_id',
        2 =>'customer_id',
        3 =>'invoice_date',
        4 =>'grand_total',
        5 =>'status',        
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.status="1"';
		
        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $from_date = ( count(explode('/', $_POST['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-d');
            $to_date = ( count(explode('/', $_POST['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-d');
            $condition .=' AND DATE(t.invoice_date)  BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        } else {
            $condition .= ' AND  t.invoice_date="' . date("Y-m-d") . '"';
        }


	  
		
        if(isset($_POST['search']['value']) && $_POST['search']['value']!=""){
        $searchString = $_POST['search']['value'];
          $condition.=" and (t.id LIKE '%".$searchString."%' OR t.shipment_reference LIKE '%".$searchString."%' OR customer.customer_name LIKE '%".$searchString."%' OR manifest LIKE '%".$searchString."%' OR trucks LIKE '%".$searchString."%' OR bill_of_lading LIKE '%".$searchString."%')";
        }
        $count = $model->with('customer')->count(array('condition'=>$condition));
        $model=$model->with('customer')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m = 1;
        foreach ($model as $row){
            
            $status  = "";
            $model_file  = MasterFile::model()->findbypk($row->file_id);
            if($model_file->current_process_status == 'I'){
                $status  = "Invoiced";
            }
            
            $div = '';
             if(Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn['exitinvoice_edit'])){
                $div .=   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'exit/ExitInvoice&id='.$row['id'].'\',\'Edit Exit Invoice\',\'xl\')"><i class="fa fa-pencil"></i></button>';
             }
            if(isset(Yii::app()->user->havePermissionOn['exitinvoice_pdf'])|| Yii::app()->user->authorised_user == 1){
                if($allPermissions->sales_exit_print_pp1 == 1)
                $div .=   ' <a class="btn btn-primary btn-xs" title="PP1" target="_blank" href="index.php?r=exit/PrintPP1&id=' . $row['id'] .'&logo=1 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                if($allPermissions->sales_exit_print_pp2 == 1)
                $div .=   ' <a class="btn btn-primary btn-xs" title="PP2" target="_blank" href="index.php?r=exit/PrintPP2&id=' . $row['id'] .'&logo=1 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                //$div .=   ' <a class="btn btn-primary btn-xs" title="PP3" target="_blank" href="index.php?r=exit/PrintPP3&id=' . $row['id'] .'&logo=1 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

                if(Yii::app()->user->mas_company_code == 'GLC001'){
                    $div .=   ' <a class="btn btn-primary btn-xs" title="Print With Logo New" target="_blank" href="index.php?r=exit/PrintLogo&id=' . $row['id'] .'"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                }
                $div .=   ' <a class="btn btn-primary btn-xs" title="Print With Logo" target="_blank" href="index.php?r=exit/Print&id=' . $row['id'] .'&logo=1"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                $div .=   ' <a class="btn btn-primary btn-xs" title="Print Without Logo" target="_blank" href="index.php?r=exit/Print&id=' . $row['id'] .'&logo=0 "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            //$div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'finance/receipt&type=EX&invoice=' . $row['id'] . '\',\'Add Receipt\',\'lg\')"><i class="fa fa-money"></i></button>';
            
            if(Yii::app()->user->mas_company_code=="ALMAS"){
                $rowData[]=array($m,'EX '.str_pad( $row['id'], 8, '0', STR_PAD_LEFT),$row['customer']['customer_name'],date("d/m/Y",strtotime($row['invoice_date'])),
                                    date("h:i A", strtotime($row['created_date'])),$row['bill_of_lading'],Yii::app()->numberFormatter->formatCurrency($row['total_vat_amount'],''),
                                    Yii::app()->numberFormatter->formatCurrency($row['grand_total'],''),'<div class="btn-wrap text-center">'.$div.'</div>');
            }
            else{
                
                $manifest_no = $row['manifest'];
                if(empty($row['manifest'])){
                    //get manifest details
                    
                    $modelManifest = ExitInvoiceManifestNo::model()->findAll(array('condition'=>'exit_invoice_id='.$row['id']));
                    
                    $manifest_no="";
                    foreach($modelManifest as $each_manifest){
                        if($manifest_no==""){
                            $manifest_no.=$each_manifest->manifest_no;
                        }
                        else{
                            $manifest_no.=", ".$each_manifest->manifest_no;
                        }
                    }
                }
                
                
                $rowData[]=array($m,'EX '.str_pad( $row['id'], 8, '0', STR_PAD_LEFT),$row['customer']['customer_name'],date("d/m/Y",strtotime($row['invoice_date'])),
                                    $manifest_no,$row['shipment_reference'],Yii::app()->numberFormatter->formatCurrency($row['total_vat_amount'],''),
                                    Yii::app()->numberFormatter->formatCurrency($row['grand_total'],''),'<div class="btn-wrap text-center">'.$div.'</div>');
            }
            
            $m++;
        
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionExitInvoice()
    {
        $id=(int) Yii::app()->request->getParam('id');
    	$model = new ExitInvoice();
    	$modelItem = array(new ExitInvoiceItem);
    	$modelTruckItem 	= array(new ExitInvoiceTruckNo);
    	$modelManifestItem	= array(new ExitInvoiceManifestNo);
    	
    	if($id > 0)
    	{
    		$model 				= ExitInvoice::model()->findByPk($id);
    		$modelItem 			= ExitInvoiceItem::model()->findAll(array('condition'=>'exit_invoice_id='.$id));
    		$modelTruckItem 	= ExitInvoiceTruckNo::model()->findAll(array('condition'=>'exit_invoice_id='.$id));
    		$modelManifestItem	= ExitInvoiceManifestNo::model()->findAll(array('condition'=>'exit_invoice_id='.$id));   		
    		$model->alias 		= $model->customer_id;
    	}
    	else 
    	{
            // $arr_prodcut_item_details	= Store::model()->findAll(array('condition'=>'mark_up > 0 AND is_default="Y"','order'=>'mark_up ASC'));
            $arr_prodcut_item_details	= Store::model()->findAll(array('condition'=>'is_exit_default="Y"','order'=>'mark_up ASC'));
    		$i=0;
            if(!empty($arr_prodcut_item_details)){
        		foreach($arr_prodcut_item_details as $i=>$product_item){
                             $modelItem[$i]=new ExitInvoiceItem();
                        if($product_item->item_code=='CL')
                        {
                         if((int)Yii::app()->request->getparam('customer_id'))
                         {
                          $cust=Customer::model()->findByPk((int)Yii::app()->request->getparam('customer_id'));
                          $modelItem[$i]['amount'] = $cust->exit_clearing_charges;
                          $modelItem[$i]['rate'] = $cust->exit_clearing_charges;
                         }   
                        }
        			$modelItem[$i]['product_id'] 		= $product_item->id;
        			$modelItem[$i]['product_name'] 		= $product_item->part_number;
        			$modelItem[$i]['description'] 		= $product_item->description;
        			$modelItem[$i]['quantity'] 			= 1;
        			$modelItem[$i]['item_code'] 		= $product_item->item_code;
        			$i++;
        		}
            }
    	}
    	
    	if((int)Yii::app()->request->getparam('customer_id'))
    	{
    		$customer_id = Yii::app()->request->getparam('customer_id');
    		 
    		$modelCustomer = new Customer();
    		 
    		$modelCustomer = Customer::model()->findByPk($customer_id);
    		 
    		$model->customer_id = $customer_id;
    		 
    		$model->customer_name = $modelCustomer->customer_name;
    		$model->alias = $modelCustomer->alias_name;
                $contact=CompanyContact::model()->findAll(array('condition'=>'crm_user_id='.$customer_id));
                foreach ($contact as $row)
                {
                $model->contact_id=$row->id;
                }
    	}
    	
    	Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
    	$this->renderPartial('exit_invoice_form', array('model' => $model, 'modelItem' => $modelItem, 'modelTruckItem' => $modelTruckItem, 'modelManifestItem' => $modelManifestItem), false, true);
    	
    }
    
    public function actionSaveExitInvoice()
    {
    	$model 				= new ExitInvoice();
    	$modelItem 			= array(new ExitInvoiceItem);
    	$modelTruckItem  	= array(new ExitInvoiceTruckNo);
    	$modelManifestItem 	= array(new ExitInvoiceManifestNo);
        
        
    	if (isset($_POST['ExitInvoice'])) {
    	
    		$model->scenario = 'add';
                date_default_timezone_set("Asia/Dubai");                    
    		if ((int) @$_POST['ExitInvoice']['id'] > 0){
                    $model=$model->findByPK((int) @$_POST['ExitInvoice']['id'] );
                    $model->scenario = 'update';
                       
                        $model->updated_by = Yii::app()->user->id;
                        $model->updated_date = date('Y-m-d H:i:s');
                }else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date=date('Y-m-d H:i:s');
                    $exist = ExitInvoice::model()->find(array('condition'=>'location_id='.Yii::app()->user->user_location,'order'=>'id DESC'));
                    if(empty($exist)){
                        $value = MasLocation::model()->findByPk(Yii::app()->user->user_location)->exit_start_no;
                    }else{
                        $value =$exist->invoice_no;
                    }
                    $model->invoice_no = $value;
                }
    		$model->attributes = $_POST['ExitInvoice'];
                
    		$other_errors = array();
    		$valid1 = true;
            
            if($_POST['ExitInvoice']['invoice_date']!='00/00/0000'){
                $model->invoice_date = str_replace('/', '-', $_POST['ExitInvoice']['invoice_date']);
                $model->invoice_date= date("Y-m-d H:i", strtotime($model->invoice_date));
            }
           
                
                $valid2 = true;
                $count=0;
    		foreach ($_POST['ExitInvoiceTruckNo'] as $i => $item) {
    			if (!empty($item['truck_no'])) {
    				$modelTruckItem[$i] = new ExitInvoiceTruckNo;
    				$modelTruckItem[$i]->attributes = $_POST['ExitInvoiceTruckNo'][$i];
    				$valid = $modelTruckItem[$i]->validate() && $valid;
                                $count++;
    			}
    		}
                
    		foreach ($_POST['ExitInvoiceItem'] as $i => $item) {
    			if (!empty($item['product_id'])) {
    				$modelItem[$i] = new ExitInvoiceItem;
    				$modelItem[$i]->attributes = $_POST['ExitInvoiceItem'][$i];
    		
                                //if($modelItem[$i]->product_id==3)
                                if($item['item_code']=='CL')
                                {
	                                $cust_id=$_POST['ExitInvoice']['customer_id'];
	//                                $count=count(array_filter($_POST['ExitInvoiceTruckNo']));
	                                $cust_mode=Customer::model()->findByPk($cust_id);
	                                switch($cust_mode->exit_refund_type)
	                                {
	                                        case 0:
	                                        	$commission=0;
	                                        	break;
	                                        case 1:
	                                        	$commission=$count*$cust_mode->exit_clearing_charges*$cust_mode->exit_refund_value/100;
	                                        	break;
	                                        case 2:
	                                        	//$commission=$count*$cust_mode->exit_refund_value;
	                                        	$commission=($count*$cust_mode->exit_clearing_charges) - ($count*$cust_mode->exit_refund_value);
	                                        	break;
	                                        case 3:
	                                        	$commission=($count*$cust_mode->exit_clearing_charges)-(($count*$cust_mode->exit_clearing_charges)-($count*$cust_mode->exit_refund_value));
	                                        	break;
	                                }
	                                $modelItem[$i]->commission =$commission;
                                }
                                $amount =$_POST['ExitInvoiceItem'][$i]['amount'];
                                $model_store= Store::model()->findByPk($modelItem[$i]->product_id);
                                $vat_amount=0.00;
                                $vat_start_date="01-01-2018";
                                $invoice_date    = date("d-m-Y",strtotime($_POST['ExitInvoice']['invoice_date']));
                                //if(strtotime($invoice_date)>= strtotime($vat_start_date)){
                                    $vat_amount=$_POST['ExitInvoiceItem'][$i]['vat'];;
                                    
                               // }    
                               if(!empty($vat_amount)){
                                $total_vat+=$vat_amount;
                               }
                                $modelItem[$i]->vat_amount =$vat_amount;
                                $modelItem[$i]->amount =$_POST['ExitInvoiceItem'][$i]['amount'];
                                
    				$valid = $modelItem[$i]->validate() && $valid;
    			}
    		}
    		$valid = is_array($modelItem) && $valid1;
    		
    		
    		$valid = is_array($modelItem) && $valid2;
    		
    		$valid3 = true;
    		foreach ($_POST['ExitInvoiceManifestNo'] as $i => $item) {
    			if (!empty($item['manifest_no'])) {
    				$modelManifestItem[$i] = new ExitInvoiceManifestNo;
    				$modelManifestItem[$i]->attributes = $_POST['ExitInvoiceManifestNo'][$i];
    				$valid = $modelManifestItem[$i]->validate() && $valid;
    			}
    		}
    		$valid = is_array($modelItem) && $valid2;
    		if ($model->validate() && $valid) {
                    $model->total_vat_amount=$total_vat;
    			$company_id = (int) $model->file_id > 0 ? $model->file->company_id : $model->customer_id;
                
                
                $model->location_id = Yii::app()->user->user_location;;
    	
    			$model->file_id = $this->masterFile($model->file_id, 'I', '', $company_id, 0);
    			$file_remarks = $_POST['Document']['file_remarks'];
    			$this->documents($model->file_id, 'I', $file_remarks);
    			if ((int) $_POST['ExitInvoice']['id'] != 0)
    				$model->id = $_POST['ExitInvoice']['id'];
    			$notification = false;
    			if ((int) $model->id == 0) {// if id 0 means its a new record, otherwise needs to update the existing one
                                $notification = ($model->file->is_approved == "N");
    				$model->save();
    			} else
    				$model->updateByPK($model->id, $model->attributes);
    	
    			$model_id = $model->id;
    			$model->refresh();
    			
    			/****************** Start Save data into Audit Log **************/
    			$arr_user_details = User::model()->findByPk(Yii::app()->user->id);
    			$user_full_name = $arr_user_details->first_name." ".$arr_user_details->last_name;
    			 
    			$modelAuditLog = new AuditLog();
    			if($model->id > 0)
    			{
    				$action_audit_log = "Exit Invoice [Invoice No: ".$model->id."] updated by ".$user_full_name." on ".date('d/m/Y')." at ".date('h:i A');
    			}
    			else
    			{
    				$action_audit_log = "New Exit Invoice [Invoice No: ".$model->id."] added by ".$user_full_name." on ".date('d/m/Y')." at ".date('h:i A');
    			}
    			
    			$modelAuditLog->form_id=3;
    			$modelAuditLog->created_by=Yii::app()->user->id;
    			$modelAuditLog->created_date_time=date('Y-m-d H:i:s');
    			$modelAuditLog->action=$action_audit_log;
    			 
    			$modelAuditLog->save(false);
    			
    			/****************** End Save data into Audit Log **************/
    			
    			
    	
    			
    			$grand_total = 0;
    			$jsonData['shoratage'] = "";
    			
    			if($model->id > 0)
    			{
		    		ExitInvoiceItem::model()->deleteAll('exit_invoice_id=:refer_id', array(':refer_id' => $model->id));
		    		ExitInvoiceTruckNo::model()->deleteAll('exit_invoice_id=:refer_id', array(':refer_id' => $model->id));
		    		ExitInvoiceManifestNo::model()->deleteAll('exit_invoice_id=:refer_id', array(':refer_id' => $model->id));
    			}
    			
    			foreach ($modelItem as $eachItem) {
    				$eachItem->exit_invoice_id = $model->id;
    				$eachItem->cost_rate = Store::model()->findByPk($eachItem->product_id)->rate;
    				$eachItem->save(false);
    				if(!empty($eachItem->amount)){
                        $grand_total += $eachItem->amount;
    				}
    				if(!empty($eachItem->vat_amount)){
                        $grand_total += $eachItem->vat_amount;
    				}
    				if(!empty($eachItem->quantity)){
    				    $invoiced_qty+=$eachItem->quantity;
    				}
    	
    			}
                $trucks = array();
                //$exit=ExitInvoice::model()->findByPk($model->id);
    			foreach ($modelTruckItem as $i=>$eachTruckItem) {
    				$eachTruckItem->exit_invoice_id = $model->id;
                    if(!empty($_POST['ExitInvoiceTruckNo'][$i]['truck_no'])){            
                        $trucks[$i] =$_POST['ExitInvoiceTruckNo'][$i]['truck_no'];
                    }
    				$eachTruckItem->save(false);
    				 
    			}
                $manifest = array();
    			foreach ($modelManifestItem as $i=>$eachManifestItem) {
    				$eachManifestItem->exit_invoice_id = $model->id;
                                //$exit=ExitInvoice::model()->findByPk($model->id);
                                if(!empty($_POST['ExitInvoiceManifestNo'][$i]['manifest_no'])){
                                    $manifest[$i] = $_POST['ExitInvoiceManifestNo'][$i]['manifest_no'];
                                }
                                //$exit->save();
    				$eachManifestItem->save(false);
    					
    			}
              /*  if( count($manifest) > 0 )
                    $exit->manifest = implode(',', $manifest);
                if( count($trucks) > 0 )
                    $exit->trucks = implode(',', $trucks);
                $exit->save();*/
    			/*foreach ($invoices as $eachInvoice)
    				$inoicedQantity+=$eachInvoice->netQuantity;
    			if ($orderedQuantity <= $inoicedQantity)
    				$this->masterFile($model->file_id, "I");*/
    			// $model->updateByPk($model->id, array('grand_total' => $grand_total));
    			//echo $grand_total;
    			$model->updateByPk($model_id, array('grand_total' => $grand_total,'manifest'=>implode(',', $manifest),'trucks'=>implode(',', $trucks)));
    			Yii::app()->session['file_id'] = $model->file_id;
    			$jsonData['file'] = $model->file_id;
    			$jsonData['model'] = $model;
    			$jsonData['status'] = 'success';
    			Yii::app()->session['company_id'] = $model->customer_id;
    			echo CJSON::encode($jsonData);
    		} else {
    			 
    			$error1 = json_decode(CActiveForm::validate($model, '', false), true);
    			if (is_array($modelItem))
    				$error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
    			else
    				$error2[] = "Please add atleast one line item";
    			
    			if (is_array($modelTruckItem))
    				$error3 = json_decode(CActiveForm::validateTabular($modelTruckItem, '', false), true);
    			else
    				$error3[] = "Please add atleast one truck details";
    			
    			if (is_array($modelManifestItem))
    				$error4 = json_decode(CActiveForm::validateTabular($modelManifestItem, '', false), true);
    			else
    				$error4[] = "Please add atleast one manifest details";
    			
    			$error = CJSON::encode(array_merge_recursive($error1, $error2, $error3,$error4, $other_errors));
    			if ($error != '[]')
    				echo $error;
    		}
    		Yii::app()->end();
    }
    
                }
        public function masterFile($file_id, $current_process_status, $title = "", $company_id = 0, $lead_owner_id = 0, $approval = "N") {
        $model_master_file = new MasterFile;
        Yii::app()->session['company_id'] = "";
        if ((int) $file_id == 0) {
            $model_master_file->crm_user_id = Yii::app()->user->id;
            $model_master_file->start_from = $model_master_file->current_process_status = $current_process_status;
            $model_master_file->company_id = $company_id;
            $model_master_file->lead_owner_id = $lead_owner_id;
            $model_master_file->file_title = $title;
            //$model_master_file->own_company_id = Yii::app()->user->master_user_company_id;
            $u_id = (int) ($lead_owner_id) > 0 ? lead_owner_id : (Yii::app()->user->id);
            //$model_master_file->own_branch_id = User::model()->findByPK($u_id)->branch_id;
            if ($approval == 'Y') {
                $model_master_file->is_approved = 'Y';
                $model_master_file->approved_by = Yii::app()->user->id;
                $model_master_file->date_of_approval = date('Y-m-d');
            }
            $model_master_file->save(false);
            $model_master_file->refresh();
            $file_id = $model_master_file->id;
        } else {
            $model_master_file = $model_master_file->findByPK($file_id);
            if ($approval == 'Y') {
                $arrayToBeUpdated['is_approved'] = 'Y';
                $model_master_file['approved_by'] = Yii::app()->user->id;
                $model_master_file['date_of_approval'] = date('Y-m-d');
            }
        }
        if ($model_master_file->priority($current_process_status) >= $model_master_file->priority($model_master_file->current_process_status))
            $arrayToBeUpdated['current_process_status'] = $current_process_status;
        if ($lead_owner_id != 0) {
            $arrayToBeUpdated['lead_owner_id'] = $lead_owner_id;
            //$arrayToBeUpdated['own_branch_id'] = User::model()->findByPK($lead_owner_id)->branch_id;
        }
        if (!empty($title))
            $arrayToBeUpdated['file_title'] = $title;
        if ((int) $company_id != 0) {
            $arrayToBeUpdated['company_id'] = $company_id;
            Yii::app()->session['company_id'] = $model_master_file->company_id;
        }

        $model_master_file->updateByPK($file_id, $arrayToBeUpdated);

        return $file_id;
    }
    public function actionPrint() {

        $model=new ExitInvoice();
        $id = Yii::app()->request->getParam('id');
        $logo = Yii::app()->request->getParam('logo');
        if($id>0){
            $model=$model->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.exit_invoice_logo', array('model' => $model, 'id' => $id, 'logo' => $logo),true));
        $mPDF1->Output("exit_invoice.pdf", 'I');
    }
    
    public function actionPrintPP1() {

        $model=new ExitInvoice();
        $id = Yii::app()->request->getParam('id');
        $logo = Yii::app()->request->getParam('logo');
        $modelmfno = new ExitInvoiceManifestNo();
        $modeltrucks = new ExitInvoiceTruckNo();
        if($id>0){
            $model=$model->findByPk($id);
            $modelmfno = $modelmfno->find(array('condition'=>'exit_invoice_id='.$id));
            $modeltruck = $modeltrucks->find(array('condition'=>'exit_invoice_id='.$id));
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.exit_invoice', array('model' => $model, 'id' => $id, 'logo' => $logo,'modelmfno'=>$modelmfno,'modeltruck'=>$modeltruck),true));
        $mPDF1->Output("exit_invoice.pdf", 'I');
    }
    public function actionPrintPP2() {

        $model=new ExitInvoice();
        $id = Yii::app()->request->getParam('id');
        $logo = Yii::app()->request->getParam('logo');
        $modelmfno = new ExitInvoiceManifestNo();
        $modeltrucks = new ExitInvoiceTruckNo();
        if($id>0){
            $model=$model->findByPk($id);
            $modelmfno = $modelmfno->find(array('condition'=>'exit_invoice_id='.$id));
            $modeltruck = $modeltrucks->find(array('condition'=>'exit_invoice_id='.$id));
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.exit_invoice_pp2', array('model' => $model, 'id' => $id, 'logo' => $logo,'modelmfno'=>$modelmfno,'modeltruck'=>$modeltruck),true));
        $mPDF1->Output("exit_invoice.pdf", 'I');
    }
    public function actionPrintPP3() {

        $model=new ExitInvoice();
        $id = Yii::app()->request->getParam('id');
        $logo = Yii::app()->request->getParam('logo');
        if($id>0){
            $model=$model->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.exit_invoice_pp3', array('model' => $model, 'id' => $id, 'logo' => $logo),true));
        $mPDF1->Output("exit_invoice.pdf", 'I');
    }
    public function actionPrintLogo() {

        $model=new ExitInvoice();
        $id = Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.exit_invoice_gulfcargo', array('model' => $model, 'id' => $id),true));
        $mPDF1->Output("exit_invoice_logo.pdf", 'I');
    }
    
    
    public function actionupdateExitInvoiceManifest(){
        $model=new ExitInvoice();
        
        $model = ExitInvoice::model()->findAll(array('condition'=>'manifest=""'));
        
        
        foreach($model as $row){
            
            $modelManifest=new ExitInvoiceManifestNo();
            
            $arr_manifest_details = $modelManifest->findAll(array('condition'=>'exit_invoice_id='.$row->id));
            
            $j=1;
            foreach($arr_manifest_details as $rowManifest){
                //echo $row->id."=".$rowManifest->manifest_no."<br>";
                
                if($rowManifest->manifest_no!=""){
                    $SQL_1='UPDATE crm_exit_invoice SET manifest="'.$rowManifest->manifest_no.'" WHERE id='.$rowManifest->exit_invoice_id;
                //echo $SQL_1."<br>";
                    Yii::app()->db->createCommand($SQL_1)->execute();
                    echo $j."<br>";
                    $j++;
                }
                
            }
            
           /* echo '<pre>';
            print_r($arr_manifest_details);*/
            
            
        }
        
    }
    
    public function actionupdateExitInvoiceTrucks(){
        $model=new ExitInvoice();
        
        $model = ExitInvoice::model()->findAll(array('condition'=>'trucks=""'));
        
        
        foreach($model as $row){
            
            $modelTruck=new ExitInvoiceTruckNo();
            
            $arr_truck_details = $modelTruck->findAll(array('condition'=>'exit_invoice_id='.$row->id));
            
            $j=1;
            foreach($arr_truck_details as $i=>$rowTruck){
                //echo $row->id."=".$rowTruck->truck_no."<br>";
                
                if($rowTruck->truck_no!=""){
                    $SQL_1='UPDATE crm_exit_invoice SET trucks="'.$rowTruck->truck_no.'" WHERE id='.$rowTruck->exit_invoice_id;
                echo $SQL_1."<br>";
                    Yii::app()->db->createCommand($SQL_1)->execute();
                    
                    $j++;
                    
                    echo $i."<br>";
                }
                
            }
            
            
            
        }
        
    }
          
}
