<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ExcelController
 *
 * @author Manu-Cumulus
 */
class ExcelController extends Controller {

    //put your code here

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('inventory','dailyentry','dailyexit','auditlog','AdminTransactionList','clearingTransactionList','TransactionList','RecieptofPayment','CustomerAdvancePayment'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionInventory() {

        $part_number = Yii::app()->request->getParam("id");
        $tax_code = Yii::app()->request->getParam("taxcode");
        $filename = 'inventory.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'part_number' => $part_number,
            'tax_code' => $tax_code
        );
        $this->renderPartial('inventory', $param);
        Yii::app()->end();
        return;
    }
    public function actionDailyEntry() {

        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id=Yii::app()->request->getParam("customer_name");
        $filename = 'dailyentry.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'customer_id' =>$customer_id
        );
        $this->renderPartial('//excel/dailyentry', $param);
        Yii::app()->end();
        return;
    }
    public function actionDailyExit() {

        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id=Yii::app()->request->getParam("customer_name");
        $filename = 'dailyexit.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'customer_id' =>$customer_id
        );
        $this->renderPartial('//excel/dailyexit', $param);
        Yii::app()->end();
        return;
    }
    public function actionAuditLog() {

        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $type=Yii::app()->request->getParam("type");
        $filename = 'auditlog.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'type' =>$type
        );
        $this->renderPartial('//excel/auditlog', $param);
        Yii::app()->end();
        return;
    }
	
	
    public function actionAdminTransactionList() {        
        $from_date = Yii::app()->request->getParam("from_date");        
        $to_date = Yii::app()->request->getParam("to_date");        
        $customer_id=Yii::app()->request->getParam("customer_id");        
        $shipper_id=Yii::app()->request->getParam("shipper_id");        
        $type=Yii::app()->request->getParam("type");        
        $payment=Yii::app()->request->getParam("payment");        
        $filename = 'admintransactionlist.xls';        
        header("Content-type: application/vnd.ms-excel");        
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");        
        $param = array(            
            'from_date' => $from_date,            
            'to_date' => $to_date,            
            'customer_id' =>$customer_id ,       
            'shipper_id' =>$shipper_id    ,    
            'type' =>$type      ,  
            'payment' =>$payment        
                );        
        $this->renderPartial('//excel/admin_transactionlist', $param);        
        Yii::app()->end();        
        return;    
        
    }
    public function actionClearingTransactionList() {        
        $from_date = Yii::app()->request->getParam("from_date");        
        $to_date = Yii::app()->request->getParam("to_date");        
        $type=Yii::app()->request->getParam("type");        
        $customer_id=Yii::app()->request->getParam("customer_id");        
        $shipper_id=Yii::app()->request->getParam("shipper_id");        
        $payment=Yii::app()->request->getParam("payment");        
        $filename = 'clearingtransactionlist.xls';        
        header("Content-type: application/vnd.ms-excel");        
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");        
        $param = array(            
            'from_date' => $from_date,            
            'to_date' => $to_date,            
            'customer_id' =>$customer_id ,       
            'type' =>$type ,       
            'shipper_id' =>$shipper_id ,       
            'payment' =>$payment        
                );        
        $this->renderPartial('//excel/clearing_transactionlist', $param);        
        Yii::app()->end();        
        return;    
        
    }			
    public function actionTransactionList() {        
        $from_date = Yii::app()->request->getParam("from_date");        
    $to_date = Yii::app()->request->getParam("to_date");        
    $type=Yii::app()->request->getParam("type");        
    $filename = 'transactionlist.xls';        
    header("Content-type: application/vnd.ms-excel");        
    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");        
    $param = array(            'from_date' => $from_date,            'to_date' => $to_date,            
        'customer_id' =>$customer_id        );        $this->renderPartial('//excel/transactionlist', $param);        
        Yii::app()->end();        return;    
        
    }
    public function actionRecieptofPayment() {        
        $from_date = Yii::app()->request->getParam("from_date");       
        $to_date = Yii::app()->request->getParam("to_date");        
        $type=Yii::app()->request->getParam("type");        
        $filename = 'recieptofpayment.xls';        
        header("Content-type: application/vnd.ms-excel");        
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");        
        $param = array(            
            'from_date' => $from_date,            
            'to_date' => $to_date,            
            'customer_id' =>$customer_id        );        
        $this->renderPartial('//excel/recieptof_payment', $param);        Yii::app()->end();        return;    
        
    }				
    public function actionCustomerAdvancePayment() {        
        $from_date = Yii::app()->request->getParam("from_date");        
        $to_date = Yii::app()->request->getParam("to_date");        
        $type=Yii::app()->request->getParam("type");        
        $filename = 'customeradvancepayment.xls';        
        header("Content-type: application/vnd.ms-excel");        
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");        
        $param = array(            
            'from_date' => $from_date,            
            'to_date' => $to_date,            
            'customer_id' =>$customer_id        
                );        
        $this->renderPartial('//excel/customer_advance_payment', $param);       
        Yii::app()->end();        
        return;    
        
    }	
}
