<?php

class DepositController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','Save','Delete'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new Deposit();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 => 't.id',
                   1 => 'cus.customer_name',
                   2 => 't.invoice_no',
                   3 => 't.bill_of_entry',
                   4 => 't.amount',
                   5 => 't.issued_date', 
                   6 => 't.expiry_date',
                   7 => 't.id'
                );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="cus.customer_name LIKE '%".$searchString."%' OR t.invoice_no  LIKE '%".$searchString."%' OR t.bill_of_entry  LIKE '%".$searchString."%'";
                }
                $count = $model->with('cus')->count(array('condition'=>$condition));
                $model=$model->with('cus')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id DESC'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                foreach ($model as $row)
                {
                    $div = '';
                    if( $row->isActive == 'Y' )
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'deposit/create&id='.$row['id'].'\',\'Edit Deposit\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    $rowData[]=array($row['id'] , $row['cus']['customer_name'], $row['invoice_no'], $row['bill_of_entry'], $row['amount'], date('d/m/Y', strtotime($row['issued_date'])), ($row['expiry_date']!="0000-00-00")?date('d/m/Y', strtotime($row['expiry_date'])):"", '<div class="btn-wrap text-center">'.$div.'</div>');
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new Deposit();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model), false, false);
        }
  
  
        public function actionSave()
        {
            $model = new Deposit();
       
    		    if ((int) @$_POST['Deposit']['id'] > 0){
                    $id= (int) @$_POST['Deposit']['id'];
                    $model=$model->findByPk($id);  
                }else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_datetime = date('Y-m-d h:i:s');
                }
                $model->attributes=$_POST['Deposit'];
                
                $model->statement_no            = $_POST['Deposit']['statement_no'];
                $model->receipt_no              = $_POST['Deposit']['receipt_no'];
                $model->collected_cheque_no     = $_POST['Deposit']['collected_cheque_no'];
                $model->delivered_cheque_no     = $_POST['Deposit']['delivered_cheque_no'];


                $model->issued_date = ( count( explode('/', $_POST['Deposit']['issued_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Deposit']['issued_date']) )) : '';
                $model->expiry_date =  ( count( explode('/', $_POST['Deposit']['expiry_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Deposit']['expiry_date']) )) : '';
                $model->doc_submitted_date =  ( count( explode('/', $_POST['Deposit']['doc_submitted_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Deposit']['doc_submitted_date']) )) : '';
                $model->customs_submitted_date =  ( count( explode('/', $_POST['Deposit']['customs_submitted_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Deposit']['customs_submitted_date']) )) : '';
                $model->payment_collection_date = ( count( explode('/', $_POST['Deposit']['payment_collection_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Deposit']['payment_collection_date']) )) : '';
                $model->payment_delivery_date =  ( count( explode('/', $_POST['Deposit']['payment_delivery_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Deposit']['payment_delivery_date']) )) : '';

                /*if( $model->payment_delivery_date != '')
                    $model->isActive = 'N';*/
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
	                    echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            
        }
}