<?php

class CustomerController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetCustomerList', 'Create', 'SaveCustomer',
                    'GetDocsList', 'CreateDocumentForm', 'UploadCustomerDocuments', 'SaveDocForm', 'GetContactList', 'CustomerContactCreate', 'SaveContact',
                    'Getcustomer','DownloadDoc'
//                    'getNotesList','SaveNote','CreateNote','CreateEditCustomer' ,'SaveEditedCustomer','SaveAgents',  'Delete', 'SaveCompany',   'DeleteContact', 'DeleteCustomer',
//                     'GetCustomerActivity','AddNote','DownloadDocument',
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $model = new Customer();

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    /*
     * function to list all customers
     *
     */

    public function actionGetCustomerList() {
        $model = new Customer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'customer_name',
            2 => 'location',
            3 => 'phone',
            4 => 'customs_code',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        //$orderBy = $filterColumn . " " . $filterOrder;
        $orderBy = "t.customer_name ASC";
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (customer_name LIKE '%" . $searchString . "%' OR location LIKE '%" . $searchString . "%' OR phone LIKE '%" . $searchString . "%' OR customs_code LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $current = strtotime(date('y-m-d'));
        foreach ($model as $row) {
            $div = '';
            $colour = 0;
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_edit"])) {
                $div .= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'customer/create&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['customer_name'] . '\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            $rowData[] = array($row['id'], substr($row['customer_name'], 0, 45), $row['location'], $row['phone'], $row['customs_code'], '<div class="btn-wrap text-center">' . $div . '</div>', $colour, $row['status']);

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create customer details
     */

    public function actionCreate() {
        $model = new Customer();
        $model_contact = new CustomerContact();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('customer_form', array('model' => $model, 'model_contact' => $model_contact));
    }

    // function to save customer details


    function actionSaveCustomer() {
        $model = new Customer();
        $modelcontact = new CustomerContact();
        $modeldoc = new Document();
        //START Code for Save **************
        if (isset($_POST['Customer'])) {

            if ($_POST['Customer']['id'] > 0) {
                $id = $_POST['Customer']['id'];
                $model = $model->findByPK($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d h:i:s');
                $scene = 'update';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date = date('Y-m-d h:i:s');
                $scene = 'new';
            }
            $model->attributes = $_POST['Customer'];
            $model->customer_type = $_POST['Customer']['customer_type'];
            $model->status = $_POST['Customer']['status'];

            $model->other_notes = $_POST['Customer']['other_notes'];
            $model->entry_clearing_charges = $_POST['Customer']['entry_clearing_charges'];
            $model->exit_clearing_charges  = $_POST['Customer']['exit_clearing_charges'];
            $valid = $model->validate();

            if ($_POST['CustomerContact']) {

                $modelcontact->attributes = $_POST['CustomerContact'];
                $modelcontact->company_id = 0;
                $modelcontact->isActive = $_POST['CustomerContact']['isActive'];
                $modelcontact->crm_user_id = Yii::app()->user->id;
                $valid = $modelcontact->validate() && $valid;
            }
            if ($valid) {
                $exist = Customer::model()->find();

                if ( (int) $exist->id == 0 ) {
                    
                    Yii::app()->db->createCommand("ALTER TABLE crm_customer AUTO_INCREMENT=1001")->query();
                }
           
                $model->save();
                /*                 * **************** Start Save data into Audit Log ************* */
                $arr_user_details = User::model()->findByPk(Yii::app()->user->id);
                $user_full_name = $arr_user_details->first_name . " " . $arr_user_details->last_name;

                $modelAuditLog = new AuditLog();
                if ($model->id > 0) {
                    $action_audit_log = "Customer [Customer No: " . $model->id . "] updated by " . $user_full_name . " on " . date('d/m/Y') . " at " . date('h:i A');
                } else {
                    $action_audit_log = "New Customer [Customer No: " . $model->id . "] added by " . $user_full_name . " on " . date('d/m/Y') . " at " . date('h:i A');
                }
                $modelAuditLog->form_id = 1;
                $modelAuditLog->created_by = Yii::app()->user->id;
                $modelAuditLog->created_date_time = date('Y-m-d H:i:s');
                $modelAuditLog->action = $action_audit_log;

                $modelAuditLog->save();

                /*                 * **************** End Save data into Audit Log ************* */
                if ($scene == 'new') {
                    $this->addSubledger(1, $model->id, $_POST['Customer']['customer_name']);
                    $modelcontact->company_id = $model->id;
                    $modelcontact->save(false);
                   
                }




                if ($_POST['Document']['document'] != '') {
                    $modeldoc->document = $_POST['Document']['document'];
                    $modeldoc->file_remarks = $_POST['Document']['file_remarks'];
                    $modeldoc->created_date = date("Y-m-d");
                    $modeldoc->created_by = Yii::app()->user->id;
                    $modeldoc->customer_id = $model->id;
                    $modeldoc->uploaded_from = 'CU';
                    $modeldoc->file_id = '0';
                    $modeldoc->isActive = 'Y';
                    $modeldoc->save(false);
                }

                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['customer_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
                
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($modelcontact, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetDocsList() {
        $model = new Document();
        $vendor_id = $_POST['vendor_id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'document_name',
            2 => 'created_date',
            3 => 'file_remarks',
            4 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if ($vendor_id > 0) {
            $condition = 't.customer_id=' . $vendor_id;
        } else {
            $condition = '1=1';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.document_name LIKE '%" . $searchString . "%' OR t.file_remarks LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {

            $edit = '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'customer/createDocumentform&id=' . $row['id'] . '&c_id=' . $row['customer_id'] . '\',\'Edit Document\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            $download = '<button class="btn btn-primary btn-xs" title ="Download" onclick="return DownloadDoc(' . $row['id'] . ', ' . $row['customer_id'] . ')"><i class="fa fa-download"></i></button> ';
            $button = $edit . $download;
            $rowData[] = array($m, $row['document_name'], date("d/m/Y", strtotime($row['created_date'])), $row['file_remarks'], $button);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreateDocumentForm() {

        $model = new Customer();
        $modeldoc = new Document();
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $modeldoc = $modeldoc->findByPk($id);
            $customer_id = $modeldoc->customer_id;
            $model = $model->findByPk($customer_id);
        }
        if ($customer_id > 0) {
            $model = $model->findByPk($customer_id);
            $modeldoc->customer_id = $customer_id;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('doc_form', array('model' => $model, 'modeldoc' => $modeldoc, 'c_id' => $customer_id));
    }

    public function actionSaveDocForm() {
        $model = new Document();
        $id = $_POST['Document']['id'];
        if ($_POST['Document']['id'] > 0) {
            $model = $model->findByPk($id);
        }
        $model->attributes = $_POST['Document'];
        $model->customer_id = $_POST['Document']['customer_id'];
        $model->document = $_POST['Document']['document'];
        $model->file_remarks = $_POST['Document']['file_remarks'];
        $model->created_date = date("Y-m-d");
        $model->created_by = Yii::app()->user->id;
        $model->uploaded_from = 'CU';
        $model->file_id = '0';
        $model->isActive = 'Y';
        if ($model->save()) {
            $jsonData['status'] = 'success';
            $jsonData['frm'] = $_POST['CustomerDocs'];
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);
        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]')
                echo $error;
        }
    }

    // function to list customer conatcts


    function actionGetContactList() {
        $model = new CustomerContact();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $customer_id = $_POST['customer_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'person_name',
            1 => 'designation',
            2 => 'ph_no',
            3 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.company_id = "' . $customer_id . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (person_name LIKE '%" . $searchString . "%' OR designation LIKE '%" . $searchString . "%' OR ph_no LIKE '%" . $searchString . "%')";
        }
        $or = 't.isActive';
        $count = $model->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $or));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {


            $st = "Blocked";
            if ($row['isActive'] == "Y") {
                $st = "Active";
            }

            $rowData[] = array($row['person_name'], $row['designation'], $row['ph_no'], $st,
                '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'customer/customercontactcreate&id=' . $row['id'] . '&c_id=' . $row['company_id'] . '\',\'Edit Contact\',\'lg\')"><i class="fa fa-pencil"></i></button></div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    // function to create customer contact using modal pop up


    public function actionCustomerContactCreate() {

        $model_contact = new CustomerContact();
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $model_contact = $model_contact->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('contact_form', array('model_contact' => $model_contact, 'c_id' => $customer_id));
    }

    // function to save customer contact


    public function actionSaveContact() {
        $model = new CustomerContact();
        //         * ********** START Code for Save **************
        if (isset($_POST['CustomerContact'])) {

            if ($_POST['CustomerContact']['id'] > 0) {
                $id = $_POST['CustomerContact']['id'];
                $model = $model->findByPK($id);
            }
            $model->company_id = $_POST['hid_customer_id'];
            $model->attributes = $_POST['CustomerContact'];
            $model->isActive = $_POST['CustomerContact']['isActive'];
            $model->crm_user_id = Yii::app()->user->id;
            if ($model->save(false)) {
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['customer__form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetCustomer() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'customer_name LIKE "%' . $searchTerm . '%" AND t.status="1"';
        $model = new Customer();
        $model = $model->with('country')->findAll(array('select' => 't.id,t.customer_name,payment_terms,address,
            city,po_box,country', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            //$modshipaddress = CompanyShippingDetails::model()->findByPk($eachModel->id);
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->customer_name;
            $adds = $po = $city = '';
            if ($eachModel->address != '')
                $adds = $eachModel->address . PHP_EOL;
            if ($eachModel->po_box != '')
                $po = 'PO Box : ' . $eachModel->po_box . PHP_EOL;
            if ($eachModel->city != '')
                $city = $eachModel->city . PHP_EOL;
            $data[$i]['address'] = $adds . $po . $city . $eachModel->country->country_name;
            $data[$i]['billaddress'] = $adds . $po . $city . $eachModel->country->country_name;

            $data[$i]['payment_term'] = $eachModel->payment_terms;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    /* public function actionCreateEditCustomer() {
      $model = new Customer();
      $model_contact = new CustomerContact();
      $id = (int) Yii::app()->request->getParam('id');
      $flag=(int) Yii::app()->request->getParam('flag');
      if ($id > 0) {
      $model = $model->findByPk($id);
      }
      Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
      $this->render('customer_form_2', array('model' => $model, 'model_contact' => $model_contact,'flag'=>$flag));
      }
      public function actionCreateNote() {

      $model = new Customer();
      $modelnote = new Activity();
      $id = (int) Yii::app()->request->getParam('id');

      if ($id > 0) {
      $model= $model->findByPk($id);
      $var = $model->id;
      }

      Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
      $this->render('notes_details_2', array('model' => $model,'modelnote' => $modelnote,'var' => $var));
      }
      public function actionAddNote() {

      $model = new Customer();
      $modelnote = new FileNotes();
      $id = (int) Yii::app()->request->getParam('id');

      if ($id > 0) {
      $model= $model->findByPk($id);
      $var = $model->id;
      }

      Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
      $this->render('notes_details_3', array('model' => $model,'modelnote' => $modelnote,'var' => $var));
      }






      public function actiongetNotesList() {
      $model = new Activity();
      $vendor_id = $_POST['vendor_id'];
      $draw = $_POST['draw'];
      $offset = $_POST['start'];
      $limit = $_POST['length'];
      $columns = array(
      // datatable column index  => database column name
      0 => 'notes',

      );
      $filterColumn = $columns[$_POST['order'][0]['column']];
      $filterOrder = $_POST['order'][0]['dir'];
      $orderBy = $filterColumn . " " . $filterOrder;
      $condition = 't.company_id=' . $vendor_id . ' AND typ_of_activity="N"';
      if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
      $searchString = $_POST['search']['value'];
      $condition.=" AND (notes LIKE '%" . $searchString . "%')";
      }
      $count = $model->count(array('condition' => $condition));
      $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'created_datetime DESC'));
      $recordsTotal = $count;
      $recordsFiltered = $count;
      $data['draw'] = $draw;
      $data['recordsTotal'] = $recordsTotal;
      $data['recordsFiltered'] = $recordsFiltered;
      $rowData = array();
      $m = 1;
      foreach ($model as $row) {
      $model2 = User::model()->find(array('condition'=>'t.id = "'.$row['crm_user_id'].'"'));
      $rowData[] = array($m, $row['notes'],$model2->username,date("d/m/Y h:m:s",strtotime($row['created_datetime'])));
      $m++;

      }
      $data['data'] = $rowData;
      echo json_encode($data);
      }

      function actionSaveEditedCustomer() {
      $model = new Customer();

      if (isset($_POST['Customer'])) {

      if ($_POST['Customer']['id'] > 0) {
      $id =  $_POST['Customer']['id'];
      $model = $model->findByPK($id);
      $model->updated_by = Yii::app()->user->id;
      $model->updated_date_time =date('Y-m-d h:i:s');
      } else {
      // $model->crm_user_id = Yii::app()->user->id;
      $model->created_by = Yii::app()->user->id;
      $model->created_date_time = date('Y-m-d h:i:s');

      }
      $model->attributes = $_POST['Customer'];
      $model->isActive = "Y";

      //$model->notes = $_POST['Customer']['notes'];

      if($model->validate()){
      $model->save();




      $jsonData['status'] = 'success';
      $jsonData['frm'] = $_POST['customer_form_2'];
      $jsonData['id'] = $model->id;
      echo CJSON::encode($jsonData);

      } else {

      $error = CActiveForm::validate($model, '', false);

      if ($error != '[]')

      echo $error;


      }
      }
      }
      public function actionSaveNote() {
      $model = new Activity();
      date_default_timezone_set("Asia/Dubai");
      $date = date("Y-m-d h:i:s");
      if (isset($_POST['Activity'])) {
      $model->attributes = $_POST['Activity'];
      $model->crm_user_id=Yii::app()->user->id;
      $model->created_by = Yii::app()->user->id;
      $model->created_datetime = $date;
      $model->company_id = $_POST['Activity']['company_id'];
      $model->typ_of_activity="N";
      //$model->notes = $_POST['CustomerContact']['notes'];
      if ($model->save()) {
      //die();
      $jsonData['status'] = 'success';
      $jsonData['frm'] = $_POST['notes_details_2'];
      $jsonData['id'] = $model->id;
      echo CJSON::encode($jsonData);

      } else {
      $error = CActiveForm::validate($model, '', false);
      if ($error != '[]')
      echo $error;
      }
      }
      }







      public function actionDeleteContact() {
      $id = $_POST['id'];
      $model = new CustomerContact();
      $model->deleteByPk($id);
      echo "success";
      }

      // function to delete customer


      public function actionDeleteCustomer() {
      $id = $_POST['id'];
      $model = Customer::model()->findByPk($id);
      if (!empty($model)) {
      $model->isActive = "N";
      $model->save(false);
      echo "success";
      } else {
      echo "fail";
      }
      }


      public function actionGetCustomers() {
      $from = $_GET['frm'];
      $searchTerm = $_GET['term'];
      $condition = 'customer_name LIKE "%' . $searchTerm . '%"';
      $model = new Customer();
      $model = $model->with('currency_detail', 'country')->findAll(array('select' => 't.id,t.customer_name,customer_currency_id,customer_payment_term,address,
      customer_city,po_box,customer_country', 'condition' => $condition));
      $i = 0;
      foreach ($model as $eachModel) {
      $data[$i]['value'] = $eachModel->id;
      $data[$i]['label'] = $eachModel->customer_name;
      $data[$i]['address'] = $eachModel->address . ", PO Box : " . $eachModel->po_box . "," . $eachModel->customer_city . "," . $eachModel->country->country_name;
      $data[$i]['currency'] = $eachModel->currency_detail->currency;
      $data[$i]['currency_id'] = $eachModel->currency_detail->id;
      $data[$i]['exchangerate'] = $eachModel->currency_detail->exchange_rate;
      $data[$i]['payment_term'] = $eachModel->customer_payment_term;
      $i++;
      }
      echo CJSON::encode($data);
      Yii::app()->end();
      }

      public function actionGetCustomerActivity() {
      $contact_id = $_POST['contact_id'];
      $customer_id = $_POST['customer_id'];
      $file_id = $_POST['file_id'];
      if ($contact_id != '' && $file_id != '') {
      $model = Activity::model()->findAll(array('condition' => 'contact_id="' . $contact_id . '" and file_id=' . $file_id, 'order' => 'id desc'));
      } else if ($contact_id == '' && $file_id != '') {
      $model = Activity::model()->findAll(array('condition' => 'file_id=' . $file_id, 'order' => 'id desc'));
      } else if ($contact_id != '' && $file_id == '') {
      $model = Activity::model()->findAll(array('condition' => 'contact_id=' . $contact_id, 'order' => 'id desc'));
      } else if ($contact_id == '' && $file_id == '') {
      $model = Activity::model()->findAll(array('condition' => 'customer_id="' . $customer_id . '"', 'order' => 'id desc'));
      }
      $this->render('//activity/activity_history_new', array('model' => $model, 'contact_id' => $contact_id));
      }

      public function actionSetMenu() {
      echo Yii::app()->session['selected_menu'] = $_POST['menu_name'];
      }
      public function actionDownloadDocument() {
      $id = (int) Yii::app()->request->getParam('id');
      $arr_employee_doc = CustomerDocs::model()->findByPk($id);
      $file = $arr_employee_doc->document;
      $arr_doc_val = explode(',', $arr_employee_doc->document);
      $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
      header("Content-type:application/octet-stream"); //for txt file
      header("Content-Type: application/download");
      //header('Content-Type:text/plain; charset=ISO-8859-15');
      //if you want to read text file using text/plain header
      header('Content-Disposition: attachment; filename="' . basename($path) . '"');
      header('Content-Length: ' . filesize($path));
      readfile($path);
      Yii::app()->end();
      }

     */

    public function actionDownloadDoc() {
        $id = $_GET['id'];
        $model = Document::model()->findByPk($id);
        $upload_path = 'uploads/documents/';
        $name = $model->document;
        if (file_exists($upload_path . $name)) {
            Yii::app()->getRequest()->sendFile($name, file_get_contents($upload_path . $name));
        } else {
            $this->render('download404');
        }
    }

}
