<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity {

    private $_id;
    public $code;

    public function __construct($username, $password, $code)
    {
        $this->username = $username;
        $this->password = $password;
        $this->code = $code;
    }

    /**
     * Authenticates a user.
     * @return boolean whether authentication succeeds.
     */
    public function authenticate() {
        $username = strtolower($this->username);
        $code = MasCompany::getCode($this->code);
        
        
        //$password = crypt($this->password, $this->password);
        //START Code modified on 08-04-2016 for secured password
        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password = crypt($this->password, $salt);
        //END Code modified on 08-04-2016 for secured password
        $user = User::model()->find('LOWER(username)=? AND isActive=? AND company_id=?', array($username, 'Y',$code));
       
        if ($user == null)
            $this->errorCode = self::ERROR_USERNAME_INVALID;
        else if ($user->password != $password)
            $this->errorCode = self::ERROR_PASSWORD_INVALID;
        else {
            /* if((UserTypes::model()->findByPk( $user->type_id )->type) == 'admin' || (UserTypes::model()->findByPk( $user->type_id )->type)=='superadmin') // This is admin login
              {
              $this->setStateKeyPrefix('admin_');
              }
              else
              {
              $this->setStateKeyPrefix('front_');
              } */
            $this->_id = $user->id;
            $this->setState('fullname', $user->fullname);
            $this->setState('master_user_company_id', $user->company_id);
            $this->setState('master_user', ($user->isMaster == 'Y') ? true : false);
            //$this->setState('master_user_branch_id', $user->branch_id);
            /*if(isset($user->ownBranch->branch_name))
            $this->setState('user_branch', $user->ownBranch->branch_name);
            else*/
            $this->setState('user_branch', "");
            $this->setState('user_email_id', $user->email);
            $this->setState('user_location', $user->location_id);
            
            //$this->setState('company_logo', $user->own_company->company_logo);
            //$company_branch_id		=	$user->branch_id;
            //$company_branch_id		=	$userGroups{0}->company_branch_id;
            //$user_group_parent_id	=	$userGroups{0}->parent_id;
            $authorised_user		=	0;
            //if($company_branch_id==0 && $user_group_parent_id==0)
            if($user->level==0)
            $authorised_user		=	1;
            
            $this->setState('authorised_user', $authorised_user);
            //$arr_company = MasCompany::model()->findAll('id='.$user->company_id);
            $arr_company = MasCompany::getMasCompanyDetails($user->company_id);
//            echo '<pre>';
//            print_r($arr_company);
//             echo '</pre>';
            $master_company_name	=	$arr_company->company_name;
            $company_db_name		=	$arr_company->company_db_name;
            $company_head_user		=	$arr_company->crm_user_id;
            $company_logo		    =	$arr_company->company_logo;
            $footer_line_1              =       $arr_company->footer_line_one;
            $footer_line_2              =       $arr_company->footer_line_two;
            $auto_generated             =       $arr_company->footer_autogenerated;
            $fin_year                   =       $arr_company->fin_year;
           
            $this->setState('master_company_name', $master_company_name);
            $this->setState('main_db_name', 'blskymine_logistics_main');
            $this->setState('company_db_name', trim($company_db_name));
            $this->setState('company_head_user', trim($company_head_user));
            $this->setState('company_logo', $company_logo);
            $this->setState('pdf_company_logo', "pdf_".$company_logo);
            $this->setState('master_company_name', $master_company_name);
            $this->setState('footer_line_1', $footer_line_1);
            $this->setState('footer_line_2', $footer_line_2);
            $this->setState('footer_autogenerated', $auto_generated);
            $this->setState('fin_year', $fin_year);
            $this->setState('default_currency_id', $arr_company->currency_id);
            $this->setState('mas_company_code', $arr_company->company_code);
            /**
            * Expiry date setup
            * by Jo~
            */
            $remind = $expired = $message = 0;
            if( strtotime($arr_company->cut_off_date) <= strtotime(date('Y-m-d')) ){
                $expired = 1;
                $message = $arr_company->cut_off_msg;
            }else if( strtotime($arr_company->reminder_date) <= strtotime(date('Y-m-d'))){
                $remind = 1;
                $message = $arr_company->reminder_msg;
            }
            $this->setState('message', $message);
            $this->setState('expired', $expired);
            $this->setState('remind', $remind);
            //End
           
            if(isset($arr_company->genral_email))
                $this->setState('company_general_email', $arr_company->genral_email);
            else
                $this->setState('company_general_email', "test@mailbluesky.com");
            
            if(isset($arr_company->genral_web))
                $this->setState('company_general_web', $arr_company->genral_web);
            else
                $this->setState('company_general_web', "");
            
            if(isset($arr_company->genral_phno))
                $this->setState('company_general_phone_no', $arr_company->genral_phno);
            else
                $this->setState('company_general_phone_no', "");
           
	        if($company_db_name !="" || $user->isMaster == 'Y')
	        {
                if($user->isMaster == 'N'){
                    Yii::app()->db->setActive(false);
                    Yii::app()->db->connectionString = 'mysql:host=localhost;dbname='.$company_db_name;
                    Yii::app()->db->tablePrefix = 'crm_';
                    Yii::app()->db->setActive(true);
                    $userGroups = MasUserGroup::model()->findAll('id in (' . $user->user_group_id . ')');
                    $permissionArray = array();
                        foreach ($userGroups as $eachUserGroup) {
                            if (!empty($eachUserGroup->permissions)) {
                                $permissionArray = CJSON::decode($eachUserGroup->permissions);
                                $formatted_array = array_map(function($num) {
                                            return (is_numeric(trim($num)) ? number_format(floatval($num), 0, '', '') : $num);
                                        }, $permissionArray);
                            }
                        }
                    $this->setState('havePermissionOn', array_merge($formatted_array));
                }
	            $this->username = $user->username;
            	$this->errorCode = self::ERROR_NONE;
	        }
	        else
	        {
	        	$this->errorCode = 'You are not authorized person';
	        }
            
        }
        return $this->errorCode == self::ERROR_NONE;
    }

    public function getId() {
        return $this->_id;
    }

}