DROP TABLE ageing;

CREATE TABLE `ageing` (
  `invoice_id` int(11) NOT NULL,
  `subledger` int(11) NOT NULL,
  `date` date NOT NULL,
  `voucher_no` varchar(255) NOT NULL,
  `debit` decimal(15,2) NOT NULL,
  `credit` decimal(15,2) NOT NULL,
  `db` decimal(15,2) NOT NULL,
  `cr` decimal(15,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;




DROP TABLE crm_advance;

CREATE TABLE `crm_advance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `advance` int(11) NOT NULL,
  `advance_date` date NOT NULL,
  `remarks` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;




DROP TABLE crm_advance_payment;

CREATE TABLE `crm_advance_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `total_received_amount` decimal(15,2) NOT NULL,
  `company_id` int(11) NOT NULL,
  `pending_amount` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;




DROP TABLE crm_advance_payment_details;

CREATE TABLE `crm_advance_payment_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `advance_payment_id` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `received_date` date NOT NULL,
  `mode_of_payment` varchar(255) NOT NULL,
  `realisation_date` date NOT NULL,
  `ref_number` int(11) NOT NULL,
  `notes` text NOT NULL,
  `remarks` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;




DROP TABLE crm_appointment;

CREATE TABLE `crm_appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fname` varchar(255) NOT NULL,
  `lname` varchar(255) NOT NULL,
  `mob` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `app_date` varchar(255) NOT NULL,
  `app_time` varchar(255) NOT NULL,
  `app_type_id` int(11) NOT NULL,
  `confirmed` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:not confirmed, 1:confirmed',
  `completed` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:not completed, 1:completed',
  `created_date` varchar(255) NOT NULL,
  `updated_date` varchar(255) NOT NULL,
  `created_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;




DROP TABLE crm_appointment_type;

CREATE TABLE `crm_appointment_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_type` varchar(225) NOT NULL,
  `is_active` enum('Y','N') NOT NULL DEFAULT 'Y',
  `created_date` varchar(255) NOT NULL,
  `updated_date` varchar(255) NOT NULL,
  `created_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;




DROP TABLE crm_approval_history;

CREATE TABLE `crm_approval_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `status` enum('Y','N') NOT NULL,
  `action_by` int(11) NOT NULL,
  `profit` varchar(255) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;




DROP TABLE crm_audit_log;

CREATE TABLE `crm_audit_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_date_time` datetime NOT NULL,
  `action` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=102549 DEFAULT CHARSET=utf16 COLLATE=utf16_persian_ci;

INSERT INTO crm_audit_log VALUES("2218","1","1","2018-12-11 11:27:04","Customer [Customer No: 237] updated by - - on 11/12/2018 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("2219","1","1","2018-12-11 11:27:14","Customer [Customer No: 237] updated by - - on 11/12/2018 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("2220","2","1","2018-12-11 11:32:08","Entry Invoice [Invoice No: 19823] updated by - - on 11/12/2018 at 11:32 AM");
INSERT INTO crm_audit_log VALUES("2221","2","6","2018-12-23 13:51:35","Entry Invoice [Invoice No: 19824] updated by ASHRAF  M K on 23/12/2018 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("2222","2","6","2018-12-23 13:53:13","Entry Invoice [Invoice No: 19824] updated by ASHRAF  M K on 23/12/2018 at 01:53 PM");
INSERT INTO crm_audit_log VALUES("2223","2","7","2018-12-23 14:04:57","Entry Invoice [Invoice No: 19824] updated by ALSED ABU SHAMA on 23/12/2018 at 02:04 PM");
INSERT INTO crm_audit_log VALUES("2224","2","6","2018-12-24 12:34:48","Entry Invoice [Invoice No: 19824] updated by ASHRAF  M K on 24/12/2018 at 12:34 PM");
INSERT INTO crm_audit_log VALUES("2225","2","3","2018-12-24 12:35:53","Entry Invoice [Invoice No: 19824] updated by JAMAL JAMAL on 24/12/2018 at 12:35 PM");
INSERT INTO crm_audit_log VALUES("2226","3","1","2018-12-26 13:12:04","Exit Invoice [Invoice No: 118041] updated by - - on 26/12/2018 at 01:12 PM");
INSERT INTO crm_audit_log VALUES("2227","3","4","2018-12-31 16:01:18","Exit Invoice [Invoice No: 118042] updated by Yasir  Rahman on 31/12/2018 at 04:01 PM");
INSERT INTO crm_audit_log VALUES("2228","3","11","2018-12-31 16:25:49","Exit Invoice [Invoice No: 118043] updated by GAREEB GAREEB on 31/12/2018 at 04:25 PM");
INSERT INTO crm_audit_log VALUES("2229","3","11","2018-12-31 18:58:40","Exit Invoice [Invoice No: 118044] updated by GAREEB GAREEB on 31/12/2018 at 06:58 PM");
INSERT INTO crm_audit_log VALUES("2230","3","6","2018-12-31 20:00:02","Exit Invoice [Invoice No: 118042] updated by ASHRAF  M K on 31/12/2018 at 08:00 PM");
INSERT INTO crm_audit_log VALUES("2231","3","6","2018-12-31 20:01:21","Exit Invoice [Invoice No: 118042] updated by ASHRAF  M K on 31/12/2018 at 08:01 PM");
INSERT INTO crm_audit_log VALUES("2232","3","6","2018-12-31 20:02:10","Exit Invoice [Invoice No: 118042] updated by ASHRAF  M K on 31/12/2018 at 08:02 PM");
INSERT INTO crm_audit_log VALUES("2233","2","6","2018-12-31 20:05:12","Entry Invoice [Invoice No: 19825] updated by ASHRAF  M K on 31/12/2018 at 08:05 PM");
INSERT INTO crm_audit_log VALUES("2234","1","6","2018-12-31 20:09:49","Customer [Customer No: 412] updated by ASHRAF  M K on 31/12/2018 at 08:09 PM");
INSERT INTO crm_audit_log VALUES("2235","2","7","2018-12-31 20:11:25","Entry Invoice [Invoice No: 19826] updated by ALSED ABU SHAMA on 31/12/2018 at 08:11 PM");
INSERT INTO crm_audit_log VALUES("2236","3","5","2018-12-31 21:17:40","Exit Invoice [Invoice No: 118045] updated by Imran  Khan on 31/12/2018 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("2237","3","5","2018-12-31 21:20:46","Exit Invoice [Invoice No: 118046] updated by Imran  Khan on 31/12/2018 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("2238","3","5","2018-12-31 21:22:44","Exit Invoice [Invoice No: 118047] updated by Imran  Khan on 31/12/2018 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("2239","3","5","2018-12-31 21:25:14","Exit Invoice [Invoice No: 118048] updated by Imran  Khan on 31/12/2018 at 09:25 PM");
INSERT INTO crm_audit_log VALUES("2240","3","5","2018-12-31 21:29:21","Exit Invoice [Invoice No: 118049] updated by Imran  Khan on 31/12/2018 at 09:29 PM");
INSERT INTO crm_audit_log VALUES("2241","3","5","2018-12-31 21:31:31","Exit Invoice [Invoice No: 118050] updated by Imran  Khan on 31/12/2018 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("2242","3","5","2018-12-31 21:33:33","Exit Invoice [Invoice No: 118051] updated by Imran  Khan on 31/12/2018 at 09:33 PM");
INSERT INTO crm_audit_log VALUES("2243","2","6","2018-12-31 21:45:05","Entry Invoice [Invoice No: 19827] updated by ASHRAF  M K on 31/12/2018 at 09:45 PM");
INSERT INTO crm_audit_log VALUES("2244","2","10","2018-12-31 21:50:43","Entry Invoice [Invoice No: 19828] updated by MEDHAT  RAMADAN on 31/12/2018 at 09:50 PM");
INSERT INTO crm_audit_log VALUES("2245","3","5","2018-12-31 22:08:41","Exit Invoice [Invoice No: 118052] updated by Imran  Khan on 31/12/2018 at 10:08 PM");
INSERT INTO crm_audit_log VALUES("2246","2","10","2018-12-31 22:26:05","Entry Invoice [Invoice No: 19829] updated by MEDHAT  RAMADAN on 31/12/2018 at 10:26 PM");
INSERT INTO crm_audit_log VALUES("2247","2","10","2018-12-31 22:27:20","Entry Invoice [Invoice No: 19830] updated by MEDHAT  RAMADAN on 31/12/2018 at 10:27 PM");
INSERT INTO crm_audit_log VALUES("2248","2","10","2018-12-31 22:28:45","Entry Invoice [Invoice No: 19831] updated by MEDHAT  RAMADAN on 31/12/2018 at 10:28 PM");
INSERT INTO crm_audit_log VALUES("2249","2","10","2018-12-31 23:28:19","Entry Invoice [Invoice No: 19832] updated by MEDHAT  RAMADAN on 31/12/2018 at 11:28 PM");
INSERT INTO crm_audit_log VALUES("2250","2","10","2019-01-01 00:07:43","Entry Invoice [Invoice No: 19833] updated by MEDHAT  RAMADAN on 01/01/2019 at 12:07 AM");
INSERT INTO crm_audit_log VALUES("2251","3","5","2019-01-01 00:34:26","Exit Invoice [Invoice No: 118053] updated by Imran  Khan on 01/01/2019 at 12:34 AM");
INSERT INTO crm_audit_log VALUES("2252","3","5","2019-01-01 00:36:49","Exit Invoice [Invoice No: 118054] updated by Imran  Khan on 01/01/2019 at 12:36 AM");
INSERT INTO crm_audit_log VALUES("2253","3","5","2019-01-01 03:01:55","Exit Invoice [Invoice No: 118055] updated by Imran  Khan on 01/01/2019 at 03:01 AM");
INSERT INTO crm_audit_log VALUES("2254","3","5","2019-01-01 03:17:45","Exit Invoice [Invoice No: 118056] updated by Imran  Khan on 01/01/2019 at 03:17 AM");
INSERT INTO crm_audit_log VALUES("2255","3","5","2019-01-01 03:19:09","Exit Invoice [Invoice No: 118057] updated by Imran  Khan on 01/01/2019 at 03:19 AM");
INSERT INTO crm_audit_log VALUES("2256","2","10","2019-01-01 03:36:02","Entry Invoice [Invoice No: 19834] updated by MEDHAT  RAMADAN on 01/01/2019 at 03:36 AM");
INSERT INTO crm_audit_log VALUES("2257","3","5","2019-01-01 04:14:53","Exit Invoice [Invoice No: 118058] updated by Imran  Khan on 01/01/2019 at 04:14 AM");
INSERT INTO crm_audit_log VALUES("2258","3","5","2019-01-01 04:17:01","Exit Invoice [Invoice No: 118059] updated by Imran  Khan on 01/01/2019 at 04:17 AM");
INSERT INTO crm_audit_log VALUES("2259","3","5","2019-01-01 04:53:39","Exit Invoice [Invoice No: 118060] updated by Imran  Khan on 01/01/2019 at 04:53 AM");
INSERT INTO crm_audit_log VALUES("2260","2","6","2019-01-01 09:19:29","Entry Invoice [Invoice No: 19828] updated by ASHRAF  M K on 01/01/2019 at 09:19 AM");
INSERT INTO crm_audit_log VALUES("2261","2","6","2019-01-01 09:21:47","Entry Invoice [Invoice No: 19828] updated by ASHRAF  M K on 01/01/2019 at 09:21 AM");
INSERT INTO crm_audit_log VALUES("2262","2","6","2019-01-01 09:22:03","Entry Invoice [Invoice No: 19827] updated by ASHRAF  M K on 01/01/2019 at 09:22 AM");
INSERT INTO crm_audit_log VALUES("2263","2","7","2019-01-01 09:35:06","Entry Invoice [Invoice No: 19835] updated by ALSED ABU SHAMA on 01/01/2019 at 09:35 AM");
INSERT INTO crm_audit_log VALUES("2264","3","4","2019-01-01 10:48:38","Exit Invoice [Invoice No: 118061] updated by Yasir  Rahman on 01/01/2019 at 10:48 AM");
INSERT INTO crm_audit_log VALUES("2265","3","4","2019-01-01 10:58:10","Exit Invoice [Invoice No: 118062] updated by Yasir  Rahman on 01/01/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("2266","2","6","2019-01-01 11:44:41","Entry Invoice [Invoice No: 19825] updated by ASHRAF  M K on 01/01/2019 at 11:44 AM");
INSERT INTO crm_audit_log VALUES("2267","3","4","2019-01-01 11:45:43","Exit Invoice [Invoice No: 118063] updated by Yasir  Rahman on 01/01/2019 at 11:45 AM");
INSERT INTO crm_audit_log VALUES("2268","2","6","2019-01-01 11:50:05","Entry Invoice [Invoice No: 19825] updated by ASHRAF  M K on 01/01/2019 at 11:50 AM");
INSERT INTO crm_audit_log VALUES("2269","3","4","2019-01-01 12:19:18","Exit Invoice [Invoice No: 118064] updated by Yasir  Rahman on 01/01/2019 at 12:19 PM");
INSERT INTO crm_audit_log VALUES("2270","3","4","2019-01-01 13:57:24","Exit Invoice [Invoice No: 118065] updated by Yasir  Rahman on 01/01/2019 at 01:57 PM");
INSERT INTO crm_audit_log VALUES("2271","2","7","2019-01-01 15:51:52","Entry Invoice [Invoice No: 19836] updated by ALSED ABU SHAMA on 01/01/2019 at 03:51 PM");
INSERT INTO crm_audit_log VALUES("2272","2","10","2019-01-01 21:07:34","Entry Invoice [Invoice No: 19837] updated by MEDHAT  RAMADAN on 01/01/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("2273","2","10","2019-01-01 21:11:14","Entry Invoice [Invoice No: 19838] updated by MEDHAT  RAMADAN on 01/01/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("2274","2","10","2019-01-01 22:15:17","Entry Invoice [Invoice No: 19839] updated by MEDHAT  RAMADAN on 01/01/2019 at 10:15 PM");
INSERT INTO crm_audit_log VALUES("2275","2","10","2019-01-01 22:16:45","Entry Invoice [Invoice No: 19840] updated by MEDHAT  RAMADAN on 01/01/2019 at 10:16 PM");
INSERT INTO crm_audit_log VALUES("2276","2","10","2019-01-01 22:17:31","Entry Invoice [Invoice No: 19841] updated by MEDHAT  RAMADAN on 01/01/2019 at 10:17 PM");
INSERT INTO crm_audit_log VALUES("2277","3","5","2019-01-01 22:56:49","Exit Invoice [Invoice No: 118066] updated by Imran  Khan on 01/01/2019 at 10:56 PM");
INSERT INTO crm_audit_log VALUES("2278","2","10","2019-01-01 22:57:26","Entry Invoice [Invoice No: 19842] updated by MEDHAT  RAMADAN on 01/01/2019 at 10:57 PM");
INSERT INTO crm_audit_log VALUES("2279","3","5","2019-01-01 23:00:28","Exit Invoice [Invoice No: 118067] updated by Imran  Khan on 01/01/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("2280","3","5","2019-01-01 23:02:14","Exit Invoice [Invoice No: 118068] updated by Imran  Khan on 01/01/2019 at 11:02 PM");
INSERT INTO crm_audit_log VALUES("2281","3","5","2019-01-01 23:04:01","Exit Invoice [Invoice No: 118069] updated by Imran  Khan on 01/01/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("2282","3","5","2019-01-01 23:05:55","Exit Invoice [Invoice No: 118070] updated by Imran  Khan on 01/01/2019 at 11:05 PM");
INSERT INTO crm_audit_log VALUES("2283","3","5","2019-01-01 23:07:25","Exit Invoice [Invoice No: 118071] updated by Imran  Khan on 01/01/2019 at 11:07 PM");
INSERT INTO crm_audit_log VALUES("2284","3","5","2019-01-01 23:11:42","Exit Invoice [Invoice No: 118072] updated by Imran  Khan on 01/01/2019 at 11:11 PM");
INSERT INTO crm_audit_log VALUES("2285","3","5","2019-01-01 23:16:23","Exit Invoice [Invoice No: 118073] updated by Imran  Khan on 01/01/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("2286","2","10","2019-01-01 23:17:34","Entry Invoice [Invoice No: 19843] updated by MEDHAT  RAMADAN on 01/01/2019 at 11:17 PM");
INSERT INTO crm_audit_log VALUES("2287","3","5","2019-01-01 23:18:05","Exit Invoice [Invoice No: 118074] updated by Imran  Khan on 01/01/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("2288","2","10","2019-01-01 23:19:28","Entry Invoice [Invoice No: 19844] updated by MEDHAT  RAMADAN on 01/01/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("2289","3","5","2019-01-01 23:19:45","Exit Invoice [Invoice No: 118075] updated by Imran  Khan on 01/01/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("2290","3","5","2019-01-01 23:21:39","Exit Invoice [Invoice No: 118076] updated by Imran  Khan on 01/01/2019 at 11:21 PM");
INSERT INTO crm_audit_log VALUES("2291","3","5","2019-01-01 23:41:31","Exit Invoice [Invoice No: 118077] updated by Imran  Khan on 01/01/2019 at 11:41 PM");
INSERT INTO crm_audit_log VALUES("2292","2","10","2019-01-02 00:03:04","Entry Invoice [Invoice No: 19845] updated by MEDHAT  RAMADAN on 02/01/2019 at 12:03 AM");
INSERT INTO crm_audit_log VALUES("2293","2","10","2019-01-02 05:54:02","Entry Invoice [Invoice No: 19846] updated by MEDHAT  RAMADAN on 02/01/2019 at 05:54 AM");
INSERT INTO crm_audit_log VALUES("2294","3","11","2019-01-02 11:04:18","Exit Invoice [Invoice No: 118078] updated by GAREEB GAREEB on 02/01/2019 at 11:04 AM");
INSERT INTO crm_audit_log VALUES("2295","2","6","2019-01-02 11:42:27","Entry Invoice [Invoice No: 19847] updated by ASHRAF  M K on 02/01/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("2296","3","11","2019-01-02 12:37:06","Exit Invoice [Invoice No: 118079] updated by GAREEB GAREEB on 02/01/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("2297","3","11","2019-01-02 12:42:55","Exit Invoice [Invoice No: 118080] updated by GAREEB GAREEB on 02/01/2019 at 12:42 PM");
INSERT INTO crm_audit_log VALUES("2298","3","11","2019-01-02 17:55:08","Exit Invoice [Invoice No: 118081] updated by GAREEB GAREEB on 02/01/2019 at 05:55 PM");
INSERT INTO crm_audit_log VALUES("2299","2","7","2019-01-02 20:05:37","Entry Invoice [Invoice No: 19848] updated by ALSED ABU SHAMA on 02/01/2019 at 08:05 PM");
INSERT INTO crm_audit_log VALUES("2300","2","10","2019-01-02 20:25:56","Entry Invoice [Invoice No: 19849] updated by MEDHAT  RAMADAN on 02/01/2019 at 08:25 PM");
INSERT INTO crm_audit_log VALUES("2301","3","5","2019-01-02 21:03:32","Exit Invoice [Invoice No: 118082] updated by Imran  Khan on 02/01/2019 at 09:03 PM");
INSERT INTO crm_audit_log VALUES("2302","3","5","2019-01-02 21:06:02","Exit Invoice [Invoice No: 118083] updated by Imran  Khan on 02/01/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("2303","2","10","2019-01-02 21:47:31","Entry Invoice [Invoice No: 19850] updated by MEDHAT  RAMADAN on 02/01/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("2304","2","10","2019-01-02 21:48:33","Entry Invoice [Invoice No: 19851] updated by MEDHAT  RAMADAN on 02/01/2019 at 09:48 PM");
INSERT INTO crm_audit_log VALUES("2305","2","10","2019-01-02 21:52:26","Entry Invoice [Invoice No: 19852] updated by MEDHAT  RAMADAN on 02/01/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("2306","2","10","2019-01-02 21:53:27","Entry Invoice [Invoice No: 19853] updated by MEDHAT  RAMADAN on 02/01/2019 at 09:53 PM");
INSERT INTO crm_audit_log VALUES("2307","2","10","2019-01-02 22:43:58","Entry Invoice [Invoice No: 19854] updated by MEDHAT  RAMADAN on 02/01/2019 at 10:43 PM");
INSERT INTO crm_audit_log VALUES("2308","3","5","2019-01-02 23:04:27","Exit Invoice [Invoice No: 118084] updated by Imran  Khan on 02/01/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("2309","2","10","2019-01-02 23:18:55","Entry Invoice [Invoice No: 19855] updated by MEDHAT  RAMADAN on 02/01/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("2310","3","5","2019-01-02 23:50:51","Exit Invoice [Invoice No: 118085] updated by Imran  Khan on 02/01/2019 at 11:50 PM");
INSERT INTO crm_audit_log VALUES("2311","2","10","2019-01-03 01:52:10","Entry Invoice [Invoice No: 19856] updated by MEDHAT  RAMADAN on 03/01/2019 at 01:52 AM");
INSERT INTO crm_audit_log VALUES("2312","2","10","2019-01-03 03:10:19","Entry Invoice [Invoice No: 19857] updated by MEDHAT  RAMADAN on 03/01/2019 at 03:10 AM");
INSERT INTO crm_audit_log VALUES("2313","2","10","2019-01-03 03:11:04","Entry Invoice [Invoice No: 19858] updated by MEDHAT  RAMADAN on 03/01/2019 at 03:11 AM");
INSERT INTO crm_audit_log VALUES("2314","2","10","2019-01-03 03:11:47","Entry Invoice [Invoice No: 19859] updated by MEDHAT  RAMADAN on 03/01/2019 at 03:11 AM");
INSERT INTO crm_audit_log VALUES("2315","3","5","2019-01-03 03:34:55","Exit Invoice [Invoice No: 118086] updated by Imran  Khan on 03/01/2019 at 03:34 AM");
INSERT INTO crm_audit_log VALUES("2316","3","5","2019-01-03 07:01:01","Exit Invoice [Invoice No: 118087] updated by Imran  Khan on 03/01/2019 at 07:01 AM");
INSERT INTO crm_audit_log VALUES("2317","3","5","2019-01-03 07:12:05","Exit Invoice [Invoice No: 118088] updated by Imran  Khan on 03/01/2019 at 07:12 AM");
INSERT INTO crm_audit_log VALUES("2318","3","6","2019-01-03 09:05:45","Exit Invoice [Invoice No: 118084] updated by ASHRAF  M K on 03/01/2019 at 09:05 AM");
INSERT INTO crm_audit_log VALUES("2319","2","7","2019-01-03 09:42:00","Entry Invoice [Invoice No: 19860] updated by ALSED ABU SHAMA on 03/01/2019 at 09:42 AM");
INSERT INTO crm_audit_log VALUES("2320","2","6","2019-01-03 10:06:16","Entry Invoice [Invoice No: 19861] updated by ASHRAF  M K on 03/01/2019 at 10:06 AM");
INSERT INTO crm_audit_log VALUES("2321","3","4","2019-01-03 10:29:32","Exit Invoice [Invoice No: 118089] updated by Yasir  Rahman on 03/01/2019 at 10:29 AM");
INSERT INTO crm_audit_log VALUES("2322","3","6","2019-01-03 11:09:57","Exit Invoice [Invoice No: 118089] updated by ASHRAF  M K on 03/01/2019 at 11:09 AM");
INSERT INTO crm_audit_log VALUES("2323","3","4","2019-01-03 11:53:12","Exit Invoice [Invoice No: 118090] updated by Yasir  Rahman on 03/01/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("2324","2","6","2019-01-03 12:48:17","Entry Invoice [Invoice No: 19862] updated by ASHRAF  M K on 03/01/2019 at 12:48 PM");
INSERT INTO crm_audit_log VALUES("2325","2","6","2019-01-03 12:54:18","Entry Invoice [Invoice No: 19863] updated by ASHRAF  M K on 03/01/2019 at 12:54 PM");
INSERT INTO crm_audit_log VALUES("2326","3","4","2019-01-03 12:57:01","Exit Invoice [Invoice No: 118091] updated by Yasir  Rahman on 03/01/2019 at 12:57 PM");
INSERT INTO crm_audit_log VALUES("2327","2","7","2019-01-03 15:47:05","Entry Invoice [Invoice No: 19864] updated by ALSED ABU SHAMA on 03/01/2019 at 03:47 PM");
INSERT INTO crm_audit_log VALUES("2328","2","7","2019-01-03 15:49:48","Entry Invoice [Invoice No: 19865] updated by ALSED ABU SHAMA on 03/01/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("2329","3","4","2019-01-03 16:21:36","Exit Invoice [Invoice No: 118092] updated by Yasir  Rahman on 03/01/2019 at 04:21 PM");
INSERT INTO crm_audit_log VALUES("2330","3","4","2019-01-03 16:23:38","Exit Invoice [Invoice No: 118093] updated by Yasir  Rahman on 03/01/2019 at 04:23 PM");
INSERT INTO crm_audit_log VALUES("2331","2","6","2019-01-03 18:24:43","Entry Invoice [Invoice No: 19866] updated by ASHRAF  M K on 03/01/2019 at 06:24 PM");
INSERT INTO crm_audit_log VALUES("2332","2","7","2019-01-03 18:46:13","Entry Invoice [Invoice No: 19867] updated by ALSED ABU SHAMA on 03/01/2019 at 06:46 PM");
INSERT INTO crm_audit_log VALUES("2333","2","10","2019-01-03 20:21:00","Entry Invoice [Invoice No: 19868] updated by MEDHAT  RAMADAN on 03/01/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("2334","2","10","2019-01-03 21:03:34","Entry Invoice [Invoice No: 19869] updated by MEDHAT  RAMADAN on 03/01/2019 at 09:03 PM");
INSERT INTO crm_audit_log VALUES("2335","2","10","2019-01-03 21:30:23","Entry Invoice [Invoice No: 19870] updated by MEDHAT  RAMADAN on 03/01/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("2336","2","10","2019-01-03 21:31:11","Entry Invoice [Invoice No: 19871] updated by MEDHAT  RAMADAN on 03/01/2019 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("2337","2","10","2019-01-03 21:57:45","Entry Invoice [Invoice No: 19872] updated by MEDHAT  RAMADAN on 03/01/2019 at 09:57 PM");
INSERT INTO crm_audit_log VALUES("2338","3","5","2019-01-03 22:44:25","Exit Invoice [Invoice No: 118094] updated by Imran  Khan on 03/01/2019 at 10:44 PM");
INSERT INTO crm_audit_log VALUES("2339","3","5","2019-01-03 22:46:20","Exit Invoice [Invoice No: 118095] updated by Imran  Khan on 03/01/2019 at 10:46 PM");
INSERT INTO crm_audit_log VALUES("2340","3","5","2019-01-03 22:48:31","Exit Invoice [Invoice No: 118096] updated by Imran  Khan on 03/01/2019 at 10:48 PM");
INSERT INTO crm_audit_log VALUES("2341","3","5","2019-01-03 22:50:07","Exit Invoice [Invoice No: 118097] updated by Imran  Khan on 03/01/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("2342","3","5","2019-01-03 22:51:39","Exit Invoice [Invoice No: 118098] updated by Imran  Khan on 03/01/2019 at 10:51 PM");
INSERT INTO crm_audit_log VALUES("2343","3","5","2019-01-03 22:53:24","Exit Invoice [Invoice No: 118099] updated by Imran  Khan on 03/01/2019 at 10:53 PM");
INSERT INTO crm_audit_log VALUES("2344","3","5","2019-01-03 22:54:59","Exit Invoice [Invoice No: 118100] updated by Imran  Khan on 03/01/2019 at 10:54 PM");
INSERT INTO crm_audit_log VALUES("2345","3","5","2019-01-03 22:56:32","Exit Invoice [Invoice No: 118101] updated by Imran  Khan on 03/01/2019 at 10:56 PM");
INSERT INTO crm_audit_log VALUES("2346","3","5","2019-01-03 22:58:45","Exit Invoice [Invoice No: 118102] updated by Imran  Khan on 03/01/2019 at 10:58 PM");
INSERT INTO crm_audit_log VALUES("2347","3","5","2019-01-03 23:00:26","Exit Invoice [Invoice No: 118103] updated by Imran  Khan on 03/01/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("2348","3","5","2019-01-04 01:51:37","Exit Invoice [Invoice No: 118104] updated by Imran  Khan on 04/01/2019 at 01:51 AM");
INSERT INTO crm_audit_log VALUES("2349","3","5","2019-01-04 02:27:10","Exit Invoice [Invoice No: 118105] updated by Imran  Khan on 04/01/2019 at 02:27 AM");
INSERT INTO crm_audit_log VALUES("2350","2","10","2019-01-04 03:44:12","Entry Invoice [Invoice No: 19873] updated by MEDHAT  RAMADAN on 04/01/2019 at 03:44 AM");
INSERT INTO crm_audit_log VALUES("2351","3","5","2019-01-04 05:24:16","Exit Invoice [Invoice No: 118106] updated by Imran  Khan on 04/01/2019 at 05:24 AM");
INSERT INTO crm_audit_log VALUES("2352","3","6","2019-01-04 10:39:21","Exit Invoice [Invoice No: 118107] updated by ASHRAF  M K on 04/01/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("2353","3","6","2019-01-04 11:06:00","Exit Invoice [Invoice No: 118107] updated by ASHRAF  M K on 04/01/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("2354","2","6","2019-01-04 11:07:35","Entry Invoice [Invoice No: 19874] updated by ASHRAF  M K on 04/01/2019 at 11:07 AM");
INSERT INTO crm_audit_log VALUES("2355","3","4","2019-01-04 11:28:51","Exit Invoice [Invoice No: 118108] updated by Yasir  Rahman on 04/01/2019 at 11:28 AM");
INSERT INTO crm_audit_log VALUES("2356","2","7","2019-01-04 13:55:28","Entry Invoice [Invoice No: 19875] updated by ALSED ABU SHAMA on 04/01/2019 at 01:55 PM");
INSERT INTO crm_audit_log VALUES("2357","3","4","2019-01-04 14:19:49","Exit Invoice [Invoice No: 118109] updated by Yasir  Rahman on 04/01/2019 at 02:19 PM");
INSERT INTO crm_audit_log VALUES("2358","3","4","2019-01-04 15:21:53","Exit Invoice [Invoice No: 118110] updated by Yasir  Rahman on 04/01/2019 at 03:21 PM");
INSERT INTO crm_audit_log VALUES("2359","2","7","2019-01-04 15:57:32","Entry Invoice [Invoice No: 19876] updated by ALSED ABU SHAMA on 04/01/2019 at 03:57 PM");
INSERT INTO crm_audit_log VALUES("2360","3","5","2019-01-04 20:42:14","Exit Invoice [Invoice No: 118111] updated by Imran  Khan on 04/01/2019 at 08:42 PM");
INSERT INTO crm_audit_log VALUES("2361","2","10","2019-01-04 22:40:20","Entry Invoice [Invoice No: 19877] updated by MEDHAT  RAMADAN on 04/01/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("2362","3","5","2019-01-04 22:52:28","Exit Invoice [Invoice No: 118112] updated by Imran  Khan on 04/01/2019 at 10:52 PM");
INSERT INTO crm_audit_log VALUES("2363","2","10","2019-01-04 23:01:22","Entry Invoice [Invoice No: 19878] updated by MEDHAT  RAMADAN on 04/01/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("2364","2","10","2019-01-04 23:02:10","Entry Invoice [Invoice No: 19879] updated by MEDHAT  RAMADAN on 04/01/2019 at 11:02 PM");
INSERT INTO crm_audit_log VALUES("2365","2","10","2019-01-04 23:03:29","Entry Invoice [Invoice No: 19880] updated by MEDHAT  RAMADAN on 04/01/2019 at 11:03 PM");
INSERT INTO crm_audit_log VALUES("2366","3","5","2019-01-04 23:31:59","Exit Invoice [Invoice No: 118113] updated by Imran  Khan on 04/01/2019 at 11:31 PM");
INSERT INTO crm_audit_log VALUES("2367","2","10","2019-01-04 23:32:02","Entry Invoice [Invoice No: 19881] updated by MEDHAT  RAMADAN on 04/01/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("2368","2","10","2019-01-04 23:32:49","Entry Invoice [Invoice No: 19882] updated by MEDHAT  RAMADAN on 04/01/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("2369","2","10","2019-01-04 23:33:39","Entry Invoice [Invoice No: 19883] updated by MEDHAT  RAMADAN on 04/01/2019 at 11:33 PM");
INSERT INTO crm_audit_log VALUES("2370","3","5","2019-01-04 23:34:15","Exit Invoice [Invoice No: 118114] updated by Imran  Khan on 04/01/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("2371","2","10","2019-01-04 23:34:28","Entry Invoice [Invoice No: 19884] updated by MEDHAT  RAMADAN on 04/01/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("2372","2","10","2019-01-04 23:36:35","Entry Invoice [Invoice No: 19885] updated by MEDHAT  RAMADAN on 04/01/2019 at 11:36 PM");
INSERT INTO crm_audit_log VALUES("2373","3","5","2019-01-04 23:36:41","Exit Invoice [Invoice No: 118115] updated by Imran  Khan on 04/01/2019 at 11:36 PM");
INSERT INTO crm_audit_log VALUES("2374","3","5","2019-01-04 23:38:39","Exit Invoice [Invoice No: 118116] updated by Imran  Khan on 04/01/2019 at 11:38 PM");
INSERT INTO crm_audit_log VALUES("2375","3","5","2019-01-04 23:40:40","Exit Invoice [Invoice No: 118117] updated by Imran  Khan on 04/01/2019 at 11:40 PM");
INSERT INTO crm_audit_log VALUES("2376","3","5","2019-01-04 23:42:23","Exit Invoice [Invoice No: 118118] updated by Imran  Khan on 04/01/2019 at 11:42 PM");
INSERT INTO crm_audit_log VALUES("2377","2","10","2019-01-05 03:52:40","Entry Invoice [Invoice No: 19886] updated by MEDHAT  RAMADAN on 05/01/2019 at 03:52 AM");
INSERT INTO crm_audit_log VALUES("2378","2","6","2019-01-05 08:38:17","Entry Invoice [Invoice No: 19885] updated by ASHRAF  M K on 05/01/2019 at 08:38 AM");
INSERT INTO crm_audit_log VALUES("2379","2","6","2019-01-05 08:39:16","Entry Invoice [Invoice No: 19885] updated by ASHRAF  M K on 05/01/2019 at 08:39 AM");
INSERT INTO crm_audit_log VALUES("2380","3","11","2019-01-05 08:52:29","Exit Invoice [Invoice No: 118119] updated by GAREEB GAREEB on 05/01/2019 at 08:52 AM");
INSERT INTO crm_audit_log VALUES("2381","3","4","2019-01-05 12:54:23","Exit Invoice [Invoice No: 118120] updated by Yasir  Rahman on 05/01/2019 at 12:54 PM");
INSERT INTO crm_audit_log VALUES("2382","2","7","2019-01-05 13:42:21","Entry Invoice [Invoice No: 19887] updated by ALSED ABU SHAMA on 05/01/2019 at 01:42 PM");
INSERT INTO crm_audit_log VALUES("2383","2","7","2019-01-05 13:44:37","Entry Invoice [Invoice No: 19888] updated by ALSED ABU SHAMA on 05/01/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("2384","3","11","2019-01-05 16:57:26","Exit Invoice [Invoice No: 118121] updated by GAREEB GAREEB on 05/01/2019 at 04:57 PM");
INSERT INTO crm_audit_log VALUES("2385","3","5","2019-01-05 20:03:40","Exit Invoice [Invoice No: 118122] updated by Imran  Khan on 05/01/2019 at 08:03 PM");
INSERT INTO crm_audit_log VALUES("2386","2","10","2019-01-05 20:30:55","Entry Invoice [Invoice No: 19889] updated by MEDHAT  RAMADAN on 05/01/2019 at 08:30 PM");
INSERT INTO crm_audit_log VALUES("2387","2","10","2019-01-05 20:43:54","Entry Invoice [Invoice No: 19890] updated by MEDHAT  RAMADAN on 05/01/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("2388","2","10","2019-01-05 20:44:52","Entry Invoice [Invoice No: 19891] updated by MEDHAT  RAMADAN on 05/01/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("2389","2","10","2019-01-05 20:47:19","Entry Invoice [Invoice No: 19892] updated by MEDHAT  RAMADAN on 05/01/2019 at 08:47 PM");
INSERT INTO crm_audit_log VALUES("2390","2","10","2019-01-05 20:48:34","Entry Invoice [Invoice No: 19893] updated by MEDHAT  RAMADAN on 05/01/2019 at 08:48 PM");
INSERT INTO crm_audit_log VALUES("2391","3","5","2019-01-05 21:37:38","Exit Invoice [Invoice No: 118123] updated by Imran  Khan on 05/01/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("2392","3","5","2019-01-05 21:38:50","Exit Invoice [Invoice No: 118124] updated by Imran  Khan on 05/01/2019 at 09:38 PM");
INSERT INTO crm_audit_log VALUES("2393","3","5","2019-01-05 22:12:37","Exit Invoice [Invoice No: 118125] updated by Imran  Khan on 05/01/2019 at 10:12 PM");
INSERT INTO crm_audit_log VALUES("2394","3","5","2019-01-06 00:28:21","Exit Invoice [Invoice No: 118126] updated by Imran  Khan on 06/01/2019 at 12:28 AM");
INSERT INTO crm_audit_log VALUES("2395","3","5","2019-01-06 01:58:23","Exit Invoice [Invoice No: 118127] updated by Imran  Khan on 06/01/2019 at 01:58 AM");
INSERT INTO crm_audit_log VALUES("2396","2","10","2019-01-06 02:24:51","Entry Invoice [Invoice No: 19894] updated by MEDHAT  RAMADAN on 06/01/2019 at 02:24 AM");
INSERT INTO crm_audit_log VALUES("2397","2","10","2019-01-06 02:25:47","Entry Invoice [Invoice No: 19895] updated by MEDHAT  RAMADAN on 06/01/2019 at 02:25 AM");
INSERT INTO crm_audit_log VALUES("2398","3","6","2019-01-06 08:48:30","Exit Invoice [Invoice No: 118126] updated by ASHRAF  M K on 06/01/2019 at 08:48 AM");
INSERT INTO crm_audit_log VALUES("2399","3","4","2019-01-06 10:04:31","Exit Invoice [Invoice No: 118128] updated by Yasir  Rahman on 06/01/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("2400","2","7","2019-01-06 12:41:19","Entry Invoice [Invoice No: 19896] updated by ALSED ABU SHAMA on 06/01/2019 at 12:41 PM");
INSERT INTO crm_audit_log VALUES("2401","2","7","2019-01-06 12:45:20","Entry Invoice [Invoice No: 19897] updated by ALSED ABU SHAMA on 06/01/2019 at 12:45 PM");
INSERT INTO crm_audit_log VALUES("2402","2","7","2019-01-06 12:46:50","Entry Invoice [Invoice No: 19898] updated by ALSED ABU SHAMA on 06/01/2019 at 12:46 PM");
INSERT INTO crm_audit_log VALUES("2403","3","4","2019-01-06 15:20:40","Exit Invoice [Invoice No: 118129] updated by Yasir  Rahman on 06/01/2019 at 03:20 PM");
INSERT INTO crm_audit_log VALUES("2404","3","4","2019-01-06 15:40:59","Exit Invoice [Invoice No: 118130] updated by Yasir  Rahman on 06/01/2019 at 03:40 PM");
INSERT INTO crm_audit_log VALUES("2405","3","4","2019-01-06 15:46:52","Exit Invoice [Invoice No: 118131] updated by Yasir  Rahman on 06/01/2019 at 03:46 PM");
INSERT INTO crm_audit_log VALUES("2406","2","7","2019-01-06 17:53:00","Entry Invoice [Invoice No: 19899] updated by ALSED ABU SHAMA on 06/01/2019 at 05:53 PM");
INSERT INTO crm_audit_log VALUES("2407","2","7","2019-01-06 18:00:47","Entry Invoice [Invoice No: 19900] updated by ALSED ABU SHAMA on 06/01/2019 at 06:00 PM");
INSERT INTO crm_audit_log VALUES("2408","2","7","2019-01-06 18:21:04","Entry Invoice [Invoice No: 19901] updated by ALSED ABU SHAMA on 06/01/2019 at 06:21 PM");
INSERT INTO crm_audit_log VALUES("2409","2","7","2019-01-06 18:41:03","Entry Invoice [Invoice No: 19902] updated by ALSED ABU SHAMA on 06/01/2019 at 06:41 PM");
INSERT INTO crm_audit_log VALUES("2410","3","11","2019-01-06 19:24:36","Exit Invoice [Invoice No: 118132] updated by GAREEB GAREEB on 06/01/2019 at 07:24 PM");
INSERT INTO crm_audit_log VALUES("2411","3","11","2019-01-06 19:26:39","Exit Invoice [Invoice No: 118133] updated by GAREEB GAREEB on 06/01/2019 at 07:26 PM");
INSERT INTO crm_audit_log VALUES("2412","3","5","2019-01-06 20:02:52","Exit Invoice [Invoice No: 118134] updated by Imran  Khan on 06/01/2019 at 08:02 PM");
INSERT INTO crm_audit_log VALUES("2413","2","10","2019-01-06 21:00:58","Entry Invoice [Invoice No: 19903] updated by MEDHAT  RAMADAN on 06/01/2019 at 09:00 PM");
INSERT INTO crm_audit_log VALUES("2414","2","10","2019-01-06 21:02:52","Entry Invoice [Invoice No: 19904] updated by MEDHAT  RAMADAN on 06/01/2019 at 09:02 PM");
INSERT INTO crm_audit_log VALUES("2415","3","5","2019-01-06 21:15:49","Exit Invoice [Invoice No: 118135] updated by Imran  Khan on 06/01/2019 at 09:15 PM");
INSERT INTO crm_audit_log VALUES("2416","2","10","2019-01-06 22:02:55","Entry Invoice [Invoice No: 19905] updated by MEDHAT  RAMADAN on 06/01/2019 at 10:02 PM");
INSERT INTO crm_audit_log VALUES("2417","2","10","2019-01-06 22:10:28","Entry Invoice [Invoice No: 19906] updated by MEDHAT  RAMADAN on 06/01/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("2418","3","5","2019-01-06 22:49:18","Exit Invoice [Invoice No: 118136] updated by Imran  Khan on 06/01/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("2419","3","5","2019-01-06 22:55:32","Exit Invoice [Invoice No: 118137] updated by Imran  Khan on 06/01/2019 at 10:55 PM");
INSERT INTO crm_audit_log VALUES("2420","3","5","2019-01-06 23:28:13","Exit Invoice [Invoice No: 118138] updated by Imran  Khan on 06/01/2019 at 11:28 PM");
INSERT INTO crm_audit_log VALUES("2421","2","10","2019-01-07 00:06:09","Entry Invoice [Invoice No: 19907] updated by MEDHAT  RAMADAN on 07/01/2019 at 12:06 AM");
INSERT INTO crm_audit_log VALUES("2422","2","10","2019-01-07 01:08:12","Entry Invoice [Invoice No: 19908] updated by MEDHAT  RAMADAN on 07/01/2019 at 01:08 AM");
INSERT INTO crm_audit_log VALUES("2423","3","5","2019-01-07 01:42:28","Exit Invoice [Invoice No: 118139] updated by Imran  Khan on 07/01/2019 at 01:42 AM");
INSERT INTO crm_audit_log VALUES("2424","2","6","2019-01-07 13:25:22","Entry Invoice [Invoice No: 19909] updated by ASHRAF  M K on 07/01/2019 at 01:25 PM");
INSERT INTO crm_audit_log VALUES("2425","2","6","2019-01-07 13:28:28","Entry Invoice [Invoice No: 19909] updated by ASHRAF  M K on 07/01/2019 at 01:28 PM");
INSERT INTO crm_audit_log VALUES("2426","3","4","2019-01-07 13:47:16","Exit Invoice [Invoice No: 118140] updated by Yasir  Rahman on 07/01/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("2427","3","4","2019-01-07 14:04:49","Exit Invoice [Invoice No: 118141] updated by Yasir  Rahman on 07/01/2019 at 02:04 PM");
INSERT INTO crm_audit_log VALUES("2428","3","4","2019-01-07 15:03:21","Exit Invoice [Invoice No: 118142] updated by Yasir  Rahman on 07/01/2019 at 03:03 PM");
INSERT INTO crm_audit_log VALUES("2429","2","7","2019-01-07 16:30:08","Entry Invoice [Invoice No: 19910] updated by ALSED ABU SHAMA on 07/01/2019 at 04:30 PM");
INSERT INTO crm_audit_log VALUES("2430","2","7","2019-01-07 17:32:18","Entry Invoice [Invoice No: 19911] updated by ALSED ABU SHAMA on 07/01/2019 at 05:32 PM");
INSERT INTO crm_audit_log VALUES("2431","2","7","2019-01-07 17:33:26","Entry Invoice [Invoice No: 19912] updated by ALSED ABU SHAMA on 07/01/2019 at 05:33 PM");
INSERT INTO crm_audit_log VALUES("2432","2","7","2019-01-07 17:52:39","Entry Invoice [Invoice No: 19913] updated by ALSED ABU SHAMA on 07/01/2019 at 05:52 PM");
INSERT INTO crm_audit_log VALUES("2433","3","11","2019-01-07 18:00:17","Exit Invoice [Invoice No: 118143] updated by GAREEB GAREEB on 07/01/2019 at 06:00 PM");
INSERT INTO crm_audit_log VALUES("2434","2","7","2019-01-07 19:37:23","Entry Invoice [Invoice No: 19914] updated by ALSED ABU SHAMA on 07/01/2019 at 07:37 PM");
INSERT INTO crm_audit_log VALUES("2435","3","5","2019-01-07 20:52:53","Exit Invoice [Invoice No: 118144] updated by Imran  Khan on 07/01/2019 at 08:52 PM");
INSERT INTO crm_audit_log VALUES("2436","2","10","2019-01-07 21:05:11","Entry Invoice [Invoice No: 19915] updated by MEDHAT  RAMADAN on 07/01/2019 at 09:05 PM");
INSERT INTO crm_audit_log VALUES("2437","2","10","2019-01-07 21:06:39","Entry Invoice [Invoice No: 19916] updated by MEDHAT  RAMADAN on 07/01/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("2438","3","5","2019-01-07 21:06:50","Exit Invoice [Invoice No: 118145] updated by Imran  Khan on 07/01/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("2439","2","10","2019-01-07 21:07:33","Entry Invoice [Invoice No: 19917] updated by MEDHAT  RAMADAN on 07/01/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("2440","2","10","2019-01-07 21:22:05","Entry Invoice [Invoice No: 19918] updated by MEDHAT  RAMADAN on 07/01/2019 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("2441","3","5","2019-01-07 23:07:53","Exit Invoice [Invoice No: 118146] updated by Imran  Khan on 07/01/2019 at 11:07 PM");
INSERT INTO crm_audit_log VALUES("2442","3","5","2019-01-07 23:11:26","Exit Invoice [Invoice No: 118147] updated by Imran  Khan on 07/01/2019 at 11:11 PM");
INSERT INTO crm_audit_log VALUES("2443","3","5","2019-01-07 23:14:13","Exit Invoice [Invoice No: 118148] updated by Imran  Khan on 07/01/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("2444","3","5","2019-01-07 23:16:08","Exit Invoice [Invoice No: 118149] updated by Imran  Khan on 07/01/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("2445","3","5","2019-01-07 23:17:14","Exit Invoice [Invoice No: 118150] updated by Imran  Khan on 07/01/2019 at 11:17 PM");
INSERT INTO crm_audit_log VALUES("2446","3","5","2019-01-08 03:17:16","Exit Invoice [Invoice No: 118151] updated by Imran  Khan on 08/01/2019 at 03:17 AM");
INSERT INTO crm_audit_log VALUES("2447","2","10","2019-01-08 03:37:49","Entry Invoice [Invoice No: 19919] updated by MEDHAT  RAMADAN on 08/01/2019 at 03:37 AM");
INSERT INTO crm_audit_log VALUES("2448","2","10","2019-01-08 03:39:22","Entry Invoice [Invoice No: 19920] updated by MEDHAT  RAMADAN on 08/01/2019 at 03:39 AM");
INSERT INTO crm_audit_log VALUES("2449","2","10","2019-01-08 03:40:22","Entry Invoice [Invoice No: 19921] updated by MEDHAT  RAMADAN on 08/01/2019 at 03:40 AM");
INSERT INTO crm_audit_log VALUES("2450","2","10","2019-01-08 03:41:11","Entry Invoice [Invoice No: 19922] updated by MEDHAT  RAMADAN on 08/01/2019 at 03:41 AM");
INSERT INTO crm_audit_log VALUES("2451","3","5","2019-01-08 07:47:44","Exit Invoice [Invoice No: 118152] updated by Imran  Khan on 08/01/2019 at 07:47 AM");
INSERT INTO crm_audit_log VALUES("2452","2","6","2019-01-08 09:00:56","Entry Invoice [Invoice No: 19909] updated by ASHRAF  M K on 08/01/2019 at 09:00 AM");
INSERT INTO crm_audit_log VALUES("2453","2","6","2019-01-08 09:03:25","Entry Invoice [Invoice No: 19909] updated by ASHRAF  M K on 08/01/2019 at 09:03 AM");
INSERT INTO crm_audit_log VALUES("2454","3","4","2019-01-08 09:32:12","Exit Invoice [Invoice No: 118153] updated by Yasir  Rahman on 08/01/2019 at 09:32 AM");
INSERT INTO crm_audit_log VALUES("2455","2","1","2019-01-08 11:43:46","Entry Invoice [Invoice No: 19909] updated by - - on 08/01/2019 at 11:43 AM");
INSERT INTO crm_audit_log VALUES("2456","2","1","2019-01-08 11:46:55","Entry Invoice [Invoice No: 19909] updated by - - on 08/01/2019 at 11:46 AM");
INSERT INTO crm_audit_log VALUES("2457","2","1","2019-01-08 11:47:13","Entry Invoice [Invoice No: 19909] updated by - - on 08/01/2019 at 11:47 AM");
INSERT INTO crm_audit_log VALUES("2458","3","1","2019-01-08 11:50:13","Exit Invoice [Invoice No: 118153] updated by - - on 08/01/2019 at 11:50 AM");
INSERT INTO crm_audit_log VALUES("2459","3","1","2019-01-08 11:50:21","Exit Invoice [Invoice No: 118153] updated by - - on 08/01/2019 at 11:50 AM");
INSERT INTO crm_audit_log VALUES("2460","3","4","2019-01-08 12:22:39","Exit Invoice [Invoice No: 118154] updated by Yasir  Rahman on 08/01/2019 at 12:22 PM");
INSERT INTO crm_audit_log VALUES("2461","3","4","2019-01-08 13:30:22","Exit Invoice [Invoice No: 118155] updated by Yasir  Rahman on 08/01/2019 at 01:30 PM");
INSERT INTO crm_audit_log VALUES("2462","3","1","2019-01-08 13:44:50","Exit Invoice [Invoice No: 118151] updated by - - on 08/01/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("2463","2","1","2019-01-08 13:51:25","Entry Invoice [Invoice No: 19909] updated by - - on 08/01/2019 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("2464","2","1","2019-01-08 13:52:16","Entry Invoice [Invoice No: 19909] updated by - - on 08/01/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("2465","3","1","2019-01-08 13:58:18","Exit Invoice [Invoice No: 118151] updated by - - on 08/01/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("2466","3","1","2019-01-08 13:58:38","Exit Invoice [Invoice No: 118151] updated by - - on 08/01/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("2467","2","1","2019-01-08 14:01:08","Entry Invoice [Invoice No: 19922] updated by - - on 08/01/2019 at 02:01 PM");
INSERT INTO crm_audit_log VALUES("2468","2","1","2019-01-08 14:01:20","Entry Invoice [Invoice No: 19922] updated by - - on 08/01/2019 at 02:01 PM");
INSERT INTO crm_audit_log VALUES("2469","2","1","2019-01-08 14:01:44","Entry Invoice [Invoice No: 19922] updated by - - on 08/01/2019 at 02:01 PM");
INSERT INTO crm_audit_log VALUES("2470","2","7","2019-01-08 14:07:03","Entry Invoice [Invoice No: 19923] updated by ALSED ABU SHAMA on 08/01/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("2471","2","9","2019-01-08 14:39:21","Entry Invoice [Invoice No: 19909] updated by Test Test on 08/01/2019 at 02:39 PM");
INSERT INTO crm_audit_log VALUES("2472","3","9","2019-01-08 14:43:03","Exit Invoice [Invoice No: 118155] updated by Test Test on 08/01/2019 at 02:43 PM");
INSERT INTO crm_audit_log VALUES("2473","3","4","2019-01-08 15:05:24","Exit Invoice [Invoice No: 118156] updated by Yasir  Rahman on 08/01/2019 at 03:05 PM");
INSERT INTO crm_audit_log VALUES("2474","1","4","2019-01-08 15:32:05","Customer [Customer No: 413] updated by Yasir  Rahman on 08/01/2019 at 03:32 PM");
INSERT INTO crm_audit_log VALUES("2475","3","11","2019-01-08 16:23:53","Exit Invoice [Invoice No: 118157] updated by GAREEB GAREEB on 08/01/2019 at 04:23 PM");
INSERT INTO crm_audit_log VALUES("2476","2","7","2019-01-08 16:32:28","Entry Invoice [Invoice No: 19924] updated by ALSED ABU SHAMA on 08/01/2019 at 04:32 PM");
INSERT INTO crm_audit_log VALUES("2477","2","7","2019-01-08 18:50:15","Entry Invoice [Invoice No: 19925] updated by ALSED ABU SHAMA on 08/01/2019 at 06:50 PM");
INSERT INTO crm_audit_log VALUES("2478","3","5","2019-01-08 21:13:09","Exit Invoice [Invoice No: 118158] updated by Imran  Khan on 08/01/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("2479","2","10","2019-01-08 22:56:43","Entry Invoice [Invoice No: 19926] updated by MEDHAT  RAMADAN on 08/01/2019 at 10:56 PM");
INSERT INTO crm_audit_log VALUES("2480","2","10","2019-01-08 22:57:41","Entry Invoice [Invoice No: 19927] updated by MEDHAT  RAMADAN on 08/01/2019 at 10:57 PM");
INSERT INTO crm_audit_log VALUES("2481","3","5","2019-01-08 23:10:22","Exit Invoice [Invoice No: 118159] updated by Imran  Khan on 08/01/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("2482","3","5","2019-01-08 23:13:43","Exit Invoice [Invoice No: 118160] updated by Imran  Khan on 08/01/2019 at 11:13 PM");
INSERT INTO crm_audit_log VALUES("2483","3","5","2019-01-08 23:16:47","Exit Invoice [Invoice No: 118161] updated by Imran  Khan on 08/01/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("2484","3","5","2019-01-08 23:18:32","Exit Invoice [Invoice No: 118162] updated by Imran  Khan on 08/01/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("2485","3","5","2019-01-08 23:20:28","Exit Invoice [Invoice No: 118163] updated by Imran  Khan on 08/01/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("2486","3","5","2019-01-08 23:22:29","Exit Invoice [Invoice No: 118164] updated by Imran  Khan on 08/01/2019 at 11:22 PM");
INSERT INTO crm_audit_log VALUES("2487","3","5","2019-01-09 01:42:13","Exit Invoice [Invoice No: 118165] updated by Imran  Khan on 09/01/2019 at 01:42 AM");
INSERT INTO crm_audit_log VALUES("2488","3","5","2019-01-09 03:00:32","Exit Invoice [Invoice No: 118166] updated by Imran  Khan on 09/01/2019 at 03:00 AM");
INSERT INTO crm_audit_log VALUES("2489","3","5","2019-01-09 04:36:24","Exit Invoice [Invoice No: 118167] updated by Imran  Khan on 09/01/2019 at 04:36 AM");
INSERT INTO crm_audit_log VALUES("2490","2","10","2019-01-09 04:43:23","Entry Invoice [Invoice No: 19928] updated by MEDHAT  RAMADAN on 09/01/2019 at 04:43 AM");
INSERT INTO crm_audit_log VALUES("2491","2","10","2019-01-09 04:44:07","Entry Invoice [Invoice No: 19929] updated by MEDHAT  RAMADAN on 09/01/2019 at 04:44 AM");
INSERT INTO crm_audit_log VALUES("2492","3","4","2019-01-09 10:21:21","Exit Invoice [Invoice No: 118168] updated by Yasir  Rahman on 09/01/2019 at 10:21 AM");
INSERT INTO crm_audit_log VALUES("2493","3","4","2019-01-09 10:22:55","Exit Invoice [Invoice No: 118169] updated by Yasir  Rahman on 09/01/2019 at 10:22 AM");
INSERT INTO crm_audit_log VALUES("2494","3","4","2019-01-09 12:50:39","Exit Invoice [Invoice No: 118170] updated by Yasir  Rahman on 09/01/2019 at 12:50 PM");
INSERT INTO crm_audit_log VALUES("2495","3","4","2019-01-09 13:52:48","Exit Invoice [Invoice No: 118171] updated by Yasir  Rahman on 09/01/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("2496","2","7","2019-01-09 17:25:09","Entry Invoice [Invoice No: 19930] updated by ALSED ABU SHAMA on 09/01/2019 at 05:25 PM");
INSERT INTO crm_audit_log VALUES("2497","2","7","2019-01-09 17:27:02","Entry Invoice [Invoice No: 19931] updated by ALSED ABU SHAMA on 09/01/2019 at 05:27 PM");
INSERT INTO crm_audit_log VALUES("2498","3","11","2019-01-09 17:27:28","Exit Invoice [Invoice No: 118172] updated by GAREEB GAREEB on 09/01/2019 at 05:27 PM");
INSERT INTO crm_audit_log VALUES("2499","3","11","2019-01-09 17:31:11","Exit Invoice [Invoice No: 118173] updated by GAREEB GAREEB on 09/01/2019 at 05:31 PM");
INSERT INTO crm_audit_log VALUES("2500","3","11","2019-01-09 17:32:13","Exit Invoice [Invoice No: 118174] updated by GAREEB GAREEB on 09/01/2019 at 05:32 PM");
INSERT INTO crm_audit_log VALUES("2501","3","11","2019-01-09 17:35:46","Exit Invoice [Invoice No: 118175] updated by GAREEB GAREEB on 09/01/2019 at 05:35 PM");
INSERT INTO crm_audit_log VALUES("2502","2","7","2019-01-09 18:53:11","Entry Invoice [Invoice No: 19932] updated by ALSED ABU SHAMA on 09/01/2019 at 06:53 PM");
INSERT INTO crm_audit_log VALUES("2503","2","7","2019-01-09 19:03:53","Entry Invoice [Invoice No: 19933] updated by ALSED ABU SHAMA on 09/01/2019 at 07:03 PM");
INSERT INTO crm_audit_log VALUES("2504","3","5","2019-01-09 19:59:55","Exit Invoice [Invoice No: 118176] updated by Imran  Khan on 09/01/2019 at 07:59 PM");
INSERT INTO crm_audit_log VALUES("2505","3","5","2019-01-09 20:02:06","Exit Invoice [Invoice No: 118177] updated by Imran  Khan on 09/01/2019 at 08:02 PM");
INSERT INTO crm_audit_log VALUES("2506","2","10","2019-01-09 21:34:42","Entry Invoice [Invoice No: 19934] updated by MEDHAT  RAMADAN on 09/01/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("2507","3","5","2019-01-09 21:50:38","Exit Invoice [Invoice No: 118178] updated by Imran  Khan on 09/01/2019 at 09:50 PM");
INSERT INTO crm_audit_log VALUES("2508","3","5","2019-01-09 21:52:40","Exit Invoice [Invoice No: 118179] updated by Imran  Khan on 09/01/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("2509","3","5","2019-01-09 21:53:50","Exit Invoice [Invoice No: 118180] updated by Imran  Khan on 09/01/2019 at 09:53 PM");
INSERT INTO crm_audit_log VALUES("2510","2","10","2019-01-09 22:23:02","Entry Invoice [Invoice No: 19935] updated by MEDHAT  RAMADAN on 09/01/2019 at 10:23 PM");
INSERT INTO crm_audit_log VALUES("2511","3","5","2019-01-09 22:33:36","Exit Invoice [Invoice No: 118181] updated by Imran  Khan on 09/01/2019 at 10:33 PM");
INSERT INTO crm_audit_log VALUES("2512","3","5","2019-01-09 23:22:04","Exit Invoice [Invoice No: 118182] updated by Imran  Khan on 09/01/2019 at 11:22 PM");
INSERT INTO crm_audit_log VALUES("2513","3","5","2019-01-09 23:24:40","Exit Invoice [Invoice No: 118183] updated by Imran  Khan on 09/01/2019 at 11:24 PM");
INSERT INTO crm_audit_log VALUES("2514","3","5","2019-01-09 23:25:59","Exit Invoice [Invoice No: 118184] updated by Imran  Khan on 09/01/2019 at 11:25 PM");
INSERT INTO crm_audit_log VALUES("2515","3","5","2019-01-09 23:27:46","Exit Invoice [Invoice No: 118185] updated by Imran  Khan on 09/01/2019 at 11:27 PM");
INSERT INTO crm_audit_log VALUES("2516","3","5","2019-01-09 23:47:26","Exit Invoice [Invoice No: 118186] updated by Imran  Khan on 09/01/2019 at 11:47 PM");
INSERT INTO crm_audit_log VALUES("2517","2","10","2019-01-10 00:04:42","Entry Invoice [Invoice No: 19936] updated by MEDHAT  RAMADAN on 10/01/2019 at 12:04 AM");
INSERT INTO crm_audit_log VALUES("2518","3","5","2019-01-10 02:47:48","Exit Invoice [Invoice No: 118187] updated by Imran  Khan on 10/01/2019 at 02:47 AM");
INSERT INTO crm_audit_log VALUES("2519","3","5","2019-01-10 02:48:33","Exit Invoice [Invoice No: 118188] updated by Imran  Khan on 10/01/2019 at 02:48 AM");
INSERT INTO crm_audit_log VALUES("2520","3","5","2019-01-10 02:51:42","Exit Invoice [Invoice No: 118189] updated by Imran  Khan on 10/01/2019 at 02:51 AM");
INSERT INTO crm_audit_log VALUES("2521","3","5","2019-01-10 02:54:57","Exit Invoice [Invoice No: 118190] updated by Imran  Khan on 10/01/2019 at 02:54 AM");
INSERT INTO crm_audit_log VALUES("2522","3","5","2019-01-10 07:03:22","Exit Invoice [Invoice No: 118191] updated by Imran  Khan on 10/01/2019 at 07:03 AM");
INSERT INTO crm_audit_log VALUES("2523","2","6","2019-01-10 08:34:30","Entry Invoice [Invoice No: 19932] updated by ASHRAF  M K on 10/01/2019 at 08:34 AM");
INSERT INTO crm_audit_log VALUES("2524","3","4","2019-01-10 10:56:57","Exit Invoice [Invoice No: 118192] updated by Yasir  Rahman on 10/01/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("2525","3","4","2019-01-10 13:45:01","Exit Invoice [Invoice No: 118193] updated by Yasir  Rahman on 10/01/2019 at 01:45 PM");
INSERT INTO crm_audit_log VALUES("2526","2","7","2019-01-10 14:00:02","Entry Invoice [Invoice No: 19937] updated by ALSED ABU SHAMA on 10/01/2019 at 02:00 PM");
INSERT INTO crm_audit_log VALUES("2527","2","7","2019-01-10 14:01:16","Entry Invoice [Invoice No: 19938] updated by ALSED ABU SHAMA on 10/01/2019 at 02:01 PM");
INSERT INTO crm_audit_log VALUES("2528","2","7","2019-01-10 14:02:48","Entry Invoice [Invoice No: 19939] updated by ALSED ABU SHAMA on 10/01/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("2529","2","7","2019-01-10 14:03:59","Entry Invoice [Invoice No: 19940] updated by ALSED ABU SHAMA on 10/01/2019 at 02:03 PM");
INSERT INTO crm_audit_log VALUES("2530","3","11","2019-01-10 17:17:26","Exit Invoice [Invoice No: 118194] updated by GAREEB GAREEB on 10/01/2019 at 05:17 PM");
INSERT INTO crm_audit_log VALUES("2531","3","11","2019-01-10 17:20:47","Exit Invoice [Invoice No: 118195] updated by GAREEB GAREEB on 10/01/2019 at 05:20 PM");
INSERT INTO crm_audit_log VALUES("2532","3","11","2019-01-10 17:22:56","Exit Invoice [Invoice No: 118196] updated by GAREEB GAREEB on 10/01/2019 at 05:22 PM");
INSERT INTO crm_audit_log VALUES("2533","3","11","2019-01-10 18:10:04","Exit Invoice [Invoice No: 118197] updated by GAREEB GAREEB on 10/01/2019 at 06:10 PM");
INSERT INTO crm_audit_log VALUES("2534","2","7","2019-01-10 18:39:03","Entry Invoice [Invoice No: 19941] updated by ALSED ABU SHAMA on 10/01/2019 at 06:39 PM");
INSERT INTO crm_audit_log VALUES("2535","2","10","2019-01-10 20:14:20","Entry Invoice [Invoice No: 19942] updated by MEDHAT  RAMADAN on 10/01/2019 at 08:14 PM");
INSERT INTO crm_audit_log VALUES("2536","3","5","2019-01-10 22:14:32","Exit Invoice [Invoice No: 118198] updated by Imran  Khan on 10/01/2019 at 10:14 PM");
INSERT INTO crm_audit_log VALUES("2537","2","10","2019-01-10 22:40:07","Entry Invoice [Invoice No: 19943] updated by MEDHAT  RAMADAN on 10/01/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("2538","3","5","2019-01-10 23:29:47","Exit Invoice [Invoice No: 118199] updated by Imran  Khan on 10/01/2019 at 11:29 PM");
INSERT INTO crm_audit_log VALUES("2539","3","5","2019-01-10 23:34:18","Exit Invoice [Invoice No: 118200] updated by Imran  Khan on 10/01/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("2540","3","5","2019-01-10 23:37:27","Exit Invoice [Invoice No: 118201] updated by Imran  Khan on 10/01/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("2541","3","5","2019-01-10 23:39:07","Exit Invoice [Invoice No: 118202] updated by Imran  Khan on 10/01/2019 at 11:39 PM");
INSERT INTO crm_audit_log VALUES("2542","3","5","2019-01-10 23:40:50","Exit Invoice [Invoice No: 118203] updated by Imran  Khan on 10/01/2019 at 11:40 PM");
INSERT INTO crm_audit_log VALUES("2543","3","5","2019-01-10 23:44:40","Exit Invoice [Invoice No: 118204] updated by Imran  Khan on 10/01/2019 at 11:44 PM");
INSERT INTO crm_audit_log VALUES("2544","3","5","2019-01-10 23:48:06","Exit Invoice [Invoice No: 118205] updated by Imran  Khan on 10/01/2019 at 11:48 PM");
INSERT INTO crm_audit_log VALUES("2545","2","10","2019-01-11 00:19:16","Entry Invoice [Invoice No: 19944] updated by MEDHAT  RAMADAN on 11/01/2019 at 12:19 AM");
INSERT INTO crm_audit_log VALUES("2546","2","10","2019-01-11 02:03:08","Entry Invoice [Invoice No: 19945] updated by MEDHAT  RAMADAN on 11/01/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("2547","3","5","2019-01-11 02:35:04","Exit Invoice [Invoice No: 118206] updated by Imran  Khan on 11/01/2019 at 02:35 AM");
INSERT INTO crm_audit_log VALUES("2548","3","5","2019-01-11 02:35:50","Exit Invoice [Invoice No: 118207] updated by Imran  Khan on 11/01/2019 at 02:35 AM");
INSERT INTO crm_audit_log VALUES("2549","3","5","2019-01-11 03:26:48","Exit Invoice [Invoice No: 118208] updated by Imran  Khan on 11/01/2019 at 03:26 AM");
INSERT INTO crm_audit_log VALUES("2550","2","10","2019-01-11 04:39:43","Entry Invoice [Invoice No: 19946] updated by MEDHAT  RAMADAN on 11/01/2019 at 04:39 AM");
INSERT INTO crm_audit_log VALUES("2551","3","5","2019-01-11 05:03:50","Exit Invoice [Invoice No: 118209] updated by Imran  Khan on 11/01/2019 at 05:03 AM");
INSERT INTO crm_audit_log VALUES("2552","3","5","2019-01-11 05:05:30","Exit Invoice [Invoice No: 118210] updated by Imran  Khan on 11/01/2019 at 05:05 AM");
INSERT INTO crm_audit_log VALUES("2553","2","10","2019-01-11 05:43:44","Entry Invoice [Invoice No: 19947] updated by MEDHAT  RAMADAN on 11/01/2019 at 05:43 AM");
INSERT INTO crm_audit_log VALUES("2554","2","10","2019-01-11 05:44:35","Entry Invoice [Invoice No: 19948] updated by MEDHAT  RAMADAN on 11/01/2019 at 05:44 AM");
INSERT INTO crm_audit_log VALUES("2555","3","5","2019-01-11 05:46:03","Exit Invoice [Invoice No: 118211] updated by Imran  Khan on 11/01/2019 at 05:46 AM");
INSERT INTO crm_audit_log VALUES("2556","2","10","2019-01-11 06:05:57","Entry Invoice [Invoice No: 19949] updated by MEDHAT  RAMADAN on 11/01/2019 at 06:05 AM");
INSERT INTO crm_audit_log VALUES("2557","2","10","2019-01-11 06:06:43","Entry Invoice [Invoice No: 19950] updated by MEDHAT  RAMADAN on 11/01/2019 at 06:06 AM");
INSERT INTO crm_audit_log VALUES("2558","2","7","2019-01-11 10:23:54","Entry Invoice [Invoice No: 19951] updated by ALSED ABU SHAMA on 11/01/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("2559","3","4","2019-01-11 11:45:45","Exit Invoice [Invoice No: 118212] updated by Yasir  Rahman on 11/01/2019 at 11:45 AM");
INSERT INTO crm_audit_log VALUES("2560","3","4","2019-01-11 11:47:58","Exit Invoice [Invoice No: 118213] updated by Yasir  Rahman on 11/01/2019 at 11:47 AM");
INSERT INTO crm_audit_log VALUES("2561","3","4","2019-01-11 11:48:57","Exit Invoice [Invoice No: 118214] updated by Yasir  Rahman on 11/01/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("2562","3","4","2019-01-11 15:24:40","Exit Invoice [Invoice No: 118215] updated by Yasir  Rahman on 11/01/2019 at 03:24 PM");
INSERT INTO crm_audit_log VALUES("2563","3","6","2019-01-11 15:31:53","Exit Invoice [Invoice No: 118215] updated by ASHRAF  M K on 11/01/2019 at 03:31 PM");
INSERT INTO crm_audit_log VALUES("2564","2","7","2019-01-11 16:45:16","Entry Invoice [Invoice No: 19952] updated by ALSED ABU SHAMA on 11/01/2019 at 04:45 PM");
INSERT INTO crm_audit_log VALUES("2565","3","11","2019-01-11 17:02:29","Exit Invoice [Invoice No: 118216] updated by GAREEB GAREEB on 11/01/2019 at 05:02 PM");
INSERT INTO crm_audit_log VALUES("2566","2","7","2019-01-11 17:50:04","Entry Invoice [Invoice No: 19953] updated by ALSED ABU SHAMA on 11/01/2019 at 05:50 PM");
INSERT INTO crm_audit_log VALUES("2567","2","7","2019-01-11 19:20:14","Entry Invoice [Invoice No: 19954] updated by ALSED ABU SHAMA on 11/01/2019 at 07:20 PM");
INSERT INTO crm_audit_log VALUES("2568","3","5","2019-01-11 21:03:09","Exit Invoice [Invoice No: 118217] updated by Imran  Khan on 11/01/2019 at 09:03 PM");
INSERT INTO crm_audit_log VALUES("2569","2","10","2019-01-11 23:48:32","Entry Invoice [Invoice No: 19955] updated by MEDHAT  RAMADAN on 11/01/2019 at 11:48 PM");
INSERT INTO crm_audit_log VALUES("2570","3","5","2019-01-12 00:48:55","Exit Invoice [Invoice No: 118218] updated by Imran  Khan on 12/01/2019 at 12:48 AM");
INSERT INTO crm_audit_log VALUES("2571","3","5","2019-01-12 00:50:53","Exit Invoice [Invoice No: 118219] updated by Imran  Khan on 12/01/2019 at 12:50 AM");
INSERT INTO crm_audit_log VALUES("2572","2","10","2019-01-12 01:22:39","Entry Invoice [Invoice No: 19956] updated by MEDHAT  RAMADAN on 12/01/2019 at 01:22 AM");
INSERT INTO crm_audit_log VALUES("2573","3","5","2019-01-12 01:22:42","Exit Invoice [Invoice No: 118220] updated by Imran  Khan on 12/01/2019 at 01:22 AM");
INSERT INTO crm_audit_log VALUES("2574","3","5","2019-01-12 01:24:57","Exit Invoice [Invoice No: 118221] updated by Imran  Khan on 12/01/2019 at 01:24 AM");
INSERT INTO crm_audit_log VALUES("2575","3","5","2019-01-12 01:26:35","Exit Invoice [Invoice No: 118222] updated by Imran  Khan on 12/01/2019 at 01:26 AM");
INSERT INTO crm_audit_log VALUES("2576","3","5","2019-01-12 01:27:58","Exit Invoice [Invoice No: 118223] updated by Imran  Khan on 12/01/2019 at 01:27 AM");
INSERT INTO crm_audit_log VALUES("2577","3","5","2019-01-12 01:29:17","Exit Invoice [Invoice No: 118224] updated by Imran  Khan on 12/01/2019 at 01:29 AM");
INSERT INTO crm_audit_log VALUES("2578","3","5","2019-01-12 01:30:47","Exit Invoice [Invoice No: 118225] updated by Imran  Khan on 12/01/2019 at 01:30 AM");
INSERT INTO crm_audit_log VALUES("2579","3","5","2019-01-12 01:54:13","Exit Invoice [Invoice No: 118226] updated by Imran  Khan on 12/01/2019 at 01:54 AM");
INSERT INTO crm_audit_log VALUES("2580","3","5","2019-01-12 01:55:49","Exit Invoice [Invoice No: 118227] updated by Imran  Khan on 12/01/2019 at 01:55 AM");
INSERT INTO crm_audit_log VALUES("2581","3","5","2019-01-12 01:58:31","Exit Invoice [Invoice No: 118228] updated by Imran  Khan on 12/01/2019 at 01:58 AM");
INSERT INTO crm_audit_log VALUES("2582","2","10","2019-01-12 02:04:40","Entry Invoice [Invoice No: 19957] updated by MEDHAT  RAMADAN on 12/01/2019 at 02:04 AM");
INSERT INTO crm_audit_log VALUES("2583","2","10","2019-01-12 02:05:52","Entry Invoice [Invoice No: 19958] updated by MEDHAT  RAMADAN on 12/01/2019 at 02:05 AM");
INSERT INTO crm_audit_log VALUES("2584","2","10","2019-01-12 02:08:42","Entry Invoice [Invoice No: 19959] updated by MEDHAT  RAMADAN on 12/01/2019 at 02:08 AM");
INSERT INTO crm_audit_log VALUES("2585","2","10","2019-01-12 02:09:57","Entry Invoice [Invoice No: 19960] updated by MEDHAT  RAMADAN on 12/01/2019 at 02:09 AM");
INSERT INTO crm_audit_log VALUES("2586","2","10","2019-01-12 03:40:50","Entry Invoice [Invoice No: 19961] updated by MEDHAT  RAMADAN on 12/01/2019 at 03:40 AM");
INSERT INTO crm_audit_log VALUES("2587","2","10","2019-01-12 03:41:33","Entry Invoice [Invoice No: 19962] updated by MEDHAT  RAMADAN on 12/01/2019 at 03:41 AM");
INSERT INTO crm_audit_log VALUES("2588","2","6","2019-01-12 10:26:26","Entry Invoice [Invoice No: 19963] updated by ASHRAF  M K on 12/01/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("2589","2","6","2019-01-12 10:37:38","Entry Invoice [Invoice No: 19964] updated by ASHRAF  M K on 12/01/2019 at 10:37 AM");
INSERT INTO crm_audit_log VALUES("2590","3","4","2019-01-12 11:41:28","Exit Invoice [Invoice No: 118229] updated by Yasir  Rahman on 12/01/2019 at 11:41 AM");
INSERT INTO crm_audit_log VALUES("2591","2","6","2019-01-12 12:53:38","Entry Invoice [Invoice No: 19965] updated by ASHRAF  M K on 12/01/2019 at 12:53 PM");
INSERT INTO crm_audit_log VALUES("2592","2","7","2019-01-12 13:29:15","Entry Invoice [Invoice No: 19966] updated by ALSED ABU SHAMA on 12/01/2019 at 01:29 PM");
INSERT INTO crm_audit_log VALUES("2593","2","7","2019-01-12 13:30:47","Entry Invoice [Invoice No: 19967] updated by ALSED ABU SHAMA on 12/01/2019 at 01:30 PM");
INSERT INTO crm_audit_log VALUES("2594","3","11","2019-01-12 15:44:36","Exit Invoice [Invoice No: 118230] updated by GAREEB GAREEB on 12/01/2019 at 03:44 PM");
INSERT INTO crm_audit_log VALUES("2595","3","11","2019-01-12 17:12:47","Exit Invoice [Invoice No: 118231] updated by GAREEB GAREEB on 12/01/2019 at 05:12 PM");
INSERT INTO crm_audit_log VALUES("2596","2","7","2019-01-12 17:23:17","Entry Invoice [Invoice No: 19968] updated by ALSED ABU SHAMA on 12/01/2019 at 05:23 PM");
INSERT INTO crm_audit_log VALUES("2597","2","7","2019-01-12 17:25:40","Entry Invoice [Invoice No: 19969] updated by ALSED ABU SHAMA on 12/01/2019 at 05:25 PM");
INSERT INTO crm_audit_log VALUES("2598","2","7","2019-01-12 17:28:05","Entry Invoice [Invoice No: 19970] updated by ALSED ABU SHAMA on 12/01/2019 at 05:28 PM");
INSERT INTO crm_audit_log VALUES("2599","3","11","2019-01-12 19:50:15","Exit Invoice [Invoice No: 118232] updated by GAREEB GAREEB on 12/01/2019 at 07:50 PM");
INSERT INTO crm_audit_log VALUES("2600","2","7","2019-01-12 20:09:30","Entry Invoice [Invoice No: 19971] updated by ALSED ABU SHAMA on 12/01/2019 at 08:09 PM");
INSERT INTO crm_audit_log VALUES("2601","2","10","2019-01-12 22:56:23","Entry Invoice [Invoice No: 19972] updated by MEDHAT  RAMADAN on 12/01/2019 at 10:56 PM");
INSERT INTO crm_audit_log VALUES("2602","3","5","2019-01-12 23:11:06","Exit Invoice [Invoice No: 118233] updated by Imran  Khan on 12/01/2019 at 11:11 PM");
INSERT INTO crm_audit_log VALUES("2603","2","10","2019-01-12 23:34:21","Entry Invoice [Invoice No: 19973] updated by MEDHAT  RAMADAN on 12/01/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("2604","2","10","2019-01-12 23:35:08","Entry Invoice [Invoice No: 19974] updated by MEDHAT  RAMADAN on 12/01/2019 at 11:35 PM");
INSERT INTO crm_audit_log VALUES("2605","3","5","2019-01-13 00:13:04","Exit Invoice [Invoice No: 118234] updated by Imran  Khan on 13/01/2019 at 12:13 AM");
INSERT INTO crm_audit_log VALUES("2606","3","5","2019-01-13 01:56:17","Exit Invoice [Invoice No: 118235] updated by Imran  Khan on 13/01/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("2607","3","5","2019-01-13 01:56:56","Exit Invoice [Invoice No: 118236] updated by Imran  Khan on 13/01/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("2608","3","5","2019-01-13 01:57:33","Exit Invoice [Invoice No: 118237] updated by Imran  Khan on 13/01/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("2609","2","10","2019-01-13 04:08:35","Entry Invoice [Invoice No: 19975] updated by MEDHAT  RAMADAN on 13/01/2019 at 04:08 AM");
INSERT INTO crm_audit_log VALUES("2610","2","6","2019-01-13 09:39:40","Entry Invoice [Invoice No: 19976] updated by ASHRAF  M K on 13/01/2019 at 09:39 AM");
INSERT INTO crm_audit_log VALUES("2611","2","6","2019-01-13 09:41:08","Entry Invoice [Invoice No: 19977] updated by ASHRAF  M K on 13/01/2019 at 09:41 AM");
INSERT INTO crm_audit_log VALUES("2612","3","4","2019-01-13 11:26:08","Exit Invoice [Invoice No: 118238] updated by Yasir  Rahman on 13/01/2019 at 11:26 AM");
INSERT INTO crm_audit_log VALUES("2613","2","6","2019-01-13 11:42:49","Entry Invoice [Invoice No: 19978] updated by ASHRAF  M K on 13/01/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("2614","2","6","2019-01-13 11:48:35","Entry Invoice [Invoice No: 19979] updated by ASHRAF  M K on 13/01/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("2615","3","4","2019-01-13 12:43:27","Exit Invoice [Invoice No: 118239] updated by Yasir  Rahman on 13/01/2019 at 12:43 PM");
INSERT INTO crm_audit_log VALUES("2616","3","4","2019-01-13 13:16:30","Exit Invoice [Invoice No: 118240] updated by Yasir  Rahman on 13/01/2019 at 01:16 PM");
INSERT INTO crm_audit_log VALUES("2617","2","7","2019-01-13 14:35:01","Entry Invoice [Invoice No: 19980] updated by ALSED ABU SHAMA on 13/01/2019 at 02:35 PM");
INSERT INTO crm_audit_log VALUES("2618","3","11","2019-01-13 16:03:37","Exit Invoice [Invoice No: 118241] updated by GAREEB GAREEB on 13/01/2019 at 04:03 PM");
INSERT INTO crm_audit_log VALUES("2619","3","11","2019-01-13 18:26:22","Exit Invoice [Invoice No: 118242] updated by GAREEB GAREEB on 13/01/2019 at 06:26 PM");
INSERT INTO crm_audit_log VALUES("2620","3","11","2019-01-13 18:28:00","Exit Invoice [Invoice No: 118243] updated by GAREEB GAREEB on 13/01/2019 at 06:28 PM");
INSERT INTO crm_audit_log VALUES("2621","2","7","2019-01-13 18:34:03","Entry Invoice [Invoice No: 19981] updated by ALSED ABU SHAMA on 13/01/2019 at 06:34 PM");
INSERT INTO crm_audit_log VALUES("2622","2","10","2019-01-13 22:16:30","Entry Invoice [Invoice No: 19982] updated by MEDHAT  RAMADAN on 13/01/2019 at 10:16 PM");
INSERT INTO crm_audit_log VALUES("2623","2","10","2019-01-13 22:18:15","Entry Invoice [Invoice No: 19983] updated by MEDHAT  RAMADAN on 13/01/2019 at 10:18 PM");
INSERT INTO crm_audit_log VALUES("2624","3","5","2019-01-13 23:25:39","Exit Invoice [Invoice No: 118244] updated by Imran  Khan on 13/01/2019 at 11:25 PM");
INSERT INTO crm_audit_log VALUES("2625","3","5","2019-01-13 23:30:28","Exit Invoice [Invoice No: 118245] updated by Imran  Khan on 13/01/2019 at 11:30 PM");
INSERT INTO crm_audit_log VALUES("2626","3","5","2019-01-13 23:36:25","Exit Invoice [Invoice No: 118246] updated by Imran  Khan on 13/01/2019 at 11:36 PM");
INSERT INTO crm_audit_log VALUES("2627","3","5","2019-01-13 23:37:48","Exit Invoice [Invoice No: 118247] updated by Imran  Khan on 13/01/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("2628","3","5","2019-01-14 01:14:23","Exit Invoice [Invoice No: 118248] updated by Imran  Khan on 14/01/2019 at 01:14 AM");
INSERT INTO crm_audit_log VALUES("2629","3","5","2019-01-14 05:16:39","Exit Invoice [Invoice No: 118249] updated by Imran  Khan on 14/01/2019 at 05:16 AM");
INSERT INTO crm_audit_log VALUES("2630","2","6","2019-01-14 08:40:57","Entry Invoice [Invoice No: 19978] updated by ASHRAF  M K on 14/01/2019 at 08:40 AM");
INSERT INTO crm_audit_log VALUES("2631","3","4","2019-01-14 10:20:21","Exit Invoice [Invoice No: 118250] updated by Yasir  Rahman on 14/01/2019 at 10:20 AM");
INSERT INTO crm_audit_log VALUES("2632","2","6","2019-01-14 10:46:49","Entry Invoice [Invoice No: 19984] updated by ASHRAF  M K on 14/01/2019 at 10:46 AM");
INSERT INTO crm_audit_log VALUES("2633","2","7","2019-01-14 11:20:58","Entry Invoice [Invoice No: 19985] updated by ALSED ABU SHAMA on 14/01/2019 at 11:20 AM");
INSERT INTO crm_audit_log VALUES("2634","3","4","2019-01-14 13:05:35","Exit Invoice [Invoice No: 118251] updated by Yasir  Rahman on 14/01/2019 at 01:05 PM");
INSERT INTO crm_audit_log VALUES("2635","3","4","2019-01-14 13:07:43","Exit Invoice [Invoice No: 118252] updated by Yasir  Rahman on 14/01/2019 at 01:07 PM");
INSERT INTO crm_audit_log VALUES("2636","3","11","2019-01-14 17:12:02","Exit Invoice [Invoice No: 118253] updated by GAREEB GAREEB on 14/01/2019 at 05:12 PM");
INSERT INTO crm_audit_log VALUES("2637","2","7","2019-01-14 17:22:07","Entry Invoice [Invoice No: 19986] updated by ALSED ABU SHAMA on 14/01/2019 at 05:22 PM");
INSERT INTO crm_audit_log VALUES("2638","2","7","2019-01-14 19:13:09","Entry Invoice [Invoice No: 19987] updated by ALSED ABU SHAMA on 14/01/2019 at 07:13 PM");
INSERT INTO crm_audit_log VALUES("2639","3","11","2019-01-14 19:48:49","Exit Invoice [Invoice No: 118254] updated by GAREEB GAREEB on 14/01/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("2640","3","5","2019-01-14 20:31:32","Exit Invoice [Invoice No: 118255] updated by Imran  Khan on 14/01/2019 at 08:31 PM");
INSERT INTO crm_audit_log VALUES("2641","2","10","2019-01-14 20:59:13","Entry Invoice [Invoice No: 19988] updated by MEDHAT  RAMADAN on 14/01/2019 at 08:59 PM");
INSERT INTO crm_audit_log VALUES("2642","2","10","2019-01-14 21:00:09","Entry Invoice [Invoice No: 19989] updated by MEDHAT  RAMADAN on 14/01/2019 at 09:00 PM");
INSERT INTO crm_audit_log VALUES("2643","2","10","2019-01-14 22:33:31","Entry Invoice [Invoice No: 19990] updated by MEDHAT  RAMADAN on 14/01/2019 at 10:33 PM");
INSERT INTO crm_audit_log VALUES("2644","3","5","2019-01-14 22:58:05","Exit Invoice [Invoice No: 118256] updated by Imran  Khan on 14/01/2019 at 10:58 PM");
INSERT INTO crm_audit_log VALUES("2645","3","5","2019-01-14 23:03:08","Exit Invoice [Invoice No: 118257] updated by Imran  Khan on 14/01/2019 at 11:03 PM");
INSERT INTO crm_audit_log VALUES("2646","2","10","2019-01-14 23:06:43","Entry Invoice [Invoice No: 19991] updated by MEDHAT  RAMADAN on 14/01/2019 at 11:06 PM");
INSERT INTO crm_audit_log VALUES("2647","3","5","2019-01-14 23:08:04","Exit Invoice [Invoice No: 118258] updated by Imran  Khan on 14/01/2019 at 11:08 PM");
INSERT INTO crm_audit_log VALUES("2648","3","5","2019-01-14 23:15:19","Exit Invoice [Invoice No: 118259] updated by Imran  Khan on 14/01/2019 at 11:15 PM");
INSERT INTO crm_audit_log VALUES("2649","3","5","2019-01-14 23:17:00","Exit Invoice [Invoice No: 118260] updated by Imran  Khan on 14/01/2019 at 11:17 PM");
INSERT INTO crm_audit_log VALUES("2650","3","5","2019-01-14 23:19:08","Exit Invoice [Invoice No: 118261] updated by Imran  Khan on 14/01/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("2651","3","5","2019-01-15 02:51:48","Exit Invoice [Invoice No: 118262] updated by Imran  Khan on 15/01/2019 at 02:51 AM");
INSERT INTO crm_audit_log VALUES("2652","3","5","2019-01-15 03:16:09","Exit Invoice [Invoice No: 118263] updated by Imran  Khan on 15/01/2019 at 03:16 AM");
INSERT INTO crm_audit_log VALUES("2653","2","7","2019-01-15 10:34:38","Entry Invoice [Invoice No: 19992] updated by ALSED ABU SHAMA on 15/01/2019 at 10:34 AM");
INSERT INTO crm_audit_log VALUES("2654","3","4","2019-01-15 10:58:27","Exit Invoice [Invoice No: 118264] updated by Yasir  Rahman on 15/01/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("2655","3","4","2019-01-15 14:02:46","Exit Invoice [Invoice No: 118265] updated by Yasir  Rahman on 15/01/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("2656","2","6","2019-01-15 14:56:52","Entry Invoice [Invoice No: 19993] updated by ASHRAF  M K on 15/01/2019 at 02:56 PM");
INSERT INTO crm_audit_log VALUES("2657","3","11","2019-01-15 18:39:15","Exit Invoice [Invoice No: 118266] updated by GAREEB GAREEB on 15/01/2019 at 06:39 PM");
INSERT INTO crm_audit_log VALUES("2658","2","7","2019-01-15 19:13:46","Entry Invoice [Invoice No: 19994] updated by ALSED ABU SHAMA on 15/01/2019 at 07:13 PM");
INSERT INTO crm_audit_log VALUES("2659","3","11","2019-01-15 19:45:48","Exit Invoice [Invoice No: 118267] updated by GAREEB GAREEB on 15/01/2019 at 07:45 PM");
INSERT INTO crm_audit_log VALUES("2660","2","10","2019-01-15 20:32:53","Entry Invoice [Invoice No: 19995] updated by MEDHAT  RAMADAN on 15/01/2019 at 08:32 PM");
INSERT INTO crm_audit_log VALUES("2661","2","10","2019-01-15 22:08:19","Entry Invoice [Invoice No: 19996] updated by MEDHAT  RAMADAN on 15/01/2019 at 10:08 PM");
INSERT INTO crm_audit_log VALUES("2662","2","10","2019-01-15 22:09:29","Entry Invoice [Invoice No: 19997] updated by MEDHAT  RAMADAN on 15/01/2019 at 10:09 PM");
INSERT INTO crm_audit_log VALUES("2663","2","10","2019-01-15 22:10:22","Entry Invoice [Invoice No: 19998] updated by MEDHAT  RAMADAN on 15/01/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("2664","2","10","2019-01-15 22:11:09","Entry Invoice [Invoice No: 19999] updated by MEDHAT  RAMADAN on 15/01/2019 at 10:11 PM");
INSERT INTO crm_audit_log VALUES("2665","3","5","2019-01-15 22:23:10","Exit Invoice [Invoice No: 118268] updated by Imran  Khan on 15/01/2019 at 10:23 PM");
INSERT INTO crm_audit_log VALUES("2666","2","10","2019-01-15 22:24:42","Entry Invoice [Invoice No: 20000] updated by MEDHAT  RAMADAN on 15/01/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("2667","3","5","2019-01-15 22:24:51","Exit Invoice [Invoice No: 118269] updated by Imran  Khan on 15/01/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("2668","3","5","2019-01-15 22:56:05","Exit Invoice [Invoice No: 118270] updated by Imran  Khan on 15/01/2019 at 10:56 PM");
INSERT INTO crm_audit_log VALUES("2669","3","5","2019-01-15 22:57:35","Exit Invoice [Invoice No: 118271] updated by Imran  Khan on 15/01/2019 at 10:57 PM");
INSERT INTO crm_audit_log VALUES("2670","3","5","2019-01-15 22:59:21","Exit Invoice [Invoice No: 118272] updated by Imran  Khan on 15/01/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("2671","3","5","2019-01-15 23:01:05","Exit Invoice [Invoice No: 118273] updated by Imran  Khan on 15/01/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("2672","3","5","2019-01-15 23:02:46","Exit Invoice [Invoice No: 118274] updated by Imran  Khan on 15/01/2019 at 11:02 PM");
INSERT INTO crm_audit_log VALUES("2673","3","5","2019-01-15 23:04:23","Exit Invoice [Invoice No: 118275] updated by Imran  Khan on 15/01/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("2674","3","5","2019-01-15 23:06:05","Exit Invoice [Invoice No: 118276] updated by Imran  Khan on 15/01/2019 at 11:06 PM");
INSERT INTO crm_audit_log VALUES("2675","3","5","2019-01-15 23:07:22","Exit Invoice [Invoice No: 118277] updated by Imran  Khan on 15/01/2019 at 11:07 PM");
INSERT INTO crm_audit_log VALUES("2676","3","5","2019-01-15 23:35:32","Exit Invoice [Invoice No: 118278] updated by Imran  Khan on 15/01/2019 at 11:35 PM");
INSERT INTO crm_audit_log VALUES("2677","2","10","2019-01-16 02:21:25","Entry Invoice [Invoice No: 20001] updated by MEDHAT  RAMADAN on 16/01/2019 at 02:21 AM");
INSERT INTO crm_audit_log VALUES("2678","3","5","2019-01-16 02:26:30","Exit Invoice [Invoice No: 118279] updated by Imran  Khan on 16/01/2019 at 02:26 AM");
INSERT INTO crm_audit_log VALUES("2679","3","5","2019-01-16 03:40:04","Exit Invoice [Invoice No: 118280] updated by Imran  Khan on 16/01/2019 at 03:40 AM");
INSERT INTO crm_audit_log VALUES("2680","2","10","2019-01-16 04:53:34","Entry Invoice [Invoice No: 20002] updated by MEDHAT  RAMADAN on 16/01/2019 at 04:53 AM");
INSERT INTO crm_audit_log VALUES("2681","2","10","2019-01-16 04:55:27","Entry Invoice [Invoice No: 20003] updated by MEDHAT  RAMADAN on 16/01/2019 at 04:55 AM");
INSERT INTO crm_audit_log VALUES("2682","2","10","2019-01-16 05:27:03","Entry Invoice [Invoice No: 20004] updated by MEDHAT  RAMADAN on 16/01/2019 at 05:27 AM");
INSERT INTO crm_audit_log VALUES("2683","2","10","2019-01-16 05:28:38","Entry Invoice [Invoice No: 20005] updated by MEDHAT  RAMADAN on 16/01/2019 at 05:28 AM");
INSERT INTO crm_audit_log VALUES("2684","2","10","2019-01-16 05:30:01","Entry Invoice [Invoice No: 20006] updated by MEDHAT  RAMADAN on 16/01/2019 at 05:30 AM");
INSERT INTO crm_audit_log VALUES("2685","3","4","2019-01-16 08:06:45","Exit Invoice [Invoice No: 118281] updated by Yasir  Rahman on 16/01/2019 at 08:06 AM");
INSERT INTO crm_audit_log VALUES("2686","3","6","2019-01-16 08:46:31","Exit Invoice [Invoice No: 118274] updated by ASHRAF  M K on 16/01/2019 at 08:46 AM");
INSERT INTO crm_audit_log VALUES("2687","3","6","2019-01-16 09:28:28","Exit Invoice [Invoice No: 118271] updated by ASHRAF  M K on 16/01/2019 at 09:28 AM");
INSERT INTO crm_audit_log VALUES("2688","3","6","2019-01-16 09:29:31","Exit Invoice [Invoice No: 118271] updated by ASHRAF  M K on 16/01/2019 at 09:29 AM");
INSERT INTO crm_audit_log VALUES("2689","3","6","2019-01-16 09:30:23","Exit Invoice [Invoice No: 118276] updated by ASHRAF  M K on 16/01/2019 at 09:30 AM");
INSERT INTO crm_audit_log VALUES("2690","3","4","2019-01-16 10:56:00","Exit Invoice [Invoice No: 118282] updated by Yasir  Rahman on 16/01/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("2691","3","4","2019-01-16 11:08:20","Exit Invoice [Invoice No: 118283] updated by Yasir  Rahman on 16/01/2019 at 11:08 AM");
INSERT INTO crm_audit_log VALUES("2692","3","4","2019-01-16 11:43:47","Exit Invoice [Invoice No: 118284] updated by Yasir  Rahman on 16/01/2019 at 11:43 AM");
INSERT INTO crm_audit_log VALUES("2693","3","4","2019-01-16 12:23:46","Exit Invoice [Invoice No: 118285] updated by Yasir  Rahman on 16/01/2019 at 12:23 PM");
INSERT INTO crm_audit_log VALUES("2694","3","4","2019-01-16 13:11:20","Exit Invoice [Invoice No: 118286] updated by Yasir  Rahman on 16/01/2019 at 01:11 PM");
INSERT INTO crm_audit_log VALUES("2695","2","6","2019-01-16 13:21:05","Entry Invoice [Invoice No: 20007] updated by ASHRAF  M K on 16/01/2019 at 01:21 PM");
INSERT INTO crm_audit_log VALUES("2696","2","7","2019-01-16 13:49:04","Entry Invoice [Invoice No: 20008] updated by ALSED ABU SHAMA on 16/01/2019 at 01:49 PM");
INSERT INTO crm_audit_log VALUES("2697","2","6","2019-01-16 14:48:09","Entry Invoice [Invoice No: 20009] updated by ASHRAF  M K on 16/01/2019 at 02:48 PM");
INSERT INTO crm_audit_log VALUES("2698","3","4","2019-01-16 15:57:55","Exit Invoice [Invoice No: 118287] updated by Yasir  Rahman on 16/01/2019 at 03:57 PM");
INSERT INTO crm_audit_log VALUES("2699","3","4","2019-01-16 16:25:49","Exit Invoice [Invoice No: 118288] updated by Yasir  Rahman on 16/01/2019 at 04:25 PM");
INSERT INTO crm_audit_log VALUES("2700","3","4","2019-01-16 16:28:08","Exit Invoice [Invoice No: 118289] updated by Yasir  Rahman on 16/01/2019 at 04:28 PM");
INSERT INTO crm_audit_log VALUES("2701","3","11","2019-01-16 17:09:12","Exit Invoice [Invoice No: 118290] updated by GAREEB GAREEB on 16/01/2019 at 05:09 PM");
INSERT INTO crm_audit_log VALUES("2702","2","10","2019-01-16 20:17:51","Entry Invoice [Invoice No: 20010] updated by MEDHAT  RAMADAN on 16/01/2019 at 08:17 PM");
INSERT INTO crm_audit_log VALUES("2703","3","5","2019-01-16 22:48:27","Exit Invoice [Invoice No: 118291] updated by Imran  Khan on 16/01/2019 at 10:48 PM");
INSERT INTO crm_audit_log VALUES("2704","3","5","2019-01-16 23:11:27","Exit Invoice [Invoice No: 118292] updated by Imran  Khan on 16/01/2019 at 11:11 PM");
INSERT INTO crm_audit_log VALUES("2705","2","10","2019-01-16 23:20:35","Entry Invoice [Invoice No: 20011] updated by MEDHAT  RAMADAN on 16/01/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("2706","3","5","2019-01-16 23:21:44","Exit Invoice [Invoice No: 118293] updated by Imran  Khan on 16/01/2019 at 11:21 PM");
INSERT INTO crm_audit_log VALUES("2707","3","5","2019-01-16 23:39:25","Exit Invoice [Invoice No: 118294] updated by Imran  Khan on 16/01/2019 at 11:39 PM");
INSERT INTO crm_audit_log VALUES("2708","3","5","2019-01-16 23:41:39","Exit Invoice [Invoice No: 118295] updated by Imran  Khan on 16/01/2019 at 11:41 PM");
INSERT INTO crm_audit_log VALUES("2709","2","10","2019-01-17 01:57:38","Entry Invoice [Invoice No: 20012] updated by MEDHAT  RAMADAN on 17/01/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("2710","2","10","2019-01-17 01:59:24","Entry Invoice [Invoice No: 20013] updated by MEDHAT  RAMADAN on 17/01/2019 at 01:59 AM");
INSERT INTO crm_audit_log VALUES("2711","3","5","2019-01-17 02:29:29","Exit Invoice [Invoice No: 118296] updated by Imran  Khan on 17/01/2019 at 02:29 AM");
INSERT INTO crm_audit_log VALUES("2712","3","5","2019-01-17 02:30:26","Exit Invoice [Invoice No: 118297] updated by Imran  Khan on 17/01/2019 at 02:30 AM");
INSERT INTO crm_audit_log VALUES("2713","3","5","2019-01-17 03:53:03","Exit Invoice [Invoice No: 118298] updated by Imran  Khan on 17/01/2019 at 03:53 AM");
INSERT INTO crm_audit_log VALUES("2714","3","4","2019-01-17 10:59:31","Exit Invoice [Invoice No: 118299] updated by Yasir  Rahman on 17/01/2019 at 10:59 AM");
INSERT INTO crm_audit_log VALUES("2715","3","4","2019-01-17 14:14:36","Exit Invoice [Invoice No: 118300] updated by Yasir  Rahman on 17/01/2019 at 02:14 PM");
INSERT INTO crm_audit_log VALUES("2716","3","4","2019-01-17 14:32:45","Exit Invoice [Invoice No: 118301] updated by Yasir  Rahman on 17/01/2019 at 02:32 PM");
INSERT INTO crm_audit_log VALUES("2717","3","4","2019-01-17 14:36:14","Exit Invoice [Invoice No: 118302] updated by Yasir  Rahman on 17/01/2019 at 02:36 PM");
INSERT INTO crm_audit_log VALUES("2718","3","4","2019-01-17 14:38:01","Exit Invoice [Invoice No: 118303] updated by Yasir  Rahman on 17/01/2019 at 02:38 PM");
INSERT INTO crm_audit_log VALUES("2719","3","4","2019-01-17 14:38:52","Exit Invoice [Invoice No: 118304] updated by Yasir  Rahman on 17/01/2019 at 02:38 PM");
INSERT INTO crm_audit_log VALUES("2720","3","4","2019-01-17 14:42:32","Exit Invoice [Invoice No: 118305] updated by Yasir  Rahman on 17/01/2019 at 02:42 PM");
INSERT INTO crm_audit_log VALUES("2721","3","4","2019-01-17 14:49:15","Exit Invoice [Invoice No: 118306] updated by Yasir  Rahman on 17/01/2019 at 02:49 PM");
INSERT INTO crm_audit_log VALUES("2722","2","7","2019-01-17 18:00:37","Entry Invoice [Invoice No: 20014] updated by ALSED ABU SHAMA on 17/01/2019 at 06:00 PM");
INSERT INTO crm_audit_log VALUES("2723","3","11","2019-01-17 19:05:55","Exit Invoice [Invoice No: 118307] updated by GAREEB GAREEB on 17/01/2019 at 07:05 PM");
INSERT INTO crm_audit_log VALUES("2724","3","11","2019-01-17 19:08:36","Exit Invoice [Invoice No: 118308] updated by GAREEB GAREEB on 17/01/2019 at 07:08 PM");
INSERT INTO crm_audit_log VALUES("2725","3","11","2019-01-17 19:17:47","Exit Invoice [Invoice No: 118309] updated by GAREEB GAREEB on 17/01/2019 at 07:17 PM");
INSERT INTO crm_audit_log VALUES("2726","2","7","2019-01-17 19:23:36","Entry Invoice [Invoice No: 20015] updated by ALSED ABU SHAMA on 17/01/2019 at 07:23 PM");
INSERT INTO crm_audit_log VALUES("2727","2","7","2019-01-17 19:28:27","Entry Invoice [Invoice No: 20016] updated by ALSED ABU SHAMA on 17/01/2019 at 07:28 PM");
INSERT INTO crm_audit_log VALUES("2728","2","7","2019-01-17 19:29:22","Entry Invoice [Invoice No: 20017] updated by ALSED ABU SHAMA on 17/01/2019 at 07:29 PM");
INSERT INTO crm_audit_log VALUES("2729","2","10","2019-01-17 20:48:49","Entry Invoice [Invoice No: 20018] updated by MEDHAT  RAMADAN on 17/01/2019 at 08:48 PM");
INSERT INTO crm_audit_log VALUES("2730","3","5","2019-01-17 21:19:22","Exit Invoice [Invoice No: 118310] updated by Imran  Khan on 17/01/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("2731","2","10","2019-01-17 21:32:04","Entry Invoice [Invoice No: 20019] updated by MEDHAT  RAMADAN on 17/01/2019 at 09:32 PM");
INSERT INTO crm_audit_log VALUES("2732","2","10","2019-01-17 21:41:27","Entry Invoice [Invoice No: 20020] updated by MEDHAT  RAMADAN on 17/01/2019 at 09:41 PM");
INSERT INTO crm_audit_log VALUES("2733","3","5","2019-01-17 21:52:33","Exit Invoice [Invoice No: 118311] updated by Imran  Khan on 17/01/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("2734","3","5","2019-01-17 23:07:17","Exit Invoice [Invoice No: 118312] updated by Imran  Khan on 17/01/2019 at 11:07 PM");
INSERT INTO crm_audit_log VALUES("2735","3","5","2019-01-17 23:11:57","Exit Invoice [Invoice No: 118313] updated by Imran  Khan on 17/01/2019 at 11:11 PM");
INSERT INTO crm_audit_log VALUES("2736","3","5","2019-01-17 23:21:51","Exit Invoice [Invoice No: 118314] updated by Imran  Khan on 17/01/2019 at 11:21 PM");
INSERT INTO crm_audit_log VALUES("2737","3","5","2019-01-18 03:35:57","Exit Invoice [Invoice No: 118315] updated by Imran  Khan on 18/01/2019 at 03:35 AM");
INSERT INTO crm_audit_log VALUES("2738","3","5","2019-01-18 06:22:47","Exit Invoice [Invoice No: 118316] updated by Imran  Khan on 18/01/2019 at 06:22 AM");
INSERT INTO crm_audit_log VALUES("2739","3","4","2019-01-18 09:27:36","Exit Invoice [Invoice No: 118317] updated by Yasir  Rahman on 18/01/2019 at 09:27 AM");
INSERT INTO crm_audit_log VALUES("2740","3","4","2019-01-18 09:29:33","Exit Invoice [Invoice No: 118318] updated by Yasir  Rahman on 18/01/2019 at 09:29 AM");
INSERT INTO crm_audit_log VALUES("2741","3","4","2019-01-18 10:52:11","Exit Invoice [Invoice No: 118319] updated by Yasir  Rahman on 18/01/2019 at 10:52 AM");
INSERT INTO crm_audit_log VALUES("2742","3","4","2019-01-18 11:48:18","Exit Invoice [Invoice No: 118320] updated by Yasir  Rahman on 18/01/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("2743","3","4","2019-01-18 14:11:26","Exit Invoice [Invoice No: 118321] updated by Yasir  Rahman on 18/01/2019 at 02:11 PM");
INSERT INTO crm_audit_log VALUES("2744","3","4","2019-01-18 14:17:06","Exit Invoice [Invoice No: 118322] updated by Yasir  Rahman on 18/01/2019 at 02:17 PM");
INSERT INTO crm_audit_log VALUES("2745","3","4","2019-01-18 14:18:05","Exit Invoice [Invoice No: 118323] updated by Yasir  Rahman on 18/01/2019 at 02:18 PM");
INSERT INTO crm_audit_log VALUES("2746","3","4","2019-01-18 15:01:49","Exit Invoice [Invoice No: 118324] updated by Yasir  Rahman on 18/01/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("2747","3","4","2019-01-18 15:49:45","Exit Invoice [Invoice No: 118325] updated by Yasir  Rahman on 18/01/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("2748","3","4","2019-01-18 15:52:42","Exit Invoice [Invoice No: 118326] updated by Yasir  Rahman on 18/01/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("2749","2","6","2019-01-18 18:05:35","Entry Invoice [Invoice No: 20021] updated by ASHRAF  M K on 18/01/2019 at 06:05 PM");
INSERT INTO crm_audit_log VALUES("2750","1","6","2019-01-18 18:27:02","Customer [Customer No: 414] updated by ASHRAF  M K on 18/01/2019 at 06:27 PM");
INSERT INTO crm_audit_log VALUES("2751","3","11","2019-01-18 18:28:54","Exit Invoice [Invoice No: 118327] updated by GAREEB GAREEB on 18/01/2019 at 06:28 PM");
INSERT INTO crm_audit_log VALUES("2752","3","11","2019-01-18 18:32:27","Exit Invoice [Invoice No: 118328] updated by GAREEB GAREEB on 18/01/2019 at 06:32 PM");
INSERT INTO crm_audit_log VALUES("2753","3","11","2019-01-18 18:33:47","Exit Invoice [Invoice No: 118329] updated by GAREEB GAREEB on 18/01/2019 at 06:33 PM");
INSERT INTO crm_audit_log VALUES("2754","2","10","2019-01-18 21:58:30","Entry Invoice [Invoice No: 20022] updated by MEDHAT  RAMADAN on 18/01/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("2755","2","10","2019-01-18 21:59:21","Entry Invoice [Invoice No: 20023] updated by MEDHAT  RAMADAN on 18/01/2019 at 09:59 PM");
INSERT INTO crm_audit_log VALUES("2756","3","5","2019-01-18 22:39:14","Exit Invoice [Invoice No: 118330] updated by Imran  Khan on 18/01/2019 at 10:39 PM");
INSERT INTO crm_audit_log VALUES("2757","2","10","2019-01-18 23:37:44","Entry Invoice [Invoice No: 20024] updated by MEDHAT  RAMADAN on 18/01/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("2758","3","5","2019-01-18 23:38:30","Exit Invoice [Invoice No: 118331] updated by Imran  Khan on 18/01/2019 at 11:38 PM");
INSERT INTO crm_audit_log VALUES("2759","2","10","2019-01-19 02:15:20","Entry Invoice [Invoice No: 20025] updated by MEDHAT  RAMADAN on 19/01/2019 at 02:15 AM");
INSERT INTO crm_audit_log VALUES("2760","2","10","2019-01-19 02:16:01","Entry Invoice [Invoice No: 20026] updated by MEDHAT  RAMADAN on 19/01/2019 at 02:16 AM");
INSERT INTO crm_audit_log VALUES("2761","2","10","2019-01-19 03:22:36","Entry Invoice [Invoice No: 20027] updated by MEDHAT  RAMADAN on 19/01/2019 at 03:22 AM");
INSERT INTO crm_audit_log VALUES("2762","3","5","2019-01-19 03:35:11","Exit Invoice [Invoice No: 118332] updated by Imran  Khan on 19/01/2019 at 03:35 AM");
INSERT INTO crm_audit_log VALUES("2763","3","5","2019-01-19 03:36:40","Exit Invoice [Invoice No: 118333] updated by Imran  Khan on 19/01/2019 at 03:36 AM");
INSERT INTO crm_audit_log VALUES("2764","3","5","2019-01-19 04:16:19","Exit Invoice [Invoice No: 118334] updated by Imran  Khan on 19/01/2019 at 04:16 AM");
INSERT INTO crm_audit_log VALUES("2765","2","10","2019-01-19 04:41:17","Entry Invoice [Invoice No: 20028] updated by MEDHAT  RAMADAN on 19/01/2019 at 04:41 AM");
INSERT INTO crm_audit_log VALUES("2766","3","5","2019-01-19 04:49:30","Exit Invoice [Invoice No: 118335] updated by Imran  Khan on 19/01/2019 at 04:49 AM");
INSERT INTO crm_audit_log VALUES("2767","2","10","2019-01-19 04:53:59","Entry Invoice [Invoice No: 20029] updated by MEDHAT  RAMADAN on 19/01/2019 at 04:53 AM");
INSERT INTO crm_audit_log VALUES("2768","2","10","2019-01-19 04:55:01","Entry Invoice [Invoice No: 20030] updated by MEDHAT  RAMADAN on 19/01/2019 at 04:55 AM");
INSERT INTO crm_audit_log VALUES("2769","2","10","2019-01-19 04:56:14","Entry Invoice [Invoice No: 20031] updated by MEDHAT  RAMADAN on 19/01/2019 at 04:56 AM");
INSERT INTO crm_audit_log VALUES("2770","2","10","2019-01-19 05:50:53","Entry Invoice [Invoice No: 20032] updated by MEDHAT  RAMADAN on 19/01/2019 at 05:50 AM");
INSERT INTO crm_audit_log VALUES("2771","3","6","2019-01-19 08:54:13","Exit Invoice [Invoice No: 118307] updated by ASHRAF  M K on 19/01/2019 at 08:54 AM");
INSERT INTO crm_audit_log VALUES("2772","3","4","2019-01-19 08:58:49","Exit Invoice [Invoice No: 118336] updated by Yasir  Rahman on 19/01/2019 at 08:58 AM");
INSERT INTO crm_audit_log VALUES("2773","3","4","2019-01-19 11:39:01","Exit Invoice [Invoice No: 118337] updated by Yasir  Rahman on 19/01/2019 at 11:39 AM");
INSERT INTO crm_audit_log VALUES("2774","3","4","2019-01-19 11:39:47","Exit Invoice [Invoice No: 118338] updated by Yasir  Rahman on 19/01/2019 at 11:39 AM");
INSERT INTO crm_audit_log VALUES("2775","2","6","2019-01-19 13:50:45","Entry Invoice [Invoice No: 20033] updated by ASHRAF  M K on 19/01/2019 at 01:50 PM");
INSERT INTO crm_audit_log VALUES("2776","2","6","2019-01-19 14:00:30","Entry Invoice [Invoice No: 20034] updated by ASHRAF  M K on 19/01/2019 at 02:00 PM");
INSERT INTO crm_audit_log VALUES("2777","2","6","2019-01-19 17:58:26","Entry Invoice [Invoice No: 20035] updated by ASHRAF  M K on 19/01/2019 at 05:58 PM");
INSERT INTO crm_audit_log VALUES("2778","2","6","2019-01-19 18:47:29","Entry Invoice [Invoice No: 20036] updated by ASHRAF  M K on 19/01/2019 at 06:47 PM");
INSERT INTO crm_audit_log VALUES("2779","2","6","2019-01-19 18:48:25","Entry Invoice [Invoice No: 20037] updated by ASHRAF  M K on 19/01/2019 at 06:48 PM");
INSERT INTO crm_audit_log VALUES("2780","3","11","2019-01-19 19:24:06","Exit Invoice [Invoice No: 118339] updated by GAREEB GAREEB on 19/01/2019 at 07:24 PM");
INSERT INTO crm_audit_log VALUES("2781","3","11","2019-01-19 19:26:11","Exit Invoice [Invoice No: 118340] updated by GAREEB GAREEB on 19/01/2019 at 07:26 PM");
INSERT INTO crm_audit_log VALUES("2782","3","5","2019-01-19 22:49:18","Exit Invoice [Invoice No: 118341] updated by Imran  Khan on 19/01/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("2783","3","5","2019-01-19 22:50:05","Exit Invoice [Invoice No: 118342] updated by Imran  Khan on 19/01/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("2784","2","10","2019-01-19 23:01:12","Entry Invoice [Invoice No: 20038] updated by MEDHAT  RAMADAN on 19/01/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("2785","2","10","2019-01-20 01:03:07","Entry Invoice [Invoice No: 20039] updated by MEDHAT  RAMADAN on 20/01/2019 at 01:03 AM");
INSERT INTO crm_audit_log VALUES("2786","2","10","2019-01-20 01:04:31","Entry Invoice [Invoice No: 20040] updated by MEDHAT  RAMADAN on 20/01/2019 at 01:04 AM");
INSERT INTO crm_audit_log VALUES("2787","2","10","2019-01-20 03:44:30","Entry Invoice [Invoice No: 20041] updated by MEDHAT  RAMADAN on 20/01/2019 at 03:44 AM");
INSERT INTO crm_audit_log VALUES("2788","3","15","2019-01-20 09:59:23","Exit Invoice [Invoice No: 118343] updated by Abdul Rasheed on 20/01/2019 at 09:59 AM");
INSERT INTO crm_audit_log VALUES("2789","3","15","2019-01-20 11:35:39","Exit Invoice [Invoice No: 118344] updated by Abdul Rasheed on 20/01/2019 at 11:35 AM");
INSERT INTO crm_audit_log VALUES("2790","3","15","2019-01-20 11:37:40","Exit Invoice [Invoice No: 118345] updated by Abdul Rasheed on 20/01/2019 at 11:37 AM");
INSERT INTO crm_audit_log VALUES("2791","3","15","2019-01-20 11:42:20","Exit Invoice [Invoice No: 118346] updated by Abdul Rasheed on 20/01/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("2792","3","6","2019-01-20 11:46:47","Exit Invoice [Invoice No: 118346] updated by ASHRAF  M K on 20/01/2019 at 11:46 AM");
INSERT INTO crm_audit_log VALUES("2793","2","4","2019-01-20 13:56:13","Entry Invoice [Invoice No: 20042] updated by Yasir  Rahman on 20/01/2019 at 01:56 PM");
INSERT INTO crm_audit_log VALUES("2794","3","15","2019-01-20 15:13:11","Exit Invoice [Invoice No: 118347] updated by Abdul Rasheed on 20/01/2019 at 03:13 PM");
INSERT INTO crm_audit_log VALUES("2795","3","11","2019-01-20 18:32:44","Exit Invoice [Invoice No: 118348] updated by GAREEB GAREEB on 20/01/2019 at 06:32 PM");
INSERT INTO crm_audit_log VALUES("2796","3","11","2019-01-20 18:34:19","Exit Invoice [Invoice No: 118349] updated by GAREEB GAREEB on 20/01/2019 at 06:34 PM");
INSERT INTO crm_audit_log VALUES("2797","2","4","2019-01-20 19:47:51","Entry Invoice [Invoice No: 20043] updated by Yasir  Rahman on 20/01/2019 at 07:47 PM");
INSERT INTO crm_audit_log VALUES("2798","2","4","2019-01-20 19:48:51","Entry Invoice [Invoice No: 20044] updated by Yasir  Rahman on 20/01/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("2799","2","10","2019-01-20 20:40:07","Entry Invoice [Invoice No: 20045] updated by MEDHAT  RAMADAN on 20/01/2019 at 08:40 PM");
INSERT INTO crm_audit_log VALUES("2800","3","5","2019-01-20 21:48:51","Exit Invoice [Invoice No: 118350] updated by Imran  Khan on 20/01/2019 at 09:48 PM");
INSERT INTO crm_audit_log VALUES("2801","3","5","2019-01-20 22:07:09","Exit Invoice [Invoice No: 118351] updated by Imran  Khan on 20/01/2019 at 10:07 PM");
INSERT INTO crm_audit_log VALUES("2802","2","10","2019-01-20 22:31:22","Entry Invoice [Invoice No: 20046] updated by MEDHAT  RAMADAN on 20/01/2019 at 10:31 PM");
INSERT INTO crm_audit_log VALUES("2803","2","10","2019-01-20 22:32:14","Entry Invoice [Invoice No: 20047] updated by MEDHAT  RAMADAN on 20/01/2019 at 10:32 PM");
INSERT INTO crm_audit_log VALUES("2804","2","10","2019-01-21 00:06:16","Entry Invoice [Invoice No: 20048] updated by MEDHAT  RAMADAN on 21/01/2019 at 12:06 AM");
INSERT INTO crm_audit_log VALUES("2805","3","5","2019-01-21 05:54:04","Exit Invoice [Invoice No: 118352] updated by Imran  Khan on 21/01/2019 at 05:54 AM");
INSERT INTO crm_audit_log VALUES("2806","3","15","2019-01-21 09:46:52","Exit Invoice [Invoice No: 118353] updated by Abdul Rasheed on 21/01/2019 at 09:46 AM");
INSERT INTO crm_audit_log VALUES("2807","3","15","2019-01-21 10:16:12","Exit Invoice [Invoice No: 118354] updated by Abdul Rasheed on 21/01/2019 at 10:16 AM");
INSERT INTO crm_audit_log VALUES("2808","3","15","2019-01-21 11:26:45","Exit Invoice [Invoice No: 118355] updated by Abdul Rasheed on 21/01/2019 at 11:26 AM");
INSERT INTO crm_audit_log VALUES("2809","3","15","2019-01-21 12:04:18","Exit Invoice [Invoice No: 118356] updated by Abdul Rasheed on 21/01/2019 at 12:04 PM");
INSERT INTO crm_audit_log VALUES("2810","3","6","2019-01-21 12:06:23","Exit Invoice [Invoice No: 118356] updated by ASHRAF  M K on 21/01/2019 at 12:06 PM");
INSERT INTO crm_audit_log VALUES("2811","3","6","2019-01-21 12:13:20","Exit Invoice [Invoice No: 118354] updated by ASHRAF  M K on 21/01/2019 at 12:13 PM");
INSERT INTO crm_audit_log VALUES("2812","3","6","2019-01-21 12:13:37","Exit Invoice [Invoice No: 118353] updated by ASHRAF  M K on 21/01/2019 at 12:13 PM");
INSERT INTO crm_audit_log VALUES("2813","3","15","2019-01-21 13:30:32","Exit Invoice [Invoice No: 118357] updated by Abdul Rasheed on 21/01/2019 at 01:30 PM");
INSERT INTO crm_audit_log VALUES("2814","3","15","2019-01-21 13:36:30","Exit Invoice [Invoice No: 118358] updated by Abdul Rasheed on 21/01/2019 at 01:36 PM");
INSERT INTO crm_audit_log VALUES("2815","2","4","2019-01-21 15:05:56","Entry Invoice [Invoice No: 20049] updated by Yasir  Rahman on 21/01/2019 at 03:05 PM");
INSERT INTO crm_audit_log VALUES("2816","2","4","2019-01-21 18:42:28","Entry Invoice [Invoice No: 20050] updated by Yasir  Rahman on 21/01/2019 at 06:42 PM");
INSERT INTO crm_audit_log VALUES("2817","2","4","2019-01-21 18:47:00","Entry Invoice [Invoice No: 20051] updated by Yasir  Rahman on 21/01/2019 at 06:47 PM");
INSERT INTO crm_audit_log VALUES("2818","2","4","2019-01-21 19:19:42","Entry Invoice [Invoice No: 20052] updated by Yasir  Rahman on 21/01/2019 at 07:19 PM");
INSERT INTO crm_audit_log VALUES("2819","3","5","2019-01-21 20:29:44","Exit Invoice [Invoice No: 118359] updated by Imran  Khan on 21/01/2019 at 08:29 PM");
INSERT INTO crm_audit_log VALUES("2820","3","5","2019-01-21 20:30:36","Exit Invoice [Invoice No: 118360] updated by Imran  Khan on 21/01/2019 at 08:30 PM");
INSERT INTO crm_audit_log VALUES("2821","3","5","2019-01-21 20:33:12","Exit Invoice [Invoice No: 118361] updated by Imran  Khan on 21/01/2019 at 08:33 PM");
INSERT INTO crm_audit_log VALUES("2822","3","5","2019-01-21 21:13:16","Exit Invoice [Invoice No: 118362] updated by Imran  Khan on 21/01/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("2823","2","10","2019-01-21 21:19:21","Entry Invoice [Invoice No: 20053] updated by MEDHAT  RAMADAN on 21/01/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("2824","2","10","2019-01-21 21:20:22","Entry Invoice [Invoice No: 20054] updated by MEDHAT  RAMADAN on 21/01/2019 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("2825","2","10","2019-01-22 00:15:56","Entry Invoice [Invoice No: 20055] updated by MEDHAT  RAMADAN on 22/01/2019 at 12:15 AM");
INSERT INTO crm_audit_log VALUES("2826","3","5","2019-01-22 00:28:52","Exit Invoice [Invoice No: 118363] updated by Imran  Khan on 22/01/2019 at 12:28 AM");
INSERT INTO crm_audit_log VALUES("2827","3","5","2019-01-22 00:54:37","Exit Invoice [Invoice No: 118364] updated by Imran  Khan on 22/01/2019 at 12:54 AM");
INSERT INTO crm_audit_log VALUES("2828","3","5","2019-01-22 01:03:27","Exit Invoice [Invoice No: 118365] updated by Imran  Khan on 22/01/2019 at 01:03 AM");
INSERT INTO crm_audit_log VALUES("2829","2","10","2019-01-22 04:16:54","Entry Invoice [Invoice No: 20056] updated by MEDHAT  RAMADAN on 22/01/2019 at 04:16 AM");
INSERT INTO crm_audit_log VALUES("2830","3","5","2019-01-22 07:36:30","Exit Invoice [Invoice No: 118366] updated by Imran  Khan on 22/01/2019 at 07:36 AM");
INSERT INTO crm_audit_log VALUES("2831","3","4","2019-01-22 10:26:37","Exit Invoice [Invoice No: 118367] updated by Yasir  Rahman on 22/01/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("2832","3","4","2019-01-22 10:28:40","Exit Invoice [Invoice No: 118368] updated by Yasir  Rahman on 22/01/2019 at 10:28 AM");
INSERT INTO crm_audit_log VALUES("2833","3","4","2019-01-22 10:48:13","Exit Invoice [Invoice No: 118369] updated by Yasir  Rahman on 22/01/2019 at 10:48 AM");
INSERT INTO crm_audit_log VALUES("2834","3","6","2019-01-22 11:01:45","Exit Invoice [Invoice No: 118368] updated by ASHRAF  M K on 22/01/2019 at 11:01 AM");
INSERT INTO crm_audit_log VALUES("2835","2","6","2019-01-22 11:52:53","Entry Invoice [Invoice No: 20057] updated by ASHRAF  M K on 22/01/2019 at 11:52 AM");
INSERT INTO crm_audit_log VALUES("2836","3","4","2019-01-22 12:08:52","Exit Invoice [Invoice No: 118370] updated by Yasir  Rahman on 22/01/2019 at 12:08 PM");
INSERT INTO crm_audit_log VALUES("2837","3","4","2019-01-22 12:43:00","Exit Invoice [Invoice No: 118371] updated by Yasir  Rahman on 22/01/2019 at 12:43 PM");
INSERT INTO crm_audit_log VALUES("2838","3","4","2019-01-22 13:00:03","Exit Invoice [Invoice No: 118372] updated by Yasir  Rahman on 22/01/2019 at 01:00 PM");
INSERT INTO crm_audit_log VALUES("2839","2","6","2019-01-22 13:39:36","Entry Invoice [Invoice No: 20058] updated by ASHRAF  M K on 22/01/2019 at 01:39 PM");
INSERT INTO crm_audit_log VALUES("2840","2","6","2019-01-22 13:42:18","Entry Invoice [Invoice No: 20059] updated by ASHRAF  M K on 22/01/2019 at 01:42 PM");
INSERT INTO crm_audit_log VALUES("2841","2","4","2019-01-22 14:42:19","Entry Invoice [Invoice No: 20060] updated by Yasir  Rahman on 22/01/2019 at 02:42 PM");
INSERT INTO crm_audit_log VALUES("2842","2","6","2019-01-22 15:17:06","Entry Invoice [Invoice No: 20061] updated by ASHRAF  M K on 22/01/2019 at 03:17 PM");
INSERT INTO crm_audit_log VALUES("2843","2","6","2019-01-22 15:19:14","Entry Invoice [Invoice No: 20062] updated by ASHRAF  M K on 22/01/2019 at 03:19 PM");
INSERT INTO crm_audit_log VALUES("2844","2","6","2019-01-22 16:02:34","Entry Invoice [Invoice No: 20063] updated by ASHRAF  M K on 22/01/2019 at 04:02 PM");
INSERT INTO crm_audit_log VALUES("2845","3","11","2019-01-22 16:37:35","Exit Invoice [Invoice No: 118373] updated by GAREEB GAREEB on 22/01/2019 at 04:37 PM");
INSERT INTO crm_audit_log VALUES("2846","3","11","2019-01-22 17:30:09","Exit Invoice [Invoice No: 118374] updated by GAREEB GAREEB on 22/01/2019 at 05:30 PM");
INSERT INTO crm_audit_log VALUES("2847","3","11","2019-01-22 17:33:35","Exit Invoice [Invoice No: 118375] updated by GAREEB GAREEB on 22/01/2019 at 05:33 PM");
INSERT INTO crm_audit_log VALUES("2848","2","4","2019-01-22 19:32:06","Entry Invoice [Invoice No: 20064] updated by Yasir  Rahman on 22/01/2019 at 07:32 PM");
INSERT INTO crm_audit_log VALUES("2849","3","5","2019-01-22 20:28:28","Exit Invoice [Invoice No: 118376] updated by Imran  Khan on 22/01/2019 at 08:28 PM");
INSERT INTO crm_audit_log VALUES("2850","2","10","2019-01-22 22:05:48","Entry Invoice [Invoice No: 20065] updated by MEDHAT  RAMADAN on 22/01/2019 at 10:05 PM");
INSERT INTO crm_audit_log VALUES("2851","2","10","2019-01-23 00:32:52","Entry Invoice [Invoice No: 20066] updated by MEDHAT  RAMADAN on 23/01/2019 at 12:32 AM");
INSERT INTO crm_audit_log VALUES("2852","3","5","2019-01-23 01:01:06","Exit Invoice [Invoice No: 118377] updated by Imran  Khan on 23/01/2019 at 01:01 AM");
INSERT INTO crm_audit_log VALUES("2853","2","10","2019-01-23 01:51:52","Entry Invoice [Invoice No: 20067] updated by MEDHAT  RAMADAN on 23/01/2019 at 01:51 AM");
INSERT INTO crm_audit_log VALUES("2854","3","5","2019-01-23 01:52:02","Exit Invoice [Invoice No: 118378] updated by Imran  Khan on 23/01/2019 at 01:52 AM");
INSERT INTO crm_audit_log VALUES("2855","2","10","2019-01-23 04:06:31","Entry Invoice [Invoice No: 20068] updated by MEDHAT  RAMADAN on 23/01/2019 at 04:06 AM");
INSERT INTO crm_audit_log VALUES("2856","2","10","2019-01-23 04:07:23","Entry Invoice [Invoice No: 20069] updated by MEDHAT  RAMADAN on 23/01/2019 at 04:07 AM");
INSERT INTO crm_audit_log VALUES("2857","3","5","2019-01-23 06:32:10","Exit Invoice [Invoice No: 118379] updated by Imran  Khan on 23/01/2019 at 06:32 AM");
INSERT INTO crm_audit_log VALUES("2858","3","5","2019-01-23 06:34:35","Exit Invoice [Invoice No: 118380] updated by Imran  Khan on 23/01/2019 at 06:34 AM");
INSERT INTO crm_audit_log VALUES("2859","3","5","2019-01-23 06:35:41","Exit Invoice [Invoice No: 118381] updated by Imran  Khan on 23/01/2019 at 06:35 AM");
INSERT INTO crm_audit_log VALUES("2860","3","5","2019-01-23 06:36:31","Exit Invoice [Invoice No: 118382] updated by Imran  Khan on 23/01/2019 at 06:36 AM");
INSERT INTO crm_audit_log VALUES("2861","3","4","2019-01-23 08:48:34","Exit Invoice [Invoice No: 118383] updated by Yasir  Rahman on 23/01/2019 at 08:48 AM");
INSERT INTO crm_audit_log VALUES("2862","3","4","2019-01-23 10:43:20","Exit Invoice [Invoice No: 118384] updated by Yasir  Rahman on 23/01/2019 at 10:43 AM");
INSERT INTO crm_audit_log VALUES("2863","3","4","2019-01-23 10:45:37","Exit Invoice [Invoice No: 118385] updated by Yasir  Rahman on 23/01/2019 at 10:45 AM");
INSERT INTO crm_audit_log VALUES("2864","3","4","2019-01-23 10:47:54","Exit Invoice [Invoice No: 118386] updated by Yasir  Rahman on 23/01/2019 at 10:47 AM");
INSERT INTO crm_audit_log VALUES("2865","3","4","2019-01-23 10:49:12","Exit Invoice [Invoice No: 118387] updated by Yasir  Rahman on 23/01/2019 at 10:49 AM");
INSERT INTO crm_audit_log VALUES("2866","3","4","2019-01-23 10:50:32","Exit Invoice [Invoice No: 118388] updated by Yasir  Rahman on 23/01/2019 at 10:50 AM");
INSERT INTO crm_audit_log VALUES("2867","2","4","2019-01-23 11:48:04","Entry Invoice [Invoice No: 20070] updated by Yasir  Rahman on 23/01/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("2868","3","4","2019-01-23 12:01:40","Exit Invoice [Invoice No: 118389] updated by Yasir  Rahman on 23/01/2019 at 12:01 PM");
INSERT INTO crm_audit_log VALUES("2869","3","4","2019-01-23 13:55:18","Exit Invoice [Invoice No: 118390] updated by Yasir  Rahman on 23/01/2019 at 01:55 PM");
INSERT INTO crm_audit_log VALUES("2870","3","4","2019-01-23 15:23:15","Exit Invoice [Invoice No: 118391] updated by Yasir  Rahman on 23/01/2019 at 03:23 PM");
INSERT INTO crm_audit_log VALUES("2871","3","4","2019-01-23 15:42:20","Exit Invoice [Invoice No: 118392] updated by Yasir  Rahman on 23/01/2019 at 03:42 PM");
INSERT INTO crm_audit_log VALUES("2872","3","11","2019-01-23 16:04:57","Exit Invoice [Invoice No: 118393] updated by GAREEB GAREEB on 23/01/2019 at 04:04 PM");
INSERT INTO crm_audit_log VALUES("2873","3","11","2019-01-23 17:14:45","Exit Invoice [Invoice No: 118394] updated by GAREEB GAREEB on 23/01/2019 at 05:14 PM");
INSERT INTO crm_audit_log VALUES("2874","3","11","2019-01-23 17:16:08","Exit Invoice [Invoice No: 118395] updated by GAREEB GAREEB on 23/01/2019 at 05:16 PM");
INSERT INTO crm_audit_log VALUES("2875","3","11","2019-01-23 17:46:26","Exit Invoice [Invoice No: 118396] updated by GAREEB GAREEB on 23/01/2019 at 05:46 PM");
INSERT INTO crm_audit_log VALUES("2876","3","11","2019-01-23 18:40:45","Exit Invoice [Invoice No: 118397] updated by GAREEB GAREEB on 23/01/2019 at 06:40 PM");
INSERT INTO crm_audit_log VALUES("2877","3","11","2019-01-23 18:42:57","Exit Invoice [Invoice No: 118398] updated by GAREEB GAREEB on 23/01/2019 at 06:42 PM");
INSERT INTO crm_audit_log VALUES("2878","2","4","2019-01-23 19:30:47","Entry Invoice [Invoice No: 20071] updated by Yasir  Rahman on 23/01/2019 at 07:30 PM");
INSERT INTO crm_audit_log VALUES("2879","2","4","2019-01-23 19:34:43","Entry Invoice [Invoice No: 20072] updated by Yasir  Rahman on 23/01/2019 at 07:34 PM");
INSERT INTO crm_audit_log VALUES("2880","2","10","2019-01-23 20:30:07","Entry Invoice [Invoice No: 20073] updated by MEDHAT  RAMADAN on 23/01/2019 at 08:30 PM");
INSERT INTO crm_audit_log VALUES("2881","2","6","2019-01-23 21:03:15","Entry Invoice [Invoice No: 20073] updated by ASHRAF  M K on 23/01/2019 at 09:03 PM");
INSERT INTO crm_audit_log VALUES("2882","2","10","2019-01-23 22:09:29","Entry Invoice [Invoice No: 20074] updated by MEDHAT  RAMADAN on 23/01/2019 at 10:09 PM");
INSERT INTO crm_audit_log VALUES("2883","3","5","2019-01-23 22:09:50","Exit Invoice [Invoice No: 118399] updated by Imran  Khan on 23/01/2019 at 10:09 PM");
INSERT INTO crm_audit_log VALUES("2884","2","10","2019-01-23 22:19:21","Entry Invoice [Invoice No: 20075] updated by MEDHAT  RAMADAN on 23/01/2019 at 10:19 PM");
INSERT INTO crm_audit_log VALUES("2885","2","10","2019-01-23 22:49:33","Entry Invoice [Invoice No: 20076] updated by MEDHAT  RAMADAN on 23/01/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("2886","2","10","2019-01-23 22:50:19","Entry Invoice [Invoice No: 20077] updated by MEDHAT  RAMADAN on 23/01/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("2887","2","10","2019-01-23 22:55:38","Entry Invoice [Invoice No: 20078] updated by MEDHAT  RAMADAN on 23/01/2019 at 10:55 PM");
INSERT INTO crm_audit_log VALUES("2888","2","10","2019-01-24 00:23:46","Entry Invoice [Invoice No: 20079] updated by MEDHAT  RAMADAN on 24/01/2019 at 12:23 AM");
INSERT INTO crm_audit_log VALUES("2889","2","10","2019-01-24 00:25:04","Entry Invoice [Invoice No: 20080] updated by MEDHAT  RAMADAN on 24/01/2019 at 12:25 AM");
INSERT INTO crm_audit_log VALUES("2890","3","5","2019-01-24 01:26:54","Exit Invoice [Invoice No: 118400] updated by Imran  Khan on 24/01/2019 at 01:26 AM");
INSERT INTO crm_audit_log VALUES("2891","3","5","2019-01-24 01:27:43","Exit Invoice [Invoice No: 118401] updated by Imran  Khan on 24/01/2019 at 01:27 AM");
INSERT INTO crm_audit_log VALUES("2892","3","5","2019-01-24 01:58:28","Exit Invoice [Invoice No: 118402] updated by Imran  Khan on 24/01/2019 at 01:58 AM");
INSERT INTO crm_audit_log VALUES("2893","2","10","2019-01-24 03:13:36","Entry Invoice [Invoice No: 20081] updated by MEDHAT  RAMADAN on 24/01/2019 at 03:13 AM");
INSERT INTO crm_audit_log VALUES("2894","2","10","2019-01-24 03:14:34","Entry Invoice [Invoice No: 20082] updated by MEDHAT  RAMADAN on 24/01/2019 at 03:14 AM");
INSERT INTO crm_audit_log VALUES("2895","3","5","2019-01-24 04:43:15","Exit Invoice [Invoice No: 118403] updated by Imran  Khan on 24/01/2019 at 04:43 AM");
INSERT INTO crm_audit_log VALUES("2896","3","5","2019-01-24 04:45:55","Exit Invoice [Invoice No: 118404] updated by Imran  Khan on 24/01/2019 at 04:45 AM");
INSERT INTO crm_audit_log VALUES("2897","3","5","2019-01-24 05:23:03","Exit Invoice [Invoice No: 118405] updated by Imran  Khan on 24/01/2019 at 05:23 AM");
INSERT INTO crm_audit_log VALUES("2898","3","5","2019-01-24 06:40:58","Exit Invoice [Invoice No: 118406] updated by Imran  Khan on 24/01/2019 at 06:40 AM");
INSERT INTO crm_audit_log VALUES("2899","3","5","2019-01-24 07:08:44","Exit Invoice [Invoice No: 118407] updated by Imran  Khan on 24/01/2019 at 07:08 AM");
INSERT INTO crm_audit_log VALUES("2900","3","6","2019-01-24 09:07:30","Exit Invoice [Invoice No: 118402] updated by ASHRAF  M K on 24/01/2019 at 09:07 AM");
INSERT INTO crm_audit_log VALUES("2901","3","15","2019-01-24 10:52:54","Exit Invoice [Invoice No: 118408] updated by Abdul Rasheed on 24/01/2019 at 10:52 AM");
INSERT INTO crm_audit_log VALUES("2902","3","15","2019-01-24 10:56:29","Exit Invoice [Invoice No: 118409] updated by Abdul Rasheed on 24/01/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("2903","2","4","2019-01-24 11:37:54","Entry Invoice [Invoice No: 20083] updated by Yasir  Rahman on 24/01/2019 at 11:37 AM");
INSERT INTO crm_audit_log VALUES("2904","2","6","2019-01-24 13:47:20","Entry Invoice [Invoice No: 20084] updated by ASHRAF  M K on 24/01/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("2905","2","6","2019-01-24 13:50:00","Entry Invoice [Invoice No: 20085] updated by ASHRAF  M K on 24/01/2019 at 01:50 PM");
INSERT INTO crm_audit_log VALUES("2906","2","6","2019-01-24 13:51:21","Entry Invoice [Invoice No: 20086] updated by ASHRAF  M K on 24/01/2019 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("2907","2","6","2019-01-24 13:57:07","Entry Invoice [Invoice No: 20087] updated by ASHRAF  M K on 24/01/2019 at 01:57 PM");
INSERT INTO crm_audit_log VALUES("2908","2","4","2019-01-24 14:53:21","Entry Invoice [Invoice No: 20088] updated by Yasir  Rahman on 24/01/2019 at 02:53 PM");
INSERT INTO crm_audit_log VALUES("2909","2","4","2019-01-24 15:01:02","Entry Invoice [Invoice No: 20089] updated by Yasir  Rahman on 24/01/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("2910","2","7","2019-01-24 18:48:54","Entry Invoice [Invoice No: 20090] updated by ALSED ABU SHAMA on 24/01/2019 at 06:48 PM");
INSERT INTO crm_audit_log VALUES("2911","3","11","2019-01-24 18:58:24","Exit Invoice [Invoice No: 118410] updated by GAREEB GAREEB on 24/01/2019 at 06:58 PM");
INSERT INTO crm_audit_log VALUES("2912","3","5","2019-01-24 20:49:14","Exit Invoice [Invoice No: 118411] updated by Imran  Khan on 24/01/2019 at 08:49 PM");
INSERT INTO crm_audit_log VALUES("2913","2","10","2019-01-24 22:35:11","Entry Invoice [Invoice No: 20091] updated by MEDHAT  RAMADAN on 24/01/2019 at 10:35 PM");
INSERT INTO crm_audit_log VALUES("2914","3","5","2019-01-25 00:59:23","Exit Invoice [Invoice No: 118412] updated by Imran  Khan on 25/01/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("2915","3","5","2019-01-25 06:20:36","Exit Invoice [Invoice No: 118413] updated by Imran  Khan on 25/01/2019 at 06:20 AM");
INSERT INTO crm_audit_log VALUES("2916","3","4","2019-01-25 10:22:43","Exit Invoice [Invoice No: 118414] updated by Yasir  Rahman on 25/01/2019 at 10:22 AM");
INSERT INTO crm_audit_log VALUES("2917","3","6","2019-01-25 10:51:02","Exit Invoice [Invoice No: 118414] updated by ASHRAF  M K on 25/01/2019 at 10:51 AM");
INSERT INTO crm_audit_log VALUES("2918","3","4","2019-01-25 11:09:58","Exit Invoice [Invoice No: 118415] updated by Yasir  Rahman on 25/01/2019 at 11:09 AM");
INSERT INTO crm_audit_log VALUES("2919","2","6","2019-01-25 11:30:43","Entry Invoice [Invoice No: 20092] updated by ASHRAF  M K on 25/01/2019 at 11:30 AM");
INSERT INTO crm_audit_log VALUES("2920","3","4","2019-01-25 13:58:26","Exit Invoice [Invoice No: 118416] updated by Yasir  Rahman on 25/01/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("2921","3","4","2019-01-25 13:59:38","Exit Invoice [Invoice No: 118417] updated by Yasir  Rahman on 25/01/2019 at 01:59 PM");
INSERT INTO crm_audit_log VALUES("2922","2","7","2019-01-25 16:08:05","Entry Invoice [Invoice No: 20093] updated by ALSED ABU SHAMA on 25/01/2019 at 04:08 PM");
INSERT INTO crm_audit_log VALUES("2923","3","11","2019-01-25 16:37:38","Exit Invoice [Invoice No: 118418] updated by GAREEB GAREEB on 25/01/2019 at 04:37 PM");
INSERT INTO crm_audit_log VALUES("2924","3","11","2019-01-25 16:38:55","Exit Invoice [Invoice No: 118419] updated by GAREEB GAREEB on 25/01/2019 at 04:38 PM");
INSERT INTO crm_audit_log VALUES("2925","3","11","2019-01-25 16:42:04","Exit Invoice [Invoice No: 118420] updated by GAREEB GAREEB on 25/01/2019 at 04:42 PM");
INSERT INTO crm_audit_log VALUES("2926","3","11","2019-01-25 16:43:39","Exit Invoice [Invoice No: 118421] updated by GAREEB GAREEB on 25/01/2019 at 04:43 PM");
INSERT INTO crm_audit_log VALUES("2927","3","11","2019-01-25 17:07:11","Exit Invoice [Invoice No: 118422] updated by GAREEB GAREEB on 25/01/2019 at 05:07 PM");
INSERT INTO crm_audit_log VALUES("2928","3","11","2019-01-25 17:09:44","Exit Invoice [Invoice No: 118423] updated by GAREEB GAREEB on 25/01/2019 at 05:09 PM");
INSERT INTO crm_audit_log VALUES("2929","2","7","2019-01-25 18:01:15","Entry Invoice [Invoice No: 20094] updated by ALSED ABU SHAMA on 25/01/2019 at 06:01 PM");
INSERT INTO crm_audit_log VALUES("2930","2","7","2019-01-25 18:03:00","Entry Invoice [Invoice No: 20095] updated by ALSED ABU SHAMA on 25/01/2019 at 06:03 PM");
INSERT INTO crm_audit_log VALUES("2931","2","7","2019-01-25 19:06:56","Entry Invoice [Invoice No: 20096] updated by ALSED ABU SHAMA on 25/01/2019 at 07:06 PM");
INSERT INTO crm_audit_log VALUES("2932","2","7","2019-01-25 19:12:50","Entry Invoice [Invoice No: 20097] updated by ALSED ABU SHAMA on 25/01/2019 at 07:12 PM");
INSERT INTO crm_audit_log VALUES("2933","2","10","2019-01-25 20:38:37","Entry Invoice [Invoice No: 20098] updated by MEDHAT  RAMADAN on 25/01/2019 at 08:38 PM");
INSERT INTO crm_audit_log VALUES("2934","3","5","2019-01-25 23:01:33","Exit Invoice [Invoice No: 118424] updated by Imran  Khan on 25/01/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("2935","3","5","2019-01-25 23:37:51","Exit Invoice [Invoice No: 118425] updated by Imran  Khan on 25/01/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("2936","2","10","2019-01-26 00:07:19","Entry Invoice [Invoice No: 20099] updated by MEDHAT  RAMADAN on 26/01/2019 at 12:07 AM");
INSERT INTO crm_audit_log VALUES("2937","3","5","2019-01-26 00:27:37","Exit Invoice [Invoice No: 118426] updated by Imran  Khan on 26/01/2019 at 12:27 AM");
INSERT INTO crm_audit_log VALUES("2938","3","5","2019-01-26 00:28:46","Exit Invoice [Invoice No: 118427] updated by Imran  Khan on 26/01/2019 at 12:28 AM");
INSERT INTO crm_audit_log VALUES("2939","3","5","2019-01-26 01:51:34","Exit Invoice [Invoice No: 118428] updated by Imran  Khan on 26/01/2019 at 01:51 AM");
INSERT INTO crm_audit_log VALUES("2940","3","5","2019-01-26 02:17:04","Exit Invoice [Invoice No: 118429] updated by Imran  Khan on 26/01/2019 at 02:17 AM");
INSERT INTO crm_audit_log VALUES("2941","2","6","2019-01-26 08:36:32","Entry Invoice [Invoice No: 20093] updated by ASHRAF  M K on 26/01/2019 at 08:36 AM");
INSERT INTO crm_audit_log VALUES("2942","3","6","2019-01-26 08:40:40","Exit Invoice [Invoice No: 118425] updated by ASHRAF  M K on 26/01/2019 at 08:40 AM");
INSERT INTO crm_audit_log VALUES("2943","3","15","2019-01-26 09:18:33","Exit Invoice [Invoice No: 118430] updated by Abdul Rasheed on 26/01/2019 at 09:18 AM");
INSERT INTO crm_audit_log VALUES("2944","3","15","2019-01-26 11:42:44","Exit Invoice [Invoice No: 118431] updated by Abdul Rasheed on 26/01/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("2945","2","6","2019-01-26 14:16:43","Entry Invoice [Invoice No: 20100] updated by ASHRAF  M K on 26/01/2019 at 02:16 PM");
INSERT INTO crm_audit_log VALUES("2946","2","6","2019-01-26 15:06:01","Entry Invoice [Invoice No: 20101] updated by ASHRAF  M K on 26/01/2019 at 03:06 PM");
INSERT INTO crm_audit_log VALUES("2947","2","6","2019-01-26 15:08:29","Entry Invoice [Invoice No: 20102] updated by ASHRAF  M K on 26/01/2019 at 03:08 PM");
INSERT INTO crm_audit_log VALUES("2948","2","7","2019-01-26 18:14:54","Entry Invoice [Invoice No: 20103] updated by ALSED ABU SHAMA on 26/01/2019 at 06:14 PM");
INSERT INTO crm_audit_log VALUES("2949","3","11","2019-01-26 18:38:09","Exit Invoice [Invoice No: 118432] updated by GAREEB GAREEB on 26/01/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("2950","2","10","2019-01-26 20:16:41","Entry Invoice [Invoice No: 20104] updated by MEDHAT  RAMADAN on 26/01/2019 at 08:16 PM");
INSERT INTO crm_audit_log VALUES("2951","3","5","2019-01-26 21:08:13","Exit Invoice [Invoice No: 118433] updated by Imran  Khan on 26/01/2019 at 09:08 PM");
INSERT INTO crm_audit_log VALUES("2952","2","10","2019-01-26 21:18:24","Entry Invoice [Invoice No: 20105] updated by MEDHAT  RAMADAN on 26/01/2019 at 09:18 PM");
INSERT INTO crm_audit_log VALUES("2953","2","10","2019-01-26 21:19:32","Entry Invoice [Invoice No: 20106] updated by MEDHAT  RAMADAN on 26/01/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("2954","2","10","2019-01-26 21:20:28","Entry Invoice [Invoice No: 20107] updated by MEDHAT  RAMADAN on 26/01/2019 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("2955","3","5","2019-01-26 22:29:45","Exit Invoice [Invoice No: 118434] updated by Imran  Khan on 26/01/2019 at 10:29 PM");
INSERT INTO crm_audit_log VALUES("2956","3","5","2019-01-26 23:24:46","Exit Invoice [Invoice No: 118435] updated by Imran  Khan on 26/01/2019 at 11:24 PM");
INSERT INTO crm_audit_log VALUES("2957","2","10","2019-01-27 02:20:10","Entry Invoice [Invoice No: 20108] updated by MEDHAT  RAMADAN on 27/01/2019 at 02:20 AM");
INSERT INTO crm_audit_log VALUES("2958","2","10","2019-01-27 02:21:54","Entry Invoice [Invoice No: 20109] updated by MEDHAT  RAMADAN on 27/01/2019 at 02:21 AM");
INSERT INTO crm_audit_log VALUES("2959","3","5","2019-01-27 03:02:51","Exit Invoice [Invoice No: 118436] updated by Imran  Khan on 27/01/2019 at 03:02 AM");
INSERT INTO crm_audit_log VALUES("2960","3","5","2019-01-27 03:03:35","Exit Invoice [Invoice No: 118437] updated by Imran  Khan on 27/01/2019 at 03:03 AM");
INSERT INTO crm_audit_log VALUES("2961","3","5","2019-01-27 04:02:08","Exit Invoice [Invoice No: 118438] updated by Imran  Khan on 27/01/2019 at 04:02 AM");
INSERT INTO crm_audit_log VALUES("2962","3","5","2019-01-27 04:22:31","Exit Invoice [Invoice No: 118439] updated by Imran  Khan on 27/01/2019 at 04:22 AM");
INSERT INTO crm_audit_log VALUES("2963","2","6","2019-01-27 08:22:15","Entry Invoice [Invoice No: 20100] updated by ASHRAF  M K on 27/01/2019 at 08:22 AM");
INSERT INTO crm_audit_log VALUES("2964","3","15","2019-01-27 14:07:44","Exit Invoice [Invoice No: 118440] updated by Abdul Rasheed on 27/01/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("2965","3","15","2019-01-27 14:10:53","Exit Invoice [Invoice No: 118441] updated by Abdul Rasheed on 27/01/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("2966","3","15","2019-01-27 14:17:12","Exit Invoice [Invoice No: 118442] updated by Abdul Rasheed on 27/01/2019 at 02:17 PM");
INSERT INTO crm_audit_log VALUES("2967","3","15","2019-01-27 15:01:58","Exit Invoice [Invoice No: 118443] updated by Abdul Rasheed on 27/01/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("2968","3","15","2019-01-27 15:14:11","Exit Invoice [Invoice No: 118444] updated by Abdul Rasheed on 27/01/2019 at 03:14 PM");
INSERT INTO crm_audit_log VALUES("2969","3","6","2019-01-27 15:30:59","Exit Invoice [Invoice No: 118439] updated by ASHRAF  M K on 27/01/2019 at 03:30 PM");
INSERT INTO crm_audit_log VALUES("2970","3","6","2019-01-27 15:31:41","Exit Invoice [Invoice No: 118436] updated by ASHRAF  M K on 27/01/2019 at 03:31 PM");
INSERT INTO crm_audit_log VALUES("2971","3","6","2019-01-27 15:32:07","Exit Invoice [Invoice No: 118437] updated by ASHRAF  M K on 27/01/2019 at 03:32 PM");
INSERT INTO crm_audit_log VALUES("2972","2","7","2019-01-27 15:44:46","Entry Invoice [Invoice No: 20110] updated by ALSED ABU SHAMA on 27/01/2019 at 03:44 PM");
INSERT INTO crm_audit_log VALUES("2973","2","7","2019-01-27 17:42:26","Entry Invoice [Invoice No: 20111] updated by ALSED ABU SHAMA on 27/01/2019 at 05:42 PM");
INSERT INTO crm_audit_log VALUES("2974","3","11","2019-01-27 18:10:44","Exit Invoice [Invoice No: 118445] updated by GAREEB GAREEB on 27/01/2019 at 06:10 PM");
INSERT INTO crm_audit_log VALUES("2975","2","7","2019-01-27 19:25:18","Entry Invoice [Invoice No: 20112] updated by ALSED ABU SHAMA on 27/01/2019 at 07:25 PM");
INSERT INTO crm_audit_log VALUES("2976","2","7","2019-01-27 19:26:43","Entry Invoice [Invoice No: 20113] updated by ALSED ABU SHAMA on 27/01/2019 at 07:26 PM");
INSERT INTO crm_audit_log VALUES("2977","2","7","2019-01-27 19:33:47","Entry Invoice [Invoice No: 20114] updated by ALSED ABU SHAMA on 27/01/2019 at 07:33 PM");
INSERT INTO crm_audit_log VALUES("2978","3","5","2019-01-27 20:34:20","Exit Invoice [Invoice No: 118446] updated by Imran  Khan on 27/01/2019 at 08:34 PM");
INSERT INTO crm_audit_log VALUES("2979","2","10","2019-01-27 21:40:10","Entry Invoice [Invoice No: 20115] updated by MEDHAT  RAMADAN on 27/01/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("2980","2","10","2019-01-27 21:42:01","Entry Invoice [Invoice No: 20116] updated by MEDHAT  RAMADAN on 27/01/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("2981","2","10","2019-01-27 21:43:03","Entry Invoice [Invoice No: 20117] updated by MEDHAT  RAMADAN on 27/01/2019 at 09:43 PM");
INSERT INTO crm_audit_log VALUES("2982","2","10","2019-01-27 21:44:03","Entry Invoice [Invoice No: 20118] updated by MEDHAT  RAMADAN on 27/01/2019 at 09:44 PM");
INSERT INTO crm_audit_log VALUES("2983","2","10","2019-01-27 21:45:06","Entry Invoice [Invoice No: 20119] updated by MEDHAT  RAMADAN on 27/01/2019 at 09:45 PM");
INSERT INTO crm_audit_log VALUES("2984","2","10","2019-01-27 21:46:10","Entry Invoice [Invoice No: 20120] updated by MEDHAT  RAMADAN on 27/01/2019 at 09:46 PM");
INSERT INTO crm_audit_log VALUES("2985","2","10","2019-01-27 22:06:44","Entry Invoice [Invoice No: 20121] updated by MEDHAT  RAMADAN on 27/01/2019 at 10:06 PM");
INSERT INTO crm_audit_log VALUES("2986","3","5","2019-01-27 23:00:10","Exit Invoice [Invoice No: 118447] updated by Imran  Khan on 27/01/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("2987","2","10","2019-01-27 23:30:18","Entry Invoice [Invoice No: 20122] updated by MEDHAT  RAMADAN on 27/01/2019 at 11:30 PM");
INSERT INTO crm_audit_log VALUES("2988","2","10","2019-01-27 23:32:48","Entry Invoice [Invoice No: 20123] updated by MEDHAT  RAMADAN on 27/01/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("2989","2","10","2019-01-27 23:33:38","Entry Invoice [Invoice No: 20124] updated by MEDHAT  RAMADAN on 27/01/2019 at 11:33 PM");
INSERT INTO crm_audit_log VALUES("2990","2","10","2019-01-27 23:34:24","Entry Invoice [Invoice No: 20125] updated by MEDHAT  RAMADAN on 27/01/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("2991","2","10","2019-01-27 23:35:10","Entry Invoice [Invoice No: 20126] updated by MEDHAT  RAMADAN on 27/01/2019 at 11:35 PM");
INSERT INTO crm_audit_log VALUES("2992","3","5","2019-01-27 23:43:58","Exit Invoice [Invoice No: 118448] updated by Imran  Khan on 27/01/2019 at 11:43 PM");
INSERT INTO crm_audit_log VALUES("2993","3","5","2019-01-28 00:33:39","Exit Invoice [Invoice No: 118449] updated by Imran  Khan on 28/01/2019 at 12:33 AM");
INSERT INTO crm_audit_log VALUES("2994","3","5","2019-01-28 01:46:59","Exit Invoice [Invoice No: 118450] updated by Imran  Khan on 28/01/2019 at 01:46 AM");
INSERT INTO crm_audit_log VALUES("2995","2","10","2019-01-28 04:09:28","Entry Invoice [Invoice No: 20127] updated by MEDHAT  RAMADAN on 28/01/2019 at 04:09 AM");
INSERT INTO crm_audit_log VALUES("2996","3","5","2019-01-28 05:16:37","Exit Invoice [Invoice No: 118451] updated by Imran  Khan on 28/01/2019 at 05:16 AM");
INSERT INTO crm_audit_log VALUES("2997","2","6","2019-01-28 10:21:55","Entry Invoice [Invoice No: 20128] updated by ASHRAF  M K on 28/01/2019 at 10:21 AM");
INSERT INTO crm_audit_log VALUES("2998","2","6","2019-01-28 11:04:00","Entry Invoice [Invoice No: 20129] updated by ASHRAF  M K on 28/01/2019 at 11:04 AM");
INSERT INTO crm_audit_log VALUES("2999","3","15","2019-01-28 11:08:39","Exit Invoice [Invoice No: 118452] updated by Abdul Rasheed on 28/01/2019 at 11:08 AM");
INSERT INTO crm_audit_log VALUES("3000","3","15","2019-01-28 11:17:12","Exit Invoice [Invoice No: 118453] updated by Abdul Rasheed on 28/01/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("3001","3","15","2019-01-28 12:37:27","Exit Invoice [Invoice No: 118454] updated by Abdul Rasheed on 28/01/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("3002","3","15","2019-01-28 15:41:18","Exit Invoice [Invoice No: 118455] updated by Abdul Rasheed on 28/01/2019 at 03:41 PM");
INSERT INTO crm_audit_log VALUES("3003","2","6","2019-01-28 15:47:29","Entry Invoice [Invoice No: 20130] updated by ASHRAF  M K on 28/01/2019 at 03:47 PM");
INSERT INTO crm_audit_log VALUES("3004","2","6","2019-01-28 15:50:12","Entry Invoice [Invoice No: 20131] updated by ASHRAF  M K on 28/01/2019 at 03:50 PM");
INSERT INTO crm_audit_log VALUES("3005","2","7","2019-01-28 16:53:02","Entry Invoice [Invoice No: 20132] updated by ALSED ABU SHAMA on 28/01/2019 at 04:53 PM");
INSERT INTO crm_audit_log VALUES("3006","2","7","2019-01-28 18:23:20","Entry Invoice [Invoice No: 20133] updated by ALSED ABU SHAMA on 28/01/2019 at 06:23 PM");
INSERT INTO crm_audit_log VALUES("3007","3","5","2019-01-28 21:36:08","Exit Invoice [Invoice No: 118456] updated by Imran  Khan on 28/01/2019 at 09:36 PM");
INSERT INTO crm_audit_log VALUES("3008","2","10","2019-01-28 23:03:09","Entry Invoice [Invoice No: 20134] updated by MEDHAT  RAMADAN on 28/01/2019 at 11:03 PM");
INSERT INTO crm_audit_log VALUES("3009","3","5","2019-01-28 23:03:56","Exit Invoice [Invoice No: 118457] updated by Imran  Khan on 28/01/2019 at 11:03 PM");
INSERT INTO crm_audit_log VALUES("3010","2","10","2019-01-29 00:21:13","Entry Invoice [Invoice No: 20135] updated by MEDHAT  RAMADAN on 29/01/2019 at 12:21 AM");
INSERT INTO crm_audit_log VALUES("3011","2","10","2019-01-29 00:22:43","Entry Invoice [Invoice No: 20136] updated by MEDHAT  RAMADAN on 29/01/2019 at 12:22 AM");
INSERT INTO crm_audit_log VALUES("3012","2","10","2019-01-29 00:24:00","Entry Invoice [Invoice No: 20137] updated by MEDHAT  RAMADAN on 29/01/2019 at 12:24 AM");
INSERT INTO crm_audit_log VALUES("3013","3","5","2019-01-29 00:45:16","Exit Invoice [Invoice No: 118458] updated by Imran  Khan on 29/01/2019 at 12:45 AM");
INSERT INTO crm_audit_log VALUES("3014","3","5","2019-01-29 01:43:19","Exit Invoice [Invoice No: 118459] updated by Imran  Khan on 29/01/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("3015","3","5","2019-01-29 03:27:40","Exit Invoice [Invoice No: 118460] updated by Imran  Khan on 29/01/2019 at 03:27 AM");
INSERT INTO crm_audit_log VALUES("3016","3","5","2019-01-29 03:28:28","Exit Invoice [Invoice No: 118461] updated by Imran  Khan on 29/01/2019 at 03:28 AM");
INSERT INTO crm_audit_log VALUES("3017","2","10","2019-01-29 03:44:09","Entry Invoice [Invoice No: 20138] updated by MEDHAT  RAMADAN on 29/01/2019 at 03:44 AM");
INSERT INTO crm_audit_log VALUES("3018","2","10","2019-01-29 03:44:56","Entry Invoice [Invoice No: 20139] updated by MEDHAT  RAMADAN on 29/01/2019 at 03:44 AM");
INSERT INTO crm_audit_log VALUES("3019","3","5","2019-01-29 04:15:15","Exit Invoice [Invoice No: 118462] updated by Imran  Khan on 29/01/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("3020","3","15","2019-01-29 10:14:43","Exit Invoice [Invoice No: 118463] updated by Abdul Rasheed on 29/01/2019 at 10:14 AM");
INSERT INTO crm_audit_log VALUES("3021","2","7","2019-01-29 11:22:12","Entry Invoice [Invoice No: 20140] updated by ALSED ABU SHAMA on 29/01/2019 at 11:22 AM");
INSERT INTO crm_audit_log VALUES("3022","3","15","2019-01-29 12:05:20","Exit Invoice [Invoice No: 118464] updated by Abdul Rasheed on 29/01/2019 at 12:05 PM");
INSERT INTO crm_audit_log VALUES("3023","3","15","2019-01-29 12:06:58","Exit Invoice [Invoice No: 118465] updated by Abdul Rasheed on 29/01/2019 at 12:06 PM");
INSERT INTO crm_audit_log VALUES("3024","2","6","2019-01-29 12:35:44","Entry Invoice [Invoice No: 20141] updated by ASHRAF  M K on 29/01/2019 at 12:35 PM");
INSERT INTO crm_audit_log VALUES("3025","2","6","2019-01-29 13:07:46","Entry Invoice [Invoice No: 20141] updated by ASHRAF  M K on 29/01/2019 at 01:07 PM");
INSERT INTO crm_audit_log VALUES("3026","3","15","2019-01-29 13:54:32","Exit Invoice [Invoice No: 118466] updated by Abdul Rasheed on 29/01/2019 at 01:54 PM");
INSERT INTO crm_audit_log VALUES("3027","3","6","2019-01-29 13:56:23","Exit Invoice [Invoice No: 118466] updated by ASHRAF  M K on 29/01/2019 at 01:56 PM");
INSERT INTO crm_audit_log VALUES("3028","3","6","2019-01-29 14:29:30","Exit Invoice [Invoice No: 118467] updated by ASHRAF  M K on 29/01/2019 at 02:29 PM");
INSERT INTO crm_audit_log VALUES("3029","3","6","2019-01-29 14:40:57","Exit Invoice [Invoice No: 118468] updated by ASHRAF  M K on 29/01/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("3030","2","6","2019-01-29 15:37:22","Entry Invoice [Invoice No: 20142] updated by ASHRAF  M K on 29/01/2019 at 03:37 PM");
INSERT INTO crm_audit_log VALUES("3031","2","6","2019-01-29 15:48:09","Entry Invoice [Invoice No: 20142] updated by ASHRAF  M K on 29/01/2019 at 03:48 PM");
INSERT INTO crm_audit_log VALUES("3032","2","6","2019-01-29 15:49:00","Entry Invoice [Invoice No: 20142] updated by ASHRAF  M K on 29/01/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("3033","2","6","2019-01-29 15:49:27","Entry Invoice [Invoice No: 20142] updated by ASHRAF  M K on 29/01/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("3034","2","6","2019-01-29 15:51:02","Entry Invoice [Invoice No: 20142] updated by ASHRAF  M K on 29/01/2019 at 03:51 PM");
INSERT INTO crm_audit_log VALUES("3035","2","6","2019-01-29 15:51:38","Entry Invoice [Invoice No: 20142] updated by ASHRAF  M K on 29/01/2019 at 03:51 PM");
INSERT INTO crm_audit_log VALUES("3036","3","11","2019-01-29 16:47:04","Exit Invoice [Invoice No: 118469] updated by GAREEB GAREEB on 29/01/2019 at 04:47 PM");
INSERT INTO crm_audit_log VALUES("3037","3","11","2019-01-29 16:48:15","Exit Invoice [Invoice No: 118470] updated by GAREEB GAREEB on 29/01/2019 at 04:48 PM");
INSERT INTO crm_audit_log VALUES("3038","2","7","2019-01-29 19:00:21","Entry Invoice [Invoice No: 20143] updated by ALSED ABU SHAMA on 29/01/2019 at 07:00 PM");
INSERT INTO crm_audit_log VALUES("3039","3","11","2019-01-29 19:06:08","Exit Invoice [Invoice No: 118471] updated by GAREEB GAREEB on 29/01/2019 at 07:06 PM");
INSERT INTO crm_audit_log VALUES("3040","2","10","2019-01-29 20:15:21","Entry Invoice [Invoice No: 20144] updated by MEDHAT  RAMADAN on 29/01/2019 at 08:15 PM");
INSERT INTO crm_audit_log VALUES("3041","3","5","2019-01-29 20:44:03","Exit Invoice [Invoice No: 118472] updated by Imran  Khan on 29/01/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("3042","3","5","2019-01-29 20:53:52","Exit Invoice [Invoice No: 118473] updated by Imran  Khan on 29/01/2019 at 08:53 PM");
INSERT INTO crm_audit_log VALUES("3043","3","5","2019-01-29 21:42:02","Exit Invoice [Invoice No: 118474] updated by Imran  Khan on 29/01/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("3044","3","5","2019-01-29 22:01:29","Exit Invoice [Invoice No: 118475] updated by Imran  Khan on 29/01/2019 at 10:01 PM");
INSERT INTO crm_audit_log VALUES("3045","2","10","2019-01-29 22:05:14","Entry Invoice [Invoice No: 20145] updated by MEDHAT  RAMADAN on 29/01/2019 at 10:05 PM");
INSERT INTO crm_audit_log VALUES("3046","2","10","2019-01-29 22:05:59","Entry Invoice [Invoice No: 20146] updated by MEDHAT  RAMADAN on 29/01/2019 at 10:05 PM");
INSERT INTO crm_audit_log VALUES("3047","2","10","2019-01-29 22:22:00","Entry Invoice [Invoice No: 20147] updated by MEDHAT  RAMADAN on 29/01/2019 at 10:22 PM");
INSERT INTO crm_audit_log VALUES("3048","2","10","2019-01-29 22:24:24","Entry Invoice [Invoice No: 20148] updated by MEDHAT  RAMADAN on 29/01/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("3049","2","10","2019-01-29 22:29:12","Entry Invoice [Invoice No: 20149] updated by MEDHAT  RAMADAN on 29/01/2019 at 10:29 PM");
INSERT INTO crm_audit_log VALUES("3050","3","5","2019-01-29 23:05:05","Exit Invoice [Invoice No: 118476] updated by Imran  Khan on 29/01/2019 at 11:05 PM");
INSERT INTO crm_audit_log VALUES("3051","3","5","2019-01-29 23:12:58","Exit Invoice [Invoice No: 118477] updated by Imran  Khan on 29/01/2019 at 11:12 PM");
INSERT INTO crm_audit_log VALUES("3052","2","10","2019-01-29 23:32:17","Entry Invoice [Invoice No: 20150] updated by MEDHAT  RAMADAN on 29/01/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("3053","2","10","2019-01-29 23:33:46","Entry Invoice [Invoice No: 20151] updated by MEDHAT  RAMADAN on 29/01/2019 at 11:33 PM");
INSERT INTO crm_audit_log VALUES("3054","2","10","2019-01-29 23:36:25","Entry Invoice [Invoice No: 20152] updated by MEDHAT  RAMADAN on 29/01/2019 at 11:36 PM");
INSERT INTO crm_audit_log VALUES("3055","2","10","2019-01-29 23:37:38","Entry Invoice [Invoice No: 20153] updated by MEDHAT  RAMADAN on 29/01/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("3056","2","10","2019-01-29 23:40:31","Entry Invoice [Invoice No: 20154] updated by MEDHAT  RAMADAN on 29/01/2019 at 11:40 PM");
INSERT INTO crm_audit_log VALUES("3057","2","10","2019-01-29 23:41:56","Entry Invoice [Invoice No: 20155] updated by MEDHAT  RAMADAN on 29/01/2019 at 11:41 PM");
INSERT INTO crm_audit_log VALUES("3058","3","5","2019-01-29 23:55:13","Exit Invoice [Invoice No: 118478] updated by Imran  Khan on 29/01/2019 at 11:55 PM");
INSERT INTO crm_audit_log VALUES("3059","3","5","2019-01-30 00:29:50","Exit Invoice [Invoice No: 118479] updated by Imran  Khan on 30/01/2019 at 12:29 AM");
INSERT INTO crm_audit_log VALUES("3060","3","5","2019-01-30 00:31:17","Exit Invoice [Invoice No: 118480] updated by Imran  Khan on 30/01/2019 at 12:31 AM");
INSERT INTO crm_audit_log VALUES("3061","3","5","2019-01-30 01:57:23","Exit Invoice [Invoice No: 118481] updated by Imran  Khan on 30/01/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("3062","3","5","2019-01-30 01:58:13","Exit Invoice [Invoice No: 118482] updated by Imran  Khan on 30/01/2019 at 01:58 AM");
INSERT INTO crm_audit_log VALUES("3063","3","5","2019-01-30 01:58:52","Exit Invoice [Invoice No: 118483] updated by Imran  Khan on 30/01/2019 at 01:58 AM");
INSERT INTO crm_audit_log VALUES("3064","3","5","2019-01-30 03:40:48","Exit Invoice [Invoice No: 118484] updated by Imran  Khan on 30/01/2019 at 03:40 AM");
INSERT INTO crm_audit_log VALUES("3065","3","5","2019-01-30 05:28:54","Exit Invoice [Invoice No: 118485] updated by Imran  Khan on 30/01/2019 at 05:28 AM");
INSERT INTO crm_audit_log VALUES("3066","3","5","2019-01-30 07:13:07","Exit Invoice [Invoice No: 118486] updated by Imran  Khan on 30/01/2019 at 07:13 AM");
INSERT INTO crm_audit_log VALUES("3067","2","6","2019-01-30 08:40:09","Entry Invoice [Invoice No: 20141] updated by ASHRAF  M K on 30/01/2019 at 08:40 AM");
INSERT INTO crm_audit_log VALUES("3068","2","6","2019-01-30 08:41:33","Entry Invoice [Invoice No: 20142] updated by ASHRAF  M K on 30/01/2019 at 08:41 AM");
INSERT INTO crm_audit_log VALUES("3069","3","15","2019-01-30 09:01:31","Exit Invoice [Invoice No: 118487] updated by Abdul Rasheed on 30/01/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("3070","3","15","2019-01-30 10:19:25","Exit Invoice [Invoice No: 118488] updated by Abdul Rasheed on 30/01/2019 at 10:19 AM");
INSERT INTO crm_audit_log VALUES("3071","3","15","2019-01-30 10:23:31","Exit Invoice [Invoice No: 118489] updated by Abdul Rasheed on 30/01/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("3072","3","6","2019-01-30 10:25:02","Exit Invoice [Invoice No: 118489] updated by ASHRAF  M K on 30/01/2019 at 10:25 AM");
INSERT INTO crm_audit_log VALUES("3073","3","6","2019-01-30 10:30:01","Exit Invoice [Invoice No: 118490] updated by ASHRAF  M K on 30/01/2019 at 10:30 AM");
INSERT INTO crm_audit_log VALUES("3074","2","7","2019-01-30 10:56:41","Entry Invoice [Invoice No: 20156] updated by ALSED ABU SHAMA on 30/01/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("3075","3","15","2019-01-30 12:47:08","Exit Invoice [Invoice No: 118491] updated by Abdul Rasheed on 30/01/2019 at 12:47 PM");
INSERT INTO crm_audit_log VALUES("3076","3","15","2019-01-30 13:20:23","Exit Invoice [Invoice No: 118492] updated by Abdul Rasheed on 30/01/2019 at 01:20 PM");
INSERT INTO crm_audit_log VALUES("3077","3","15","2019-01-30 13:53:51","Exit Invoice [Invoice No: 118493] updated by Abdul Rasheed on 30/01/2019 at 01:53 PM");
INSERT INTO crm_audit_log VALUES("3078","3","11","2019-01-30 17:18:27","Exit Invoice [Invoice No: 118494] updated by GAREEB GAREEB on 30/01/2019 at 05:18 PM");
INSERT INTO crm_audit_log VALUES("3079","2","10","2019-01-30 20:46:34","Entry Invoice [Invoice No: 20157] updated by MEDHAT  RAMADAN on 30/01/2019 at 08:46 PM");
INSERT INTO crm_audit_log VALUES("3080","2","10","2019-01-30 20:47:34","Entry Invoice [Invoice No: 20158] updated by MEDHAT  RAMADAN on 30/01/2019 at 08:47 PM");
INSERT INTO crm_audit_log VALUES("3081","3","5","2019-01-30 23:32:44","Exit Invoice [Invoice No: 118495] updated by Imran  Khan on 30/01/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("3082","3","5","2019-01-30 23:41:49","Exit Invoice [Invoice No: 118496] updated by Imran  Khan on 30/01/2019 at 11:41 PM");
INSERT INTO crm_audit_log VALUES("3083","3","5","2019-01-31 00:04:59","Exit Invoice [Invoice No: 118497] updated by Imran  Khan on 31/01/2019 at 12:04 AM");
INSERT INTO crm_audit_log VALUES("3084","3","5","2019-01-31 00:41:35","Exit Invoice [Invoice No: 118498] updated by Imran  Khan on 31/01/2019 at 12:41 AM");
INSERT INTO crm_audit_log VALUES("3085","2","10","2019-01-31 03:45:49","Entry Invoice [Invoice No: 20159] updated by MEDHAT  RAMADAN on 31/01/2019 at 03:45 AM");
INSERT INTO crm_audit_log VALUES("3086","3","15","2019-01-31 08:44:49","Exit Invoice [Invoice No: 118499] updated by Abdul Rasheed on 31/01/2019 at 08:44 AM");
INSERT INTO crm_audit_log VALUES("3087","2","7","2019-01-31 10:58:28","Entry Invoice [Invoice No: 20160] updated by ALSED ABU SHAMA on 31/01/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("3088","2","6","2019-01-31 10:58:31","Entry Invoice [Invoice No: 20161] updated by ASHRAF  M K on 31/01/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("3089","3","15","2019-01-31 11:56:23","Exit Invoice [Invoice No: 118500] updated by Abdul Rasheed on 31/01/2019 at 11:56 AM");
INSERT INTO crm_audit_log VALUES("3090","3","15","2019-01-31 12:10:28","Exit Invoice [Invoice No: 118501] updated by Abdul Rasheed on 31/01/2019 at 12:10 PM");
INSERT INTO crm_audit_log VALUES("3091","2","7","2019-01-31 12:29:05","Entry Invoice [Invoice No: 20162] updated by ALSED ABU SHAMA on 31/01/2019 at 12:29 PM");
INSERT INTO crm_audit_log VALUES("3092","2","7","2019-01-31 12:49:06","Entry Invoice [Invoice No: 20163] updated by ALSED ABU SHAMA on 31/01/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("3093","3","15","2019-01-31 13:09:59","Exit Invoice [Invoice No: 118502] updated by Abdul Rasheed on 31/01/2019 at 01:09 PM");
INSERT INTO crm_audit_log VALUES("3094","2","6","2019-01-31 13:44:27","Entry Invoice [Invoice No: 20164] updated by ASHRAF  M K on 31/01/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("3095","3","15","2019-01-31 14:40:55","Exit Invoice [Invoice No: 118503] updated by Abdul Rasheed on 31/01/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("3096","3","11","2019-01-31 17:06:39","Exit Invoice [Invoice No: 118504] updated by GAREEB GAREEB on 31/01/2019 at 05:06 PM");
INSERT INTO crm_audit_log VALUES("3097","3","11","2019-01-31 17:09:00","Exit Invoice [Invoice No: 118505] updated by GAREEB GAREEB on 31/01/2019 at 05:09 PM");
INSERT INTO crm_audit_log VALUES("3098","2","7","2019-01-31 19:04:52","Entry Invoice [Invoice No: 20165] updated by ALSED ABU SHAMA on 31/01/2019 at 07:04 PM");
INSERT INTO crm_audit_log VALUES("3099","3","11","2019-01-31 19:07:30","Exit Invoice [Invoice No: 118506] updated by GAREEB GAREEB on 31/01/2019 at 07:07 PM");
INSERT INTO crm_audit_log VALUES("3100","2","10","2019-01-31 22:14:28","Entry Invoice [Invoice No: 20166] updated by MEDHAT  RAMADAN on 31/01/2019 at 10:14 PM");
INSERT INTO crm_audit_log VALUES("3101","2","10","2019-01-31 22:15:25","Entry Invoice [Invoice No: 20167] updated by MEDHAT  RAMADAN on 31/01/2019 at 10:15 PM");
INSERT INTO crm_audit_log VALUES("3102","3","5","2019-01-31 23:08:34","Exit Invoice [Invoice No: 118507] updated by Imran  Khan on 31/01/2019 at 11:08 PM");
INSERT INTO crm_audit_log VALUES("3103","2","10","2019-01-31 23:25:19","Entry Invoice [Invoice No: 20168] updated by MEDHAT  RAMADAN on 31/01/2019 at 11:25 PM");
INSERT INTO crm_audit_log VALUES("3104","3","5","2019-01-31 23:34:57","Exit Invoice [Invoice No: 118508] updated by Imran  Khan on 31/01/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("3105","3","5","2019-02-01 01:25:29","Exit Invoice [Invoice No: 118509] updated by Imran  Khan on 01/02/2019 at 01:25 AM");
INSERT INTO crm_audit_log VALUES("3106","3","5","2019-02-01 01:43:39","Exit Invoice [Invoice No: 118510] updated by Imran  Khan on 01/02/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("3107","3","5","2019-02-01 02:31:17","Exit Invoice [Invoice No: 118511] updated by Imran  Khan on 01/02/2019 at 02:31 AM");
INSERT INTO crm_audit_log VALUES("3108","3","5","2019-02-01 05:04:01","Exit Invoice [Invoice No: 118512] updated by Imran  Khan on 01/02/2019 at 05:04 AM");
INSERT INTO crm_audit_log VALUES("3109","3","5","2019-02-01 05:05:07","Exit Invoice [Invoice No: 118513] updated by Imran  Khan on 01/02/2019 at 05:05 AM");
INSERT INTO crm_audit_log VALUES("3110","3","5","2019-02-01 05:30:43","Exit Invoice [Invoice No: 118514] updated by Imran  Khan on 01/02/2019 at 05:30 AM");
INSERT INTO crm_audit_log VALUES("3111","3","4","2019-02-01 09:58:14","Exit Invoice [Invoice No: 118515] updated by Yasir  Rahman on 01/02/2019 at 09:58 AM");
INSERT INTO crm_audit_log VALUES("3112","3","4","2019-02-01 10:40:47","Exit Invoice [Invoice No: 118516] updated by Yasir  Rahman on 01/02/2019 at 10:40 AM");
INSERT INTO crm_audit_log VALUES("3113","3","4","2019-02-01 10:48:47","Exit Invoice [Invoice No: 118517] updated by Yasir  Rahman on 01/02/2019 at 10:48 AM");
INSERT INTO crm_audit_log VALUES("3114","2","15","2019-02-01 11:05:37","Entry Invoice [Invoice No: 20169] updated by Abdul Rasheed on 01/02/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("3115","2","15","2019-02-01 11:08:37","Entry Invoice [Invoice No: 20170] updated by Abdul Rasheed on 01/02/2019 at 11:08 AM");
INSERT INTO crm_audit_log VALUES("3116","2","15","2019-02-01 11:10:37","Entry Invoice [Invoice No: 20171] updated by Abdul Rasheed on 01/02/2019 at 11:10 AM");
INSERT INTO crm_audit_log VALUES("3117","2","15","2019-02-01 11:13:08","Entry Invoice [Invoice No: 20172] updated by Abdul Rasheed on 01/02/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("3118","2","15","2019-02-01 11:14:52","Entry Invoice [Invoice No: 20173] updated by Abdul Rasheed on 01/02/2019 at 11:14 AM");
INSERT INTO crm_audit_log VALUES("3119","2","15","2019-02-01 11:16:46","Entry Invoice [Invoice No: 20174] updated by Abdul Rasheed on 01/02/2019 at 11:16 AM");
INSERT INTO crm_audit_log VALUES("3120","2","6","2019-02-01 11:18:18","Entry Invoice [Invoice No: 20169] updated by ASHRAF  M K on 01/02/2019 at 11:18 AM");
INSERT INTO crm_audit_log VALUES("3121","3","4","2019-02-01 11:38:44","Exit Invoice [Invoice No: 118518] updated by Yasir  Rahman on 01/02/2019 at 11:38 AM");
INSERT INTO crm_audit_log VALUES("3122","3","4","2019-02-01 11:47:40","Exit Invoice [Invoice No: 118519] updated by Yasir  Rahman on 01/02/2019 at 11:47 AM");
INSERT INTO crm_audit_log VALUES("3123","2","7","2019-02-01 14:04:50","Entry Invoice [Invoice No: 20175] updated by ALSED ABU SHAMA on 01/02/2019 at 02:04 PM");
INSERT INTO crm_audit_log VALUES("3124","3","4","2019-02-01 14:41:43","Exit Invoice [Invoice No: 118520] updated by Yasir  Rahman on 01/02/2019 at 02:41 PM");
INSERT INTO crm_audit_log VALUES("3125","3","4","2019-02-01 14:59:31","Exit Invoice [Invoice No: 118521] updated by Yasir  Rahman on 01/02/2019 at 02:59 PM");
INSERT INTO crm_audit_log VALUES("3126","3","11","2019-02-01 20:05:30","Exit Invoice [Invoice No: 118522] updated by GAREEB GAREEB on 01/02/2019 at 08:05 PM");
INSERT INTO crm_audit_log VALUES("3127","3","11","2019-02-01 20:13:15","Exit Invoice [Invoice No: 118523] updated by GAREEB GAREEB on 01/02/2019 at 08:13 PM");
INSERT INTO crm_audit_log VALUES("3128","3","11","2019-02-01 20:14:26","Exit Invoice [Invoice No: 118524] updated by GAREEB GAREEB on 01/02/2019 at 08:14 PM");
INSERT INTO crm_audit_log VALUES("3129","3","11","2019-02-01 20:17:03","Exit Invoice [Invoice No: 118525] updated by GAREEB GAREEB on 01/02/2019 at 08:17 PM");
INSERT INTO crm_audit_log VALUES("3130","2","10","2019-02-01 20:39:13","Entry Invoice [Invoice No: 20176] updated by MEDHAT  RAMADAN on 01/02/2019 at 08:39 PM");
INSERT INTO crm_audit_log VALUES("3131","3","11","2019-02-01 20:40:42","Exit Invoice [Invoice No: 118526] updated by GAREEB GAREEB on 01/02/2019 at 08:40 PM");
INSERT INTO crm_audit_log VALUES("3132","2","10","2019-02-01 20:44:43","Entry Invoice [Invoice No: 20177] updated by MEDHAT  RAMADAN on 01/02/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("3133","2","10","2019-02-01 20:47:06","Entry Invoice [Invoice No: 20178] updated by MEDHAT  RAMADAN on 01/02/2019 at 08:47 PM");
INSERT INTO crm_audit_log VALUES("3134","2","10","2019-02-01 20:47:55","Entry Invoice [Invoice No: 20179] updated by MEDHAT  RAMADAN on 01/02/2019 at 08:47 PM");
INSERT INTO crm_audit_log VALUES("3135","3","11","2019-02-01 21:10:43","Exit Invoice [Invoice No: 118527] updated by GAREEB GAREEB on 01/02/2019 at 09:10 PM");
INSERT INTO crm_audit_log VALUES("3136","2","10","2019-02-01 21:14:12","Entry Invoice [Invoice No: 20180] updated by MEDHAT  RAMADAN on 01/02/2019 at 09:14 PM");
INSERT INTO crm_audit_log VALUES("3137","2","10","2019-02-01 22:17:32","Entry Invoice [Invoice No: 20181] updated by MEDHAT  RAMADAN on 01/02/2019 at 10:17 PM");
INSERT INTO crm_audit_log VALUES("3138","3","11","2019-02-01 22:48:05","Exit Invoice [Invoice No: 118528] updated by GAREEB GAREEB on 01/02/2019 at 10:48 PM");
INSERT INTO crm_audit_log VALUES("3139","3","11","2019-02-01 23:23:47","Exit Invoice [Invoice No: 118529] updated by GAREEB GAREEB on 01/02/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("3140","2","10","2019-02-02 00:04:01","Entry Invoice [Invoice No: 20182] updated by MEDHAT  RAMADAN on 02/02/2019 at 12:04 AM");
INSERT INTO crm_audit_log VALUES("3141","2","10","2019-02-02 00:04:47","Entry Invoice [Invoice No: 20183] updated by MEDHAT  RAMADAN on 02/02/2019 at 12:04 AM");
INSERT INTO crm_audit_log VALUES("3142","2","10","2019-02-02 00:05:47","Entry Invoice [Invoice No: 20184] updated by MEDHAT  RAMADAN on 02/02/2019 at 12:05 AM");
INSERT INTO crm_audit_log VALUES("3143","3","5","2019-02-02 04:13:10","Exit Invoice [Invoice No: 118530] updated by Imran  Khan on 02/02/2019 at 04:13 AM");
INSERT INTO crm_audit_log VALUES("3144","3","4","2019-02-02 10:29:21","Exit Invoice [Invoice No: 118531] updated by Yasir  Rahman on 02/02/2019 at 10:29 AM");
INSERT INTO crm_audit_log VALUES("3145","3","4","2019-02-02 13:12:26","Exit Invoice [Invoice No: 118532] updated by Yasir  Rahman on 02/02/2019 at 01:12 PM");
INSERT INTO crm_audit_log VALUES("3146","3","4","2019-02-02 13:14:31","Exit Invoice [Invoice No: 118533] updated by Yasir  Rahman on 02/02/2019 at 01:14 PM");
INSERT INTO crm_audit_log VALUES("3147","3","6","2019-02-02 13:16:26","Exit Invoice [Invoice No: 118533] updated by ASHRAF  M K on 02/02/2019 at 01:16 PM");
INSERT INTO crm_audit_log VALUES("3148","2","7","2019-02-02 13:18:13","Entry Invoice [Invoice No: 20185] updated by ALSED ABU SHAMA on 02/02/2019 at 01:18 PM");
INSERT INTO crm_audit_log VALUES("3149","3","4","2019-02-02 13:40:57","Exit Invoice [Invoice No: 118534] updated by Yasir  Rahman on 02/02/2019 at 01:40 PM");
INSERT INTO crm_audit_log VALUES("3150","3","4","2019-02-02 13:43:24","Exit Invoice [Invoice No: 118535] updated by Yasir  Rahman on 02/02/2019 at 01:43 PM");
INSERT INTO crm_audit_log VALUES("3151","3","4","2019-02-02 13:51:38","Exit Invoice [Invoice No: 118536] updated by Yasir  Rahman on 02/02/2019 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("3152","3","4","2019-02-02 15:27:39","Exit Invoice [Invoice No: 118537] updated by Yasir  Rahman on 02/02/2019 at 03:27 PM");
INSERT INTO crm_audit_log VALUES("3153","3","11","2019-02-02 16:26:16","Exit Invoice [Invoice No: 118538] updated by GAREEB GAREEB on 02/02/2019 at 04:26 PM");
INSERT INTO crm_audit_log VALUES("3154","2","7","2019-02-02 16:48:05","Entry Invoice [Invoice No: 20186] updated by ALSED ABU SHAMA on 02/02/2019 at 04:48 PM");
INSERT INTO crm_audit_log VALUES("3155","3","11","2019-02-02 18:30:38","Exit Invoice [Invoice No: 118539] updated by GAREEB GAREEB on 02/02/2019 at 06:30 PM");
INSERT INTO crm_audit_log VALUES("3156","2","7","2019-02-02 18:38:35","Entry Invoice [Invoice No: 20187] updated by ALSED ABU SHAMA on 02/02/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("3157","2","7","2019-02-02 18:40:02","Entry Invoice [Invoice No: 20188] updated by ALSED ABU SHAMA on 02/02/2019 at 06:40 PM");
INSERT INTO crm_audit_log VALUES("3158","2","7","2019-02-02 19:02:27","Entry Invoice [Invoice No: 20189] updated by ALSED ABU SHAMA on 02/02/2019 at 07:02 PM");
INSERT INTO crm_audit_log VALUES("3159","2","10","2019-02-02 20:26:31","Entry Invoice [Invoice No: 20190] updated by MEDHAT  RAMADAN on 02/02/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("3160","2","10","2019-02-02 21:30:32","Entry Invoice [Invoice No: 20191] updated by MEDHAT  RAMADAN on 02/02/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("3161","2","10","2019-02-02 22:59:10","Entry Invoice [Invoice No: 20192] updated by MEDHAT  RAMADAN on 02/02/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("3162","3","5","2019-02-03 01:29:17","Exit Invoice [Invoice No: 118540] updated by Imran  Khan on 03/02/2019 at 01:29 AM");
INSERT INTO crm_audit_log VALUES("3163","3","5","2019-02-03 01:58:44","Exit Invoice [Invoice No: 118541] updated by Imran  Khan on 03/02/2019 at 01:58 AM");
INSERT INTO crm_audit_log VALUES("3164","2","6","2019-02-03 09:01:20","Entry Invoice [Invoice No: 20186] updated by ASHRAF  M K on 03/02/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("3165","3","6","2019-02-03 09:02:13","Exit Invoice [Invoice No: 118537] updated by ASHRAF  M K on 03/02/2019 at 09:02 AM");
INSERT INTO crm_audit_log VALUES("3166","2","6","2019-02-03 09:23:41","Entry Invoice [Invoice No: 20192] updated by ASHRAF  M K on 03/02/2019 at 09:23 AM");
INSERT INTO crm_audit_log VALUES("3167","3","4","2019-02-03 12:14:49","Exit Invoice [Invoice No: 118542] updated by Yasir  Rahman on 03/02/2019 at 12:14 PM");
INSERT INTO crm_audit_log VALUES("3168","3","4","2019-02-03 12:16:45","Exit Invoice [Invoice No: 118543] updated by Yasir  Rahman on 03/02/2019 at 12:16 PM");
INSERT INTO crm_audit_log VALUES("3169","3","4","2019-02-03 12:39:48","Exit Invoice [Invoice No: 118544] updated by Yasir  Rahman on 03/02/2019 at 12:39 PM");
INSERT INTO crm_audit_log VALUES("3170","2","7","2019-02-03 12:45:54","Entry Invoice [Invoice No: 20193] updated by ALSED ABU SHAMA on 03/02/2019 at 12:45 PM");
INSERT INTO crm_audit_log VALUES("3171","3","4","2019-02-03 14:35:55","Exit Invoice [Invoice No: 118545] updated by Yasir  Rahman on 03/02/2019 at 02:35 PM");
INSERT INTO crm_audit_log VALUES("3172","2","7","2019-02-03 14:58:56","Entry Invoice [Invoice No: 20194] updated by ALSED ABU SHAMA on 03/02/2019 at 02:58 PM");
INSERT INTO crm_audit_log VALUES("3173","2","7","2019-02-03 18:37:17","Entry Invoice [Invoice No: 20195] updated by ALSED ABU SHAMA on 03/02/2019 at 06:37 PM");
INSERT INTO crm_audit_log VALUES("3174","2","7","2019-02-03 18:38:16","Entry Invoice [Invoice No: 20196] updated by ALSED ABU SHAMA on 03/02/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("3175","2","10","2019-02-03 20:20:30","Entry Invoice [Invoice No: 20197] updated by MEDHAT  RAMADAN on 03/02/2019 at 08:20 PM");
INSERT INTO crm_audit_log VALUES("3176","1","10","2019-02-03 20:32:33","Customer [Customer No: 415] updated by MEDHAT  RAMADAN on 03/02/2019 at 08:32 PM");
INSERT INTO crm_audit_log VALUES("3177","2","10","2019-02-03 20:33:47","Entry Invoice [Invoice No: 20198] updated by MEDHAT  RAMADAN on 03/02/2019 at 08:33 PM");
INSERT INTO crm_audit_log VALUES("3178","3","11","2019-02-03 20:35:05","Exit Invoice [Invoice No: 118546] updated by GAREEB GAREEB on 03/02/2019 at 08:35 PM");
INSERT INTO crm_audit_log VALUES("3179","2","10","2019-02-03 21:06:26","Entry Invoice [Invoice No: 20199] updated by MEDHAT  RAMADAN on 03/02/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("3180","3","11","2019-02-03 22:03:55","Exit Invoice [Invoice No: 118547] updated by GAREEB GAREEB on 03/02/2019 at 10:03 PM");
INSERT INTO crm_audit_log VALUES("3181","2","10","2019-02-03 23:01:13","Entry Invoice [Invoice No: 20200] updated by MEDHAT  RAMADAN on 03/02/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("3182","3","5","2019-02-04 03:45:08","Exit Invoice [Invoice No: 118548] updated by Imran  Khan on 04/02/2019 at 03:45 AM");
INSERT INTO crm_audit_log VALUES("3183","3","4","2019-02-04 08:53:38","Exit Invoice [Invoice No: 118549] updated by Yasir  Rahman on 04/02/2019 at 08:53 AM");
INSERT INTO crm_audit_log VALUES("3184","2","15","2019-02-04 09:59:06","Entry Invoice [Invoice No: 20201] updated by Abdul Rasheed on 04/02/2019 at 09:59 AM");
INSERT INTO crm_audit_log VALUES("3185","2","15","2019-02-04 10:00:10","Entry Invoice [Invoice No: 20202] updated by Abdul Rasheed on 04/02/2019 at 10:00 AM");
INSERT INTO crm_audit_log VALUES("3186","2","15","2019-02-04 10:01:33","Entry Invoice [Invoice No: 20203] updated by Abdul Rasheed on 04/02/2019 at 10:01 AM");
INSERT INTO crm_audit_log VALUES("3187","2","15","2019-02-04 10:09:57","Entry Invoice [Invoice No: 20204] updated by Abdul Rasheed on 04/02/2019 at 10:09 AM");
INSERT INTO crm_audit_log VALUES("3188","2","15","2019-02-04 10:11:03","Entry Invoice [Invoice No: 20205] updated by Abdul Rasheed on 04/02/2019 at 10:11 AM");
INSERT INTO crm_audit_log VALUES("3189","2","15","2019-02-04 10:39:27","Entry Invoice [Invoice No: 20206] updated by Abdul Rasheed on 04/02/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("3190","3","4","2019-02-04 11:05:26","Exit Invoice [Invoice No: 118550] updated by Yasir  Rahman on 04/02/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("3191","3","4","2019-02-04 11:30:37","Exit Invoice [Invoice No: 118551] updated by Yasir  Rahman on 04/02/2019 at 11:30 AM");
INSERT INTO crm_audit_log VALUES("3192","2","7","2019-02-04 11:32:24","Entry Invoice [Invoice No: 20207] updated by ALSED ABU SHAMA on 04/02/2019 at 11:32 AM");
INSERT INTO crm_audit_log VALUES("3193","3","4","2019-02-04 11:37:49","Exit Invoice [Invoice No: 118552] updated by Yasir  Rahman on 04/02/2019 at 11:37 AM");
INSERT INTO crm_audit_log VALUES("3194","2","15","2019-02-04 13:48:33","Entry Invoice [Invoice No: 20208] updated by Abdul Rasheed on 04/02/2019 at 01:48 PM");
INSERT INTO crm_audit_log VALUES("3195","3","11","2019-02-04 17:55:45","Exit Invoice [Invoice No: 118553] updated by GAREEB GAREEB on 04/02/2019 at 05:55 PM");
INSERT INTO crm_audit_log VALUES("3196","3","11","2019-02-04 17:58:21","Exit Invoice [Invoice No: 118554] updated by GAREEB GAREEB on 04/02/2019 at 05:58 PM");
INSERT INTO crm_audit_log VALUES("3197","3","11","2019-02-04 19:54:35","Exit Invoice [Invoice No: 118555] updated by GAREEB GAREEB on 04/02/2019 at 07:54 PM");
INSERT INTO crm_audit_log VALUES("3198","2","10","2019-02-04 20:41:01","Entry Invoice [Invoice No: 20209] updated by MEDHAT  RAMADAN on 04/02/2019 at 08:41 PM");
INSERT INTO crm_audit_log VALUES("3199","2","10","2019-02-04 21:58:01","Entry Invoice [Invoice No: 20210] updated by MEDHAT  RAMADAN on 04/02/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("3200","2","10","2019-02-04 21:59:00","Entry Invoice [Invoice No: 20211] updated by MEDHAT  RAMADAN on 04/02/2019 at 09:59 PM");
INSERT INTO crm_audit_log VALUES("3201","2","10","2019-02-04 21:59:51","Entry Invoice [Invoice No: 20212] updated by MEDHAT  RAMADAN on 04/02/2019 at 09:59 PM");
INSERT INTO crm_audit_log VALUES("3202","3","11","2019-02-04 22:36:40","Exit Invoice [Invoice No: 118556] updated by GAREEB GAREEB on 04/02/2019 at 10:36 PM");
INSERT INTO crm_audit_log VALUES("3203","3","11","2019-02-04 22:41:58","Exit Invoice [Invoice No: 118557] updated by GAREEB GAREEB on 04/02/2019 at 10:41 PM");
INSERT INTO crm_audit_log VALUES("3204","3","11","2019-02-04 23:29:43","Exit Invoice [Invoice No: 118558] updated by GAREEB GAREEB on 04/02/2019 at 11:29 PM");
INSERT INTO crm_audit_log VALUES("3205","2","10","2019-02-05 00:04:06","Entry Invoice [Invoice No: 20213] updated by MEDHAT  RAMADAN on 05/02/2019 at 12:04 AM");
INSERT INTO crm_audit_log VALUES("3206","3","5","2019-02-05 05:31:40","Exit Invoice [Invoice No: 118559] updated by Imran  Khan on 05/02/2019 at 05:31 AM");
INSERT INTO crm_audit_log VALUES("3207","3","5","2019-02-05 06:34:18","Exit Invoice [Invoice No: 118560] updated by Imran  Khan on 05/02/2019 at 06:34 AM");
INSERT INTO crm_audit_log VALUES("3208","2","7","2019-02-05 08:50:43","Entry Invoice [Invoice No: 20214] updated by ALSED ABU SHAMA on 05/02/2019 at 08:50 AM");
INSERT INTO crm_audit_log VALUES("3209","2","15","2019-02-05 11:26:47","Entry Invoice [Invoice No: 20215] updated by Abdul Rasheed on 05/02/2019 at 11:26 AM");
INSERT INTO crm_audit_log VALUES("3210","2","6","2019-02-05 11:27:31","Entry Invoice [Invoice No: 20215] updated by ASHRAF  M K on 05/02/2019 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("3211","3","4","2019-02-05 11:51:10","Exit Invoice [Invoice No: 118561] updated by Yasir  Rahman on 05/02/2019 at 11:51 AM");
INSERT INTO crm_audit_log VALUES("3212","2","7","2019-02-05 12:00:18","Entry Invoice [Invoice No: 20216] updated by ALSED ABU SHAMA on 05/02/2019 at 12:00 PM");
INSERT INTO crm_audit_log VALUES("3213","2","6","2019-02-05 12:02:02","Entry Invoice [Invoice No: 20216] updated by ASHRAF  M K on 05/02/2019 at 12:02 PM");
INSERT INTO crm_audit_log VALUES("3214","2","7","2019-02-05 12:02:08","Entry Invoice [Invoice No: 20217] updated by ALSED ABU SHAMA on 05/02/2019 at 12:02 PM");
INSERT INTO crm_audit_log VALUES("3215","3","4","2019-02-05 13:11:35","Exit Invoice [Invoice No: 118562] updated by Yasir  Rahman on 05/02/2019 at 01:11 PM");
INSERT INTO crm_audit_log VALUES("3216","3","4","2019-02-05 14:27:35","Exit Invoice [Invoice No: 118563] updated by Yasir  Rahman on 05/02/2019 at 02:27 PM");
INSERT INTO crm_audit_log VALUES("3217","2","7","2019-02-05 15:05:14","Entry Invoice [Invoice No: 20218] updated by ALSED ABU SHAMA on 05/02/2019 at 03:05 PM");
INSERT INTO crm_audit_log VALUES("3218","3","4","2019-02-05 15:35:49","Exit Invoice [Invoice No: 118564] updated by Yasir  Rahman on 05/02/2019 at 03:35 PM");
INSERT INTO crm_audit_log VALUES("3219","2","7","2019-02-05 18:31:34","Entry Invoice [Invoice No: 20219] updated by ALSED ABU SHAMA on 05/02/2019 at 06:31 PM");
INSERT INTO crm_audit_log VALUES("3220","2","7","2019-02-05 19:12:06","Entry Invoice [Invoice No: 20220] updated by ALSED ABU SHAMA on 05/02/2019 at 07:12 PM");
INSERT INTO crm_audit_log VALUES("3221","3","11","2019-02-05 20:09:04","Exit Invoice [Invoice No: 118565] updated by GAREEB GAREEB on 05/02/2019 at 08:09 PM");
INSERT INTO crm_audit_log VALUES("3222","3","11","2019-02-05 20:10:28","Exit Invoice [Invoice No: 118566] updated by GAREEB GAREEB on 05/02/2019 at 08:10 PM");
INSERT INTO crm_audit_log VALUES("3223","2","10","2019-02-05 20:44:38","Entry Invoice [Invoice No: 20221] updated by MEDHAT  RAMADAN on 05/02/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("3224","2","10","2019-02-05 20:46:24","Entry Invoice [Invoice No: 20222] updated by MEDHAT  RAMADAN on 05/02/2019 at 08:46 PM");
INSERT INTO crm_audit_log VALUES("3225","2","10","2019-02-05 20:48:13","Entry Invoice [Invoice No: 20223] updated by MEDHAT  RAMADAN on 05/02/2019 at 08:48 PM");
INSERT INTO crm_audit_log VALUES("3226","2","10","2019-02-05 20:54:38","Entry Invoice [Invoice No: 20224] updated by MEDHAT  RAMADAN on 05/02/2019 at 08:54 PM");
INSERT INTO crm_audit_log VALUES("3227","3","11","2019-02-05 22:21:28","Exit Invoice [Invoice No: 118567] updated by GAREEB GAREEB on 05/02/2019 at 10:21 PM");
INSERT INTO crm_audit_log VALUES("3228","3","11","2019-02-05 22:22:57","Exit Invoice [Invoice No: 118568] updated by GAREEB GAREEB on 05/02/2019 at 10:22 PM");
INSERT INTO crm_audit_log VALUES("3229","3","11","2019-02-05 22:23:40","Exit Invoice [Invoice No: 118569] updated by GAREEB GAREEB on 05/02/2019 at 10:23 PM");
INSERT INTO crm_audit_log VALUES("3230","3","11","2019-02-05 22:24:24","Exit Invoice [Invoice No: 118570] updated by GAREEB GAREEB on 05/02/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("3231","3","11","2019-02-05 22:25:07","Exit Invoice [Invoice No: 118571] updated by GAREEB GAREEB on 05/02/2019 at 10:25 PM");
INSERT INTO crm_audit_log VALUES("3232","3","11","2019-02-05 23:43:26","Exit Invoice [Invoice No: 118572] updated by GAREEB GAREEB on 05/02/2019 at 11:43 PM");
INSERT INTO crm_audit_log VALUES("3233","2","10","2019-02-06 01:29:09","Entry Invoice [Invoice No: 20225] updated by MEDHAT  RAMADAN on 06/02/2019 at 01:29 AM");
INSERT INTO crm_audit_log VALUES("3234","2","10","2019-02-06 02:28:09","Entry Invoice [Invoice No: 20226] updated by MEDHAT  RAMADAN on 06/02/2019 at 02:28 AM");
INSERT INTO crm_audit_log VALUES("3235","3","5","2019-02-06 07:27:00","Exit Invoice [Invoice No: 118573] updated by Imran  Khan on 06/02/2019 at 07:27 AM");
INSERT INTO crm_audit_log VALUES("3236","2","7","2019-02-06 09:55:26","Entry Invoice [Invoice No: 20227] updated by ALSED ABU SHAMA on 06/02/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("3237","1","4","2019-02-06 10:28:24","Customer [Customer No: 416] updated by Yasir  Rahman on 06/02/2019 at 10:28 AM");
INSERT INTO crm_audit_log VALUES("3238","3","4","2019-02-06 10:29:51","Exit Invoice [Invoice No: 118574] updated by Yasir  Rahman on 06/02/2019 at 10:29 AM");
INSERT INTO crm_audit_log VALUES("3239","3","4","2019-02-06 10:33:33","Exit Invoice [Invoice No: 118575] updated by Yasir  Rahman on 06/02/2019 at 10:33 AM");
INSERT INTO crm_audit_log VALUES("3240","3","4","2019-02-06 10:55:59","Exit Invoice [Invoice No: 118576] updated by Yasir  Rahman on 06/02/2019 at 10:55 AM");
INSERT INTO crm_audit_log VALUES("3241","3","4","2019-02-06 11:51:11","Exit Invoice [Invoice No: 118577] updated by Yasir  Rahman on 06/02/2019 at 11:51 AM");
INSERT INTO crm_audit_log VALUES("3242","3","4","2019-02-06 12:22:39","Exit Invoice [Invoice No: 118578] updated by Yasir  Rahman on 06/02/2019 at 12:22 PM");
INSERT INTO crm_audit_log VALUES("3243","3","4","2019-02-06 14:56:31","Exit Invoice [Invoice No: 118579] updated by Yasir  Rahman on 06/02/2019 at 02:56 PM");
INSERT INTO crm_audit_log VALUES("3244","3","4","2019-02-06 14:58:54","Exit Invoice [Invoice No: 118580] updated by Yasir  Rahman on 06/02/2019 at 02:58 PM");
INSERT INTO crm_audit_log VALUES("3245","3","4","2019-02-06 14:59:55","Exit Invoice [Invoice No: 118581] updated by Yasir  Rahman on 06/02/2019 at 02:59 PM");
INSERT INTO crm_audit_log VALUES("3246","3","4","2019-02-06 15:00:59","Exit Invoice [Invoice No: 118582] updated by Yasir  Rahman on 06/02/2019 at 03:00 PM");
INSERT INTO crm_audit_log VALUES("3247","3","11","2019-02-06 16:43:08","Exit Invoice [Invoice No: 118583] updated by GAREEB GAREEB on 06/02/2019 at 04:43 PM");
INSERT INTO crm_audit_log VALUES("3248","3","11","2019-02-06 16:55:28","Exit Invoice [Invoice No: 118584] updated by GAREEB GAREEB on 06/02/2019 at 04:55 PM");
INSERT INTO crm_audit_log VALUES("3249","3","11","2019-02-06 16:56:44","Exit Invoice [Invoice No: 118585] updated by GAREEB GAREEB on 06/02/2019 at 04:56 PM");
INSERT INTO crm_audit_log VALUES("3250","3","11","2019-02-06 17:13:17","Exit Invoice [Invoice No: 118586] updated by GAREEB GAREEB on 06/02/2019 at 05:13 PM");
INSERT INTO crm_audit_log VALUES("3251","2","15","2019-02-06 17:38:42","Entry Invoice [Invoice No: 20228] updated by Abdul Rasheed on 06/02/2019 at 05:38 PM");
INSERT INTO crm_audit_log VALUES("3252","3","11","2019-02-06 18:00:15","Exit Invoice [Invoice No: 118587] updated by GAREEB GAREEB on 06/02/2019 at 06:00 PM");
INSERT INTO crm_audit_log VALUES("3253","3","11","2019-02-06 18:21:08","Exit Invoice [Invoice No: 118588] updated by GAREEB GAREEB on 06/02/2019 at 06:21 PM");
INSERT INTO crm_audit_log VALUES("3254","3","11","2019-02-06 18:22:00","Exit Invoice [Invoice No: 118589] updated by GAREEB GAREEB on 06/02/2019 at 06:22 PM");
INSERT INTO crm_audit_log VALUES("3255","3","11","2019-02-06 18:37:07","Exit Invoice [Invoice No: 118590] updated by GAREEB GAREEB on 06/02/2019 at 06:37 PM");
INSERT INTO crm_audit_log VALUES("3256","3","11","2019-02-06 21:05:25","Exit Invoice [Invoice No: 118591] updated by GAREEB GAREEB on 06/02/2019 at 09:05 PM");
INSERT INTO crm_audit_log VALUES("3257","3","11","2019-02-06 22:22:58","Exit Invoice [Invoice No: 118592] updated by GAREEB GAREEB on 06/02/2019 at 10:22 PM");
INSERT INTO crm_audit_log VALUES("3258","2","10","2019-02-06 22:34:17","Entry Invoice [Invoice No: 20229] updated by MEDHAT  RAMADAN on 06/02/2019 at 10:34 PM");
INSERT INTO crm_audit_log VALUES("3259","2","10","2019-02-06 22:35:27","Entry Invoice [Invoice No: 20230] updated by MEDHAT  RAMADAN on 06/02/2019 at 10:35 PM");
INSERT INTO crm_audit_log VALUES("3260","2","10","2019-02-06 23:06:16","Entry Invoice [Invoice No: 20231] updated by MEDHAT  RAMADAN on 06/02/2019 at 11:06 PM");
INSERT INTO crm_audit_log VALUES("3261","2","10","2019-02-07 00:08:32","Entry Invoice [Invoice No: 20232] updated by MEDHAT  RAMADAN on 07/02/2019 at 12:08 AM");
INSERT INTO crm_audit_log VALUES("3262","2","10","2019-02-07 00:10:57","Entry Invoice [Invoice No: 20233] updated by MEDHAT  RAMADAN on 07/02/2019 at 12:10 AM");
INSERT INTO crm_audit_log VALUES("3263","3","5","2019-02-07 00:47:57","Exit Invoice [Invoice No: 118593] updated by Imran  Khan on 07/02/2019 at 12:47 AM");
INSERT INTO crm_audit_log VALUES("3264","3","5","2019-02-07 00:48:48","Exit Invoice [Invoice No: 118594] updated by Imran  Khan on 07/02/2019 at 12:48 AM");
INSERT INTO crm_audit_log VALUES("3265","3","5","2019-02-07 02:12:17","Exit Invoice [Invoice No: 118595] updated by Imran  Khan on 07/02/2019 at 02:12 AM");
INSERT INTO crm_audit_log VALUES("3266","3","5","2019-02-07 05:24:53","Exit Invoice [Invoice No: 118596] updated by Imran  Khan on 07/02/2019 at 05:24 AM");
INSERT INTO crm_audit_log VALUES("3267","3","5","2019-02-07 05:48:44","Exit Invoice [Invoice No: 118597] updated by Imran  Khan on 07/02/2019 at 05:48 AM");
INSERT INTO crm_audit_log VALUES("3268","3","4","2019-02-07 10:40:42","Exit Invoice [Invoice No: 118598] updated by Yasir  Rahman on 07/02/2019 at 10:40 AM");
INSERT INTO crm_audit_log VALUES("3269","2","15","2019-02-07 15:10:16","Entry Invoice [Invoice No: 20234] updated by Abdul Rasheed on 07/02/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("3270","2","15","2019-02-07 15:12:25","Entry Invoice [Invoice No: 20235] updated by Abdul Rasheed on 07/02/2019 at 03:12 PM");
INSERT INTO crm_audit_log VALUES("3271","2","15","2019-02-07 15:14:40","Entry Invoice [Invoice No: 20236] updated by Abdul Rasheed on 07/02/2019 at 03:14 PM");
INSERT INTO crm_audit_log VALUES("3272","2","6","2019-02-07 15:16:19","Entry Invoice [Invoice No: 20236] updated by ASHRAF  M K on 07/02/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("3273","2","6","2019-02-07 15:16:34","Entry Invoice [Invoice No: 20235] updated by ASHRAF  M K on 07/02/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("3274","2","6","2019-02-07 15:16:52","Entry Invoice [Invoice No: 20234] updated by ASHRAF  M K on 07/02/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("3275","2","6","2019-02-07 15:22:32","Entry Invoice [Invoice No: 20237] updated by ASHRAF  M K on 07/02/2019 at 03:22 PM");
INSERT INTO crm_audit_log VALUES("3276","2","6","2019-02-07 15:24:46","Entry Invoice [Invoice No: 20238] updated by ASHRAF  M K on 07/02/2019 at 03:24 PM");
INSERT INTO crm_audit_log VALUES("3277","1","15","2019-02-07 16:07:06","Customer [Customer No: 417] updated by Abdul Rasheed on 07/02/2019 at 04:07 PM");
INSERT INTO crm_audit_log VALUES("3278","2","15","2019-02-07 16:11:13","Entry Invoice [Invoice No: 20239] updated by Abdul Rasheed on 07/02/2019 at 04:11 PM");
INSERT INTO crm_audit_log VALUES("3279","1","15","2019-02-07 16:18:34","Customer [Customer No: 418] updated by Abdul Rasheed on 07/02/2019 at 04:18 PM");
INSERT INTO crm_audit_log VALUES("3280","1","6","2019-02-07 16:20:10","Customer [Customer No: 418] updated by ASHRAF  M K on 07/02/2019 at 04:20 PM");
INSERT INTO crm_audit_log VALUES("3281","2","6","2019-02-07 16:22:56","Entry Invoice [Invoice No: 20240] updated by ASHRAF  M K on 07/02/2019 at 04:22 PM");
INSERT INTO crm_audit_log VALUES("3282","2","6","2019-02-07 16:23:23","Entry Invoice [Invoice No: 20239] updated by ASHRAF  M K on 07/02/2019 at 04:23 PM");
INSERT INTO crm_audit_log VALUES("3283","2","6","2019-02-07 16:25:45","Entry Invoice [Invoice No: 20241] updated by ASHRAF  M K on 07/02/2019 at 04:25 PM");
INSERT INTO crm_audit_log VALUES("3284","2","6","2019-02-07 16:27:29","Entry Invoice [Invoice No: 20242] updated by ASHRAF  M K on 07/02/2019 at 04:27 PM");
INSERT INTO crm_audit_log VALUES("3285","2","6","2019-02-07 16:29:04","Entry Invoice [Invoice No: 20243] updated by ASHRAF  M K on 07/02/2019 at 04:29 PM");
INSERT INTO crm_audit_log VALUES("3286","2","6","2019-02-07 16:36:15","Entry Invoice [Invoice No: 20234] updated by ASHRAF  M K on 07/02/2019 at 04:36 PM");
INSERT INTO crm_audit_log VALUES("3287","2","6","2019-02-07 16:36:47","Entry Invoice [Invoice No: 20235] updated by ASHRAF  M K on 07/02/2019 at 04:36 PM");
INSERT INTO crm_audit_log VALUES("3288","2","6","2019-02-07 16:37:14","Entry Invoice [Invoice No: 20236] updated by ASHRAF  M K on 07/02/2019 at 04:37 PM");
INSERT INTO crm_audit_log VALUES("3289","3","11","2019-02-07 19:03:34","Exit Invoice [Invoice No: 118599] updated by GAREEB GAREEB on 07/02/2019 at 07:03 PM");
INSERT INTO crm_audit_log VALUES("3290","3","11","2019-02-07 19:04:28","Exit Invoice [Invoice No: 118600] updated by GAREEB GAREEB on 07/02/2019 at 07:04 PM");
INSERT INTO crm_audit_log VALUES("3291","2","7","2019-02-07 19:42:11","Entry Invoice [Invoice No: 20244] updated by ALSED ABU SHAMA on 07/02/2019 at 07:42 PM");
INSERT INTO crm_audit_log VALUES("3292","3","11","2019-02-07 20:06:58","Exit Invoice [Invoice No: 118601] updated by GAREEB GAREEB on 07/02/2019 at 08:06 PM");
INSERT INTO crm_audit_log VALUES("3293","2","10","2019-02-07 20:54:23","Entry Invoice [Invoice No: 20245] updated by MEDHAT  RAMADAN on 07/02/2019 at 08:54 PM");
INSERT INTO crm_audit_log VALUES("3294","2","10","2019-02-07 20:55:11","Entry Invoice [Invoice No: 20246] updated by MEDHAT  RAMADAN on 07/02/2019 at 08:55 PM");
INSERT INTO crm_audit_log VALUES("3295","3","11","2019-02-07 21:04:24","Exit Invoice [Invoice No: 118602] updated by GAREEB GAREEB on 07/02/2019 at 09:04 PM");
INSERT INTO crm_audit_log VALUES("3296","3","11","2019-02-07 21:05:24","Exit Invoice [Invoice No: 118603] updated by GAREEB GAREEB on 07/02/2019 at 09:05 PM");
INSERT INTO crm_audit_log VALUES("3297","2","10","2019-02-07 21:24:37","Entry Invoice [Invoice No: 20247] updated by MEDHAT  RAMADAN on 07/02/2019 at 09:24 PM");
INSERT INTO crm_audit_log VALUES("3298","2","10","2019-02-07 21:29:04","Entry Invoice [Invoice No: 20248] updated by MEDHAT  RAMADAN on 07/02/2019 at 09:29 PM");
INSERT INTO crm_audit_log VALUES("3299","3","11","2019-02-07 22:32:02","Exit Invoice [Invoice No: 118604] updated by GAREEB GAREEB on 07/02/2019 at 10:32 PM");
INSERT INTO crm_audit_log VALUES("3300","3","5","2019-02-08 00:35:07","Exit Invoice [Invoice No: 118605] updated by Imran  Khan on 08/02/2019 at 12:35 AM");
INSERT INTO crm_audit_log VALUES("3301","3","5","2019-02-08 01:04:00","Exit Invoice [Invoice No: 118606] updated by Imran  Khan on 08/02/2019 at 01:04 AM");
INSERT INTO crm_audit_log VALUES("3302","3","5","2019-02-08 02:01:32","Exit Invoice [Invoice No: 118607] updated by Imran  Khan on 08/02/2019 at 02:01 AM");
INSERT INTO crm_audit_log VALUES("3303","3","5","2019-02-08 02:02:11","Exit Invoice [Invoice No: 118608] updated by Imran  Khan on 08/02/2019 at 02:02 AM");
INSERT INTO crm_audit_log VALUES("3304","1","5","2019-02-08 02:51:33","Customer [Customer No: 419] updated by Imran  Khan on 08/02/2019 at 02:51 AM");
INSERT INTO crm_audit_log VALUES("3305","3","5","2019-02-08 02:52:11","Exit Invoice [Invoice No: 118609] updated by Imran  Khan on 08/02/2019 at 02:52 AM");
INSERT INTO crm_audit_log VALUES("3306","3","4","2019-02-08 08:39:32","Exit Invoice [Invoice No: 118610] updated by Yasir  Rahman on 08/02/2019 at 08:39 AM");
INSERT INTO crm_audit_log VALUES("3307","2","6","2019-02-08 08:44:09","Entry Invoice [Invoice No: 20234] updated by ASHRAF  M K on 08/02/2019 at 08:44 AM");
INSERT INTO crm_audit_log VALUES("3308","2","6","2019-02-08 08:50:45","Entry Invoice [Invoice No: 20234] updated by ASHRAF  M K on 08/02/2019 at 08:50 AM");
INSERT INTO crm_audit_log VALUES("3309","2","6","2019-02-08 08:51:06","Entry Invoice [Invoice No: 20235] updated by ASHRAF  M K on 08/02/2019 at 08:51 AM");
INSERT INTO crm_audit_log VALUES("3310","2","6","2019-02-08 08:52:19","Entry Invoice [Invoice No: 20236] updated by ASHRAF  M K on 08/02/2019 at 08:52 AM");
INSERT INTO crm_audit_log VALUES("3311","3","4","2019-02-08 10:04:44","Exit Invoice [Invoice No: 118611] updated by Yasir  Rahman on 08/02/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("3312","3","4","2019-02-08 10:56:31","Exit Invoice [Invoice No: 118612] updated by Yasir  Rahman on 08/02/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("3313","2","7","2019-02-08 11:12:43","Entry Invoice [Invoice No: 20249] updated by ALSED ABU SHAMA on 08/02/2019 at 11:12 AM");
INSERT INTO crm_audit_log VALUES("3314","2","15","2019-02-08 11:32:27","Entry Invoice [Invoice No: 20250] updated by Abdul Rasheed on 08/02/2019 at 11:32 AM");
INSERT INTO crm_audit_log VALUES("3315","2","15","2019-02-08 11:33:29","Entry Invoice [Invoice No: 20251] updated by Abdul Rasheed on 08/02/2019 at 11:33 AM");
INSERT INTO crm_audit_log VALUES("3316","2","15","2019-02-08 11:35:32","Entry Invoice [Invoice No: 20252] updated by Abdul Rasheed on 08/02/2019 at 11:35 AM");
INSERT INTO crm_audit_log VALUES("3317","2","15","2019-02-08 11:36:44","Entry Invoice [Invoice No: 20253] updated by Abdul Rasheed on 08/02/2019 at 11:36 AM");
INSERT INTO crm_audit_log VALUES("3318","3","4","2019-02-08 14:38:38","Exit Invoice [Invoice No: 118613] updated by Yasir  Rahman on 08/02/2019 at 02:38 PM");
INSERT INTO crm_audit_log VALUES("3319","3","4","2019-02-08 18:39:33","Exit Invoice [Invoice No: 118614] updated by Yasir  Rahman on 08/02/2019 at 06:39 PM");
INSERT INTO crm_audit_log VALUES("3320","2","11","2019-02-08 20:26:05","Entry Invoice [Invoice No: 20254] updated by GAREEB GAREEB on 08/02/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("3321","3","5","2019-02-08 21:03:59","Exit Invoice [Invoice No: 118615] updated by Imran  Khan on 08/02/2019 at 09:03 PM");
INSERT INTO crm_audit_log VALUES("3322","3","5","2019-02-08 21:06:51","Exit Invoice [Invoice No: 118616] updated by Imran  Khan on 08/02/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("3323","3","5","2019-02-08 21:07:34","Exit Invoice [Invoice No: 118617] updated by Imran  Khan on 08/02/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("3324","3","11","2019-02-08 22:47:29","Exit Invoice [Invoice No: 118618] updated by GAREEB GAREEB on 08/02/2019 at 10:47 PM");
INSERT INTO crm_audit_log VALUES("3325","2","11","2019-02-08 22:55:22","Entry Invoice [Invoice No: 20255] updated by GAREEB GAREEB on 08/02/2019 at 10:55 PM");
INSERT INTO crm_audit_log VALUES("3326","2","11","2019-02-08 23:05:45","Entry Invoice [Invoice No: 20256] updated by GAREEB GAREEB on 08/02/2019 at 11:05 PM");
INSERT INTO crm_audit_log VALUES("3327","3","5","2019-02-09 01:27:13","Exit Invoice [Invoice No: 118619] updated by Imran  Khan on 09/02/2019 at 01:27 AM");
INSERT INTO crm_audit_log VALUES("3328","2","11","2019-02-09 02:47:43","Entry Invoice [Invoice No: 20257] updated by GAREEB GAREEB on 09/02/2019 at 02:47 AM");
INSERT INTO crm_audit_log VALUES("3329","2","11","2019-02-09 02:54:13","Entry Invoice [Invoice No: 20258] updated by GAREEB GAREEB on 09/02/2019 at 02:54 AM");
INSERT INTO crm_audit_log VALUES("3330","2","6","2019-02-09 08:29:27","Entry Invoice [Invoice No: 20256] updated by ASHRAF  M K on 09/02/2019 at 08:29 AM");
INSERT INTO crm_audit_log VALUES("3331","2","6","2019-02-09 08:30:44","Entry Invoice [Invoice No: 20256] updated by ASHRAF  M K on 09/02/2019 at 08:30 AM");
INSERT INTO crm_audit_log VALUES("3332","3","4","2019-02-09 09:59:23","Exit Invoice [Invoice No: 118620] updated by Yasir  Rahman on 09/02/2019 at 09:59 AM");
INSERT INTO crm_audit_log VALUES("3333","3","4","2019-02-09 10:14:14","Exit Invoice [Invoice No: 118621] updated by Yasir  Rahman on 09/02/2019 at 10:14 AM");
INSERT INTO crm_audit_log VALUES("3334","3","6","2019-02-09 10:15:15","Exit Invoice [Invoice No: 118621] updated by ASHRAF  M K on 09/02/2019 at 10:15 AM");
INSERT INTO crm_audit_log VALUES("3335","2","15","2019-02-09 11:31:50","Entry Invoice [Invoice No: 20259] updated by Abdul Rasheed on 09/02/2019 at 11:31 AM");
INSERT INTO crm_audit_log VALUES("3336","2","15","2019-02-09 11:32:47","Entry Invoice [Invoice No: 20260] updated by Abdul Rasheed on 09/02/2019 at 11:32 AM");
INSERT INTO crm_audit_log VALUES("3337","3","4","2019-02-09 13:37:14","Exit Invoice [Invoice No: 118622] updated by Yasir  Rahman on 09/02/2019 at 01:37 PM");
INSERT INTO crm_audit_log VALUES("3338","2","7","2019-02-09 13:58:54","Entry Invoice [Invoice No: 20261] updated by ALSED ABU SHAMA on 09/02/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("3339","2","15","2019-02-09 14:03:20","Entry Invoice [Invoice No: 20262] updated by Abdul Rasheed on 09/02/2019 at 02:03 PM");
INSERT INTO crm_audit_log VALUES("3340","2","6","2019-02-09 14:04:54","Entry Invoice [Invoice No: 20262] updated by ASHRAF  M K on 09/02/2019 at 02:04 PM");
INSERT INTO crm_audit_log VALUES("3341","3","4","2019-02-09 14:25:38","Exit Invoice [Invoice No: 118623] updated by Yasir  Rahman on 09/02/2019 at 02:25 PM");
INSERT INTO crm_audit_log VALUES("3342","2","15","2019-02-09 15:16:45","Entry Invoice [Invoice No: 20263] updated by Abdul Rasheed on 09/02/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("3343","2","7","2019-02-09 18:30:18","Entry Invoice [Invoice No: 20264] updated by ALSED ABU SHAMA on 09/02/2019 at 06:30 PM");
INSERT INTO crm_audit_log VALUES("3344","3","7","2019-02-09 18:45:18","Exit Invoice [Invoice No: 118624] updated by ALSED ABU SHAMA on 09/02/2019 at 06:45 PM");
INSERT INTO crm_audit_log VALUES("3345","2","7","2019-02-09 19:11:44","Entry Invoice [Invoice No: 20265] updated by ALSED ABU SHAMA on 09/02/2019 at 07:11 PM");
INSERT INTO crm_audit_log VALUES("3346","3","5","2019-02-09 19:59:14","Exit Invoice [Invoice No: 118625] updated by Imran  Khan on 09/02/2019 at 07:59 PM");
INSERT INTO crm_audit_log VALUES("3347","2","11","2019-02-09 22:10:02","Entry Invoice [Invoice No: 20266] updated by GAREEB GAREEB on 09/02/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("3348","2","11","2019-02-09 23:06:09","Entry Invoice [Invoice No: 20267] updated by GAREEB GAREEB on 09/02/2019 at 11:06 PM");
INSERT INTO crm_audit_log VALUES("3349","2","11","2019-02-09 23:14:48","Entry Invoice [Invoice No: 20268] updated by GAREEB GAREEB on 09/02/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("3350","2","11","2019-02-10 01:03:33","Entry Invoice [Invoice No: 20269] updated by GAREEB GAREEB on 10/02/2019 at 01:03 AM");
INSERT INTO crm_audit_log VALUES("3351","2","6","2019-02-10 08:25:18","Entry Invoice [Invoice No: 20267] updated by ASHRAF  M K on 10/02/2019 at 08:25 AM");
INSERT INTO crm_audit_log VALUES("3352","2","6","2019-02-10 08:29:22","Entry Invoice [Invoice No: 20264] updated by ASHRAF  M K on 10/02/2019 at 08:29 AM");
INSERT INTO crm_audit_log VALUES("3353","2","6","2019-02-10 08:30:47","Entry Invoice [Invoice No: 20264] updated by ASHRAF  M K on 10/02/2019 at 08:30 AM");
INSERT INTO crm_audit_log VALUES("3354","2","6","2019-02-10 08:31:26","Entry Invoice [Invoice No: 20264] updated by ASHRAF  M K on 10/02/2019 at 08:31 AM");
INSERT INTO crm_audit_log VALUES("3355","2","6","2019-02-10 09:18:33","Entry Invoice [Invoice No: 20264] updated by ASHRAF  M K on 10/02/2019 at 09:18 AM");
INSERT INTO crm_audit_log VALUES("3356","2","6","2019-02-10 09:19:08","Entry Invoice [Invoice No: 20262] updated by ASHRAF  M K on 10/02/2019 at 09:19 AM");
INSERT INTO crm_audit_log VALUES("3357","2","7","2019-02-10 09:26:52","Entry Invoice [Invoice No: 20270] updated by ALSED ABU SHAMA on 10/02/2019 at 09:26 AM");
INSERT INTO crm_audit_log VALUES("3358","2","6","2019-02-10 09:43:14","Entry Invoice [Invoice No: 20264] updated by ASHRAF  M K on 10/02/2019 at 09:43 AM");
INSERT INTO crm_audit_log VALUES("3359","2","6","2019-02-10 09:44:50","Entry Invoice [Invoice No: 20264] updated by ASHRAF  M K on 10/02/2019 at 09:44 AM");
INSERT INTO crm_audit_log VALUES("3360","2","6","2019-02-10 09:47:58","Entry Invoice [Invoice No: 20262] updated by ASHRAF  M K on 10/02/2019 at 09:47 AM");
INSERT INTO crm_audit_log VALUES("3361","3","4","2019-02-10 09:51:09","Exit Invoice [Invoice No: 118626] updated by Yasir  Rahman on 10/02/2019 at 09:51 AM");
INSERT INTO crm_audit_log VALUES("3362","3","4","2019-02-10 11:13:10","Exit Invoice [Invoice No: 118627] updated by Yasir  Rahman on 10/02/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("3363","2","7","2019-02-10 11:18:03","Entry Invoice [Invoice No: 20271] updated by ALSED ABU SHAMA on 10/02/2019 at 11:18 AM");
INSERT INTO crm_audit_log VALUES("3364","2","7","2019-02-10 11:18:56","Entry Invoice [Invoice No: 20272] updated by ALSED ABU SHAMA on 10/02/2019 at 11:18 AM");
INSERT INTO crm_audit_log VALUES("3365","3","4","2019-02-10 11:31:32","Exit Invoice [Invoice No: 118628] updated by Yasir  Rahman on 10/02/2019 at 11:31 AM");
INSERT INTO crm_audit_log VALUES("3366","2","7","2019-02-10 12:23:05","Entry Invoice [Invoice No: 20273] updated by ALSED ABU SHAMA on 10/02/2019 at 12:23 PM");
INSERT INTO crm_audit_log VALUES("3367","2","7","2019-02-10 12:25:13","Entry Invoice [Invoice No: 20274] updated by ALSED ABU SHAMA on 10/02/2019 at 12:25 PM");
INSERT INTO crm_audit_log VALUES("3368","3","4","2019-02-10 13:39:26","Exit Invoice [Invoice No: 118629] updated by Yasir  Rahman on 10/02/2019 at 01:39 PM");
INSERT INTO crm_audit_log VALUES("3369","2","7","2019-02-10 17:30:54","Entry Invoice [Invoice No: 20275] updated by ALSED ABU SHAMA on 10/02/2019 at 05:30 PM");
INSERT INTO crm_audit_log VALUES("3370","2","7","2019-02-10 17:40:14","Entry Invoice [Invoice No: 20276] updated by ALSED ABU SHAMA on 10/02/2019 at 05:40 PM");
INSERT INTO crm_audit_log VALUES("3371","2","7","2019-02-10 17:44:58","Entry Invoice [Invoice No: 20277] updated by ALSED ABU SHAMA on 10/02/2019 at 05:44 PM");
INSERT INTO crm_audit_log VALUES("3372","3","4","2019-02-10 18:22:00","Exit Invoice [Invoice No: 118630] updated by Yasir  Rahman on 10/02/2019 at 06:22 PM");
INSERT INTO crm_audit_log VALUES("3373","3","4","2019-02-10 18:49:50","Exit Invoice [Invoice No: 118631] updated by Yasir  Rahman on 10/02/2019 at 06:49 PM");
INSERT INTO crm_audit_log VALUES("3374","2","11","2019-02-10 21:07:45","Entry Invoice [Invoice No: 20278] updated by GAREEB GAREEB on 10/02/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("3375","2","11","2019-02-10 21:37:48","Entry Invoice [Invoice No: 20279] updated by GAREEB GAREEB on 10/02/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("3376","2","11","2019-02-10 21:40:57","Entry Invoice [Invoice No: 20280] updated by GAREEB GAREEB on 10/02/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("3377","3","5","2019-02-10 22:35:51","Exit Invoice [Invoice No: 118632] updated by Imran  Khan on 10/02/2019 at 10:35 PM");
INSERT INTO crm_audit_log VALUES("3378","2","11","2019-02-10 23:42:59","Entry Invoice [Invoice No: 20281] updated by GAREEB GAREEB on 10/02/2019 at 11:42 PM");
INSERT INTO crm_audit_log VALUES("3379","2","11","2019-02-10 23:45:24","Entry Invoice [Invoice No: 20282] updated by GAREEB GAREEB on 10/02/2019 at 11:45 PM");
INSERT INTO crm_audit_log VALUES("3380","3","5","2019-02-11 01:11:20","Exit Invoice [Invoice No: 118633] updated by Imran  Khan on 11/02/2019 at 01:11 AM");
INSERT INTO crm_audit_log VALUES("3381","3","5","2019-02-11 02:03:10","Exit Invoice [Invoice No: 118634] updated by Imran  Khan on 11/02/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("3382","3","5","2019-02-11 02:08:28","Exit Invoice [Invoice No: 118635] updated by Imran  Khan on 11/02/2019 at 02:08 AM");
INSERT INTO crm_audit_log VALUES("3383","3","5","2019-02-11 03:14:24","Exit Invoice [Invoice No: 118636] updated by Imran  Khan on 11/02/2019 at 03:14 AM");
INSERT INTO crm_audit_log VALUES("3384","3","4","2019-02-11 10:49:50","Exit Invoice [Invoice No: 118637] updated by Yasir  Rahman on 11/02/2019 at 10:49 AM");
INSERT INTO crm_audit_log VALUES("3385","2","7","2019-02-11 10:50:46","Entry Invoice [Invoice No: 20283] updated by ALSED ABU SHAMA on 11/02/2019 at 10:50 AM");
INSERT INTO crm_audit_log VALUES("3386","3","4","2019-02-11 11:39:00","Exit Invoice [Invoice No: 118638] updated by Yasir  Rahman on 11/02/2019 at 11:39 AM");
INSERT INTO crm_audit_log VALUES("3387","3","4","2019-02-11 13:03:57","Exit Invoice [Invoice No: 118639] updated by Yasir  Rahman on 11/02/2019 at 01:03 PM");
INSERT INTO crm_audit_log VALUES("3388","3","4","2019-02-11 13:54:02","Exit Invoice [Invoice No: 118640] updated by Yasir  Rahman on 11/02/2019 at 01:54 PM");
INSERT INTO crm_audit_log VALUES("3389","2","7","2019-02-11 14:37:05","Entry Invoice [Invoice No: 20284] updated by ALSED ABU SHAMA on 11/02/2019 at 02:37 PM");
INSERT INTO crm_audit_log VALUES("3390","3","4","2019-02-11 17:01:25","Exit Invoice [Invoice No: 118641] updated by Yasir  Rahman on 11/02/2019 at 05:01 PM");
INSERT INTO crm_audit_log VALUES("3391","3","4","2019-02-11 17:02:44","Exit Invoice [Invoice No: 118642] updated by Yasir  Rahman on 11/02/2019 at 05:02 PM");
INSERT INTO crm_audit_log VALUES("3392","3","4","2019-02-11 17:51:28","Exit Invoice [Invoice No: 118643] updated by Yasir  Rahman on 11/02/2019 at 05:51 PM");
INSERT INTO crm_audit_log VALUES("3393","2","11","2019-02-11 20:58:55","Entry Invoice [Invoice No: 20285] updated by GAREEB GAREEB on 11/02/2019 at 08:58 PM");
INSERT INTO crm_audit_log VALUES("3394","3","5","2019-02-11 23:00:37","Exit Invoice [Invoice No: 118644] updated by Imran  Khan on 11/02/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("3395","2","11","2019-02-11 23:04:02","Entry Invoice [Invoice No: 20286] updated by GAREEB GAREEB on 11/02/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("3396","2","11","2019-02-11 23:07:30","Entry Invoice [Invoice No: 20287] updated by GAREEB GAREEB on 11/02/2019 at 11:07 PM");
INSERT INTO crm_audit_log VALUES("3397","3","5","2019-02-11 23:56:26","Exit Invoice [Invoice No: 118645] updated by Imran  Khan on 11/02/2019 at 11:56 PM");
INSERT INTO crm_audit_log VALUES("3398","2","11","2019-02-12 00:05:02","Entry Invoice [Invoice No: 20288] updated by GAREEB GAREEB on 12/02/2019 at 12:05 AM");
INSERT INTO crm_audit_log VALUES("3399","2","11","2019-02-12 00:07:13","Entry Invoice [Invoice No: 20289] updated by GAREEB GAREEB on 12/02/2019 at 12:07 AM");
INSERT INTO crm_audit_log VALUES("3400","3","5","2019-02-12 01:02:32","Exit Invoice [Invoice No: 118646] updated by Imran  Khan on 12/02/2019 at 01:02 AM");
INSERT INTO crm_audit_log VALUES("3401","3","5","2019-02-12 01:09:00","Exit Invoice [Invoice No: 118647] updated by Imran  Khan on 12/02/2019 at 01:09 AM");
INSERT INTO crm_audit_log VALUES("3402","2","11","2019-02-12 01:24:39","Entry Invoice [Invoice No: 20290] updated by GAREEB GAREEB on 12/02/2019 at 01:24 AM");
INSERT INTO crm_audit_log VALUES("3403","2","11","2019-02-12 01:25:46","Entry Invoice [Invoice No: 20291] updated by GAREEB GAREEB on 12/02/2019 at 01:25 AM");
INSERT INTO crm_audit_log VALUES("3404","3","5","2019-02-12 02:12:33","Exit Invoice [Invoice No: 118648] updated by Imran  Khan on 12/02/2019 at 02:12 AM");
INSERT INTO crm_audit_log VALUES("3405","3","5","2019-02-12 02:13:08","Exit Invoice [Invoice No: 118649] updated by Imran  Khan on 12/02/2019 at 02:13 AM");
INSERT INTO crm_audit_log VALUES("3406","3","5","2019-02-12 02:13:48","Exit Invoice [Invoice No: 118650] updated by Imran  Khan on 12/02/2019 at 02:13 AM");
INSERT INTO crm_audit_log VALUES("3407","3","5","2019-02-12 03:12:59","Exit Invoice [Invoice No: 118651] updated by Imran  Khan on 12/02/2019 at 03:12 AM");
INSERT INTO crm_audit_log VALUES("3408","3","5","2019-02-12 05:48:45","Exit Invoice [Invoice No: 118652] updated by Imran  Khan on 12/02/2019 at 05:48 AM");
INSERT INTO crm_audit_log VALUES("3409","3","5","2019-02-12 07:34:45","Exit Invoice [Invoice No: 118653] updated by Imran  Khan on 12/02/2019 at 07:34 AM");
INSERT INTO crm_audit_log VALUES("3410","1","6","2019-02-12 08:31:04","Customer [Customer No: 420] updated by ASHRAF  M K on 12/02/2019 at 08:31 AM");
INSERT INTO crm_audit_log VALUES("3411","2","6","2019-02-12 08:37:02","Entry Invoice [Invoice No: 20285] updated by ASHRAF  M K on 12/02/2019 at 08:37 AM");
INSERT INTO crm_audit_log VALUES("3412","2","6","2019-02-12 08:38:20","Entry Invoice [Invoice No: 20285] updated by ASHRAF  M K on 12/02/2019 at 08:38 AM");
INSERT INTO crm_audit_log VALUES("3413","3","4","2019-02-12 11:03:21","Exit Invoice [Invoice No: 118654] updated by Yasir  Rahman on 12/02/2019 at 11:03 AM");
INSERT INTO crm_audit_log VALUES("3414","3","4","2019-02-12 11:04:15","Exit Invoice [Invoice No: 118655] updated by Yasir  Rahman on 12/02/2019 at 11:04 AM");
INSERT INTO crm_audit_log VALUES("3415","3","4","2019-02-12 11:07:15","Exit Invoice [Invoice No: 118656] updated by Yasir  Rahman on 12/02/2019 at 11:07 AM");
INSERT INTO crm_audit_log VALUES("3416","3","4","2019-02-12 11:09:43","Exit Invoice [Invoice No: 118657] updated by Yasir  Rahman on 12/02/2019 at 11:09 AM");
INSERT INTO crm_audit_log VALUES("3417","3","4","2019-02-12 11:11:42","Exit Invoice [Invoice No: 118658] updated by Yasir  Rahman on 12/02/2019 at 11:11 AM");
INSERT INTO crm_audit_log VALUES("3418","2","7","2019-02-12 12:09:29","Entry Invoice [Invoice No: 20292] updated by ALSED ABU SHAMA on 12/02/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("3419","2","15","2019-02-12 12:24:15","Entry Invoice [Invoice No: 20293] updated by Abdul Rasheed on 12/02/2019 at 12:24 PM");
INSERT INTO crm_audit_log VALUES("3420","2","15","2019-02-12 12:27:01","Entry Invoice [Invoice No: 20294] updated by Abdul Rasheed on 12/02/2019 at 12:27 PM");
INSERT INTO crm_audit_log VALUES("3421","2","15","2019-02-12 12:29:15","Entry Invoice [Invoice No: 20295] updated by Abdul Rasheed on 12/02/2019 at 12:29 PM");
INSERT INTO crm_audit_log VALUES("3422","2","15","2019-02-12 12:31:26","Entry Invoice [Invoice No: 20296] updated by Abdul Rasheed on 12/02/2019 at 12:31 PM");
INSERT INTO crm_audit_log VALUES("3423","2","7","2019-02-12 12:49:20","Entry Invoice [Invoice No: 20297] updated by ALSED ABU SHAMA on 12/02/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("3424","3","4","2019-02-12 12:49:45","Exit Invoice [Invoice No: 118659] updated by Yasir  Rahman on 12/02/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("3425","3","4","2019-02-12 12:54:11","Exit Invoice [Invoice No: 118660] updated by Yasir  Rahman on 12/02/2019 at 12:54 PM");
INSERT INTO crm_audit_log VALUES("3426","3","4","2019-02-12 15:27:16","Exit Invoice [Invoice No: 118661] updated by Yasir  Rahman on 12/02/2019 at 03:27 PM");
INSERT INTO crm_audit_log VALUES("3427","2","7","2019-02-12 17:06:00","Entry Invoice [Invoice No: 20298] updated by ALSED ABU SHAMA on 12/02/2019 at 05:06 PM");
INSERT INTO crm_audit_log VALUES("3428","2","7","2019-02-12 17:06:52","Entry Invoice [Invoice No: 20299] updated by ALSED ABU SHAMA on 12/02/2019 at 05:06 PM");
INSERT INTO crm_audit_log VALUES("3429","2","7","2019-02-12 17:07:28","Entry Invoice [Invoice No: 20300] updated by ALSED ABU SHAMA on 12/02/2019 at 05:07 PM");
INSERT INTO crm_audit_log VALUES("3430","2","7","2019-02-12 17:08:20","Entry Invoice [Invoice No: 20301] updated by ALSED ABU SHAMA on 12/02/2019 at 05:08 PM");
INSERT INTO crm_audit_log VALUES("3431","2","7","2019-02-12 17:09:03","Entry Invoice [Invoice No: 20302] updated by ALSED ABU SHAMA on 12/02/2019 at 05:09 PM");
INSERT INTO crm_audit_log VALUES("3432","3","4","2019-02-12 17:33:48","Exit Invoice [Invoice No: 118662] updated by Yasir  Rahman on 12/02/2019 at 05:33 PM");
INSERT INTO crm_audit_log VALUES("3433","2","7","2019-02-12 18:25:28","Entry Invoice [Invoice No: 20303] updated by ALSED ABU SHAMA on 12/02/2019 at 06:25 PM");
INSERT INTO crm_audit_log VALUES("3434","2","7","2019-02-12 18:26:24","Entry Invoice [Invoice No: 20304] updated by ALSED ABU SHAMA on 12/02/2019 at 06:26 PM");
INSERT INTO crm_audit_log VALUES("3435","3","4","2019-02-12 19:26:10","Exit Invoice [Invoice No: 118663] updated by Yasir  Rahman on 12/02/2019 at 07:26 PM");
INSERT INTO crm_audit_log VALUES("3436","2","7","2019-02-12 19:35:53","Entry Invoice [Invoice No: 20305] updated by ALSED ABU SHAMA on 12/02/2019 at 07:35 PM");
INSERT INTO crm_audit_log VALUES("3437","2","7","2019-02-12 19:38:31","Entry Invoice [Invoice No: 20306] updated by ALSED ABU SHAMA on 12/02/2019 at 07:38 PM");
INSERT INTO crm_audit_log VALUES("3438","3","4","2019-02-12 21:14:42","Exit Invoice [Invoice No: 118664] updated by Yasir  Rahman on 12/02/2019 at 09:14 PM");
INSERT INTO crm_audit_log VALUES("3439","3","5","2019-02-12 23:57:01","Exit Invoice [Invoice No: 118665] updated by Imran  Khan on 12/02/2019 at 11:57 PM");
INSERT INTO crm_audit_log VALUES("3440","3","5","2019-02-12 23:58:03","Exit Invoice [Invoice No: 118666] updated by Imran  Khan on 12/02/2019 at 11:58 PM");
INSERT INTO crm_audit_log VALUES("3441","3","5","2019-02-12 23:58:48","Exit Invoice [Invoice No: 118667] updated by Imran  Khan on 12/02/2019 at 11:58 PM");
INSERT INTO crm_audit_log VALUES("3442","2","11","2019-02-13 00:23:10","Entry Invoice [Invoice No: 20307] updated by GAREEB GAREEB on 13/02/2019 at 12:23 AM");
INSERT INTO crm_audit_log VALUES("3443","2","11","2019-02-13 00:25:02","Entry Invoice [Invoice No: 20308] updated by GAREEB GAREEB on 13/02/2019 at 12:25 AM");
INSERT INTO crm_audit_log VALUES("3444","3","5","2019-02-13 01:17:46","Exit Invoice [Invoice No: 118668] updated by Imran  Khan on 13/02/2019 at 01:17 AM");
INSERT INTO crm_audit_log VALUES("3445","2","11","2019-02-13 02:06:38","Entry Invoice [Invoice No: 20309] updated by GAREEB GAREEB on 13/02/2019 at 02:06 AM");
INSERT INTO crm_audit_log VALUES("3446","2","11","2019-02-13 02:07:47","Entry Invoice [Invoice No: 20310] updated by GAREEB GAREEB on 13/02/2019 at 02:07 AM");
INSERT INTO crm_audit_log VALUES("3447","2","11","2019-02-13 02:24:34","Entry Invoice [Invoice No: 20311] updated by GAREEB GAREEB on 13/02/2019 at 02:24 AM");
INSERT INTO crm_audit_log VALUES("3448","3","5","2019-02-13 03:55:10","Exit Invoice [Invoice No: 118669] updated by Imran  Khan on 13/02/2019 at 03:55 AM");
INSERT INTO crm_audit_log VALUES("3449","3","5","2019-02-13 04:39:04","Exit Invoice [Invoice No: 118670] updated by Imran  Khan on 13/02/2019 at 04:39 AM");
INSERT INTO crm_audit_log VALUES("3450","3","5","2019-02-13 04:40:10","Exit Invoice [Invoice No: 118671] updated by Imran  Khan on 13/02/2019 at 04:40 AM");
INSERT INTO crm_audit_log VALUES("3451","3","4","2019-02-13 09:11:41","Exit Invoice [Invoice No: 118672] updated by Yasir  Rahman on 13/02/2019 at 09:11 AM");
INSERT INTO crm_audit_log VALUES("3452","3","4","2019-02-13 09:12:55","Exit Invoice [Invoice No: 118673] updated by Yasir  Rahman on 13/02/2019 at 09:12 AM");
INSERT INTO crm_audit_log VALUES("3453","2","7","2019-02-13 09:27:23","Entry Invoice [Invoice No: 20312] updated by ALSED ABU SHAMA on 13/02/2019 at 09:27 AM");
INSERT INTO crm_audit_log VALUES("3454","2","7","2019-02-13 11:21:36","Entry Invoice [Invoice No: 20313] updated by ALSED ABU SHAMA on 13/02/2019 at 11:21 AM");
INSERT INTO crm_audit_log VALUES("3455","3","4","2019-02-13 11:26:09","Exit Invoice [Invoice No: 118674] updated by Yasir  Rahman on 13/02/2019 at 11:26 AM");
INSERT INTO crm_audit_log VALUES("3456","3","4","2019-02-13 11:27:24","Exit Invoice [Invoice No: 118675] updated by Yasir  Rahman on 13/02/2019 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("3457","3","4","2019-02-13 12:38:58","Exit Invoice [Invoice No: 118676] updated by Yasir  Rahman on 13/02/2019 at 12:38 PM");
INSERT INTO crm_audit_log VALUES("3458","3","4","2019-02-13 12:40:25","Exit Invoice [Invoice No: 118677] updated by Yasir  Rahman on 13/02/2019 at 12:40 PM");
INSERT INTO crm_audit_log VALUES("3459","3","4","2019-02-13 12:41:29","Exit Invoice [Invoice No: 118678] updated by Yasir  Rahman on 13/02/2019 at 12:41 PM");
INSERT INTO crm_audit_log VALUES("3460","3","4","2019-02-13 12:54:28","Exit Invoice [Invoice No: 118679] updated by Yasir  Rahman on 13/02/2019 at 12:54 PM");
INSERT INTO crm_audit_log VALUES("3461","2","7","2019-02-13 14:10:55","Entry Invoice [Invoice No: 20314] updated by ALSED ABU SHAMA on 13/02/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("3462","2","7","2019-02-13 15:19:53","Entry Invoice [Invoice No: 20315] updated by ALSED ABU SHAMA on 13/02/2019 at 03:19 PM");
INSERT INTO crm_audit_log VALUES("3463","3","4","2019-02-13 16:57:09","Exit Invoice [Invoice No: 118680] updated by Yasir  Rahman on 13/02/2019 at 04:57 PM");
INSERT INTO crm_audit_log VALUES("3464","2","11","2019-02-13 23:00:31","Entry Invoice [Invoice No: 20316] updated by GAREEB GAREEB on 13/02/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("3465","3","11","2019-02-13 23:32:57","Exit Invoice [Invoice No: 118681] updated by GAREEB GAREEB on 13/02/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("3466","3","5","2019-02-14 01:43:35","Exit Invoice [Invoice No: 118682] updated by Imran  Khan on 14/02/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("3467","2","11","2019-02-14 03:07:10","Entry Invoice [Invoice No: 20317] updated by GAREEB GAREEB on 14/02/2019 at 03:07 AM");
INSERT INTO crm_audit_log VALUES("3468","2","11","2019-02-14 03:08:57","Entry Invoice [Invoice No: 20318] updated by GAREEB GAREEB on 14/02/2019 at 03:08 AM");
INSERT INTO crm_audit_log VALUES("3469","2","11","2019-02-14 03:11:15","Entry Invoice [Invoice No: 20319] updated by GAREEB GAREEB on 14/02/2019 at 03:11 AM");
INSERT INTO crm_audit_log VALUES("3470","2","11","2019-02-14 03:13:01","Entry Invoice [Invoice No: 20320] updated by GAREEB GAREEB on 14/02/2019 at 03:13 AM");
INSERT INTO crm_audit_log VALUES("3471","3","5","2019-02-14 04:37:01","Exit Invoice [Invoice No: 118683] updated by Imran  Khan on 14/02/2019 at 04:37 AM");
INSERT INTO crm_audit_log VALUES("3472","3","5","2019-02-14 06:50:13","Exit Invoice [Invoice No: 118684] updated by Imran  Khan on 14/02/2019 at 06:50 AM");
INSERT INTO crm_audit_log VALUES("3473","2","6","2019-02-14 08:44:17","Entry Invoice [Invoice No: 20311] updated by ASHRAF  M K on 14/02/2019 at 08:44 AM");
INSERT INTO crm_audit_log VALUES("3474","2","6","2019-02-14 08:46:25","Entry Invoice [Invoice No: 20311] updated by ASHRAF  M K on 14/02/2019 at 08:46 AM");
INSERT INTO crm_audit_log VALUES("3475","2","7","2019-02-14 10:24:06","Entry Invoice [Invoice No: 20321] updated by ALSED ABU SHAMA on 14/02/2019 at 10:24 AM");
INSERT INTO crm_audit_log VALUES("3476","2","7","2019-02-14 10:58:28","Entry Invoice [Invoice No: 20322] updated by ALSED ABU SHAMA on 14/02/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("3477","3","4","2019-02-14 11:48:15","Exit Invoice [Invoice No: 118685] updated by Yasir  Rahman on 14/02/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("3478","3","4","2019-02-14 11:49:31","Exit Invoice [Invoice No: 118686] updated by Yasir  Rahman on 14/02/2019 at 11:49 AM");
INSERT INTO crm_audit_log VALUES("3479","3","4","2019-02-14 12:30:33","Exit Invoice [Invoice No: 118687] updated by Yasir  Rahman on 14/02/2019 at 12:30 PM");
INSERT INTO crm_audit_log VALUES("3480","3","4","2019-02-14 15:42:57","Exit Invoice [Invoice No: 118688] updated by Yasir  Rahman on 14/02/2019 at 03:42 PM");
INSERT INTO crm_audit_log VALUES("3481","3","4","2019-02-14 15:44:30","Exit Invoice [Invoice No: 118689] updated by Yasir  Rahman on 14/02/2019 at 03:44 PM");
INSERT INTO crm_audit_log VALUES("3482","2","7","2019-02-14 17:45:20","Entry Invoice [Invoice No: 20323] updated by ALSED ABU SHAMA on 14/02/2019 at 05:45 PM");
INSERT INTO crm_audit_log VALUES("3483","2","7","2019-02-14 18:52:31","Entry Invoice [Invoice No: 20324] updated by ALSED ABU SHAMA on 14/02/2019 at 06:52 PM");
INSERT INTO crm_audit_log VALUES("3484","2","7","2019-02-14 18:54:16","Entry Invoice [Invoice No: 20325] updated by ALSED ABU SHAMA on 14/02/2019 at 06:54 PM");
INSERT INTO crm_audit_log VALUES("3485","3","4","2019-02-14 21:38:20","Exit Invoice [Invoice No: 118690] updated by Yasir  Rahman on 14/02/2019 at 09:38 PM");
INSERT INTO crm_audit_log VALUES("3486","3","4","2019-02-14 21:39:32","Exit Invoice [Invoice No: 118691] updated by Yasir  Rahman on 14/02/2019 at 09:39 PM");
INSERT INTO crm_audit_log VALUES("3487","3","4","2019-02-14 21:40:46","Exit Invoice [Invoice No: 118692] updated by Yasir  Rahman on 14/02/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("3488","3","4","2019-02-14 23:23:59","Exit Invoice [Invoice No: 118693] updated by Yasir  Rahman on 14/02/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("3489","3","5","2019-02-15 01:47:36","Exit Invoice [Invoice No: 118694] updated by Imran  Khan on 15/02/2019 at 01:47 AM");
INSERT INTO crm_audit_log VALUES("3490","2","11","2019-02-15 02:44:12","Entry Invoice [Invoice No: 20326] updated by GAREEB GAREEB on 15/02/2019 at 02:44 AM");
INSERT INTO crm_audit_log VALUES("3491","2","11","2019-02-15 02:45:32","Entry Invoice [Invoice No: 20327] updated by GAREEB GAREEB on 15/02/2019 at 02:45 AM");
INSERT INTO crm_audit_log VALUES("3492","3","5","2019-02-15 03:00:39","Exit Invoice [Invoice No: 118695] updated by Imran  Khan on 15/02/2019 at 03:00 AM");
INSERT INTO crm_audit_log VALUES("3493","3","5","2019-02-15 03:06:01","Exit Invoice [Invoice No: 118696] updated by Imran  Khan on 15/02/2019 at 03:06 AM");
INSERT INTO crm_audit_log VALUES("3494","3","5","2019-02-15 04:36:51","Exit Invoice [Invoice No: 118697] updated by Imran  Khan on 15/02/2019 at 04:36 AM");
INSERT INTO crm_audit_log VALUES("3495","3","5","2019-02-15 07:12:45","Exit Invoice [Invoice No: 118698] updated by Imran  Khan on 15/02/2019 at 07:12 AM");
INSERT INTO crm_audit_log VALUES("3496","2","15","2019-02-15 09:57:56","Entry Invoice [Invoice No: 20328] updated by Abdul Rasheed on 15/02/2019 at 09:57 AM");
INSERT INTO crm_audit_log VALUES("3497","2","15","2019-02-15 09:59:41","Entry Invoice [Invoice No: 20329] updated by Abdul Rasheed on 15/02/2019 at 09:59 AM");
INSERT INTO crm_audit_log VALUES("3498","3","4","2019-02-15 10:08:05","Exit Invoice [Invoice No: 118699] updated by Yasir  Rahman on 15/02/2019 at 10:08 AM");
INSERT INTO crm_audit_log VALUES("3499","3","4","2019-02-15 10:12:14","Exit Invoice [Invoice No: 118700] updated by Yasir  Rahman on 15/02/2019 at 10:12 AM");
INSERT INTO crm_audit_log VALUES("3500","2","7","2019-02-15 10:36:24","Entry Invoice [Invoice No: 20330] updated by ALSED ABU SHAMA on 15/02/2019 at 10:36 AM");
INSERT INTO crm_audit_log VALUES("3501","3","4","2019-02-15 11:14:00","Exit Invoice [Invoice No: 118701] updated by Yasir  Rahman on 15/02/2019 at 11:14 AM");
INSERT INTO crm_audit_log VALUES("3502","3","4","2019-02-15 14:08:40","Exit Invoice [Invoice No: 118702] updated by Yasir  Rahman on 15/02/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("3503","3","4","2019-02-15 14:52:41","Exit Invoice [Invoice No: 118703] updated by Yasir  Rahman on 15/02/2019 at 02:52 PM");
INSERT INTO crm_audit_log VALUES("3504","3","4","2019-02-15 14:53:49","Exit Invoice [Invoice No: 118704] updated by Yasir  Rahman on 15/02/2019 at 02:53 PM");
INSERT INTO crm_audit_log VALUES("3505","3","4","2019-02-15 15:22:46","Exit Invoice [Invoice No: 118705] updated by Yasir  Rahman on 15/02/2019 at 03:22 PM");
INSERT INTO crm_audit_log VALUES("3506","3","4","2019-02-15 16:04:55","Exit Invoice [Invoice No: 118706] updated by Yasir  Rahman on 15/02/2019 at 04:04 PM");
INSERT INTO crm_audit_log VALUES("3507","3","4","2019-02-15 17:37:08","Exit Invoice [Invoice No: 118707] updated by Yasir  Rahman on 15/02/2019 at 05:37 PM");
INSERT INTO crm_audit_log VALUES("3508","3","4","2019-02-15 17:37:43","Exit Invoice [Invoice No: 118708] updated by Yasir  Rahman on 15/02/2019 at 05:37 PM");
INSERT INTO crm_audit_log VALUES("3509","3","4","2019-02-15 17:38:16","Exit Invoice [Invoice No: 118709] updated by Yasir  Rahman on 15/02/2019 at 05:38 PM");
INSERT INTO crm_audit_log VALUES("3510","3","4","2019-02-15 17:39:04","Exit Invoice [Invoice No: 118710] updated by Yasir  Rahman on 15/02/2019 at 05:39 PM");
INSERT INTO crm_audit_log VALUES("3511","2","11","2019-02-15 21:19:20","Entry Invoice [Invoice No: 20331] updated by GAREEB GAREEB on 15/02/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("3512","2","11","2019-02-15 23:43:52","Entry Invoice [Invoice No: 20332] updated by GAREEB GAREEB on 15/02/2019 at 11:43 PM");
INSERT INTO crm_audit_log VALUES("3513","2","11","2019-02-15 23:46:21","Entry Invoice [Invoice No: 20333] updated by GAREEB GAREEB on 15/02/2019 at 11:46 PM");
INSERT INTO crm_audit_log VALUES("3514","2","11","2019-02-15 23:53:10","Entry Invoice [Invoice No: 20334] updated by GAREEB GAREEB on 15/02/2019 at 11:53 PM");
INSERT INTO crm_audit_log VALUES("3515","2","11","2019-02-15 23:54:38","Entry Invoice [Invoice No: 20335] updated by GAREEB GAREEB on 15/02/2019 at 11:54 PM");
INSERT INTO crm_audit_log VALUES("3516","3","5","2019-02-16 00:01:52","Exit Invoice [Invoice No: 118711] updated by Imran  Khan on 16/02/2019 at 12:01 AM");
INSERT INTO crm_audit_log VALUES("3517","2","11","2019-02-16 03:00:52","Entry Invoice [Invoice No: 20336] updated by GAREEB GAREEB on 16/02/2019 at 03:00 AM");
INSERT INTO crm_audit_log VALUES("3518","2","11","2019-02-16 03:02:39","Entry Invoice [Invoice No: 20337] updated by GAREEB GAREEB on 16/02/2019 at 03:02 AM");
INSERT INTO crm_audit_log VALUES("3519","3","5","2019-02-16 06:05:19","Exit Invoice [Invoice No: 118712] updated by Imran  Khan on 16/02/2019 at 06:05 AM");
INSERT INTO crm_audit_log VALUES("3520","3","5","2019-02-16 07:00:58","Exit Invoice [Invoice No: 118713] updated by Imran  Khan on 16/02/2019 at 07:00 AM");
INSERT INTO crm_audit_log VALUES("3521","1","4","2019-02-16 11:58:24","Customer [Customer No: 421] updated by Yasir  Rahman on 16/02/2019 at 11:58 AM");
INSERT INTO crm_audit_log VALUES("3522","2","15","2019-02-16 12:07:16","Entry Invoice [Invoice No: 20338] updated by Abdul Rasheed on 16/02/2019 at 12:07 PM");
INSERT INTO crm_audit_log VALUES("3523","2","6","2019-02-16 12:14:14","Entry Invoice [Invoice No: 20338] updated by ASHRAF  M K on 16/02/2019 at 12:14 PM");
INSERT INTO crm_audit_log VALUES("3524","2","7","2019-02-16 12:27:39","Entry Invoice [Invoice No: 20339] updated by ALSED ABU SHAMA on 16/02/2019 at 12:27 PM");
INSERT INTO crm_audit_log VALUES("3525","2","7","2019-02-16 12:29:34","Entry Invoice [Invoice No: 20340] updated by ALSED ABU SHAMA on 16/02/2019 at 12:29 PM");
INSERT INTO crm_audit_log VALUES("3526","3","4","2019-02-16 12:51:25","Exit Invoice [Invoice No: 118714] updated by Yasir  Rahman on 16/02/2019 at 12:51 PM");
INSERT INTO crm_audit_log VALUES("3527","2","15","2019-02-16 13:19:44","Entry Invoice [Invoice No: 20341] updated by Abdul Rasheed on 16/02/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("3528","2","15","2019-02-16 13:22:38","Entry Invoice [Invoice No: 20342] updated by Abdul Rasheed on 16/02/2019 at 01:22 PM");
INSERT INTO crm_audit_log VALUES("3529","3","4","2019-02-16 14:40:12","Exit Invoice [Invoice No: 118715] updated by Yasir  Rahman on 16/02/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("3530","2","7","2019-02-16 16:14:59","Entry Invoice [Invoice No: 20343] updated by ALSED ABU SHAMA on 16/02/2019 at 04:14 PM");
INSERT INTO crm_audit_log VALUES("3531","2","7","2019-02-16 16:50:12","Entry Invoice [Invoice No: 20344] updated by ALSED ABU SHAMA on 16/02/2019 at 04:50 PM");
INSERT INTO crm_audit_log VALUES("3532","2","6","2019-02-16 17:08:38","Entry Invoice [Invoice No: 20344] updated by ASHRAF  M K on 16/02/2019 at 05:08 PM");
INSERT INTO crm_audit_log VALUES("3533","3","4","2019-02-16 18:39:50","Exit Invoice [Invoice No: 118716] updated by Yasir  Rahman on 16/02/2019 at 06:39 PM");
INSERT INTO crm_audit_log VALUES("3534","3","4","2019-02-16 18:42:51","Exit Invoice [Invoice No: 118717] updated by Yasir  Rahman on 16/02/2019 at 06:42 PM");
INSERT INTO crm_audit_log VALUES("3535","3","4","2019-02-16 18:43:33","Exit Invoice [Invoice No: 118718] updated by Yasir  Rahman on 16/02/2019 at 06:43 PM");
INSERT INTO crm_audit_log VALUES("3536","3","4","2019-02-16 18:44:00","Exit Invoice [Invoice No: 118719] updated by Yasir  Rahman on 16/02/2019 at 06:44 PM");
INSERT INTO crm_audit_log VALUES("3537","2","7","2019-02-16 19:08:58","Entry Invoice [Invoice No: 20345] updated by ALSED ABU SHAMA on 16/02/2019 at 07:08 PM");
INSERT INTO crm_audit_log VALUES("3538","2","7","2019-02-16 19:14:48","Entry Invoice [Invoice No: 20346] updated by ALSED ABU SHAMA on 16/02/2019 at 07:14 PM");
INSERT INTO crm_audit_log VALUES("3539","3","4","2019-02-16 21:44:18","Exit Invoice [Invoice No: 118720] updated by Yasir  Rahman on 16/02/2019 at 09:44 PM");
INSERT INTO crm_audit_log VALUES("3540","2","11","2019-02-16 22:06:54","Entry Invoice [Invoice No: 20347] updated by GAREEB GAREEB on 16/02/2019 at 10:06 PM");
INSERT INTO crm_audit_log VALUES("3541","2","11","2019-02-17 01:53:20","Entry Invoice [Invoice No: 20348] updated by GAREEB GAREEB on 17/02/2019 at 01:53 AM");
INSERT INTO crm_audit_log VALUES("3542","3","5","2019-02-17 02:28:59","Exit Invoice [Invoice No: 118721] updated by Imran  Khan on 17/02/2019 at 02:28 AM");
INSERT INTO crm_audit_log VALUES("3543","2","11","2019-02-17 03:06:54","Entry Invoice [Invoice No: 20349] updated by GAREEB GAREEB on 17/02/2019 at 03:06 AM");
INSERT INTO crm_audit_log VALUES("3544","3","5","2019-02-17 06:28:27","Exit Invoice [Invoice No: 118722] updated by Imran  Khan on 17/02/2019 at 06:28 AM");
INSERT INTO crm_audit_log VALUES("3545","3","4","2019-02-17 11:24:09","Exit Invoice [Invoice No: 118723] updated by Yasir  Rahman on 17/02/2019 at 11:24 AM");
INSERT INTO crm_audit_log VALUES("3546","3","4","2019-02-17 12:28:21","Exit Invoice [Invoice No: 118724] updated by Yasir  Rahman on 17/02/2019 at 12:28 PM");
INSERT INTO crm_audit_log VALUES("3547","3","4","2019-02-17 12:29:05","Exit Invoice [Invoice No: 118725] updated by Yasir  Rahman on 17/02/2019 at 12:29 PM");
INSERT INTO crm_audit_log VALUES("3548","3","4","2019-02-17 12:29:54","Exit Invoice [Invoice No: 118726] updated by Yasir  Rahman on 17/02/2019 at 12:29 PM");
INSERT INTO crm_audit_log VALUES("3549","3","4","2019-02-17 13:50:25","Exit Invoice [Invoice No: 118727] updated by Yasir  Rahman on 17/02/2019 at 01:50 PM");
INSERT INTO crm_audit_log VALUES("3550","3","4","2019-02-17 14:33:28","Exit Invoice [Invoice No: 118728] updated by Yasir  Rahman on 17/02/2019 at 02:33 PM");
INSERT INTO crm_audit_log VALUES("3551","3","4","2019-02-17 15:16:00","Exit Invoice [Invoice No: 118729] updated by Yasir  Rahman on 17/02/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("3552","3","4","2019-02-17 17:23:13","Exit Invoice [Invoice No: 118730] updated by Yasir  Rahman on 17/02/2019 at 05:23 PM");
INSERT INTO crm_audit_log VALUES("3553","2","7","2019-02-17 17:52:16","Entry Invoice [Invoice No: 20350] updated by ALSED ABU SHAMA on 17/02/2019 at 05:52 PM");
INSERT INTO crm_audit_log VALUES("3554","3","4","2019-02-17 18:41:21","Exit Invoice [Invoice No: 118731] updated by Yasir  Rahman on 17/02/2019 at 06:41 PM");
INSERT INTO crm_audit_log VALUES("3555","3","4","2019-02-17 18:42:15","Exit Invoice [Invoice No: 118732] updated by Yasir  Rahman on 17/02/2019 at 06:42 PM");
INSERT INTO crm_audit_log VALUES("3556","2","11","2019-02-17 20:30:03","Entry Invoice [Invoice No: 20351] updated by GAREEB GAREEB on 17/02/2019 at 08:30 PM");
INSERT INTO crm_audit_log VALUES("3557","2","11","2019-02-17 20:55:09","Entry Invoice [Invoice No: 20352] updated by GAREEB GAREEB on 17/02/2019 at 08:55 PM");
INSERT INTO crm_audit_log VALUES("3558","2","11","2019-02-17 21:26:18","Entry Invoice [Invoice No: 20353] updated by GAREEB GAREEB on 17/02/2019 at 09:26 PM");
INSERT INTO crm_audit_log VALUES("3559","3","5","2019-02-18 00:48:36","Exit Invoice [Invoice No: 118733] updated by Imran  Khan on 18/02/2019 at 12:48 AM");
INSERT INTO crm_audit_log VALUES("3560","2","11","2019-02-18 01:07:07","Entry Invoice [Invoice No: 20354] updated by GAREEB GAREEB on 18/02/2019 at 01:07 AM");
INSERT INTO crm_audit_log VALUES("3561","2","11","2019-02-18 01:08:25","Entry Invoice [Invoice No: 20355] updated by GAREEB GAREEB on 18/02/2019 at 01:08 AM");
INSERT INTO crm_audit_log VALUES("3562","3","5","2019-02-18 01:51:19","Exit Invoice [Invoice No: 118734] updated by Imran  Khan on 18/02/2019 at 01:51 AM");
INSERT INTO crm_audit_log VALUES("3563","3","5","2019-02-18 01:52:22","Exit Invoice [Invoice No: 118735] updated by Imran  Khan on 18/02/2019 at 01:52 AM");
INSERT INTO crm_audit_log VALUES("3564","2","11","2019-02-18 02:51:44","Entry Invoice [Invoice No: 20356] updated by GAREEB GAREEB on 18/02/2019 at 02:51 AM");
INSERT INTO crm_audit_log VALUES("3565","3","5","2019-02-18 03:15:52","Exit Invoice [Invoice No: 118736] updated by Imran  Khan on 18/02/2019 at 03:15 AM");
INSERT INTO crm_audit_log VALUES("3566","3","5","2019-02-18 03:16:30","Exit Invoice [Invoice No: 118737] updated by Imran  Khan on 18/02/2019 at 03:16 AM");
INSERT INTO crm_audit_log VALUES("3567","3","5","2019-02-18 07:15:22","Exit Invoice [Invoice No: 118738] updated by Imran  Khan on 18/02/2019 at 07:15 AM");
INSERT INTO crm_audit_log VALUES("3568","3","4","2019-02-18 11:05:21","Exit Invoice [Invoice No: 118739] updated by Yasir  Rahman on 18/02/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("3569","3","4","2019-02-18 11:10:22","Exit Invoice [Invoice No: 118740] updated by Yasir  Rahman on 18/02/2019 at 11:10 AM");
INSERT INTO crm_audit_log VALUES("3570","3","4","2019-02-18 11:13:20","Exit Invoice [Invoice No: 118741] updated by Yasir  Rahman on 18/02/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("3571","3","4","2019-02-18 12:01:13","Exit Invoice [Invoice No: 118742] updated by Yasir  Rahman on 18/02/2019 at 12:01 PM");
INSERT INTO crm_audit_log VALUES("3572","3","4","2019-02-18 12:42:27","Exit Invoice [Invoice No: 118743] updated by Yasir  Rahman on 18/02/2019 at 12:42 PM");
INSERT INTO crm_audit_log VALUES("3573","3","4","2019-02-18 12:43:39","Exit Invoice [Invoice No: 118744] updated by Yasir  Rahman on 18/02/2019 at 12:43 PM");
INSERT INTO crm_audit_log VALUES("3574","3","4","2019-02-18 12:47:32","Exit Invoice [Invoice No: 118745] updated by Yasir  Rahman on 18/02/2019 at 12:47 PM");
INSERT INTO crm_audit_log VALUES("3575","2","7","2019-02-18 13:52:00","Entry Invoice [Invoice No: 20357] updated by ALSED ABU SHAMA on 18/02/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("3576","2","7","2019-02-18 14:09:51","Entry Invoice [Invoice No: 20358] updated by ALSED ABU SHAMA on 18/02/2019 at 02:09 PM");
INSERT INTO crm_audit_log VALUES("3577","3","4","2019-02-18 15:10:44","Exit Invoice [Invoice No: 118746] updated by Yasir  Rahman on 18/02/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("3578","3","4","2019-02-18 15:31:06","Exit Invoice [Invoice No: 118747] updated by Yasir  Rahman on 18/02/2019 at 03:31 PM");
INSERT INTO crm_audit_log VALUES("3579","3","4","2019-02-18 15:34:58","Exit Invoice [Invoice No: 118748] updated by Yasir  Rahman on 18/02/2019 at 03:34 PM");
INSERT INTO crm_audit_log VALUES("3580","3","4","2019-02-18 15:43:52","Exit Invoice [Invoice No: 118749] updated by Yasir  Rahman on 18/02/2019 at 03:43 PM");
INSERT INTO crm_audit_log VALUES("3581","3","4","2019-02-18 15:49:35","Exit Invoice [Invoice No: 118750] updated by Yasir  Rahman on 18/02/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("3582","2","7","2019-02-18 17:39:08","Entry Invoice [Invoice No: 20359] updated by ALSED ABU SHAMA on 18/02/2019 at 05:39 PM");
INSERT INTO crm_audit_log VALUES("3583","2","7","2019-02-18 19:35:19","Entry Invoice [Invoice No: 20360] updated by ALSED ABU SHAMA on 18/02/2019 at 07:35 PM");
INSERT INTO crm_audit_log VALUES("3584","2","7","2019-02-18 19:47:35","Entry Invoice [Invoice No: 20361] updated by ALSED ABU SHAMA on 18/02/2019 at 07:47 PM");
INSERT INTO crm_audit_log VALUES("3585","3","5","2019-02-18 21:59:59","Exit Invoice [Invoice No: 118751] updated by Imran  Khan on 18/02/2019 at 09:59 PM");
INSERT INTO crm_audit_log VALUES("3586","3","5","2019-02-18 23:00:27","Exit Invoice [Invoice No: 118752] updated by Imran  Khan on 18/02/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("3587","2","4","2019-02-19 00:57:10","Entry Invoice [Invoice No: 20362] updated by Yasir  Rahman on 19/02/2019 at 12:57 AM");
INSERT INTO crm_audit_log VALUES("3588","2","4","2019-02-19 01:00:16","Entry Invoice [Invoice No: 20363] updated by Yasir  Rahman on 19/02/2019 at 01:00 AM");
INSERT INTO crm_audit_log VALUES("3589","2","4","2019-02-19 01:02:19","Entry Invoice [Invoice No: 20364] updated by Yasir  Rahman on 19/02/2019 at 01:02 AM");
INSERT INTO crm_audit_log VALUES("3590","2","4","2019-02-19 01:04:43","Entry Invoice [Invoice No: 20365] updated by Yasir  Rahman on 19/02/2019 at 01:04 AM");
INSERT INTO crm_audit_log VALUES("3591","2","4","2019-02-19 01:51:45","Entry Invoice [Invoice No: 20366] updated by Yasir  Rahman on 19/02/2019 at 01:51 AM");
INSERT INTO crm_audit_log VALUES("3592","2","4","2019-02-19 03:05:16","Entry Invoice [Invoice No: 20367] updated by Yasir  Rahman on 19/02/2019 at 03:05 AM");
INSERT INTO crm_audit_log VALUES("3593","2","4","2019-02-19 03:07:02","Entry Invoice [Invoice No: 20368] updated by Yasir  Rahman on 19/02/2019 at 03:07 AM");
INSERT INTO crm_audit_log VALUES("3594","2","4","2019-02-19 03:10:10","Entry Invoice [Invoice No: 20369] updated by Yasir  Rahman on 19/02/2019 at 03:10 AM");
INSERT INTO crm_audit_log VALUES("3595","2","4","2019-02-19 03:12:39","Entry Invoice [Invoice No: 20370] updated by Yasir  Rahman on 19/02/2019 at 03:12 AM");
INSERT INTO crm_audit_log VALUES("3596","2","4","2019-02-19 03:14:10","Entry Invoice [Invoice No: 20371] updated by Yasir  Rahman on 19/02/2019 at 03:14 AM");
INSERT INTO crm_audit_log VALUES("3597","3","5","2019-02-19 04:58:11","Exit Invoice [Invoice No: 118753] updated by Imran  Khan on 19/02/2019 at 04:58 AM");
INSERT INTO crm_audit_log VALUES("3598","3","5","2019-02-19 06:12:32","Exit Invoice [Invoice No: 118754] updated by Imran  Khan on 19/02/2019 at 06:12 AM");
INSERT INTO crm_audit_log VALUES("3599","2","6","2019-02-19 08:50:43","Entry Invoice [Invoice No: 20369] updated by ASHRAF  M K on 19/02/2019 at 08:50 AM");
INSERT INTO crm_audit_log VALUES("3600","2","6","2019-02-19 08:52:08","Entry Invoice [Invoice No: 20364] updated by ASHRAF  M K on 19/02/2019 at 08:52 AM");
INSERT INTO crm_audit_log VALUES("3601","2","6","2019-02-19 09:38:07","Entry Invoice [Invoice No: 20369] updated by ASHRAF  M K on 19/02/2019 at 09:38 AM");
INSERT INTO crm_audit_log VALUES("3602","3","4","2019-02-19 12:03:18","Exit Invoice [Invoice No: 118755] updated by Yasir  Rahman on 19/02/2019 at 12:03 PM");
INSERT INTO crm_audit_log VALUES("3603","2","11","2019-02-19 13:52:14","Entry Invoice [Invoice No: 20372] updated by GAREEB GAREEB on 19/02/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("3604","3","4","2019-02-19 13:56:23","Exit Invoice [Invoice No: 118756] updated by Yasir  Rahman on 19/02/2019 at 01:56 PM");
INSERT INTO crm_audit_log VALUES("3605","3","4","2019-02-19 14:19:41","Exit Invoice [Invoice No: 118757] updated by Yasir  Rahman on 19/02/2019 at 02:19 PM");
INSERT INTO crm_audit_log VALUES("3606","2","11","2019-02-19 14:48:57","Entry Invoice [Invoice No: 20373] updated by GAREEB GAREEB on 19/02/2019 at 02:48 PM");
INSERT INTO crm_audit_log VALUES("3607","2","11","2019-02-19 14:51:38","Entry Invoice [Invoice No: 20374] updated by GAREEB GAREEB on 19/02/2019 at 02:51 PM");
INSERT INTO crm_audit_log VALUES("3608","2","11","2019-02-19 14:54:12","Entry Invoice [Invoice No: 20375] updated by GAREEB GAREEB on 19/02/2019 at 02:54 PM");
INSERT INTO crm_audit_log VALUES("3609","3","4","2019-02-19 15:36:34","Exit Invoice [Invoice No: 118758] updated by Yasir  Rahman on 19/02/2019 at 03:36 PM");
INSERT INTO crm_audit_log VALUES("3610","2","11","2019-02-19 16:52:55","Entry Invoice [Invoice No: 20376] updated by GAREEB GAREEB on 19/02/2019 at 04:52 PM");
INSERT INTO crm_audit_log VALUES("3611","3","4","2019-02-19 17:00:15","Exit Invoice [Invoice No: 118759] updated by Yasir  Rahman on 19/02/2019 at 05:00 PM");
INSERT INTO crm_audit_log VALUES("3612","3","4","2019-02-19 17:39:13","Exit Invoice [Invoice No: 118760] updated by Yasir  Rahman on 19/02/2019 at 05:39 PM");
INSERT INTO crm_audit_log VALUES("3613","3","4","2019-02-19 17:40:25","Exit Invoice [Invoice No: 118761] updated by Yasir  Rahman on 19/02/2019 at 05:40 PM");
INSERT INTO crm_audit_log VALUES("3614","2","11","2019-02-19 17:57:46","Entry Invoice [Invoice No: 20377] updated by GAREEB GAREEB on 19/02/2019 at 05:57 PM");
INSERT INTO crm_audit_log VALUES("3615","2","11","2019-02-19 19:32:49","Entry Invoice [Invoice No: 20378] updated by GAREEB GAREEB on 19/02/2019 at 07:32 PM");
INSERT INTO crm_audit_log VALUES("3616","2","11","2019-02-19 19:38:32","Entry Invoice [Invoice No: 20379] updated by GAREEB GAREEB on 19/02/2019 at 07:38 PM");
INSERT INTO crm_audit_log VALUES("3617","3","5","2019-02-19 22:34:09","Exit Invoice [Invoice No: 118762] updated by Imran  Khan on 19/02/2019 at 10:34 PM");
INSERT INTO crm_audit_log VALUES("3618","3","5","2019-02-19 22:35:25","Exit Invoice [Invoice No: 118763] updated by Imran  Khan on 19/02/2019 at 10:35 PM");
INSERT INTO crm_audit_log VALUES("3619","3","5","2019-02-19 22:36:21","Exit Invoice [Invoice No: 118764] updated by Imran  Khan on 19/02/2019 at 10:36 PM");
INSERT INTO crm_audit_log VALUES("3620","3","5","2019-02-19 23:09:34","Exit Invoice [Invoice No: 118765] updated by Imran  Khan on 19/02/2019 at 11:09 PM");
INSERT INTO crm_audit_log VALUES("3621","3","5","2019-02-19 23:14:30","Exit Invoice [Invoice No: 118766] updated by Imran  Khan on 19/02/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("3622","2","4","2019-02-19 23:16:01","Entry Invoice [Invoice No: 20380] updated by Yasir  Rahman on 19/02/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("3623","2","4","2019-02-19 23:18:01","Entry Invoice [Invoice No: 20381] updated by Yasir  Rahman on 19/02/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("3624","2","4","2019-02-19 23:19:33","Entry Invoice [Invoice No: 20382] updated by Yasir  Rahman on 19/02/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("3625","3","5","2019-02-19 23:20:48","Exit Invoice [Invoice No: 118767] updated by Imran  Khan on 19/02/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("3626","3","5","2019-02-19 23:22:33","Exit Invoice [Invoice No: 118768] updated by Imran  Khan on 19/02/2019 at 11:22 PM");
INSERT INTO crm_audit_log VALUES("3627","3","5","2019-02-19 23:38:20","Exit Invoice [Invoice No: 118769] updated by Imran  Khan on 19/02/2019 at 11:38 PM");
INSERT INTO crm_audit_log VALUES("3628","3","5","2019-02-20 00:35:05","Exit Invoice [Invoice No: 118770] updated by Imran  Khan on 20/02/2019 at 12:35 AM");
INSERT INTO crm_audit_log VALUES("3629","3","5","2019-02-20 00:35:49","Exit Invoice [Invoice No: 118771] updated by Imran  Khan on 20/02/2019 at 12:35 AM");
INSERT INTO crm_audit_log VALUES("3630","3","5","2019-02-20 03:30:17","Exit Invoice [Invoice No: 118772] updated by Imran  Khan on 20/02/2019 at 03:30 AM");
INSERT INTO crm_audit_log VALUES("3631","2","4","2019-02-20 05:48:05","Entry Invoice [Invoice No: 20383] updated by Yasir  Rahman on 20/02/2019 at 05:48 AM");
INSERT INTO crm_audit_log VALUES("3632","2","4","2019-02-20 05:53:30","Entry Invoice [Invoice No: 20384] updated by Yasir  Rahman on 20/02/2019 at 05:53 AM");
INSERT INTO crm_audit_log VALUES("3633","2","4","2019-02-20 05:55:34","Entry Invoice [Invoice No: 20385] updated by Yasir  Rahman on 20/02/2019 at 05:55 AM");
INSERT INTO crm_audit_log VALUES("3634","2","4","2019-02-20 05:56:56","Entry Invoice [Invoice No: 20386] updated by Yasir  Rahman on 20/02/2019 at 05:56 AM");
INSERT INTO crm_audit_log VALUES("3635","3","5","2019-02-20 06:44:08","Exit Invoice [Invoice No: 118773] updated by Imran  Khan on 20/02/2019 at 06:44 AM");
INSERT INTO crm_audit_log VALUES("3636","2","4","2019-02-20 07:15:21","Entry Invoice [Invoice No: 20387] updated by Yasir  Rahman on 20/02/2019 at 07:15 AM");
INSERT INTO crm_audit_log VALUES("3637","2","4","2019-02-20 07:37:36","Entry Invoice [Invoice No: 20388] updated by Yasir  Rahman on 20/02/2019 at 07:37 AM");
INSERT INTO crm_audit_log VALUES("3638","2","4","2019-02-20 07:39:06","Entry Invoice [Invoice No: 20389] updated by Yasir  Rahman on 20/02/2019 at 07:39 AM");
INSERT INTO crm_audit_log VALUES("3639","2","11","2019-02-20 08:47:28","Entry Invoice [Invoice No: 20390] updated by GAREEB GAREEB on 20/02/2019 at 08:47 AM");
INSERT INTO crm_audit_log VALUES("3640","3","4","2019-02-20 09:26:46","Exit Invoice [Invoice No: 118774] updated by Yasir  Rahman on 20/02/2019 at 09:26 AM");
INSERT INTO crm_audit_log VALUES("3641","3","4","2019-02-20 09:29:06","Exit Invoice [Invoice No: 118775] updated by Yasir  Rahman on 20/02/2019 at 09:29 AM");
INSERT INTO crm_audit_log VALUES("3642","2","11","2019-02-20 09:47:00","Entry Invoice [Invoice No: 20391] updated by GAREEB GAREEB on 20/02/2019 at 09:47 AM");
INSERT INTO crm_audit_log VALUES("3643","3","4","2019-02-20 11:14:18","Exit Invoice [Invoice No: 118776] updated by Yasir  Rahman on 20/02/2019 at 11:14 AM");
INSERT INTO crm_audit_log VALUES("3644","2","11","2019-02-20 11:40:12","Entry Invoice [Invoice No: 20392] updated by GAREEB GAREEB on 20/02/2019 at 11:40 AM");
INSERT INTO crm_audit_log VALUES("3645","1","4","2019-02-20 12:15:43","Customer [Customer No: 422] updated by Yasir  Rahman on 20/02/2019 at 12:15 PM");
INSERT INTO crm_audit_log VALUES("3646","1","4","2019-02-20 12:18:46","Customer [Customer No: 423] updated by Yasir  Rahman on 20/02/2019 at 12:18 PM");
INSERT INTO crm_audit_log VALUES("3647","2","6","2019-02-20 12:25:50","Entry Invoice [Invoice No: 20346] updated by ASHRAF  M K on 20/02/2019 at 12:25 PM");
INSERT INTO crm_audit_log VALUES("3648","3","4","2019-02-20 14:05:59","Exit Invoice [Invoice No: 118777] updated by Yasir  Rahman on 20/02/2019 at 02:05 PM");
INSERT INTO crm_audit_log VALUES("3649","3","4","2019-02-20 14:06:41","Exit Invoice [Invoice No: 118778] updated by Yasir  Rahman on 20/02/2019 at 02:06 PM");
INSERT INTO crm_audit_log VALUES("3650","3","4","2019-02-20 14:07:26","Exit Invoice [Invoice No: 118779] updated by Yasir  Rahman on 20/02/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("3651","3","4","2019-02-20 15:31:51","Exit Invoice [Invoice No: 118780] updated by Yasir  Rahman on 20/02/2019 at 03:31 PM");
INSERT INTO crm_audit_log VALUES("3652","3","4","2019-02-20 15:52:36","Exit Invoice [Invoice No: 118781] updated by Yasir  Rahman on 20/02/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("3653","3","4","2019-02-20 15:57:01","Exit Invoice [Invoice No: 118782] updated by Yasir  Rahman on 20/02/2019 at 03:57 PM");
INSERT INTO crm_audit_log VALUES("3654","2","11","2019-02-20 16:30:32","Entry Invoice [Invoice No: 20393] updated by GAREEB GAREEB on 20/02/2019 at 04:30 PM");
INSERT INTO crm_audit_log VALUES("3655","2","11","2019-02-20 16:35:44","Entry Invoice [Invoice No: 20394] updated by GAREEB GAREEB on 20/02/2019 at 04:35 PM");
INSERT INTO crm_audit_log VALUES("3656","2","11","2019-02-20 16:37:55","Entry Invoice [Invoice No: 20395] updated by GAREEB GAREEB on 20/02/2019 at 04:37 PM");
INSERT INTO crm_audit_log VALUES("3657","2","11","2019-02-20 16:40:03","Entry Invoice [Invoice No: 20396] updated by GAREEB GAREEB on 20/02/2019 at 04:40 PM");
INSERT INTO crm_audit_log VALUES("3658","3","4","2019-02-20 16:41:42","Exit Invoice [Invoice No: 118783] updated by Yasir  Rahman on 20/02/2019 at 04:41 PM");
INSERT INTO crm_audit_log VALUES("3659","2","11","2019-02-20 17:17:22","Entry Invoice [Invoice No: 20397] updated by GAREEB GAREEB on 20/02/2019 at 05:17 PM");
INSERT INTO crm_audit_log VALUES("3660","3","4","2019-02-20 17:31:10","Exit Invoice [Invoice No: 118784] updated by Yasir  Rahman on 20/02/2019 at 05:31 PM");
INSERT INTO crm_audit_log VALUES("3661","3","4","2019-02-20 18:08:37","Exit Invoice [Invoice No: 118785] updated by Yasir  Rahman on 20/02/2019 at 06:08 PM");
INSERT INTO crm_audit_log VALUES("3662","3","4","2019-02-20 18:10:08","Exit Invoice [Invoice No: 118786] updated by Yasir  Rahman on 20/02/2019 at 06:10 PM");
INSERT INTO crm_audit_log VALUES("3663","3","4","2019-02-20 18:37:04","Exit Invoice [Invoice No: 118787] updated by Yasir  Rahman on 20/02/2019 at 06:37 PM");
INSERT INTO crm_audit_log VALUES("3664","3","5","2019-02-20 20:48:44","Exit Invoice [Invoice No: 118788] updated by Imran  Khan on 20/02/2019 at 08:48 PM");
INSERT INTO crm_audit_log VALUES("3665","2","4","2019-02-20 21:13:58","Entry Invoice [Invoice No: 20398] updated by Yasir  Rahman on 20/02/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("3666","2","4","2019-02-20 21:34:51","Entry Invoice [Invoice No: 20399] updated by Yasir  Rahman on 20/02/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("3667","2","4","2019-02-20 21:37:05","Entry Invoice [Invoice No: 20400] updated by Yasir  Rahman on 20/02/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("3668","2","6","2019-02-20 21:38:48","Entry Invoice [Invoice No: 20399] updated by ASHRAF  M K on 20/02/2019 at 09:38 PM");
INSERT INTO crm_audit_log VALUES("3669","2","4","2019-02-20 21:47:04","Entry Invoice [Invoice No: 20401] updated by Yasir  Rahman on 20/02/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("3670","2","4","2019-02-20 22:12:05","Entry Invoice [Invoice No: 20402] updated by Yasir  Rahman on 20/02/2019 at 10:12 PM");
INSERT INTO crm_audit_log VALUES("3671","3","5","2019-02-20 22:25:36","Exit Invoice [Invoice No: 118789] updated by Imran  Khan on 20/02/2019 at 10:25 PM");
INSERT INTO crm_audit_log VALUES("3672","3","5","2019-02-20 22:29:40","Exit Invoice [Invoice No: 118790] updated by Imran  Khan on 20/02/2019 at 10:29 PM");
INSERT INTO crm_audit_log VALUES("3673","3","5","2019-02-21 03:00:51","Exit Invoice [Invoice No: 118791] updated by Imran  Khan on 21/02/2019 at 03:00 AM");
INSERT INTO crm_audit_log VALUES("3674","3","5","2019-02-21 03:06:51","Exit Invoice [Invoice No: 118792] updated by Imran  Khan on 21/02/2019 at 03:06 AM");
INSERT INTO crm_audit_log VALUES("3675","3","5","2019-02-21 03:07:28","Exit Invoice [Invoice No: 118793] updated by Imran  Khan on 21/02/2019 at 03:07 AM");
INSERT INTO crm_audit_log VALUES("3676","1","5","2019-02-21 03:11:22","Customer [Customer No: 424] updated by Imran  Khan on 21/02/2019 at 03:11 AM");
INSERT INTO crm_audit_log VALUES("3677","3","5","2019-02-21 03:12:17","Exit Invoice [Invoice No: 118794] updated by Imran  Khan on 21/02/2019 at 03:12 AM");
INSERT INTO crm_audit_log VALUES("3678","1","5","2019-02-21 04:11:28","Customer [Customer No: 425] updated by Imran  Khan on 21/02/2019 at 04:11 AM");
INSERT INTO crm_audit_log VALUES("3679","3","5","2019-02-21 04:12:21","Exit Invoice [Invoice No: 118795] updated by Imran  Khan on 21/02/2019 at 04:12 AM");
INSERT INTO crm_audit_log VALUES("3680","3","5","2019-02-21 04:14:13","Exit Invoice [Invoice No: 118796] updated by Imran  Khan on 21/02/2019 at 04:14 AM");
INSERT INTO crm_audit_log VALUES("3681","3","5","2019-02-21 04:15:09","Exit Invoice [Invoice No: 118797] updated by Imran  Khan on 21/02/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("3682","2","6","2019-02-21 08:26:09","Entry Invoice [Invoice No: 20402] updated by ASHRAF  M K on 21/02/2019 at 08:26 AM");
INSERT INTO crm_audit_log VALUES("3683","2","15","2019-02-21 08:58:14","Entry Invoice [Invoice No: 20403] updated by Abdul Rasheed on 21/02/2019 at 08:58 AM");
INSERT INTO crm_audit_log VALUES("3684","3","6","2019-02-21 09:25:34","Exit Invoice [Invoice No: 118795] updated by ASHRAF  M K on 21/02/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("3685","3","4","2019-02-21 10:01:41","Exit Invoice [Invoice No: 118798] updated by Yasir  Rahman on 21/02/2019 at 10:01 AM");
INSERT INTO crm_audit_log VALUES("3686","2","15","2019-02-21 10:45:52","Entry Invoice [Invoice No: 20404] updated by Abdul Rasheed on 21/02/2019 at 10:45 AM");
INSERT INTO crm_audit_log VALUES("3687","2","15","2019-02-21 10:47:20","Entry Invoice [Invoice No: 20405] updated by Abdul Rasheed on 21/02/2019 at 10:47 AM");
INSERT INTO crm_audit_log VALUES("3688","2","15","2019-02-21 10:48:34","Entry Invoice [Invoice No: 20406] updated by Abdul Rasheed on 21/02/2019 at 10:48 AM");
INSERT INTO crm_audit_log VALUES("3689","2","15","2019-02-21 10:49:52","Entry Invoice [Invoice No: 20407] updated by Abdul Rasheed on 21/02/2019 at 10:49 AM");
INSERT INTO crm_audit_log VALUES("3690","2","7","2019-02-21 11:27:40","Entry Invoice [Invoice No: 20408] updated by ALSED ABU SHAMA on 21/02/2019 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("3691","3","4","2019-02-21 12:34:49","Exit Invoice [Invoice No: 118799] updated by Yasir  Rahman on 21/02/2019 at 12:34 PM");
INSERT INTO crm_audit_log VALUES("3692","3","4","2019-02-21 12:53:36","Exit Invoice [Invoice No: 118800] updated by Yasir  Rahman on 21/02/2019 at 12:53 PM");
INSERT INTO crm_audit_log VALUES("3693","3","4","2019-02-21 12:55:00","Exit Invoice [Invoice No: 118801] updated by Yasir  Rahman on 21/02/2019 at 12:55 PM");
INSERT INTO crm_audit_log VALUES("3694","3","4","2019-02-21 13:20:03","Exit Invoice [Invoice No: 118802] updated by Yasir  Rahman on 21/02/2019 at 01:20 PM");
INSERT INTO crm_audit_log VALUES("3695","3","4","2019-02-21 13:21:28","Exit Invoice [Invoice No: 118803] updated by Yasir  Rahman on 21/02/2019 at 01:21 PM");
INSERT INTO crm_audit_log VALUES("3696","3","4","2019-02-21 13:27:43","Exit Invoice [Invoice No: 118804] updated by Yasir  Rahman on 21/02/2019 at 01:27 PM");
INSERT INTO crm_audit_log VALUES("3697","3","4","2019-02-21 13:46:34","Exit Invoice [Invoice No: 118805] updated by Yasir  Rahman on 21/02/2019 at 01:46 PM");
INSERT INTO crm_audit_log VALUES("3698","3","4","2019-02-21 15:10:41","Exit Invoice [Invoice No: 118806] updated by Yasir  Rahman on 21/02/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("3699","3","4","2019-02-21 15:43:58","Exit Invoice [Invoice No: 118807] updated by Yasir  Rahman on 21/02/2019 at 03:43 PM");
INSERT INTO crm_audit_log VALUES("3700","3","4","2019-02-21 15:48:32","Exit Invoice [Invoice No: 118808] updated by Yasir  Rahman on 21/02/2019 at 03:48 PM");
INSERT INTO crm_audit_log VALUES("3701","3","6","2019-02-21 15:55:50","Exit Invoice [Invoice No: 118795] updated by ASHRAF  M K on 21/02/2019 at 03:55 PM");
INSERT INTO crm_audit_log VALUES("3702","2","7","2019-02-21 16:53:36","Entry Invoice [Invoice No: 20409] updated by ALSED ABU SHAMA on 21/02/2019 at 04:53 PM");
INSERT INTO crm_audit_log VALUES("3703","3","11","2019-02-21 17:28:12","Exit Invoice [Invoice No: 118809] updated by GAREEB GAREEB on 21/02/2019 at 05:28 PM");
INSERT INTO crm_audit_log VALUES("3704","3","11","2019-02-21 17:29:18","Exit Invoice [Invoice No: 118810] updated by GAREEB GAREEB on 21/02/2019 at 05:29 PM");
INSERT INTO crm_audit_log VALUES("3705","3","11","2019-02-21 17:30:19","Exit Invoice [Invoice No: 118811] updated by GAREEB GAREEB on 21/02/2019 at 05:30 PM");
INSERT INTO crm_audit_log VALUES("3706","3","11","2019-02-21 17:39:50","Exit Invoice [Invoice No: 118812] updated by GAREEB GAREEB on 21/02/2019 at 05:39 PM");
INSERT INTO crm_audit_log VALUES("3707","2","7","2019-02-21 17:41:44","Entry Invoice [Invoice No: 20410] updated by ALSED ABU SHAMA on 21/02/2019 at 05:41 PM");
INSERT INTO crm_audit_log VALUES("3708","3","11","2019-02-21 18:43:54","Exit Invoice [Invoice No: 118813] updated by GAREEB GAREEB on 21/02/2019 at 06:43 PM");
INSERT INTO crm_audit_log VALUES("3709","3","11","2019-02-21 18:47:20","Exit Invoice [Invoice No: 118814] updated by GAREEB GAREEB on 21/02/2019 at 06:47 PM");
INSERT INTO crm_audit_log VALUES("3710","3","11","2019-02-21 18:48:19","Exit Invoice [Invoice No: 118815] updated by GAREEB GAREEB on 21/02/2019 at 06:48 PM");
INSERT INTO crm_audit_log VALUES("3711","3","11","2019-02-21 20:15:48","Exit Invoice [Invoice No: 118816] updated by GAREEB GAREEB on 21/02/2019 at 08:15 PM");
INSERT INTO crm_audit_log VALUES("3712","2","4","2019-02-21 22:08:15","Entry Invoice [Invoice No: 20411] updated by Yasir  Rahman on 21/02/2019 at 10:08 PM");
INSERT INTO crm_audit_log VALUES("3713","3","11","2019-02-21 22:11:48","Exit Invoice [Invoice No: 118817] updated by GAREEB GAREEB on 21/02/2019 at 10:11 PM");
INSERT INTO crm_audit_log VALUES("3714","2","4","2019-02-21 22:12:38","Entry Invoice [Invoice No: 20412] updated by Yasir  Rahman on 21/02/2019 at 10:12 PM");
INSERT INTO crm_audit_log VALUES("3715","1","11","2019-02-21 22:14:57","Customer [Customer No: 426] updated by GAREEB GAREEB on 21/02/2019 at 10:14 PM");
INSERT INTO crm_audit_log VALUES("3716","3","11","2019-02-21 22:16:41","Exit Invoice [Invoice No: 118818] updated by GAREEB GAREEB on 21/02/2019 at 10:16 PM");
INSERT INTO crm_audit_log VALUES("3717","2","4","2019-02-21 22:16:45","Entry Invoice [Invoice No: 20413] updated by Yasir  Rahman on 21/02/2019 at 10:16 PM");
INSERT INTO crm_audit_log VALUES("3718","2","4","2019-02-22 01:56:10","Entry Invoice [Invoice No: 20414] updated by Yasir  Rahman on 22/02/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("3719","3","5","2019-02-22 02:46:59","Exit Invoice [Invoice No: 118819] updated by Imran  Khan on 22/02/2019 at 02:46 AM");
INSERT INTO crm_audit_log VALUES("3720","3","5","2019-02-22 02:47:48","Exit Invoice [Invoice No: 118820] updated by Imran  Khan on 22/02/2019 at 02:47 AM");
INSERT INTO crm_audit_log VALUES("3721","3","5","2019-02-22 04:14:32","Exit Invoice [Invoice No: 118821] updated by Imran  Khan on 22/02/2019 at 04:14 AM");
INSERT INTO crm_audit_log VALUES("3722","3","5","2019-02-22 05:13:06","Exit Invoice [Invoice No: 118822] updated by Imran  Khan on 22/02/2019 at 05:13 AM");
INSERT INTO crm_audit_log VALUES("3723","3","5","2019-02-22 05:13:59","Exit Invoice [Invoice No: 118823] updated by Imran  Khan on 22/02/2019 at 05:13 AM");
INSERT INTO crm_audit_log VALUES("3724","2","4","2019-02-22 06:50:02","Entry Invoice [Invoice No: 20415] updated by Yasir  Rahman on 22/02/2019 at 06:50 AM");
INSERT INTO crm_audit_log VALUES("3725","2","4","2019-02-22 06:53:31","Entry Invoice [Invoice No: 20416] updated by Yasir  Rahman on 22/02/2019 at 06:53 AM");
INSERT INTO crm_audit_log VALUES("3726","2","4","2019-02-22 06:55:23","Entry Invoice [Invoice No: 20417] updated by Yasir  Rahman on 22/02/2019 at 06:55 AM");
INSERT INTO crm_audit_log VALUES("3727","2","4","2019-02-22 06:56:29","Entry Invoice [Invoice No: 20418] updated by Yasir  Rahman on 22/02/2019 at 06:56 AM");
INSERT INTO crm_audit_log VALUES("3728","3","5","2019-02-22 07:39:26","Exit Invoice [Invoice No: 118824] updated by Imran  Khan on 22/02/2019 at 07:39 AM");
INSERT INTO crm_audit_log VALUES("3729","2","6","2019-02-22 08:35:09","Entry Invoice [Invoice No: 20418] updated by ASHRAF  M K on 22/02/2019 at 08:35 AM");
INSERT INTO crm_audit_log VALUES("3730","3","4","2019-02-22 09:34:09","Exit Invoice [Invoice No: 118825] updated by Yasir  Rahman on 22/02/2019 at 09:34 AM");
INSERT INTO crm_audit_log VALUES("3731","3","4","2019-02-22 09:35:09","Exit Invoice [Invoice No: 118826] updated by Yasir  Rahman on 22/02/2019 at 09:35 AM");
INSERT INTO crm_audit_log VALUES("3732","2","15","2019-02-22 10:31:07","Entry Invoice [Invoice No: 20419] updated by Abdul Rasheed on 22/02/2019 at 10:31 AM");
INSERT INTO crm_audit_log VALUES("3733","3","4","2019-02-22 11:17:46","Exit Invoice [Invoice No: 118827] updated by Yasir  Rahman on 22/02/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("3734","3","4","2019-02-22 11:35:37","Exit Invoice [Invoice No: 118828] updated by Yasir  Rahman on 22/02/2019 at 11:35 AM");
INSERT INTO crm_audit_log VALUES("3735","3","4","2019-02-22 12:03:32","Exit Invoice [Invoice No: 118829] updated by Yasir  Rahman on 22/02/2019 at 12:03 PM");
INSERT INTO crm_audit_log VALUES("3736","3","4","2019-02-22 14:38:30","Exit Invoice [Invoice No: 118830] updated by Yasir  Rahman on 22/02/2019 at 02:38 PM");
INSERT INTO crm_audit_log VALUES("3737","3","4","2019-02-22 14:40:38","Exit Invoice [Invoice No: 118831] updated by Yasir  Rahman on 22/02/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("3738","3","4","2019-02-22 15:26:54","Exit Invoice [Invoice No: 118832] updated by Yasir  Rahman on 22/02/2019 at 03:26 PM");
INSERT INTO crm_audit_log VALUES("3739","3","4","2019-02-22 15:32:36","Exit Invoice [Invoice No: 118833] updated by Yasir  Rahman on 22/02/2019 at 03:32 PM");
INSERT INTO crm_audit_log VALUES("3740","3","4","2019-02-22 15:33:44","Exit Invoice [Invoice No: 118834] updated by Yasir  Rahman on 22/02/2019 at 03:33 PM");
INSERT INTO crm_audit_log VALUES("3741","3","4","2019-02-22 15:35:10","Exit Invoice [Invoice No: 118835] updated by Yasir  Rahman on 22/02/2019 at 03:35 PM");
INSERT INTO crm_audit_log VALUES("3742","3","4","2019-02-22 16:07:15","Exit Invoice [Invoice No: 118836] updated by Yasir  Rahman on 22/02/2019 at 04:07 PM");
INSERT INTO crm_audit_log VALUES("3743","3","4","2019-02-22 16:45:32","Exit Invoice [Invoice No: 118837] updated by Yasir  Rahman on 22/02/2019 at 04:45 PM");
INSERT INTO crm_audit_log VALUES("3744","2","7","2019-02-22 18:29:42","Entry Invoice [Invoice No: 20420] updated by ALSED ABU SHAMA on 22/02/2019 at 06:29 PM");
INSERT INTO crm_audit_log VALUES("3745","2","7","2019-02-22 18:35:47","Entry Invoice [Invoice No: 20421] updated by ALSED ABU SHAMA on 22/02/2019 at 06:35 PM");
INSERT INTO crm_audit_log VALUES("3746","2","7","2019-02-22 18:38:24","Entry Invoice [Invoice No: 20422] updated by ALSED ABU SHAMA on 22/02/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("3747","3","5","2019-02-22 22:18:41","Exit Invoice [Invoice No: 118838] updated by Imran  Khan on 22/02/2019 at 10:18 PM");
INSERT INTO crm_audit_log VALUES("3748","2","4","2019-02-23 00:04:58","Entry Invoice [Invoice No: 20423] updated by Yasir  Rahman on 23/02/2019 at 12:04 AM");
INSERT INTO crm_audit_log VALUES("3749","2","4","2019-02-23 00:12:59","Entry Invoice [Invoice No: 20424] updated by Yasir  Rahman on 23/02/2019 at 12:12 AM");
INSERT INTO crm_audit_log VALUES("3750","2","4","2019-02-23 00:27:38","Entry Invoice [Invoice No: 20425] updated by Yasir  Rahman on 23/02/2019 at 12:27 AM");
INSERT INTO crm_audit_log VALUES("3751","3","5","2019-02-23 01:01:50","Exit Invoice [Invoice No: 118839] updated by Imran  Khan on 23/02/2019 at 01:01 AM");
INSERT INTO crm_audit_log VALUES("3752","2","4","2019-02-23 01:05:25","Entry Invoice [Invoice No: 20426] updated by Yasir  Rahman on 23/02/2019 at 01:05 AM");
INSERT INTO crm_audit_log VALUES("3753","2","4","2019-02-23 01:36:21","Entry Invoice [Invoice No: 20427] updated by Yasir  Rahman on 23/02/2019 at 01:36 AM");
INSERT INTO crm_audit_log VALUES("3754","2","4","2019-02-23 01:37:37","Entry Invoice [Invoice No: 20428] updated by Yasir  Rahman on 23/02/2019 at 01:37 AM");
INSERT INTO crm_audit_log VALUES("3755","2","4","2019-02-23 01:39:07","Entry Invoice [Invoice No: 20429] updated by Yasir  Rahman on 23/02/2019 at 01:39 AM");
INSERT INTO crm_audit_log VALUES("3756","3","4","2019-02-23 09:13:00","Exit Invoice [Invoice No: 118840] updated by Yasir  Rahman on 23/02/2019 at 09:13 AM");
INSERT INTO crm_audit_log VALUES("3757","3","4","2019-02-23 09:20:58","Exit Invoice [Invoice No: 118841] updated by Yasir  Rahman on 23/02/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("3758","2","15","2019-02-23 12:13:06","Entry Invoice [Invoice No: 20430] updated by Abdul Rasheed on 23/02/2019 at 12:13 PM");
INSERT INTO crm_audit_log VALUES("3759","3","4","2019-02-23 12:19:39","Exit Invoice [Invoice No: 118842] updated by Yasir  Rahman on 23/02/2019 at 12:19 PM");
INSERT INTO crm_audit_log VALUES("3760","2","7","2019-02-23 12:56:49","Entry Invoice [Invoice No: 20431] updated by ALSED ABU SHAMA on 23/02/2019 at 12:56 PM");
INSERT INTO crm_audit_log VALUES("3761","3","4","2019-02-23 15:19:31","Exit Invoice [Invoice No: 118843] updated by Yasir  Rahman on 23/02/2019 at 03:19 PM");
INSERT INTO crm_audit_log VALUES("3762","2","15","2019-02-23 16:09:54","Entry Invoice [Invoice No: 20432] updated by Abdul Rasheed on 23/02/2019 at 04:09 PM");
INSERT INTO crm_audit_log VALUES("3763","2","15","2019-02-23 16:11:13","Entry Invoice [Invoice No: 20433] updated by Abdul Rasheed on 23/02/2019 at 04:11 PM");
INSERT INTO crm_audit_log VALUES("3764","2","15","2019-02-23 16:12:16","Entry Invoice [Invoice No: 20434] updated by Abdul Rasheed on 23/02/2019 at 04:12 PM");
INSERT INTO crm_audit_log VALUES("3765","2","15","2019-02-23 16:13:33","Entry Invoice [Invoice No: 20435] updated by Abdul Rasheed on 23/02/2019 at 04:13 PM");
INSERT INTO crm_audit_log VALUES("3766","2","15","2019-02-23 16:14:55","Entry Invoice [Invoice No: 20436] updated by Abdul Rasheed on 23/02/2019 at 04:14 PM");
INSERT INTO crm_audit_log VALUES("3767","2","15","2019-02-23 16:15:56","Entry Invoice [Invoice No: 20437] updated by Abdul Rasheed on 23/02/2019 at 04:15 PM");
INSERT INTO crm_audit_log VALUES("3768","2","15","2019-02-23 16:16:59","Entry Invoice [Invoice No: 20438] updated by Abdul Rasheed on 23/02/2019 at 04:16 PM");
INSERT INTO crm_audit_log VALUES("3769","2","15","2019-02-23 16:18:05","Entry Invoice [Invoice No: 20439] updated by Abdul Rasheed on 23/02/2019 at 04:18 PM");
INSERT INTO crm_audit_log VALUES("3770","2","15","2019-02-23 16:19:44","Entry Invoice [Invoice No: 20440] updated by Abdul Rasheed on 23/02/2019 at 04:19 PM");
INSERT INTO crm_audit_log VALUES("3771","2","15","2019-02-23 16:20:54","Entry Invoice [Invoice No: 20441] updated by Abdul Rasheed on 23/02/2019 at 04:20 PM");
INSERT INTO crm_audit_log VALUES("3772","2","15","2019-02-23 16:21:58","Entry Invoice [Invoice No: 20442] updated by Abdul Rasheed on 23/02/2019 at 04:21 PM");
INSERT INTO crm_audit_log VALUES("3773","2","15","2019-02-23 16:23:04","Entry Invoice [Invoice No: 20443] updated by Abdul Rasheed on 23/02/2019 at 04:23 PM");
INSERT INTO crm_audit_log VALUES("3774","2","15","2019-02-23 16:24:06","Entry Invoice [Invoice No: 20444] updated by Abdul Rasheed on 23/02/2019 at 04:24 PM");
INSERT INTO crm_audit_log VALUES("3775","2","15","2019-02-23 16:25:18","Entry Invoice [Invoice No: 20445] updated by Abdul Rasheed on 23/02/2019 at 04:25 PM");
INSERT INTO crm_audit_log VALUES("3776","2","15","2019-02-23 16:26:23","Entry Invoice [Invoice No: 20446] updated by Abdul Rasheed on 23/02/2019 at 04:26 PM");
INSERT INTO crm_audit_log VALUES("3777","2","15","2019-02-23 16:27:37","Entry Invoice [Invoice No: 20447] updated by Abdul Rasheed on 23/02/2019 at 04:27 PM");
INSERT INTO crm_audit_log VALUES("3778","2","15","2019-02-23 16:29:00","Entry Invoice [Invoice No: 20448] updated by Abdul Rasheed on 23/02/2019 at 04:29 PM");
INSERT INTO crm_audit_log VALUES("3779","2","15","2019-02-23 17:25:04","Entry Invoice [Invoice No: 20449] updated by Abdul Rasheed on 23/02/2019 at 05:25 PM");
INSERT INTO crm_audit_log VALUES("3780","3","4","2019-02-23 17:54:01","Exit Invoice [Invoice No: 118844] updated by Yasir  Rahman on 23/02/2019 at 05:54 PM");
INSERT INTO crm_audit_log VALUES("3781","3","4","2019-02-23 18:29:31","Exit Invoice [Invoice No: 118845] updated by Yasir  Rahman on 23/02/2019 at 06:29 PM");
INSERT INTO crm_audit_log VALUES("3782","2","7","2019-02-23 19:33:09","Entry Invoice [Invoice No: 20450] updated by ALSED ABU SHAMA on 23/02/2019 at 07:33 PM");
INSERT INTO crm_audit_log VALUES("3783","2","7","2019-02-23 20:12:54","Entry Invoice [Invoice No: 20451] updated by ALSED ABU SHAMA on 23/02/2019 at 08:12 PM");
INSERT INTO crm_audit_log VALUES("3784","2","7","2019-02-23 20:19:39","Entry Invoice [Invoice No: 20452] updated by ALSED ABU SHAMA on 23/02/2019 at 08:19 PM");
INSERT INTO crm_audit_log VALUES("3785","3","5","2019-02-23 20:20:23","Exit Invoice [Invoice No: 118846] updated by Imran  Khan on 23/02/2019 at 08:20 PM");
INSERT INTO crm_audit_log VALUES("3786","3","5","2019-02-23 20:21:07","Exit Invoice [Invoice No: 118847] updated by Imran  Khan on 23/02/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("3787","3","5","2019-02-23 21:26:50","Exit Invoice [Invoice No: 118848] updated by Imran  Khan on 23/02/2019 at 09:26 PM");
INSERT INTO crm_audit_log VALUES("3788","3","5","2019-02-23 21:27:37","Exit Invoice [Invoice No: 118849] updated by Imran  Khan on 23/02/2019 at 09:27 PM");
INSERT INTO crm_audit_log VALUES("3789","3","5","2019-02-23 21:51:41","Exit Invoice [Invoice No: 118850] updated by Imran  Khan on 23/02/2019 at 09:51 PM");
INSERT INTO crm_audit_log VALUES("3790","2","4","2019-02-23 22:21:13","Entry Invoice [Invoice No: 20453] updated by Yasir  Rahman on 23/02/2019 at 10:21 PM");
INSERT INTO crm_audit_log VALUES("3791","2","4","2019-02-23 23:05:18","Entry Invoice [Invoice No: 20454] updated by Yasir  Rahman on 23/02/2019 at 11:05 PM");
INSERT INTO crm_audit_log VALUES("3792","2","4","2019-02-23 23:06:54","Entry Invoice [Invoice No: 20455] updated by Yasir  Rahman on 23/02/2019 at 11:06 PM");
INSERT INTO crm_audit_log VALUES("3793","2","4","2019-02-23 23:08:11","Entry Invoice [Invoice No: 20456] updated by Yasir  Rahman on 23/02/2019 at 11:08 PM");
INSERT INTO crm_audit_log VALUES("3794","2","4","2019-02-23 23:10:10","Entry Invoice [Invoice No: 20457] updated by Yasir  Rahman on 23/02/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("3795","2","4","2019-02-23 23:16:23","Entry Invoice [Invoice No: 20458] updated by Yasir  Rahman on 23/02/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("3796","2","4","2019-02-23 23:18:28","Entry Invoice [Invoice No: 20459] updated by Yasir  Rahman on 23/02/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("3797","2","4","2019-02-23 23:24:21","Entry Invoice [Invoice No: 20460] updated by Yasir  Rahman on 23/02/2019 at 11:24 PM");
INSERT INTO crm_audit_log VALUES("3798","2","4","2019-02-23 23:26:05","Entry Invoice [Invoice No: 20461] updated by Yasir  Rahman on 23/02/2019 at 11:26 PM");
INSERT INTO crm_audit_log VALUES("3799","2","4","2019-02-23 23:27:47","Entry Invoice [Invoice No: 20462] updated by Yasir  Rahman on 23/02/2019 at 11:27 PM");
INSERT INTO crm_audit_log VALUES("3800","2","4","2019-02-24 00:22:11","Entry Invoice [Invoice No: 20463] updated by Yasir  Rahman on 24/02/2019 at 12:22 AM");
INSERT INTO crm_audit_log VALUES("3801","2","4","2019-02-24 03:17:09","Entry Invoice [Invoice No: 20464] updated by Yasir  Rahman on 24/02/2019 at 03:17 AM");
INSERT INTO crm_audit_log VALUES("3802","2","4","2019-02-24 03:18:47","Entry Invoice [Invoice No: 20465] updated by Yasir  Rahman on 24/02/2019 at 03:18 AM");
INSERT INTO crm_audit_log VALUES("3803","2","4","2019-02-24 03:20:09","Entry Invoice [Invoice No: 20466] updated by Yasir  Rahman on 24/02/2019 at 03:20 AM");
INSERT INTO crm_audit_log VALUES("3804","3","5","2019-02-24 06:29:26","Exit Invoice [Invoice No: 118851] updated by Imran  Khan on 24/02/2019 at 06:29 AM");
INSERT INTO crm_audit_log VALUES("3805","3","4","2019-02-24 10:16:23","Exit Invoice [Invoice No: 118852] updated by Yasir  Rahman on 24/02/2019 at 10:16 AM");
INSERT INTO crm_audit_log VALUES("3806","3","4","2019-02-24 10:20:52","Exit Invoice [Invoice No: 118853] updated by Yasir  Rahman on 24/02/2019 at 10:20 AM");
INSERT INTO crm_audit_log VALUES("3807","3","4","2019-02-24 11:30:17","Exit Invoice [Invoice No: 118854] updated by Yasir  Rahman on 24/02/2019 at 11:30 AM");
INSERT INTO crm_audit_log VALUES("3808","3","4","2019-02-24 11:32:04","Exit Invoice [Invoice No: 118855] updated by Yasir  Rahman on 24/02/2019 at 11:32 AM");
INSERT INTO crm_audit_log VALUES("3809","2","7","2019-02-24 11:37:35","Entry Invoice [Invoice No: 20467] updated by ALSED ABU SHAMA on 24/02/2019 at 11:37 AM");
INSERT INTO crm_audit_log VALUES("3810","2","15","2019-02-24 13:18:57","Entry Invoice [Invoice No: 20468] updated by Abdul Rasheed on 24/02/2019 at 01:18 PM");
INSERT INTO crm_audit_log VALUES("3811","2","15","2019-02-24 13:20:53","Entry Invoice [Invoice No: 20469] updated by Abdul Rasheed on 24/02/2019 at 01:20 PM");
INSERT INTO crm_audit_log VALUES("3812","2","15","2019-02-24 13:22:27","Entry Invoice [Invoice No: 20470] updated by Abdul Rasheed on 24/02/2019 at 01:22 PM");
INSERT INTO crm_audit_log VALUES("3813","2","15","2019-02-24 13:23:57","Entry Invoice [Invoice No: 20471] updated by Abdul Rasheed on 24/02/2019 at 01:23 PM");
INSERT INTO crm_audit_log VALUES("3814","3","4","2019-02-24 13:30:39","Exit Invoice [Invoice No: 118856] updated by Yasir  Rahman on 24/02/2019 at 01:30 PM");
INSERT INTO crm_audit_log VALUES("3815","3","4","2019-02-24 14:12:31","Exit Invoice [Invoice No: 118857] updated by Yasir  Rahman on 24/02/2019 at 02:12 PM");
INSERT INTO crm_audit_log VALUES("3816","3","4","2019-02-24 14:35:21","Exit Invoice [Invoice No: 118858] updated by Yasir  Rahman on 24/02/2019 at 02:35 PM");
INSERT INTO crm_audit_log VALUES("3817","2","7","2019-02-24 14:51:22","Entry Invoice [Invoice No: 20472] updated by ALSED ABU SHAMA on 24/02/2019 at 02:51 PM");
INSERT INTO crm_audit_log VALUES("3818","2","6","2019-02-24 15:15:14","Entry Invoice [Invoice No: 20456] updated by ASHRAF  M K on 24/02/2019 at 03:15 PM");
INSERT INTO crm_audit_log VALUES("3819","2","6","2019-02-24 15:21:13","Entry Invoice [Invoice No: 20457] updated by ASHRAF  M K on 24/02/2019 at 03:21 PM");
INSERT INTO crm_audit_log VALUES("3820","2","6","2019-02-24 15:22:54","Entry Invoice [Invoice No: 20455] updated by ASHRAF  M K on 24/02/2019 at 03:22 PM");
INSERT INTO crm_audit_log VALUES("3821","2","6","2019-02-24 15:53:35","Entry Invoice [Invoice No: 20473] updated by ASHRAF  M K on 24/02/2019 at 03:53 PM");
INSERT INTO crm_audit_log VALUES("3822","2","6","2019-02-24 15:55:10","Entry Invoice [Invoice No: 20474] updated by ASHRAF  M K on 24/02/2019 at 03:55 PM");
INSERT INTO crm_audit_log VALUES("3823","2","6","2019-02-24 16:08:23","Entry Invoice [Invoice No: 20458] updated by ASHRAF  M K on 24/02/2019 at 04:08 PM");
INSERT INTO crm_audit_log VALUES("3824","2","7","2019-02-24 17:03:10","Entry Invoice [Invoice No: 20475] updated by ALSED ABU SHAMA on 24/02/2019 at 05:03 PM");
INSERT INTO crm_audit_log VALUES("3825","2","6","2019-02-24 17:07:16","Entry Invoice [Invoice No: 20466] updated by ASHRAF  M K on 24/02/2019 at 05:07 PM");
INSERT INTO crm_audit_log VALUES("3826","3","4","2019-02-24 17:57:40","Exit Invoice [Invoice No: 118859] updated by Yasir  Rahman on 24/02/2019 at 05:57 PM");
INSERT INTO crm_audit_log VALUES("3827","2","15","2019-02-24 19:18:06","Entry Invoice [Invoice No: 20476] updated by Abdul Rasheed on 24/02/2019 at 07:18 PM");
INSERT INTO crm_audit_log VALUES("3828","2","15","2019-02-24 19:19:08","Entry Invoice [Invoice No: 20477] updated by Abdul Rasheed on 24/02/2019 at 07:19 PM");
INSERT INTO crm_audit_log VALUES("3829","3","5","2019-02-24 20:32:06","Exit Invoice [Invoice No: 118860] updated by Imran  Khan on 24/02/2019 at 08:32 PM");
INSERT INTO crm_audit_log VALUES("3830","3","5","2019-02-24 21:55:43","Exit Invoice [Invoice No: 118861] updated by Imran  Khan on 24/02/2019 at 09:55 PM");
INSERT INTO crm_audit_log VALUES("3831","2","4","2019-02-24 23:05:12","Entry Invoice [Invoice No: 20478] updated by Yasir  Rahman on 24/02/2019 at 11:05 PM");
INSERT INTO crm_audit_log VALUES("3832","3","5","2019-02-24 23:56:01","Exit Invoice [Invoice No: 118862] updated by Imran  Khan on 24/02/2019 at 11:56 PM");
INSERT INTO crm_audit_log VALUES("3833","3","5","2019-02-25 01:28:57","Exit Invoice [Invoice No: 118863] updated by Imran  Khan on 25/02/2019 at 01:28 AM");
INSERT INTO crm_audit_log VALUES("3834","3","5","2019-02-25 01:29:44","Exit Invoice [Invoice No: 118864] updated by Imran  Khan on 25/02/2019 at 01:29 AM");
INSERT INTO crm_audit_log VALUES("3835","3","5","2019-02-25 04:15:44","Exit Invoice [Invoice No: 118865] updated by Imran  Khan on 25/02/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("3836","3","5","2019-02-25 04:16:58","Exit Invoice [Invoice No: 118866] updated by Imran  Khan on 25/02/2019 at 04:16 AM");
INSERT INTO crm_audit_log VALUES("3837","3","5","2019-02-25 05:05:53","Exit Invoice [Invoice No: 118867] updated by Imran  Khan on 25/02/2019 at 05:05 AM");
INSERT INTO crm_audit_log VALUES("3838","3","5","2019-02-25 05:06:50","Exit Invoice [Invoice No: 118868] updated by Imran  Khan on 25/02/2019 at 05:06 AM");
INSERT INTO crm_audit_log VALUES("3839","1","4","2019-02-25 05:59:17","Customer [Customer No: 427] updated by Yasir  Rahman on 25/02/2019 at 05:59 AM");
INSERT INTO crm_audit_log VALUES("3840","2","4","2019-02-25 06:00:26","Entry Invoice [Invoice No: 20479] updated by Yasir  Rahman on 25/02/2019 at 06:00 AM");
INSERT INTO crm_audit_log VALUES("3841","3","4","2019-02-25 09:06:03","Exit Invoice [Invoice No: 118869] updated by Yasir  Rahman on 25/02/2019 at 09:06 AM");
INSERT INTO crm_audit_log VALUES("3842","3","4","2019-02-25 09:33:45","Exit Invoice [Invoice No: 118870] updated by Yasir  Rahman on 25/02/2019 at 09:33 AM");
INSERT INTO crm_audit_log VALUES("3843","3","4","2019-02-25 10:39:54","Exit Invoice [Invoice No: 118871] updated by Yasir  Rahman on 25/02/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("3844","2","7","2019-02-25 10:49:55","Entry Invoice [Invoice No: 20480] updated by ALSED ABU SHAMA on 25/02/2019 at 10:49 AM");
INSERT INTO crm_audit_log VALUES("3845","2","15","2019-02-25 11:12:02","Entry Invoice [Invoice No: 20481] updated by Abdul Rasheed on 25/02/2019 at 11:12 AM");
INSERT INTO crm_audit_log VALUES("3846","2","15","2019-02-25 11:13:03","Entry Invoice [Invoice No: 20482] updated by Abdul Rasheed on 25/02/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("3847","3","4","2019-02-25 12:06:01","Exit Invoice [Invoice No: 118872] updated by Yasir  Rahman on 25/02/2019 at 12:06 PM");
INSERT INTO crm_audit_log VALUES("3848","3","6","2019-02-25 14:44:11","Exit Invoice [Invoice No: 118873] updated by ASHRAF  M K on 25/02/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("3849","3","4","2019-02-25 14:47:58","Exit Invoice [Invoice No: 118874] updated by Yasir  Rahman on 25/02/2019 at 02:47 PM");
INSERT INTO crm_audit_log VALUES("3850","3","4","2019-02-25 14:49:15","Exit Invoice [Invoice No: 118875] updated by Yasir  Rahman on 25/02/2019 at 02:49 PM");
INSERT INTO crm_audit_log VALUES("3851","3","4","2019-02-25 15:08:51","Exit Invoice [Invoice No: 118876] updated by Yasir  Rahman on 25/02/2019 at 03:08 PM");
INSERT INTO crm_audit_log VALUES("3852","3","4","2019-02-25 16:59:46","Exit Invoice [Invoice No: 118877] updated by Yasir  Rahman on 25/02/2019 at 04:59 PM");
INSERT INTO crm_audit_log VALUES("3853","2","7","2019-02-25 17:33:00","Entry Invoice [Invoice No: 20483] updated by ALSED ABU SHAMA on 25/02/2019 at 05:33 PM");
INSERT INTO crm_audit_log VALUES("3854","2","7","2019-02-25 17:34:32","Entry Invoice [Invoice No: 20484] updated by ALSED ABU SHAMA on 25/02/2019 at 05:34 PM");
INSERT INTO crm_audit_log VALUES("3855","3","5","2019-02-25 20:39:15","Exit Invoice [Invoice No: 118878] updated by Imran  Khan on 25/02/2019 at 08:39 PM");
INSERT INTO crm_audit_log VALUES("3856","3","5","2019-02-25 22:08:34","Exit Invoice [Invoice No: 118879] updated by Imran  Khan on 25/02/2019 at 10:08 PM");
INSERT INTO crm_audit_log VALUES("3857","3","5","2019-02-25 22:10:28","Exit Invoice [Invoice No: 118880] updated by Imran  Khan on 25/02/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("3858","3","5","2019-02-25 22:59:25","Exit Invoice [Invoice No: 118881] updated by Imran  Khan on 25/02/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("3859","2","4","2019-02-25 23:23:06","Entry Invoice [Invoice No: 20485] updated by Yasir  Rahman on 25/02/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("3860","2","4","2019-02-25 23:27:08","Entry Invoice [Invoice No: 20486] updated by Yasir  Rahman on 25/02/2019 at 11:27 PM");
INSERT INTO crm_audit_log VALUES("3861","3","5","2019-02-26 02:04:15","Exit Invoice [Invoice No: 118882] updated by Imran  Khan on 26/02/2019 at 02:04 AM");
INSERT INTO crm_audit_log VALUES("3862","3","5","2019-02-26 02:07:15","Exit Invoice [Invoice No: 118883] updated by Imran  Khan on 26/02/2019 at 02:07 AM");
INSERT INTO crm_audit_log VALUES("3863","3","5","2019-02-26 02:08:07","Exit Invoice [Invoice No: 118884] updated by Imran  Khan on 26/02/2019 at 02:08 AM");
INSERT INTO crm_audit_log VALUES("3864","3","5","2019-02-26 02:08:57","Exit Invoice [Invoice No: 118885] updated by Imran  Khan on 26/02/2019 at 02:08 AM");
INSERT INTO crm_audit_log VALUES("3865","3","5","2019-02-26 04:33:32","Exit Invoice [Invoice No: 118886] updated by Imran  Khan on 26/02/2019 at 04:33 AM");
INSERT INTO crm_audit_log VALUES("3866","2","4","2019-02-26 05:44:11","Entry Invoice [Invoice No: 20487] updated by Yasir  Rahman on 26/02/2019 at 05:44 AM");
INSERT INTO crm_audit_log VALUES("3867","2","4","2019-02-26 06:03:53","Entry Invoice [Invoice No: 20488] updated by Yasir  Rahman on 26/02/2019 at 06:03 AM");
INSERT INTO crm_audit_log VALUES("3868","3","5","2019-02-26 06:13:09","Exit Invoice [Invoice No: 118887] updated by Imran  Khan on 26/02/2019 at 06:13 AM");
INSERT INTO crm_audit_log VALUES("3869","2","4","2019-02-26 06:57:51","Entry Invoice [Invoice No: 20489] updated by Yasir  Rahman on 26/02/2019 at 06:57 AM");
INSERT INTO crm_audit_log VALUES("3870","2","4","2019-02-26 07:01:38","Entry Invoice [Invoice No: 20490] updated by Yasir  Rahman on 26/02/2019 at 07:01 AM");
INSERT INTO crm_audit_log VALUES("3871","2","4","2019-02-26 07:14:37","Entry Invoice [Invoice No: 20491] updated by Yasir  Rahman on 26/02/2019 at 07:14 AM");
INSERT INTO crm_audit_log VALUES("3872","2","4","2019-02-26 07:15:42","Entry Invoice [Invoice No: 20492] updated by Yasir  Rahman on 26/02/2019 at 07:15 AM");
INSERT INTO crm_audit_log VALUES("3873","3","4","2019-02-26 10:38:45","Exit Invoice [Invoice No: 118888] updated by Yasir  Rahman on 26/02/2019 at 10:38 AM");
INSERT INTO crm_audit_log VALUES("3874","3","4","2019-02-26 11:11:12","Exit Invoice [Invoice No: 118889] updated by Yasir  Rahman on 26/02/2019 at 11:11 AM");
INSERT INTO crm_audit_log VALUES("3875","3","4","2019-02-26 12:45:34","Exit Invoice [Invoice No: 118890] updated by Yasir  Rahman on 26/02/2019 at 12:45 PM");
INSERT INTO crm_audit_log VALUES("3876","3","4","2019-02-26 12:46:38","Exit Invoice [Invoice No: 118891] updated by Yasir  Rahman on 26/02/2019 at 12:46 PM");
INSERT INTO crm_audit_log VALUES("3877","3","4","2019-02-26 12:48:49","Exit Invoice [Invoice No: 118892] updated by Yasir  Rahman on 26/02/2019 at 12:48 PM");
INSERT INTO crm_audit_log VALUES("3878","3","4","2019-02-26 14:17:08","Exit Invoice [Invoice No: 118893] updated by Yasir  Rahman on 26/02/2019 at 02:17 PM");
INSERT INTO crm_audit_log VALUES("3879","3","4","2019-02-26 15:50:34","Exit Invoice [Invoice No: 118894] updated by Yasir  Rahman on 26/02/2019 at 03:50 PM");
INSERT INTO crm_audit_log VALUES("3880","3","4","2019-02-26 15:52:14","Exit Invoice [Invoice No: 118895] updated by Yasir  Rahman on 26/02/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("3881","2","7","2019-02-26 16:13:40","Entry Invoice [Invoice No: 20493] updated by ALSED ABU SHAMA on 26/02/2019 at 04:13 PM");
INSERT INTO crm_audit_log VALUES("3882","3","4","2019-02-26 18:09:56","Exit Invoice [Invoice No: 118896] updated by Yasir  Rahman on 26/02/2019 at 06:09 PM");
INSERT INTO crm_audit_log VALUES("3883","2","6","2019-02-26 18:32:07","Entry Invoice [Invoice No: 20488] updated by ASHRAF  M K on 26/02/2019 at 06:32 PM");
INSERT INTO crm_audit_log VALUES("3884","2","6","2019-02-26 18:32:42","Entry Invoice [Invoice No: 20487] updated by ASHRAF  M K on 26/02/2019 at 06:32 PM");
INSERT INTO crm_audit_log VALUES("3885","2","6","2019-02-26 18:33:13","Entry Invoice [Invoice No: 20490] updated by ASHRAF  M K on 26/02/2019 at 06:33 PM");
INSERT INTO crm_audit_log VALUES("3886","2","7","2019-02-26 19:04:21","Entry Invoice [Invoice No: 20494] updated by ALSED ABU SHAMA on 26/02/2019 at 07:04 PM");
INSERT INTO crm_audit_log VALUES("3887","2","7","2019-02-26 19:08:58","Entry Invoice [Invoice No: 20495] updated by ALSED ABU SHAMA on 26/02/2019 at 07:08 PM");
INSERT INTO crm_audit_log VALUES("3888","2","7","2019-02-26 19:18:01","Entry Invoice [Invoice No: 20496] updated by ALSED ABU SHAMA on 26/02/2019 at 07:18 PM");
INSERT INTO crm_audit_log VALUES("3889","2","4","2019-02-26 20:26:32","Entry Invoice [Invoice No: 20497] updated by Yasir  Rahman on 26/02/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("3890","3","5","2019-02-26 23:03:25","Exit Invoice [Invoice No: 118897] updated by Imran  Khan on 26/02/2019 at 11:03 PM");
INSERT INTO crm_audit_log VALUES("3891","2","4","2019-02-26 23:10:37","Entry Invoice [Invoice No: 20498] updated by Yasir  Rahman on 26/02/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("3892","2","4","2019-02-26 23:14:57","Entry Invoice [Invoice No: 20499] updated by Yasir  Rahman on 26/02/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("3893","2","4","2019-02-26 23:26:23","Entry Invoice [Invoice No: 20500] updated by Yasir  Rahman on 26/02/2019 at 11:26 PM");
INSERT INTO crm_audit_log VALUES("3894","3","5","2019-02-26 23:37:42","Exit Invoice [Invoice No: 118898] updated by Imran  Khan on 26/02/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("3895","2","4","2019-02-26 23:39:24","Entry Invoice [Invoice No: 20501] updated by Yasir  Rahman on 26/02/2019 at 11:39 PM");
INSERT INTO crm_audit_log VALUES("3896","2","4","2019-02-26 23:41:31","Entry Invoice [Invoice No: 20502] updated by Yasir  Rahman on 26/02/2019 at 11:41 PM");
INSERT INTO crm_audit_log VALUES("3897","2","4","2019-02-26 23:45:39","Entry Invoice [Invoice No: 20503] updated by Yasir  Rahman on 26/02/2019 at 11:45 PM");
INSERT INTO crm_audit_log VALUES("3898","3","5","2019-02-26 23:53:49","Exit Invoice [Invoice No: 118899] updated by Imran  Khan on 26/02/2019 at 11:53 PM");
INSERT INTO crm_audit_log VALUES("3899","3","5","2019-02-26 23:54:49","Exit Invoice [Invoice No: 118900] updated by Imran  Khan on 26/02/2019 at 11:54 PM");
INSERT INTO crm_audit_log VALUES("3900","2","4","2019-02-27 00:49:34","Entry Invoice [Invoice No: 20504] updated by Yasir  Rahman on 27/02/2019 at 12:49 AM");
INSERT INTO crm_audit_log VALUES("3901","3","5","2019-02-27 03:02:41","Exit Invoice [Invoice No: 118901] updated by Imran  Khan on 27/02/2019 at 03:02 AM");
INSERT INTO crm_audit_log VALUES("3902","3","5","2019-02-27 04:43:36","Exit Invoice [Invoice No: 118902] updated by Imran  Khan on 27/02/2019 at 04:43 AM");
INSERT INTO crm_audit_log VALUES("3903","2","4","2019-02-27 07:22:38","Entry Invoice [Invoice No: 20505] updated by Yasir  Rahman on 27/02/2019 at 07:22 AM");
INSERT INTO crm_audit_log VALUES("3904","2","4","2019-02-27 07:24:03","Entry Invoice [Invoice No: 20506] updated by Yasir  Rahman on 27/02/2019 at 07:24 AM");
INSERT INTO crm_audit_log VALUES("3905","2","4","2019-02-27 07:26:26","Entry Invoice [Invoice No: 20507] updated by Yasir  Rahman on 27/02/2019 at 07:26 AM");
INSERT INTO crm_audit_log VALUES("3906","3","5","2019-02-27 07:26:42","Exit Invoice [Invoice No: 118903] updated by Imran  Khan on 27/02/2019 at 07:26 AM");
INSERT INTO crm_audit_log VALUES("3907","3","6","2019-02-27 08:33:36","Exit Invoice [Invoice No: 118883] updated by ASHRAF  M K on 27/02/2019 at 08:33 AM");
INSERT INTO crm_audit_log VALUES("3908","3","15","2019-02-27 09:29:28","Exit Invoice [Invoice No: 118904] updated by Abdul Rasheed on 27/02/2019 at 09:29 AM");
INSERT INTO crm_audit_log VALUES("3909","2","7","2019-02-27 12:56:16","Entry Invoice [Invoice No: 20508] updated by ALSED ABU SHAMA on 27/02/2019 at 12:56 PM");
INSERT INTO crm_audit_log VALUES("3910","2","7","2019-02-27 13:00:31","Entry Invoice [Invoice No: 20509] updated by ALSED ABU SHAMA on 27/02/2019 at 01:00 PM");
INSERT INTO crm_audit_log VALUES("3911","2","7","2019-02-27 13:02:29","Entry Invoice [Invoice No: 20510] updated by ALSED ABU SHAMA on 27/02/2019 at 01:02 PM");
INSERT INTO crm_audit_log VALUES("3912","2","7","2019-02-27 13:10:14","Entry Invoice [Invoice No: 20511] updated by ALSED ABU SHAMA on 27/02/2019 at 01:10 PM");
INSERT INTO crm_audit_log VALUES("3913","3","4","2019-02-27 13:21:39","Exit Invoice [Invoice No: 118905] updated by Yasir  Rahman on 27/02/2019 at 01:21 PM");
INSERT INTO crm_audit_log VALUES("3914","3","4","2019-02-27 13:22:52","Exit Invoice [Invoice No: 118906] updated by Yasir  Rahman on 27/02/2019 at 01:22 PM");
INSERT INTO crm_audit_log VALUES("3915","2","6","2019-02-27 14:36:01","Entry Invoice [Invoice No: 20504] updated by ASHRAF  M K on 27/02/2019 at 02:36 PM");
INSERT INTO crm_audit_log VALUES("3916","2","7","2019-02-27 14:46:21","Entry Invoice [Invoice No: 20512] updated by ALSED ABU SHAMA on 27/02/2019 at 02:46 PM");
INSERT INTO crm_audit_log VALUES("3917","3","4","2019-02-27 15:54:59","Exit Invoice [Invoice No: 118907] updated by Yasir  Rahman on 27/02/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("3918","3","4","2019-02-27 16:16:23","Exit Invoice [Invoice No: 118908] updated by Yasir  Rahman on 27/02/2019 at 04:16 PM");
INSERT INTO crm_audit_log VALUES("3919","3","4","2019-02-27 17:26:33","Exit Invoice [Invoice No: 118909] updated by Yasir  Rahman on 27/02/2019 at 05:26 PM");
INSERT INTO crm_audit_log VALUES("3920","2","7","2019-02-27 17:54:51","Entry Invoice [Invoice No: 20513] updated by ALSED ABU SHAMA on 27/02/2019 at 05:54 PM");
INSERT INTO crm_audit_log VALUES("3921","3","4","2019-02-27 18:02:39","Exit Invoice [Invoice No: 118910] updated by Yasir  Rahman on 27/02/2019 at 06:02 PM");
INSERT INTO crm_audit_log VALUES("3922","3","4","2019-02-27 18:03:35","Exit Invoice [Invoice No: 118911] updated by Yasir  Rahman on 27/02/2019 at 06:03 PM");
INSERT INTO crm_audit_log VALUES("3923","3","4","2019-02-27 18:04:28","Exit Invoice [Invoice No: 118912] updated by Yasir  Rahman on 27/02/2019 at 06:04 PM");
INSERT INTO crm_audit_log VALUES("3924","2","4","2019-02-27 21:02:42","Entry Invoice [Invoice No: 20514] updated by Yasir  Rahman on 27/02/2019 at 09:02 PM");
INSERT INTO crm_audit_log VALUES("3925","2","4","2019-02-27 21:04:01","Entry Invoice [Invoice No: 20515] updated by Yasir  Rahman on 27/02/2019 at 09:04 PM");
INSERT INTO crm_audit_log VALUES("3926","2","4","2019-02-27 23:10:07","Entry Invoice [Invoice No: 20516] updated by Yasir  Rahman on 27/02/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("3927","2","4","2019-02-27 23:15:58","Entry Invoice [Invoice No: 20517] updated by Yasir  Rahman on 27/02/2019 at 11:15 PM");
INSERT INTO crm_audit_log VALUES("3928","2","4","2019-02-27 23:20:27","Entry Invoice [Invoice No: 20518] updated by Yasir  Rahman on 27/02/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("3929","3","5","2019-02-28 00:36:23","Exit Invoice [Invoice No: 118913] updated by Imran  Khan on 28/02/2019 at 12:36 AM");
INSERT INTO crm_audit_log VALUES("3930","3","5","2019-02-28 00:37:09","Exit Invoice [Invoice No: 118914] updated by Imran  Khan on 28/02/2019 at 12:37 AM");
INSERT INTO crm_audit_log VALUES("3931","3","5","2019-02-28 01:57:37","Exit Invoice [Invoice No: 118915] updated by Imran  Khan on 28/02/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("3932","3","5","2019-02-28 01:58:49","Exit Invoice [Invoice No: 118916] updated by Imran  Khan on 28/02/2019 at 01:58 AM");
INSERT INTO crm_audit_log VALUES("3933","3","5","2019-02-28 02:03:33","Exit Invoice [Invoice No: 118917] updated by Imran  Khan on 28/02/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("3934","3","4","2019-02-28 09:41:02","Exit Invoice [Invoice No: 118918] updated by Yasir  Rahman on 28/02/2019 at 09:41 AM");
INSERT INTO crm_audit_log VALUES("3935","3","4","2019-02-28 11:17:59","Exit Invoice [Invoice No: 118919] updated by Yasir  Rahman on 28/02/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("3936","3","4","2019-02-28 11:20:35","Exit Invoice [Invoice No: 118920] updated by Yasir  Rahman on 28/02/2019 at 11:20 AM");
INSERT INTO crm_audit_log VALUES("3937","3","4","2019-02-28 11:23:45","Exit Invoice [Invoice No: 118921] updated by Yasir  Rahman on 28/02/2019 at 11:23 AM");
INSERT INTO crm_audit_log VALUES("3938","3","4","2019-02-28 11:25:03","Exit Invoice [Invoice No: 118922] updated by Yasir  Rahman on 28/02/2019 at 11:25 AM");
INSERT INTO crm_audit_log VALUES("3939","2","7","2019-02-28 11:59:13","Entry Invoice [Invoice No: 20519] updated by ALSED ABU SHAMA on 28/02/2019 at 11:59 AM");
INSERT INTO crm_audit_log VALUES("3940","3","4","2019-02-28 12:05:56","Exit Invoice [Invoice No: 118923] updated by Yasir  Rahman on 28/02/2019 at 12:05 PM");
INSERT INTO crm_audit_log VALUES("3941","3","4","2019-02-28 12:06:35","Exit Invoice [Invoice No: 118924] updated by Yasir  Rahman on 28/02/2019 at 12:06 PM");
INSERT INTO crm_audit_log VALUES("3942","2","15","2019-02-28 14:33:18","Entry Invoice [Invoice No: 20520] updated by Abdul Rasheed on 28/02/2019 at 02:33 PM");
INSERT INTO crm_audit_log VALUES("3943","2","15","2019-02-28 14:34:15","Entry Invoice [Invoice No: 20521] updated by Abdul Rasheed on 28/02/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("3944","2","15","2019-02-28 14:36:13","Entry Invoice [Invoice No: 20522] updated by Abdul Rasheed on 28/02/2019 at 02:36 PM");
INSERT INTO crm_audit_log VALUES("3945","2","15","2019-02-28 14:44:26","Entry Invoice [Invoice No: 20523] updated by Abdul Rasheed on 28/02/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("3946","2","15","2019-02-28 14:45:34","Entry Invoice [Invoice No: 20524] updated by Abdul Rasheed on 28/02/2019 at 02:45 PM");
INSERT INTO crm_audit_log VALUES("3947","3","4","2019-02-28 15:54:03","Exit Invoice [Invoice No: 118925] updated by Yasir  Rahman on 28/02/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("3948","2","7","2019-02-28 16:01:46","Entry Invoice [Invoice No: 20525] updated by ALSED ABU SHAMA on 28/02/2019 at 04:01 PM");
INSERT INTO crm_audit_log VALUES("3949","2","7","2019-02-28 16:38:19","Entry Invoice [Invoice No: 20526] updated by ALSED ABU SHAMA on 28/02/2019 at 04:38 PM");
INSERT INTO crm_audit_log VALUES("3950","2","7","2019-02-28 16:39:55","Entry Invoice [Invoice No: 20527] updated by ALSED ABU SHAMA on 28/02/2019 at 04:39 PM");
INSERT INTO crm_audit_log VALUES("3951","3","4","2019-02-28 17:59:34","Exit Invoice [Invoice No: 118926] updated by Yasir  Rahman on 28/02/2019 at 05:59 PM");
INSERT INTO crm_audit_log VALUES("3952","2","6","2019-02-28 19:10:03","Entry Invoice [Invoice No: 20528] updated by ASHRAF  M K on 28/02/2019 at 07:10 PM");
INSERT INTO crm_audit_log VALUES("3953","3","6","2019-02-28 19:13:40","Exit Invoice [Invoice No: 118920] updated by ASHRAF  M K on 28/02/2019 at 07:13 PM");
INSERT INTO crm_audit_log VALUES("3954","3","6","2019-02-28 19:14:27","Exit Invoice [Invoice No: 118920] updated by ASHRAF  M K on 28/02/2019 at 07:14 PM");
INSERT INTO crm_audit_log VALUES("3955","2","15","2019-02-28 19:30:03","Entry Invoice [Invoice No: 20529] updated by Abdul Rasheed on 28/02/2019 at 07:30 PM");
INSERT INTO crm_audit_log VALUES("3956","2","7","2019-02-28 20:20:42","Entry Invoice [Invoice No: 20530] updated by ALSED ABU SHAMA on 28/02/2019 at 08:20 PM");
INSERT INTO crm_audit_log VALUES("3957","3","5","2019-02-28 21:15:47","Exit Invoice [Invoice No: 118927] updated by Imran  Khan on 28/02/2019 at 09:15 PM");
INSERT INTO crm_audit_log VALUES("3958","3","5","2019-02-28 21:23:03","Exit Invoice [Invoice No: 118928] updated by Imran  Khan on 28/02/2019 at 09:23 PM");
INSERT INTO crm_audit_log VALUES("3959","3","5","2019-02-28 21:23:42","Exit Invoice [Invoice No: 118929] updated by Imran  Khan on 28/02/2019 at 09:23 PM");
INSERT INTO crm_audit_log VALUES("3960","3","5","2019-02-28 21:36:59","Exit Invoice [Invoice No: 118930] updated by Imran  Khan on 28/02/2019 at 09:36 PM");
INSERT INTO crm_audit_log VALUES("3961","3","5","2019-02-28 22:49:17","Exit Invoice [Invoice No: 118931] updated by Imran  Khan on 28/02/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("3962","2","4","2019-02-28 22:53:49","Entry Invoice [Invoice No: 20531] updated by Yasir  Rahman on 28/02/2019 at 10:53 PM");
INSERT INTO crm_audit_log VALUES("3963","2","4","2019-02-28 23:05:10","Entry Invoice [Invoice No: 20532] updated by Yasir  Rahman on 28/02/2019 at 11:05 PM");
INSERT INTO crm_audit_log VALUES("3964","2","4","2019-02-28 23:28:36","Entry Invoice [Invoice No: 20533] updated by Yasir  Rahman on 28/02/2019 at 11:28 PM");
INSERT INTO crm_audit_log VALUES("3965","2","4","2019-02-28 23:30:28","Entry Invoice [Invoice No: 20534] updated by Yasir  Rahman on 28/02/2019 at 11:30 PM");
INSERT INTO crm_audit_log VALUES("3966","3","5","2019-02-28 23:39:22","Exit Invoice [Invoice No: 118932] updated by Imran  Khan on 28/02/2019 at 11:39 PM");
INSERT INTO crm_audit_log VALUES("3967","3","5","2019-03-01 00:05:29","Exit Invoice [Invoice No: 118933] updated by Imran  Khan on 01/03/2019 at 12:05 AM");
INSERT INTO crm_audit_log VALUES("3968","3","5","2019-03-01 00:59:21","Exit Invoice [Invoice No: 118934] updated by Imran  Khan on 01/03/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("3969","3","5","2019-03-01 01:00:29","Exit Invoice [Invoice No: 118935] updated by Imran  Khan on 01/03/2019 at 01:00 AM");
INSERT INTO crm_audit_log VALUES("3970","2","4","2019-03-01 01:08:11","Entry Invoice [Invoice No: 20535] updated by Yasir  Rahman on 01/03/2019 at 01:08 AM");
INSERT INTO crm_audit_log VALUES("3971","2","4","2019-03-01 01:09:53","Entry Invoice [Invoice No: 20536] updated by Yasir  Rahman on 01/03/2019 at 01:09 AM");
INSERT INTO crm_audit_log VALUES("3972","3","5","2019-03-01 02:12:39","Exit Invoice [Invoice No: 118936] updated by Imran  Khan on 01/03/2019 at 02:12 AM");
INSERT INTO crm_audit_log VALUES("3973","3","5","2019-03-01 03:32:39","Exit Invoice [Invoice No: 118937] updated by Imran  Khan on 01/03/2019 at 03:32 AM");
INSERT INTO crm_audit_log VALUES("3974","2","4","2019-03-01 06:11:01","Entry Invoice [Invoice No: 20537] updated by Yasir  Rahman on 01/03/2019 at 06:11 AM");
INSERT INTO crm_audit_log VALUES("3975","2","4","2019-03-01 06:12:41","Entry Invoice [Invoice No: 20538] updated by Yasir  Rahman on 01/03/2019 at 06:12 AM");
INSERT INTO crm_audit_log VALUES("3976","2","4","2019-03-01 06:14:48","Entry Invoice [Invoice No: 20539] updated by Yasir  Rahman on 01/03/2019 at 06:14 AM");
INSERT INTO crm_audit_log VALUES("3977","3","5","2019-03-01 07:15:06","Exit Invoice [Invoice No: 118938] updated by Imran  Khan on 01/03/2019 at 07:15 AM");
INSERT INTO crm_audit_log VALUES("3978","3","6","2019-03-01 09:09:17","Exit Invoice [Invoice No: 118933] updated by ASHRAF  M K on 01/03/2019 at 09:09 AM");
INSERT INTO crm_audit_log VALUES("3979","3","6","2019-03-01 09:09:40","Exit Invoice [Invoice No: 118933] updated by ASHRAF  M K on 01/03/2019 at 09:09 AM");
INSERT INTO crm_audit_log VALUES("3980","3","4","2019-03-01 10:12:21","Exit Invoice [Invoice No: 118939] updated by Yasir  Rahman on 01/03/2019 at 10:12 AM");
INSERT INTO crm_audit_log VALUES("3981","3","4","2019-03-01 10:13:23","Exit Invoice [Invoice No: 118940] updated by Yasir  Rahman on 01/03/2019 at 10:13 AM");
INSERT INTO crm_audit_log VALUES("3982","3","4","2019-03-01 10:23:05","Exit Invoice [Invoice No: 118941] updated by Yasir  Rahman on 01/03/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("3983","3","4","2019-03-01 13:58:38","Exit Invoice [Invoice No: 118942] updated by Yasir  Rahman on 01/03/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("3984","3","4","2019-03-01 14:18:15","Exit Invoice [Invoice No: 118943] updated by Yasir  Rahman on 01/03/2019 at 02:18 PM");
INSERT INTO crm_audit_log VALUES("3985","3","4","2019-03-01 14:34:13","Exit Invoice [Invoice No: 118944] updated by Yasir  Rahman on 01/03/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("3986","3","4","2019-03-01 15:30:31","Exit Invoice [Invoice No: 118945] updated by Yasir  Rahman on 01/03/2019 at 03:30 PM");
INSERT INTO crm_audit_log VALUES("3987","2","7","2019-03-01 16:11:59","Entry Invoice [Invoice No: 20540] updated by ALSED ABU SHAMA on 01/03/2019 at 04:11 PM");
INSERT INTO crm_audit_log VALUES("3988","2","7","2019-03-01 16:35:00","Entry Invoice [Invoice No: 20541] updated by ALSED ABU SHAMA on 01/03/2019 at 04:35 PM");
INSERT INTO crm_audit_log VALUES("3989","3","4","2019-03-01 17:45:03","Exit Invoice [Invoice No: 118946] updated by Yasir  Rahman on 01/03/2019 at 05:45 PM");
INSERT INTO crm_audit_log VALUES("3990","3","5","2019-03-01 20:15:40","Exit Invoice [Invoice No: 118947] updated by Imran  Khan on 01/03/2019 at 08:15 PM");
INSERT INTO crm_audit_log VALUES("3991","3","5","2019-03-01 20:16:33","Exit Invoice [Invoice No: 118948] updated by Imran  Khan on 01/03/2019 at 08:16 PM");
INSERT INTO crm_audit_log VALUES("3992","3","5","2019-03-01 20:33:42","Exit Invoice [Invoice No: 118949] updated by Imran  Khan on 01/03/2019 at 08:33 PM");
INSERT INTO crm_audit_log VALUES("3993","3","5","2019-03-01 20:34:28","Exit Invoice [Invoice No: 118950] updated by Imran  Khan on 01/03/2019 at 08:34 PM");
INSERT INTO crm_audit_log VALUES("3994","3","5","2019-03-01 20:55:49","Exit Invoice [Invoice No: 118951] updated by Imran  Khan on 01/03/2019 at 08:55 PM");
INSERT INTO crm_audit_log VALUES("3995","2","4","2019-03-01 21:36:11","Entry Invoice [Invoice No: 20542] updated by Yasir  Rahman on 01/03/2019 at 09:36 PM");
INSERT INTO crm_audit_log VALUES("3996","3","5","2019-03-01 22:32:23","Exit Invoice [Invoice No: 118952] updated by Imran  Khan on 01/03/2019 at 10:32 PM");
INSERT INTO crm_audit_log VALUES("3997","2","4","2019-03-01 22:44:53","Entry Invoice [Invoice No: 20543] updated by Yasir  Rahman on 01/03/2019 at 10:44 PM");
INSERT INTO crm_audit_log VALUES("3998","2","4","2019-03-01 23:32:06","Entry Invoice [Invoice No: 20544] updated by Yasir  Rahman on 01/03/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("3999","2","4","2019-03-01 23:33:38","Entry Invoice [Invoice No: 20545] updated by Yasir  Rahman on 01/03/2019 at 11:33 PM");
INSERT INTO crm_audit_log VALUES("4000","2","4","2019-03-01 23:35:13","Entry Invoice [Invoice No: 20546] updated by Yasir  Rahman on 01/03/2019 at 11:35 PM");
INSERT INTO crm_audit_log VALUES("4001","3","5","2019-03-01 23:59:19","Exit Invoice [Invoice No: 118953] updated by Imran  Khan on 01/03/2019 at 11:59 PM");
INSERT INTO crm_audit_log VALUES("4002","3","5","2019-03-02 00:00:24","Exit Invoice [Invoice No: 118954] updated by Imran  Khan on 02/03/2019 at 12:00 AM");
INSERT INTO crm_audit_log VALUES("4003","3","5","2019-03-02 00:01:22","Exit Invoice [Invoice No: 118955] updated by Imran  Khan on 02/03/2019 at 12:01 AM");
INSERT INTO crm_audit_log VALUES("4004","3","5","2019-03-02 01:59:02","Exit Invoice [Invoice No: 118956] updated by Imran  Khan on 02/03/2019 at 01:59 AM");
INSERT INTO crm_audit_log VALUES("4005","3","5","2019-03-02 04:44:58","Exit Invoice [Invoice No: 118957] updated by Imran  Khan on 02/03/2019 at 04:44 AM");
INSERT INTO crm_audit_log VALUES("4006","3","5","2019-03-02 07:06:09","Exit Invoice [Invoice No: 118958] updated by Imran  Khan on 02/03/2019 at 07:06 AM");
INSERT INTO crm_audit_log VALUES("4007","2","4","2019-03-02 07:37:06","Entry Invoice [Invoice No: 20547] updated by Yasir  Rahman on 02/03/2019 at 07:37 AM");
INSERT INTO crm_audit_log VALUES("4008","2","15","2019-03-02 09:53:38","Entry Invoice [Invoice No: 20548] updated by Abdul Rasheed on 02/03/2019 at 09:53 AM");
INSERT INTO crm_audit_log VALUES("4009","2","15","2019-03-02 10:30:01","Entry Invoice [Invoice No: 20549] updated by Abdul Rasheed on 02/03/2019 at 10:30 AM");
INSERT INTO crm_audit_log VALUES("4010","2","15","2019-03-02 10:36:02","Entry Invoice [Invoice No: 20550] updated by Abdul Rasheed on 02/03/2019 at 10:36 AM");
INSERT INTO crm_audit_log VALUES("4011","3","4","2019-03-02 11:30:59","Exit Invoice [Invoice No: 118959] updated by Yasir  Rahman on 02/03/2019 at 11:30 AM");
INSERT INTO crm_audit_log VALUES("4012","2","7","2019-03-02 17:05:32","Entry Invoice [Invoice No: 20551] updated by ALSED ABU SHAMA on 02/03/2019 at 05:05 PM");
INSERT INTO crm_audit_log VALUES("4013","3","4","2019-03-02 17:16:51","Exit Invoice [Invoice No: 118960] updated by Yasir  Rahman on 02/03/2019 at 05:16 PM");
INSERT INTO crm_audit_log VALUES("4014","3","4","2019-03-02 18:41:21","Exit Invoice [Invoice No: 118961] updated by Yasir  Rahman on 02/03/2019 at 06:41 PM");
INSERT INTO crm_audit_log VALUES("4015","1","5","2019-03-02 21:19:09","Customer [Customer No: 428] updated by Imran  Khan on 02/03/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("4016","3","5","2019-03-02 21:19:48","Exit Invoice [Invoice No: 118962] updated by Imran  Khan on 02/03/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("4017","2","4","2019-03-02 21:22:29","Entry Invoice [Invoice No: 20552] updated by Yasir  Rahman on 02/03/2019 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("4018","2","4","2019-03-02 23:20:39","Entry Invoice [Invoice No: 20553] updated by Yasir  Rahman on 02/03/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("4019","2","4","2019-03-02 23:23:21","Entry Invoice [Invoice No: 20554] updated by Yasir  Rahman on 02/03/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("4020","2","4","2019-03-02 23:27:58","Entry Invoice [Invoice No: 20555] updated by Yasir  Rahman on 02/03/2019 at 11:27 PM");
INSERT INTO crm_audit_log VALUES("4021","2","4","2019-03-02 23:29:19","Entry Invoice [Invoice No: 20556] updated by Yasir  Rahman on 02/03/2019 at 11:29 PM");
INSERT INTO crm_audit_log VALUES("4022","2","4","2019-03-02 23:59:37","Entry Invoice [Invoice No: 20557] updated by Yasir  Rahman on 02/03/2019 at 11:59 PM");
INSERT INTO crm_audit_log VALUES("4023","3","5","2019-03-03 01:36:13","Exit Invoice [Invoice No: 118963] updated by Imran  Khan on 03/03/2019 at 01:36 AM");
INSERT INTO crm_audit_log VALUES("4024","2","4","2019-03-03 03:21:34","Entry Invoice [Invoice No: 20558] updated by Yasir  Rahman on 03/03/2019 at 03:21 AM");
INSERT INTO crm_audit_log VALUES("4025","2","4","2019-03-03 03:23:04","Entry Invoice [Invoice No: 20559] updated by Yasir  Rahman on 03/03/2019 at 03:23 AM");
INSERT INTO crm_audit_log VALUES("4026","2","4","2019-03-03 03:24:16","Entry Invoice [Invoice No: 20560] updated by Yasir  Rahman on 03/03/2019 at 03:24 AM");
INSERT INTO crm_audit_log VALUES("4027","2","6","2019-03-03 08:30:03","Entry Invoice [Invoice No: 20553] updated by ASHRAF  M K on 03/03/2019 at 08:30 AM");
INSERT INTO crm_audit_log VALUES("4028","2","6","2019-03-03 09:04:59","Entry Invoice [Invoice No: 20554] updated by ASHRAF  M K on 03/03/2019 at 09:04 AM");
INSERT INTO crm_audit_log VALUES("4029","3","4","2019-03-03 09:41:24","Exit Invoice [Invoice No: 118964] updated by Yasir  Rahman on 03/03/2019 at 09:41 AM");
INSERT INTO crm_audit_log VALUES("4030","3","4","2019-03-03 10:39:50","Exit Invoice [Invoice No: 118965] updated by Yasir  Rahman on 03/03/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("4031","3","4","2019-03-03 14:59:45","Exit Invoice [Invoice No: 118966] updated by Yasir  Rahman on 03/03/2019 at 02:59 PM");
INSERT INTO crm_audit_log VALUES("4032","3","4","2019-03-03 15:31:17","Exit Invoice [Invoice No: 118967] updated by Yasir  Rahman on 03/03/2019 at 03:31 PM");
INSERT INTO crm_audit_log VALUES("4033","3","4","2019-03-03 15:32:21","Exit Invoice [Invoice No: 118968] updated by Yasir  Rahman on 03/03/2019 at 03:32 PM");
INSERT INTO crm_audit_log VALUES("4034","2","7","2019-03-03 18:40:10","Entry Invoice [Invoice No: 20561] updated by ALSED ABU SHAMA on 03/03/2019 at 06:40 PM");
INSERT INTO crm_audit_log VALUES("4035","2","7","2019-03-03 18:41:27","Entry Invoice [Invoice No: 20562] updated by ALSED ABU SHAMA on 03/03/2019 at 06:41 PM");
INSERT INTO crm_audit_log VALUES("4036","2","7","2019-03-03 18:42:49","Entry Invoice [Invoice No: 20563] updated by ALSED ABU SHAMA on 03/03/2019 at 06:42 PM");
INSERT INTO crm_audit_log VALUES("4037","2","7","2019-03-03 18:45:23","Entry Invoice [Invoice No: 20564] updated by ALSED ABU SHAMA on 03/03/2019 at 06:45 PM");
INSERT INTO crm_audit_log VALUES("4038","3","5","2019-03-03 20:29:11","Exit Invoice [Invoice No: 118969] updated by Imran  Khan on 03/03/2019 at 08:29 PM");
INSERT INTO crm_audit_log VALUES("4039","3","5","2019-03-03 21:07:49","Exit Invoice [Invoice No: 118970] updated by Imran  Khan on 03/03/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("4040","3","5","2019-03-03 21:13:16","Exit Invoice [Invoice No: 118971] updated by Imran  Khan on 03/03/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("4041","3","5","2019-03-03 21:58:12","Exit Invoice [Invoice No: 118972] updated by Imran  Khan on 03/03/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("4042","2","4","2019-03-03 23:14:57","Entry Invoice [Invoice No: 20565] updated by Yasir  Rahman on 03/03/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("4043","2","4","2019-03-03 23:25:36","Entry Invoice [Invoice No: 20566] updated by Yasir  Rahman on 03/03/2019 at 11:25 PM");
INSERT INTO crm_audit_log VALUES("4044","2","4","2019-03-03 23:29:36","Entry Invoice [Invoice No: 20567] updated by Yasir  Rahman on 03/03/2019 at 11:29 PM");
INSERT INTO crm_audit_log VALUES("4045","3","5","2019-03-04 00:14:59","Exit Invoice [Invoice No: 118973] updated by Imran  Khan on 04/03/2019 at 12:14 AM");
INSERT INTO crm_audit_log VALUES("4046","3","5","2019-03-04 00:15:54","Exit Invoice [Invoice No: 118974] updated by Imran  Khan on 04/03/2019 at 12:15 AM");
INSERT INTO crm_audit_log VALUES("4047","3","5","2019-03-04 00:17:00","Exit Invoice [Invoice No: 118975] updated by Imran  Khan on 04/03/2019 at 12:17 AM");
INSERT INTO crm_audit_log VALUES("4048","3","5","2019-03-04 01:43:06","Exit Invoice [Invoice No: 118976] updated by Imran  Khan on 04/03/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("4049","3","5","2019-03-04 01:44:05","Exit Invoice [Invoice No: 118977] updated by Imran  Khan on 04/03/2019 at 01:44 AM");
INSERT INTO crm_audit_log VALUES("4050","3","5","2019-03-04 01:45:51","Exit Invoice [Invoice No: 118978] updated by Imran  Khan on 04/03/2019 at 01:45 AM");
INSERT INTO crm_audit_log VALUES("4051","3","5","2019-03-04 02:34:20","Exit Invoice [Invoice No: 118979] updated by Imran  Khan on 04/03/2019 at 02:34 AM");
INSERT INTO crm_audit_log VALUES("4052","3","5","2019-03-04 02:52:50","Exit Invoice [Invoice No: 118980] updated by Imran  Khan on 04/03/2019 at 02:52 AM");
INSERT INTO crm_audit_log VALUES("4053","3","5","2019-03-04 02:53:29","Exit Invoice [Invoice No: 118981] updated by Imran  Khan on 04/03/2019 at 02:53 AM");
INSERT INTO crm_audit_log VALUES("4054","3","5","2019-03-04 02:58:30","Exit Invoice [Invoice No: 118982] updated by Imran  Khan on 04/03/2019 at 02:58 AM");
INSERT INTO crm_audit_log VALUES("4055","3","5","2019-03-04 04:51:44","Exit Invoice [Invoice No: 118983] updated by Imran  Khan on 04/03/2019 at 04:51 AM");
INSERT INTO crm_audit_log VALUES("4056","3","5","2019-03-04 04:52:18","Exit Invoice [Invoice No: 118984] updated by Imran  Khan on 04/03/2019 at 04:52 AM");
INSERT INTO crm_audit_log VALUES("4057","2","4","2019-03-04 07:16:35","Entry Invoice [Invoice No: 20568] updated by Yasir  Rahman on 04/03/2019 at 07:16 AM");
INSERT INTO crm_audit_log VALUES("4058","2","4","2019-03-04 07:17:57","Entry Invoice [Invoice No: 20569] updated by Yasir  Rahman on 04/03/2019 at 07:17 AM");
INSERT INTO crm_audit_log VALUES("4059","3","5","2019-03-04 07:28:20","Exit Invoice [Invoice No: 118985] updated by Imran  Khan on 04/03/2019 at 07:28 AM");
INSERT INTO crm_audit_log VALUES("4060","3","4","2019-03-04 08:45:25","Exit Invoice [Invoice No: 118986] updated by Yasir  Rahman on 04/03/2019 at 08:45 AM");
INSERT INTO crm_audit_log VALUES("4061","1","15","2019-03-04 10:00:40","Customer [Customer No: 429] updated by Abdul Rasheed on 04/03/2019 at 10:00 AM");
INSERT INTO crm_audit_log VALUES("4062","2","15","2019-03-04 10:02:39","Entry Invoice [Invoice No: 20570] updated by Abdul Rasheed on 04/03/2019 at 10:02 AM");
INSERT INTO crm_audit_log VALUES("4063","3","4","2019-03-04 11:01:36","Exit Invoice [Invoice No: 118987] updated by Yasir  Rahman on 04/03/2019 at 11:01 AM");
INSERT INTO crm_audit_log VALUES("4064","3","4","2019-03-04 12:11:37","Exit Invoice [Invoice No: 118988] updated by Yasir  Rahman on 04/03/2019 at 12:11 PM");
INSERT INTO crm_audit_log VALUES("4065","3","4","2019-03-04 12:13:40","Exit Invoice [Invoice No: 118989] updated by Yasir  Rahman on 04/03/2019 at 12:13 PM");
INSERT INTO crm_audit_log VALUES("4066","3","4","2019-03-04 13:59:31","Exit Invoice [Invoice No: 118990] updated by Yasir  Rahman on 04/03/2019 at 01:59 PM");
INSERT INTO crm_audit_log VALUES("4067","3","4","2019-03-04 14:11:06","Exit Invoice [Invoice No: 118991] updated by Yasir  Rahman on 04/03/2019 at 02:11 PM");
INSERT INTO crm_audit_log VALUES("4068","2","7","2019-03-04 15:57:56","Entry Invoice [Invoice No: 20571] updated by ALSED ABU SHAMA on 04/03/2019 at 03:57 PM");
INSERT INTO crm_audit_log VALUES("4069","3","4","2019-03-04 16:44:57","Exit Invoice [Invoice No: 118992] updated by Yasir  Rahman on 04/03/2019 at 04:44 PM");
INSERT INTO crm_audit_log VALUES("4070","3","4","2019-03-04 16:59:44","Exit Invoice [Invoice No: 118993] updated by Yasir  Rahman on 04/03/2019 at 04:59 PM");
INSERT INTO crm_audit_log VALUES("4071","2","7","2019-03-04 17:19:45","Entry Invoice [Invoice No: 20572] updated by ALSED ABU SHAMA on 04/03/2019 at 05:19 PM");
INSERT INTO crm_audit_log VALUES("4072","3","4","2019-03-04 19:11:34","Exit Invoice [Invoice No: 118994] updated by Yasir  Rahman on 04/03/2019 at 07:11 PM");
INSERT INTO crm_audit_log VALUES("4073","3","5","2019-03-04 20:44:52","Exit Invoice [Invoice No: 118995] updated by Imran  Khan on 04/03/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("4074","2","4","2019-03-04 20:45:40","Entry Invoice [Invoice No: 20573] updated by Yasir  Rahman on 04/03/2019 at 08:45 PM");
INSERT INTO crm_audit_log VALUES("4075","3","5","2019-03-04 20:47:52","Exit Invoice [Invoice No: 118996] updated by Imran  Khan on 04/03/2019 at 08:47 PM");
INSERT INTO crm_audit_log VALUES("4076","2","4","2019-03-04 21:49:28","Entry Invoice [Invoice No: 20574] updated by Yasir  Rahman on 04/03/2019 at 09:49 PM");
INSERT INTO crm_audit_log VALUES("4077","3","5","2019-03-04 23:33:30","Exit Invoice [Invoice No: 118997] updated by Imran  Khan on 04/03/2019 at 11:33 PM");
INSERT INTO crm_audit_log VALUES("4078","3","5","2019-03-05 02:49:53","Exit Invoice [Invoice No: 118998] updated by Imran  Khan on 05/03/2019 at 02:49 AM");
INSERT INTO crm_audit_log VALUES("4079","3","5","2019-03-05 06:39:23","Exit Invoice [Invoice No: 118999] updated by Imran  Khan on 05/03/2019 at 06:39 AM");
INSERT INTO crm_audit_log VALUES("4080","2","4","2019-03-05 07:10:38","Entry Invoice [Invoice No: 20575] updated by Yasir  Rahman on 05/03/2019 at 07:10 AM");
INSERT INTO crm_audit_log VALUES("4081","2","4","2019-03-05 07:11:49","Entry Invoice [Invoice No: 20576] updated by Yasir  Rahman on 05/03/2019 at 07:11 AM");
INSERT INTO crm_audit_log VALUES("4082","3","5","2019-03-05 07:46:11","Exit Invoice [Invoice No: 119000] updated by Imran  Khan on 05/03/2019 at 07:46 AM");
INSERT INTO crm_audit_log VALUES("4083","3","4","2019-03-05 09:45:47","Exit Invoice [Invoice No: 119001] updated by Yasir  Rahman on 05/03/2019 at 09:45 AM");
INSERT INTO crm_audit_log VALUES("4084","3","4","2019-03-05 09:47:14","Exit Invoice [Invoice No: 119002] updated by Yasir  Rahman on 05/03/2019 at 09:47 AM");
INSERT INTO crm_audit_log VALUES("4085","3","4","2019-03-05 09:48:14","Exit Invoice [Invoice No: 119003] updated by Yasir  Rahman on 05/03/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("4086","3","4","2019-03-05 09:49:57","Exit Invoice [Invoice No: 119004] updated by Yasir  Rahman on 05/03/2019 at 09:49 AM");
INSERT INTO crm_audit_log VALUES("4087","3","4","2019-03-05 10:23:57","Exit Invoice [Invoice No: 119005] updated by Yasir  Rahman on 05/03/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("4088","2","7","2019-03-05 11:23:07","Entry Invoice [Invoice No: 20577] updated by ALSED ABU SHAMA on 05/03/2019 at 11:23 AM");
INSERT INTO crm_audit_log VALUES("4089","2","15","2019-03-05 12:39:51","Entry Invoice [Invoice No: 20578] updated by Abdul Rasheed on 05/03/2019 at 12:39 PM");
INSERT INTO crm_audit_log VALUES("4090","2","15","2019-03-05 12:41:45","Entry Invoice [Invoice No: 20579] updated by Abdul Rasheed on 05/03/2019 at 12:41 PM");
INSERT INTO crm_audit_log VALUES("4091","2","15","2019-03-05 12:52:42","Entry Invoice [Invoice No: 20580] updated by Abdul Rasheed on 05/03/2019 at 12:52 PM");
INSERT INTO crm_audit_log VALUES("4092","3","4","2019-03-05 12:58:53","Exit Invoice [Invoice No: 119006] updated by Yasir  Rahman on 05/03/2019 at 12:58 PM");
INSERT INTO crm_audit_log VALUES("4093","3","4","2019-03-05 13:39:32","Exit Invoice [Invoice No: 119007] updated by Yasir  Rahman on 05/03/2019 at 01:39 PM");
INSERT INTO crm_audit_log VALUES("4094","3","4","2019-03-05 13:45:25","Exit Invoice [Invoice No: 119008] updated by Yasir  Rahman on 05/03/2019 at 01:45 PM");
INSERT INTO crm_audit_log VALUES("4095","2","7","2019-03-05 14:10:07","Entry Invoice [Invoice No: 20581] updated by ALSED ABU SHAMA on 05/03/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("4096","2","7","2019-03-05 14:12:17","Entry Invoice [Invoice No: 20582] updated by ALSED ABU SHAMA on 05/03/2019 at 02:12 PM");
INSERT INTO crm_audit_log VALUES("4097","2","7","2019-03-05 14:18:35","Entry Invoice [Invoice No: 20583] updated by ALSED ABU SHAMA on 05/03/2019 at 02:18 PM");
INSERT INTO crm_audit_log VALUES("4098","2","7","2019-03-05 19:39:01","Entry Invoice [Invoice No: 20584] updated by ALSED ABU SHAMA on 05/03/2019 at 07:39 PM");
INSERT INTO crm_audit_log VALUES("4099","2","4","2019-03-05 21:05:38","Entry Invoice [Invoice No: 20585] updated by Yasir  Rahman on 05/03/2019 at 09:05 PM");
INSERT INTO crm_audit_log VALUES("4100","3","5","2019-03-05 21:31:22","Exit Invoice [Invoice No: 119009] updated by Imran  Khan on 05/03/2019 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("4101","2","4","2019-03-05 22:36:47","Entry Invoice [Invoice No: 20586] updated by Yasir  Rahman on 05/03/2019 at 10:36 PM");
INSERT INTO crm_audit_log VALUES("4102","3","5","2019-03-05 23:50:26","Exit Invoice [Invoice No: 119010] updated by Imran  Khan on 05/03/2019 at 11:50 PM");
INSERT INTO crm_audit_log VALUES("4103","3","5","2019-03-06 02:40:48","Exit Invoice [Invoice No: 119011] updated by Imran  Khan on 06/03/2019 at 02:40 AM");
INSERT INTO crm_audit_log VALUES("4104","3","5","2019-03-06 02:41:36","Exit Invoice [Invoice No: 119012] updated by Imran  Khan on 06/03/2019 at 02:41 AM");
INSERT INTO crm_audit_log VALUES("4105","3","5","2019-03-06 03:12:48","Exit Invoice [Invoice No: 119013] updated by Imran  Khan on 06/03/2019 at 03:12 AM");
INSERT INTO crm_audit_log VALUES("4106","3","5","2019-03-06 03:43:09","Exit Invoice [Invoice No: 119014] updated by Imran  Khan on 06/03/2019 at 03:43 AM");
INSERT INTO crm_audit_log VALUES("4107","3","5","2019-03-06 05:17:23","Exit Invoice [Invoice No: 119015] updated by Imran  Khan on 06/03/2019 at 05:17 AM");
INSERT INTO crm_audit_log VALUES("4108","2","4","2019-03-06 07:27:56","Entry Invoice [Invoice No: 20587] updated by Yasir  Rahman on 06/03/2019 at 07:27 AM");
INSERT INTO crm_audit_log VALUES("4109","2","4","2019-03-06 07:31:36","Entry Invoice [Invoice No: 20588] updated by Yasir  Rahman on 06/03/2019 at 07:31 AM");
INSERT INTO crm_audit_log VALUES("4110","2","4","2019-03-06 07:34:52","Entry Invoice [Invoice No: 20589] updated by Yasir  Rahman on 06/03/2019 at 07:34 AM");
INSERT INTO crm_audit_log VALUES("4111","2","4","2019-03-06 07:40:46","Entry Invoice [Invoice No: 20590] updated by Yasir  Rahman on 06/03/2019 at 07:40 AM");
INSERT INTO crm_audit_log VALUES("4112","2","4","2019-03-06 07:42:29","Entry Invoice [Invoice No: 20591] updated by Yasir  Rahman on 06/03/2019 at 07:42 AM");
INSERT INTO crm_audit_log VALUES("4113","2","6","2019-03-06 08:27:54","Entry Invoice [Invoice No: 20580] updated by ASHRAF  M K on 06/03/2019 at 08:27 AM");
INSERT INTO crm_audit_log VALUES("4114","3","4","2019-03-06 09:28:45","Exit Invoice [Invoice No: 119016] updated by Yasir  Rahman on 06/03/2019 at 09:28 AM");
INSERT INTO crm_audit_log VALUES("4115","3","4","2019-03-06 10:47:07","Exit Invoice [Invoice No: 119017] updated by Yasir  Rahman on 06/03/2019 at 10:47 AM");
INSERT INTO crm_audit_log VALUES("4116","3","4","2019-03-06 12:26:19","Exit Invoice [Invoice No: 119018] updated by Yasir  Rahman on 06/03/2019 at 12:26 PM");
INSERT INTO crm_audit_log VALUES("4117","3","4","2019-03-06 12:34:59","Exit Invoice [Invoice No: 119019] updated by Yasir  Rahman on 06/03/2019 at 12:34 PM");
INSERT INTO crm_audit_log VALUES("4118","3","4","2019-03-06 12:36:03","Exit Invoice [Invoice No: 119020] updated by Yasir  Rahman on 06/03/2019 at 12:36 PM");
INSERT INTO crm_audit_log VALUES("4119","3","4","2019-03-06 13:52:45","Exit Invoice [Invoice No: 119021] updated by Yasir  Rahman on 06/03/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("4120","2","6","2019-03-06 14:02:57","Entry Invoice [Invoice No: 20592] updated by ASHRAF  M K on 06/03/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("4121","2","6","2019-03-06 14:40:12","Entry Invoice [Invoice No: 20593] updated by ASHRAF  M K on 06/03/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("4122","3","4","2019-03-06 14:47:48","Exit Invoice [Invoice No: 119022] updated by Yasir  Rahman on 06/03/2019 at 02:47 PM");
INSERT INTO crm_audit_log VALUES("4123","3","4","2019-03-06 14:50:22","Exit Invoice [Invoice No: 119023] updated by Yasir  Rahman on 06/03/2019 at 02:50 PM");
INSERT INTO crm_audit_log VALUES("4124","3","4","2019-03-06 14:51:10","Exit Invoice [Invoice No: 119024] updated by Yasir  Rahman on 06/03/2019 at 02:51 PM");
INSERT INTO crm_audit_log VALUES("4125","1","6","2019-03-06 15:00:55","Customer [Customer No: 421] updated by ASHRAF  M K on 06/03/2019 at 03:00 PM");
INSERT INTO crm_audit_log VALUES("4126","1","6","2019-03-06 15:01:37","Customer [Customer No: 421] updated by ASHRAF  M K on 06/03/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("4127","2","7","2019-03-06 15:08:54","Entry Invoice [Invoice No: 20594] updated by ALSED ABU SHAMA on 06/03/2019 at 03:08 PM");
INSERT INTO crm_audit_log VALUES("4128","3","4","2019-03-06 17:43:04","Exit Invoice [Invoice No: 119025] updated by Yasir  Rahman on 06/03/2019 at 05:43 PM");
INSERT INTO crm_audit_log VALUES("4129","3","4","2019-03-06 18:01:53","Exit Invoice [Invoice No: 119026] updated by Yasir  Rahman on 06/03/2019 at 06:01 PM");
INSERT INTO crm_audit_log VALUES("4130","3","4","2019-03-06 18:03:19","Exit Invoice [Invoice No: 119027] updated by Yasir  Rahman on 06/03/2019 at 06:03 PM");
INSERT INTO crm_audit_log VALUES("4131","3","6","2019-03-06 18:06:24","Exit Invoice [Invoice No: 119027] updated by ASHRAF  M K on 06/03/2019 at 06:06 PM");
INSERT INTO crm_audit_log VALUES("4132","3","4","2019-03-06 18:31:57","Exit Invoice [Invoice No: 119028] updated by Yasir  Rahman on 06/03/2019 at 06:31 PM");
INSERT INTO crm_audit_log VALUES("4133","2","7","2019-03-06 19:15:25","Entry Invoice [Invoice No: 20595] updated by ALSED ABU SHAMA on 06/03/2019 at 07:15 PM");
INSERT INTO crm_audit_log VALUES("4134","2","7","2019-03-06 19:19:05","Entry Invoice [Invoice No: 20596] updated by ALSED ABU SHAMA on 06/03/2019 at 07:19 PM");
INSERT INTO crm_audit_log VALUES("4135","3","6","2019-03-06 20:48:07","Exit Invoice [Invoice No: 119025] updated by ASHRAF  M K on 06/03/2019 at 08:48 PM");
INSERT INTO crm_audit_log VALUES("4136","2","4","2019-03-06 21:06:01","Entry Invoice [Invoice No: 20597] updated by Yasir  Rahman on 06/03/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("4137","3","5","2019-03-06 22:31:16","Exit Invoice [Invoice No: 119029] updated by Imran  Khan on 06/03/2019 at 10:31 PM");
INSERT INTO crm_audit_log VALUES("4138","3","5","2019-03-06 22:34:10","Exit Invoice [Invoice No: 119030] updated by Imran  Khan on 06/03/2019 at 10:34 PM");
INSERT INTO crm_audit_log VALUES("4139","3","5","2019-03-06 23:54:42","Exit Invoice [Invoice No: 119031] updated by Imran  Khan on 06/03/2019 at 11:54 PM");
INSERT INTO crm_audit_log VALUES("4140","3","5","2019-03-07 01:43:21","Exit Invoice [Invoice No: 119032] updated by Imran  Khan on 07/03/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("4141","3","5","2019-03-07 02:34:55","Exit Invoice [Invoice No: 119033] updated by Imran  Khan on 07/03/2019 at 02:34 AM");
INSERT INTO crm_audit_log VALUES("4142","3","5","2019-03-07 03:34:42","Exit Invoice [Invoice No: 119034] updated by Imran  Khan on 07/03/2019 at 03:34 AM");
INSERT INTO crm_audit_log VALUES("4143","2","4","2019-03-07 05:55:51","Entry Invoice [Invoice No: 20598] updated by Yasir  Rahman on 07/03/2019 at 05:55 AM");
INSERT INTO crm_audit_log VALUES("4144","2","4","2019-03-07 05:59:25","Entry Invoice [Invoice No: 20599] updated by Yasir  Rahman on 07/03/2019 at 05:59 AM");
INSERT INTO crm_audit_log VALUES("4145","2","4","2019-03-07 06:01:51","Entry Invoice [Invoice No: 20600] updated by Yasir  Rahman on 07/03/2019 at 06:01 AM");
INSERT INTO crm_audit_log VALUES("4146","2","4","2019-03-07 06:04:58","Entry Invoice [Invoice No: 20601] updated by Yasir  Rahman on 07/03/2019 at 06:04 AM");
INSERT INTO crm_audit_log VALUES("4147","2","4","2019-03-07 06:07:48","Entry Invoice [Invoice No: 20602] updated by Yasir  Rahman on 07/03/2019 at 06:07 AM");
INSERT INTO crm_audit_log VALUES("4148","2","4","2019-03-07 06:10:31","Entry Invoice [Invoice No: 20603] updated by Yasir  Rahman on 07/03/2019 at 06:10 AM");
INSERT INTO crm_audit_log VALUES("4149","3","5","2019-03-07 07:02:57","Exit Invoice [Invoice No: 119035] updated by Imran  Khan on 07/03/2019 at 07:02 AM");
INSERT INTO crm_audit_log VALUES("4150","1","6","2019-03-07 08:43:28","Customer [Customer No: 430] updated by ASHRAF  M K on 07/03/2019 at 08:43 AM");
INSERT INTO crm_audit_log VALUES("4151","2","6","2019-03-07 08:45:44","Entry Invoice [Invoice No: 20604] updated by ASHRAF  M K on 07/03/2019 at 08:45 AM");
INSERT INTO crm_audit_log VALUES("4152","3","4","2019-03-07 09:16:20","Exit Invoice [Invoice No: 119036] updated by Yasir  Rahman on 07/03/2019 at 09:16 AM");
INSERT INTO crm_audit_log VALUES("4153","3","4","2019-03-07 09:17:31","Exit Invoice [Invoice No: 119037] updated by Yasir  Rahman on 07/03/2019 at 09:17 AM");
INSERT INTO crm_audit_log VALUES("4154","3","4","2019-03-07 10:05:49","Exit Invoice [Invoice No: 119038] updated by Yasir  Rahman on 07/03/2019 at 10:05 AM");
INSERT INTO crm_audit_log VALUES("4155","3","4","2019-03-07 10:34:57","Exit Invoice [Invoice No: 119039] updated by Yasir  Rahman on 07/03/2019 at 10:34 AM");
INSERT INTO crm_audit_log VALUES("4156","2","6","2019-03-07 10:49:36","Entry Invoice [Invoice No: 20605] updated by ASHRAF  M K on 07/03/2019 at 10:49 AM");
INSERT INTO crm_audit_log VALUES("4157","3","4","2019-03-07 11:53:38","Exit Invoice [Invoice No: 119040] updated by Yasir  Rahman on 07/03/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("4158","2","6","2019-03-07 12:51:36","Entry Invoice [Invoice No: 20606] updated by ASHRAF  M K on 07/03/2019 at 12:51 PM");
INSERT INTO crm_audit_log VALUES("4159","2","6","2019-03-07 12:56:10","Entry Invoice [Invoice No: 20607] updated by ASHRAF  M K on 07/03/2019 at 12:56 PM");
INSERT INTO crm_audit_log VALUES("4160","2","7","2019-03-07 14:24:24","Entry Invoice [Invoice No: 20608] updated by ALSED ABU SHAMA on 07/03/2019 at 02:24 PM");
INSERT INTO crm_audit_log VALUES("4161","2","6","2019-03-07 14:33:47","Entry Invoice [Invoice No: 20512] updated by ASHRAF  M K on 07/03/2019 at 02:33 PM");
INSERT INTO crm_audit_log VALUES("4162","2","6","2019-03-07 14:34:59","Entry Invoice [Invoice No: 20512] updated by ASHRAF  M K on 07/03/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("4163","2","6","2019-03-07 14:35:45","Entry Invoice [Invoice No: 20512] updated by ASHRAF  M K on 07/03/2019 at 02:35 PM");
INSERT INTO crm_audit_log VALUES("4164","1","6","2019-03-07 14:37:06","Customer [Customer No: 421] updated by ASHRAF  M K on 07/03/2019 at 02:37 PM");
INSERT INTO crm_audit_log VALUES("4165","1","6","2019-03-07 14:39:42","Customer [Customer No: 421] updated by ASHRAF  M K on 07/03/2019 at 02:39 PM");
INSERT INTO crm_audit_log VALUES("4166","3","4","2019-03-07 16:03:00","Exit Invoice [Invoice No: 119041] updated by Yasir  Rahman on 07/03/2019 at 04:03 PM");
INSERT INTO crm_audit_log VALUES("4167","2","7","2019-03-07 16:33:29","Entry Invoice [Invoice No: 20609] updated by ALSED ABU SHAMA on 07/03/2019 at 04:33 PM");
INSERT INTO crm_audit_log VALUES("4168","2","7","2019-03-07 16:43:21","Entry Invoice [Invoice No: 20610] updated by ALSED ABU SHAMA on 07/03/2019 at 04:43 PM");
INSERT INTO crm_audit_log VALUES("4169","3","4","2019-03-07 16:55:37","Exit Invoice [Invoice No: 119042] updated by Yasir  Rahman on 07/03/2019 at 04:55 PM");
INSERT INTO crm_audit_log VALUES("4170","3","4","2019-03-07 18:40:11","Exit Invoice [Invoice No: 119043] updated by Yasir  Rahman on 07/03/2019 at 06:40 PM");
INSERT INTO crm_audit_log VALUES("4171","3","4","2019-03-07 19:36:04","Exit Invoice [Invoice No: 119044] updated by Yasir  Rahman on 07/03/2019 at 07:36 PM");
INSERT INTO crm_audit_log VALUES("4172","3","4","2019-03-07 19:37:29","Exit Invoice [Invoice No: 119045] updated by Yasir  Rahman on 07/03/2019 at 07:37 PM");
INSERT INTO crm_audit_log VALUES("4173","2","7","2019-03-07 19:39:04","Entry Invoice [Invoice No: 20611] updated by ALSED ABU SHAMA on 07/03/2019 at 07:39 PM");
INSERT INTO crm_audit_log VALUES("4174","2","7","2019-03-07 19:39:58","Entry Invoice [Invoice No: 20612] updated by ALSED ABU SHAMA on 07/03/2019 at 07:39 PM");
INSERT INTO crm_audit_log VALUES("4175","3","15","2019-03-07 20:12:45","Exit Invoice [Invoice No: 119046] updated by Abdul Rasheed on 07/03/2019 at 08:12 PM");
INSERT INTO crm_audit_log VALUES("4176","2","4","2019-03-07 21:37:31","Entry Invoice [Invoice No: 20613] updated by Yasir  Rahman on 07/03/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("4177","2","4","2019-03-07 22:06:06","Entry Invoice [Invoice No: 20614] updated by Yasir  Rahman on 07/03/2019 at 10:06 PM");
INSERT INTO crm_audit_log VALUES("4178","3","15","2019-03-07 23:01:42","Exit Invoice [Invoice No: 119047] updated by Abdul Rasheed on 07/03/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("4179","3","6","2019-03-08 00:11:08","Exit Invoice [Invoice No: 119034] updated by ASHRAF  M K on 08/03/2019 at 12:11 AM");
INSERT INTO crm_audit_log VALUES("4180","3","15","2019-03-08 00:42:03","Exit Invoice [Invoice No: 119048] updated by Abdul Rasheed on 08/03/2019 at 12:42 AM");
INSERT INTO crm_audit_log VALUES("4181","3","15","2019-03-08 01:27:19","Exit Invoice [Invoice No: 119049] updated by Abdul Rasheed on 08/03/2019 at 01:27 AM");
INSERT INTO crm_audit_log VALUES("4182","3","15","2019-03-08 01:35:01","Exit Invoice [Invoice No: 119050] updated by Abdul Rasheed on 08/03/2019 at 01:35 AM");
INSERT INTO crm_audit_log VALUES("4183","3","15","2019-03-08 04:56:24","Exit Invoice [Invoice No: 119051] updated by Abdul Rasheed on 08/03/2019 at 04:56 AM");
INSERT INTO crm_audit_log VALUES("4184","2","4","2019-03-08 05:27:16","Entry Invoice [Invoice No: 20615] updated by Yasir  Rahman on 08/03/2019 at 05:27 AM");
INSERT INTO crm_audit_log VALUES("4185","2","4","2019-03-08 05:29:56","Entry Invoice [Invoice No: 20616] updated by Yasir  Rahman on 08/03/2019 at 05:29 AM");
INSERT INTO crm_audit_log VALUES("4186","2","4","2019-03-08 05:31:56","Entry Invoice [Invoice No: 20617] updated by Yasir  Rahman on 08/03/2019 at 05:31 AM");
INSERT INTO crm_audit_log VALUES("4187","2","4","2019-03-08 05:34:24","Entry Invoice [Invoice No: 20618] updated by Yasir  Rahman on 08/03/2019 at 05:34 AM");
INSERT INTO crm_audit_log VALUES("4188","3","15","2019-03-08 06:18:30","Exit Invoice [Invoice No: 119052] updated by Abdul Rasheed on 08/03/2019 at 06:18 AM");
INSERT INTO crm_audit_log VALUES("4189","3","15","2019-03-08 06:19:10","Exit Invoice [Invoice No: 119053] updated by Abdul Rasheed on 08/03/2019 at 06:19 AM");
INSERT INTO crm_audit_log VALUES("4190","3","4","2019-03-08 09:37:39","Exit Invoice [Invoice No: 119054] updated by Yasir  Rahman on 08/03/2019 at 09:37 AM");
INSERT INTO crm_audit_log VALUES("4191","2","7","2019-03-08 10:23:23","Entry Invoice [Invoice No: 20619] updated by ALSED ABU SHAMA on 08/03/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("4192","3","4","2019-03-08 10:26:04","Exit Invoice [Invoice No: 119055] updated by Yasir  Rahman on 08/03/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("4193","3","4","2019-03-08 10:27:01","Exit Invoice [Invoice No: 119056] updated by Yasir  Rahman on 08/03/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("4194","3","4","2019-03-08 14:42:07","Exit Invoice [Invoice No: 119057] updated by Yasir  Rahman on 08/03/2019 at 02:42 PM");
INSERT INTO crm_audit_log VALUES("4195","3","4","2019-03-08 14:42:58","Exit Invoice [Invoice No: 119058] updated by Yasir  Rahman on 08/03/2019 at 02:42 PM");
INSERT INTO crm_audit_log VALUES("4196","2","7","2019-03-08 15:10:19","Entry Invoice [Invoice No: 20620] updated by ALSED ABU SHAMA on 08/03/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("4197","2","7","2019-03-08 15:12:56","Entry Invoice [Invoice No: 20621] updated by ALSED ABU SHAMA on 08/03/2019 at 03:12 PM");
INSERT INTO crm_audit_log VALUES("4198","3","4","2019-03-08 16:57:16","Exit Invoice [Invoice No: 119059] updated by Yasir  Rahman on 08/03/2019 at 04:57 PM");
INSERT INTO crm_audit_log VALUES("4199","2","7","2019-03-08 18:34:44","Entry Invoice [Invoice No: 20622] updated by ALSED ABU SHAMA on 08/03/2019 at 06:34 PM");
INSERT INTO crm_audit_log VALUES("4200","3","4","2019-03-08 18:35:27","Exit Invoice [Invoice No: 119060] updated by Yasir  Rahman on 08/03/2019 at 06:35 PM");
INSERT INTO crm_audit_log VALUES("4201","3","4","2019-03-08 18:36:26","Exit Invoice [Invoice No: 119061] updated by Yasir  Rahman on 08/03/2019 at 06:36 PM");
INSERT INTO crm_audit_log VALUES("4202","3","4","2019-03-08 18:37:07","Exit Invoice [Invoice No: 119062] updated by Yasir  Rahman on 08/03/2019 at 06:37 PM");
INSERT INTO crm_audit_log VALUES("4203","3","4","2019-03-08 19:30:52","Exit Invoice [Invoice No: 119063] updated by Yasir  Rahman on 08/03/2019 at 07:30 PM");
INSERT INTO crm_audit_log VALUES("4204","2","7","2019-03-08 19:43:32","Entry Invoice [Invoice No: 20623] updated by ALSED ABU SHAMA on 08/03/2019 at 07:43 PM");
INSERT INTO crm_audit_log VALUES("4205","2","7","2019-03-08 19:45:05","Entry Invoice [Invoice No: 20624] updated by ALSED ABU SHAMA on 08/03/2019 at 07:45 PM");
INSERT INTO crm_audit_log VALUES("4206","2","4","2019-03-08 20:55:10","Entry Invoice [Invoice No: 20625] updated by Yasir  Rahman on 08/03/2019 at 08:55 PM");
INSERT INTO crm_audit_log VALUES("4207","3","15","2019-03-08 21:08:56","Exit Invoice [Invoice No: 119064] updated by Abdul Rasheed on 08/03/2019 at 09:08 PM");
INSERT INTO crm_audit_log VALUES("4208","3","15","2019-03-08 21:09:39","Exit Invoice [Invoice No: 119065] updated by Abdul Rasheed on 08/03/2019 at 09:09 PM");
INSERT INTO crm_audit_log VALUES("4209","3","15","2019-03-08 21:10:22","Exit Invoice [Invoice No: 119066] updated by Abdul Rasheed on 08/03/2019 at 09:10 PM");
INSERT INTO crm_audit_log VALUES("4210","2","4","2019-03-08 21:13:07","Entry Invoice [Invoice No: 20626] updated by Yasir  Rahman on 08/03/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("4211","3","15","2019-03-08 21:20:13","Exit Invoice [Invoice No: 119067] updated by Abdul Rasheed on 08/03/2019 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("4212","3","15","2019-03-08 21:34:30","Exit Invoice [Invoice No: 119068] updated by Abdul Rasheed on 08/03/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("4213","2","6","2019-03-08 21:57:37","Entry Invoice [Invoice No: 20626] updated by ASHRAF  M K on 08/03/2019 at 09:57 PM");
INSERT INTO crm_audit_log VALUES("4214","1","4","2019-03-08 22:29:51","Customer [Customer No: 431] updated by Yasir  Rahman on 08/03/2019 at 10:29 PM");
INSERT INTO crm_audit_log VALUES("4215","2","4","2019-03-08 22:31:05","Entry Invoice [Invoice No: 20627] updated by Yasir  Rahman on 08/03/2019 at 10:31 PM");
INSERT INTO crm_audit_log VALUES("4216","2","6","2019-03-08 22:38:49","Entry Invoice [Invoice No: 20626] updated by ASHRAF  M K on 08/03/2019 at 10:38 PM");
INSERT INTO crm_audit_log VALUES("4217","2","6","2019-03-08 22:41:17","Entry Invoice [Invoice No: 20626] updated by ASHRAF  M K on 08/03/2019 at 10:41 PM");
INSERT INTO crm_audit_log VALUES("4218","2","6","2019-03-08 22:46:28","Entry Invoice [Invoice No: 20628] updated by ASHRAF  M K on 08/03/2019 at 10:46 PM");
INSERT INTO crm_audit_log VALUES("4219","3","15","2019-03-08 23:29:02","Exit Invoice [Invoice No: 119069] updated by Abdul Rasheed on 08/03/2019 at 11:29 PM");
INSERT INTO crm_audit_log VALUES("4220","3","15","2019-03-09 00:34:20","Exit Invoice [Invoice No: 119070] updated by Abdul Rasheed on 09/03/2019 at 12:34 AM");
INSERT INTO crm_audit_log VALUES("4221","3","15","2019-03-09 00:35:28","Exit Invoice [Invoice No: 119071] updated by Abdul Rasheed on 09/03/2019 at 12:35 AM");
INSERT INTO crm_audit_log VALUES("4222","3","15","2019-03-09 00:39:27","Exit Invoice [Invoice No: 119072] updated by Abdul Rasheed on 09/03/2019 at 12:39 AM");
INSERT INTO crm_audit_log VALUES("4223","3","15","2019-03-09 00:43:03","Exit Invoice [Invoice No: 119073] updated by Abdul Rasheed on 09/03/2019 at 12:43 AM");
INSERT INTO crm_audit_log VALUES("4224","2","4","2019-03-09 05:18:15","Entry Invoice [Invoice No: 20629] updated by Yasir  Rahman on 09/03/2019 at 05:18 AM");
INSERT INTO crm_audit_log VALUES("4225","2","4","2019-03-09 05:22:00","Entry Invoice [Invoice No: 20630] updated by Yasir  Rahman on 09/03/2019 at 05:22 AM");
INSERT INTO crm_audit_log VALUES("4226","2","4","2019-03-09 05:23:09","Entry Invoice [Invoice No: 20631] updated by Yasir  Rahman on 09/03/2019 at 05:23 AM");
INSERT INTO crm_audit_log VALUES("4227","2","4","2019-03-09 05:24:00","Entry Invoice [Invoice No: 20632] updated by Yasir  Rahman on 09/03/2019 at 05:24 AM");
INSERT INTO crm_audit_log VALUES("4228","2","4","2019-03-09 05:25:08","Entry Invoice [Invoice No: 20633] updated by Yasir  Rahman on 09/03/2019 at 05:25 AM");
INSERT INTO crm_audit_log VALUES("4229","3","15","2019-03-09 05:44:11","Exit Invoice [Invoice No: 119074] updated by Abdul Rasheed on 09/03/2019 at 05:44 AM");
INSERT INTO crm_audit_log VALUES("4230","3","15","2019-03-09 05:45:30","Exit Invoice [Invoice No: 119075] updated by Abdul Rasheed on 09/03/2019 at 05:45 AM");
INSERT INTO crm_audit_log VALUES("4231","2","4","2019-03-09 06:25:54","Entry Invoice [Invoice No: 20634] updated by Yasir  Rahman on 09/03/2019 at 06:25 AM");
INSERT INTO crm_audit_log VALUES("4232","2","7","2019-03-09 10:19:22","Entry Invoice [Invoice No: 20635] updated by ALSED ABU SHAMA on 09/03/2019 at 10:19 AM");
INSERT INTO crm_audit_log VALUES("4233","3","4","2019-03-09 12:13:21","Exit Invoice [Invoice No: 119076] updated by Yasir  Rahman on 09/03/2019 at 12:13 PM");
INSERT INTO crm_audit_log VALUES("4234","2","7","2019-03-09 13:50:34","Entry Invoice [Invoice No: 20636] updated by ALSED ABU SHAMA on 09/03/2019 at 01:50 PM");
INSERT INTO crm_audit_log VALUES("4235","2","7","2019-03-09 13:54:09","Entry Invoice [Invoice No: 20637] updated by ALSED ABU SHAMA on 09/03/2019 at 01:54 PM");
INSERT INTO crm_audit_log VALUES("4236","3","4","2019-03-09 14:40:59","Exit Invoice [Invoice No: 119077] updated by Yasir  Rahman on 09/03/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("4237","2","6","2019-03-09 15:31:37","Entry Invoice [Invoice No: 20638] updated by ASHRAF  M K on 09/03/2019 at 03:31 PM");
INSERT INTO crm_audit_log VALUES("4238","3","4","2019-03-09 17:18:29","Exit Invoice [Invoice No: 119078] updated by Yasir  Rahman on 09/03/2019 at 05:18 PM");
INSERT INTO crm_audit_log VALUES("4239","3","4","2019-03-09 17:19:51","Exit Invoice [Invoice No: 119079] updated by Yasir  Rahman on 09/03/2019 at 05:19 PM");
INSERT INTO crm_audit_log VALUES("4240","3","4","2019-03-09 19:29:36","Exit Invoice [Invoice No: 119080] updated by Yasir  Rahman on 09/03/2019 at 07:29 PM");
INSERT INTO crm_audit_log VALUES("4241","1","15","2019-03-09 22:50:42","Customer [Customer No: 432] updated by Abdul Rasheed on 09/03/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("4242","3","4","2019-03-10 02:48:59","Exit Invoice [Invoice No: 119081] updated by Yasir  Rahman on 10/03/2019 at 02:48 AM");
INSERT INTO crm_audit_log VALUES("4243","3","4","2019-03-10 06:49:23","Exit Invoice [Invoice No: 119082] updated by Yasir  Rahman on 10/03/2019 at 06:49 AM");
INSERT INTO crm_audit_log VALUES("4244","2","4","2019-03-10 07:41:04","Entry Invoice [Invoice No: 20639] updated by Yasir  Rahman on 10/03/2019 at 07:41 AM");
INSERT INTO crm_audit_log VALUES("4245","2","4","2019-03-10 07:42:10","Entry Invoice [Invoice No: 20640] updated by Yasir  Rahman on 10/03/2019 at 07:42 AM");
INSERT INTO crm_audit_log VALUES("4246","2","4","2019-03-10 07:43:17","Entry Invoice [Invoice No: 20641] updated by Yasir  Rahman on 10/03/2019 at 07:43 AM");
INSERT INTO crm_audit_log VALUES("4247","3","4","2019-03-10 08:08:27","Exit Invoice [Invoice No: 119083] updated by Yasir  Rahman on 10/03/2019 at 08:08 AM");
INSERT INTO crm_audit_log VALUES("4248","3","4","2019-03-10 09:59:48","Exit Invoice [Invoice No: 119084] updated by Yasir  Rahman on 10/03/2019 at 09:59 AM");
INSERT INTO crm_audit_log VALUES("4249","2","7","2019-03-10 11:36:21","Entry Invoice [Invoice No: 20642] updated by ALSED ABU SHAMA on 10/03/2019 at 11:36 AM");
INSERT INTO crm_audit_log VALUES("4250","3","4","2019-03-10 12:42:45","Exit Invoice [Invoice No: 119085] updated by Yasir  Rahman on 10/03/2019 at 12:42 PM");
INSERT INTO crm_audit_log VALUES("4251","3","4","2019-03-10 15:33:38","Exit Invoice [Invoice No: 119086] updated by Yasir  Rahman on 10/03/2019 at 03:33 PM");
INSERT INTO crm_audit_log VALUES("4252","3","4","2019-03-10 19:02:05","Exit Invoice [Invoice No: 119087] updated by Yasir  Rahman on 10/03/2019 at 07:02 PM");
INSERT INTO crm_audit_log VALUES("4253","3","4","2019-03-10 20:03:14","Exit Invoice [Invoice No: 119088] updated by Yasir  Rahman on 10/03/2019 at 08:03 PM");
INSERT INTO crm_audit_log VALUES("4254","3","4","2019-03-10 22:59:50","Exit Invoice [Invoice No: 119089] updated by Yasir  Rahman on 10/03/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("4255","3","4","2019-03-10 23:59:31","Exit Invoice [Invoice No: 119090] updated by Yasir  Rahman on 10/03/2019 at 11:59 PM");
INSERT INTO crm_audit_log VALUES("4256","2","4","2019-03-11 00:04:46","Entry Invoice [Invoice No: 20643] updated by Yasir  Rahman on 11/03/2019 at 12:04 AM");
INSERT INTO crm_audit_log VALUES("4257","2","4","2019-03-11 00:52:16","Entry Invoice [Invoice No: 20644] updated by Yasir  Rahman on 11/03/2019 at 12:52 AM");
INSERT INTO crm_audit_log VALUES("4258","2","4","2019-03-11 00:54:28","Entry Invoice [Invoice No: 20645] updated by Yasir  Rahman on 11/03/2019 at 12:54 AM");
INSERT INTO crm_audit_log VALUES("4259","2","4","2019-03-11 00:56:45","Entry Invoice [Invoice No: 20646] updated by Yasir  Rahman on 11/03/2019 at 12:56 AM");
INSERT INTO crm_audit_log VALUES("4260","2","4","2019-03-11 00:58:29","Entry Invoice [Invoice No: 20647] updated by Yasir  Rahman on 11/03/2019 at 12:58 AM");
INSERT INTO crm_audit_log VALUES("4261","2","4","2019-03-11 01:00:26","Entry Invoice [Invoice No: 20648] updated by Yasir  Rahman on 11/03/2019 at 01:00 AM");
INSERT INTO crm_audit_log VALUES("4262","2","4","2019-03-11 01:04:21","Entry Invoice [Invoice No: 20649] updated by Yasir  Rahman on 11/03/2019 at 01:04 AM");
INSERT INTO crm_audit_log VALUES("4263","3","4","2019-03-11 02:46:09","Exit Invoice [Invoice No: 119091] updated by Yasir  Rahman on 11/03/2019 at 02:46 AM");
INSERT INTO crm_audit_log VALUES("4264","3","4","2019-03-11 04:50:46","Exit Invoice [Invoice No: 119092] updated by Yasir  Rahman on 11/03/2019 at 04:50 AM");
INSERT INTO crm_audit_log VALUES("4265","2","4","2019-03-11 05:29:21","Entry Invoice [Invoice No: 20650] updated by Yasir  Rahman on 11/03/2019 at 05:29 AM");
INSERT INTO crm_audit_log VALUES("4266","2","4","2019-03-11 05:32:00","Entry Invoice [Invoice No: 20651] updated by Yasir  Rahman on 11/03/2019 at 05:32 AM");
INSERT INTO crm_audit_log VALUES("4267","2","4","2019-03-11 05:35:08","Entry Invoice [Invoice No: 20652] updated by Yasir  Rahman on 11/03/2019 at 05:35 AM");
INSERT INTO crm_audit_log VALUES("4268","3","4","2019-03-11 07:46:59","Exit Invoice [Invoice No: 119093] updated by Yasir  Rahman on 11/03/2019 at 07:46 AM");
INSERT INTO crm_audit_log VALUES("4269","3","15","2019-03-11 12:00:51","Exit Invoice [Invoice No: 119094] updated by Abdul Rasheed on 11/03/2019 at 12:00 PM");
INSERT INTO crm_audit_log VALUES("4270","3","15","2019-03-11 12:59:33","Exit Invoice [Invoice No: 119095] updated by Abdul Rasheed on 11/03/2019 at 12:59 PM");
INSERT INTO crm_audit_log VALUES("4271","2","6","2019-03-11 14:45:49","Entry Invoice [Invoice No: 20653] updated by ASHRAF  M K on 11/03/2019 at 02:45 PM");
INSERT INTO crm_audit_log VALUES("4272","3","15","2019-03-11 14:59:42","Exit Invoice [Invoice No: 119096] updated by Abdul Rasheed on 11/03/2019 at 02:59 PM");
INSERT INTO crm_audit_log VALUES("4273","2","6","2019-03-11 15:36:43","Entry Invoice [Invoice No: 20654] updated by ASHRAF  M K on 11/03/2019 at 03:36 PM");
INSERT INTO crm_audit_log VALUES("4274","2","7","2019-03-11 15:40:36","Entry Invoice [Invoice No: 20655] updated by ALSED ABU SHAMA on 11/03/2019 at 03:40 PM");
INSERT INTO crm_audit_log VALUES("4275","2","7","2019-03-11 15:41:46","Entry Invoice [Invoice No: 20656] updated by ALSED ABU SHAMA on 11/03/2019 at 03:41 PM");
INSERT INTO crm_audit_log VALUES("4276","2","7","2019-03-11 15:42:41","Entry Invoice [Invoice No: 20657] updated by ALSED ABU SHAMA on 11/03/2019 at 03:42 PM");
INSERT INTO crm_audit_log VALUES("4277","2","7","2019-03-11 15:45:52","Entry Invoice [Invoice No: 20658] updated by ALSED ABU SHAMA on 11/03/2019 at 03:45 PM");
INSERT INTO crm_audit_log VALUES("4278","2","6","2019-03-11 15:47:40","Entry Invoice [Invoice No: 20653] updated by ASHRAF  M K on 11/03/2019 at 03:47 PM");
INSERT INTO crm_audit_log VALUES("4279","3","15","2019-03-11 15:56:00","Exit Invoice [Invoice No: 119097] updated by Abdul Rasheed on 11/03/2019 at 03:56 PM");
INSERT INTO crm_audit_log VALUES("4280","3","4","2019-03-11 17:08:58","Exit Invoice [Invoice No: 119098] updated by Yasir  Rahman on 11/03/2019 at 05:08 PM");
INSERT INTO crm_audit_log VALUES("4281","3","4","2019-03-11 17:11:34","Exit Invoice [Invoice No: 119099] updated by Yasir  Rahman on 11/03/2019 at 05:11 PM");
INSERT INTO crm_audit_log VALUES("4282","3","4","2019-03-11 17:14:20","Exit Invoice [Invoice No: 119100] updated by Yasir  Rahman on 11/03/2019 at 05:14 PM");
INSERT INTO crm_audit_log VALUES("4283","2","7","2019-03-11 17:45:10","Entry Invoice [Invoice No: 20659] updated by ALSED ABU SHAMA on 11/03/2019 at 05:45 PM");
INSERT INTO crm_audit_log VALUES("4284","3","4","2019-03-11 18:16:45","Exit Invoice [Invoice No: 119101] updated by Yasir  Rahman on 11/03/2019 at 06:16 PM");
INSERT INTO crm_audit_log VALUES("4285","3","6","2019-03-11 18:22:39","Exit Invoice [Invoice No: 119101] updated by ASHRAF  M K on 11/03/2019 at 06:22 PM");
INSERT INTO crm_audit_log VALUES("4286","3","4","2019-03-11 19:16:04","Exit Invoice [Invoice No: 119102] updated by Yasir  Rahman on 11/03/2019 at 07:16 PM");
INSERT INTO crm_audit_log VALUES("4287","2","7","2019-03-11 19:40:03","Entry Invoice [Invoice No: 20660] updated by ALSED ABU SHAMA on 11/03/2019 at 07:40 PM");
INSERT INTO crm_audit_log VALUES("4288","2","7","2019-03-11 20:18:02","Entry Invoice [Invoice No: 20661] updated by ALSED ABU SHAMA on 11/03/2019 at 08:18 PM");
INSERT INTO crm_audit_log VALUES("4289","3","5","2019-03-11 20:57:47","Exit Invoice [Invoice No: 119103] updated by Imran  Khan on 11/03/2019 at 08:57 PM");
INSERT INTO crm_audit_log VALUES("4290","3","5","2019-03-11 21:29:58","Exit Invoice [Invoice No: 119104] updated by Imran  Khan on 11/03/2019 at 09:29 PM");
INSERT INTO crm_audit_log VALUES("4291","3","5","2019-03-11 21:30:39","Exit Invoice [Invoice No: 119105] updated by Imran  Khan on 11/03/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("4292","2","4","2019-03-11 21:44:44","Entry Invoice [Invoice No: 20662] updated by Yasir  Rahman on 11/03/2019 at 09:44 PM");
INSERT INTO crm_audit_log VALUES("4293","3","5","2019-03-11 23:18:00","Exit Invoice [Invoice No: 119106] updated by Imran  Khan on 11/03/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("4294","3","5","2019-03-11 23:38:57","Exit Invoice [Invoice No: 119107] updated by Imran  Khan on 11/03/2019 at 11:38 PM");
INSERT INTO crm_audit_log VALUES("4295","3","5","2019-03-12 00:48:52","Exit Invoice [Invoice No: 119108] updated by Imran  Khan on 12/03/2019 at 12:48 AM");
INSERT INTO crm_audit_log VALUES("4296","2","4","2019-03-12 02:32:57","Entry Invoice [Invoice No: 20663] updated by Yasir  Rahman on 12/03/2019 at 02:32 AM");
INSERT INTO crm_audit_log VALUES("4297","3","5","2019-03-12 04:08:11","Exit Invoice [Invoice No: 119109] updated by Imran  Khan on 12/03/2019 at 04:08 AM");
INSERT INTO crm_audit_log VALUES("4298","3","5","2019-03-12 04:09:02","Exit Invoice [Invoice No: 119110] updated by Imran  Khan on 12/03/2019 at 04:09 AM");
INSERT INTO crm_audit_log VALUES("4299","3","5","2019-03-12 04:09:52","Exit Invoice [Invoice No: 119111] updated by Imran  Khan on 12/03/2019 at 04:09 AM");
INSERT INTO crm_audit_log VALUES("4300","3","5","2019-03-12 06:20:19","Exit Invoice [Invoice No: 119112] updated by Imran  Khan on 12/03/2019 at 06:20 AM");
INSERT INTO crm_audit_log VALUES("4301","2","6","2019-03-12 09:49:04","Entry Invoice [Invoice No: 20664] updated by ASHRAF  M K on 12/03/2019 at 09:49 AM");
INSERT INTO crm_audit_log VALUES("4302","2","6","2019-03-12 09:54:48","Entry Invoice [Invoice No: 20665] updated by ASHRAF  M K on 12/03/2019 at 09:54 AM");
INSERT INTO crm_audit_log VALUES("4303","2","6","2019-03-12 10:03:14","Entry Invoice [Invoice No: 20666] updated by ASHRAF  M K on 12/03/2019 at 10:03 AM");
INSERT INTO crm_audit_log VALUES("4304","2","6","2019-03-12 12:30:57","Entry Invoice [Invoice No: 20667] updated by ASHRAF  M K on 12/03/2019 at 12:30 PM");
INSERT INTO crm_audit_log VALUES("4305","2","6","2019-03-12 12:31:06","Entry Invoice [Invoice No: 20667] updated by ASHRAF  M K on 12/03/2019 at 12:31 PM");
INSERT INTO crm_audit_log VALUES("4306","2","6","2019-03-12 12:40:02","Entry Invoice [Invoice No: 20668] updated by ASHRAF  M K on 12/03/2019 at 12:40 PM");
INSERT INTO crm_audit_log VALUES("4307","2","6","2019-03-12 12:46:26","Entry Invoice [Invoice No: 20669] updated by ASHRAF  M K on 12/03/2019 at 12:46 PM");
INSERT INTO crm_audit_log VALUES("4308","2","6","2019-03-12 12:48:45","Entry Invoice [Invoice No: 20670] updated by ASHRAF  M K on 12/03/2019 at 12:48 PM");
INSERT INTO crm_audit_log VALUES("4309","2","6","2019-03-12 13:35:28","Entry Invoice [Invoice No: 20671] updated by ASHRAF  M K on 12/03/2019 at 01:35 PM");
INSERT INTO crm_audit_log VALUES("4310","2","6","2019-03-12 13:36:03","Entry Invoice [Invoice No: 20671] updated by ASHRAF  M K on 12/03/2019 at 01:36 PM");
INSERT INTO crm_audit_log VALUES("4311","2","6","2019-03-12 13:38:28","Entry Invoice [Invoice No: 20672] updated by ASHRAF  M K on 12/03/2019 at 01:38 PM");
INSERT INTO crm_audit_log VALUES("4312","2","6","2019-03-12 13:47:06","Entry Invoice [Invoice No: 20672] updated by ASHRAF  M K on 12/03/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("4313","3","4","2019-03-12 14:07:56","Exit Invoice [Invoice No: 119113] updated by Yasir  Rahman on 12/03/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("4314","3","4","2019-03-12 14:44:47","Exit Invoice [Invoice No: 119114] updated by Yasir  Rahman on 12/03/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("4315","3","4","2019-03-12 15:52:08","Exit Invoice [Invoice No: 119115] updated by Yasir  Rahman on 12/03/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("4316","3","4","2019-03-12 15:53:20","Exit Invoice [Invoice No: 119116] updated by Yasir  Rahman on 12/03/2019 at 03:53 PM");
INSERT INTO crm_audit_log VALUES("4317","3","4","2019-03-12 15:54:08","Exit Invoice [Invoice No: 119117] updated by Yasir  Rahman on 12/03/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("4318","3","4","2019-03-12 15:54:59","Exit Invoice [Invoice No: 119118] updated by Yasir  Rahman on 12/03/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("4319","3","4","2019-03-12 15:56:36","Exit Invoice [Invoice No: 119119] updated by Yasir  Rahman on 12/03/2019 at 03:56 PM");
INSERT INTO crm_audit_log VALUES("4320","3","4","2019-03-12 15:57:27","Exit Invoice [Invoice No: 119120] updated by Yasir  Rahman on 12/03/2019 at 03:57 PM");
INSERT INTO crm_audit_log VALUES("4321","2","7","2019-03-12 18:11:16","Entry Invoice [Invoice No: 20673] updated by ALSED ABU SHAMA on 12/03/2019 at 06:11 PM");
INSERT INTO crm_audit_log VALUES("4322","2","7","2019-03-12 18:17:13","Entry Invoice [Invoice No: 20674] updated by ALSED ABU SHAMA on 12/03/2019 at 06:17 PM");
INSERT INTO crm_audit_log VALUES("4323","3","15","2019-03-12 19:48:49","Exit Invoice [Invoice No: 119121] updated by Abdul Rasheed on 12/03/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("4324","3","15","2019-03-12 19:49:34","Exit Invoice [Invoice No: 119122] updated by Abdul Rasheed on 12/03/2019 at 07:49 PM");
INSERT INTO crm_audit_log VALUES("4325","2","4","2019-03-12 20:51:30","Entry Invoice [Invoice No: 20675] updated by Yasir  Rahman on 12/03/2019 at 08:51 PM");
INSERT INTO crm_audit_log VALUES("4326","3","15","2019-03-12 21:29:24","Exit Invoice [Invoice No: 119123] updated by Abdul Rasheed on 12/03/2019 at 09:29 PM");
INSERT INTO crm_audit_log VALUES("4327","3","15","2019-03-12 21:31:13","Exit Invoice [Invoice No: 119124] updated by Abdul Rasheed on 12/03/2019 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("4328","2","4","2019-03-12 22:03:51","Entry Invoice [Invoice No: 20676] updated by Yasir  Rahman on 12/03/2019 at 10:03 PM");
INSERT INTO crm_audit_log VALUES("4329","3","15","2019-03-12 22:20:44","Exit Invoice [Invoice No: 119125] updated by Abdul Rasheed on 12/03/2019 at 10:20 PM");
INSERT INTO crm_audit_log VALUES("4330","3","15","2019-03-12 22:21:33","Exit Invoice [Invoice No: 119126] updated by Abdul Rasheed on 12/03/2019 at 10:21 PM");
INSERT INTO crm_audit_log VALUES("4331","3","15","2019-03-12 22:24:13","Exit Invoice [Invoice No: 119127] updated by Abdul Rasheed on 12/03/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("4332","3","15","2019-03-12 22:31:17","Exit Invoice [Invoice No: 119128] updated by Abdul Rasheed on 12/03/2019 at 10:31 PM");
INSERT INTO crm_audit_log VALUES("4333","3","15","2019-03-12 23:13:05","Exit Invoice [Invoice No: 119129] updated by Abdul Rasheed on 12/03/2019 at 11:13 PM");
INSERT INTO crm_audit_log VALUES("4334","3","15","2019-03-13 00:16:43","Exit Invoice [Invoice No: 119130] updated by Abdul Rasheed on 13/03/2019 at 12:16 AM");
INSERT INTO crm_audit_log VALUES("4335","3","15","2019-03-13 00:17:43","Exit Invoice [Invoice No: 119131] updated by Abdul Rasheed on 13/03/2019 at 12:17 AM");
INSERT INTO crm_audit_log VALUES("4336","3","15","2019-03-13 00:50:24","Exit Invoice [Invoice No: 119132] updated by Abdul Rasheed on 13/03/2019 at 12:50 AM");
INSERT INTO crm_audit_log VALUES("4337","2","4","2019-03-13 01:24:16","Entry Invoice [Invoice No: 20677] updated by Yasir  Rahman on 13/03/2019 at 01:24 AM");
INSERT INTO crm_audit_log VALUES("4338","3","5","2019-03-13 02:31:08","Exit Invoice [Invoice No: 119133] updated by Imran  Khan on 13/03/2019 at 02:31 AM");
INSERT INTO crm_audit_log VALUES("4339","3","5","2019-03-13 02:33:51","Exit Invoice [Invoice No: 119134] updated by Imran  Khan on 13/03/2019 at 02:33 AM");
INSERT INTO crm_audit_log VALUES("4340","3","5","2019-03-13 02:35:43","Exit Invoice [Invoice No: 119135] updated by Imran  Khan on 13/03/2019 at 02:35 AM");
INSERT INTO crm_audit_log VALUES("4341","3","5","2019-03-13 02:37:28","Exit Invoice [Invoice No: 119136] updated by Imran  Khan on 13/03/2019 at 02:37 AM");
INSERT INTO crm_audit_log VALUES("4342","3","5","2019-03-13 02:39:57","Exit Invoice [Invoice No: 119137] updated by Imran  Khan on 13/03/2019 at 02:39 AM");
INSERT INTO crm_audit_log VALUES("4343","3","5","2019-03-13 02:40:44","Exit Invoice [Invoice No: 119138] updated by Imran  Khan on 13/03/2019 at 02:40 AM");
INSERT INTO crm_audit_log VALUES("4344","2","4","2019-03-13 05:48:00","Entry Invoice [Invoice No: 20678] updated by Yasir  Rahman on 13/03/2019 at 05:48 AM");
INSERT INTO crm_audit_log VALUES("4345","2","4","2019-03-13 05:49:45","Entry Invoice [Invoice No: 20679] updated by Yasir  Rahman on 13/03/2019 at 05:49 AM");
INSERT INTO crm_audit_log VALUES("4346","2","4","2019-03-13 07:43:21","Entry Invoice [Invoice No: 20680] updated by Yasir  Rahman on 13/03/2019 at 07:43 AM");
INSERT INTO crm_audit_log VALUES("4347","2","4","2019-03-13 07:44:18","Entry Invoice [Invoice No: 20681] updated by Yasir  Rahman on 13/03/2019 at 07:44 AM");
INSERT INTO crm_audit_log VALUES("4348","2","4","2019-03-13 07:45:15","Entry Invoice [Invoice No: 20682] updated by Yasir  Rahman on 13/03/2019 at 07:45 AM");
INSERT INTO crm_audit_log VALUES("4349","2","4","2019-03-13 07:47:02","Entry Invoice [Invoice No: 20683] updated by Yasir  Rahman on 13/03/2019 at 07:47 AM");
INSERT INTO crm_audit_log VALUES("4350","2","4","2019-03-13 07:48:22","Entry Invoice [Invoice No: 20684] updated by Yasir  Rahman on 13/03/2019 at 07:48 AM");
INSERT INTO crm_audit_log VALUES("4351","2","4","2019-03-13 07:49:33","Entry Invoice [Invoice No: 20685] updated by Yasir  Rahman on 13/03/2019 at 07:49 AM");
INSERT INTO crm_audit_log VALUES("4352","2","4","2019-03-13 07:51:25","Entry Invoice [Invoice No: 20686] updated by Yasir  Rahman on 13/03/2019 at 07:51 AM");
INSERT INTO crm_audit_log VALUES("4353","2","4","2019-03-13 07:53:45","Entry Invoice [Invoice No: 20687] updated by Yasir  Rahman on 13/03/2019 at 07:53 AM");
INSERT INTO crm_audit_log VALUES("4354","2","4","2019-03-13 07:54:42","Entry Invoice [Invoice No: 20688] updated by Yasir  Rahman on 13/03/2019 at 07:54 AM");
INSERT INTO crm_audit_log VALUES("4355","3","4","2019-03-13 10:12:55","Exit Invoice [Invoice No: 119139] updated by Yasir  Rahman on 13/03/2019 at 10:12 AM");
INSERT INTO crm_audit_log VALUES("4356","3","4","2019-03-13 10:13:56","Exit Invoice [Invoice No: 119140] updated by Yasir  Rahman on 13/03/2019 at 10:13 AM");
INSERT INTO crm_audit_log VALUES("4357","3","4","2019-03-13 10:33:17","Exit Invoice [Invoice No: 119141] updated by Yasir  Rahman on 13/03/2019 at 10:33 AM");
INSERT INTO crm_audit_log VALUES("4358","3","4","2019-03-13 10:36:06","Exit Invoice [Invoice No: 119142] updated by Yasir  Rahman on 13/03/2019 at 10:36 AM");
INSERT INTO crm_audit_log VALUES("4359","3","6","2019-03-13 10:39:34","Exit Invoice [Invoice No: 119141] updated by ASHRAF  M K on 13/03/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("4360","3","6","2019-03-13 10:39:50","Exit Invoice [Invoice No: 119142] updated by ASHRAF  M K on 13/03/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("4361","3","6","2019-03-13 10:40:29","Exit Invoice [Invoice No: 119142] updated by ASHRAF  M K on 13/03/2019 at 10:40 AM");
INSERT INTO crm_audit_log VALUES("4362","3","6","2019-03-13 10:41:08","Exit Invoice [Invoice No: 119131] updated by ASHRAF  M K on 13/03/2019 at 10:41 AM");
INSERT INTO crm_audit_log VALUES("4363","3","6","2019-03-13 10:41:19","Exit Invoice [Invoice No: 119130] updated by ASHRAF  M K on 13/03/2019 at 10:41 AM");
INSERT INTO crm_audit_log VALUES("4364","2","6","2019-03-13 10:59:42","Entry Invoice [Invoice No: 20689] updated by ASHRAF  M K on 13/03/2019 at 10:59 AM");
INSERT INTO crm_audit_log VALUES("4365","2","6","2019-03-13 11:01:45","Entry Invoice [Invoice No: 20690] updated by ASHRAF  M K on 13/03/2019 at 11:01 AM");
INSERT INTO crm_audit_log VALUES("4366","2","6","2019-03-13 11:06:28","Entry Invoice [Invoice No: 20691] updated by ASHRAF  M K on 13/03/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("4367","2","6","2019-03-13 12:22:06","Entry Invoice [Invoice No: 20692] updated by ASHRAF  M K on 13/03/2019 at 12:22 PM");
INSERT INTO crm_audit_log VALUES("4368","3","4","2019-03-13 12:37:58","Exit Invoice [Invoice No: 119143] updated by Yasir  Rahman on 13/03/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("4369","3","4","2019-03-13 12:38:50","Exit Invoice [Invoice No: 119144] updated by Yasir  Rahman on 13/03/2019 at 12:38 PM");
INSERT INTO crm_audit_log VALUES("4370","3","4","2019-03-13 12:41:38","Exit Invoice [Invoice No: 119145] updated by Yasir  Rahman on 13/03/2019 at 12:41 PM");
INSERT INTO crm_audit_log VALUES("4371","3","4","2019-03-13 12:43:26","Exit Invoice [Invoice No: 119146] updated by Yasir  Rahman on 13/03/2019 at 12:43 PM");
INSERT INTO crm_audit_log VALUES("4372","2","6","2019-03-13 13:51:27","Entry Invoice [Invoice No: 20693] updated by ASHRAF  M K on 13/03/2019 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("4373","3","4","2019-03-13 15:03:58","Exit Invoice [Invoice No: 119147] updated by Yasir  Rahman on 13/03/2019 at 03:03 PM");
INSERT INTO crm_audit_log VALUES("4374","2","6","2019-03-13 15:04:32","Entry Invoice [Invoice No: 20691] updated by ASHRAF  M K on 13/03/2019 at 03:04 PM");
INSERT INTO crm_audit_log VALUES("4375","3","4","2019-03-13 15:06:35","Exit Invoice [Invoice No: 119148] updated by Yasir  Rahman on 13/03/2019 at 03:06 PM");
INSERT INTO crm_audit_log VALUES("4376","3","6","2019-03-13 15:10:34","Exit Invoice [Invoice No: 119145] updated by ASHRAF  M K on 13/03/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("4377","2","6","2019-03-13 15:47:33","Entry Invoice [Invoice No: 20694] updated by ASHRAF  M K on 13/03/2019 at 03:47 PM");
INSERT INTO crm_audit_log VALUES("4378","2","7","2019-03-13 16:44:03","Entry Invoice [Invoice No: 20695] updated by ALSED ABU SHAMA on 13/03/2019 at 04:44 PM");
INSERT INTO crm_audit_log VALUES("4379","3","15","2019-03-13 16:59:01","Exit Invoice [Invoice No: 119149] updated by Abdul Rasheed on 13/03/2019 at 04:59 PM");
INSERT INTO crm_audit_log VALUES("4380","3","15","2019-03-13 17:01:29","Exit Invoice [Invoice No: 119150] updated by Abdul Rasheed on 13/03/2019 at 05:01 PM");
INSERT INTO crm_audit_log VALUES("4381","2","7","2019-03-13 17:43:12","Entry Invoice [Invoice No: 20696] updated by ALSED ABU SHAMA on 13/03/2019 at 05:43 PM");
INSERT INTO crm_audit_log VALUES("4382","3","15","2019-03-13 21:00:28","Exit Invoice [Invoice No: 119151] updated by Abdul Rasheed on 13/03/2019 at 09:00 PM");
INSERT INTO crm_audit_log VALUES("4383","2","4","2019-03-13 21:04:50","Entry Invoice [Invoice No: 20697] updated by Yasir  Rahman on 13/03/2019 at 09:04 PM");
INSERT INTO crm_audit_log VALUES("4384","3","15","2019-03-13 21:16:42","Exit Invoice [Invoice No: 119152] updated by Abdul Rasheed on 13/03/2019 at 09:16 PM");
INSERT INTO crm_audit_log VALUES("4385","2","4","2019-03-13 21:16:43","Entry Invoice [Invoice No: 20698] updated by Yasir  Rahman on 13/03/2019 at 09:16 PM");
INSERT INTO crm_audit_log VALUES("4386","3","15","2019-03-13 21:32:25","Exit Invoice [Invoice No: 119153] updated by Abdul Rasheed on 13/03/2019 at 09:32 PM");
INSERT INTO crm_audit_log VALUES("4387","3","15","2019-03-13 23:07:01","Exit Invoice [Invoice No: 119154] updated by Abdul Rasheed on 13/03/2019 at 11:07 PM");
INSERT INTO crm_audit_log VALUES("4388","3","6","2019-03-13 23:32:10","Exit Invoice [Invoice No: 119147] updated by ASHRAF  M K on 13/03/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("4389","3","6","2019-03-13 23:32:47","Exit Invoice [Invoice No: 119148] updated by ASHRAF  M K on 13/03/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("4390","2","4","2019-03-14 02:40:41","Entry Invoice [Invoice No: 20699] updated by Yasir  Rahman on 14/03/2019 at 02:40 AM");
INSERT INTO crm_audit_log VALUES("4391","2","4","2019-03-14 02:42:47","Entry Invoice [Invoice No: 20700] updated by Yasir  Rahman on 14/03/2019 at 02:42 AM");
INSERT INTO crm_audit_log VALUES("4392","2","4","2019-03-14 02:44:27","Entry Invoice [Invoice No: 20701] updated by Yasir  Rahman on 14/03/2019 at 02:44 AM");
INSERT INTO crm_audit_log VALUES("4393","3","5","2019-03-14 03:56:17","Exit Invoice [Invoice No: 119155] updated by Imran  Khan on 14/03/2019 at 03:56 AM");
INSERT INTO crm_audit_log VALUES("4394","3","5","2019-03-14 04:20:07","Exit Invoice [Invoice No: 119156] updated by Imran  Khan on 14/03/2019 at 04:20 AM");
INSERT INTO crm_audit_log VALUES("4395","3","5","2019-03-14 06:11:53","Exit Invoice [Invoice No: 119157] updated by Imran  Khan on 14/03/2019 at 06:11 AM");
INSERT INTO crm_audit_log VALUES("4396","3","5","2019-03-14 06:12:29","Exit Invoice [Invoice No: 119158] updated by Imran  Khan on 14/03/2019 at 06:12 AM");
INSERT INTO crm_audit_log VALUES("4397","3","5","2019-03-14 06:15:28","Exit Invoice [Invoice No: 119159] updated by Imran  Khan on 14/03/2019 at 06:15 AM");
INSERT INTO crm_audit_log VALUES("4398","3","4","2019-03-14 09:07:53","Exit Invoice [Invoice No: 119160] updated by Yasir  Rahman on 14/03/2019 at 09:07 AM");
INSERT INTO crm_audit_log VALUES("4399","3","4","2019-03-14 10:42:36","Exit Invoice [Invoice No: 119161] updated by Yasir  Rahman on 14/03/2019 at 10:42 AM");
INSERT INTO crm_audit_log VALUES("4400","2","6","2019-03-14 11:31:48","Entry Invoice [Invoice No: 20702] updated by ASHRAF  M K on 14/03/2019 at 11:31 AM");
INSERT INTO crm_audit_log VALUES("4401","2","6","2019-03-14 12:23:40","Entry Invoice [Invoice No: 20703] updated by ASHRAF  M K on 14/03/2019 at 12:23 PM");
INSERT INTO crm_audit_log VALUES("4402","3","4","2019-03-14 13:44:33","Exit Invoice [Invoice No: 119162] updated by Yasir  Rahman on 14/03/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("4403","2","6","2019-03-14 14:34:29","Entry Invoice [Invoice No: 20704] updated by ASHRAF  M K on 14/03/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("4404","2","6","2019-03-14 14:34:58","Entry Invoice [Invoice No: 20704] updated by ASHRAF  M K on 14/03/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("4405","2","6","2019-03-14 14:35:38","Entry Invoice [Invoice No: 20704] updated by ASHRAF  M K on 14/03/2019 at 02:35 PM");
INSERT INTO crm_audit_log VALUES("4406","3","15","2019-03-14 17:45:28","Exit Invoice [Invoice No: 119163] updated by Abdul Rasheed on 14/03/2019 at 05:45 PM");
INSERT INTO crm_audit_log VALUES("4407","3","15","2019-03-14 17:46:56","Exit Invoice [Invoice No: 119164] updated by Abdul Rasheed on 14/03/2019 at 05:46 PM");
INSERT INTO crm_audit_log VALUES("4408","3","15","2019-03-14 17:47:53","Exit Invoice [Invoice No: 119165] updated by Abdul Rasheed on 14/03/2019 at 05:47 PM");
INSERT INTO crm_audit_log VALUES("4409","3","15","2019-03-14 19:11:21","Exit Invoice [Invoice No: 119166] updated by Abdul Rasheed on 14/03/2019 at 07:11 PM");
INSERT INTO crm_audit_log VALUES("4410","2","7","2019-03-14 19:48:29","Entry Invoice [Invoice No: 20705] updated by ALSED ABU SHAMA on 14/03/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("4411","3","15","2019-03-14 19:56:11","Exit Invoice [Invoice No: 119167] updated by Abdul Rasheed on 14/03/2019 at 07:56 PM");
INSERT INTO crm_audit_log VALUES("4412","2","7","2019-03-14 20:19:46","Entry Invoice [Invoice No: 20706] updated by ALSED ABU SHAMA on 14/03/2019 at 08:19 PM");
INSERT INTO crm_audit_log VALUES("4413","2","7","2019-03-14 20:21:06","Entry Invoice [Invoice No: 20707] updated by ALSED ABU SHAMA on 14/03/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("4414","2","7","2019-03-14 20:21:59","Entry Invoice [Invoice No: 20708] updated by ALSED ABU SHAMA on 14/03/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("4415","2","7","2019-03-14 20:22:39","Entry Invoice [Invoice No: 20709] updated by ALSED ABU SHAMA on 14/03/2019 at 08:22 PM");
INSERT INTO crm_audit_log VALUES("4416","2","7","2019-03-14 20:23:50","Entry Invoice [Invoice No: 20710] updated by ALSED ABU SHAMA on 14/03/2019 at 08:23 PM");
INSERT INTO crm_audit_log VALUES("4417","3","15","2019-03-14 20:39:11","Exit Invoice [Invoice No: 119168] updated by Abdul Rasheed on 14/03/2019 at 08:39 PM");
INSERT INTO crm_audit_log VALUES("4418","3","15","2019-03-14 20:42:20","Exit Invoice [Invoice No: 119169] updated by Abdul Rasheed on 14/03/2019 at 08:42 PM");
INSERT INTO crm_audit_log VALUES("4419","3","6","2019-03-14 20:43:27","Exit Invoice [Invoice No: 119169] updated by ASHRAF  M K on 14/03/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("4420","3","5","2019-03-15 01:07:49","Exit Invoice [Invoice No: 119170] updated by Imran  Khan on 15/03/2019 at 01:07 AM");
INSERT INTO crm_audit_log VALUES("4421","3","5","2019-03-15 01:08:22","Exit Invoice [Invoice No: 119171] updated by Imran  Khan on 15/03/2019 at 01:08 AM");
INSERT INTO crm_audit_log VALUES("4422","2","4","2019-03-15 01:44:33","Entry Invoice [Invoice No: 20711] updated by Yasir  Rahman on 15/03/2019 at 01:44 AM");
INSERT INTO crm_audit_log VALUES("4423","3","5","2019-03-15 01:48:41","Exit Invoice [Invoice No: 119172] updated by Imran  Khan on 15/03/2019 at 01:48 AM");
INSERT INTO crm_audit_log VALUES("4424","2","4","2019-03-15 02:07:14","Entry Invoice [Invoice No: 20712] updated by Yasir  Rahman on 15/03/2019 at 02:07 AM");
INSERT INTO crm_audit_log VALUES("4425","2","4","2019-03-15 02:24:21","Entry Invoice [Invoice No: 20713] updated by Yasir  Rahman on 15/03/2019 at 02:24 AM");
INSERT INTO crm_audit_log VALUES("4426","3","5","2019-03-15 03:52:52","Exit Invoice [Invoice No: 119173] updated by Imran  Khan on 15/03/2019 at 03:52 AM");
INSERT INTO crm_audit_log VALUES("4427","3","5","2019-03-15 03:58:25","Exit Invoice [Invoice No: 119174] updated by Imran  Khan on 15/03/2019 at 03:58 AM");
INSERT INTO crm_audit_log VALUES("4428","2","4","2019-03-15 06:45:54","Entry Invoice [Invoice No: 20714] updated by Yasir  Rahman on 15/03/2019 at 06:45 AM");
INSERT INTO crm_audit_log VALUES("4429","2","4","2019-03-15 06:47:31","Entry Invoice [Invoice No: 20715] updated by Yasir  Rahman on 15/03/2019 at 06:47 AM");
INSERT INTO crm_audit_log VALUES("4430","2","4","2019-03-15 06:50:09","Entry Invoice [Invoice No: 20716] updated by Yasir  Rahman on 15/03/2019 at 06:50 AM");
INSERT INTO crm_audit_log VALUES("4431","2","4","2019-03-15 07:02:15","Entry Invoice [Invoice No: 20717] updated by Yasir  Rahman on 15/03/2019 at 07:02 AM");
INSERT INTO crm_audit_log VALUES("4432","2","4","2019-03-15 07:03:37","Entry Invoice [Invoice No: 20718] updated by Yasir  Rahman on 15/03/2019 at 07:03 AM");
INSERT INTO crm_audit_log VALUES("4433","2","4","2019-03-15 07:08:25","Entry Invoice [Invoice No: 20719] updated by Yasir  Rahman on 15/03/2019 at 07:08 AM");
INSERT INTO crm_audit_log VALUES("4434","2","4","2019-03-15 07:32:59","Entry Invoice [Invoice No: 20720] updated by Yasir  Rahman on 15/03/2019 at 07:32 AM");
INSERT INTO crm_audit_log VALUES("4435","3","4","2019-03-15 09:37:07","Exit Invoice [Invoice No: 119175] updated by Yasir  Rahman on 15/03/2019 at 09:37 AM");
INSERT INTO crm_audit_log VALUES("4436","3","4","2019-03-15 09:38:10","Exit Invoice [Invoice No: 119176] updated by Yasir  Rahman on 15/03/2019 at 09:38 AM");
INSERT INTO crm_audit_log VALUES("4437","3","4","2019-03-15 09:39:45","Exit Invoice [Invoice No: 119177] updated by Yasir  Rahman on 15/03/2019 at 09:39 AM");
INSERT INTO crm_audit_log VALUES("4438","3","4","2019-03-15 09:40:51","Exit Invoice [Invoice No: 119178] updated by Yasir  Rahman on 15/03/2019 at 09:40 AM");
INSERT INTO crm_audit_log VALUES("4439","2","7","2019-03-15 10:23:15","Entry Invoice [Invoice No: 20721] updated by ALSED ABU SHAMA on 15/03/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("4440","3","4","2019-03-15 10:47:36","Exit Invoice [Invoice No: 119179] updated by Yasir  Rahman on 15/03/2019 at 10:47 AM");
INSERT INTO crm_audit_log VALUES("4441","3","4","2019-03-15 14:18:29","Exit Invoice [Invoice No: 119180] updated by Yasir  Rahman on 15/03/2019 at 02:18 PM");
INSERT INTO crm_audit_log VALUES("4442","3","4","2019-03-15 14:19:55","Exit Invoice [Invoice No: 119181] updated by Yasir  Rahman on 15/03/2019 at 02:19 PM");
INSERT INTO crm_audit_log VALUES("4443","3","4","2019-03-15 14:21:44","Exit Invoice [Invoice No: 119182] updated by Yasir  Rahman on 15/03/2019 at 02:21 PM");
INSERT INTO crm_audit_log VALUES("4444","3","4","2019-03-15 14:23:49","Exit Invoice [Invoice No: 119183] updated by Yasir  Rahman on 15/03/2019 at 02:23 PM");
INSERT INTO crm_audit_log VALUES("4445","3","4","2019-03-15 15:30:50","Exit Invoice [Invoice No: 119184] updated by Yasir  Rahman on 15/03/2019 at 03:30 PM");
INSERT INTO crm_audit_log VALUES("4446","3","4","2019-03-15 15:45:20","Exit Invoice [Invoice No: 119185] updated by Yasir  Rahman on 15/03/2019 at 03:45 PM");
INSERT INTO crm_audit_log VALUES("4447","3","4","2019-03-15 15:49:09","Exit Invoice [Invoice No: 119186] updated by Yasir  Rahman on 15/03/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("4448","2","7","2019-03-15 16:39:40","Entry Invoice [Invoice No: 20722] updated by ALSED ABU SHAMA on 15/03/2019 at 04:39 PM");
INSERT INTO crm_audit_log VALUES("4449","2","7","2019-03-15 16:43:34","Entry Invoice [Invoice No: 20723] updated by ALSED ABU SHAMA on 15/03/2019 at 04:43 PM");
INSERT INTO crm_audit_log VALUES("4450","3","15","2019-03-15 18:01:46","Exit Invoice [Invoice No: 119187] updated by Abdul Rasheed on 15/03/2019 at 06:01 PM");
INSERT INTO crm_audit_log VALUES("4451","2","7","2019-03-15 18:58:11","Entry Invoice [Invoice No: 20724] updated by ALSED ABU SHAMA on 15/03/2019 at 06:58 PM");
INSERT INTO crm_audit_log VALUES("4452","2","7","2019-03-15 19:47:09","Entry Invoice [Invoice No: 20725] updated by ALSED ABU SHAMA on 15/03/2019 at 07:47 PM");
INSERT INTO crm_audit_log VALUES("4453","3","15","2019-03-15 19:48:02","Exit Invoice [Invoice No: 119188] updated by Abdul Rasheed on 15/03/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("4454","3","15","2019-03-15 20:51:46","Exit Invoice [Invoice No: 119189] updated by Abdul Rasheed on 15/03/2019 at 08:51 PM");
INSERT INTO crm_audit_log VALUES("4455","3","15","2019-03-15 20:52:48","Exit Invoice [Invoice No: 119190] updated by Abdul Rasheed on 15/03/2019 at 08:52 PM");
INSERT INTO crm_audit_log VALUES("4456","3","15","2019-03-15 21:31:23","Exit Invoice [Invoice No: 119191] updated by Abdul Rasheed on 15/03/2019 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("4457","3","15","2019-03-15 22:10:39","Exit Invoice [Invoice No: 119192] updated by Abdul Rasheed on 15/03/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("4458","2","4","2019-03-15 22:27:12","Entry Invoice [Invoice No: 20726] updated by Yasir  Rahman on 15/03/2019 at 10:27 PM");
INSERT INTO crm_audit_log VALUES("4459","2","4","2019-03-15 22:34:39","Entry Invoice [Invoice No: 20727] updated by Yasir  Rahman on 15/03/2019 at 10:34 PM");
INSERT INTO crm_audit_log VALUES("4460","3","15","2019-03-15 22:46:24","Exit Invoice [Invoice No: 119193] updated by Abdul Rasheed on 15/03/2019 at 10:46 PM");
INSERT INTO crm_audit_log VALUES("4461","1","15","2019-03-15 22:49:49","Customer [Customer No: 37] updated by Abdul Rasheed on 15/03/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("4462","2","4","2019-03-16 00:55:09","Entry Invoice [Invoice No: 20728] updated by Yasir  Rahman on 16/03/2019 at 12:55 AM");
INSERT INTO crm_audit_log VALUES("4463","2","4","2019-03-16 01:01:22","Entry Invoice [Invoice No: 20729] updated by Yasir  Rahman on 16/03/2019 at 01:01 AM");
INSERT INTO crm_audit_log VALUES("4464","2","4","2019-03-16 01:03:31","Entry Invoice [Invoice No: 20730] updated by Yasir  Rahman on 16/03/2019 at 01:03 AM");
INSERT INTO crm_audit_log VALUES("4465","2","4","2019-03-16 01:05:40","Entry Invoice [Invoice No: 20731] updated by Yasir  Rahman on 16/03/2019 at 01:05 AM");
INSERT INTO crm_audit_log VALUES("4466","2","4","2019-03-16 01:08:21","Entry Invoice [Invoice No: 20732] updated by Yasir  Rahman on 16/03/2019 at 01:08 AM");
INSERT INTO crm_audit_log VALUES("4467","2","4","2019-03-16 02:30:52","Entry Invoice [Invoice No: 20733] updated by Yasir  Rahman on 16/03/2019 at 02:30 AM");
INSERT INTO crm_audit_log VALUES("4468","2","4","2019-03-16 03:00:34","Entry Invoice [Invoice No: 20734] updated by Yasir  Rahman on 16/03/2019 at 03:00 AM");
INSERT INTO crm_audit_log VALUES("4469","2","4","2019-03-16 03:13:02","Entry Invoice [Invoice No: 20735] updated by Yasir  Rahman on 16/03/2019 at 03:13 AM");
INSERT INTO crm_audit_log VALUES("4470","3","5","2019-03-16 05:34:43","Exit Invoice [Invoice No: 119194] updated by Imran  Khan on 16/03/2019 at 05:34 AM");
INSERT INTO crm_audit_log VALUES("4471","3","5","2019-03-16 05:38:27","Exit Invoice [Invoice No: 119195] updated by Imran  Khan on 16/03/2019 at 05:38 AM");
INSERT INTO crm_audit_log VALUES("4472","3","5","2019-03-16 06:43:39","Exit Invoice [Invoice No: 119196] updated by Imran  Khan on 16/03/2019 at 06:43 AM");
INSERT INTO crm_audit_log VALUES("4473","2","6","2019-03-16 10:29:58","Entry Invoice [Invoice No: 20736] updated by ASHRAF  M K on 16/03/2019 at 10:29 AM");
INSERT INTO crm_audit_log VALUES("4474","2","7","2019-03-16 13:39:12","Entry Invoice [Invoice No: 20737] updated by ALSED ABU SHAMA on 16/03/2019 at 01:39 PM");
INSERT INTO crm_audit_log VALUES("4475","3","15","2019-03-16 16:55:04","Exit Invoice [Invoice No: 119197] updated by Abdul Rasheed on 16/03/2019 at 04:55 PM");
INSERT INTO crm_audit_log VALUES("4476","3","15","2019-03-16 18:01:44","Exit Invoice [Invoice No: 119198] updated by Abdul Rasheed on 16/03/2019 at 06:01 PM");
INSERT INTO crm_audit_log VALUES("4477","2","7","2019-03-16 18:20:22","Entry Invoice [Invoice No: 20738] updated by ALSED ABU SHAMA on 16/03/2019 at 06:20 PM");
INSERT INTO crm_audit_log VALUES("4478","3","15","2019-03-16 18:50:50","Exit Invoice [Invoice No: 119199] updated by Abdul Rasheed on 16/03/2019 at 06:50 PM");
INSERT INTO crm_audit_log VALUES("4479","3","15","2019-03-16 19:29:55","Exit Invoice [Invoice No: 119200] updated by Abdul Rasheed on 16/03/2019 at 07:29 PM");
INSERT INTO crm_audit_log VALUES("4480","3","15","2019-03-16 20:12:00","Exit Invoice [Invoice No: 119201] updated by Abdul Rasheed on 16/03/2019 at 08:12 PM");
INSERT INTO crm_audit_log VALUES("4481","2","4","2019-03-16 20:29:32","Entry Invoice [Invoice No: 20739] updated by Yasir  Rahman on 16/03/2019 at 08:29 PM");
INSERT INTO crm_audit_log VALUES("4482","2","4","2019-03-16 23:00:25","Entry Invoice [Invoice No: 20740] updated by Yasir  Rahman on 16/03/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("4483","2","4","2019-03-16 23:23:36","Entry Invoice [Invoice No: 20741] updated by Yasir  Rahman on 16/03/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("4484","3","15","2019-03-16 23:25:01","Exit Invoice [Invoice No: 119202] updated by Abdul Rasheed on 16/03/2019 at 11:25 PM");
INSERT INTO crm_audit_log VALUES("4485","3","5","2019-03-17 00:15:15","Exit Invoice [Invoice No: 119203] updated by Imran  Khan on 17/03/2019 at 12:15 AM");
INSERT INTO crm_audit_log VALUES("4486","2","4","2019-03-17 01:11:14","Entry Invoice [Invoice No: 20742] updated by Yasir  Rahman on 17/03/2019 at 01:11 AM");
INSERT INTO crm_audit_log VALUES("4487","2","4","2019-03-17 02:16:38","Entry Invoice [Invoice No: 20743] updated by Yasir  Rahman on 17/03/2019 at 02:16 AM");
INSERT INTO crm_audit_log VALUES("4488","2","4","2019-03-17 03:16:07","Entry Invoice [Invoice No: 20744] updated by Yasir  Rahman on 17/03/2019 at 03:16 AM");
INSERT INTO crm_audit_log VALUES("4489","3","5","2019-03-17 03:51:10","Exit Invoice [Invoice No: 119204] updated by Imran  Khan on 17/03/2019 at 03:51 AM");
INSERT INTO crm_audit_log VALUES("4490","3","5","2019-03-17 04:46:40","Exit Invoice [Invoice No: 119205] updated by Imran  Khan on 17/03/2019 at 04:46 AM");
INSERT INTO crm_audit_log VALUES("4491","2","4","2019-03-17 06:37:46","Entry Invoice [Invoice No: 20745] updated by Yasir  Rahman on 17/03/2019 at 06:37 AM");
INSERT INTO crm_audit_log VALUES("4492","3","4","2019-03-17 08:39:07","Exit Invoice [Invoice No: 119206] updated by Yasir  Rahman on 17/03/2019 at 08:39 AM");
INSERT INTO crm_audit_log VALUES("4493","3","6","2019-03-17 08:46:08","Exit Invoice [Invoice No: 119206] updated by ASHRAF  M K on 17/03/2019 at 08:46 AM");
INSERT INTO crm_audit_log VALUES("4494","2","6","2019-03-17 10:00:41","Entry Invoice [Invoice No: 20746] updated by ASHRAF  M K on 17/03/2019 at 10:00 AM");
INSERT INTO crm_audit_log VALUES("4495","2","6","2019-03-17 10:07:09","Entry Invoice [Invoice No: 20747] updated by ASHRAF  M K on 17/03/2019 at 10:07 AM");
INSERT INTO crm_audit_log VALUES("4496","2","6","2019-03-17 10:20:34","Entry Invoice [Invoice No: 20748] updated by ASHRAF  M K on 17/03/2019 at 10:20 AM");
INSERT INTO crm_audit_log VALUES("4497","3","4","2019-03-17 10:34:26","Exit Invoice [Invoice No: 119207] updated by Yasir  Rahman on 17/03/2019 at 10:34 AM");
INSERT INTO crm_audit_log VALUES("4498","2","7","2019-03-17 11:43:22","Entry Invoice [Invoice No: 20749] updated by ALSED ABU SHAMA on 17/03/2019 at 11:43 AM");
INSERT INTO crm_audit_log VALUES("4499","2","7","2019-03-17 11:56:55","Entry Invoice [Invoice No: 20750] updated by ALSED ABU SHAMA on 17/03/2019 at 11:56 AM");
INSERT INTO crm_audit_log VALUES("4500","3","4","2019-03-17 12:21:21","Exit Invoice [Invoice No: 119208] updated by Yasir  Rahman on 17/03/2019 at 12:21 PM");
INSERT INTO crm_audit_log VALUES("4501","2","7","2019-03-17 15:23:07","Entry Invoice [Invoice No: 20751] updated by ALSED ABU SHAMA on 17/03/2019 at 03:23 PM");
INSERT INTO crm_audit_log VALUES("4502","3","15","2019-03-17 16:54:57","Exit Invoice [Invoice No: 119209] updated by Abdul Rasheed on 17/03/2019 at 04:54 PM");
INSERT INTO crm_audit_log VALUES("4503","2","7","2019-03-17 17:25:02","Entry Invoice [Invoice No: 20752] updated by ALSED ABU SHAMA on 17/03/2019 at 05:25 PM");
INSERT INTO crm_audit_log VALUES("4504","2","7","2019-03-17 18:53:18","Entry Invoice [Invoice No: 20753] updated by ALSED ABU SHAMA on 17/03/2019 at 06:53 PM");
INSERT INTO crm_audit_log VALUES("4505","2","7","2019-03-17 18:55:38","Entry Invoice [Invoice No: 20754] updated by ALSED ABU SHAMA on 17/03/2019 at 06:55 PM");
INSERT INTO crm_audit_log VALUES("4506","2","4","2019-03-17 20:41:49","Entry Invoice [Invoice No: 20755] updated by Yasir  Rahman on 17/03/2019 at 08:41 PM");
INSERT INTO crm_audit_log VALUES("4507","2","4","2019-03-17 20:43:33","Entry Invoice [Invoice No: 20756] updated by Yasir  Rahman on 17/03/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("4508","2","4","2019-03-17 20:44:58","Entry Invoice [Invoice No: 20757] updated by Yasir  Rahman on 17/03/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("4509","2","4","2019-03-17 22:05:46","Entry Invoice [Invoice No: 20758] updated by Yasir  Rahman on 17/03/2019 at 10:05 PM");
INSERT INTO crm_audit_log VALUES("4510","2","4","2019-03-17 22:06:43","Entry Invoice [Invoice No: 20759] updated by Yasir  Rahman on 17/03/2019 at 10:06 PM");
INSERT INTO crm_audit_log VALUES("4511","3","15","2019-03-17 22:10:35","Exit Invoice [Invoice No: 119210] updated by Abdul Rasheed on 17/03/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("4512","3","15","2019-03-17 22:11:31","Exit Invoice [Invoice No: 119211] updated by Abdul Rasheed on 17/03/2019 at 10:11 PM");
INSERT INTO crm_audit_log VALUES("4513","3","15","2019-03-17 22:36:32","Exit Invoice [Invoice No: 119212] updated by Abdul Rasheed on 17/03/2019 at 10:36 PM");
INSERT INTO crm_audit_log VALUES("4514","3","15","2019-03-17 22:37:21","Exit Invoice [Invoice No: 119213] updated by Abdul Rasheed on 17/03/2019 at 10:37 PM");
INSERT INTO crm_audit_log VALUES("4515","3","15","2019-03-17 23:14:13","Exit Invoice [Invoice No: 119214] updated by Abdul Rasheed on 17/03/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("4516","3","5","2019-03-18 00:21:03","Exit Invoice [Invoice No: 119215] updated by Imran  Khan on 18/03/2019 at 12:21 AM");
INSERT INTO crm_audit_log VALUES("4517","3","5","2019-03-18 02:08:33","Exit Invoice [Invoice No: 119216] updated by Imran  Khan on 18/03/2019 at 02:08 AM");
INSERT INTO crm_audit_log VALUES("4518","2","4","2019-03-18 02:32:17","Entry Invoice [Invoice No: 20760] updated by Yasir  Rahman on 18/03/2019 at 02:32 AM");
INSERT INTO crm_audit_log VALUES("4519","3","5","2019-03-18 04:03:46","Exit Invoice [Invoice No: 119217] updated by Imran  Khan on 18/03/2019 at 04:03 AM");
INSERT INTO crm_audit_log VALUES("4520","2","4","2019-03-18 04:56:48","Entry Invoice [Invoice No: 20761] updated by Yasir  Rahman on 18/03/2019 at 04:56 AM");
INSERT INTO crm_audit_log VALUES("4521","2","4","2019-03-18 04:58:13","Entry Invoice [Invoice No: 20762] updated by Yasir  Rahman on 18/03/2019 at 04:58 AM");
INSERT INTO crm_audit_log VALUES("4522","2","4","2019-03-18 05:00:27","Entry Invoice [Invoice No: 20763] updated by Yasir  Rahman on 18/03/2019 at 05:00 AM");
INSERT INTO crm_audit_log VALUES("4523","3","4","2019-03-18 09:16:44","Exit Invoice [Invoice No: 119218] updated by Yasir  Rahman on 18/03/2019 at 09:16 AM");
INSERT INTO crm_audit_log VALUES("4524","3","4","2019-03-18 09:28:06","Exit Invoice [Invoice No: 119219] updated by Yasir  Rahman on 18/03/2019 at 09:28 AM");
INSERT INTO crm_audit_log VALUES("4525","3","4","2019-03-18 09:53:25","Exit Invoice [Invoice No: 119220] updated by Yasir  Rahman on 18/03/2019 at 09:53 AM");
INSERT INTO crm_audit_log VALUES("4526","3","4","2019-03-18 09:54:48","Exit Invoice [Invoice No: 119221] updated by Yasir  Rahman on 18/03/2019 at 09:54 AM");
INSERT INTO crm_audit_log VALUES("4527","2","6","2019-03-18 11:53:37","Entry Invoice [Invoice No: 20764] updated by ASHRAF  M K on 18/03/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("4528","3","4","2019-03-18 11:53:59","Exit Invoice [Invoice No: 119222] updated by Yasir  Rahman on 18/03/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("4529","3","4","2019-03-18 13:15:58","Exit Invoice [Invoice No: 119223] updated by Yasir  Rahman on 18/03/2019 at 01:15 PM");
INSERT INTO crm_audit_log VALUES("4530","3","4","2019-03-18 14:00:56","Exit Invoice [Invoice No: 119224] updated by Yasir  Rahman on 18/03/2019 at 02:00 PM");
INSERT INTO crm_audit_log VALUES("4531","3","15","2019-03-18 16:05:16","Exit Invoice [Invoice No: 119225] updated by Abdul Rasheed on 18/03/2019 at 04:05 PM");
INSERT INTO crm_audit_log VALUES("4532","2","7","2019-03-18 17:04:34","Entry Invoice [Invoice No: 20765] updated by ALSED ABU SHAMA on 18/03/2019 at 05:04 PM");
INSERT INTO crm_audit_log VALUES("4533","2","7","2019-03-18 17:07:22","Entry Invoice [Invoice No: 20766] updated by ALSED ABU SHAMA on 18/03/2019 at 05:07 PM");
INSERT INTO crm_audit_log VALUES("4534","2","7","2019-03-18 17:54:27","Entry Invoice [Invoice No: 20767] updated by ALSED ABU SHAMA on 18/03/2019 at 05:54 PM");
INSERT INTO crm_audit_log VALUES("4535","3","15","2019-03-18 18:25:20","Exit Invoice [Invoice No: 119226] updated by Abdul Rasheed on 18/03/2019 at 06:25 PM");
INSERT INTO crm_audit_log VALUES("4536","3","15","2019-03-18 18:25:58","Exit Invoice [Invoice No: 119227] updated by Abdul Rasheed on 18/03/2019 at 06:25 PM");
INSERT INTO crm_audit_log VALUES("4537","3","15","2019-03-18 18:26:36","Exit Invoice [Invoice No: 119228] updated by Abdul Rasheed on 18/03/2019 at 06:26 PM");
INSERT INTO crm_audit_log VALUES("4538","2","7","2019-03-18 18:49:06","Entry Invoice [Invoice No: 20768] updated by ALSED ABU SHAMA on 18/03/2019 at 06:49 PM");
INSERT INTO crm_audit_log VALUES("4539","3","15","2019-03-18 20:41:03","Exit Invoice [Invoice No: 119229] updated by Abdul Rasheed on 18/03/2019 at 08:41 PM");
INSERT INTO crm_audit_log VALUES("4540","3","15","2019-03-18 20:43:25","Exit Invoice [Invoice No: 119230] updated by Abdul Rasheed on 18/03/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("4541","3","15","2019-03-18 21:32:21","Exit Invoice [Invoice No: 119231] updated by Abdul Rasheed on 18/03/2019 at 09:32 PM");
INSERT INTO crm_audit_log VALUES("4542","2","4","2019-03-18 22:11:48","Entry Invoice [Invoice No: 20769] updated by Yasir  Rahman on 18/03/2019 at 10:11 PM");
INSERT INTO crm_audit_log VALUES("4543","3","15","2019-03-18 22:47:51","Exit Invoice [Invoice No: 119232] updated by Abdul Rasheed on 18/03/2019 at 10:47 PM");
INSERT INTO crm_audit_log VALUES("4544","3","15","2019-03-18 22:49:08","Exit Invoice [Invoice No: 119233] updated by Abdul Rasheed on 18/03/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("4545","3","15","2019-03-18 22:57:09","Exit Invoice [Invoice No: 119234] updated by Abdul Rasheed on 18/03/2019 at 10:57 PM");
INSERT INTO crm_audit_log VALUES("4546","2","4","2019-03-18 23:03:24","Entry Invoice [Invoice No: 20770] updated by Yasir  Rahman on 18/03/2019 at 11:03 PM");
INSERT INTO crm_audit_log VALUES("4547","2","4","2019-03-18 23:05:40","Entry Invoice [Invoice No: 20771] updated by Yasir  Rahman on 18/03/2019 at 11:05 PM");
INSERT INTO crm_audit_log VALUES("4548","2","4","2019-03-18 23:09:56","Entry Invoice [Invoice No: 20772] updated by Yasir  Rahman on 18/03/2019 at 11:09 PM");
INSERT INTO crm_audit_log VALUES("4549","2","4","2019-03-19 00:46:07","Entry Invoice [Invoice No: 20773] updated by Yasir  Rahman on 19/03/2019 at 12:46 AM");
INSERT INTO crm_audit_log VALUES("4550","2","4","2019-03-19 01:54:16","Entry Invoice [Invoice No: 20774] updated by Yasir  Rahman on 19/03/2019 at 01:54 AM");
INSERT INTO crm_audit_log VALUES("4551","2","4","2019-03-19 01:56:24","Entry Invoice [Invoice No: 20775] updated by Yasir  Rahman on 19/03/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("4552","3","5","2019-03-19 02:05:16","Exit Invoice [Invoice No: 119235] updated by Imran  Khan on 19/03/2019 at 02:05 AM");
INSERT INTO crm_audit_log VALUES("4553","3","5","2019-03-19 02:32:33","Exit Invoice [Invoice No: 119236] updated by Imran  Khan on 19/03/2019 at 02:32 AM");
INSERT INTO crm_audit_log VALUES("4554","3","5","2019-03-19 02:34:44","Exit Invoice [Invoice No: 119237] updated by Imran  Khan on 19/03/2019 at 02:34 AM");
INSERT INTO crm_audit_log VALUES("4555","3","5","2019-03-19 04:22:04","Exit Invoice [Invoice No: 119238] updated by Imran  Khan on 19/03/2019 at 04:22 AM");
INSERT INTO crm_audit_log VALUES("4556","3","5","2019-03-19 04:22:52","Exit Invoice [Invoice No: 119239] updated by Imran  Khan on 19/03/2019 at 04:22 AM");
INSERT INTO crm_audit_log VALUES("4557","3","5","2019-03-19 04:23:34","Exit Invoice [Invoice No: 119240] updated by Imran  Khan on 19/03/2019 at 04:23 AM");
INSERT INTO crm_audit_log VALUES("4558","3","5","2019-03-19 04:24:15","Exit Invoice [Invoice No: 119241] updated by Imran  Khan on 19/03/2019 at 04:24 AM");
INSERT INTO crm_audit_log VALUES("4559","3","5","2019-03-19 04:25:00","Exit Invoice [Invoice No: 119242] updated by Imran  Khan on 19/03/2019 at 04:25 AM");
INSERT INTO crm_audit_log VALUES("4560","3","5","2019-03-19 04:25:47","Exit Invoice [Invoice No: 119243] updated by Imran  Khan on 19/03/2019 at 04:25 AM");
INSERT INTO crm_audit_log VALUES("4561","3","5","2019-03-19 05:26:01","Exit Invoice [Invoice No: 119244] updated by Imran  Khan on 19/03/2019 at 05:26 AM");
INSERT INTO crm_audit_log VALUES("4562","3","4","2019-03-19 09:43:11","Exit Invoice [Invoice No: 119245] updated by Yasir  Rahman on 19/03/2019 at 09:43 AM");
INSERT INTO crm_audit_log VALUES("4563","2","6","2019-03-19 11:05:10","Entry Invoice [Invoice No: 20776] updated by ASHRAF  M K on 19/03/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("4564","2","6","2019-03-19 11:15:50","Entry Invoice [Invoice No: 20777] updated by ASHRAF  M K on 19/03/2019 at 11:15 AM");
INSERT INTO crm_audit_log VALUES("4565","2","6","2019-03-19 11:16:13","Entry Invoice [Invoice No: 20777] updated by ASHRAF  M K on 19/03/2019 at 11:16 AM");
INSERT INTO crm_audit_log VALUES("4566","2","6","2019-03-19 11:21:20","Entry Invoice [Invoice No: 20778] updated by ASHRAF  M K on 19/03/2019 at 11:21 AM");
INSERT INTO crm_audit_log VALUES("4567","2","6","2019-03-19 11:22:30","Entry Invoice [Invoice No: 20779] updated by ASHRAF  M K on 19/03/2019 at 11:22 AM");
INSERT INTO crm_audit_log VALUES("4568","2","6","2019-03-19 11:53:27","Entry Invoice [Invoice No: 20780] updated by ASHRAF  M K on 19/03/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("4569","2","6","2019-03-19 11:54:32","Entry Invoice [Invoice No: 20781] updated by ASHRAF  M K on 19/03/2019 at 11:54 AM");
INSERT INTO crm_audit_log VALUES("4570","2","6","2019-03-19 12:02:22","Entry Invoice [Invoice No: 20782] updated by ASHRAF  M K on 19/03/2019 at 12:02 PM");
INSERT INTO crm_audit_log VALUES("4571","3","4","2019-03-19 12:30:59","Exit Invoice [Invoice No: 119246] updated by Yasir  Rahman on 19/03/2019 at 12:30 PM");
INSERT INTO crm_audit_log VALUES("4572","3","4","2019-03-19 13:26:40","Exit Invoice [Invoice No: 119247] updated by Yasir  Rahman on 19/03/2019 at 01:26 PM");
INSERT INTO crm_audit_log VALUES("4573","3","4","2019-03-19 14:17:45","Exit Invoice [Invoice No: 119248] updated by Yasir  Rahman on 19/03/2019 at 02:17 PM");
INSERT INTO crm_audit_log VALUES("4574","2","6","2019-03-19 15:28:11","Entry Invoice [Invoice No: 20783] updated by ASHRAF  M K on 19/03/2019 at 03:28 PM");
INSERT INTO crm_audit_log VALUES("4575","2","6","2019-03-19 15:28:19","Entry Invoice [Invoice No: 20783] updated by ASHRAF  M K on 19/03/2019 at 03:28 PM");
INSERT INTO crm_audit_log VALUES("4576","2","7","2019-03-19 17:01:51","Entry Invoice [Invoice No: 20784] updated by ALSED ABU SHAMA on 19/03/2019 at 05:01 PM");
INSERT INTO crm_audit_log VALUES("4577","2","7","2019-03-19 17:07:12","Entry Invoice [Invoice No: 20785] updated by ALSED ABU SHAMA on 19/03/2019 at 05:07 PM");
INSERT INTO crm_audit_log VALUES("4578","3","15","2019-03-19 17:33:13","Exit Invoice [Invoice No: 119249] updated by Abdul Rasheed on 19/03/2019 at 05:33 PM");
INSERT INTO crm_audit_log VALUES("4579","3","15","2019-03-19 18:51:43","Exit Invoice [Invoice No: 119250] updated by Abdul Rasheed on 19/03/2019 at 06:51 PM");
INSERT INTO crm_audit_log VALUES("4580","3","15","2019-03-19 20:28:11","Exit Invoice [Invoice No: 119251] updated by Abdul Rasheed on 19/03/2019 at 08:28 PM");
INSERT INTO crm_audit_log VALUES("4581","2","4","2019-03-19 21:26:15","Entry Invoice [Invoice No: 20786] updated by Yasir  Rahman on 19/03/2019 at 09:26 PM");
INSERT INTO crm_audit_log VALUES("4582","2","4","2019-03-19 21:28:33","Entry Invoice [Invoice No: 20787] updated by Yasir  Rahman on 19/03/2019 at 09:28 PM");
INSERT INTO crm_audit_log VALUES("4583","2","4","2019-03-19 21:31:16","Entry Invoice [Invoice No: 20788] updated by Yasir  Rahman on 19/03/2019 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("4584","2","4","2019-03-19 21:37:48","Entry Invoice [Invoice No: 20789] updated by Yasir  Rahman on 19/03/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("4585","2","4","2019-03-19 21:41:18","Entry Invoice [Invoice No: 20790] updated by Yasir  Rahman on 19/03/2019 at 09:41 PM");
INSERT INTO crm_audit_log VALUES("4586","2","4","2019-03-19 21:46:24","Entry Invoice [Invoice No: 20791] updated by Yasir  Rahman on 19/03/2019 at 09:46 PM");
INSERT INTO crm_audit_log VALUES("4587","2","4","2019-03-19 22:24:06","Entry Invoice [Invoice No: 20792] updated by Yasir  Rahman on 19/03/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("4588","3","5","2019-03-20 01:02:35","Exit Invoice [Invoice No: 119252] updated by Imran  Khan on 20/03/2019 at 01:02 AM");
INSERT INTO crm_audit_log VALUES("4589","3","5","2019-03-20 02:42:41","Exit Invoice [Invoice No: 119253] updated by Imran  Khan on 20/03/2019 at 02:42 AM");
INSERT INTO crm_audit_log VALUES("4590","3","5","2019-03-20 06:32:01","Exit Invoice [Invoice No: 119254] updated by Imran  Khan on 20/03/2019 at 06:32 AM");
INSERT INTO crm_audit_log VALUES("4591","2","4","2019-03-20 07:02:26","Entry Invoice [Invoice No: 20793] updated by Yasir  Rahman on 20/03/2019 at 07:02 AM");
INSERT INTO crm_audit_log VALUES("4592","3","5","2019-03-20 07:04:16","Exit Invoice [Invoice No: 119255] updated by Imran  Khan on 20/03/2019 at 07:04 AM");
INSERT INTO crm_audit_log VALUES("4593","2","7","2019-03-20 08:44:08","Entry Invoice [Invoice No: 20794] updated by ALSED ABU SHAMA on 20/03/2019 at 08:44 AM");
INSERT INTO crm_audit_log VALUES("4594","2","6","2019-03-20 12:20:04","Entry Invoice [Invoice No: 20795] updated by ASHRAF  M K on 20/03/2019 at 12:20 PM");
INSERT INTO crm_audit_log VALUES("4595","2","6","2019-03-20 12:22:11","Entry Invoice [Invoice No: 20796] updated by ASHRAF  M K on 20/03/2019 at 12:22 PM");
INSERT INTO crm_audit_log VALUES("4596","3","4","2019-03-20 12:57:26","Exit Invoice [Invoice No: 119256] updated by Yasir  Rahman on 20/03/2019 at 12:57 PM");
INSERT INTO crm_audit_log VALUES("4597","3","4","2019-03-20 13:19:42","Exit Invoice [Invoice No: 119257] updated by Yasir  Rahman on 20/03/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("4598","3","4","2019-03-20 13:46:01","Exit Invoice [Invoice No: 119258] updated by Yasir  Rahman on 20/03/2019 at 01:46 PM");
INSERT INTO crm_audit_log VALUES("4599","3","4","2019-03-20 14:18:55","Exit Invoice [Invoice No: 119259] updated by Yasir  Rahman on 20/03/2019 at 02:18 PM");
INSERT INTO crm_audit_log VALUES("4600","2","6","2019-03-20 15:06:24","Entry Invoice [Invoice No: 20797] updated by ASHRAF  M K on 20/03/2019 at 03:06 PM");
INSERT INTO crm_audit_log VALUES("4601","2","6","2019-03-20 15:40:12","Entry Invoice [Invoice No: 20798] updated by ASHRAF  M K on 20/03/2019 at 03:40 PM");
INSERT INTO crm_audit_log VALUES("4602","2","6","2019-03-20 15:52:32","Entry Invoice [Invoice No: 20799] updated by ASHRAF  M K on 20/03/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("4603","3","4","2019-03-20 15:53:19","Exit Invoice [Invoice No: 119260] updated by Yasir  Rahman on 20/03/2019 at 03:53 PM");
INSERT INTO crm_audit_log VALUES("4604","2","6","2019-03-20 15:53:48","Entry Invoice [Invoice No: 20800] updated by ASHRAF  M K on 20/03/2019 at 03:53 PM");
INSERT INTO crm_audit_log VALUES("4605","3","15","2019-03-20 16:18:29","Exit Invoice [Invoice No: 119261] updated by Abdul Rasheed on 20/03/2019 at 04:18 PM");
INSERT INTO crm_audit_log VALUES("4606","3","15","2019-03-20 16:19:44","Exit Invoice [Invoice No: 119262] updated by Abdul Rasheed on 20/03/2019 at 04:19 PM");
INSERT INTO crm_audit_log VALUES("4607","3","15","2019-03-20 17:15:51","Exit Invoice [Invoice No: 119263] updated by Abdul Rasheed on 20/03/2019 at 05:15 PM");
INSERT INTO crm_audit_log VALUES("4608","2","7","2019-03-20 17:32:49","Entry Invoice [Invoice No: 20801] updated by ALSED ABU SHAMA on 20/03/2019 at 05:32 PM");
INSERT INTO crm_audit_log VALUES("4609","2","7","2019-03-20 18:10:46","Entry Invoice [Invoice No: 20802] updated by ALSED ABU SHAMA on 20/03/2019 at 06:10 PM");
INSERT INTO crm_audit_log VALUES("4610","2","7","2019-03-20 18:30:08","Entry Invoice [Invoice No: 20803] updated by ALSED ABU SHAMA on 20/03/2019 at 06:30 PM");
INSERT INTO crm_audit_log VALUES("4611","2","7","2019-03-20 18:33:20","Entry Invoice [Invoice No: 20804] updated by ALSED ABU SHAMA on 20/03/2019 at 06:33 PM");
INSERT INTO crm_audit_log VALUES("4612","2","7","2019-03-20 19:27:41","Entry Invoice [Invoice No: 20805] updated by ALSED ABU SHAMA on 20/03/2019 at 07:27 PM");
INSERT INTO crm_audit_log VALUES("4613","3","15","2019-03-20 19:44:20","Exit Invoice [Invoice No: 119264] updated by Abdul Rasheed on 20/03/2019 at 07:44 PM");
INSERT INTO crm_audit_log VALUES("4614","3","15","2019-03-20 19:45:41","Exit Invoice [Invoice No: 119265] updated by Abdul Rasheed on 20/03/2019 at 07:45 PM");
INSERT INTO crm_audit_log VALUES("4615","3","15","2019-03-20 19:46:48","Exit Invoice [Invoice No: 119266] updated by Abdul Rasheed on 20/03/2019 at 07:46 PM");
INSERT INTO crm_audit_log VALUES("4616","3","15","2019-03-20 19:49:10","Exit Invoice [Invoice No: 119267] updated by Abdul Rasheed on 20/03/2019 at 07:49 PM");
INSERT INTO crm_audit_log VALUES("4617","2","4","2019-03-20 21:11:12","Entry Invoice [Invoice No: 20806] updated by Yasir  Rahman on 20/03/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("4618","2","4","2019-03-20 21:17:44","Entry Invoice [Invoice No: 20807] updated by Yasir  Rahman on 20/03/2019 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("4619","2","4","2019-03-20 21:22:17","Entry Invoice [Invoice No: 20808] updated by Yasir  Rahman on 20/03/2019 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("4620","2","4","2019-03-20 21:28:05","Entry Invoice [Invoice No: 20809] updated by Yasir  Rahman on 20/03/2019 at 09:28 PM");
INSERT INTO crm_audit_log VALUES("4621","2","4","2019-03-20 21:34:06","Entry Invoice [Invoice No: 20810] updated by Yasir  Rahman on 20/03/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("4622","2","4","2019-03-20 21:39:04","Entry Invoice [Invoice No: 20811] updated by Yasir  Rahman on 20/03/2019 at 09:39 PM");
INSERT INTO crm_audit_log VALUES("4623","2","6","2019-03-20 21:40:17","Entry Invoice [Invoice No: 20811] updated by ASHRAF  M K on 20/03/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("4624","3","6","2019-03-20 21:59:25","Exit Invoice [Invoice No: 119268] updated by ASHRAF  M K on 20/03/2019 at 09:59 PM");
INSERT INTO crm_audit_log VALUES("4625","3","6","2019-03-20 22:44:34","Exit Invoice [Invoice No: 119268] updated by ASHRAF  M K on 20/03/2019 at 10:44 PM");
INSERT INTO crm_audit_log VALUES("4626","2","4","2019-03-20 22:53:05","Entry Invoice [Invoice No: 20812] updated by Yasir  Rahman on 20/03/2019 at 10:53 PM");
INSERT INTO crm_audit_log VALUES("4627","2","4","2019-03-20 22:54:39","Entry Invoice [Invoice No: 20813] updated by Yasir  Rahman on 20/03/2019 at 10:54 PM");
INSERT INTO crm_audit_log VALUES("4628","2","6","2019-03-20 22:58:02","Entry Invoice [Invoice No: 20813] updated by ASHRAF  M K on 20/03/2019 at 10:58 PM");
INSERT INTO crm_audit_log VALUES("4629","2","4","2019-03-20 22:59:47","Entry Invoice [Invoice No: 20814] updated by Yasir  Rahman on 20/03/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("4630","2","4","2019-03-20 23:16:37","Entry Invoice [Invoice No: 20815] updated by Yasir  Rahman on 20/03/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("4631","3","6","2019-03-20 23:18:18","Exit Invoice [Invoice No: 119269] updated by ASHRAF  M K on 20/03/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("4632","2","4","2019-03-20 23:34:45","Entry Invoice [Invoice No: 20816] updated by Yasir  Rahman on 20/03/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("4633","3","6","2019-03-20 23:35:02","Exit Invoice [Invoice No: 119270] updated by ASHRAF  M K on 20/03/2019 at 11:35 PM");
INSERT INTO crm_audit_log VALUES("4634","2","4","2019-03-21 00:54:13","Entry Invoice [Invoice No: 20817] updated by Yasir  Rahman on 21/03/2019 at 12:54 AM");
INSERT INTO crm_audit_log VALUES("4635","2","4","2019-03-21 01:19:31","Entry Invoice [Invoice No: 20818] updated by Yasir  Rahman on 21/03/2019 at 01:19 AM");
INSERT INTO crm_audit_log VALUES("4636","2","4","2019-03-21 01:56:01","Entry Invoice [Invoice No: 20819] updated by Yasir  Rahman on 21/03/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("4637","1","5","2019-03-21 03:00:27","Customer [Customer No: 433] updated by Imran  Khan on 21/03/2019 at 03:00 AM");
INSERT INTO crm_audit_log VALUES("4638","3","5","2019-03-21 03:01:04","Exit Invoice [Invoice No: 119271] updated by Imran  Khan on 21/03/2019 at 03:01 AM");
INSERT INTO crm_audit_log VALUES("4639","3","5","2019-03-21 03:02:31","Exit Invoice [Invoice No: 119272] updated by Imran  Khan on 21/03/2019 at 03:02 AM");
INSERT INTO crm_audit_log VALUES("4640","3","5","2019-03-21 06:42:33","Exit Invoice [Invoice No: 119273] updated by Imran  Khan on 21/03/2019 at 06:42 AM");
INSERT INTO crm_audit_log VALUES("4641","3","5","2019-03-21 06:43:21","Exit Invoice [Invoice No: 119274] updated by Imran  Khan on 21/03/2019 at 06:43 AM");
INSERT INTO crm_audit_log VALUES("4642","3","5","2019-03-21 06:44:24","Exit Invoice [Invoice No: 119275] updated by Imran  Khan on 21/03/2019 at 06:44 AM");
INSERT INTO crm_audit_log VALUES("4643","2","6","2019-03-21 08:40:57","Entry Invoice [Invoice No: 20816] updated by ASHRAF  M K on 21/03/2019 at 08:40 AM");
INSERT INTO crm_audit_log VALUES("4644","3","4","2019-03-21 09:15:16","Exit Invoice [Invoice No: 119276] updated by Yasir  Rahman on 21/03/2019 at 09:15 AM");
INSERT INTO crm_audit_log VALUES("4645","3","4","2019-03-21 09:20:02","Exit Invoice [Invoice No: 119277] updated by Yasir  Rahman on 21/03/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("4646","3","4","2019-03-21 11:10:06","Exit Invoice [Invoice No: 119278] updated by Yasir  Rahman on 21/03/2019 at 11:10 AM");
INSERT INTO crm_audit_log VALUES("4647","2","7","2019-03-21 11:17:29","Entry Invoice [Invoice No: 20820] updated by ALSED ABU SHAMA on 21/03/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("4648","2","6","2019-03-21 11:48:33","Entry Invoice [Invoice No: 20821] updated by ASHRAF  M K on 21/03/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("4649","3","4","2019-03-21 15:07:23","Exit Invoice [Invoice No: 119279] updated by Yasir  Rahman on 21/03/2019 at 03:07 PM");
INSERT INTO crm_audit_log VALUES("4650","3","4","2019-03-21 15:08:28","Exit Invoice [Invoice No: 119280] updated by Yasir  Rahman on 21/03/2019 at 03:08 PM");
INSERT INTO crm_audit_log VALUES("4651","3","4","2019-03-21 15:09:49","Exit Invoice [Invoice No: 119281] updated by Yasir  Rahman on 21/03/2019 at 03:09 PM");
INSERT INTO crm_audit_log VALUES("4652","3","4","2019-03-21 15:12:33","Exit Invoice [Invoice No: 119282] updated by Yasir  Rahman on 21/03/2019 at 03:12 PM");
INSERT INTO crm_audit_log VALUES("4653","3","4","2019-03-21 15:13:16","Exit Invoice [Invoice No: 119283] updated by Yasir  Rahman on 21/03/2019 at 03:13 PM");
INSERT INTO crm_audit_log VALUES("4654","3","4","2019-03-21 15:16:33","Exit Invoice [Invoice No: 119284] updated by Yasir  Rahman on 21/03/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("4655","3","4","2019-03-21 15:17:46","Exit Invoice [Invoice No: 119285] updated by Yasir  Rahman on 21/03/2019 at 03:17 PM");
INSERT INTO crm_audit_log VALUES("4656","3","4","2019-03-21 15:24:38","Exit Invoice [Invoice No: 119286] updated by Yasir  Rahman on 21/03/2019 at 03:24 PM");
INSERT INTO crm_audit_log VALUES("4657","2","7","2019-03-21 15:33:49","Entry Invoice [Invoice No: 20822] updated by ALSED ABU SHAMA on 21/03/2019 at 03:33 PM");
INSERT INTO crm_audit_log VALUES("4658","2","6","2019-03-21 16:39:03","Entry Invoice [Invoice No: 20823] updated by ASHRAF  M K on 21/03/2019 at 04:39 PM");
INSERT INTO crm_audit_log VALUES("4659","2","6","2019-03-21 16:42:22","Entry Invoice [Invoice No: 20824] updated by ASHRAF  M K on 21/03/2019 at 04:42 PM");
INSERT INTO crm_audit_log VALUES("4660","2","6","2019-03-21 16:44:16","Entry Invoice [Invoice No: 20825] updated by ASHRAF  M K on 21/03/2019 at 04:44 PM");
INSERT INTO crm_audit_log VALUES("4661","3","15","2019-03-21 17:04:23","Exit Invoice [Invoice No: 119287] updated by Abdul Rasheed on 21/03/2019 at 05:04 PM");
INSERT INTO crm_audit_log VALUES("4662","3","15","2019-03-21 17:05:44","Exit Invoice [Invoice No: 119288] updated by Abdul Rasheed on 21/03/2019 at 05:05 PM");
INSERT INTO crm_audit_log VALUES("4663","3","15","2019-03-21 17:09:14","Exit Invoice [Invoice No: 119289] updated by Abdul Rasheed on 21/03/2019 at 05:09 PM");
INSERT INTO crm_audit_log VALUES("4664","3","15","2019-03-21 17:23:09","Exit Invoice [Invoice No: 119290] updated by Abdul Rasheed on 21/03/2019 at 05:23 PM");
INSERT INTO crm_audit_log VALUES("4665","3","15","2019-03-21 17:24:11","Exit Invoice [Invoice No: 119291] updated by Abdul Rasheed on 21/03/2019 at 05:24 PM");
INSERT INTO crm_audit_log VALUES("4666","3","15","2019-03-21 17:26:56","Exit Invoice [Invoice No: 119292] updated by Abdul Rasheed on 21/03/2019 at 05:26 PM");
INSERT INTO crm_audit_log VALUES("4667","2","7","2019-03-21 17:33:28","Entry Invoice [Invoice No: 20826] updated by ALSED ABU SHAMA on 21/03/2019 at 05:33 PM");
INSERT INTO crm_audit_log VALUES("4668","2","7","2019-03-21 17:34:14","Entry Invoice [Invoice No: 20827] updated by ALSED ABU SHAMA on 21/03/2019 at 05:34 PM");
INSERT INTO crm_audit_log VALUES("4669","2","7","2019-03-21 17:34:56","Entry Invoice [Invoice No: 20828] updated by ALSED ABU SHAMA on 21/03/2019 at 05:34 PM");
INSERT INTO crm_audit_log VALUES("4670","2","7","2019-03-21 17:35:38","Entry Invoice [Invoice No: 20829] updated by ALSED ABU SHAMA on 21/03/2019 at 05:35 PM");
INSERT INTO crm_audit_log VALUES("4671","2","7","2019-03-21 17:36:17","Entry Invoice [Invoice No: 20830] updated by ALSED ABU SHAMA on 21/03/2019 at 05:36 PM");
INSERT INTO crm_audit_log VALUES("4672","3","15","2019-03-21 17:50:49","Exit Invoice [Invoice No: 119293] updated by Abdul Rasheed on 21/03/2019 at 05:50 PM");
INSERT INTO crm_audit_log VALUES("4673","3","15","2019-03-21 18:58:56","Exit Invoice [Invoice No: 119294] updated by Abdul Rasheed on 21/03/2019 at 06:58 PM");
INSERT INTO crm_audit_log VALUES("4674","3","15","2019-03-21 19:00:14","Exit Invoice [Invoice No: 119295] updated by Abdul Rasheed on 21/03/2019 at 07:00 PM");
INSERT INTO crm_audit_log VALUES("4675","3","15","2019-03-21 19:10:02","Exit Invoice [Invoice No: 119296] updated by Abdul Rasheed on 21/03/2019 at 07:10 PM");
INSERT INTO crm_audit_log VALUES("4676","2","4","2019-03-21 21:04:30","Entry Invoice [Invoice No: 20831] updated by Yasir  Rahman on 21/03/2019 at 09:04 PM");
INSERT INTO crm_audit_log VALUES("4677","2","4","2019-03-21 21:15:07","Entry Invoice [Invoice No: 20832] updated by Yasir  Rahman on 21/03/2019 at 09:15 PM");
INSERT INTO crm_audit_log VALUES("4678","2","4","2019-03-21 21:18:56","Entry Invoice [Invoice No: 20833] updated by Yasir  Rahman on 21/03/2019 at 09:18 PM");
INSERT INTO crm_audit_log VALUES("4679","3","15","2019-03-21 21:34:37","Exit Invoice [Invoice No: 119297] updated by Abdul Rasheed on 21/03/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("4680","3","5","2019-03-22 03:14:34","Exit Invoice [Invoice No: 119298] updated by Imran  Khan on 22/03/2019 at 03:14 AM");
INSERT INTO crm_audit_log VALUES("4681","3","5","2019-03-22 03:23:32","Exit Invoice [Invoice No: 119299] updated by Imran  Khan on 22/03/2019 at 03:23 AM");
INSERT INTO crm_audit_log VALUES("4682","3","5","2019-03-22 03:24:06","Exit Invoice [Invoice No: 119300] updated by Imran  Khan on 22/03/2019 at 03:24 AM");
INSERT INTO crm_audit_log VALUES("4683","3","5","2019-03-22 03:24:43","Exit Invoice [Invoice No: 119301] updated by Imran  Khan on 22/03/2019 at 03:24 AM");
INSERT INTO crm_audit_log VALUES("4684","3","5","2019-03-22 03:25:22","Exit Invoice [Invoice No: 119302] updated by Imran  Khan on 22/03/2019 at 03:25 AM");
INSERT INTO crm_audit_log VALUES("4685","3","5","2019-03-22 03:26:01","Exit Invoice [Invoice No: 119303] updated by Imran  Khan on 22/03/2019 at 03:26 AM");
INSERT INTO crm_audit_log VALUES("4686","3","5","2019-03-22 03:26:37","Exit Invoice [Invoice No: 119304] updated by Imran  Khan on 22/03/2019 at 03:26 AM");
INSERT INTO crm_audit_log VALUES("4687","2","4","2019-03-22 06:26:27","Entry Invoice [Invoice No: 20834] updated by Yasir  Rahman on 22/03/2019 at 06:26 AM");
INSERT INTO crm_audit_log VALUES("4688","2","4","2019-03-22 06:29:21","Entry Invoice [Invoice No: 20835] updated by Yasir  Rahman on 22/03/2019 at 06:29 AM");
INSERT INTO crm_audit_log VALUES("4689","2","4","2019-03-22 06:30:29","Entry Invoice [Invoice No: 20836] updated by Yasir  Rahman on 22/03/2019 at 06:30 AM");
INSERT INTO crm_audit_log VALUES("4690","2","4","2019-03-22 06:31:50","Entry Invoice [Invoice No: 20837] updated by Yasir  Rahman on 22/03/2019 at 06:31 AM");
INSERT INTO crm_audit_log VALUES("4691","2","4","2019-03-22 06:33:06","Entry Invoice [Invoice No: 20838] updated by Yasir  Rahman on 22/03/2019 at 06:33 AM");
INSERT INTO crm_audit_log VALUES("4692","2","4","2019-03-22 06:34:32","Entry Invoice [Invoice No: 20839] updated by Yasir  Rahman on 22/03/2019 at 06:34 AM");
INSERT INTO crm_audit_log VALUES("4693","2","4","2019-03-22 06:35:52","Entry Invoice [Invoice No: 20840] updated by Yasir  Rahman on 22/03/2019 at 06:35 AM");
INSERT INTO crm_audit_log VALUES("4694","2","4","2019-03-22 06:37:44","Entry Invoice [Invoice No: 20841] updated by Yasir  Rahman on 22/03/2019 at 06:37 AM");
INSERT INTO crm_audit_log VALUES("4695","3","4","2019-03-22 09:20:41","Exit Invoice [Invoice No: 119305] updated by Yasir  Rahman on 22/03/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("4696","3","4","2019-03-22 09:26:49","Exit Invoice [Invoice No: 119306] updated by Yasir  Rahman on 22/03/2019 at 09:26 AM");
INSERT INTO crm_audit_log VALUES("4697","3","4","2019-03-22 09:32:08","Exit Invoice [Invoice No: 119307] updated by Yasir  Rahman on 22/03/2019 at 09:32 AM");
INSERT INTO crm_audit_log VALUES("4698","3","4","2019-03-22 11:17:53","Exit Invoice [Invoice No: 119308] updated by Yasir  Rahman on 22/03/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("4699","3","4","2019-03-22 11:55:51","Exit Invoice [Invoice No: 119309] updated by Yasir  Rahman on 22/03/2019 at 11:55 AM");
INSERT INTO crm_audit_log VALUES("4700","2","7","2019-03-22 14:23:18","Entry Invoice [Invoice No: 20842] updated by ALSED ABU SHAMA on 22/03/2019 at 02:23 PM");
INSERT INTO crm_audit_log VALUES("4701","2","7","2019-03-22 14:24:29","Entry Invoice [Invoice No: 20843] updated by ALSED ABU SHAMA on 22/03/2019 at 02:24 PM");
INSERT INTO crm_audit_log VALUES("4702","3","4","2019-03-22 14:43:27","Exit Invoice [Invoice No: 119310] updated by Yasir  Rahman on 22/03/2019 at 02:43 PM");
INSERT INTO crm_audit_log VALUES("4703","3","4","2019-03-22 14:44:50","Exit Invoice [Invoice No: 119311] updated by Yasir  Rahman on 22/03/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("4704","3","15","2019-03-22 16:41:11","Exit Invoice [Invoice No: 119312] updated by Abdul Rasheed on 22/03/2019 at 04:41 PM");
INSERT INTO crm_audit_log VALUES("4705","2","7","2019-03-22 17:04:32","Entry Invoice [Invoice No: 20844] updated by ALSED ABU SHAMA on 22/03/2019 at 05:04 PM");
INSERT INTO crm_audit_log VALUES("4706","2","7","2019-03-22 17:51:38","Entry Invoice [Invoice No: 20845] updated by ALSED ABU SHAMA on 22/03/2019 at 05:51 PM");
INSERT INTO crm_audit_log VALUES("4707","2","7","2019-03-22 17:52:45","Entry Invoice [Invoice No: 20846] updated by ALSED ABU SHAMA on 22/03/2019 at 05:52 PM");
INSERT INTO crm_audit_log VALUES("4708","3","15","2019-03-22 17:55:27","Exit Invoice [Invoice No: 119313] updated by Abdul Rasheed on 22/03/2019 at 05:55 PM");
INSERT INTO crm_audit_log VALUES("4709","3","15","2019-03-22 17:56:13","Exit Invoice [Invoice No: 119314] updated by Abdul Rasheed on 22/03/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("4710","3","15","2019-03-22 17:57:06","Exit Invoice [Invoice No: 119315] updated by Abdul Rasheed on 22/03/2019 at 05:57 PM");
INSERT INTO crm_audit_log VALUES("4711","3","15","2019-03-22 17:58:17","Exit Invoice [Invoice No: 119316] updated by Abdul Rasheed on 22/03/2019 at 05:58 PM");
INSERT INTO crm_audit_log VALUES("4712","3","15","2019-03-22 19:30:18","Exit Invoice [Invoice No: 119317] updated by Abdul Rasheed on 22/03/2019 at 07:30 PM");
INSERT INTO crm_audit_log VALUES("4713","3","15","2019-03-22 19:31:34","Exit Invoice [Invoice No: 119318] updated by Abdul Rasheed on 22/03/2019 at 07:31 PM");
INSERT INTO crm_audit_log VALUES("4714","2","4","2019-03-22 22:21:31","Entry Invoice [Invoice No: 20847] updated by Yasir  Rahman on 22/03/2019 at 10:21 PM");
INSERT INTO crm_audit_log VALUES("4715","3","5","2019-03-23 00:27:14","Exit Invoice [Invoice No: 119319] updated by Imran  Khan on 23/03/2019 at 12:27 AM");
INSERT INTO crm_audit_log VALUES("4716","3","5","2019-03-23 01:26:24","Exit Invoice [Invoice No: 119320] updated by Imran  Khan on 23/03/2019 at 01:26 AM");
INSERT INTO crm_audit_log VALUES("4717","3","5","2019-03-23 01:27:09","Exit Invoice [Invoice No: 119321] updated by Imran  Khan on 23/03/2019 at 01:27 AM");
INSERT INTO crm_audit_log VALUES("4718","2","4","2019-03-23 01:46:49","Entry Invoice [Invoice No: 20848] updated by Yasir  Rahman on 23/03/2019 at 01:46 AM");
INSERT INTO crm_audit_log VALUES("4719","2","4","2019-03-23 01:47:13","Entry Invoice [Invoice No: 20849] updated by Yasir  Rahman on 23/03/2019 at 01:47 AM");
INSERT INTO crm_audit_log VALUES("4720","2","4","2019-03-23 01:47:13","Entry Invoice [Invoice No: 20850] updated by Yasir  Rahman on 23/03/2019 at 01:47 AM");
INSERT INTO crm_audit_log VALUES("4721","2","4","2019-03-23 01:48:32","Entry Invoice [Invoice No: 20851] updated by Yasir  Rahman on 23/03/2019 at 01:48 AM");
INSERT INTO crm_audit_log VALUES("4722","3","5","2019-03-23 03:13:49","Exit Invoice [Invoice No: 119322] updated by Imran  Khan on 23/03/2019 at 03:13 AM");
INSERT INTO crm_audit_log VALUES("4723","2","4","2019-03-23 03:22:16","Entry Invoice [Invoice No: 20852] updated by Yasir  Rahman on 23/03/2019 at 03:22 AM");
INSERT INTO crm_audit_log VALUES("4724","3","6","2019-03-23 08:33:05","Exit Invoice [Invoice No: 119319] updated by ASHRAF  M K on 23/03/2019 at 08:33 AM");
INSERT INTO crm_audit_log VALUES("4725","3","4","2019-03-23 08:35:29","Exit Invoice [Invoice No: 119323] updated by Yasir  Rahman on 23/03/2019 at 08:35 AM");
INSERT INTO crm_audit_log VALUES("4726","2","6","2019-03-23 08:36:22","Entry Invoice [Invoice No: 20847] updated by ASHRAF  M K on 23/03/2019 at 08:36 AM");
INSERT INTO crm_audit_log VALUES("4727","3","4","2019-03-23 09:04:39","Exit Invoice [Invoice No: 119324] updated by Yasir  Rahman on 23/03/2019 at 09:04 AM");
INSERT INTO crm_audit_log VALUES("4728","3","4","2019-03-23 10:19:14","Exit Invoice [Invoice No: 119325] updated by Yasir  Rahman on 23/03/2019 at 10:19 AM");
INSERT INTO crm_audit_log VALUES("4729","2","6","2019-03-23 10:36:23","Entry Invoice [Invoice No: 20849] updated by ASHRAF  M K on 23/03/2019 at 10:36 AM");
INSERT INTO crm_audit_log VALUES("4730","2","6","2019-03-23 10:56:32","Entry Invoice [Invoice No: 20850] updated by ASHRAF  M K on 23/03/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("4731","2","6","2019-03-23 10:58:07","Entry Invoice [Invoice No: 20853] updated by ASHRAF  M K on 23/03/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("4732","2","6","2019-03-23 11:37:42","Entry Invoice [Invoice No: 20854] updated by ASHRAF  M K on 23/03/2019 at 11:37 AM");
INSERT INTO crm_audit_log VALUES("4733","2","6","2019-03-23 11:38:55","Entry Invoice [Invoice No: 20855] updated by ASHRAF  M K on 23/03/2019 at 11:38 AM");
INSERT INTO crm_audit_log VALUES("4734","3","4","2019-03-23 13:25:17","Exit Invoice [Invoice No: 119326] updated by Yasir  Rahman on 23/03/2019 at 01:25 PM");
INSERT INTO crm_audit_log VALUES("4735","3","4","2019-03-23 13:46:09","Exit Invoice [Invoice No: 119327] updated by Yasir  Rahman on 23/03/2019 at 01:46 PM");
INSERT INTO crm_audit_log VALUES("4736","2","6","2019-03-23 14:18:33","Entry Invoice [Invoice No: 20856] updated by ASHRAF  M K on 23/03/2019 at 02:18 PM");
INSERT INTO crm_audit_log VALUES("4737","2","6","2019-03-23 14:22:57","Entry Invoice [Invoice No: 20857] updated by ASHRAF  M K on 23/03/2019 at 02:22 PM");
INSERT INTO crm_audit_log VALUES("4738","3","15","2019-03-23 17:06:06","Exit Invoice [Invoice No: 119328] updated by Abdul Rasheed on 23/03/2019 at 05:06 PM");
INSERT INTO crm_audit_log VALUES("4739","2","7","2019-03-23 18:44:59","Entry Invoice [Invoice No: 20858] updated by ALSED ABU SHAMA on 23/03/2019 at 06:44 PM");
INSERT INTO crm_audit_log VALUES("4740","2","4","2019-03-23 20:39:35","Entry Invoice [Invoice No: 20859] updated by Yasir  Rahman on 23/03/2019 at 08:39 PM");
INSERT INTO crm_audit_log VALUES("4741","2","4","2019-03-23 20:51:14","Entry Invoice [Invoice No: 20860] updated by Yasir  Rahman on 23/03/2019 at 08:51 PM");
INSERT INTO crm_audit_log VALUES("4742","2","4","2019-03-23 20:53:42","Entry Invoice [Invoice No: 20861] updated by Yasir  Rahman on 23/03/2019 at 08:53 PM");
INSERT INTO crm_audit_log VALUES("4743","2","6","2019-03-23 20:53:50","Entry Invoice [Invoice No: 20859] updated by ASHRAF  M K on 23/03/2019 at 08:53 PM");
INSERT INTO crm_audit_log VALUES("4744","2","4","2019-03-23 21:10:31","Entry Invoice [Invoice No: 20862] updated by Yasir  Rahman on 23/03/2019 at 09:10 PM");
INSERT INTO crm_audit_log VALUES("4745","2","4","2019-03-23 21:12:34","Entry Invoice [Invoice No: 20863] updated by Yasir  Rahman on 23/03/2019 at 09:12 PM");
INSERT INTO crm_audit_log VALUES("4746","2","4","2019-03-23 21:13:40","Entry Invoice [Invoice No: 20864] updated by Yasir  Rahman on 23/03/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("4747","2","6","2019-03-23 21:19:04","Entry Invoice [Invoice No: 20863] updated by ASHRAF  M K on 23/03/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("4748","3","5","2019-03-24 00:01:33","Exit Invoice [Invoice No: 119329] updated by Imran  Khan on 24/03/2019 at 12:01 AM");
INSERT INTO crm_audit_log VALUES("4749","2","4","2019-03-24 00:27:15","Entry Invoice [Invoice No: 20865] updated by Yasir  Rahman on 24/03/2019 at 12:27 AM");
INSERT INTO crm_audit_log VALUES("4750","2","4","2019-03-24 00:29:00","Entry Invoice [Invoice No: 20866] updated by Yasir  Rahman on 24/03/2019 at 12:29 AM");
INSERT INTO crm_audit_log VALUES("4751","3","5","2019-03-24 00:37:19","Exit Invoice [Invoice No: 119330] updated by Imran  Khan on 24/03/2019 at 12:37 AM");
INSERT INTO crm_audit_log VALUES("4752","3","5","2019-03-24 05:31:14","Exit Invoice [Invoice No: 119331] updated by Imran  Khan on 24/03/2019 at 05:31 AM");
INSERT INTO crm_audit_log VALUES("4753","3","5","2019-03-24 05:49:01","Exit Invoice [Invoice No: 119332] updated by Imran  Khan on 24/03/2019 at 05:49 AM");
INSERT INTO crm_audit_log VALUES("4754","3","4","2019-03-24 10:44:15","Exit Invoice [Invoice No: 119333] updated by Yasir  Rahman on 24/03/2019 at 10:44 AM");
INSERT INTO crm_audit_log VALUES("4755","3","4","2019-03-24 10:44:48","Exit Invoice [Invoice No: 119334] updated by Yasir  Rahman on 24/03/2019 at 10:44 AM");
INSERT INTO crm_audit_log VALUES("4756","2","7","2019-03-24 12:27:45","Entry Invoice [Invoice No: 20867] updated by ALSED ABU SHAMA on 24/03/2019 at 12:27 PM");
INSERT INTO crm_audit_log VALUES("4757","3","4","2019-03-24 13:00:57","Exit Invoice [Invoice No: 119335] updated by Yasir  Rahman on 24/03/2019 at 01:00 PM");
INSERT INTO crm_audit_log VALUES("4758","3","4","2019-03-24 13:01:48","Exit Invoice [Invoice No: 119336] updated by Yasir  Rahman on 24/03/2019 at 01:01 PM");
INSERT INTO crm_audit_log VALUES("4759","3","4","2019-03-24 13:27:28","Exit Invoice [Invoice No: 119337] updated by Yasir  Rahman on 24/03/2019 at 01:27 PM");
INSERT INTO crm_audit_log VALUES("4760","3","4","2019-03-24 13:28:27","Exit Invoice [Invoice No: 119338] updated by Yasir  Rahman on 24/03/2019 at 01:28 PM");
INSERT INTO crm_audit_log VALUES("4761","2","7","2019-03-24 14:04:20","Entry Invoice [Invoice No: 20868] updated by ALSED ABU SHAMA on 24/03/2019 at 02:04 PM");
INSERT INTO crm_audit_log VALUES("4762","3","4","2019-03-24 14:10:18","Exit Invoice [Invoice No: 119339] updated by Yasir  Rahman on 24/03/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("4763","2","7","2019-03-24 16:29:56","Entry Invoice [Invoice No: 20869] updated by ALSED ABU SHAMA on 24/03/2019 at 04:29 PM");
INSERT INTO crm_audit_log VALUES("4764","3","15","2019-03-24 17:14:27","Exit Invoice [Invoice No: 119340] updated by Abdul Rasheed on 24/03/2019 at 05:14 PM");
INSERT INTO crm_audit_log VALUES("4765","3","15","2019-03-24 17:16:32","Exit Invoice [Invoice No: 119341] updated by Abdul Rasheed on 24/03/2019 at 05:16 PM");
INSERT INTO crm_audit_log VALUES("4766","3","15","2019-03-24 17:21:03","Exit Invoice [Invoice No: 119342] updated by Abdul Rasheed on 24/03/2019 at 05:21 PM");
INSERT INTO crm_audit_log VALUES("4767","3","15","2019-03-24 17:22:05","Exit Invoice [Invoice No: 119343] updated by Abdul Rasheed on 24/03/2019 at 05:22 PM");
INSERT INTO crm_audit_log VALUES("4768","3","6","2019-03-24 18:01:28","Exit Invoice [Invoice No: 119342] updated by ASHRAF  M K on 24/03/2019 at 06:01 PM");
INSERT INTO crm_audit_log VALUES("4769","3","6","2019-03-24 18:01:55","Exit Invoice [Invoice No: 119343] updated by ASHRAF  M K on 24/03/2019 at 06:01 PM");
INSERT INTO crm_audit_log VALUES("4770","3","6","2019-03-24 18:02:33","Exit Invoice [Invoice No: 119342] updated by ASHRAF  M K on 24/03/2019 at 06:02 PM");
INSERT INTO crm_audit_log VALUES("4771","3","6","2019-03-24 18:06:00","Exit Invoice [Invoice No: 119343] updated by ASHRAF  M K on 24/03/2019 at 06:06 PM");
INSERT INTO crm_audit_log VALUES("4772","3","6","2019-03-24 18:06:12","Exit Invoice [Invoice No: 119342] updated by ASHRAF  M K on 24/03/2019 at 06:06 PM");
INSERT INTO crm_audit_log VALUES("4773","3","15","2019-03-24 18:55:01","Exit Invoice [Invoice No: 119344] updated by Abdul Rasheed on 24/03/2019 at 06:55 PM");
INSERT INTO crm_audit_log VALUES("4774","3","15","2019-03-24 22:09:03","Exit Invoice [Invoice No: 119345] updated by Abdul Rasheed on 24/03/2019 at 10:09 PM");
INSERT INTO crm_audit_log VALUES("4775","3","15","2019-03-24 23:14:18","Exit Invoice [Invoice No: 119346] updated by Abdul Rasheed on 24/03/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("4776","3","15","2019-03-24 23:24:15","Exit Invoice [Invoice No: 119347] updated by Abdul Rasheed on 24/03/2019 at 11:24 PM");
INSERT INTO crm_audit_log VALUES("4777","2","4","2019-03-24 23:38:51","Entry Invoice [Invoice No: 20870] updated by Yasir  Rahman on 24/03/2019 at 11:38 PM");
INSERT INTO crm_audit_log VALUES("4778","2","4","2019-03-24 23:40:32","Entry Invoice [Invoice No: 20871] updated by Yasir  Rahman on 24/03/2019 at 11:40 PM");
INSERT INTO crm_audit_log VALUES("4779","2","4","2019-03-24 23:42:09","Entry Invoice [Invoice No: 20872] updated by Yasir  Rahman on 24/03/2019 at 11:42 PM");
INSERT INTO crm_audit_log VALUES("4780","3","5","2019-03-25 03:34:13","Exit Invoice [Invoice No: 119348] updated by Imran  Khan on 25/03/2019 at 03:34 AM");
INSERT INTO crm_audit_log VALUES("4781","3","5","2019-03-25 05:47:37","Exit Invoice [Invoice No: 119349] updated by Imran  Khan on 25/03/2019 at 05:47 AM");
INSERT INTO crm_audit_log VALUES("4782","2","4","2019-03-25 06:51:19","Entry Invoice [Invoice No: 20873] updated by Yasir  Rahman on 25/03/2019 at 06:51 AM");
INSERT INTO crm_audit_log VALUES("4783","2","6","2019-03-25 10:06:14","Entry Invoice [Invoice No: 20874] updated by ASHRAF  M K on 25/03/2019 at 10:06 AM");
INSERT INTO crm_audit_log VALUES("4784","3","4","2019-03-25 10:32:56","Exit Invoice [Invoice No: 119350] updated by Yasir  Rahman on 25/03/2019 at 10:32 AM");
INSERT INTO crm_audit_log VALUES("4785","3","4","2019-03-25 10:35:18","Exit Invoice [Invoice No: 119351] updated by Yasir  Rahman on 25/03/2019 at 10:35 AM");
INSERT INTO crm_audit_log VALUES("4786","2","6","2019-03-25 11:42:18","Entry Invoice [Invoice No: 20875] updated by ASHRAF  M K on 25/03/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("4787","2","6","2019-03-25 11:49:00","Entry Invoice [Invoice No: 20876] updated by ASHRAF  M K on 25/03/2019 at 11:49 AM");
INSERT INTO crm_audit_log VALUES("4788","3","4","2019-03-25 13:16:03","Exit Invoice [Invoice No: 119352] updated by Yasir  Rahman on 25/03/2019 at 01:16 PM");
INSERT INTO crm_audit_log VALUES("4789","2","6","2019-03-25 14:22:07","Entry Invoice [Invoice No: 20877] updated by ASHRAF  M K on 25/03/2019 at 02:22 PM");
INSERT INTO crm_audit_log VALUES("4790","3","4","2019-03-25 14:41:23","Exit Invoice [Invoice No: 119353] updated by Yasir  Rahman on 25/03/2019 at 02:41 PM");
INSERT INTO crm_audit_log VALUES("4791","3","15","2019-03-25 17:37:16","Exit Invoice [Invoice No: 119354] updated by Abdul Rasheed on 25/03/2019 at 05:37 PM");
INSERT INTO crm_audit_log VALUES("4792","3","15","2019-03-25 18:04:31","Exit Invoice [Invoice No: 119355] updated by Abdul Rasheed on 25/03/2019 at 06:04 PM");
INSERT INTO crm_audit_log VALUES("4793","3","15","2019-03-25 22:04:20","Exit Invoice [Invoice No: 119356] updated by Abdul Rasheed on 25/03/2019 at 10:04 PM");
INSERT INTO crm_audit_log VALUES("4794","3","15","2019-03-25 22:06:45","Exit Invoice [Invoice No: 119357] updated by Abdul Rasheed on 25/03/2019 at 10:06 PM");
INSERT INTO crm_audit_log VALUES("4795","2","4","2019-03-25 22:16:59","Entry Invoice [Invoice No: 20878] updated by Yasir  Rahman on 25/03/2019 at 10:16 PM");
INSERT INTO crm_audit_log VALUES("4796","2","4","2019-03-25 22:28:30","Entry Invoice [Invoice No: 20879] updated by Yasir  Rahman on 25/03/2019 at 10:28 PM");
INSERT INTO crm_audit_log VALUES("4797","3","15","2019-03-25 23:31:30","Exit Invoice [Invoice No: 119358] updated by Abdul Rasheed on 25/03/2019 at 11:31 PM");
INSERT INTO crm_audit_log VALUES("4798","2","4","2019-03-25 23:51:35","Entry Invoice [Invoice No: 20880] updated by Yasir  Rahman on 25/03/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("4799","2","4","2019-03-25 23:52:31","Entry Invoice [Invoice No: 20881] updated by Yasir  Rahman on 25/03/2019 at 11:52 PM");
INSERT INTO crm_audit_log VALUES("4800","2","4","2019-03-25 23:53:32","Entry Invoice [Invoice No: 20882] updated by Yasir  Rahman on 25/03/2019 at 11:53 PM");
INSERT INTO crm_audit_log VALUES("4801","2","4","2019-03-26 01:32:18","Entry Invoice [Invoice No: 20883] updated by Yasir  Rahman on 26/03/2019 at 01:32 AM");
INSERT INTO crm_audit_log VALUES("4802","3","5","2019-03-26 02:18:45","Exit Invoice [Invoice No: 119359] updated by Imran  Khan on 26/03/2019 at 02:18 AM");
INSERT INTO crm_audit_log VALUES("4803","3","5","2019-03-26 02:22:46","Exit Invoice [Invoice No: 119360] updated by Imran  Khan on 26/03/2019 at 02:22 AM");
INSERT INTO crm_audit_log VALUES("4804","2","4","2019-03-26 05:53:20","Entry Invoice [Invoice No: 20884] updated by Yasir  Rahman on 26/03/2019 at 05:53 AM");
INSERT INTO crm_audit_log VALUES("4805","2","4","2019-03-26 05:56:49","Entry Invoice [Invoice No: 20885] updated by Yasir  Rahman on 26/03/2019 at 05:56 AM");
INSERT INTO crm_audit_log VALUES("4806","2","4","2019-03-26 05:58:56","Entry Invoice [Invoice No: 20886] updated by Yasir  Rahman on 26/03/2019 at 05:58 AM");
INSERT INTO crm_audit_log VALUES("4807","2","4","2019-03-26 06:02:07","Entry Invoice [Invoice No: 20887] updated by Yasir  Rahman on 26/03/2019 at 06:02 AM");
INSERT INTO crm_audit_log VALUES("4808","2","4","2019-03-26 06:04:08","Entry Invoice [Invoice No: 20888] updated by Yasir  Rahman on 26/03/2019 at 06:04 AM");
INSERT INTO crm_audit_log VALUES("4809","3","5","2019-03-26 07:40:57","Exit Invoice [Invoice No: 119361] updated by Imran  Khan on 26/03/2019 at 07:40 AM");
INSERT INTO crm_audit_log VALUES("4810","3","6","2019-03-26 10:00:16","Exit Invoice [Invoice No: 119362] updated by ASHRAF  M K on 26/03/2019 at 10:00 AM");
INSERT INTO crm_audit_log VALUES("4811","3","6","2019-03-26 10:00:53","Exit Invoice [Invoice No: 119362] updated by ASHRAF  M K on 26/03/2019 at 10:00 AM");
INSERT INTO crm_audit_log VALUES("4812","3","6","2019-03-26 10:02:44","Exit Invoice [Invoice No: 119363] updated by ASHRAF  M K on 26/03/2019 at 10:02 AM");
INSERT INTO crm_audit_log VALUES("4813","3","6","2019-03-26 10:04:22","Exit Invoice [Invoice No: 119364] updated by ASHRAF  M K on 26/03/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("4814","3","6","2019-03-26 10:07:21","Exit Invoice [Invoice No: 119365] updated by ASHRAF  M K on 26/03/2019 at 10:07 AM");
INSERT INTO crm_audit_log VALUES("4815","3","6","2019-03-26 10:10:06","Exit Invoice [Invoice No: 119366] updated by ASHRAF  M K on 26/03/2019 at 10:10 AM");
INSERT INTO crm_audit_log VALUES("4816","2","7","2019-03-26 10:19:59","Entry Invoice [Invoice No: 20889] updated by ALSED ABU SHAMA on 26/03/2019 at 10:19 AM");
INSERT INTO crm_audit_log VALUES("4817","2","7","2019-03-26 12:09:08","Entry Invoice [Invoice No: 20890] updated by ALSED ABU SHAMA on 26/03/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("4818","3","6","2019-03-26 14:27:58","Exit Invoice [Invoice No: 119367] updated by ASHRAF  M K on 26/03/2019 at 02:27 PM");
INSERT INTO crm_audit_log VALUES("4819","3","6","2019-03-26 14:39:29","Exit Invoice [Invoice No: 119367] updated by ASHRAF  M K on 26/03/2019 at 02:39 PM");
INSERT INTO crm_audit_log VALUES("4820","3","15","2019-03-26 16:59:40","Exit Invoice [Invoice No: 119368] updated by Abdul Rasheed on 26/03/2019 at 04:59 PM");
INSERT INTO crm_audit_log VALUES("4821","2","7","2019-03-26 17:37:27","Entry Invoice [Invoice No: 20891] updated by ALSED ABU SHAMA on 26/03/2019 at 05:37 PM");
INSERT INTO crm_audit_log VALUES("4822","2","7","2019-03-26 18:50:19","Entry Invoice [Invoice No: 20892] updated by ALSED ABU SHAMA on 26/03/2019 at 06:50 PM");
INSERT INTO crm_audit_log VALUES("4823","2","7","2019-03-26 19:34:39","Entry Invoice [Invoice No: 20893] updated by ALSED ABU SHAMA on 26/03/2019 at 07:34 PM");
INSERT INTO crm_audit_log VALUES("4824","2","7","2019-03-26 19:39:11","Entry Invoice [Invoice No: 20894] updated by ALSED ABU SHAMA on 26/03/2019 at 07:39 PM");
INSERT INTO crm_audit_log VALUES("4825","3","15","2019-03-26 20:00:56","Exit Invoice [Invoice No: 119369] updated by Abdul Rasheed on 26/03/2019 at 08:00 PM");
INSERT INTO crm_audit_log VALUES("4826","2","4","2019-03-26 20:56:20","Entry Invoice [Invoice No: 20895] updated by Yasir  Rahman on 26/03/2019 at 08:56 PM");
INSERT INTO crm_audit_log VALUES("4827","2","4","2019-03-26 21:00:22","Entry Invoice [Invoice No: 20896] updated by Yasir  Rahman on 26/03/2019 at 09:00 PM");
INSERT INTO crm_audit_log VALUES("4828","3","15","2019-03-26 21:04:11","Exit Invoice [Invoice No: 119370] updated by Abdul Rasheed on 26/03/2019 at 09:04 PM");
INSERT INTO crm_audit_log VALUES("4829","3","15","2019-03-26 22:44:09","Exit Invoice [Invoice No: 119371] updated by Abdul Rasheed on 26/03/2019 at 10:44 PM");
INSERT INTO crm_audit_log VALUES("4830","3","5","2019-03-27 00:16:15","Exit Invoice [Invoice No: 119372] updated by Imran  Khan on 27/03/2019 at 12:16 AM");
INSERT INTO crm_audit_log VALUES("4831","3","5","2019-03-27 01:11:27","Exit Invoice [Invoice No: 119373] updated by Imran  Khan on 27/03/2019 at 01:11 AM");
INSERT INTO crm_audit_log VALUES("4832","2","4","2019-03-27 06:43:23","Entry Invoice [Invoice No: 20897] updated by Yasir  Rahman on 27/03/2019 at 06:43 AM");
INSERT INTO crm_audit_log VALUES("4833","2","4","2019-03-27 06:45:12","Entry Invoice [Invoice No: 20898] updated by Yasir  Rahman on 27/03/2019 at 06:45 AM");
INSERT INTO crm_audit_log VALUES("4834","2","4","2019-03-27 06:46:22","Entry Invoice [Invoice No: 20899] updated by Yasir  Rahman on 27/03/2019 at 06:46 AM");
INSERT INTO crm_audit_log VALUES("4835","2","4","2019-03-27 06:47:55","Entry Invoice [Invoice No: 20900] updated by Yasir  Rahman on 27/03/2019 at 06:47 AM");
INSERT INTO crm_audit_log VALUES("4836","2","4","2019-03-27 06:49:30","Entry Invoice [Invoice No: 20901] updated by Yasir  Rahman on 27/03/2019 at 06:49 AM");
INSERT INTO crm_audit_log VALUES("4837","3","5","2019-03-27 07:27:57","Exit Invoice [Invoice No: 119374] updated by Imran  Khan on 27/03/2019 at 07:27 AM");
INSERT INTO crm_audit_log VALUES("4838","3","5","2019-03-27 07:29:34","Exit Invoice [Invoice No: 119375] updated by Imran  Khan on 27/03/2019 at 07:29 AM");
INSERT INTO crm_audit_log VALUES("4839","3","4","2019-03-27 09:52:18","Exit Invoice [Invoice No: 119376] updated by Yasir  Rahman on 27/03/2019 at 09:52 AM");
INSERT INTO crm_audit_log VALUES("4840","3","4","2019-03-27 09:55:30","Exit Invoice [Invoice No: 119377] updated by Yasir  Rahman on 27/03/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("4841","3","4","2019-03-27 11:53:42","Exit Invoice [Invoice No: 119378] updated by Yasir  Rahman on 27/03/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("4842","2","6","2019-03-27 12:58:51","Entry Invoice [Invoice No: 20902] updated by ASHRAF  M K on 27/03/2019 at 12:58 PM");
INSERT INTO crm_audit_log VALUES("4843","2","6","2019-03-27 13:11:50","Entry Invoice [Invoice No: 20903] updated by ASHRAF  M K on 27/03/2019 at 01:11 PM");
INSERT INTO crm_audit_log VALUES("4844","2","6","2019-03-27 13:12:46","Entry Invoice [Invoice No: 20904] updated by ASHRAF  M K on 27/03/2019 at 01:12 PM");
INSERT INTO crm_audit_log VALUES("4845","3","4","2019-03-27 13:44:17","Exit Invoice [Invoice No: 119379] updated by Yasir  Rahman on 27/03/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("4846","3","4","2019-03-27 13:45:41","Exit Invoice [Invoice No: 119380] updated by Yasir  Rahman on 27/03/2019 at 01:45 PM");
INSERT INTO crm_audit_log VALUES("4847","2","7","2019-03-27 15:14:13","Entry Invoice [Invoice No: 20905] updated by ALSED ABU SHAMA on 27/03/2019 at 03:14 PM");
INSERT INTO crm_audit_log VALUES("4848","2","7","2019-03-27 15:16:05","Entry Invoice [Invoice No: 20906] updated by ALSED ABU SHAMA on 27/03/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("4849","3","4","2019-03-27 15:54:19","Exit Invoice [Invoice No: 119381] updated by Yasir  Rahman on 27/03/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("4850","3","4","2019-03-27 15:54:45","Exit Invoice [Invoice No: 119382] updated by Yasir  Rahman on 27/03/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("4851","3","4","2019-03-27 16:39:50","Exit Invoice [Invoice No: 119383] updated by Yasir  Rahman on 27/03/2019 at 04:39 PM");
INSERT INTO crm_audit_log VALUES("4852","3","4","2019-03-27 16:40:46","Exit Invoice [Invoice No: 119384] updated by Yasir  Rahman on 27/03/2019 at 04:40 PM");
INSERT INTO crm_audit_log VALUES("4853","3","15","2019-03-27 17:56:03","Exit Invoice [Invoice No: 119385] updated by Abdul Rasheed on 27/03/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("4854","2","7","2019-03-27 18:31:18","Entry Invoice [Invoice No: 20907] updated by ALSED ABU SHAMA on 27/03/2019 at 06:31 PM");
INSERT INTO crm_audit_log VALUES("4855","2","7","2019-03-27 19:12:18","Entry Invoice [Invoice No: 20908] updated by ALSED ABU SHAMA on 27/03/2019 at 07:12 PM");
INSERT INTO crm_audit_log VALUES("4856","3","15","2019-03-27 19:48:02","Exit Invoice [Invoice No: 119386] updated by Abdul Rasheed on 27/03/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("4857","3","15","2019-03-27 20:31:10","Exit Invoice [Invoice No: 119387] updated by Abdul Rasheed on 27/03/2019 at 08:31 PM");
INSERT INTO crm_audit_log VALUES("4858","3","15","2019-03-27 20:32:58","Exit Invoice [Invoice No: 119388] updated by Abdul Rasheed on 27/03/2019 at 08:32 PM");
INSERT INTO crm_audit_log VALUES("4859","3","15","2019-03-27 21:09:22","Exit Invoice [Invoice No: 119389] updated by Abdul Rasheed on 27/03/2019 at 09:09 PM");
INSERT INTO crm_audit_log VALUES("4860","2","4","2019-03-27 21:39:38","Entry Invoice [Invoice No: 20909] updated by Yasir  Rahman on 27/03/2019 at 09:39 PM");
INSERT INTO crm_audit_log VALUES("4861","2","4","2019-03-27 21:40:44","Entry Invoice [Invoice No: 20910] updated by Yasir  Rahman on 27/03/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("4862","3","15","2019-03-27 21:52:57","Exit Invoice [Invoice No: 119390] updated by Abdul Rasheed on 27/03/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("4863","2","4","2019-03-27 21:58:55","Entry Invoice [Invoice No: 20911] updated by Yasir  Rahman on 27/03/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("4864","3","15","2019-03-27 21:59:00","Exit Invoice [Invoice No: 119391] updated by Abdul Rasheed on 27/03/2019 at 09:59 PM");
INSERT INTO crm_audit_log VALUES("4865","2","4","2019-03-27 22:15:31","Entry Invoice [Invoice No: 20912] updated by Yasir  Rahman on 27/03/2019 at 10:15 PM");
INSERT INTO crm_audit_log VALUES("4866","2","4","2019-03-27 22:24:14","Entry Invoice [Invoice No: 20913] updated by Yasir  Rahman on 27/03/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("4867","3","15","2019-03-27 22:32:49","Exit Invoice [Invoice No: 119392] updated by Abdul Rasheed on 27/03/2019 at 10:32 PM");
INSERT INTO crm_audit_log VALUES("4868","3","15","2019-03-27 23:06:06","Exit Invoice [Invoice No: 119393] updated by Abdul Rasheed on 27/03/2019 at 11:06 PM");
INSERT INTO crm_audit_log VALUES("4869","3","15","2019-03-27 23:08:41","Exit Invoice [Invoice No: 119394] updated by Abdul Rasheed on 27/03/2019 at 11:08 PM");
INSERT INTO crm_audit_log VALUES("4870","3","15","2019-03-27 23:34:35","Exit Invoice [Invoice No: 119395] updated by Abdul Rasheed on 27/03/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("4871","2","4","2019-03-28 01:55:25","Entry Invoice [Invoice No: 20914] updated by Yasir  Rahman on 28/03/2019 at 01:55 AM");
INSERT INTO crm_audit_log VALUES("4872","3","5","2019-03-28 05:25:34","Exit Invoice [Invoice No: 119396] updated by Imran  Khan on 28/03/2019 at 05:25 AM");
INSERT INTO crm_audit_log VALUES("4873","2","6","2019-03-28 09:46:07","Entry Invoice [Invoice No: 20915] updated by ASHRAF  M K on 28/03/2019 at 09:46 AM");
INSERT INTO crm_audit_log VALUES("4874","3","4","2019-03-28 10:23:42","Exit Invoice [Invoice No: 119397] updated by Yasir  Rahman on 28/03/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("4875","2","6","2019-03-28 10:26:04","Entry Invoice [Invoice No: 20916] updated by ASHRAF  M K on 28/03/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("4876","2","6","2019-03-28 10:26:58","Entry Invoice [Invoice No: 20917] updated by ASHRAF  M K on 28/03/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("4877","2","6","2019-03-28 10:27:54","Entry Invoice [Invoice No: 20918] updated by ASHRAF  M K on 28/03/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("4878","2","7","2019-03-28 12:57:16","Entry Invoice [Invoice No: 20919] updated by ALSED ABU SHAMA on 28/03/2019 at 12:57 PM");
INSERT INTO crm_audit_log VALUES("4879","2","7","2019-03-28 13:04:07","Entry Invoice [Invoice No: 20920] updated by ALSED ABU SHAMA on 28/03/2019 at 01:04 PM");
INSERT INTO crm_audit_log VALUES("4880","2","7","2019-03-28 13:07:11","Entry Invoice [Invoice No: 20921] updated by ALSED ABU SHAMA on 28/03/2019 at 01:07 PM");
INSERT INTO crm_audit_log VALUES("4881","3","4","2019-03-28 13:23:59","Exit Invoice [Invoice No: 119398] updated by Yasir  Rahman on 28/03/2019 at 01:23 PM");
INSERT INTO crm_audit_log VALUES("4882","3","4","2019-03-28 14:07:59","Exit Invoice [Invoice No: 119399] updated by Yasir  Rahman on 28/03/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("4883","3","4","2019-03-28 15:02:56","Exit Invoice [Invoice No: 119400] updated by Yasir  Rahman on 28/03/2019 at 03:02 PM");
INSERT INTO crm_audit_log VALUES("4884","2","7","2019-03-28 16:21:47","Entry Invoice [Invoice No: 20922] updated by ALSED ABU SHAMA on 28/03/2019 at 04:21 PM");
INSERT INTO crm_audit_log VALUES("4885","3","4","2019-03-28 16:39:55","Exit Invoice [Invoice No: 119401] updated by Yasir  Rahman on 28/03/2019 at 04:39 PM");
INSERT INTO crm_audit_log VALUES("4886","3","15","2019-03-28 17:19:34","Exit Invoice [Invoice No: 119402] updated by Abdul Rasheed on 28/03/2019 at 05:19 PM");
INSERT INTO crm_audit_log VALUES("4887","3","15","2019-03-28 18:32:31","Exit Invoice [Invoice No: 119403] updated by Abdul Rasheed on 28/03/2019 at 06:32 PM");
INSERT INTO crm_audit_log VALUES("4888","3","15","2019-03-28 18:33:24","Exit Invoice [Invoice No: 119404] updated by Abdul Rasheed on 28/03/2019 at 06:33 PM");
INSERT INTO crm_audit_log VALUES("4889","3","15","2019-03-28 19:29:15","Exit Invoice [Invoice No: 119405] updated by Abdul Rasheed on 28/03/2019 at 07:29 PM");
INSERT INTO crm_audit_log VALUES("4890","2","4","2019-03-28 20:50:24","Entry Invoice [Invoice No: 20923] updated by Yasir  Rahman on 28/03/2019 at 08:50 PM");
INSERT INTO crm_audit_log VALUES("4891","2","4","2019-03-28 20:52:32","Entry Invoice [Invoice No: 20924] updated by Yasir  Rahman on 28/03/2019 at 08:52 PM");
INSERT INTO crm_audit_log VALUES("4892","2","4","2019-03-28 20:54:29","Entry Invoice [Invoice No: 20925] updated by Yasir  Rahman on 28/03/2019 at 08:54 PM");
INSERT INTO crm_audit_log VALUES("4893","3","15","2019-03-28 23:04:02","Exit Invoice [Invoice No: 119406] updated by Abdul Rasheed on 28/03/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("4894","3","5","2019-03-29 01:06:23","Exit Invoice [Invoice No: 119407] updated by Imran  Khan on 29/03/2019 at 01:06 AM");
INSERT INTO crm_audit_log VALUES("4895","2","4","2019-03-29 04:00:02","Entry Invoice [Invoice No: 20926] updated by Yasir  Rahman on 29/03/2019 at 04:00 AM");
INSERT INTO crm_audit_log VALUES("4896","2","4","2019-03-29 04:01:53","Entry Invoice [Invoice No: 20927] updated by Yasir  Rahman on 29/03/2019 at 04:01 AM");
INSERT INTO crm_audit_log VALUES("4897","3","5","2019-03-29 06:02:08","Exit Invoice [Invoice No: 119408] updated by Imran  Khan on 29/03/2019 at 06:02 AM");
INSERT INTO crm_audit_log VALUES("4898","2","7","2019-03-29 09:10:38","Entry Invoice [Invoice No: 20928] updated by ALSED ABU SHAMA on 29/03/2019 at 09:10 AM");
INSERT INTO crm_audit_log VALUES("4899","2","7","2019-03-29 09:11:46","Entry Invoice [Invoice No: 20929] updated by ALSED ABU SHAMA on 29/03/2019 at 09:11 AM");
INSERT INTO crm_audit_log VALUES("4900","2","7","2019-03-29 09:12:49","Entry Invoice [Invoice No: 20930] updated by ALSED ABU SHAMA on 29/03/2019 at 09:12 AM");
INSERT INTO crm_audit_log VALUES("4901","2","7","2019-03-29 09:13:45","Entry Invoice [Invoice No: 20931] updated by ALSED ABU SHAMA on 29/03/2019 at 09:13 AM");
INSERT INTO crm_audit_log VALUES("4902","2","7","2019-03-29 09:14:30","Entry Invoice [Invoice No: 20932] updated by ALSED ABU SHAMA on 29/03/2019 at 09:14 AM");
INSERT INTO crm_audit_log VALUES("4903","3","4","2019-03-29 09:53:24","Exit Invoice [Invoice No: 119409] updated by Yasir  Rahman on 29/03/2019 at 09:53 AM");
INSERT INTO crm_audit_log VALUES("4904","3","4","2019-03-29 09:55:23","Exit Invoice [Invoice No: 119410] updated by Yasir  Rahman on 29/03/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("4905","3","4","2019-03-29 11:23:45","Exit Invoice [Invoice No: 119411] updated by Yasir  Rahman on 29/03/2019 at 11:23 AM");
INSERT INTO crm_audit_log VALUES("4906","3","4","2019-03-29 11:57:13","Exit Invoice [Invoice No: 119412] updated by Yasir  Rahman on 29/03/2019 at 11:57 AM");
INSERT INTO crm_audit_log VALUES("4907","2","7","2019-03-29 12:17:46","Entry Invoice [Invoice No: 20933] updated by ALSED ABU SHAMA on 29/03/2019 at 12:17 PM");
INSERT INTO crm_audit_log VALUES("4908","3","4","2019-03-29 14:26:06","Exit Invoice [Invoice No: 119413] updated by Yasir  Rahman on 29/03/2019 at 02:26 PM");
INSERT INTO crm_audit_log VALUES("4909","3","4","2019-03-29 14:29:56","Exit Invoice [Invoice No: 119414] updated by Yasir  Rahman on 29/03/2019 at 02:29 PM");
INSERT INTO crm_audit_log VALUES("4910","3","4","2019-03-29 15:15:46","Exit Invoice [Invoice No: 119415] updated by Yasir  Rahman on 29/03/2019 at 03:15 PM");
INSERT INTO crm_audit_log VALUES("4911","2","7","2019-03-29 15:24:00","Entry Invoice [Invoice No: 20934] updated by ALSED ABU SHAMA on 29/03/2019 at 03:24 PM");
INSERT INTO crm_audit_log VALUES("4912","2","7","2019-03-29 15:39:58","Entry Invoice [Invoice No: 20935] updated by ALSED ABU SHAMA on 29/03/2019 at 03:39 PM");
INSERT INTO crm_audit_log VALUES("4913","2","7","2019-03-29 15:41:17","Entry Invoice [Invoice No: 20936] updated by ALSED ABU SHAMA on 29/03/2019 at 03:41 PM");
INSERT INTO crm_audit_log VALUES("4914","3","15","2019-03-29 16:01:06","Exit Invoice [Invoice No: 119416] updated by Abdul Rasheed on 29/03/2019 at 04:01 PM");
INSERT INTO crm_audit_log VALUES("4915","3","15","2019-03-29 16:02:18","Exit Invoice [Invoice No: 119417] updated by Abdul Rasheed on 29/03/2019 at 04:02 PM");
INSERT INTO crm_audit_log VALUES("4916","3","15","2019-03-29 16:03:32","Exit Invoice [Invoice No: 119418] updated by Abdul Rasheed on 29/03/2019 at 04:03 PM");
INSERT INTO crm_audit_log VALUES("4917","3","15","2019-03-29 16:05:01","Exit Invoice [Invoice No: 119419] updated by Abdul Rasheed on 29/03/2019 at 04:05 PM");
INSERT INTO crm_audit_log VALUES("4918","3","15","2019-03-29 16:06:36","Exit Invoice [Invoice No: 119420] updated by Abdul Rasheed on 29/03/2019 at 04:06 PM");
INSERT INTO crm_audit_log VALUES("4919","3","15","2019-03-29 16:07:46","Exit Invoice [Invoice No: 119421] updated by Abdul Rasheed on 29/03/2019 at 04:07 PM");
INSERT INTO crm_audit_log VALUES("4920","3","15","2019-03-29 17:45:31","Exit Invoice [Invoice No: 119422] updated by Abdul Rasheed on 29/03/2019 at 05:45 PM");
INSERT INTO crm_audit_log VALUES("4921","3","15","2019-03-29 17:47:27","Exit Invoice [Invoice No: 119423] updated by Abdul Rasheed on 29/03/2019 at 05:47 PM");
INSERT INTO crm_audit_log VALUES("4922","3","15","2019-03-29 17:57:00","Exit Invoice [Invoice No: 119424] updated by Abdul Rasheed on 29/03/2019 at 05:57 PM");
INSERT INTO crm_audit_log VALUES("4923","3","15","2019-03-29 19:08:50","Exit Invoice [Invoice No: 119425] updated by Abdul Rasheed on 29/03/2019 at 07:08 PM");
INSERT INTO crm_audit_log VALUES("4924","3","15","2019-03-29 19:09:52","Exit Invoice [Invoice No: 119426] updated by Abdul Rasheed on 29/03/2019 at 07:09 PM");
INSERT INTO crm_audit_log VALUES("4925","3","15","2019-03-29 19:10:43","Exit Invoice [Invoice No: 119427] updated by Abdul Rasheed on 29/03/2019 at 07:10 PM");
INSERT INTO crm_audit_log VALUES("4926","3","15","2019-03-29 20:10:29","Exit Invoice [Invoice No: 119428] updated by Abdul Rasheed on 29/03/2019 at 08:10 PM");
INSERT INTO crm_audit_log VALUES("4927","3","15","2019-03-29 20:24:35","Exit Invoice [Invoice No: 119429] updated by Abdul Rasheed on 29/03/2019 at 08:24 PM");
INSERT INTO crm_audit_log VALUES("4928","2","4","2019-03-29 21:27:47","Entry Invoice [Invoice No: 20937] updated by Yasir  Rahman on 29/03/2019 at 09:27 PM");
INSERT INTO crm_audit_log VALUES("4929","2","4","2019-03-29 21:56:40","Entry Invoice [Invoice No: 20938] updated by Yasir  Rahman on 29/03/2019 at 09:56 PM");
INSERT INTO crm_audit_log VALUES("4930","3","15","2019-03-29 22:00:45","Exit Invoice [Invoice No: 119430] updated by Abdul Rasheed on 29/03/2019 at 10:00 PM");
INSERT INTO crm_audit_log VALUES("4931","3","15","2019-03-29 22:01:33","Exit Invoice [Invoice No: 119431] updated by Abdul Rasheed on 29/03/2019 at 10:01 PM");
INSERT INTO crm_audit_log VALUES("4932","3","15","2019-03-29 22:11:51","Exit Invoice [Invoice No: 119432] updated by Abdul Rasheed on 29/03/2019 at 10:11 PM");
INSERT INTO crm_audit_log VALUES("4933","3","6","2019-03-29 22:47:58","Exit Invoice [Invoice No: 119432] updated by ASHRAF  M K on 29/03/2019 at 10:47 PM");
INSERT INTO crm_audit_log VALUES("4934","3","6","2019-03-29 22:48:16","Exit Invoice [Invoice No: 119418] updated by ASHRAF  M K on 29/03/2019 at 10:48 PM");
INSERT INTO crm_audit_log VALUES("4935","2","4","2019-03-29 22:49:57","Entry Invoice [Invoice No: 20939] updated by Yasir  Rahman on 29/03/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("4936","2","4","2019-03-29 22:50:57","Entry Invoice [Invoice No: 20940] updated by Yasir  Rahman on 29/03/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("4937","2","4","2019-03-29 22:52:42","Entry Invoice [Invoice No: 20941] updated by Yasir  Rahman on 29/03/2019 at 10:52 PM");
INSERT INTO crm_audit_log VALUES("4938","2","4","2019-03-29 23:13:46","Entry Invoice [Invoice No: 20942] updated by Yasir  Rahman on 29/03/2019 at 11:13 PM");
INSERT INTO crm_audit_log VALUES("4939","2","4","2019-03-29 23:16:37","Entry Invoice [Invoice No: 20943] updated by Yasir  Rahman on 29/03/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("4940","2","4","2019-03-29 23:18:03","Entry Invoice [Invoice No: 20944] updated by Yasir  Rahman on 29/03/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("4941","2","4","2019-03-29 23:19:19","Entry Invoice [Invoice No: 20945] updated by Yasir  Rahman on 29/03/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("4942","2","4","2019-03-29 23:20:48","Entry Invoice [Invoice No: 20946] updated by Yasir  Rahman on 29/03/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("4943","2","4","2019-03-29 23:21:58","Entry Invoice [Invoice No: 20947] updated by Yasir  Rahman on 29/03/2019 at 11:21 PM");
INSERT INTO crm_audit_log VALUES("4944","3","15","2019-03-29 23:40:21","Exit Invoice [Invoice No: 119433] updated by Abdul Rasheed on 29/03/2019 at 11:40 PM");
INSERT INTO crm_audit_log VALUES("4945","3","15","2019-03-29 23:42:05","Exit Invoice [Invoice No: 119434] updated by Abdul Rasheed on 29/03/2019 at 11:42 PM");
INSERT INTO crm_audit_log VALUES("4946","2","4","2019-03-30 00:20:18","Entry Invoice [Invoice No: 20948] updated by Yasir  Rahman on 30/03/2019 at 12:20 AM");
INSERT INTO crm_audit_log VALUES("4947","2","4","2019-03-30 00:21:40","Entry Invoice [Invoice No: 20949] updated by Yasir  Rahman on 30/03/2019 at 12:21 AM");
INSERT INTO crm_audit_log VALUES("4948","2","4","2019-03-30 01:11:03","Entry Invoice [Invoice No: 20950] updated by Yasir  Rahman on 30/03/2019 at 01:11 AM");
INSERT INTO crm_audit_log VALUES("4949","3","5","2019-03-30 03:31:49","Exit Invoice [Invoice No: 119435] updated by Imran  Khan on 30/03/2019 at 03:31 AM");
INSERT INTO crm_audit_log VALUES("4950","2","4","2019-03-30 05:01:22","Entry Invoice [Invoice No: 20951] updated by Yasir  Rahman on 30/03/2019 at 05:01 AM");
INSERT INTO crm_audit_log VALUES("4951","2","6","2019-03-30 08:48:55","Entry Invoice [Invoice No: 20951] updated by ASHRAF  M K on 30/03/2019 at 08:48 AM");
INSERT INTO crm_audit_log VALUES("4952","3","4","2019-03-30 09:45:20","Exit Invoice [Invoice No: 119436] updated by Yasir  Rahman on 30/03/2019 at 09:45 AM");
INSERT INTO crm_audit_log VALUES("4953","3","4","2019-03-30 09:47:31","Exit Invoice [Invoice No: 119437] updated by Yasir  Rahman on 30/03/2019 at 09:47 AM");
INSERT INTO crm_audit_log VALUES("4954","3","4","2019-03-30 09:48:42","Exit Invoice [Invoice No: 119438] updated by Yasir  Rahman on 30/03/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("4955","3","4","2019-03-30 09:49:34","Exit Invoice [Invoice No: 119439] updated by Yasir  Rahman on 30/03/2019 at 09:49 AM");
INSERT INTO crm_audit_log VALUES("4956","2","6","2019-03-30 10:27:23","Entry Invoice [Invoice No: 20952] updated by ASHRAF  M K on 30/03/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("4957","2","6","2019-03-30 10:27:30","Entry Invoice [Invoice No: 20952] updated by ASHRAF  M K on 30/03/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("4958","2","6","2019-03-30 10:29:14","Entry Invoice [Invoice No: 20953] updated by ASHRAF  M K on 30/03/2019 at 10:29 AM");
INSERT INTO crm_audit_log VALUES("4959","2","6","2019-03-30 10:31:03","Entry Invoice [Invoice No: 20954] updated by ASHRAF  M K on 30/03/2019 at 10:31 AM");
INSERT INTO crm_audit_log VALUES("4960","2","6","2019-03-30 10:31:11","Entry Invoice [Invoice No: 20953] updated by ASHRAF  M K on 30/03/2019 at 10:31 AM");
INSERT INTO crm_audit_log VALUES("4961","2","6","2019-03-30 10:38:18","Entry Invoice [Invoice No: 20954] updated by ASHRAF  M K on 30/03/2019 at 10:38 AM");
INSERT INTO crm_audit_log VALUES("4962","2","6","2019-03-30 11:24:43","Entry Invoice [Invoice No: 20955] updated by ASHRAF  M K on 30/03/2019 at 11:24 AM");
INSERT INTO crm_audit_log VALUES("4963","2","6","2019-03-30 11:32:49","Entry Invoice [Invoice No: 20956] updated by ASHRAF  M K on 30/03/2019 at 11:32 AM");
INSERT INTO crm_audit_log VALUES("4964","2","7","2019-03-30 12:39:01","Entry Invoice [Invoice No: 20957] updated by ALSED ABU SHAMA on 30/03/2019 at 12:39 PM");
INSERT INTO crm_audit_log VALUES("4965","2","6","2019-03-30 12:58:39","Entry Invoice [Invoice No: 20958] updated by ASHRAF  M K on 30/03/2019 at 12:58 PM");
INSERT INTO crm_audit_log VALUES("4966","2","6","2019-03-30 13:00:19","Entry Invoice [Invoice No: 20958] updated by ASHRAF  M K on 30/03/2019 at 01:00 PM");
INSERT INTO crm_audit_log VALUES("4967","2","6","2019-03-30 13:55:18","Entry Invoice [Invoice No: 20959] updated by ASHRAF  M K on 30/03/2019 at 01:55 PM");
INSERT INTO crm_audit_log VALUES("4968","3","4","2019-03-30 15:10:59","Exit Invoice [Invoice No: 119440] updated by Yasir  Rahman on 30/03/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("4969","3","4","2019-03-30 15:23:21","Exit Invoice [Invoice No: 119441] updated by Yasir  Rahman on 30/03/2019 at 03:23 PM");
INSERT INTO crm_audit_log VALUES("4970","3","4","2019-03-30 15:24:09","Exit Invoice [Invoice No: 119442] updated by Yasir  Rahman on 30/03/2019 at 03:24 PM");
INSERT INTO crm_audit_log VALUES("4971","3","4","2019-03-30 15:29:51","Exit Invoice [Invoice No: 119443] updated by Yasir  Rahman on 30/03/2019 at 03:29 PM");
INSERT INTO crm_audit_log VALUES("4972","3","4","2019-03-30 15:49:16","Exit Invoice [Invoice No: 119444] updated by Yasir  Rahman on 30/03/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("4973","3","15","2019-03-30 16:54:21","Exit Invoice [Invoice No: 119445] updated by Abdul Rasheed on 30/03/2019 at 04:54 PM");
INSERT INTO crm_audit_log VALUES("4974","3","15","2019-03-30 18:55:01","Exit Invoice [Invoice No: 119446] updated by Abdul Rasheed on 30/03/2019 at 06:55 PM");
INSERT INTO crm_audit_log VALUES("4975","2","7","2019-03-30 19:13:23","Entry Invoice [Invoice No: 20960] updated by ALSED ABU SHAMA on 30/03/2019 at 07:13 PM");
INSERT INTO crm_audit_log VALUES("4976","2","4","2019-03-30 20:44:52","Entry Invoice [Invoice No: 20961] updated by Yasir  Rahman on 30/03/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("4977","2","4","2019-03-30 20:46:05","Entry Invoice [Invoice No: 20962] updated by Yasir  Rahman on 30/03/2019 at 08:46 PM");
INSERT INTO crm_audit_log VALUES("4978","3","5","2019-03-31 00:26:42","Exit Invoice [Invoice No: 119447] updated by Imran  Khan on 31/03/2019 at 12:26 AM");
INSERT INTO crm_audit_log VALUES("4979","3","5","2019-03-31 00:30:18","Exit Invoice [Invoice No: 119448] updated by Imran  Khan on 31/03/2019 at 12:30 AM");
INSERT INTO crm_audit_log VALUES("4980","3","5","2019-03-31 00:31:35","Exit Invoice [Invoice No: 119449] updated by Imran  Khan on 31/03/2019 at 12:31 AM");
INSERT INTO crm_audit_log VALUES("4981","3","5","2019-03-31 01:28:51","Exit Invoice [Invoice No: 119450] updated by Imran  Khan on 31/03/2019 at 01:28 AM");
INSERT INTO crm_audit_log VALUES("4982","3","5","2019-03-31 02:36:04","Exit Invoice [Invoice No: 119451] updated by Imran  Khan on 31/03/2019 at 02:36 AM");
INSERT INTO crm_audit_log VALUES("4983","3","5","2019-03-31 02:36:46","Exit Invoice [Invoice No: 119452] updated by Imran  Khan on 31/03/2019 at 02:36 AM");
INSERT INTO crm_audit_log VALUES("4984","3","6","2019-03-31 08:43:58","Exit Invoice [Invoice No: 119447] updated by ASHRAF  M K on 31/03/2019 at 08:43 AM");
INSERT INTO crm_audit_log VALUES("4985","3","4","2019-03-31 08:56:14","Exit Invoice [Invoice No: 119453] updated by Yasir  Rahman on 31/03/2019 at 08:56 AM");
INSERT INTO crm_audit_log VALUES("4986","3","4","2019-03-31 08:57:30","Exit Invoice [Invoice No: 119454] updated by Yasir  Rahman on 31/03/2019 at 08:57 AM");
INSERT INTO crm_audit_log VALUES("4987","3","4","2019-03-31 08:58:55","Exit Invoice [Invoice No: 119455] updated by Yasir  Rahman on 31/03/2019 at 08:58 AM");
INSERT INTO crm_audit_log VALUES("4988","2","7","2019-03-31 10:47:06","Entry Invoice [Invoice No: 20963] updated by ALSED ABU SHAMA on 31/03/2019 at 10:47 AM");
INSERT INTO crm_audit_log VALUES("4989","3","4","2019-03-31 11:03:03","Exit Invoice [Invoice No: 119456] updated by Yasir  Rahman on 31/03/2019 at 11:03 AM");
INSERT INTO crm_audit_log VALUES("4990","3","4","2019-03-31 11:05:37","Exit Invoice [Invoice No: 119457] updated by Yasir  Rahman on 31/03/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("4991","3","4","2019-03-31 13:21:30","Exit Invoice [Invoice No: 119458] updated by Yasir  Rahman on 31/03/2019 at 01:21 PM");
INSERT INTO crm_audit_log VALUES("4992","2","7","2019-03-31 15:25:08","Entry Invoice [Invoice No: 20964] updated by ALSED ABU SHAMA on 31/03/2019 at 03:25 PM");
INSERT INTO crm_audit_log VALUES("4993","3","4","2019-03-31 15:35:32","Exit Invoice [Invoice No: 119459] updated by Yasir  Rahman on 31/03/2019 at 03:35 PM");
INSERT INTO crm_audit_log VALUES("4994","3","4","2019-03-31 15:46:50","Exit Invoice [Invoice No: 119460] updated by Yasir  Rahman on 31/03/2019 at 03:46 PM");
INSERT INTO crm_audit_log VALUES("4995","3","15","2019-03-31 16:30:49","Exit Invoice [Invoice No: 119461] updated by Abdul Rasheed on 31/03/2019 at 04:30 PM");
INSERT INTO crm_audit_log VALUES("4996","3","15","2019-03-31 16:31:56","Exit Invoice [Invoice No: 119462] updated by Abdul Rasheed on 31/03/2019 at 04:31 PM");
INSERT INTO crm_audit_log VALUES("4997","3","15","2019-03-31 17:58:10","Exit Invoice [Invoice No: 119463] updated by Abdul Rasheed on 31/03/2019 at 05:58 PM");
INSERT INTO crm_audit_log VALUES("4998","2","7","2019-03-31 18:28:57","Entry Invoice [Invoice No: 20965] updated by ALSED ABU SHAMA on 31/03/2019 at 06:28 PM");
INSERT INTO crm_audit_log VALUES("4999","2","7","2019-03-31 18:30:28","Entry Invoice [Invoice No: 20966] updated by ALSED ABU SHAMA on 31/03/2019 at 06:30 PM");
INSERT INTO crm_audit_log VALUES("5000","2","7","2019-03-31 18:35:39","Entry Invoice [Invoice No: 20967] updated by ALSED ABU SHAMA on 31/03/2019 at 06:35 PM");
INSERT INTO crm_audit_log VALUES("5001","2","7","2019-03-31 18:36:18","Entry Invoice [Invoice No: 20968] updated by ALSED ABU SHAMA on 31/03/2019 at 06:36 PM");
INSERT INTO crm_audit_log VALUES("5002","2","7","2019-03-31 19:01:14","Entry Invoice [Invoice No: 20969] updated by ALSED ABU SHAMA on 31/03/2019 at 07:01 PM");
INSERT INTO crm_audit_log VALUES("5003","3","4","2019-03-31 21:58:23","Exit Invoice [Invoice No: 119464] updated by Yasir  Rahman on 31/03/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("5004","2","4","2019-03-31 22:17:36","Entry Invoice [Invoice No: 20970] updated by Yasir  Rahman on 31/03/2019 at 10:17 PM");
INSERT INTO crm_audit_log VALUES("5005","3","4","2019-03-31 23:05:21","Exit Invoice [Invoice No: 119465] updated by Yasir  Rahman on 31/03/2019 at 11:05 PM");
INSERT INTO crm_audit_log VALUES("5006","3","4","2019-03-31 23:06:52","Exit Invoice [Invoice No: 119466] updated by Yasir  Rahman on 31/03/2019 at 11:06 PM");
INSERT INTO crm_audit_log VALUES("5007","3","4","2019-03-31 23:41:42","Exit Invoice [Invoice No: 119467] updated by Yasir  Rahman on 31/03/2019 at 11:41 PM");
INSERT INTO crm_audit_log VALUES("5008","2","4","2019-04-01 00:38:00","Entry Invoice [Invoice No: 20971] updated by Yasir  Rahman on 01/04/2019 at 12:38 AM");
INSERT INTO crm_audit_log VALUES("5009","3","5","2019-04-01 01:32:31","Exit Invoice [Invoice No: 119468] updated by Imran  Khan on 01/04/2019 at 01:32 AM");
INSERT INTO crm_audit_log VALUES("5010","2","4","2019-04-01 06:39:30","Entry Invoice [Invoice No: 20972] updated by Yasir  Rahman on 01/04/2019 at 06:39 AM");
INSERT INTO crm_audit_log VALUES("5011","2","4","2019-04-01 06:41:48","Entry Invoice [Invoice No: 20973] updated by Yasir  Rahman on 01/04/2019 at 06:41 AM");
INSERT INTO crm_audit_log VALUES("5012","2","4","2019-04-01 06:43:57","Entry Invoice [Invoice No: 20974] updated by Yasir  Rahman on 01/04/2019 at 06:43 AM");
INSERT INTO crm_audit_log VALUES("5013","3","15","2019-04-01 10:51:15","Exit Invoice [Invoice No: 119469] updated by Abdul Rasheed on 01/04/2019 at 10:51 AM");
INSERT INTO crm_audit_log VALUES("5014","3","15","2019-04-01 11:08:59","Exit Invoice [Invoice No: 119470] updated by Abdul Rasheed on 01/04/2019 at 11:08 AM");
INSERT INTO crm_audit_log VALUES("5015","2","7","2019-04-01 11:31:23","Entry Invoice [Invoice No: 20975] updated by ALSED ABU SHAMA on 01/04/2019 at 11:31 AM");
INSERT INTO crm_audit_log VALUES("5016","2","7","2019-04-01 11:52:14","Entry Invoice [Invoice No: 20976] updated by ALSED ABU SHAMA on 01/04/2019 at 11:52 AM");
INSERT INTO crm_audit_log VALUES("5017","3","15","2019-04-01 13:15:05","Exit Invoice [Invoice No: 119471] updated by Abdul Rasheed on 01/04/2019 at 01:15 PM");
INSERT INTO crm_audit_log VALUES("5018","3","6","2019-04-01 13:20:56","Exit Invoice [Invoice No: 119469] updated by ASHRAF  M K on 01/04/2019 at 01:20 PM");
INSERT INTO crm_audit_log VALUES("5019","3","6","2019-04-01 13:22:50","Exit Invoice [Invoice No: 119469] updated by ASHRAF  M K on 01/04/2019 at 01:22 PM");
INSERT INTO crm_audit_log VALUES("5020","2","6","2019-04-01 13:40:31","Entry Invoice [Invoice No: 20952] updated by ASHRAF  M K on 01/04/2019 at 01:40 PM");
INSERT INTO crm_audit_log VALUES("5021","2","6","2019-04-01 13:44:27","Entry Invoice [Invoice No: 20953] updated by ASHRAF  M K on 01/04/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("5022","3","15","2019-04-01 15:38:32","Exit Invoice [Invoice No: 119472] updated by Abdul Rasheed on 01/04/2019 at 03:38 PM");
INSERT INTO crm_audit_log VALUES("5023","2","7","2019-04-01 17:10:09","Entry Invoice [Invoice No: 20977] updated by ALSED ABU SHAMA on 01/04/2019 at 05:10 PM");
INSERT INTO crm_audit_log VALUES("5024","2","7","2019-04-01 19:53:13","Entry Invoice [Invoice No: 20978] updated by ALSED ABU SHAMA on 01/04/2019 at 07:53 PM");
INSERT INTO crm_audit_log VALUES("5025","3","5","2019-04-01 20:07:25","Exit Invoice [Invoice No: 119473] updated by Imran  Khan on 01/04/2019 at 08:07 PM");
INSERT INTO crm_audit_log VALUES("5026","2","4","2019-04-01 21:22:24","Entry Invoice [Invoice No: 20979] updated by Yasir  Rahman on 01/04/2019 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("5027","2","4","2019-04-01 21:35:04","Entry Invoice [Invoice No: 20980] updated by Yasir  Rahman on 01/04/2019 at 09:35 PM");
INSERT INTO crm_audit_log VALUES("5028","2","4","2019-04-01 21:37:12","Entry Invoice [Invoice No: 20981] updated by Yasir  Rahman on 01/04/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("5029","2","4","2019-04-01 21:38:43","Entry Invoice [Invoice No: 20982] updated by Yasir  Rahman on 01/04/2019 at 09:38 PM");
INSERT INTO crm_audit_log VALUES("5030","2","4","2019-04-01 21:47:20","Entry Invoice [Invoice No: 20983] updated by Yasir  Rahman on 01/04/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("5031","2","4","2019-04-01 22:04:02","Entry Invoice [Invoice No: 20984] updated by Yasir  Rahman on 01/04/2019 at 10:04 PM");
INSERT INTO crm_audit_log VALUES("5032","2","4","2019-04-01 22:57:39","Entry Invoice [Invoice No: 20985] updated by Yasir  Rahman on 01/04/2019 at 10:57 PM");
INSERT INTO crm_audit_log VALUES("5033","2","4","2019-04-01 23:00:34","Entry Invoice [Invoice No: 20986] updated by Yasir  Rahman on 01/04/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("5034","3","5","2019-04-01 23:18:42","Exit Invoice [Invoice No: 119474] updated by Imran  Khan on 01/04/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("5035","3","5","2019-04-01 23:47:51","Exit Invoice [Invoice No: 119475] updated by Imran  Khan on 01/04/2019 at 11:47 PM");
INSERT INTO crm_audit_log VALUES("5036","2","4","2019-04-02 00:11:24","Entry Invoice [Invoice No: 20987] updated by Yasir  Rahman on 02/04/2019 at 12:11 AM");
INSERT INTO crm_audit_log VALUES("5037","3","5","2019-04-02 01:27:03","Exit Invoice [Invoice No: 119476] updated by Imran  Khan on 02/04/2019 at 01:27 AM");
INSERT INTO crm_audit_log VALUES("5038","3","5","2019-04-02 01:27:29","Exit Invoice [Invoice No: 119477] updated by Imran  Khan on 02/04/2019 at 01:27 AM");
INSERT INTO crm_audit_log VALUES("5039","3","5","2019-04-02 02:45:31","Exit Invoice [Invoice No: 119478] updated by Imran  Khan on 02/04/2019 at 02:45 AM");
INSERT INTO crm_audit_log VALUES("5040","3","5","2019-04-02 02:46:24","Exit Invoice [Invoice No: 119479] updated by Imran  Khan on 02/04/2019 at 02:46 AM");
INSERT INTO crm_audit_log VALUES("5041","3","5","2019-04-02 04:45:34","Exit Invoice [Invoice No: 119480] updated by Imran  Khan on 02/04/2019 at 04:45 AM");
INSERT INTO crm_audit_log VALUES("5042","3","5","2019-04-02 07:13:35","Exit Invoice [Invoice No: 119481] updated by Imran  Khan on 02/04/2019 at 07:13 AM");
INSERT INTO crm_audit_log VALUES("5043","3","15","2019-04-02 09:39:16","Exit Invoice [Invoice No: 119482] updated by Abdul Rasheed on 02/04/2019 at 09:39 AM");
INSERT INTO crm_audit_log VALUES("5044","3","15","2019-04-02 10:17:16","Exit Invoice [Invoice No: 119483] updated by Abdul Rasheed on 02/04/2019 at 10:17 AM");
INSERT INTO crm_audit_log VALUES("5045","2","7","2019-04-02 11:11:23","Entry Invoice [Invoice No: 20988] updated by ALSED ABU SHAMA on 02/04/2019 at 11:11 AM");
INSERT INTO crm_audit_log VALUES("5046","2","7","2019-04-02 11:24:06","Entry Invoice [Invoice No: 20989] updated by ALSED ABU SHAMA on 02/04/2019 at 11:24 AM");
INSERT INTO crm_audit_log VALUES("5047","3","15","2019-04-02 12:44:08","Exit Invoice [Invoice No: 119484] updated by Abdul Rasheed on 02/04/2019 at 12:44 PM");
INSERT INTO crm_audit_log VALUES("5048","3","15","2019-04-02 12:45:15","Exit Invoice [Invoice No: 119485] updated by Abdul Rasheed on 02/04/2019 at 12:45 PM");
INSERT INTO crm_audit_log VALUES("5049","3","15","2019-04-02 12:57:23","Exit Invoice [Invoice No: 119486] updated by Abdul Rasheed on 02/04/2019 at 12:57 PM");
INSERT INTO crm_audit_log VALUES("5050","3","15","2019-04-02 13:15:23","Exit Invoice [Invoice No: 119487] updated by Abdul Rasheed on 02/04/2019 at 01:15 PM");
INSERT INTO crm_audit_log VALUES("5051","3","15","2019-04-02 13:31:16","Exit Invoice [Invoice No: 119488] updated by Abdul Rasheed on 02/04/2019 at 01:31 PM");
INSERT INTO crm_audit_log VALUES("5052","2","7","2019-04-02 15:46:12","Entry Invoice [Invoice No: 20990] updated by ALSED ABU SHAMA on 02/04/2019 at 03:46 PM");
INSERT INTO crm_audit_log VALUES("5053","3","4","2019-04-02 16:49:32","Exit Invoice [Invoice No: 119489] updated by Yasir  Rahman on 02/04/2019 at 04:49 PM");
INSERT INTO crm_audit_log VALUES("5054","2","7","2019-04-02 16:51:55","Entry Invoice [Invoice No: 20991] updated by ALSED ABU SHAMA on 02/04/2019 at 04:51 PM");
INSERT INTO crm_audit_log VALUES("5055","2","7","2019-04-02 16:53:12","Entry Invoice [Invoice No: 20992] updated by ALSED ABU SHAMA on 02/04/2019 at 04:53 PM");
INSERT INTO crm_audit_log VALUES("5056","2","7","2019-04-02 17:52:27","Entry Invoice [Invoice No: 20993] updated by ALSED ABU SHAMA on 02/04/2019 at 05:52 PM");
INSERT INTO crm_audit_log VALUES("5057","3","4","2019-04-02 18:29:41","Exit Invoice [Invoice No: 119490] updated by Yasir  Rahman on 02/04/2019 at 06:29 PM");
INSERT INTO crm_audit_log VALUES("5058","3","4","2019-04-02 18:42:06","Exit Invoice [Invoice No: 119491] updated by Yasir  Rahman on 02/04/2019 at 06:42 PM");
INSERT INTO crm_audit_log VALUES("5059","2","7","2019-04-02 18:55:21","Entry Invoice [Invoice No: 20994] updated by ALSED ABU SHAMA on 02/04/2019 at 06:55 PM");
INSERT INTO crm_audit_log VALUES("5060","2","6","2019-04-02 19:46:44","Entry Invoice [Invoice No: 20995] updated by ASHRAF  M K on 02/04/2019 at 07:46 PM");
INSERT INTO crm_audit_log VALUES("5061","2","6","2019-04-02 20:06:31","Entry Invoice [Invoice No: 20996] updated by ASHRAF  M K on 02/04/2019 at 08:06 PM");
INSERT INTO crm_audit_log VALUES("5062","2","6","2019-04-02 20:07:39","Entry Invoice [Invoice No: 20997] updated by ASHRAF  M K on 02/04/2019 at 08:07 PM");
INSERT INTO crm_audit_log VALUES("5063","2","6","2019-04-02 20:10:16","Entry Invoice [Invoice No: 20998] updated by ASHRAF  M K on 02/04/2019 at 08:10 PM");
INSERT INTO crm_audit_log VALUES("5064","2","7","2019-04-02 20:13:36","Entry Invoice [Invoice No: 20999] updated by ALSED ABU SHAMA on 02/04/2019 at 08:13 PM");
INSERT INTO crm_audit_log VALUES("5065","2","7","2019-04-02 20:14:20","Entry Invoice [Invoice No: 21000] updated by ALSED ABU SHAMA on 02/04/2019 at 08:14 PM");
INSERT INTO crm_audit_log VALUES("5066","2","7","2019-04-02 20:15:06","Entry Invoice [Invoice No: 21001] updated by ALSED ABU SHAMA on 02/04/2019 at 08:15 PM");
INSERT INTO crm_audit_log VALUES("5067","3","5","2019-04-02 20:42:52","Exit Invoice [Invoice No: 119492] updated by Imran  Khan on 02/04/2019 at 08:42 PM");
INSERT INTO crm_audit_log VALUES("5068","2","7","2019-04-02 20:45:40","Entry Invoice [Invoice No: 21002] updated by ALSED ABU SHAMA on 02/04/2019 at 08:45 PM");
INSERT INTO crm_audit_log VALUES("5069","2","7","2019-04-02 20:46:42","Entry Invoice [Invoice No: 21003] updated by ALSED ABU SHAMA on 02/04/2019 at 08:46 PM");
INSERT INTO crm_audit_log VALUES("5070","3","5","2019-04-02 21:54:19","Exit Invoice [Invoice No: 119493] updated by Imran  Khan on 02/04/2019 at 09:54 PM");
INSERT INTO crm_audit_log VALUES("5071","3","5","2019-04-02 22:15:52","Exit Invoice [Invoice No: 119494] updated by Imran  Khan on 02/04/2019 at 10:15 PM");
INSERT INTO crm_audit_log VALUES("5072","3","5","2019-04-03 02:12:18","Exit Invoice [Invoice No: 119495] updated by Imran  Khan on 03/04/2019 at 02:12 AM");
INSERT INTO crm_audit_log VALUES("5073","2","6","2019-04-03 08:55:08","Entry Invoice [Invoice No: 20993] updated by ASHRAF  M K on 03/04/2019 at 08:55 AM");
INSERT INTO crm_audit_log VALUES("5074","3","15","2019-04-03 11:02:51","Exit Invoice [Invoice No: 119496] updated by Abdul Rasheed on 03/04/2019 at 11:02 AM");
INSERT INTO crm_audit_log VALUES("5075","3","15","2019-04-03 11:04:25","Exit Invoice [Invoice No: 119497] updated by Abdul Rasheed on 03/04/2019 at 11:04 AM");
INSERT INTO crm_audit_log VALUES("5076","3","15","2019-04-03 11:05:23","Exit Invoice [Invoice No: 119498] updated by Abdul Rasheed on 03/04/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("5077","3","15","2019-04-03 12:30:18","Exit Invoice [Invoice No: 119499] updated by Abdul Rasheed on 03/04/2019 at 12:30 PM");
INSERT INTO crm_audit_log VALUES("5078","3","15","2019-04-03 12:31:49","Exit Invoice [Invoice No: 119500] updated by Abdul Rasheed on 03/04/2019 at 12:31 PM");
INSERT INTO crm_audit_log VALUES("5079","2","7","2019-04-03 12:55:49","Entry Invoice [Invoice No: 21004] updated by ALSED ABU SHAMA on 03/04/2019 at 12:55 PM");
INSERT INTO crm_audit_log VALUES("5080","3","15","2019-04-03 13:07:07","Exit Invoice [Invoice No: 119501] updated by Abdul Rasheed on 03/04/2019 at 01:07 PM");
INSERT INTO crm_audit_log VALUES("5081","2","7","2019-04-03 13:49:46","Entry Invoice [Invoice No: 21005] updated by ALSED ABU SHAMA on 03/04/2019 at 01:49 PM");
INSERT INTO crm_audit_log VALUES("5082","2","7","2019-04-03 13:58:08","Entry Invoice [Invoice No: 21006] updated by ALSED ABU SHAMA on 03/04/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("5083","2","6","2019-04-03 14:13:29","Entry Invoice [Invoice No: 21006] updated by ASHRAF  M K on 03/04/2019 at 02:13 PM");
INSERT INTO crm_audit_log VALUES("5084","3","15","2019-04-03 14:53:55","Exit Invoice [Invoice No: 119502] updated by Abdul Rasheed on 03/04/2019 at 02:53 PM");
INSERT INTO crm_audit_log VALUES("5085","3","15","2019-04-03 14:55:04","Exit Invoice [Invoice No: 119503] updated by Abdul Rasheed on 03/04/2019 at 02:55 PM");
INSERT INTO crm_audit_log VALUES("5086","3","15","2019-04-03 14:56:24","Exit Invoice [Invoice No: 119504] updated by Abdul Rasheed on 03/04/2019 at 02:56 PM");
INSERT INTO crm_audit_log VALUES("5087","2","7","2019-04-03 15:09:17","Entry Invoice [Invoice No: 21007] updated by ALSED ABU SHAMA on 03/04/2019 at 03:09 PM");
INSERT INTO crm_audit_log VALUES("5088","2","7","2019-04-03 15:17:27","Entry Invoice [Invoice No: 21008] updated by ALSED ABU SHAMA on 03/04/2019 at 03:17 PM");
INSERT INTO crm_audit_log VALUES("5089","2","7","2019-04-03 15:18:29","Entry Invoice [Invoice No: 21009] updated by ALSED ABU SHAMA on 03/04/2019 at 03:18 PM");
INSERT INTO crm_audit_log VALUES("5090","3","15","2019-04-03 15:41:30","Exit Invoice [Invoice No: 119505] updated by Abdul Rasheed on 03/04/2019 at 03:41 PM");
INSERT INTO crm_audit_log VALUES("5091","3","4","2019-04-03 17:48:10","Exit Invoice [Invoice No: 119506] updated by Yasir  Rahman on 03/04/2019 at 05:48 PM");
INSERT INTO crm_audit_log VALUES("5092","3","4","2019-04-03 18:53:28","Exit Invoice [Invoice No: 119507] updated by Yasir  Rahman on 03/04/2019 at 06:53 PM");
INSERT INTO crm_audit_log VALUES("5093","2","7","2019-04-03 19:35:03","Entry Invoice [Invoice No: 21010] updated by ALSED ABU SHAMA on 03/04/2019 at 07:35 PM");
INSERT INTO crm_audit_log VALUES("5094","2","7","2019-04-03 19:40:38","Entry Invoice [Invoice No: 21011] updated by ALSED ABU SHAMA on 03/04/2019 at 07:40 PM");
INSERT INTO crm_audit_log VALUES("5095","2","7","2019-04-03 19:42:53","Entry Invoice [Invoice No: 21012] updated by ALSED ABU SHAMA on 03/04/2019 at 07:42 PM");
INSERT INTO crm_audit_log VALUES("5096","2","7","2019-04-03 19:48:32","Entry Invoice [Invoice No: 21013] updated by ALSED ABU SHAMA on 03/04/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("5097","2","7","2019-04-03 19:49:41","Entry Invoice [Invoice No: 21014] updated by ALSED ABU SHAMA on 03/04/2019 at 07:49 PM");
INSERT INTO crm_audit_log VALUES("5098","2","7","2019-04-03 20:24:45","Entry Invoice [Invoice No: 21015] updated by ALSED ABU SHAMA on 03/04/2019 at 08:24 PM");
INSERT INTO crm_audit_log VALUES("5099","2","7","2019-04-03 20:27:46","Entry Invoice [Invoice No: 21016] updated by ALSED ABU SHAMA on 03/04/2019 at 08:27 PM");
INSERT INTO crm_audit_log VALUES("5100","2","7","2019-04-03 20:37:07","Entry Invoice [Invoice No: 21017] updated by ALSED ABU SHAMA on 03/04/2019 at 08:37 PM");
INSERT INTO crm_audit_log VALUES("5101","2","7","2019-04-03 20:37:07","Entry Invoice [Invoice No: 21018] updated by ALSED ABU SHAMA on 03/04/2019 at 08:37 PM");
INSERT INTO crm_audit_log VALUES("5102","2","7","2019-04-03 21:04:27","Entry Invoice [Invoice No: 21019] updated by ALSED ABU SHAMA on 03/04/2019 at 09:04 PM");
INSERT INTO crm_audit_log VALUES("5103","2","7","2019-04-03 21:16:40","Entry Invoice [Invoice No: 21020] updated by ALSED ABU SHAMA on 03/04/2019 at 09:16 PM");
INSERT INTO crm_audit_log VALUES("5104","3","5","2019-04-03 21:50:22","Exit Invoice [Invoice No: 119508] updated by Imran  Khan on 03/04/2019 at 09:50 PM");
INSERT INTO crm_audit_log VALUES("5105","2","4","2019-04-03 22:04:49","Entry Invoice [Invoice No: 21021] updated by Yasir  Rahman on 03/04/2019 at 10:04 PM");
INSERT INTO crm_audit_log VALUES("5106","2","4","2019-04-03 22:24:11","Entry Invoice [Invoice No: 21022] updated by Yasir  Rahman on 03/04/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("5107","2","4","2019-04-03 22:27:32","Entry Invoice [Invoice No: 21023] updated by Yasir  Rahman on 03/04/2019 at 10:27 PM");
INSERT INTO crm_audit_log VALUES("5108","2","4","2019-04-03 23:10:01","Entry Invoice [Invoice No: 21024] updated by Yasir  Rahman on 03/04/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("5109","3","5","2019-04-03 23:50:52","Exit Invoice [Invoice No: 119509] updated by Imran  Khan on 03/04/2019 at 11:50 PM");
INSERT INTO crm_audit_log VALUES("5110","3","5","2019-04-03 23:51:25","Exit Invoice [Invoice No: 119510] updated by Imran  Khan on 03/04/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("5111","2","4","2019-04-04 01:03:16","Entry Invoice [Invoice No: 21025] updated by Yasir  Rahman on 04/04/2019 at 01:03 AM");
INSERT INTO crm_audit_log VALUES("5112","2","4","2019-04-04 01:04:48","Entry Invoice [Invoice No: 21026] updated by Yasir  Rahman on 04/04/2019 at 01:04 AM");
INSERT INTO crm_audit_log VALUES("5113","3","5","2019-04-04 01:18:25","Exit Invoice [Invoice No: 119511] updated by Imran  Khan on 04/04/2019 at 01:18 AM");
INSERT INTO crm_audit_log VALUES("5114","3","5","2019-04-04 01:19:11","Exit Invoice [Invoice No: 119512] updated by Imran  Khan on 04/04/2019 at 01:19 AM");
INSERT INTO crm_audit_log VALUES("5115","2","4","2019-04-04 01:25:58","Entry Invoice [Invoice No: 21027] updated by Yasir  Rahman on 04/04/2019 at 01:25 AM");
INSERT INTO crm_audit_log VALUES("5116","3","5","2019-04-04 03:33:46","Exit Invoice [Invoice No: 119513] updated by Imran  Khan on 04/04/2019 at 03:33 AM");
INSERT INTO crm_audit_log VALUES("5117","2","6","2019-04-04 08:31:11","Entry Invoice [Invoice No: 21018] updated by ASHRAF  M K on 04/04/2019 at 08:31 AM");
INSERT INTO crm_audit_log VALUES("5118","3","15","2019-04-04 09:18:57","Exit Invoice [Invoice No: 119514] updated by Abdul Rasheed on 04/04/2019 at 09:18 AM");
INSERT INTO crm_audit_log VALUES("5119","3","15","2019-04-04 15:19:13","Exit Invoice [Invoice No: 119515] updated by Abdul Rasheed on 04/04/2019 at 03:19 PM");
INSERT INTO crm_audit_log VALUES("5120","3","4","2019-04-04 18:14:31","Exit Invoice [Invoice No: 119516] updated by Yasir  Rahman on 04/04/2019 at 06:14 PM");
INSERT INTO crm_audit_log VALUES("5121","2","7","2019-04-04 18:38:32","Entry Invoice [Invoice No: 21028] updated by ALSED ABU SHAMA on 04/04/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("5122","2","7","2019-04-04 18:48:01","Entry Invoice [Invoice No: 21029] updated by ALSED ABU SHAMA on 04/04/2019 at 06:48 PM");
INSERT INTO crm_audit_log VALUES("5123","2","7","2019-04-04 19:25:58","Entry Invoice [Invoice No: 21030] updated by ALSED ABU SHAMA on 04/04/2019 at 07:25 PM");
INSERT INTO crm_audit_log VALUES("5124","2","7","2019-04-04 19:49:55","Entry Invoice [Invoice No: 21031] updated by ALSED ABU SHAMA on 04/04/2019 at 07:49 PM");
INSERT INTO crm_audit_log VALUES("5125","2","7","2019-04-04 19:50:44","Entry Invoice [Invoice No: 21032] updated by ALSED ABU SHAMA on 04/04/2019 at 07:50 PM");
INSERT INTO crm_audit_log VALUES("5126","3","5","2019-04-04 20:39:46","Exit Invoice [Invoice No: 119517] updated by Imran  Khan on 04/04/2019 at 08:39 PM");
INSERT INTO crm_audit_log VALUES("5127","3","5","2019-04-04 20:40:28","Exit Invoice [Invoice No: 119518] updated by Imran  Khan on 04/04/2019 at 08:40 PM");
INSERT INTO crm_audit_log VALUES("5128","3","5","2019-04-04 20:42:01","Exit Invoice [Invoice No: 119519] updated by Imran  Khan on 04/04/2019 at 08:42 PM");
INSERT INTO crm_audit_log VALUES("5129","3","5","2019-04-04 20:42:39","Exit Invoice [Invoice No: 119520] updated by Imran  Khan on 04/04/2019 at 08:42 PM");
INSERT INTO crm_audit_log VALUES("5130","3","5","2019-04-04 20:49:49","Exit Invoice [Invoice No: 119521] updated by Imran  Khan on 04/04/2019 at 08:49 PM");
INSERT INTO crm_audit_log VALUES("5131","2","4","2019-04-04 21:07:12","Entry Invoice [Invoice No: 21033] updated by Yasir  Rahman on 04/04/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("5132","3","5","2019-04-04 21:51:31","Exit Invoice [Invoice No: 119522] updated by Imran  Khan on 04/04/2019 at 09:51 PM");
INSERT INTO crm_audit_log VALUES("5133","3","5","2019-04-04 21:52:12","Exit Invoice [Invoice No: 119523] updated by Imran  Khan on 04/04/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("5134","2","4","2019-04-04 22:48:43","Entry Invoice [Invoice No: 21034] updated by Yasir  Rahman on 04/04/2019 at 10:48 PM");
INSERT INTO crm_audit_log VALUES("5135","3","5","2019-04-04 23:03:38","Exit Invoice [Invoice No: 119524] updated by Imran  Khan on 04/04/2019 at 11:03 PM");
INSERT INTO crm_audit_log VALUES("5136","3","5","2019-04-04 23:04:52","Exit Invoice [Invoice No: 119525] updated by Imran  Khan on 04/04/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("5137","2","4","2019-04-04 23:09:11","Entry Invoice [Invoice No: 21035] updated by Yasir  Rahman on 04/04/2019 at 11:09 PM");
INSERT INTO crm_audit_log VALUES("5138","2","4","2019-04-05 00:45:10","Entry Invoice [Invoice No: 21036] updated by Yasir  Rahman on 05/04/2019 at 12:45 AM");
INSERT INTO crm_audit_log VALUES("5139","3","5","2019-04-05 02:57:55","Exit Invoice [Invoice No: 119526] updated by Imran  Khan on 05/04/2019 at 02:57 AM");
INSERT INTO crm_audit_log VALUES("5140","3","15","2019-04-05 10:57:21","Exit Invoice [Invoice No: 119527] updated by Abdul Rasheed on 05/04/2019 at 10:57 AM");
INSERT INTO crm_audit_log VALUES("5141","3","15","2019-04-05 11:46:26","Exit Invoice [Invoice No: 119528] updated by Abdul Rasheed on 05/04/2019 at 11:46 AM");
INSERT INTO crm_audit_log VALUES("5142","2","7","2019-04-05 13:57:18","Entry Invoice [Invoice No: 21037] updated by ALSED ABU SHAMA on 05/04/2019 at 01:57 PM");
INSERT INTO crm_audit_log VALUES("5143","2","7","2019-04-05 13:58:08","Entry Invoice [Invoice No: 21038] updated by ALSED ABU SHAMA on 05/04/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("5144","2","7","2019-04-05 13:58:51","Entry Invoice [Invoice No: 21039] updated by ALSED ABU SHAMA on 05/04/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("5145","3","15","2019-04-05 14:54:37","Exit Invoice [Invoice No: 119529] updated by Abdul Rasheed on 05/04/2019 at 02:54 PM");
INSERT INTO crm_audit_log VALUES("5146","3","15","2019-04-05 15:17:44","Exit Invoice [Invoice No: 119530] updated by Abdul Rasheed on 05/04/2019 at 03:17 PM");
INSERT INTO crm_audit_log VALUES("5147","2","7","2019-04-05 16:14:35","Entry Invoice [Invoice No: 21040] updated by ALSED ABU SHAMA on 05/04/2019 at 04:14 PM");
INSERT INTO crm_audit_log VALUES("5148","2","7","2019-04-05 16:54:10","Entry Invoice [Invoice No: 21041] updated by ALSED ABU SHAMA on 05/04/2019 at 04:54 PM");
INSERT INTO crm_audit_log VALUES("5149","3","4","2019-04-05 17:32:28","Exit Invoice [Invoice No: 119531] updated by Yasir  Rahman on 05/04/2019 at 05:32 PM");
INSERT INTO crm_audit_log VALUES("5150","2","7","2019-04-05 19:19:45","Entry Invoice [Invoice No: 21042] updated by ALSED ABU SHAMA on 05/04/2019 at 07:19 PM");
INSERT INTO crm_audit_log VALUES("5151","2","7","2019-04-05 19:22:42","Entry Invoice [Invoice No: 21043] updated by ALSED ABU SHAMA on 05/04/2019 at 07:22 PM");
INSERT INTO crm_audit_log VALUES("5152","2","4","2019-04-05 20:07:25","Entry Invoice [Invoice No: 21044] updated by Yasir  Rahman on 05/04/2019 at 08:07 PM");
INSERT INTO crm_audit_log VALUES("5153","2","4","2019-04-05 20:08:54","Entry Invoice [Invoice No: 21045] updated by Yasir  Rahman on 05/04/2019 at 08:08 PM");
INSERT INTO crm_audit_log VALUES("5154","2","4","2019-04-05 20:58:04","Entry Invoice [Invoice No: 21046] updated by Yasir  Rahman on 05/04/2019 at 08:58 PM");
INSERT INTO crm_audit_log VALUES("5155","3","5","2019-04-05 21:29:47","Exit Invoice [Invoice No: 119532] updated by Imran  Khan on 05/04/2019 at 09:29 PM");
INSERT INTO crm_audit_log VALUES("5156","3","5","2019-04-05 21:54:26","Exit Invoice [Invoice No: 119533] updated by Imran  Khan on 05/04/2019 at 09:54 PM");
INSERT INTO crm_audit_log VALUES("5157","3","5","2019-04-05 23:40:48","Exit Invoice [Invoice No: 119534] updated by Imran  Khan on 05/04/2019 at 11:40 PM");
INSERT INTO crm_audit_log VALUES("5158","3","5","2019-04-06 02:01:57","Exit Invoice [Invoice No: 119535] updated by Imran  Khan on 06/04/2019 at 02:01 AM");
INSERT INTO crm_audit_log VALUES("5159","3","5","2019-04-06 02:02:31","Exit Invoice [Invoice No: 119536] updated by Imran  Khan on 06/04/2019 at 02:02 AM");
INSERT INTO crm_audit_log VALUES("5160","3","5","2019-04-06 02:03:05","Exit Invoice [Invoice No: 119537] updated by Imran  Khan on 06/04/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("5161","3","5","2019-04-06 02:03:43","Exit Invoice [Invoice No: 119538] updated by Imran  Khan on 06/04/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("5162","2","4","2019-04-06 02:21:25","Entry Invoice [Invoice No: 21047] updated by Yasir  Rahman on 06/04/2019 at 02:21 AM");
INSERT INTO crm_audit_log VALUES("5163","2","4","2019-04-06 02:28:39","Entry Invoice [Invoice No: 21048] updated by Yasir  Rahman on 06/04/2019 at 02:28 AM");
INSERT INTO crm_audit_log VALUES("5164","2","4","2019-04-06 02:32:50","Entry Invoice [Invoice No: 21049] updated by Yasir  Rahman on 06/04/2019 at 02:32 AM");
INSERT INTO crm_audit_log VALUES("5165","2","4","2019-04-06 06:49:18","Entry Invoice [Invoice No: 21050] updated by Yasir  Rahman on 06/04/2019 at 06:49 AM");
INSERT INTO crm_audit_log VALUES("5166","3","15","2019-04-06 08:55:03","Exit Invoice [Invoice No: 119539] updated by Abdul Rasheed on 06/04/2019 at 08:55 AM");
INSERT INTO crm_audit_log VALUES("5167","2","6","2019-04-06 10:23:44","Entry Invoice [Invoice No: 21051] updated by ASHRAF  M K on 06/04/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("5168","2","6","2019-04-06 10:25:49","Entry Invoice [Invoice No: 21052] updated by ASHRAF  M K on 06/04/2019 at 10:25 AM");
INSERT INTO crm_audit_log VALUES("5169","3","15","2019-04-06 10:34:50","Exit Invoice [Invoice No: 119540] updated by Abdul Rasheed on 06/04/2019 at 10:34 AM");
INSERT INTO crm_audit_log VALUES("5170","3","15","2019-04-06 10:43:00","Exit Invoice [Invoice No: 119541] updated by Abdul Rasheed on 06/04/2019 at 10:43 AM");
INSERT INTO crm_audit_log VALUES("5171","2","6","2019-04-06 10:46:50","Entry Invoice [Invoice No: 21053] updated by ASHRAF  M K on 06/04/2019 at 10:46 AM");
INSERT INTO crm_audit_log VALUES("5172","3","15","2019-04-06 10:52:14","Exit Invoice [Invoice No: 119542] updated by Abdul Rasheed on 06/04/2019 at 10:52 AM");
INSERT INTO crm_audit_log VALUES("5173","2","6","2019-04-06 10:53:48","Entry Invoice [Invoice No: 21054] updated by ASHRAF  M K on 06/04/2019 at 10:53 AM");
INSERT INTO crm_audit_log VALUES("5174","2","6","2019-04-06 11:47:00","Entry Invoice [Invoice No: 21055] updated by ASHRAF  M K on 06/04/2019 at 11:47 AM");
INSERT INTO crm_audit_log VALUES("5175","2","6","2019-04-06 11:50:16","Entry Invoice [Invoice No: 21056] updated by ASHRAF  M K on 06/04/2019 at 11:50 AM");
INSERT INTO crm_audit_log VALUES("5176","2","6","2019-04-06 13:02:46","Entry Invoice [Invoice No: 21057] updated by ASHRAF  M K on 06/04/2019 at 01:02 PM");
INSERT INTO crm_audit_log VALUES("5177","2","7","2019-04-06 13:19:35","Entry Invoice [Invoice No: 21058] updated by ALSED ABU SHAMA on 06/04/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("5178","2","7","2019-04-06 13:21:06","Entry Invoice [Invoice No: 21059] updated by ALSED ABU SHAMA on 06/04/2019 at 01:21 PM");
INSERT INTO crm_audit_log VALUES("5179","2","7","2019-04-06 16:24:23","Entry Invoice [Invoice No: 21060] updated by ALSED ABU SHAMA on 06/04/2019 at 04:24 PM");
INSERT INTO crm_audit_log VALUES("5180","2","7","2019-04-06 16:29:06","Entry Invoice [Invoice No: 21061] updated by ALSED ABU SHAMA on 06/04/2019 at 04:29 PM");
INSERT INTO crm_audit_log VALUES("5181","3","4","2019-04-06 16:38:00","Exit Invoice [Invoice No: 119543] updated by Yasir  Rahman on 06/04/2019 at 04:38 PM");
INSERT INTO crm_audit_log VALUES("5182","3","4","2019-04-06 17:52:22","Exit Invoice [Invoice No: 119544] updated by Yasir  Rahman on 06/04/2019 at 05:52 PM");
INSERT INTO crm_audit_log VALUES("5183","2","7","2019-04-06 18:11:10","Entry Invoice [Invoice No: 21062] updated by ALSED ABU SHAMA on 06/04/2019 at 06:11 PM");
INSERT INTO crm_audit_log VALUES("5184","2","7","2019-04-06 18:22:19","Entry Invoice [Invoice No: 21063] updated by ALSED ABU SHAMA on 06/04/2019 at 06:22 PM");
INSERT INTO crm_audit_log VALUES("5185","3","4","2019-04-06 19:10:36","Exit Invoice [Invoice No: 119545] updated by Yasir  Rahman on 06/04/2019 at 07:10 PM");
INSERT INTO crm_audit_log VALUES("5186","3","5","2019-04-06 20:56:40","Exit Invoice [Invoice No: 119546] updated by Imran  Khan on 06/04/2019 at 08:56 PM");
INSERT INTO crm_audit_log VALUES("5187","2","4","2019-04-06 21:06:01","Entry Invoice [Invoice No: 21064] updated by Yasir  Rahman on 06/04/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("5188","2","4","2019-04-06 21:07:19","Entry Invoice [Invoice No: 21065] updated by Yasir  Rahman on 06/04/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("5189","2","4","2019-04-06 21:36:03","Entry Invoice [Invoice No: 21066] updated by Yasir  Rahman on 06/04/2019 at 09:36 PM");
INSERT INTO crm_audit_log VALUES("5190","2","4","2019-04-06 21:42:55","Entry Invoice [Invoice No: 21067] updated by Yasir  Rahman on 06/04/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("5191","3","5","2019-04-06 21:53:37","Exit Invoice [Invoice No: 119547] updated by Imran  Khan on 06/04/2019 at 09:53 PM");
INSERT INTO crm_audit_log VALUES("5192","2","4","2019-04-06 23:23:28","Entry Invoice [Invoice No: 21068] updated by Yasir  Rahman on 06/04/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("5193","2","4","2019-04-07 02:22:47","Entry Invoice [Invoice No: 21069] updated by Yasir  Rahman on 07/04/2019 at 02:22 AM");
INSERT INTO crm_audit_log VALUES("5194","3","5","2019-04-07 03:30:44","Exit Invoice [Invoice No: 119548] updated by Imran  Khan on 07/04/2019 at 03:30 AM");
INSERT INTO crm_audit_log VALUES("5195","3","5","2019-04-07 05:05:52","Exit Invoice [Invoice No: 119549] updated by Imran  Khan on 07/04/2019 at 05:05 AM");
INSERT INTO crm_audit_log VALUES("5196","2","4","2019-04-07 06:35:14","Entry Invoice [Invoice No: 21070] updated by Yasir  Rahman on 07/04/2019 at 06:35 AM");
INSERT INTO crm_audit_log VALUES("5197","3","5","2019-04-07 06:36:40","Exit Invoice [Invoice No: 119550] updated by Imran  Khan on 07/04/2019 at 06:36 AM");
INSERT INTO crm_audit_log VALUES("5198","2","6","2019-04-07 08:39:54","Entry Invoice [Invoice No: 21067] updated by ASHRAF  M K on 07/04/2019 at 08:39 AM");
INSERT INTO crm_audit_log VALUES("5199","2","6","2019-04-07 10:30:15","Entry Invoice [Invoice No: 21071] updated by ASHRAF  M K on 07/04/2019 at 10:30 AM");
INSERT INTO crm_audit_log VALUES("5200","2","6","2019-04-07 10:37:43","Entry Invoice [Invoice No: 21072] updated by ASHRAF  M K on 07/04/2019 at 10:37 AM");
INSERT INTO crm_audit_log VALUES("5201","2","6","2019-04-07 10:45:44","Entry Invoice [Invoice No: 21073] updated by ASHRAF  M K on 07/04/2019 at 10:45 AM");
INSERT INTO crm_audit_log VALUES("5202","2","6","2019-04-07 11:10:51","Entry Invoice [Invoice No: 21074] updated by ASHRAF  M K on 07/04/2019 at 11:10 AM");
INSERT INTO crm_audit_log VALUES("5203","3","15","2019-04-07 12:38:27","Exit Invoice [Invoice No: 119551] updated by Abdul Rasheed on 07/04/2019 at 12:38 PM");
INSERT INTO crm_audit_log VALUES("5204","2","7","2019-04-07 16:29:06","Entry Invoice [Invoice No: 21075] updated by ALSED ABU SHAMA on 07/04/2019 at 04:29 PM");
INSERT INTO crm_audit_log VALUES("5205","2","7","2019-04-07 16:29:49","Entry Invoice [Invoice No: 21076] updated by ALSED ABU SHAMA on 07/04/2019 at 04:29 PM");
INSERT INTO crm_audit_log VALUES("5206","3","4","2019-04-07 16:36:23","Exit Invoice [Invoice No: 119552] updated by Yasir  Rahman on 07/04/2019 at 04:36 PM");
INSERT INTO crm_audit_log VALUES("5207","3","4","2019-04-07 16:51:52","Exit Invoice [Invoice No: 119553] updated by Yasir  Rahman on 07/04/2019 at 04:51 PM");
INSERT INTO crm_audit_log VALUES("5208","3","4","2019-04-07 18:52:18","Exit Invoice [Invoice No: 119554] updated by Yasir  Rahman on 07/04/2019 at 06:52 PM");
INSERT INTO crm_audit_log VALUES("5209","3","5","2019-04-07 21:11:55","Exit Invoice [Invoice No: 119555] updated by Imran  Khan on 07/04/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("5210","2","4","2019-04-07 21:18:10","Entry Invoice [Invoice No: 21077] updated by Yasir  Rahman on 07/04/2019 at 09:18 PM");
INSERT INTO crm_audit_log VALUES("5211","3","5","2019-04-07 21:19:41","Exit Invoice [Invoice No: 119556] updated by Imran  Khan on 07/04/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("5212","2","4","2019-04-07 21:20:10","Entry Invoice [Invoice No: 21078] updated by Yasir  Rahman on 07/04/2019 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("5213","3","5","2019-04-07 21:20:20","Exit Invoice [Invoice No: 119557] updated by Imran  Khan on 07/04/2019 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("5214","3","5","2019-04-07 21:20:54","Exit Invoice [Invoice No: 119558] updated by Imran  Khan on 07/04/2019 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("5215","2","4","2019-04-07 21:21:29","Entry Invoice [Invoice No: 21079] updated by Yasir  Rahman on 07/04/2019 at 09:21 PM");
INSERT INTO crm_audit_log VALUES("5216","2","4","2019-04-07 23:29:56","Entry Invoice [Invoice No: 21080] updated by Yasir  Rahman on 07/04/2019 at 11:29 PM");
INSERT INTO crm_audit_log VALUES("5217","3","5","2019-04-08 00:28:44","Exit Invoice [Invoice No: 119559] updated by Imran  Khan on 08/04/2019 at 12:28 AM");
INSERT INTO crm_audit_log VALUES("5218","3","5","2019-04-08 01:57:58","Exit Invoice [Invoice No: 119560] updated by Imran  Khan on 08/04/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("5219","3","5","2019-04-08 05:50:48","Exit Invoice [Invoice No: 119561] updated by Imran  Khan on 08/04/2019 at 05:50 AM");
INSERT INTO crm_audit_log VALUES("5220","3","5","2019-04-08 07:24:58","Exit Invoice [Invoice No: 119562] updated by Imran  Khan on 08/04/2019 at 07:24 AM");
INSERT INTO crm_audit_log VALUES("5221","1","15","2019-04-08 08:06:55","Customer [Customer No: 434] updated by Abdul Rasheed on 08/04/2019 at 08:06 AM");
INSERT INTO crm_audit_log VALUES("5222","3","15","2019-04-08 08:08:56","Exit Invoice [Invoice No: 119563] updated by Abdul Rasheed on 08/04/2019 at 08:08 AM");
INSERT INTO crm_audit_log VALUES("5223","3","15","2019-04-08 08:51:17","Exit Invoice [Invoice No: 119564] updated by Abdul Rasheed on 08/04/2019 at 08:51 AM");
INSERT INTO crm_audit_log VALUES("5224","3","15","2019-04-08 10:26:16","Exit Invoice [Invoice No: 119565] updated by Abdul Rasheed on 08/04/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("5225","3","15","2019-04-08 10:27:45","Exit Invoice [Invoice No: 119566] updated by Abdul Rasheed on 08/04/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("5226","3","15","2019-04-08 10:43:00","Exit Invoice [Invoice No: 119567] updated by Abdul Rasheed on 08/04/2019 at 10:43 AM");
INSERT INTO crm_audit_log VALUES("5227","3","15","2019-04-08 12:09:24","Exit Invoice [Invoice No: 119568] updated by Abdul Rasheed on 08/04/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("5228","1","6","2019-04-08 13:03:16","Customer [Customer No: 435] updated by ASHRAF  M K on 08/04/2019 at 01:03 PM");
INSERT INTO crm_audit_log VALUES("5229","2","7","2019-04-08 13:47:22","Entry Invoice [Invoice No: 21081] updated by ALSED ABU SHAMA on 08/04/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("5230","3","4","2019-04-08 16:18:49","Exit Invoice [Invoice No: 119569] updated by Yasir  Rahman on 08/04/2019 at 04:18 PM");
INSERT INTO crm_audit_log VALUES("5231","2","7","2019-04-08 16:59:00","Entry Invoice [Invoice No: 21082] updated by ALSED ABU SHAMA on 08/04/2019 at 04:59 PM");
INSERT INTO crm_audit_log VALUES("5232","3","4","2019-04-08 19:30:19","Exit Invoice [Invoice No: 119570] updated by Yasir  Rahman on 08/04/2019 at 07:30 PM");
INSERT INTO crm_audit_log VALUES("5233","3","4","2019-04-08 19:31:57","Exit Invoice [Invoice No: 119571] updated by Yasir  Rahman on 08/04/2019 at 07:31 PM");
INSERT INTO crm_audit_log VALUES("5234","2","7","2019-04-08 19:43:10","Entry Invoice [Invoice No: 21083] updated by ALSED ABU SHAMA on 08/04/2019 at 07:43 PM");
INSERT INTO crm_audit_log VALUES("5235","2","4","2019-04-08 21:37:21","Entry Invoice [Invoice No: 21084] updated by Yasir  Rahman on 08/04/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("5236","3","5","2019-04-08 21:47:01","Exit Invoice [Invoice No: 119572] updated by Imran  Khan on 08/04/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("5237","3","5","2019-04-09 02:19:24","Exit Invoice [Invoice No: 119573] updated by Imran  Khan on 09/04/2019 at 02:19 AM");
INSERT INTO crm_audit_log VALUES("5238","2","4","2019-04-09 05:23:46","Entry Invoice [Invoice No: 21085] updated by Yasir  Rahman on 09/04/2019 at 05:23 AM");
INSERT INTO crm_audit_log VALUES("5239","2","4","2019-04-09 05:26:08","Entry Invoice [Invoice No: 21086] updated by Yasir  Rahman on 09/04/2019 at 05:26 AM");
INSERT INTO crm_audit_log VALUES("5240","2","4","2019-04-09 05:27:55","Entry Invoice [Invoice No: 21087] updated by Yasir  Rahman on 09/04/2019 at 05:27 AM");
INSERT INTO crm_audit_log VALUES("5241","2","4","2019-04-09 05:29:37","Entry Invoice [Invoice No: 21088] updated by Yasir  Rahman on 09/04/2019 at 05:29 AM");
INSERT INTO crm_audit_log VALUES("5242","2","4","2019-04-09 05:31:38","Entry Invoice [Invoice No: 21089] updated by Yasir  Rahman on 09/04/2019 at 05:31 AM");
INSERT INTO crm_audit_log VALUES("5243","2","4","2019-04-09 05:33:38","Entry Invoice [Invoice No: 21090] updated by Yasir  Rahman on 09/04/2019 at 05:33 AM");
INSERT INTO crm_audit_log VALUES("5244","2","4","2019-04-09 05:36:18","Entry Invoice [Invoice No: 21091] updated by Yasir  Rahman on 09/04/2019 at 05:36 AM");
INSERT INTO crm_audit_log VALUES("5245","3","15","2019-04-09 09:26:46","Exit Invoice [Invoice No: 119574] updated by Abdul Rasheed on 09/04/2019 at 09:26 AM");
INSERT INTO crm_audit_log VALUES("5246","3","15","2019-04-09 09:55:33","Exit Invoice [Invoice No: 119575] updated by Abdul Rasheed on 09/04/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("5247","2","6","2019-04-09 09:56:32","Entry Invoice [Invoice No: 21092] updated by ASHRAF  M K on 09/04/2019 at 09:56 AM");
INSERT INTO crm_audit_log VALUES("5248","3","15","2019-04-09 09:57:01","Exit Invoice [Invoice No: 119576] updated by Abdul Rasheed on 09/04/2019 at 09:57 AM");
INSERT INTO crm_audit_log VALUES("5249","2","6","2019-04-09 10:41:02","Entry Invoice [Invoice No: 21093] updated by ASHRAF  M K on 09/04/2019 at 10:41 AM");
INSERT INTO crm_audit_log VALUES("5250","2","6","2019-04-09 10:43:01","Entry Invoice [Invoice No: 21094] updated by ASHRAF  M K on 09/04/2019 at 10:43 AM");
INSERT INTO crm_audit_log VALUES("5251","3","15","2019-04-09 11:45:55","Exit Invoice [Invoice No: 119577] updated by Abdul Rasheed on 09/04/2019 at 11:45 AM");
INSERT INTO crm_audit_log VALUES("5252","3","15","2019-04-09 11:48:45","Exit Invoice [Invoice No: 119578] updated by Abdul Rasheed on 09/04/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("5253","2","6","2019-04-09 11:57:57","Entry Invoice [Invoice No: 21095] updated by ASHRAF  M K on 09/04/2019 at 11:57 AM");
INSERT INTO crm_audit_log VALUES("5254","2","7","2019-04-09 13:03:10","Entry Invoice [Invoice No: 21096] updated by ALSED ABU SHAMA on 09/04/2019 at 01:03 PM");
INSERT INTO crm_audit_log VALUES("5255","3","15","2019-04-09 14:38:33","Exit Invoice [Invoice No: 119579] updated by Abdul Rasheed on 09/04/2019 at 02:38 PM");
INSERT INTO crm_audit_log VALUES("5256","3","15","2019-04-09 14:55:34","Exit Invoice [Invoice No: 119580] updated by Abdul Rasheed on 09/04/2019 at 02:55 PM");
INSERT INTO crm_audit_log VALUES("5257","2","6","2019-04-09 15:45:21","Entry Invoice [Invoice No: 21097] updated by ASHRAF  M K on 09/04/2019 at 03:45 PM");
INSERT INTO crm_audit_log VALUES("5258","2","6","2019-04-09 15:46:51","Entry Invoice [Invoice No: 21098] updated by ASHRAF  M K on 09/04/2019 at 03:46 PM");
INSERT INTO crm_audit_log VALUES("5259","3","4","2019-04-09 16:35:58","Exit Invoice [Invoice No: 119581] updated by Yasir  Rahman on 09/04/2019 at 04:35 PM");
INSERT INTO crm_audit_log VALUES("5260","3","4","2019-04-09 17:04:45","Exit Invoice [Invoice No: 119582] updated by Yasir  Rahman on 09/04/2019 at 05:04 PM");
INSERT INTO crm_audit_log VALUES("5261","3","4","2019-04-09 18:48:53","Exit Invoice [Invoice No: 119583] updated by Yasir  Rahman on 09/04/2019 at 06:48 PM");
INSERT INTO crm_audit_log VALUES("5262","3","5","2019-04-09 20:16:12","Exit Invoice [Invoice No: 119584] updated by Imran  Khan on 09/04/2019 at 08:16 PM");
INSERT INTO crm_audit_log VALUES("5263","2","4","2019-04-09 20:50:59","Entry Invoice [Invoice No: 21099] updated by Yasir  Rahman on 09/04/2019 at 08:50 PM");
INSERT INTO crm_audit_log VALUES("5264","2","4","2019-04-09 20:54:42","Entry Invoice [Invoice No: 21100] updated by Yasir  Rahman on 09/04/2019 at 08:54 PM");
INSERT INTO crm_audit_log VALUES("5265","2","4","2019-04-09 20:56:24","Entry Invoice [Invoice No: 21101] updated by Yasir  Rahman on 09/04/2019 at 08:56 PM");
INSERT INTO crm_audit_log VALUES("5266","2","4","2019-04-09 20:58:17","Entry Invoice [Invoice No: 21102] updated by Yasir  Rahman on 09/04/2019 at 08:58 PM");
INSERT INTO crm_audit_log VALUES("5267","3","5","2019-04-10 01:47:04","Exit Invoice [Invoice No: 119585] updated by Imran  Khan on 10/04/2019 at 01:47 AM");
INSERT INTO crm_audit_log VALUES("5268","3","5","2019-04-10 01:48:46","Exit Invoice [Invoice No: 119586] updated by Imran  Khan on 10/04/2019 at 01:48 AM");
INSERT INTO crm_audit_log VALUES("5269","2","4","2019-04-10 03:35:57","Entry Invoice [Invoice No: 21103] updated by Yasir  Rahman on 10/04/2019 at 03:35 AM");
INSERT INTO crm_audit_log VALUES("5270","2","4","2019-04-10 03:39:10","Entry Invoice [Invoice No: 21104] updated by Yasir  Rahman on 10/04/2019 at 03:39 AM");
INSERT INTO crm_audit_log VALUES("5271","3","5","2019-04-10 04:50:10","Exit Invoice [Invoice No: 119587] updated by Imran  Khan on 10/04/2019 at 04:50 AM");
INSERT INTO crm_audit_log VALUES("5272","2","4","2019-04-10 04:53:00","Entry Invoice [Invoice No: 21105] updated by Yasir  Rahman on 10/04/2019 at 04:53 AM");
INSERT INTO crm_audit_log VALUES("5273","2","4","2019-04-10 07:05:01","Entry Invoice [Invoice No: 21106] updated by Yasir  Rahman on 10/04/2019 at 07:05 AM");
INSERT INTO crm_audit_log VALUES("5274","2","4","2019-04-10 07:09:36","Entry Invoice [Invoice No: 21107] updated by Yasir  Rahman on 10/04/2019 at 07:09 AM");
INSERT INTO crm_audit_log VALUES("5275","2","4","2019-04-10 07:11:32","Entry Invoice [Invoice No: 21108] updated by Yasir  Rahman on 10/04/2019 at 07:11 AM");
INSERT INTO crm_audit_log VALUES("5276","2","4","2019-04-10 07:13:46","Entry Invoice [Invoice No: 21109] updated by Yasir  Rahman on 10/04/2019 at 07:13 AM");
INSERT INTO crm_audit_log VALUES("5277","3","15","2019-04-10 08:44:36","Exit Invoice [Invoice No: 119588] updated by Abdul Rasheed on 10/04/2019 at 08:44 AM");
INSERT INTO crm_audit_log VALUES("5278","3","15","2019-04-10 10:52:32","Exit Invoice [Invoice No: 119589] updated by Abdul Rasheed on 10/04/2019 at 10:52 AM");
INSERT INTO crm_audit_log VALUES("5279","3","15","2019-04-10 10:57:10","Exit Invoice [Invoice No: 119590] updated by Abdul Rasheed on 10/04/2019 at 10:57 AM");
INSERT INTO crm_audit_log VALUES("5280","2","6","2019-04-10 11:06:23","Entry Invoice [Invoice No: 21110] updated by ASHRAF  M K on 10/04/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("5281","3","15","2019-04-10 11:06:32","Exit Invoice [Invoice No: 119591] updated by Abdul Rasheed on 10/04/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("5282","2","6","2019-04-10 11:13:03","Entry Invoice [Invoice No: 21111] updated by ASHRAF  M K on 10/04/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("5283","3","15","2019-04-10 12:04:02","Exit Invoice [Invoice No: 119592] updated by Abdul Rasheed on 10/04/2019 at 12:04 PM");
INSERT INTO crm_audit_log VALUES("5284","2","6","2019-04-10 12:08:33","Entry Invoice [Invoice No: 21112] updated by ASHRAF  M K on 10/04/2019 at 12:08 PM");
INSERT INTO crm_audit_log VALUES("5285","2","6","2019-04-10 12:09:33","Entry Invoice [Invoice No: 21113] updated by ASHRAF  M K on 10/04/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("5286","3","15","2019-04-10 12:18:36","Exit Invoice [Invoice No: 119593] updated by Abdul Rasheed on 10/04/2019 at 12:18 PM");
INSERT INTO crm_audit_log VALUES("5287","2","6","2019-04-10 12:33:11","Entry Invoice [Invoice No: 21114] updated by ASHRAF  M K on 10/04/2019 at 12:33 PM");
INSERT INTO crm_audit_log VALUES("5288","2","6","2019-04-10 12:35:51","Entry Invoice [Invoice No: 21115] updated by ASHRAF  M K on 10/04/2019 at 12:35 PM");
INSERT INTO crm_audit_log VALUES("5289","2","6","2019-04-10 12:38:09","Entry Invoice [Invoice No: 21116] updated by ASHRAF  M K on 10/04/2019 at 12:38 PM");
INSERT INTO crm_audit_log VALUES("5290","2","6","2019-04-10 12:40:10","Entry Invoice [Invoice No: 21117] updated by ASHRAF  M K on 10/04/2019 at 12:40 PM");
INSERT INTO crm_audit_log VALUES("5291","3","15","2019-04-10 14:19:56","Exit Invoice [Invoice No: 119594] updated by Abdul Rasheed on 10/04/2019 at 02:19 PM");
INSERT INTO crm_audit_log VALUES("5292","2","6","2019-04-10 14:29:58","Entry Invoice [Invoice No: 21118] updated by ASHRAF  M K on 10/04/2019 at 02:29 PM");
INSERT INTO crm_audit_log VALUES("5293","2","6","2019-04-10 15:05:45","Entry Invoice [Invoice No: 21097] updated by ASHRAF  M K on 10/04/2019 at 03:05 PM");
INSERT INTO crm_audit_log VALUES("5294","3","4","2019-04-10 16:45:10","Exit Invoice [Invoice No: 119595] updated by Yasir  Rahman on 10/04/2019 at 04:45 PM");
INSERT INTO crm_audit_log VALUES("5295","3","4","2019-04-10 16:45:54","Exit Invoice [Invoice No: 119596] updated by Yasir  Rahman on 10/04/2019 at 04:45 PM");
INSERT INTO crm_audit_log VALUES("5296","3","4","2019-04-10 16:46:29","Exit Invoice [Invoice No: 119597] updated by Yasir  Rahman on 10/04/2019 at 04:46 PM");
INSERT INTO crm_audit_log VALUES("5297","2","7","2019-04-10 17:43:53","Entry Invoice [Invoice No: 21119] updated by ALSED ABU SHAMA on 10/04/2019 at 05:43 PM");
INSERT INTO crm_audit_log VALUES("5298","3","4","2019-04-10 18:51:32","Exit Invoice [Invoice No: 119598] updated by Yasir  Rahman on 10/04/2019 at 06:51 PM");
INSERT INTO crm_audit_log VALUES("5299","3","5","2019-04-10 20:32:45","Exit Invoice [Invoice No: 119599] updated by Imran  Khan on 10/04/2019 at 08:32 PM");
INSERT INTO crm_audit_log VALUES("5300","2","4","2019-04-10 21:17:21","Entry Invoice [Invoice No: 21120] updated by Yasir  Rahman on 10/04/2019 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("5301","3","5","2019-04-10 23:32:13","Exit Invoice [Invoice No: 119600] updated by Imran  Khan on 10/04/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("5302","2","4","2019-04-11 00:57:08","Entry Invoice [Invoice No: 21121] updated by Yasir  Rahman on 11/04/2019 at 12:57 AM");
INSERT INTO crm_audit_log VALUES("5303","2","4","2019-04-11 01:08:50","Entry Invoice [Invoice No: 21122] updated by Yasir  Rahman on 11/04/2019 at 01:08 AM");
INSERT INTO crm_audit_log VALUES("5304","3","5","2019-04-11 01:28:43","Exit Invoice [Invoice No: 119601] updated by Imran  Khan on 11/04/2019 at 01:28 AM");
INSERT INTO crm_audit_log VALUES("5305","2","4","2019-04-11 02:02:20","Entry Invoice [Invoice No: 21123] updated by Yasir  Rahman on 11/04/2019 at 02:02 AM");
INSERT INTO crm_audit_log VALUES("5306","2","4","2019-04-11 02:23:55","Entry Invoice [Invoice No: 21124] updated by Yasir  Rahman on 11/04/2019 at 02:23 AM");
INSERT INTO crm_audit_log VALUES("5307","2","4","2019-04-11 02:25:41","Entry Invoice [Invoice No: 21125] updated by Yasir  Rahman on 11/04/2019 at 02:25 AM");
INSERT INTO crm_audit_log VALUES("5308","3","5","2019-04-11 03:13:38","Exit Invoice [Invoice No: 119602] updated by Imran  Khan on 11/04/2019 at 03:13 AM");
INSERT INTO crm_audit_log VALUES("5309","3","5","2019-04-11 03:14:23","Exit Invoice [Invoice No: 119603] updated by Imran  Khan on 11/04/2019 at 03:14 AM");
INSERT INTO crm_audit_log VALUES("5310","3","5","2019-04-11 03:15:22","Exit Invoice [Invoice No: 119604] updated by Imran  Khan on 11/04/2019 at 03:15 AM");
INSERT INTO crm_audit_log VALUES("5311","3","5","2019-04-11 04:33:39","Exit Invoice [Invoice No: 119605] updated by Imran  Khan on 11/04/2019 at 04:33 AM");
INSERT INTO crm_audit_log VALUES("5312","3","5","2019-04-11 04:34:15","Exit Invoice [Invoice No: 119606] updated by Imran  Khan on 11/04/2019 at 04:34 AM");
INSERT INTO crm_audit_log VALUES("5313","3","5","2019-04-11 05:24:09","Exit Invoice [Invoice No: 119607] updated by Imran  Khan on 11/04/2019 at 05:24 AM");
INSERT INTO crm_audit_log VALUES("5314","2","6","2019-04-11 08:19:49","Entry Invoice [Invoice No: 21110] updated by ASHRAF  M K on 11/04/2019 at 08:19 AM");
INSERT INTO crm_audit_log VALUES("5315","2","6","2019-04-11 08:20:15","Entry Invoice [Invoice No: 21110] updated by ASHRAF  M K on 11/04/2019 at 08:20 AM");
INSERT INTO crm_audit_log VALUES("5316","2","6","2019-04-11 08:20:45","Entry Invoice [Invoice No: 21111] updated by ASHRAF  M K on 11/04/2019 at 08:20 AM");
INSERT INTO crm_audit_log VALUES("5317","3","15","2019-04-11 10:04:00","Exit Invoice [Invoice No: 119608] updated by Abdul Rasheed on 11/04/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("5318","2","6","2019-04-11 10:05:57","Entry Invoice [Invoice No: 21126] updated by ASHRAF  M K on 11/04/2019 at 10:05 AM");
INSERT INTO crm_audit_log VALUES("5319","3","15","2019-04-11 10:20:12","Exit Invoice [Invoice No: 119609] updated by Abdul Rasheed on 11/04/2019 at 10:20 AM");
INSERT INTO crm_audit_log VALUES("5320","2","6","2019-04-11 10:24:19","Entry Invoice [Invoice No: 21127] updated by ASHRAF  M K on 11/04/2019 at 10:24 AM");
INSERT INTO crm_audit_log VALUES("5321","3","15","2019-04-11 10:26:11","Exit Invoice [Invoice No: 119610] updated by Abdul Rasheed on 11/04/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("5322","2","6","2019-04-11 10:44:56","Entry Invoice [Invoice No: 21128] updated by ASHRAF  M K on 11/04/2019 at 10:44 AM");
INSERT INTO crm_audit_log VALUES("5323","2","6","2019-04-11 10:46:45","Entry Invoice [Invoice No: 21129] updated by ASHRAF  M K on 11/04/2019 at 10:46 AM");
INSERT INTO crm_audit_log VALUES("5324","3","6","2019-04-11 11:05:58","Exit Invoice [Invoice No: 119604] updated by ASHRAF  M K on 11/04/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("5325","3","6","2019-04-11 11:12:11","Exit Invoice [Invoice No: 119611] updated by ASHRAF  M K on 11/04/2019 at 11:12 AM");
INSERT INTO crm_audit_log VALUES("5326","2","6","2019-04-11 14:01:58","Entry Invoice [Invoice No: 21130] updated by ASHRAF  M K on 11/04/2019 at 02:01 PM");
INSERT INTO crm_audit_log VALUES("5327","2","6","2019-04-11 14:02:11","Entry Invoice [Invoice No: 21130] updated by ASHRAF  M K on 11/04/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("5328","2","6","2019-04-11 14:02:25","Entry Invoice [Invoice No: 21130] updated by ASHRAF  M K on 11/04/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("5329","2","6","2019-04-11 15:20:19","Entry Invoice [Invoice No: 21131] updated by ASHRAF  M K on 11/04/2019 at 03:20 PM");
INSERT INTO crm_audit_log VALUES("5330","2","6","2019-04-11 15:23:21","Entry Invoice [Invoice No: 21132] updated by ASHRAF  M K on 11/04/2019 at 03:23 PM");
INSERT INTO crm_audit_log VALUES("5331","3","4","2019-04-11 16:49:01","Exit Invoice [Invoice No: 119612] updated by Yasir  Rahman on 11/04/2019 at 04:49 PM");
INSERT INTO crm_audit_log VALUES("5332","3","4","2019-04-11 17:48:26","Exit Invoice [Invoice No: 119613] updated by Yasir  Rahman on 11/04/2019 at 05:48 PM");
INSERT INTO crm_audit_log VALUES("5333","3","4","2019-04-11 18:52:26","Exit Invoice [Invoice No: 119614] updated by Yasir  Rahman on 11/04/2019 at 06:52 PM");
INSERT INTO crm_audit_log VALUES("5334","3","4","2019-04-11 19:33:30","Exit Invoice [Invoice No: 119615] updated by Yasir  Rahman on 11/04/2019 at 07:33 PM");
INSERT INTO crm_audit_log VALUES("5335","3","4","2019-04-11 20:09:56","Exit Invoice [Invoice No: 119616] updated by Yasir  Rahman on 11/04/2019 at 08:09 PM");
INSERT INTO crm_audit_log VALUES("5336","3","5","2019-04-11 21:13:36","Exit Invoice [Invoice No: 119617] updated by Imran  Khan on 11/04/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("5337","3","5","2019-04-11 23:28:08","Exit Invoice [Invoice No: 119618] updated by Imran  Khan on 11/04/2019 at 11:28 PM");
INSERT INTO crm_audit_log VALUES("5338","3","5","2019-04-12 00:44:55","Exit Invoice [Invoice No: 119619] updated by Imran  Khan on 12/04/2019 at 12:44 AM");
INSERT INTO crm_audit_log VALUES("5339","3","5","2019-04-12 00:45:31","Exit Invoice [Invoice No: 119620] updated by Imran  Khan on 12/04/2019 at 12:45 AM");
INSERT INTO crm_audit_log VALUES("5340","3","5","2019-04-12 00:46:14","Exit Invoice [Invoice No: 119621] updated by Imran  Khan on 12/04/2019 at 12:46 AM");
INSERT INTO crm_audit_log VALUES("5341","3","5","2019-04-12 01:50:49","Exit Invoice [Invoice No: 119622] updated by Imran  Khan on 12/04/2019 at 01:50 AM");
INSERT INTO crm_audit_log VALUES("5342","3","5","2019-04-12 03:51:41","Exit Invoice [Invoice No: 119623] updated by Imran  Khan on 12/04/2019 at 03:51 AM");
INSERT INTO crm_audit_log VALUES("5343","3","5","2019-04-12 04:32:25","Exit Invoice [Invoice No: 119624] updated by Imran  Khan on 12/04/2019 at 04:32 AM");
INSERT INTO crm_audit_log VALUES("5344","3","5","2019-04-12 06:13:55","Exit Invoice [Invoice No: 119625] updated by Imran  Khan on 12/04/2019 at 06:13 AM");
INSERT INTO crm_audit_log VALUES("5345","3","5","2019-04-12 06:14:36","Exit Invoice [Invoice No: 119626] updated by Imran  Khan on 12/04/2019 at 06:14 AM");
INSERT INTO crm_audit_log VALUES("5346","2","4","2019-04-12 06:23:58","Entry Invoice [Invoice No: 21133] updated by Yasir  Rahman on 12/04/2019 at 06:23 AM");
INSERT INTO crm_audit_log VALUES("5347","2","4","2019-04-12 06:26:17","Entry Invoice [Invoice No: 21134] updated by Yasir  Rahman on 12/04/2019 at 06:26 AM");
INSERT INTO crm_audit_log VALUES("5348","3","15","2019-04-12 08:38:24","Exit Invoice [Invoice No: 119627] updated by Abdul Rasheed on 12/04/2019 at 08:38 AM");
INSERT INTO crm_audit_log VALUES("5349","2","7","2019-04-12 08:50:26","Entry Invoice [Invoice No: 21135] updated by ALSED ABU SHAMA on 12/04/2019 at 08:50 AM");
INSERT INTO crm_audit_log VALUES("5350","2","7","2019-04-12 08:51:26","Entry Invoice [Invoice No: 21136] updated by ALSED ABU SHAMA on 12/04/2019 at 08:51 AM");
INSERT INTO crm_audit_log VALUES("5351","2","7","2019-04-12 08:52:11","Entry Invoice [Invoice No: 21137] updated by ALSED ABU SHAMA on 12/04/2019 at 08:52 AM");
INSERT INTO crm_audit_log VALUES("5352","2","7","2019-04-12 08:57:21","Entry Invoice [Invoice No: 21138] updated by ALSED ABU SHAMA on 12/04/2019 at 08:57 AM");
INSERT INTO crm_audit_log VALUES("5353","3","15","2019-04-12 09:12:08","Exit Invoice [Invoice No: 119628] updated by Abdul Rasheed on 12/04/2019 at 09:12 AM");
INSERT INTO crm_audit_log VALUES("5354","3","15","2019-04-12 11:06:24","Exit Invoice [Invoice No: 119629] updated by Abdul Rasheed on 12/04/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("5355","3","15","2019-04-12 11:31:39","Exit Invoice [Invoice No: 119630] updated by Abdul Rasheed on 12/04/2019 at 11:31 AM");
INSERT INTO crm_audit_log VALUES("5356","2","7","2019-04-12 11:36:56","Entry Invoice [Invoice No: 21139] updated by ALSED ABU SHAMA on 12/04/2019 at 11:36 AM");
INSERT INTO crm_audit_log VALUES("5357","2","7","2019-04-12 11:38:04","Entry Invoice [Invoice No: 21140] updated by ALSED ABU SHAMA on 12/04/2019 at 11:38 AM");
INSERT INTO crm_audit_log VALUES("5358","3","15","2019-04-12 13:48:12","Exit Invoice [Invoice No: 119631] updated by Abdul Rasheed on 12/04/2019 at 01:48 PM");
INSERT INTO crm_audit_log VALUES("5359","3","15","2019-04-12 14:39:19","Exit Invoice [Invoice No: 119632] updated by Abdul Rasheed on 12/04/2019 at 02:39 PM");
INSERT INTO crm_audit_log VALUES("5360","3","5","2019-04-12 19:56:05","Exit Invoice [Invoice No: 119633] updated by Imran  Khan on 12/04/2019 at 07:56 PM");
INSERT INTO crm_audit_log VALUES("5361","3","5","2019-04-12 21:01:40","Exit Invoice [Invoice No: 119634] updated by Imran  Khan on 12/04/2019 at 09:01 PM");
INSERT INTO crm_audit_log VALUES("5362","3","5","2019-04-12 22:41:37","Exit Invoice [Invoice No: 119635] updated by Imran  Khan on 12/04/2019 at 10:41 PM");
INSERT INTO crm_audit_log VALUES("5363","2","4","2019-04-12 23:37:04","Entry Invoice [Invoice No: 21141] updated by Yasir  Rahman on 12/04/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("5364","2","4","2019-04-13 03:10:57","Entry Invoice [Invoice No: 21142] updated by Yasir  Rahman on 13/04/2019 at 03:10 AM");
INSERT INTO crm_audit_log VALUES("5365","2","4","2019-04-13 03:23:13","Entry Invoice [Invoice No: 21143] updated by Yasir  Rahman on 13/04/2019 at 03:23 AM");
INSERT INTO crm_audit_log VALUES("5366","2","4","2019-04-13 03:24:21","Entry Invoice [Invoice No: 21144] updated by Yasir  Rahman on 13/04/2019 at 03:24 AM");
INSERT INTO crm_audit_log VALUES("5367","2","4","2019-04-13 03:25:32","Entry Invoice [Invoice No: 21145] updated by Yasir  Rahman on 13/04/2019 at 03:25 AM");
INSERT INTO crm_audit_log VALUES("5368","2","4","2019-04-13 03:26:16","Entry Invoice [Invoice No: 21146] updated by Yasir  Rahman on 13/04/2019 at 03:26 AM");
INSERT INTO crm_audit_log VALUES("5369","2","4","2019-04-13 03:27:04","Entry Invoice [Invoice No: 21147] updated by Yasir  Rahman on 13/04/2019 at 03:27 AM");
INSERT INTO crm_audit_log VALUES("5370","3","5","2019-04-13 04:34:46","Exit Invoice [Invoice No: 119636] updated by Imran  Khan on 13/04/2019 at 04:34 AM");
INSERT INTO crm_audit_log VALUES("5371","2","4","2019-04-13 06:17:20","Entry Invoice [Invoice No: 21148] updated by Yasir  Rahman on 13/04/2019 at 06:17 AM");
INSERT INTO crm_audit_log VALUES("5372","2","6","2019-04-13 08:25:07","Entry Invoice [Invoice No: 21139] updated by ASHRAF  M K on 13/04/2019 at 08:25 AM");
INSERT INTO crm_audit_log VALUES("5373","3","15","2019-04-13 08:52:07","Exit Invoice [Invoice No: 119637] updated by Abdul Rasheed on 13/04/2019 at 08:52 AM");
INSERT INTO crm_audit_log VALUES("5374","2","7","2019-04-13 10:30:15","Entry Invoice [Invoice No: 21149] updated by ALSED ABU SHAMA on 13/04/2019 at 10:30 AM");
INSERT INTO crm_audit_log VALUES("5375","3","15","2019-04-13 10:48:58","Exit Invoice [Invoice No: 119638] updated by Abdul Rasheed on 13/04/2019 at 10:48 AM");
INSERT INTO crm_audit_log VALUES("5376","1","6","2019-04-13 11:21:17","Customer [Customer No: 436] updated by ASHRAF  M K on 13/04/2019 at 11:21 AM");
INSERT INTO crm_audit_log VALUES("5377","2","6","2019-04-13 11:23:21","Entry Invoice [Invoice No: 21150] updated by ASHRAF  M K on 13/04/2019 at 11:23 AM");
INSERT INTO crm_audit_log VALUES("5378","2","6","2019-04-13 11:52:28","Entry Invoice [Invoice No: 21151] updated by ASHRAF  M K on 13/04/2019 at 11:52 AM");
INSERT INTO crm_audit_log VALUES("5379","2","6","2019-04-13 14:03:37","Entry Invoice [Invoice No: 21152] updated by ASHRAF  M K on 13/04/2019 at 02:03 PM");
INSERT INTO crm_audit_log VALUES("5380","2","6","2019-04-13 15:09:59","Entry Invoice [Invoice No: 21153] updated by ASHRAF  M K on 13/04/2019 at 03:09 PM");
INSERT INTO crm_audit_log VALUES("5381","3","4","2019-04-13 17:16:44","Exit Invoice [Invoice No: 119639] updated by Yasir  Rahman on 13/04/2019 at 05:16 PM");
INSERT INTO crm_audit_log VALUES("5382","3","4","2019-04-13 17:23:58","Exit Invoice [Invoice No: 119640] updated by Yasir  Rahman on 13/04/2019 at 05:23 PM");
INSERT INTO crm_audit_log VALUES("5383","2","7","2019-04-13 18:03:12","Entry Invoice [Invoice No: 21154] updated by ALSED ABU SHAMA on 13/04/2019 at 06:03 PM");
INSERT INTO crm_audit_log VALUES("5384","2","7","2019-04-13 18:14:46","Entry Invoice [Invoice No: 21155] updated by ALSED ABU SHAMA on 13/04/2019 at 06:14 PM");
INSERT INTO crm_audit_log VALUES("5385","2","7","2019-04-13 18:17:09","Entry Invoice [Invoice No: 21156] updated by ALSED ABU SHAMA on 13/04/2019 at 06:17 PM");
INSERT INTO crm_audit_log VALUES("5386","2","7","2019-04-13 19:31:26","Entry Invoice [Invoice No: 21157] updated by ALSED ABU SHAMA on 13/04/2019 at 07:31 PM");
INSERT INTO crm_audit_log VALUES("5387","3","5","2019-04-13 20:40:51","Exit Invoice [Invoice No: 119641] updated by Imran  Khan on 13/04/2019 at 08:40 PM");
INSERT INTO crm_audit_log VALUES("5388","3","5","2019-04-13 20:48:26","Exit Invoice [Invoice No: 119642] updated by Imran  Khan on 13/04/2019 at 08:48 PM");
INSERT INTO crm_audit_log VALUES("5389","3","5","2019-04-13 20:49:02","Exit Invoice [Invoice No: 119643] updated by Imran  Khan on 13/04/2019 at 08:49 PM");
INSERT INTO crm_audit_log VALUES("5390","3","5","2019-04-13 23:04:29","Exit Invoice [Invoice No: 119644] updated by Imran  Khan on 13/04/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("5391","3","5","2019-04-14 01:13:49","Exit Invoice [Invoice No: 119645] updated by Imran  Khan on 14/04/2019 at 01:13 AM");
INSERT INTO crm_audit_log VALUES("5392","3","5","2019-04-14 01:15:48","Exit Invoice [Invoice No: 119646] updated by Imran  Khan on 14/04/2019 at 01:15 AM");
INSERT INTO crm_audit_log VALUES("5393","2","6","2019-04-14 08:06:04","Entry Invoice [Invoice No: 21150] updated by ASHRAF  M K on 14/04/2019 at 08:06 AM");
INSERT INTO crm_audit_log VALUES("5394","2","7","2019-04-14 08:57:15","Entry Invoice [Invoice No: 21158] updated by ALSED ABU SHAMA on 14/04/2019 at 08:57 AM");
INSERT INTO crm_audit_log VALUES("5395","2","7","2019-04-14 08:58:22","Entry Invoice [Invoice No: 21159] updated by ALSED ABU SHAMA on 14/04/2019 at 08:58 AM");
INSERT INTO crm_audit_log VALUES("5396","2","7","2019-04-14 09:17:01","Entry Invoice [Invoice No: 21160] updated by ALSED ABU SHAMA on 14/04/2019 at 09:17 AM");
INSERT INTO crm_audit_log VALUES("5397","2","6","2019-04-14 09:48:33","Entry Invoice [Invoice No: 21161] updated by ASHRAF  M K on 14/04/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("5398","2","7","2019-04-14 11:13:50","Entry Invoice [Invoice No: 21162] updated by ALSED ABU SHAMA on 14/04/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("5399","2","7","2019-04-14 11:15:19","Entry Invoice [Invoice No: 21163] updated by ALSED ABU SHAMA on 14/04/2019 at 11:15 AM");
INSERT INTO crm_audit_log VALUES("5400","3","6","2019-04-14 13:46:51","Exit Invoice [Invoice No: 119647] updated by ASHRAF  M K on 14/04/2019 at 01:46 PM");
INSERT INTO crm_audit_log VALUES("5401","2","7","2019-04-14 13:52:49","Entry Invoice [Invoice No: 21164] updated by ALSED ABU SHAMA on 14/04/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("5402","2","7","2019-04-14 14:16:01","Entry Invoice [Invoice No: 21165] updated by ALSED ABU SHAMA on 14/04/2019 at 02:16 PM");
INSERT INTO crm_audit_log VALUES("5403","2","7","2019-04-14 14:34:51","Entry Invoice [Invoice No: 21166] updated by ALSED ABU SHAMA on 14/04/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("5404","2","7","2019-04-14 16:41:12","Entry Invoice [Invoice No: 21167] updated by ALSED ABU SHAMA on 14/04/2019 at 04:41 PM");
INSERT INTO crm_audit_log VALUES("5405","2","7","2019-04-14 16:43:02","Entry Invoice [Invoice No: 21168] updated by ALSED ABU SHAMA on 14/04/2019 at 04:43 PM");
INSERT INTO crm_audit_log VALUES("5406","2","7","2019-04-14 16:44:10","Entry Invoice [Invoice No: 21169] updated by ALSED ABU SHAMA on 14/04/2019 at 04:44 PM");
INSERT INTO crm_audit_log VALUES("5407","3","4","2019-04-14 17:55:44","Exit Invoice [Invoice No: 119648] updated by Yasir  Rahman on 14/04/2019 at 05:55 PM");
INSERT INTO crm_audit_log VALUES("5408","3","4","2019-04-14 18:07:31","Exit Invoice [Invoice No: 119649] updated by Yasir  Rahman on 14/04/2019 at 06:07 PM");
INSERT INTO crm_audit_log VALUES("5409","3","4","2019-04-14 20:00:30","Exit Invoice [Invoice No: 119650] updated by Yasir  Rahman on 14/04/2019 at 08:00 PM");
INSERT INTO crm_audit_log VALUES("5410","3","4","2019-04-14 20:02:09","Exit Invoice [Invoice No: 119651] updated by Yasir  Rahman on 14/04/2019 at 08:02 PM");
INSERT INTO crm_audit_log VALUES("5411","2","4","2019-04-14 22:03:04","Entry Invoice [Invoice No: 21170] updated by Yasir  Rahman on 14/04/2019 at 10:03 PM");
INSERT INTO crm_audit_log VALUES("5412","3","5","2019-04-14 22:39:57","Exit Invoice [Invoice No: 119652] updated by Imran  Khan on 14/04/2019 at 10:39 PM");
INSERT INTO crm_audit_log VALUES("5413","3","5","2019-04-14 23:17:27","Exit Invoice [Invoice No: 119653] updated by Imran  Khan on 14/04/2019 at 11:17 PM");
INSERT INTO crm_audit_log VALUES("5414","3","5","2019-04-14 23:26:16","Exit Invoice [Invoice No: 119654] updated by Imran  Khan on 14/04/2019 at 11:26 PM");
INSERT INTO crm_audit_log VALUES("5415","3","5","2019-04-15 00:26:56","Exit Invoice [Invoice No: 119655] updated by Imran  Khan on 15/04/2019 at 12:26 AM");
INSERT INTO crm_audit_log VALUES("5416","3","5","2019-04-15 04:16:58","Exit Invoice [Invoice No: 119656] updated by Imran  Khan on 15/04/2019 at 04:16 AM");
INSERT INTO crm_audit_log VALUES("5417","2","4","2019-04-15 07:04:04","Entry Invoice [Invoice No: 21171] updated by Yasir  Rahman on 15/04/2019 at 07:04 AM");
INSERT INTO crm_audit_log VALUES("5418","3","15","2019-04-15 08:32:40","Exit Invoice [Invoice No: 119657] updated by Abdul Rasheed on 15/04/2019 at 08:32 AM");
INSERT INTO crm_audit_log VALUES("5419","3","15","2019-04-15 08:33:55","Exit Invoice [Invoice No: 119658] updated by Abdul Rasheed on 15/04/2019 at 08:33 AM");
INSERT INTO crm_audit_log VALUES("5420","2","6","2019-04-15 08:43:32","Entry Invoice [Invoice No: 21161] updated by ASHRAF  M K on 15/04/2019 at 08:43 AM");
INSERT INTO crm_audit_log VALUES("5421","3","15","2019-04-15 09:23:57","Exit Invoice [Invoice No: 119659] updated by Abdul Rasheed on 15/04/2019 at 09:23 AM");
INSERT INTO crm_audit_log VALUES("5422","2","6","2019-04-15 11:00:49","Entry Invoice [Invoice No: 21172] updated by ASHRAF  M K on 15/04/2019 at 11:00 AM");
INSERT INTO crm_audit_log VALUES("5423","3","15","2019-04-15 11:17:45","Exit Invoice [Invoice No: 119660] updated by Abdul Rasheed on 15/04/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("5424","2","6","2019-04-15 11:52:44","Entry Invoice [Invoice No: 21173] updated by ASHRAF  M K on 15/04/2019 at 11:52 AM");
INSERT INTO crm_audit_log VALUES("5425","2","6","2019-04-15 12:03:50","Entry Invoice [Invoice No: 21174] updated by ASHRAF  M K on 15/04/2019 at 12:03 PM");
INSERT INTO crm_audit_log VALUES("5426","2","6","2019-04-15 12:04:47","Entry Invoice [Invoice No: 21175] updated by ASHRAF  M K on 15/04/2019 at 12:04 PM");
INSERT INTO crm_audit_log VALUES("5427","3","15","2019-04-15 14:05:37","Exit Invoice [Invoice No: 119661] updated by Abdul Rasheed on 15/04/2019 at 02:05 PM");
INSERT INTO crm_audit_log VALUES("5428","1","15","2019-04-15 14:08:46","Customer [Customer No: 437] updated by Abdul Rasheed on 15/04/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("5429","3","15","2019-04-15 14:10:04","Exit Invoice [Invoice No: 119662] updated by Abdul Rasheed on 15/04/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("5430","2","7","2019-04-15 14:37:01","Entry Invoice [Invoice No: 21176] updated by ALSED ABU SHAMA on 15/04/2019 at 02:37 PM");
INSERT INTO crm_audit_log VALUES("5431","3","15","2019-04-15 15:15:50","Exit Invoice [Invoice No: 119663] updated by Abdul Rasheed on 15/04/2019 at 03:15 PM");
INSERT INTO crm_audit_log VALUES("5432","2","7","2019-04-15 17:23:40","Entry Invoice [Invoice No: 21177] updated by ALSED ABU SHAMA on 15/04/2019 at 05:23 PM");
INSERT INTO crm_audit_log VALUES("5433","3","4","2019-04-15 17:41:51","Exit Invoice [Invoice No: 119664] updated by Yasir  Rahman on 15/04/2019 at 05:41 PM");
INSERT INTO crm_audit_log VALUES("5434","2","4","2019-04-15 21:38:59","Entry Invoice [Invoice No: 21178] updated by Yasir  Rahman on 15/04/2019 at 09:38 PM");
INSERT INTO crm_audit_log VALUES("5435","3","5","2019-04-15 22:15:33","Exit Invoice [Invoice No: 119665] updated by Imran  Khan on 15/04/2019 at 10:15 PM");
INSERT INTO crm_audit_log VALUES("5436","3","5","2019-04-15 22:26:45","Exit Invoice [Invoice No: 119666] updated by Imran  Khan on 15/04/2019 at 10:26 PM");
INSERT INTO crm_audit_log VALUES("5437","3","5","2019-04-15 22:27:26","Exit Invoice [Invoice No: 119667] updated by Imran  Khan on 15/04/2019 at 10:27 PM");
INSERT INTO crm_audit_log VALUES("5438","3","5","2019-04-15 23:34:48","Exit Invoice [Invoice No: 119668] updated by Imran  Khan on 15/04/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("5439","2","4","2019-04-16 01:23:33","Entry Invoice [Invoice No: 21179] updated by Yasir  Rahman on 16/04/2019 at 01:23 AM");
INSERT INTO crm_audit_log VALUES("5440","3","5","2019-04-16 01:44:44","Exit Invoice [Invoice No: 119669] updated by Imran  Khan on 16/04/2019 at 01:44 AM");
INSERT INTO crm_audit_log VALUES("5441","3","5","2019-04-16 01:45:25","Exit Invoice [Invoice No: 119670] updated by Imran  Khan on 16/04/2019 at 01:45 AM");
INSERT INTO crm_audit_log VALUES("5442","2","4","2019-04-16 02:27:06","Entry Invoice [Invoice No: 21180] updated by Yasir  Rahman on 16/04/2019 at 02:27 AM");
INSERT INTO crm_audit_log VALUES("5443","3","5","2019-04-16 03:32:40","Exit Invoice [Invoice No: 119671] updated by Imran  Khan on 16/04/2019 at 03:32 AM");
INSERT INTO crm_audit_log VALUES("5444","3","5","2019-04-16 03:33:28","Exit Invoice [Invoice No: 119672] updated by Imran  Khan on 16/04/2019 at 03:33 AM");
INSERT INTO crm_audit_log VALUES("5445","3","15","2019-04-16 09:22:41","Exit Invoice [Invoice No: 119673] updated by Abdul Rasheed on 16/04/2019 at 09:22 AM");
INSERT INTO crm_audit_log VALUES("5446","3","15","2019-04-16 09:48:29","Exit Invoice [Invoice No: 119674] updated by Abdul Rasheed on 16/04/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("5447","2","6","2019-04-16 09:51:43","Entry Invoice [Invoice No: 21181] updated by ASHRAF  M K on 16/04/2019 at 09:51 AM");
INSERT INTO crm_audit_log VALUES("5448","2","6","2019-04-16 10:11:04","Entry Invoice [Invoice No: 21182] updated by ASHRAF  M K on 16/04/2019 at 10:11 AM");
INSERT INTO crm_audit_log VALUES("5449","2","6","2019-04-16 10:23:10","Entry Invoice [Invoice No: 21183] updated by ASHRAF  M K on 16/04/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("5450","2","6","2019-04-16 10:24:21","Entry Invoice [Invoice No: 21184] updated by ASHRAF  M K on 16/04/2019 at 10:24 AM");
INSERT INTO crm_audit_log VALUES("5451","3","15","2019-04-16 10:25:27","Exit Invoice [Invoice No: 119675] updated by Abdul Rasheed on 16/04/2019 at 10:25 AM");
INSERT INTO crm_audit_log VALUES("5452","3","15","2019-04-16 11:03:38","Exit Invoice [Invoice No: 119676] updated by Abdul Rasheed on 16/04/2019 at 11:03 AM");
INSERT INTO crm_audit_log VALUES("5453","3","15","2019-04-16 11:41:38","Exit Invoice [Invoice No: 119677] updated by Abdul Rasheed on 16/04/2019 at 11:41 AM");
INSERT INTO crm_audit_log VALUES("5454","2","7","2019-04-16 12:52:56","Entry Invoice [Invoice No: 21185] updated by ALSED ABU SHAMA on 16/04/2019 at 12:52 PM");
INSERT INTO crm_audit_log VALUES("5455","2","7","2019-04-16 12:53:50","Entry Invoice [Invoice No: 21186] updated by ALSED ABU SHAMA on 16/04/2019 at 12:53 PM");
INSERT INTO crm_audit_log VALUES("5456","3","15","2019-04-16 14:02:29","Exit Invoice [Invoice No: 119678] updated by Abdul Rasheed on 16/04/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("5457","2","6","2019-04-16 14:13:11","Entry Invoice [Invoice No: 21187] updated by ASHRAF  M K on 16/04/2019 at 02:13 PM");
INSERT INTO crm_audit_log VALUES("5458","2","6","2019-04-16 15:00:27","Entry Invoice [Invoice No: 21188] updated by ASHRAF  M K on 16/04/2019 at 03:00 PM");
INSERT INTO crm_audit_log VALUES("5459","3","4","2019-04-16 17:35:42","Exit Invoice [Invoice No: 119679] updated by Yasir  Rahman on 16/04/2019 at 05:35 PM");
INSERT INTO crm_audit_log VALUES("5460","3","4","2019-04-16 18:56:14","Exit Invoice [Invoice No: 119680] updated by Yasir  Rahman on 16/04/2019 at 06:56 PM");
INSERT INTO crm_audit_log VALUES("5461","2","7","2019-04-16 19:27:42","Entry Invoice [Invoice No: 21189] updated by ALSED ABU SHAMA on 16/04/2019 at 07:27 PM");
INSERT INTO crm_audit_log VALUES("5462","2","7","2019-04-16 19:33:35","Entry Invoice [Invoice No: 21190] updated by ALSED ABU SHAMA on 16/04/2019 at 07:33 PM");
INSERT INTO crm_audit_log VALUES("5463","3","5","2019-04-16 20:21:21","Exit Invoice [Invoice No: 119681] updated by Imran  Khan on 16/04/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("5464","3","5","2019-04-16 20:22:02","Exit Invoice [Invoice No: 119682] updated by Imran  Khan on 16/04/2019 at 08:22 PM");
INSERT INTO crm_audit_log VALUES("5465","2","4","2019-04-16 22:05:18","Entry Invoice [Invoice No: 21191] updated by Yasir  Rahman on 16/04/2019 at 10:05 PM");
INSERT INTO crm_audit_log VALUES("5466","2","4","2019-04-16 22:10:56","Entry Invoice [Invoice No: 21192] updated by Yasir  Rahman on 16/04/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("5467","2","4","2019-04-16 22:12:57","Entry Invoice [Invoice No: 21193] updated by Yasir  Rahman on 16/04/2019 at 10:12 PM");
INSERT INTO crm_audit_log VALUES("5468","2","4","2019-04-16 22:14:45","Entry Invoice [Invoice No: 21194] updated by Yasir  Rahman on 16/04/2019 at 10:14 PM");
INSERT INTO crm_audit_log VALUES("5469","3","5","2019-04-16 22:34:26","Exit Invoice [Invoice No: 119683] updated by Imran  Khan on 16/04/2019 at 10:34 PM");
INSERT INTO crm_audit_log VALUES("5470","2","4","2019-04-16 22:57:48","Entry Invoice [Invoice No: 21195] updated by Yasir  Rahman on 16/04/2019 at 10:57 PM");
INSERT INTO crm_audit_log VALUES("5471","3","5","2019-04-16 23:51:37","Exit Invoice [Invoice No: 119684] updated by Imran  Khan on 16/04/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("5472","3","5","2019-04-17 01:31:49","Exit Invoice [Invoice No: 119685] updated by Imran  Khan on 17/04/2019 at 01:31 AM");
INSERT INTO crm_audit_log VALUES("5473","3","5","2019-04-17 01:33:02","Exit Invoice [Invoice No: 119686] updated by Imran  Khan on 17/04/2019 at 01:33 AM");
INSERT INTO crm_audit_log VALUES("5474","3","5","2019-04-17 02:14:23","Exit Invoice [Invoice No: 119687] updated by Imran  Khan on 17/04/2019 at 02:14 AM");
INSERT INTO crm_audit_log VALUES("5475","3","6","2019-04-17 09:16:57","Exit Invoice [Invoice No: 119685] updated by ASHRAF  M K on 17/04/2019 at 09:16 AM");
INSERT INTO crm_audit_log VALUES("5476","3","6","2019-04-17 09:17:28","Exit Invoice [Invoice No: 119686] updated by ASHRAF  M K on 17/04/2019 at 09:17 AM");
INSERT INTO crm_audit_log VALUES("5477","3","15","2019-04-17 09:46:39","Exit Invoice [Invoice No: 119688] updated by Abdul Rasheed on 17/04/2019 at 09:46 AM");
INSERT INTO crm_audit_log VALUES("5478","3","15","2019-04-17 09:47:51","Exit Invoice [Invoice No: 119689] updated by Abdul Rasheed on 17/04/2019 at 09:47 AM");
INSERT INTO crm_audit_log VALUES("5479","2","7","2019-04-17 10:39:30","Entry Invoice [Invoice No: 21196] updated by ALSED ABU SHAMA on 17/04/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("5480","3","15","2019-04-17 10:58:50","Exit Invoice [Invoice No: 119690] updated by Abdul Rasheed on 17/04/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("5481","3","15","2019-04-17 11:18:22","Exit Invoice [Invoice No: 119691] updated by Abdul Rasheed on 17/04/2019 at 11:18 AM");
INSERT INTO crm_audit_log VALUES("5482","2","6","2019-04-17 11:54:21","Entry Invoice [Invoice No: 21197] updated by ASHRAF  M K on 17/04/2019 at 11:54 AM");
INSERT INTO crm_audit_log VALUES("5483","2","6","2019-04-17 11:55:47","Entry Invoice [Invoice No: 21198] updated by ASHRAF  M K on 17/04/2019 at 11:55 AM");
INSERT INTO crm_audit_log VALUES("5484","2","6","2019-04-17 12:12:15","Entry Invoice [Invoice No: 21199] updated by ASHRAF  M K on 17/04/2019 at 12:12 PM");
INSERT INTO crm_audit_log VALUES("5485","2","6","2019-04-17 12:18:13","Entry Invoice [Invoice No: 21200] updated by ASHRAF  M K on 17/04/2019 at 12:18 PM");
INSERT INTO crm_audit_log VALUES("5486","3","15","2019-04-17 12:31:18","Exit Invoice [Invoice No: 119692] updated by Abdul Rasheed on 17/04/2019 at 12:31 PM");
INSERT INTO crm_audit_log VALUES("5487","3","15","2019-04-17 12:47:37","Exit Invoice [Invoice No: 119693] updated by Abdul Rasheed on 17/04/2019 at 12:47 PM");
INSERT INTO crm_audit_log VALUES("5488","2","6","2019-04-17 13:43:23","Entry Invoice [Invoice No: 21201] updated by ASHRAF  M K on 17/04/2019 at 01:43 PM");
INSERT INTO crm_audit_log VALUES("5489","2","7","2019-04-17 13:59:13","Entry Invoice [Invoice No: 21202] updated by ALSED ABU SHAMA on 17/04/2019 at 01:59 PM");
INSERT INTO crm_audit_log VALUES("5490","2","7","2019-04-17 14:00:28","Entry Invoice [Invoice No: 21203] updated by ALSED ABU SHAMA on 17/04/2019 at 02:00 PM");
INSERT INTO crm_audit_log VALUES("5491","2","7","2019-04-17 14:01:54","Entry Invoice [Invoice No: 21204] updated by ALSED ABU SHAMA on 17/04/2019 at 02:01 PM");
INSERT INTO crm_audit_log VALUES("5492","2","7","2019-04-17 14:02:56","Entry Invoice [Invoice No: 21205] updated by ALSED ABU SHAMA on 17/04/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("5493","2","7","2019-04-17 14:03:48","Entry Invoice [Invoice No: 21206] updated by ALSED ABU SHAMA on 17/04/2019 at 02:03 PM");
INSERT INTO crm_audit_log VALUES("5494","2","7","2019-04-17 14:23:16","Entry Invoice [Invoice No: 21207] updated by ALSED ABU SHAMA on 17/04/2019 at 02:23 PM");
INSERT INTO crm_audit_log VALUES("5495","2","7","2019-04-17 14:25:16","Entry Invoice [Invoice No: 21208] updated by ALSED ABU SHAMA on 17/04/2019 at 02:25 PM");
INSERT INTO crm_audit_log VALUES("5496","2","7","2019-04-17 15:23:21","Entry Invoice [Invoice No: 21209] updated by ALSED ABU SHAMA on 17/04/2019 at 03:23 PM");
INSERT INTO crm_audit_log VALUES("5497","3","4","2019-04-17 17:51:20","Exit Invoice [Invoice No: 119694] updated by Yasir  Rahman on 17/04/2019 at 05:51 PM");
INSERT INTO crm_audit_log VALUES("5498","3","4","2019-04-17 17:52:35","Exit Invoice [Invoice No: 119695] updated by Yasir  Rahman on 17/04/2019 at 05:52 PM");
INSERT INTO crm_audit_log VALUES("5499","3","4","2019-04-17 17:54:02","Exit Invoice [Invoice No: 119696] updated by Yasir  Rahman on 17/04/2019 at 05:54 PM");
INSERT INTO crm_audit_log VALUES("5500","3","5","2019-04-17 20:36:20","Exit Invoice [Invoice No: 119697] updated by Imran  Khan on 17/04/2019 at 08:36 PM");
INSERT INTO crm_audit_log VALUES("5501","3","5","2019-04-17 21:39:09","Exit Invoice [Invoice No: 119698] updated by Imran  Khan on 17/04/2019 at 09:39 PM");
INSERT INTO crm_audit_log VALUES("5502","3","5","2019-04-17 22:28:28","Exit Invoice [Invoice No: 119699] updated by Imran  Khan on 17/04/2019 at 10:28 PM");
INSERT INTO crm_audit_log VALUES("5503","2","4","2019-04-17 22:55:03","Entry Invoice [Invoice No: 21210] updated by Yasir  Rahman on 17/04/2019 at 10:55 PM");
INSERT INTO crm_audit_log VALUES("5504","3","5","2019-04-18 00:54:53","Exit Invoice [Invoice No: 119700] updated by Imran  Khan on 18/04/2019 at 12:54 AM");
INSERT INTO crm_audit_log VALUES("5505","2","4","2019-04-18 03:42:59","Entry Invoice [Invoice No: 21211] updated by Yasir  Rahman on 18/04/2019 at 03:42 AM");
INSERT INTO crm_audit_log VALUES("5506","2","4","2019-04-18 03:44:42","Entry Invoice [Invoice No: 21212] updated by Yasir  Rahman on 18/04/2019 at 03:44 AM");
INSERT INTO crm_audit_log VALUES("5507","2","4","2019-04-18 03:47:29","Entry Invoice [Invoice No: 21213] updated by Yasir  Rahman on 18/04/2019 at 03:47 AM");
INSERT INTO crm_audit_log VALUES("5508","2","4","2019-04-18 03:48:23","Entry Invoice [Invoice No: 21214] updated by Yasir  Rahman on 18/04/2019 at 03:48 AM");
INSERT INTO crm_audit_log VALUES("5509","3","5","2019-04-18 07:27:10","Exit Invoice [Invoice No: 119701] updated by Imran  Khan on 18/04/2019 at 07:27 AM");
INSERT INTO crm_audit_log VALUES("5510","3","4","2019-04-18 08:56:00","Exit Invoice [Invoice No: 119702] updated by Yasir  Rahman on 18/04/2019 at 08:56 AM");
INSERT INTO crm_audit_log VALUES("5511","3","4","2019-04-18 10:27:37","Exit Invoice [Invoice No: 119703] updated by Yasir  Rahman on 18/04/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("5512","3","6","2019-04-18 11:06:39","Exit Invoice [Invoice No: 119704] updated by ASHRAF  M K on 18/04/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("5513","2","7","2019-04-18 11:13:01","Entry Invoice [Invoice No: 21215] updated by ALSED ABU SHAMA on 18/04/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("5514","3","6","2019-04-18 11:28:05","Exit Invoice [Invoice No: 119705] updated by ASHRAF  M K on 18/04/2019 at 11:28 AM");
INSERT INTO crm_audit_log VALUES("5515","3","6","2019-04-18 11:28:22","Exit Invoice [Invoice No: 119705] updated by ASHRAF  M K on 18/04/2019 at 11:28 AM");
INSERT INTO crm_audit_log VALUES("5516","3","6","2019-04-18 11:56:31","Exit Invoice [Invoice No: 119706] updated by ASHRAF  M K on 18/04/2019 at 11:56 AM");
INSERT INTO crm_audit_log VALUES("5517","3","6","2019-04-18 14:04:06","Exit Invoice [Invoice No: 119707] updated by ASHRAF  M K on 18/04/2019 at 02:04 PM");
INSERT INTO crm_audit_log VALUES("5518","3","6","2019-04-18 14:08:13","Exit Invoice [Invoice No: 119708] updated by ASHRAF  M K on 18/04/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("5519","3","4","2019-04-18 16:20:56","Exit Invoice [Invoice No: 119709] updated by Yasir  Rahman on 18/04/2019 at 04:20 PM");
INSERT INTO crm_audit_log VALUES("5520","2","7","2019-04-18 17:03:10","Entry Invoice [Invoice No: 21216] updated by ALSED ABU SHAMA on 18/04/2019 at 05:03 PM");
INSERT INTO crm_audit_log VALUES("5521","2","7","2019-04-18 17:40:24","Entry Invoice [Invoice No: 21217] updated by ALSED ABU SHAMA on 18/04/2019 at 05:40 PM");
INSERT INTO crm_audit_log VALUES("5522","2","7","2019-04-18 17:44:17","Entry Invoice [Invoice No: 21218] updated by ALSED ABU SHAMA on 18/04/2019 at 05:44 PM");
INSERT INTO crm_audit_log VALUES("5523","2","7","2019-04-18 17:51:27","Entry Invoice [Invoice No: 21219] updated by ALSED ABU SHAMA on 18/04/2019 at 05:51 PM");
INSERT INTO crm_audit_log VALUES("5524","2","7","2019-04-18 18:49:18","Entry Invoice [Invoice No: 21220] updated by ALSED ABU SHAMA on 18/04/2019 at 06:49 PM");
INSERT INTO crm_audit_log VALUES("5525","2","7","2019-04-18 18:50:17","Entry Invoice [Invoice No: 21221] updated by ALSED ABU SHAMA on 18/04/2019 at 06:50 PM");
INSERT INTO crm_audit_log VALUES("5526","2","7","2019-04-18 18:51:05","Entry Invoice [Invoice No: 21222] updated by ALSED ABU SHAMA on 18/04/2019 at 06:51 PM");
INSERT INTO crm_audit_log VALUES("5527","2","7","2019-04-18 18:51:55","Entry Invoice [Invoice No: 21223] updated by ALSED ABU SHAMA on 18/04/2019 at 06:51 PM");
INSERT INTO crm_audit_log VALUES("5528","2","4","2019-04-18 20:29:17","Entry Invoice [Invoice No: 21224] updated by Yasir  Rahman on 18/04/2019 at 08:29 PM");
INSERT INTO crm_audit_log VALUES("5529","3","5","2019-04-18 20:34:09","Exit Invoice [Invoice No: 119710] updated by Imran  Khan on 18/04/2019 at 08:34 PM");
INSERT INTO crm_audit_log VALUES("5530","3","5","2019-04-18 22:05:19","Exit Invoice [Invoice No: 119711] updated by Imran  Khan on 18/04/2019 at 10:05 PM");
INSERT INTO crm_audit_log VALUES("5531","3","5","2019-04-19 01:39:09","Exit Invoice [Invoice No: 119712] updated by Imran  Khan on 19/04/2019 at 01:39 AM");
INSERT INTO crm_audit_log VALUES("5532","2","4","2019-04-19 02:15:56","Entry Invoice [Invoice No: 21225] updated by Yasir  Rahman on 19/04/2019 at 02:15 AM");
INSERT INTO crm_audit_log VALUES("5533","3","5","2019-04-19 02:20:28","Exit Invoice [Invoice No: 119713] updated by Imran  Khan on 19/04/2019 at 02:20 AM");
INSERT INTO crm_audit_log VALUES("5534","3","5","2019-04-19 02:47:52","Exit Invoice [Invoice No: 119714] updated by Imran  Khan on 19/04/2019 at 02:47 AM");
INSERT INTO crm_audit_log VALUES("5535","3","5","2019-04-19 05:58:22","Exit Invoice [Invoice No: 119715] updated by Imran  Khan on 19/04/2019 at 05:58 AM");
INSERT INTO crm_audit_log VALUES("5536","2","4","2019-04-19 06:06:18","Entry Invoice [Invoice No: 21226] updated by Yasir  Rahman on 19/04/2019 at 06:06 AM");
INSERT INTO crm_audit_log VALUES("5537","2","4","2019-04-19 06:17:49","Entry Invoice [Invoice No: 21227] updated by Yasir  Rahman on 19/04/2019 at 06:17 AM");
INSERT INTO crm_audit_log VALUES("5538","2","4","2019-04-19 06:19:26","Entry Invoice [Invoice No: 21228] updated by Yasir  Rahman on 19/04/2019 at 06:19 AM");
INSERT INTO crm_audit_log VALUES("5539","2","4","2019-04-19 06:20:55","Entry Invoice [Invoice No: 21229] updated by Yasir  Rahman on 19/04/2019 at 06:20 AM");
INSERT INTO crm_audit_log VALUES("5540","2","7","2019-04-19 10:03:43","Entry Invoice [Invoice No: 21230] updated by ALSED ABU SHAMA on 19/04/2019 at 10:03 AM");
INSERT INTO crm_audit_log VALUES("5541","3","15","2019-04-19 11:37:25","Exit Invoice [Invoice No: 119716] updated by Abdul Rasheed on 19/04/2019 at 11:37 AM");
INSERT INTO crm_audit_log VALUES("5542","2","7","2019-04-19 16:25:18","Entry Invoice [Invoice No: 21231] updated by ALSED ABU SHAMA on 19/04/2019 at 04:25 PM");
INSERT INTO crm_audit_log VALUES("5543","3","4","2019-04-19 17:34:15","Exit Invoice [Invoice No: 119717] updated by Yasir  Rahman on 19/04/2019 at 05:34 PM");
INSERT INTO crm_audit_log VALUES("5544","3","4","2019-04-19 17:34:54","Exit Invoice [Invoice No: 119718] updated by Yasir  Rahman on 19/04/2019 at 05:34 PM");
INSERT INTO crm_audit_log VALUES("5545","3","4","2019-04-19 17:36:26","Exit Invoice [Invoice No: 119719] updated by Yasir  Rahman on 19/04/2019 at 05:36 PM");
INSERT INTO crm_audit_log VALUES("5546","3","4","2019-04-19 17:37:30","Exit Invoice [Invoice No: 119720] updated by Yasir  Rahman on 19/04/2019 at 05:37 PM");
INSERT INTO crm_audit_log VALUES("5547","3","4","2019-04-19 19:24:29","Exit Invoice [Invoice No: 119721] updated by Yasir  Rahman on 19/04/2019 at 07:24 PM");
INSERT INTO crm_audit_log VALUES("5548","3","4","2019-04-19 19:25:03","Exit Invoice [Invoice No: 119722] updated by Yasir  Rahman on 19/04/2019 at 07:25 PM");
INSERT INTO crm_audit_log VALUES("5549","3","4","2019-04-19 19:26:25","Exit Invoice [Invoice No: 119723] updated by Yasir  Rahman on 19/04/2019 at 07:26 PM");
INSERT INTO crm_audit_log VALUES("5550","2","4","2019-04-19 20:21:40","Entry Invoice [Invoice No: 21232] updated by Yasir  Rahman on 19/04/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("5551","2","4","2019-04-19 21:01:10","Entry Invoice [Invoice No: 21233] updated by Yasir  Rahman on 19/04/2019 at 09:01 PM");
INSERT INTO crm_audit_log VALUES("5552","2","4","2019-04-19 21:02:59","Entry Invoice [Invoice No: 21234] updated by Yasir  Rahman on 19/04/2019 at 09:02 PM");
INSERT INTO crm_audit_log VALUES("5553","3","5","2019-04-19 21:28:22","Exit Invoice [Invoice No: 119724] updated by Imran  Khan on 19/04/2019 at 09:28 PM");
INSERT INTO crm_audit_log VALUES("5554","2","4","2019-04-19 21:36:20","Entry Invoice [Invoice No: 21235] updated by Yasir  Rahman on 19/04/2019 at 09:36 PM");
INSERT INTO crm_audit_log VALUES("5555","2","4","2019-04-19 22:18:42","Entry Invoice [Invoice No: 21236] updated by Yasir  Rahman on 19/04/2019 at 10:18 PM");
INSERT INTO crm_audit_log VALUES("5556","3","5","2019-04-19 23:19:20","Exit Invoice [Invoice No: 119725] updated by Imran  Khan on 19/04/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("5557","3","5","2019-04-19 23:20:07","Exit Invoice [Invoice No: 119726] updated by Imran  Khan on 19/04/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("5558","2","4","2019-04-19 23:23:31","Entry Invoice [Invoice No: 21237] updated by Yasir  Rahman on 19/04/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("5559","3","5","2019-04-19 23:56:28","Exit Invoice [Invoice No: 119727] updated by Imran  Khan on 19/04/2019 at 11:56 PM");
INSERT INTO crm_audit_log VALUES("5560","3","5","2019-04-20 01:51:09","Exit Invoice [Invoice No: 119728] updated by Imran  Khan on 20/04/2019 at 01:51 AM");
INSERT INTO crm_audit_log VALUES("5561","2","4","2019-04-20 02:02:03","Entry Invoice [Invoice No: 21238] updated by Yasir  Rahman on 20/04/2019 at 02:02 AM");
INSERT INTO crm_audit_log VALUES("5562","2","4","2019-04-20 02:26:37","Entry Invoice [Invoice No: 21239] updated by Yasir  Rahman on 20/04/2019 at 02:26 AM");
INSERT INTO crm_audit_log VALUES("5563","2","4","2019-04-20 02:27:33","Entry Invoice [Invoice No: 21240] updated by Yasir  Rahman on 20/04/2019 at 02:27 AM");
INSERT INTO crm_audit_log VALUES("5564","2","4","2019-04-20 03:38:49","Entry Invoice [Invoice No: 21241] updated by Yasir  Rahman on 20/04/2019 at 03:38 AM");
INSERT INTO crm_audit_log VALUES("5565","2","4","2019-04-20 04:23:24","Entry Invoice [Invoice No: 21242] updated by Yasir  Rahman on 20/04/2019 at 04:23 AM");
INSERT INTO crm_audit_log VALUES("5566","3","15","2019-04-20 10:29:14","Exit Invoice [Invoice No: 119729] updated by Abdul Rasheed on 20/04/2019 at 10:29 AM");
INSERT INTO crm_audit_log VALUES("5567","2","7","2019-04-20 11:40:51","Entry Invoice [Invoice No: 21243] updated by ALSED ABU SHAMA on 20/04/2019 at 11:40 AM");
INSERT INTO crm_audit_log VALUES("5568","2","7","2019-04-20 11:41:32","Entry Invoice [Invoice No: 21244] updated by ALSED ABU SHAMA on 20/04/2019 at 11:41 AM");
INSERT INTO crm_audit_log VALUES("5569","2","7","2019-04-20 11:48:27","Entry Invoice [Invoice No: 21245] updated by ALSED ABU SHAMA on 20/04/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("5570","3","15","2019-04-20 13:25:39","Exit Invoice [Invoice No: 119730] updated by Abdul Rasheed on 20/04/2019 at 01:25 PM");
INSERT INTO crm_audit_log VALUES("5571","2","7","2019-04-20 13:30:00","Entry Invoice [Invoice No: 21246] updated by ALSED ABU SHAMA on 20/04/2019 at 01:30 PM");
INSERT INTO crm_audit_log VALUES("5572","2","7","2019-04-20 15:20:37","Entry Invoice [Invoice No: 21247] updated by ALSED ABU SHAMA on 20/04/2019 at 03:20 PM");
INSERT INTO crm_audit_log VALUES("5573","2","7","2019-04-20 15:21:27","Entry Invoice [Invoice No: 21248] updated by ALSED ABU SHAMA on 20/04/2019 at 03:21 PM");
INSERT INTO crm_audit_log VALUES("5574","2","7","2019-04-20 15:24:23","Entry Invoice [Invoice No: 21249] updated by ALSED ABU SHAMA on 20/04/2019 at 03:24 PM");
INSERT INTO crm_audit_log VALUES("5575","2","7","2019-04-20 15:25:10","Entry Invoice [Invoice No: 21250] updated by ALSED ABU SHAMA on 20/04/2019 at 03:25 PM");
INSERT INTO crm_audit_log VALUES("5576","2","7","2019-04-20 15:30:13","Entry Invoice [Invoice No: 21251] updated by ALSED ABU SHAMA on 20/04/2019 at 03:30 PM");
INSERT INTO crm_audit_log VALUES("5577","3","4","2019-04-20 18:20:34","Exit Invoice [Invoice No: 119731] updated by Yasir  Rahman on 20/04/2019 at 06:20 PM");
INSERT INTO crm_audit_log VALUES("5578","3","4","2019-04-20 18:21:56","Exit Invoice [Invoice No: 119732] updated by Yasir  Rahman on 20/04/2019 at 06:21 PM");
INSERT INTO crm_audit_log VALUES("5579","2","7","2019-04-20 19:00:41","Entry Invoice [Invoice No: 21252] updated by ALSED ABU SHAMA on 20/04/2019 at 07:00 PM");
INSERT INTO crm_audit_log VALUES("5580","2","4","2019-04-20 21:48:34","Entry Invoice [Invoice No: 21253] updated by Yasir  Rahman on 20/04/2019 at 09:48 PM");
INSERT INTO crm_audit_log VALUES("5581","2","4","2019-04-20 21:50:10","Entry Invoice [Invoice No: 21254] updated by Yasir  Rahman on 20/04/2019 at 09:50 PM");
INSERT INTO crm_audit_log VALUES("5582","2","4","2019-04-20 21:54:32","Entry Invoice [Invoice No: 21255] updated by Yasir  Rahman on 20/04/2019 at 09:54 PM");
INSERT INTO crm_audit_log VALUES("5583","2","4","2019-04-20 22:41:28","Entry Invoice [Invoice No: 21256] updated by Yasir  Rahman on 20/04/2019 at 10:41 PM");
INSERT INTO crm_audit_log VALUES("5584","2","4","2019-04-20 22:42:47","Entry Invoice [Invoice No: 21257] updated by Yasir  Rahman on 20/04/2019 at 10:42 PM");
INSERT INTO crm_audit_log VALUES("5585","3","5","2019-04-20 23:31:42","Exit Invoice [Invoice No: 119733] updated by Imran  Khan on 20/04/2019 at 11:31 PM");
INSERT INTO crm_audit_log VALUES("5586","3","5","2019-04-21 03:16:12","Exit Invoice [Invoice No: 119734] updated by Imran  Khan on 21/04/2019 at 03:16 AM");
INSERT INTO crm_audit_log VALUES("5587","2","4","2019-04-21 06:55:12","Entry Invoice [Invoice No: 21258] updated by Yasir  Rahman on 21/04/2019 at 06:55 AM");
INSERT INTO crm_audit_log VALUES("5588","2","4","2019-04-21 07:01:41","Entry Invoice [Invoice No: 21259] updated by Yasir  Rahman on 21/04/2019 at 07:01 AM");
INSERT INTO crm_audit_log VALUES("5589","2","4","2019-04-21 07:02:31","Entry Invoice [Invoice No: 21260] updated by Yasir  Rahman on 21/04/2019 at 07:02 AM");
INSERT INTO crm_audit_log VALUES("5590","2","4","2019-04-21 07:03:42","Entry Invoice [Invoice No: 21261] updated by Yasir  Rahman on 21/04/2019 at 07:03 AM");
INSERT INTO crm_audit_log VALUES("5591","3","5","2019-04-21 07:28:17","Exit Invoice [Invoice No: 119735] updated by Imran  Khan on 21/04/2019 at 07:28 AM");
INSERT INTO crm_audit_log VALUES("5592","2","6","2019-04-21 09:04:44","Entry Invoice [Invoice No: 21262] updated by ASHRAF  M K on 21/04/2019 at 09:04 AM");
INSERT INTO crm_audit_log VALUES("5593","2","6","2019-04-21 09:08:05","Entry Invoice [Invoice No: 21263] updated by ASHRAF  M K on 21/04/2019 at 09:08 AM");
INSERT INTO crm_audit_log VALUES("5594","2","6","2019-04-21 09:09:16","Entry Invoice [Invoice No: 21264] updated by ASHRAF  M K on 21/04/2019 at 09:09 AM");
INSERT INTO crm_audit_log VALUES("5595","2","6","2019-04-21 09:10:33","Entry Invoice [Invoice No: 21265] updated by ASHRAF  M K on 21/04/2019 at 09:10 AM");
INSERT INTO crm_audit_log VALUES("5596","2","6","2019-04-21 10:15:53","Entry Invoice [Invoice No: 21266] updated by ASHRAF  M K on 21/04/2019 at 10:15 AM");
INSERT INTO crm_audit_log VALUES("5597","3","15","2019-04-21 10:50:40","Exit Invoice [Invoice No: 119736] updated by Abdul Rasheed on 21/04/2019 at 10:50 AM");
INSERT INTO crm_audit_log VALUES("5598","3","15","2019-04-21 11:01:48","Exit Invoice [Invoice No: 119737] updated by Abdul Rasheed on 21/04/2019 at 11:01 AM");
INSERT INTO crm_audit_log VALUES("5599","3","15","2019-04-21 12:20:35","Exit Invoice [Invoice No: 119738] updated by Abdul Rasheed on 21/04/2019 at 12:20 PM");
INSERT INTO crm_audit_log VALUES("5600","3","15","2019-04-21 13:31:03","Exit Invoice [Invoice No: 119739] updated by Abdul Rasheed on 21/04/2019 at 01:31 PM");
INSERT INTO crm_audit_log VALUES("5601","3","15","2019-04-21 13:32:24","Exit Invoice [Invoice No: 119740] updated by Abdul Rasheed on 21/04/2019 at 01:32 PM");
INSERT INTO crm_audit_log VALUES("5602","3","15","2019-04-21 13:39:26","Exit Invoice [Invoice No: 119741] updated by Abdul Rasheed on 21/04/2019 at 01:39 PM");
INSERT INTO crm_audit_log VALUES("5603","3","15","2019-04-21 13:40:33","Exit Invoice [Invoice No: 119742] updated by Abdul Rasheed on 21/04/2019 at 01:40 PM");
INSERT INTO crm_audit_log VALUES("5604","2","7","2019-04-21 14:24:42","Entry Invoice [Invoice No: 21267] updated by ALSED ABU SHAMA on 21/04/2019 at 02:24 PM");
INSERT INTO crm_audit_log VALUES("5605","2","7","2019-04-21 14:28:34","Entry Invoice [Invoice No: 21268] updated by ALSED ABU SHAMA on 21/04/2019 at 02:28 PM");
INSERT INTO crm_audit_log VALUES("5606","2","7","2019-04-21 14:32:16","Entry Invoice [Invoice No: 21269] updated by ALSED ABU SHAMA on 21/04/2019 at 02:32 PM");
INSERT INTO crm_audit_log VALUES("5607","3","15","2019-04-21 14:36:34","Exit Invoice [Invoice No: 119743] updated by Abdul Rasheed on 21/04/2019 at 02:36 PM");
INSERT INTO crm_audit_log VALUES("5608","2","7","2019-04-21 14:38:52","Entry Invoice [Invoice No: 21270] updated by ALSED ABU SHAMA on 21/04/2019 at 02:38 PM");
INSERT INTO crm_audit_log VALUES("5609","3","4","2019-04-21 16:45:11","Exit Invoice [Invoice No: 119744] updated by Yasir  Rahman on 21/04/2019 at 04:45 PM");
INSERT INTO crm_audit_log VALUES("5610","3","4","2019-04-21 18:17:14","Exit Invoice [Invoice No: 119745] updated by Yasir  Rahman on 21/04/2019 at 06:17 PM");
INSERT INTO crm_audit_log VALUES("5611","2","7","2019-04-21 18:33:52","Entry Invoice [Invoice No: 21271] updated by ALSED ABU SHAMA on 21/04/2019 at 06:33 PM");
INSERT INTO crm_audit_log VALUES("5612","2","7","2019-04-21 18:40:55","Entry Invoice [Invoice No: 21272] updated by ALSED ABU SHAMA on 21/04/2019 at 06:40 PM");
INSERT INTO crm_audit_log VALUES("5613","2","4","2019-04-21 21:40:43","Entry Invoice [Invoice No: 21273] updated by Yasir  Rahman on 21/04/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("5614","2","4","2019-04-21 21:42:52","Entry Invoice [Invoice No: 21274] updated by Yasir  Rahman on 21/04/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("5615","2","4","2019-04-21 21:48:58","Entry Invoice [Invoice No: 21275] updated by Yasir  Rahman on 21/04/2019 at 09:48 PM");
INSERT INTO crm_audit_log VALUES("5616","2","6","2019-04-21 21:50:43","Entry Invoice [Invoice No: 21273] updated by ASHRAF  M K on 21/04/2019 at 09:50 PM");
INSERT INTO crm_audit_log VALUES("5617","2","6","2019-04-21 21:52:48","Entry Invoice [Invoice No: 21273] updated by ASHRAF  M K on 21/04/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("5618","2","4","2019-04-21 22:00:59","Entry Invoice [Invoice No: 21276] updated by Yasir  Rahman on 21/04/2019 at 10:00 PM");
INSERT INTO crm_audit_log VALUES("5619","3","5","2019-04-22 00:55:03","Exit Invoice [Invoice No: 119746] updated by Imran  Khan on 22/04/2019 at 12:55 AM");
INSERT INTO crm_audit_log VALUES("5620","3","5","2019-04-22 02:01:47","Exit Invoice [Invoice No: 119747] updated by Imran  Khan on 22/04/2019 at 02:01 AM");
INSERT INTO crm_audit_log VALUES("5621","3","5","2019-04-22 02:04:16","Exit Invoice [Invoice No: 119748] updated by Imran  Khan on 22/04/2019 at 02:04 AM");
INSERT INTO crm_audit_log VALUES("5622","3","5","2019-04-22 02:05:02","Exit Invoice [Invoice No: 119749] updated by Imran  Khan on 22/04/2019 at 02:05 AM");
INSERT INTO crm_audit_log VALUES("5623","3","5","2019-04-22 02:05:41","Exit Invoice [Invoice No: 119750] updated by Imran  Khan on 22/04/2019 at 02:05 AM");
INSERT INTO crm_audit_log VALUES("5624","3","5","2019-04-22 03:20:52","Exit Invoice [Invoice No: 119751] updated by Imran  Khan on 22/04/2019 at 03:20 AM");
INSERT INTO crm_audit_log VALUES("5625","3","5","2019-04-22 03:21:37","Exit Invoice [Invoice No: 119752] updated by Imran  Khan on 22/04/2019 at 03:21 AM");
INSERT INTO crm_audit_log VALUES("5626","3","5","2019-04-22 04:36:33","Exit Invoice [Invoice No: 119753] updated by Imran  Khan on 22/04/2019 at 04:36 AM");
INSERT INTO crm_audit_log VALUES("5627","3","5","2019-04-22 07:45:28","Exit Invoice [Invoice No: 119754] updated by Imran  Khan on 22/04/2019 at 07:45 AM");
INSERT INTO crm_audit_log VALUES("5628","3","15","2019-04-22 11:47:49","Exit Invoice [Invoice No: 119755] updated by Abdul Rasheed on 22/04/2019 at 11:47 AM");
INSERT INTO crm_audit_log VALUES("5629","3","15","2019-04-22 11:49:24","Exit Invoice [Invoice No: 119756] updated by Abdul Rasheed on 22/04/2019 at 11:49 AM");
INSERT INTO crm_audit_log VALUES("5630","3","15","2019-04-22 12:45:02","Exit Invoice [Invoice No: 119757] updated by Abdul Rasheed on 22/04/2019 at 12:45 PM");
INSERT INTO crm_audit_log VALUES("5631","3","15","2019-04-22 12:46:04","Exit Invoice [Invoice No: 119758] updated by Abdul Rasheed on 22/04/2019 at 12:46 PM");
INSERT INTO crm_audit_log VALUES("5632","3","15","2019-04-22 12:47:20","Exit Invoice [Invoice No: 119759] updated by Abdul Rasheed on 22/04/2019 at 12:47 PM");
INSERT INTO crm_audit_log VALUES("5633","2","7","2019-04-22 12:49:45","Entry Invoice [Invoice No: 21277] updated by ALSED ABU SHAMA on 22/04/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("5634","2","7","2019-04-22 12:58:45","Entry Invoice [Invoice No: 21278] updated by ALSED ABU SHAMA on 22/04/2019 at 12:58 PM");
INSERT INTO crm_audit_log VALUES("5635","2","7","2019-04-22 13:00:05","Entry Invoice [Invoice No: 21279] updated by ALSED ABU SHAMA on 22/04/2019 at 01:00 PM");
INSERT INTO crm_audit_log VALUES("5636","2","7","2019-04-22 13:06:14","Entry Invoice [Invoice No: 21280] updated by ALSED ABU SHAMA on 22/04/2019 at 01:06 PM");
INSERT INTO crm_audit_log VALUES("5637","2","6","2019-04-22 13:25:31","Entry Invoice [Invoice No: 21281] updated by ASHRAF  M K on 22/04/2019 at 01:25 PM");
INSERT INTO crm_audit_log VALUES("5638","2","7","2019-04-22 13:36:32","Entry Invoice [Invoice No: 21282] updated by ALSED ABU SHAMA on 22/04/2019 at 01:36 PM");
INSERT INTO crm_audit_log VALUES("5639","2","7","2019-04-22 13:37:21","Entry Invoice [Invoice No: 21283] updated by ALSED ABU SHAMA on 22/04/2019 at 01:37 PM");
INSERT INTO crm_audit_log VALUES("5640","3","15","2019-04-22 14:55:16","Exit Invoice [Invoice No: 119760] updated by Abdul Rasheed on 22/04/2019 at 02:55 PM");
INSERT INTO crm_audit_log VALUES("5641","2","7","2019-04-22 15:01:58","Entry Invoice [Invoice No: 21284] updated by ALSED ABU SHAMA on 22/04/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("5642","2","7","2019-04-22 18:07:54","Entry Invoice [Invoice No: 21285] updated by ALSED ABU SHAMA on 22/04/2019 at 06:07 PM");
INSERT INTO crm_audit_log VALUES("5643","2","4","2019-04-22 20:27:48","Entry Invoice [Invoice No: 21286] updated by Yasir  Rahman on 22/04/2019 at 08:27 PM");
INSERT INTO crm_audit_log VALUES("5644","2","4","2019-04-22 20:33:27","Entry Invoice [Invoice No: 21287] updated by Yasir  Rahman on 22/04/2019 at 08:33 PM");
INSERT INTO crm_audit_log VALUES("5645","2","4","2019-04-22 20:35:15","Entry Invoice [Invoice No: 21288] updated by Yasir  Rahman on 22/04/2019 at 08:35 PM");
INSERT INTO crm_audit_log VALUES("5646","2","4","2019-04-22 20:50:40","Entry Invoice [Invoice No: 21289] updated by Yasir  Rahman on 22/04/2019 at 08:50 PM");
INSERT INTO crm_audit_log VALUES("5647","2","4","2019-04-22 20:52:15","Entry Invoice [Invoice No: 21290] updated by Yasir  Rahman on 22/04/2019 at 08:52 PM");
INSERT INTO crm_audit_log VALUES("5648","3","4","2019-04-22 20:54:51","Exit Invoice [Invoice No: 119761] updated by Yasir  Rahman on 22/04/2019 at 08:54 PM");
INSERT INTO crm_audit_log VALUES("5649","3","4","2019-04-22 21:14:29","Exit Invoice [Invoice No: 119762] updated by Yasir  Rahman on 22/04/2019 at 09:14 PM");
INSERT INTO crm_audit_log VALUES("5650","3","4","2019-04-22 21:55:29","Exit Invoice [Invoice No: 119763] updated by Yasir  Rahman on 22/04/2019 at 09:55 PM");
INSERT INTO crm_audit_log VALUES("5651","3","4","2019-04-22 21:57:03","Exit Invoice [Invoice No: 119764] updated by Yasir  Rahman on 22/04/2019 at 09:57 PM");
INSERT INTO crm_audit_log VALUES("5652","3","4","2019-04-22 21:58:13","Exit Invoice [Invoice No: 119765] updated by Yasir  Rahman on 22/04/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("5653","2","4","2019-04-22 22:20:51","Entry Invoice [Invoice No: 21291] updated by Yasir  Rahman on 22/04/2019 at 10:20 PM");
INSERT INTO crm_audit_log VALUES("5654","2","4","2019-04-22 22:27:16","Entry Invoice [Invoice No: 21292] updated by Yasir  Rahman on 22/04/2019 at 10:27 PM");
INSERT INTO crm_audit_log VALUES("5655","3","4","2019-04-22 23:10:45","Exit Invoice [Invoice No: 119766] updated by Yasir  Rahman on 22/04/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("5656","3","4","2019-04-22 23:43:16","Exit Invoice [Invoice No: 119767] updated by Yasir  Rahman on 22/04/2019 at 11:43 PM");
INSERT INTO crm_audit_log VALUES("5657","2","4","2019-04-23 00:18:24","Entry Invoice [Invoice No: 21293] updated by Yasir  Rahman on 23/04/2019 at 12:18 AM");
INSERT INTO crm_audit_log VALUES("5658","3","4","2019-04-23 00:29:02","Exit Invoice [Invoice No: 119768] updated by Yasir  Rahman on 23/04/2019 at 12:29 AM");
INSERT INTO crm_audit_log VALUES("5659","2","4","2019-04-23 00:50:39","Entry Invoice [Invoice No: 21294] updated by Yasir  Rahman on 23/04/2019 at 12:50 AM");
INSERT INTO crm_audit_log VALUES("5660","3","4","2019-04-23 01:20:44","Exit Invoice [Invoice No: 119769] updated by Yasir  Rahman on 23/04/2019 at 01:20 AM");
INSERT INTO crm_audit_log VALUES("5661","3","4","2019-04-23 01:52:22","Exit Invoice [Invoice No: 119770] updated by Yasir  Rahman on 23/04/2019 at 01:52 AM");
INSERT INTO crm_audit_log VALUES("5662","3","4","2019-04-23 02:48:02","Exit Invoice [Invoice No: 119771] updated by Yasir  Rahman on 23/04/2019 at 02:48 AM");
INSERT INTO crm_audit_log VALUES("5663","2","4","2019-04-23 03:01:22","Entry Invoice [Invoice No: 21295] updated by Yasir  Rahman on 23/04/2019 at 03:01 AM");
INSERT INTO crm_audit_log VALUES("5664","2","4","2019-04-23 03:04:45","Entry Invoice [Invoice No: 21296] updated by Yasir  Rahman on 23/04/2019 at 03:04 AM");
INSERT INTO crm_audit_log VALUES("5665","3","4","2019-04-23 04:04:31","Exit Invoice [Invoice No: 119772] updated by Yasir  Rahman on 23/04/2019 at 04:04 AM");
INSERT INTO crm_audit_log VALUES("5666","3","4","2019-04-23 04:05:43","Exit Invoice [Invoice No: 119773] updated by Yasir  Rahman on 23/04/2019 at 04:05 AM");
INSERT INTO crm_audit_log VALUES("5667","3","4","2019-04-23 04:45:55","Exit Invoice [Invoice No: 119774] updated by Yasir  Rahman on 23/04/2019 at 04:45 AM");
INSERT INTO crm_audit_log VALUES("5668","3","15","2019-04-23 08:02:24","Exit Invoice [Invoice No: 119775] updated by Abdul Rasheed on 23/04/2019 at 08:02 AM");
INSERT INTO crm_audit_log VALUES("5669","3","15","2019-04-23 08:33:49","Exit Invoice [Invoice No: 119776] updated by Abdul Rasheed on 23/04/2019 at 08:33 AM");
INSERT INTO crm_audit_log VALUES("5670","2","6","2019-04-23 10:03:52","Entry Invoice [Invoice No: 21297] updated by ASHRAF  M K on 23/04/2019 at 10:03 AM");
INSERT INTO crm_audit_log VALUES("5671","2","6","2019-04-23 10:05:16","Entry Invoice [Invoice No: 21298] updated by ASHRAF  M K on 23/04/2019 at 10:05 AM");
INSERT INTO crm_audit_log VALUES("5672","3","15","2019-04-23 10:44:43","Exit Invoice [Invoice No: 119777] updated by Abdul Rasheed on 23/04/2019 at 10:44 AM");
INSERT INTO crm_audit_log VALUES("5673","3","15","2019-04-23 10:48:26","Exit Invoice [Invoice No: 119778] updated by Abdul Rasheed on 23/04/2019 at 10:48 AM");
INSERT INTO crm_audit_log VALUES("5674","2","6","2019-04-23 11:36:20","Entry Invoice [Invoice No: 21299] updated by ASHRAF  M K on 23/04/2019 at 11:36 AM");
INSERT INTO crm_audit_log VALUES("5675","2","6","2019-04-23 11:38:12","Entry Invoice [Invoice No: 21300] updated by ASHRAF  M K on 23/04/2019 at 11:38 AM");
INSERT INTO crm_audit_log VALUES("5676","3","6","2019-04-23 12:03:44","Exit Invoice [Invoice No: 119769] updated by ASHRAF  M K on 23/04/2019 at 12:03 PM");
INSERT INTO crm_audit_log VALUES("5677","2","6","2019-04-23 12:57:49","Entry Invoice [Invoice No: 21301] updated by ASHRAF  M K on 23/04/2019 at 12:57 PM");
INSERT INTO crm_audit_log VALUES("5678","2","6","2019-04-23 12:59:01","Entry Invoice [Invoice No: 21302] updated by ASHRAF  M K on 23/04/2019 at 12:59 PM");
INSERT INTO crm_audit_log VALUES("5679","2","6","2019-04-23 13:00:15","Entry Invoice [Invoice No: 21303] updated by ASHRAF  M K on 23/04/2019 at 01:00 PM");
INSERT INTO crm_audit_log VALUES("5680","2","6","2019-04-23 13:06:25","Entry Invoice [Invoice No: 21304] updated by ASHRAF  M K on 23/04/2019 at 01:06 PM");
INSERT INTO crm_audit_log VALUES("5681","2","6","2019-04-23 13:07:25","Entry Invoice [Invoice No: 21305] updated by ASHRAF  M K on 23/04/2019 at 01:07 PM");
INSERT INTO crm_audit_log VALUES("5682","2","6","2019-04-23 13:55:27","Entry Invoice [Invoice No: 21306] updated by ASHRAF  M K on 23/04/2019 at 01:55 PM");
INSERT INTO crm_audit_log VALUES("5683","3","6","2019-04-23 14:12:21","Exit Invoice [Invoice No: 119769] updated by ASHRAF  M K on 23/04/2019 at 02:12 PM");
INSERT INTO crm_audit_log VALUES("5684","3","15","2019-04-23 14:59:04","Exit Invoice [Invoice No: 119779] updated by Abdul Rasheed on 23/04/2019 at 02:59 PM");
INSERT INTO crm_audit_log VALUES("5685","3","15","2019-04-23 15:23:36","Exit Invoice [Invoice No: 119780] updated by Abdul Rasheed on 23/04/2019 at 03:23 PM");
INSERT INTO crm_audit_log VALUES("5686","3","15","2019-04-23 15:25:23","Exit Invoice [Invoice No: 119781] updated by Abdul Rasheed on 23/04/2019 at 03:25 PM");
INSERT INTO crm_audit_log VALUES("5687","3","15","2019-04-23 16:25:02","Exit Invoice [Invoice No: 119782] updated by Abdul Rasheed on 23/04/2019 at 04:25 PM");
INSERT INTO crm_audit_log VALUES("5688","3","15","2019-04-23 16:27:08","Exit Invoice [Invoice No: 119783] updated by Abdul Rasheed on 23/04/2019 at 04:27 PM");
INSERT INTO crm_audit_log VALUES("5689","2","4","2019-04-23 16:42:27","Entry Invoice [Invoice No: 21307] updated by Yasir  Rahman on 23/04/2019 at 04:42 PM");
INSERT INTO crm_audit_log VALUES("5690","3","4","2019-04-23 17:43:15","Exit Invoice [Invoice No: 119784] updated by Yasir  Rahman on 23/04/2019 at 05:43 PM");
INSERT INTO crm_audit_log VALUES("5691","3","4","2019-04-23 17:46:33","Exit Invoice [Invoice No: 119785] updated by Yasir  Rahman on 23/04/2019 at 05:46 PM");
INSERT INTO crm_audit_log VALUES("5692","3","6","2019-04-23 18:39:53","Exit Invoice [Invoice No: 119782] updated by ASHRAF  M K on 23/04/2019 at 06:39 PM");
INSERT INTO crm_audit_log VALUES("5693","2","4","2019-04-23 19:02:24","Entry Invoice [Invoice No: 21308] updated by Yasir  Rahman on 23/04/2019 at 07:02 PM");
INSERT INTO crm_audit_log VALUES("5694","2","4","2019-04-23 19:04:16","Entry Invoice [Invoice No: 21309] updated by Yasir  Rahman on 23/04/2019 at 07:04 PM");
INSERT INTO crm_audit_log VALUES("5695","2","4","2019-04-23 19:06:40","Entry Invoice [Invoice No: 21310] updated by Yasir  Rahman on 23/04/2019 at 07:06 PM");
INSERT INTO crm_audit_log VALUES("5696","2","4","2019-04-23 19:09:33","Entry Invoice [Invoice No: 21311] updated by Yasir  Rahman on 23/04/2019 at 07:09 PM");
INSERT INTO crm_audit_log VALUES("5697","3","4","2019-04-23 20:51:29","Exit Invoice [Invoice No: 119786] updated by Yasir  Rahman on 23/04/2019 at 08:51 PM");
INSERT INTO crm_audit_log VALUES("5698","2","4","2019-04-23 21:10:16","Entry Invoice [Invoice No: 21312] updated by Yasir  Rahman on 23/04/2019 at 09:10 PM");
INSERT INTO crm_audit_log VALUES("5699","3","4","2019-04-23 21:38:17","Exit Invoice [Invoice No: 119787] updated by Yasir  Rahman on 23/04/2019 at 09:38 PM");
INSERT INTO crm_audit_log VALUES("5700","3","4","2019-04-23 22:55:23","Exit Invoice [Invoice No: 119788] updated by Yasir  Rahman on 23/04/2019 at 10:55 PM");
INSERT INTO crm_audit_log VALUES("5701","3","4","2019-04-23 22:56:32","Exit Invoice [Invoice No: 119789] updated by Yasir  Rahman on 23/04/2019 at 10:56 PM");
INSERT INTO crm_audit_log VALUES("5702","3","4","2019-04-23 22:57:45","Exit Invoice [Invoice No: 119790] updated by Yasir  Rahman on 23/04/2019 at 10:57 PM");
INSERT INTO crm_audit_log VALUES("5703","3","4","2019-04-23 23:22:08","Exit Invoice [Invoice No: 119791] updated by Yasir  Rahman on 23/04/2019 at 11:22 PM");
INSERT INTO crm_audit_log VALUES("5704","3","4","2019-04-23 23:23:29","Exit Invoice [Invoice No: 119792] updated by Yasir  Rahman on 23/04/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("5705","2","4","2019-04-23 23:50:57","Entry Invoice [Invoice No: 21313] updated by Yasir  Rahman on 23/04/2019 at 11:50 PM");
INSERT INTO crm_audit_log VALUES("5706","2","4","2019-04-24 01:15:17","Entry Invoice [Invoice No: 21314] updated by Yasir  Rahman on 24/04/2019 at 01:15 AM");
INSERT INTO crm_audit_log VALUES("5707","2","4","2019-04-24 01:16:31","Entry Invoice [Invoice No: 21315] updated by Yasir  Rahman on 24/04/2019 at 01:16 AM");
INSERT INTO crm_audit_log VALUES("5708","3","4","2019-04-24 02:54:49","Exit Invoice [Invoice No: 119793] updated by Yasir  Rahman on 24/04/2019 at 02:54 AM");
INSERT INTO crm_audit_log VALUES("5709","1","4","2019-04-24 03:41:41","Customer [Customer No: 438] updated by Yasir  Rahman on 24/04/2019 at 03:41 AM");
INSERT INTO crm_audit_log VALUES("5710","3","4","2019-04-24 03:43:09","Exit Invoice [Invoice No: 119794] updated by Yasir  Rahman on 24/04/2019 at 03:43 AM");
INSERT INTO crm_audit_log VALUES("5711","3","4","2019-04-24 04:51:38","Exit Invoice [Invoice No: 119795] updated by Yasir  Rahman on 24/04/2019 at 04:51 AM");
INSERT INTO crm_audit_log VALUES("5712","3","4","2019-04-24 05:37:52","Exit Invoice [Invoice No: 119796] updated by Yasir  Rahman on 24/04/2019 at 05:37 AM");
INSERT INTO crm_audit_log VALUES("5713","2","6","2019-04-24 08:22:36","Entry Invoice [Invoice No: 21310] updated by ASHRAF  M K on 24/04/2019 at 08:22 AM");
INSERT INTO crm_audit_log VALUES("5714","3","15","2019-04-24 09:26:41","Exit Invoice [Invoice No: 119797] updated by Abdul Rasheed on 24/04/2019 at 09:26 AM");
INSERT INTO crm_audit_log VALUES("5715","3","15","2019-04-24 09:29:29","Exit Invoice [Invoice No: 119798] updated by Abdul Rasheed on 24/04/2019 at 09:29 AM");
INSERT INTO crm_audit_log VALUES("5716","2","7","2019-04-24 09:32:19","Entry Invoice [Invoice No: 21316] updated by ALSED ABU SHAMA on 24/04/2019 at 09:32 AM");
INSERT INTO crm_audit_log VALUES("5717","2","7","2019-04-24 09:33:32","Entry Invoice [Invoice No: 21317] updated by ALSED ABU SHAMA on 24/04/2019 at 09:33 AM");
INSERT INTO crm_audit_log VALUES("5718","2","7","2019-04-24 09:34:23","Entry Invoice [Invoice No: 21318] updated by ALSED ABU SHAMA on 24/04/2019 at 09:34 AM");
INSERT INTO crm_audit_log VALUES("5719","3","15","2019-04-24 09:53:26","Exit Invoice [Invoice No: 119799] updated by Abdul Rasheed on 24/04/2019 at 09:53 AM");
INSERT INTO crm_audit_log VALUES("5720","3","15","2019-04-24 10:01:44","Exit Invoice [Invoice No: 119800] updated by Abdul Rasheed on 24/04/2019 at 10:01 AM");
INSERT INTO crm_audit_log VALUES("5721","3","15","2019-04-24 10:04:13","Exit Invoice [Invoice No: 119801] updated by Abdul Rasheed on 24/04/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("5722","3","15","2019-04-24 10:50:46","Exit Invoice [Invoice No: 119802] updated by Abdul Rasheed on 24/04/2019 at 10:50 AM");
INSERT INTO crm_audit_log VALUES("5723","3","15","2019-04-24 11:40:33","Exit Invoice [Invoice No: 119803] updated by Abdul Rasheed on 24/04/2019 at 11:40 AM");
INSERT INTO crm_audit_log VALUES("5724","3","15","2019-04-24 13:10:03","Exit Invoice [Invoice No: 119804] updated by Abdul Rasheed on 24/04/2019 at 01:10 PM");
INSERT INTO crm_audit_log VALUES("5725","3","15","2019-04-24 14:20:36","Exit Invoice [Invoice No: 119805] updated by Abdul Rasheed on 24/04/2019 at 02:20 PM");
INSERT INTO crm_audit_log VALUES("5726","3","15","2019-04-24 14:33:57","Exit Invoice [Invoice No: 119806] updated by Abdul Rasheed on 24/04/2019 at 02:33 PM");
INSERT INTO crm_audit_log VALUES("5727","3","15","2019-04-24 14:34:59","Exit Invoice [Invoice No: 119807] updated by Abdul Rasheed on 24/04/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("5728","2","7","2019-04-24 15:42:20","Entry Invoice [Invoice No: 21319] updated by ALSED ABU SHAMA on 24/04/2019 at 03:42 PM");
INSERT INTO crm_audit_log VALUES("5729","3","4","2019-04-24 17:56:43","Exit Invoice [Invoice No: 119808] updated by Yasir  Rahman on 24/04/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("5730","3","4","2019-04-24 17:58:04","Exit Invoice [Invoice No: 119809] updated by Yasir  Rahman on 24/04/2019 at 05:58 PM");
INSERT INTO crm_audit_log VALUES("5731","3","4","2019-04-24 18:38:22","Exit Invoice [Invoice No: 119810] updated by Yasir  Rahman on 24/04/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("5732","3","4","2019-04-24 19:23:53","Exit Invoice [Invoice No: 119811] updated by Yasir  Rahman on 24/04/2019 at 07:23 PM");
INSERT INTO crm_audit_log VALUES("5733","3","4","2019-04-24 19:50:02","Exit Invoice [Invoice No: 119812] updated by Yasir  Rahman on 24/04/2019 at 07:50 PM");
INSERT INTO crm_audit_log VALUES("5734","2","4","2019-04-24 21:14:24","Entry Invoice [Invoice No: 21320] updated by Yasir  Rahman on 24/04/2019 at 09:14 PM");
INSERT INTO crm_audit_log VALUES("5735","2","4","2019-04-24 21:17:48","Entry Invoice [Invoice No: 21321] updated by Yasir  Rahman on 24/04/2019 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("5736","2","4","2019-04-24 21:19:07","Entry Invoice [Invoice No: 21322] updated by Yasir  Rahman on 24/04/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("5737","2","4","2019-04-24 21:21:15","Entry Invoice [Invoice No: 21323] updated by Yasir  Rahman on 24/04/2019 at 09:21 PM");
INSERT INTO crm_audit_log VALUES("5738","3","4","2019-04-24 23:25:44","Exit Invoice [Invoice No: 119813] updated by Yasir  Rahman on 24/04/2019 at 11:25 PM");
INSERT INTO crm_audit_log VALUES("5739","3","4","2019-04-24 23:26:50","Exit Invoice [Invoice No: 119814] updated by Yasir  Rahman on 24/04/2019 at 11:26 PM");
INSERT INTO crm_audit_log VALUES("5740","2","4","2019-04-24 23:35:31","Entry Invoice [Invoice No: 21324] updated by Yasir  Rahman on 24/04/2019 at 11:35 PM");
INSERT INTO crm_audit_log VALUES("5741","3","4","2019-04-24 23:47:58","Exit Invoice [Invoice No: 119815] updated by Yasir  Rahman on 24/04/2019 at 11:47 PM");
INSERT INTO crm_audit_log VALUES("5742","3","4","2019-04-25 00:39:47","Exit Invoice [Invoice No: 119816] updated by Yasir  Rahman on 25/04/2019 at 12:39 AM");
INSERT INTO crm_audit_log VALUES("5743","3","4","2019-04-25 01:42:47","Exit Invoice [Invoice No: 119817] updated by Yasir  Rahman on 25/04/2019 at 01:42 AM");
INSERT INTO crm_audit_log VALUES("5744","3","4","2019-04-25 01:43:47","Exit Invoice [Invoice No: 119818] updated by Yasir  Rahman on 25/04/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("5745","2","4","2019-04-25 02:55:59","Entry Invoice [Invoice No: 21325] updated by Yasir  Rahman on 25/04/2019 at 02:55 AM");
INSERT INTO crm_audit_log VALUES("5746","3","4","2019-04-25 03:42:26","Exit Invoice [Invoice No: 119819] updated by Yasir  Rahman on 25/04/2019 at 03:42 AM");
INSERT INTO crm_audit_log VALUES("5747","3","4","2019-04-25 06:10:39","Exit Invoice [Invoice No: 119820] updated by Yasir  Rahman on 25/04/2019 at 06:10 AM");
INSERT INTO crm_audit_log VALUES("5748","3","4","2019-04-25 07:24:36","Exit Invoice [Invoice No: 119821] updated by Yasir  Rahman on 25/04/2019 at 07:24 AM");
INSERT INTO crm_audit_log VALUES("5749","2","4","2019-04-25 07:43:53","Entry Invoice [Invoice No: 21326] updated by Yasir  Rahman on 25/04/2019 at 07:43 AM");
INSERT INTO crm_audit_log VALUES("5750","2","4","2019-04-25 07:44:46","Entry Invoice [Invoice No: 21327] updated by Yasir  Rahman on 25/04/2019 at 07:44 AM");
INSERT INTO crm_audit_log VALUES("5751","2","4","2019-04-25 07:46:04","Entry Invoice [Invoice No: 21328] updated by Yasir  Rahman on 25/04/2019 at 07:46 AM");
INSERT INTO crm_audit_log VALUES("5752","3","15","2019-04-25 08:53:22","Exit Invoice [Invoice No: 119822] updated by Abdul Rasheed on 25/04/2019 at 08:53 AM");
INSERT INTO crm_audit_log VALUES("5753","2","6","2019-04-25 09:37:50","Entry Invoice [Invoice No: 21329] updated by ASHRAF  M K on 25/04/2019 at 09:37 AM");
INSERT INTO crm_audit_log VALUES("5754","2","7","2019-04-25 09:57:46","Entry Invoice [Invoice No: 21330] updated by ALSED ABU SHAMA on 25/04/2019 at 09:57 AM");
INSERT INTO crm_audit_log VALUES("5755","2","7","2019-04-25 09:58:35","Entry Invoice [Invoice No: 21331] updated by ALSED ABU SHAMA on 25/04/2019 at 09:58 AM");
INSERT INTO crm_audit_log VALUES("5756","2","7","2019-04-25 10:06:48","Entry Invoice [Invoice No: 21332] updated by ALSED ABU SHAMA on 25/04/2019 at 10:06 AM");
INSERT INTO crm_audit_log VALUES("5757","3","15","2019-04-25 10:55:33","Exit Invoice [Invoice No: 119823] updated by Abdul Rasheed on 25/04/2019 at 10:55 AM");
INSERT INTO crm_audit_log VALUES("5758","3","15","2019-04-25 10:57:55","Exit Invoice [Invoice No: 119824] updated by Abdul Rasheed on 25/04/2019 at 10:57 AM");
INSERT INTO crm_audit_log VALUES("5759","3","15","2019-04-25 11:17:48","Exit Invoice [Invoice No: 119825] updated by Abdul Rasheed on 25/04/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("5760","3","15","2019-04-25 11:51:21","Exit Invoice [Invoice No: 119826] updated by Abdul Rasheed on 25/04/2019 at 11:51 AM");
INSERT INTO crm_audit_log VALUES("5761","2","7","2019-04-25 13:44:38","Entry Invoice [Invoice No: 21333] updated by ALSED ABU SHAMA on 25/04/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("5762","2","7","2019-04-25 13:50:10","Entry Invoice [Invoice No: 21334] updated by ALSED ABU SHAMA on 25/04/2019 at 01:50 PM");
INSERT INTO crm_audit_log VALUES("5763","3","15","2019-04-25 14:08:55","Exit Invoice [Invoice No: 119827] updated by Abdul Rasheed on 25/04/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("5764","3","15","2019-04-25 14:57:42","Exit Invoice [Invoice No: 119828] updated by Abdul Rasheed on 25/04/2019 at 02:57 PM");
INSERT INTO crm_audit_log VALUES("5765","3","15","2019-04-25 15:22:56","Exit Invoice [Invoice No: 119829] updated by Abdul Rasheed on 25/04/2019 at 03:22 PM");
INSERT INTO crm_audit_log VALUES("5766","3","4","2019-04-25 17:21:08","Exit Invoice [Invoice No: 119830] updated by Yasir  Rahman on 25/04/2019 at 05:21 PM");
INSERT INTO crm_audit_log VALUES("5767","3","4","2019-04-25 18:17:46","Exit Invoice [Invoice No: 119831] updated by Yasir  Rahman on 25/04/2019 at 06:17 PM");
INSERT INTO crm_audit_log VALUES("5768","3","4","2019-04-25 19:00:53","Exit Invoice [Invoice No: 119832] updated by Yasir  Rahman on 25/04/2019 at 07:00 PM");
INSERT INTO crm_audit_log VALUES("5769","3","4","2019-04-25 19:01:34","Exit Invoice [Invoice No: 119833] updated by Yasir  Rahman on 25/04/2019 at 07:01 PM");
INSERT INTO crm_audit_log VALUES("5770","3","4","2019-04-25 19:02:36","Exit Invoice [Invoice No: 119834] updated by Yasir  Rahman on 25/04/2019 at 07:02 PM");
INSERT INTO crm_audit_log VALUES("5771","2","7","2019-04-25 20:31:51","Entry Invoice [Invoice No: 21335] updated by ALSED ABU SHAMA on 25/04/2019 at 08:31 PM");
INSERT INTO crm_audit_log VALUES("5772","2","7","2019-04-25 20:47:01","Entry Invoice [Invoice No: 21336] updated by ALSED ABU SHAMA on 25/04/2019 at 08:47 PM");
INSERT INTO crm_audit_log VALUES("5773","3","4","2019-04-25 21:47:37","Exit Invoice [Invoice No: 119835] updated by Yasir  Rahman on 25/04/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("5774","2","4","2019-04-25 22:08:56","Entry Invoice [Invoice No: 21337] updated by Yasir  Rahman on 25/04/2019 at 10:08 PM");
INSERT INTO crm_audit_log VALUES("5775","2","4","2019-04-25 22:24:35","Entry Invoice [Invoice No: 21338] updated by Yasir  Rahman on 25/04/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("5776","3","4","2019-04-26 01:44:39","Exit Invoice [Invoice No: 119836] updated by Yasir  Rahman on 26/04/2019 at 01:44 AM");
INSERT INTO crm_audit_log VALUES("5777","3","4","2019-04-26 01:46:00","Exit Invoice [Invoice No: 119837] updated by Yasir  Rahman on 26/04/2019 at 01:46 AM");
INSERT INTO crm_audit_log VALUES("5778","2","4","2019-04-26 02:18:04","Entry Invoice [Invoice No: 21339] updated by Yasir  Rahman on 26/04/2019 at 02:18 AM");
INSERT INTO crm_audit_log VALUES("5779","2","4","2019-04-26 02:24:48","Entry Invoice [Invoice No: 21340] updated by Yasir  Rahman on 26/04/2019 at 02:24 AM");
INSERT INTO crm_audit_log VALUES("5780","2","4","2019-04-26 02:28:24","Entry Invoice [Invoice No: 21341] updated by Yasir  Rahman on 26/04/2019 at 02:28 AM");
INSERT INTO crm_audit_log VALUES("5781","3","4","2019-04-26 02:39:32","Exit Invoice [Invoice No: 119838] updated by Yasir  Rahman on 26/04/2019 at 02:39 AM");
INSERT INTO crm_audit_log VALUES("5782","2","4","2019-04-26 03:00:51","Entry Invoice [Invoice No: 21342] updated by Yasir  Rahman on 26/04/2019 at 03:00 AM");
INSERT INTO crm_audit_log VALUES("5783","2","4","2019-04-26 03:06:37","Entry Invoice [Invoice No: 21343] updated by Yasir  Rahman on 26/04/2019 at 03:06 AM");
INSERT INTO crm_audit_log VALUES("5784","2","4","2019-04-26 03:20:17","Entry Invoice [Invoice No: 21344] updated by Yasir  Rahman on 26/04/2019 at 03:20 AM");
INSERT INTO crm_audit_log VALUES("5785","2","4","2019-04-26 03:29:03","Entry Invoice [Invoice No: 21345] updated by Yasir  Rahman on 26/04/2019 at 03:29 AM");
INSERT INTO crm_audit_log VALUES("5786","3","4","2019-04-26 04:19:38","Exit Invoice [Invoice No: 119839] updated by Yasir  Rahman on 26/04/2019 at 04:19 AM");
INSERT INTO crm_audit_log VALUES("5787","2","4","2019-04-26 07:47:19","Entry Invoice [Invoice No: 21346] updated by Yasir  Rahman on 26/04/2019 at 07:47 AM");
INSERT INTO crm_audit_log VALUES("5788","2","4","2019-04-26 07:49:04","Entry Invoice [Invoice No: 21347] updated by Yasir  Rahman on 26/04/2019 at 07:49 AM");
INSERT INTO crm_audit_log VALUES("5789","3","15","2019-04-26 08:35:19","Exit Invoice [Invoice No: 119840] updated by Abdul Rasheed on 26/04/2019 at 08:35 AM");
INSERT INTO crm_audit_log VALUES("5790","2","6","2019-04-26 09:31:09","Entry Invoice [Invoice No: 21348] updated by ASHRAF  M K on 26/04/2019 at 09:31 AM");
INSERT INTO crm_audit_log VALUES("5791","2","6","2019-04-26 09:33:05","Entry Invoice [Invoice No: 21349] updated by ASHRAF  M K on 26/04/2019 at 09:33 AM");
INSERT INTO crm_audit_log VALUES("5792","2","6","2019-04-26 09:38:57","Entry Invoice [Invoice No: 21350] updated by ASHRAF  M K on 26/04/2019 at 09:38 AM");
INSERT INTO crm_audit_log VALUES("5793","2","6","2019-04-26 09:40:16","Entry Invoice [Invoice No: 21351] updated by ASHRAF  M K on 26/04/2019 at 09:40 AM");
INSERT INTO crm_audit_log VALUES("5794","2","6","2019-04-26 09:55:57","Entry Invoice [Invoice No: 21352] updated by ASHRAF  M K on 26/04/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("5795","3","15","2019-04-26 10:12:24","Exit Invoice [Invoice No: 119841] updated by Abdul Rasheed on 26/04/2019 at 10:12 AM");
INSERT INTO crm_audit_log VALUES("5796","3","15","2019-04-26 10:25:16","Exit Invoice [Invoice No: 119842] updated by Abdul Rasheed on 26/04/2019 at 10:25 AM");
INSERT INTO crm_audit_log VALUES("5797","3","15","2019-04-26 10:45:28","Exit Invoice [Invoice No: 119843] updated by Abdul Rasheed on 26/04/2019 at 10:45 AM");
INSERT INTO crm_audit_log VALUES("5798","2","7","2019-04-26 10:53:44","Entry Invoice [Invoice No: 21353] updated by ALSED ABU SHAMA on 26/04/2019 at 10:53 AM");
INSERT INTO crm_audit_log VALUES("5799","2","7","2019-04-26 11:45:44","Entry Invoice [Invoice No: 21354] updated by ALSED ABU SHAMA on 26/04/2019 at 11:45 AM");
INSERT INTO crm_audit_log VALUES("5800","2","7","2019-04-26 11:46:49","Entry Invoice [Invoice No: 21355] updated by ALSED ABU SHAMA on 26/04/2019 at 11:46 AM");
INSERT INTO crm_audit_log VALUES("5801","2","6","2019-04-26 11:46:56","Entry Invoice [Invoice No: 21356] updated by ASHRAF  M K on 26/04/2019 at 11:46 AM");
INSERT INTO crm_audit_log VALUES("5802","3","15","2019-04-26 13:49:08","Exit Invoice [Invoice No: 119844] updated by Abdul Rasheed on 26/04/2019 at 01:49 PM");
INSERT INTO crm_audit_log VALUES("5803","3","15","2019-04-26 14:08:46","Exit Invoice [Invoice No: 119845] updated by Abdul Rasheed on 26/04/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("5804","3","4","2019-04-26 16:24:53","Exit Invoice [Invoice No: 119846] updated by Yasir  Rahman on 26/04/2019 at 04:24 PM");
INSERT INTO crm_audit_log VALUES("5805","3","4","2019-04-26 16:26:17","Exit Invoice [Invoice No: 119847] updated by Yasir  Rahman on 26/04/2019 at 04:26 PM");
INSERT INTO crm_audit_log VALUES("5806","3","4","2019-04-26 16:53:55","Exit Invoice [Invoice No: 119848] updated by Yasir  Rahman on 26/04/2019 at 04:53 PM");
INSERT INTO crm_audit_log VALUES("5807","2","7","2019-04-26 17:56:19","Entry Invoice [Invoice No: 21357] updated by ALSED ABU SHAMA on 26/04/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("5808","2","4","2019-04-26 19:03:25","Entry Invoice [Invoice No: 21358] updated by Yasir  Rahman on 26/04/2019 at 07:03 PM");
INSERT INTO crm_audit_log VALUES("5809","2","4","2019-04-26 20:06:23","Entry Invoice [Invoice No: 21359] updated by Yasir  Rahman on 26/04/2019 at 08:06 PM");
INSERT INTO crm_audit_log VALUES("5810","2","7","2019-04-26 20:15:01","Entry Invoice [Invoice No: 21360] updated by ALSED ABU SHAMA on 26/04/2019 at 08:15 PM");
INSERT INTO crm_audit_log VALUES("5811","2","7","2019-04-26 20:24:31","Entry Invoice [Invoice No: 21361] updated by ALSED ABU SHAMA on 26/04/2019 at 08:24 PM");
INSERT INTO crm_audit_log VALUES("5812","2","7","2019-04-26 20:26:22","Entry Invoice [Invoice No: 21362] updated by ALSED ABU SHAMA on 26/04/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("5813","2","7","2019-04-26 20:27:07","Entry Invoice [Invoice No: 21363] updated by ALSED ABU SHAMA on 26/04/2019 at 08:27 PM");
INSERT INTO crm_audit_log VALUES("5814","2","7","2019-04-26 20:32:51","Entry Invoice [Invoice No: 21364] updated by ALSED ABU SHAMA on 26/04/2019 at 08:32 PM");
INSERT INTO crm_audit_log VALUES("5815","2","4","2019-04-26 20:45:11","Entry Invoice [Invoice No: 21365] updated by Yasir  Rahman on 26/04/2019 at 08:45 PM");
INSERT INTO crm_audit_log VALUES("5816","3","6","2019-04-26 21:07:46","Exit Invoice [Invoice No: 119847] updated by ASHRAF  M K on 26/04/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("5817","3","6","2019-04-26 21:11:01","Exit Invoice [Invoice No: 119846] updated by ASHRAF  M K on 26/04/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("5818","2","4","2019-04-26 21:21:11","Entry Invoice [Invoice No: 21366] updated by Yasir  Rahman on 26/04/2019 at 09:21 PM");
INSERT INTO crm_audit_log VALUES("5819","2","4","2019-04-26 21:25:16","Entry Invoice [Invoice No: 21367] updated by Yasir  Rahman on 26/04/2019 at 09:25 PM");
INSERT INTO crm_audit_log VALUES("5820","2","4","2019-04-26 21:35:39","Entry Invoice [Invoice No: 21368] updated by Yasir  Rahman on 26/04/2019 at 09:35 PM");
INSERT INTO crm_audit_log VALUES("5821","2","4","2019-04-26 22:03:09","Entry Invoice [Invoice No: 21369] updated by Yasir  Rahman on 26/04/2019 at 10:03 PM");
INSERT INTO crm_audit_log VALUES("5822","2","4","2019-04-26 22:04:50","Entry Invoice [Invoice No: 21370] updated by Yasir  Rahman on 26/04/2019 at 10:04 PM");
INSERT INTO crm_audit_log VALUES("5823","2","4","2019-04-26 22:06:26","Entry Invoice [Invoice No: 21371] updated by Yasir  Rahman on 26/04/2019 at 10:06 PM");
INSERT INTO crm_audit_log VALUES("5824","3","4","2019-04-26 22:16:14","Exit Invoice [Invoice No: 119849] updated by Yasir  Rahman on 26/04/2019 at 10:16 PM");
INSERT INTO crm_audit_log VALUES("5825","3","4","2019-04-26 22:19:37","Exit Invoice [Invoice No: 119850] updated by Yasir  Rahman on 26/04/2019 at 10:19 PM");
INSERT INTO crm_audit_log VALUES("5826","3","4","2019-04-26 23:12:50","Exit Invoice [Invoice No: 119851] updated by Yasir  Rahman on 26/04/2019 at 11:12 PM");
INSERT INTO crm_audit_log VALUES("5827","2","4","2019-04-26 23:19:36","Entry Invoice [Invoice No: 21372] updated by Yasir  Rahman on 26/04/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("5828","2","4","2019-04-27 03:18:29","Entry Invoice [Invoice No: 21373] updated by Yasir  Rahman on 27/04/2019 at 03:18 AM");
INSERT INTO crm_audit_log VALUES("5829","2","4","2019-04-27 03:20:18","Entry Invoice [Invoice No: 21374] updated by Yasir  Rahman on 27/04/2019 at 03:20 AM");
INSERT INTO crm_audit_log VALUES("5830","2","4","2019-04-27 03:26:42","Entry Invoice [Invoice No: 21375] updated by Yasir  Rahman on 27/04/2019 at 03:26 AM");
INSERT INTO crm_audit_log VALUES("5831","2","4","2019-04-27 03:28:59","Entry Invoice [Invoice No: 21376] updated by Yasir  Rahman on 27/04/2019 at 03:28 AM");
INSERT INTO crm_audit_log VALUES("5832","2","4","2019-04-27 03:32:00","Entry Invoice [Invoice No: 21377] updated by Yasir  Rahman on 27/04/2019 at 03:32 AM");
INSERT INTO crm_audit_log VALUES("5833","2","4","2019-04-27 03:34:20","Entry Invoice [Invoice No: 21378] updated by Yasir  Rahman on 27/04/2019 at 03:34 AM");
INSERT INTO crm_audit_log VALUES("5834","2","4","2019-04-27 03:36:16","Entry Invoice [Invoice No: 21379] updated by Yasir  Rahman on 27/04/2019 at 03:36 AM");
INSERT INTO crm_audit_log VALUES("5835","2","4","2019-04-27 03:37:42","Entry Invoice [Invoice No: 21380] updated by Yasir  Rahman on 27/04/2019 at 03:37 AM");
INSERT INTO crm_audit_log VALUES("5836","2","4","2019-04-27 05:00:36","Entry Invoice [Invoice No: 21381] updated by Yasir  Rahman on 27/04/2019 at 05:00 AM");
INSERT INTO crm_audit_log VALUES("5837","2","4","2019-04-27 05:02:27","Entry Invoice [Invoice No: 21382] updated by Yasir  Rahman on 27/04/2019 at 05:02 AM");
INSERT INTO crm_audit_log VALUES("5838","2","4","2019-04-27 05:04:14","Entry Invoice [Invoice No: 21383] updated by Yasir  Rahman on 27/04/2019 at 05:04 AM");
INSERT INTO crm_audit_log VALUES("5839","2","4","2019-04-27 05:31:30","Entry Invoice [Invoice No: 21384] updated by Yasir  Rahman on 27/04/2019 at 05:31 AM");
INSERT INTO crm_audit_log VALUES("5840","2","4","2019-04-27 05:32:59","Entry Invoice [Invoice No: 21385] updated by Yasir  Rahman on 27/04/2019 at 05:32 AM");
INSERT INTO crm_audit_log VALUES("5841","2","6","2019-04-27 08:53:10","Entry Invoice [Invoice No: 21378] updated by ASHRAF  M K on 27/04/2019 at 08:53 AM");
INSERT INTO crm_audit_log VALUES("5842","2","7","2019-04-27 10:23:45","Entry Invoice [Invoice No: 21386] updated by ALSED ABU SHAMA on 27/04/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("5843","2","7","2019-04-27 10:32:16","Entry Invoice [Invoice No: 21387] updated by ALSED ABU SHAMA on 27/04/2019 at 10:32 AM");
INSERT INTO crm_audit_log VALUES("5844","2","7","2019-04-27 10:33:13","Entry Invoice [Invoice No: 21388] updated by ALSED ABU SHAMA on 27/04/2019 at 10:33 AM");
INSERT INTO crm_audit_log VALUES("5845","2","7","2019-04-27 10:52:31","Entry Invoice [Invoice No: 21389] updated by ALSED ABU SHAMA on 27/04/2019 at 10:52 AM");
INSERT INTO crm_audit_log VALUES("5846","2","7","2019-04-27 12:27:44","Entry Invoice [Invoice No: 21390] updated by ALSED ABU SHAMA on 27/04/2019 at 12:27 PM");
INSERT INTO crm_audit_log VALUES("5847","3","15","2019-04-27 12:37:22","Exit Invoice [Invoice No: 119852] updated by Abdul Rasheed on 27/04/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("5848","3","4","2019-04-27 18:38:24","Exit Invoice [Invoice No: 119853] updated by Yasir  Rahman on 27/04/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("5849","2","7","2019-04-27 19:47:50","Entry Invoice [Invoice No: 21391] updated by ALSED ABU SHAMA on 27/04/2019 at 07:47 PM");
INSERT INTO crm_audit_log VALUES("5850","3","5","2019-04-27 21:07:06","Exit Invoice [Invoice No: 119854] updated by Imran  Khan on 27/04/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("5851","2","4","2019-04-27 21:08:51","Entry Invoice [Invoice No: 21392] updated by Yasir  Rahman on 27/04/2019 at 09:08 PM");
INSERT INTO crm_audit_log VALUES("5852","2","4","2019-04-27 22:10:14","Entry Invoice [Invoice No: 21393] updated by Yasir  Rahman on 27/04/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("5853","2","4","2019-04-27 22:44:38","Entry Invoice [Invoice No: 21394] updated by Yasir  Rahman on 27/04/2019 at 10:44 PM");
INSERT INTO crm_audit_log VALUES("5854","3","5","2019-04-27 23:15:58","Exit Invoice [Invoice No: 119855] updated by Imran  Khan on 27/04/2019 at 11:15 PM");
INSERT INTO crm_audit_log VALUES("5855","3","5","2019-04-28 02:10:13","Exit Invoice [Invoice No: 119856] updated by Imran  Khan on 28/04/2019 at 02:10 AM");
INSERT INTO crm_audit_log VALUES("5856","2","4","2019-04-28 02:26:41","Entry Invoice [Invoice No: 21395] updated by Yasir  Rahman on 28/04/2019 at 02:26 AM");
INSERT INTO crm_audit_log VALUES("5857","3","5","2019-04-28 02:35:01","Exit Invoice [Invoice No: 119857] updated by Imran  Khan on 28/04/2019 at 02:35 AM");
INSERT INTO crm_audit_log VALUES("5858","3","5","2019-04-28 03:22:05","Exit Invoice [Invoice No: 119858] updated by Imran  Khan on 28/04/2019 at 03:22 AM");
INSERT INTO crm_audit_log VALUES("5859","3","5","2019-04-28 03:22:46","Exit Invoice [Invoice No: 119859] updated by Imran  Khan on 28/04/2019 at 03:22 AM");
INSERT INTO crm_audit_log VALUES("5860","3","15","2019-04-28 08:24:54","Exit Invoice [Invoice No: 119860] updated by Abdul Rasheed on 28/04/2019 at 08:24 AM");
INSERT INTO crm_audit_log VALUES("5861","3","15","2019-04-28 09:48:27","Exit Invoice [Invoice No: 119861] updated by Abdul Rasheed on 28/04/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("5862","3","15","2019-04-28 09:49:52","Exit Invoice [Invoice No: 119862] updated by Abdul Rasheed on 28/04/2019 at 09:49 AM");
INSERT INTO crm_audit_log VALUES("5863","3","15","2019-04-28 10:09:33","Exit Invoice [Invoice No: 119863] updated by Abdul Rasheed on 28/04/2019 at 10:09 AM");
INSERT INTO crm_audit_log VALUES("5864","2","7","2019-04-28 12:07:24","Entry Invoice [Invoice No: 21396] updated by ALSED ABU SHAMA on 28/04/2019 at 12:07 PM");
INSERT INTO crm_audit_log VALUES("5865","2","7","2019-04-28 12:09:34","Entry Invoice [Invoice No: 21397] updated by ALSED ABU SHAMA on 28/04/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("5866","2","7","2019-04-28 12:11:13","Entry Invoice [Invoice No: 21398] updated by ALSED ABU SHAMA on 28/04/2019 at 12:11 PM");
INSERT INTO crm_audit_log VALUES("5867","2","6","2019-04-28 14:54:51","Entry Invoice [Invoice No: 21399] updated by ASHRAF  M K on 28/04/2019 at 02:54 PM");
INSERT INTO crm_audit_log VALUES("5868","2","6","2019-04-28 14:58:02","Entry Invoice [Invoice No: 21400] updated by ASHRAF  M K on 28/04/2019 at 02:58 PM");
INSERT INTO crm_audit_log VALUES("5869","2","6","2019-04-28 15:02:50","Entry Invoice [Invoice No: 21401] updated by ASHRAF  M K on 28/04/2019 at 03:02 PM");
INSERT INTO crm_audit_log VALUES("5870","3","4","2019-04-28 17:04:00","Exit Invoice [Invoice No: 119864] updated by Yasir  Rahman on 28/04/2019 at 05:04 PM");
INSERT INTO crm_audit_log VALUES("5871","2","6","2019-04-28 17:07:07","Entry Invoice [Invoice No: 21402] updated by ASHRAF  M K on 28/04/2019 at 05:07 PM");
INSERT INTO crm_audit_log VALUES("5872","2","6","2019-04-28 17:10:29","Entry Invoice [Invoice No: 21403] updated by ASHRAF  M K on 28/04/2019 at 05:10 PM");
INSERT INTO crm_audit_log VALUES("5873","2","6","2019-04-28 17:11:51","Entry Invoice [Invoice No: 21404] updated by ASHRAF  M K on 28/04/2019 at 05:11 PM");
INSERT INTO crm_audit_log VALUES("5874","2","6","2019-04-28 17:20:15","Entry Invoice [Invoice No: 21405] updated by ASHRAF  M K on 28/04/2019 at 05:20 PM");
INSERT INTO crm_audit_log VALUES("5875","2","6","2019-04-28 17:22:46","Entry Invoice [Invoice No: 21406] updated by ASHRAF  M K on 28/04/2019 at 05:22 PM");
INSERT INTO crm_audit_log VALUES("5876","2","6","2019-04-28 17:25:03","Entry Invoice [Invoice No: 21407] updated by ASHRAF  M K on 28/04/2019 at 05:25 PM");
INSERT INTO crm_audit_log VALUES("5877","3","4","2019-04-28 17:48:01","Exit Invoice [Invoice No: 119865] updated by Yasir  Rahman on 28/04/2019 at 05:48 PM");
INSERT INTO crm_audit_log VALUES("5878","2","6","2019-04-28 17:50:25","Entry Invoice [Invoice No: 21408] updated by ASHRAF  M K on 28/04/2019 at 05:50 PM");
INSERT INTO crm_audit_log VALUES("5879","2","6","2019-04-28 17:51:27","Entry Invoice [Invoice No: 21409] updated by ASHRAF  M K on 28/04/2019 at 05:51 PM");
INSERT INTO crm_audit_log VALUES("5880","2","6","2019-04-28 17:52:46","Entry Invoice [Invoice No: 21410] updated by ASHRAF  M K on 28/04/2019 at 05:52 PM");
INSERT INTO crm_audit_log VALUES("5881","2","6","2019-04-28 17:56:02","Entry Invoice [Invoice No: 21411] updated by ASHRAF  M K on 28/04/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("5882","2","6","2019-04-28 17:57:31","Entry Invoice [Invoice No: 21412] updated by ASHRAF  M K on 28/04/2019 at 05:57 PM");
INSERT INTO crm_audit_log VALUES("5883","3","4","2019-04-28 19:34:00","Exit Invoice [Invoice No: 119866] updated by Yasir  Rahman on 28/04/2019 at 07:34 PM");
INSERT INTO crm_audit_log VALUES("5884","2","7","2019-04-28 20:35:10","Entry Invoice [Invoice No: 21413] updated by ALSED ABU SHAMA on 28/04/2019 at 08:35 PM");
INSERT INTO crm_audit_log VALUES("5885","2","4","2019-04-28 21:57:19","Entry Invoice [Invoice No: 21414] updated by Yasir  Rahman on 28/04/2019 at 09:57 PM");
INSERT INTO crm_audit_log VALUES("5886","2","4","2019-04-28 21:58:38","Entry Invoice [Invoice No: 21415] updated by Yasir  Rahman on 28/04/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("5887","2","4","2019-04-28 22:00:00","Entry Invoice [Invoice No: 21416] updated by Yasir  Rahman on 28/04/2019 at 10:00 PM");
INSERT INTO crm_audit_log VALUES("5888","2","4","2019-04-28 22:01:43","Entry Invoice [Invoice No: 21417] updated by Yasir  Rahman on 28/04/2019 at 10:01 PM");
INSERT INTO crm_audit_log VALUES("5889","3","5","2019-04-28 23:29:50","Exit Invoice [Invoice No: 119867] updated by Imran  Khan on 28/04/2019 at 11:29 PM");
INSERT INTO crm_audit_log VALUES("5890","3","5","2019-04-28 23:30:51","Exit Invoice [Invoice No: 119868] updated by Imran  Khan on 28/04/2019 at 11:30 PM");
INSERT INTO crm_audit_log VALUES("5891","2","4","2019-04-28 23:44:20","Entry Invoice [Invoice No: 21418] updated by Yasir  Rahman on 28/04/2019 at 11:44 PM");
INSERT INTO crm_audit_log VALUES("5892","3","5","2019-04-29 01:10:35","Exit Invoice [Invoice No: 119869] updated by Imran  Khan on 29/04/2019 at 01:10 AM");
INSERT INTO crm_audit_log VALUES("5893","3","15","2019-04-29 10:04:07","Exit Invoice [Invoice No: 119870] updated by Abdul Rasheed on 29/04/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("5894","3","15","2019-04-29 10:05:45","Exit Invoice [Invoice No: 119871] updated by Abdul Rasheed on 29/04/2019 at 10:05 AM");
INSERT INTO crm_audit_log VALUES("5895","3","15","2019-04-29 10:07:14","Exit Invoice [Invoice No: 119872] updated by Abdul Rasheed on 29/04/2019 at 10:07 AM");
INSERT INTO crm_audit_log VALUES("5896","3","15","2019-04-29 10:08:34","Exit Invoice [Invoice No: 119873] updated by Abdul Rasheed on 29/04/2019 at 10:08 AM");
INSERT INTO crm_audit_log VALUES("5897","3","15","2019-04-29 10:09:49","Exit Invoice [Invoice No: 119874] updated by Abdul Rasheed on 29/04/2019 at 10:09 AM");
INSERT INTO crm_audit_log VALUES("5898","2","7","2019-04-29 10:22:05","Entry Invoice [Invoice No: 21419] updated by ALSED ABU SHAMA on 29/04/2019 at 10:22 AM");
INSERT INTO crm_audit_log VALUES("5899","3","15","2019-04-29 10:57:32","Exit Invoice [Invoice No: 119875] updated by Abdul Rasheed on 29/04/2019 at 10:57 AM");
INSERT INTO crm_audit_log VALUES("5900","2","7","2019-04-29 11:26:40","Entry Invoice [Invoice No: 21420] updated by ALSED ABU SHAMA on 29/04/2019 at 11:26 AM");
INSERT INTO crm_audit_log VALUES("5901","2","7","2019-04-29 11:27:54","Entry Invoice [Invoice No: 21421] updated by ALSED ABU SHAMA on 29/04/2019 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("5902","3","15","2019-04-29 12:40:35","Exit Invoice [Invoice No: 119876] updated by Abdul Rasheed on 29/04/2019 at 12:40 PM");
INSERT INTO crm_audit_log VALUES("5903","2","7","2019-04-29 14:14:21","Entry Invoice [Invoice No: 21422] updated by ALSED ABU SHAMA on 29/04/2019 at 02:14 PM");
INSERT INTO crm_audit_log VALUES("5904","3","4","2019-04-29 19:43:51","Exit Invoice [Invoice No: 119877] updated by Yasir  Rahman on 29/04/2019 at 07:43 PM");
INSERT INTO crm_audit_log VALUES("5905","3","4","2019-04-29 19:45:22","Exit Invoice [Invoice No: 119878] updated by Yasir  Rahman on 29/04/2019 at 07:45 PM");
INSERT INTO crm_audit_log VALUES("5906","2","7","2019-04-29 19:46:37","Entry Invoice [Invoice No: 21423] updated by ALSED ABU SHAMA on 29/04/2019 at 07:46 PM");
INSERT INTO crm_audit_log VALUES("5907","3","5","2019-04-29 20:56:12","Exit Invoice [Invoice No: 119879] updated by Imran  Khan on 29/04/2019 at 08:56 PM");
INSERT INTO crm_audit_log VALUES("5908","2","4","2019-04-29 21:53:13","Entry Invoice [Invoice No: 21424] updated by Yasir  Rahman on 29/04/2019 at 09:53 PM");
INSERT INTO crm_audit_log VALUES("5909","2","4","2019-04-29 21:55:29","Entry Invoice [Invoice No: 21425] updated by Yasir  Rahman on 29/04/2019 at 09:55 PM");
INSERT INTO crm_audit_log VALUES("5910","3","5","2019-04-29 23:03:38","Exit Invoice [Invoice No: 119880] updated by Imran  Khan on 29/04/2019 at 11:03 PM");
INSERT INTO crm_audit_log VALUES("5911","3","5","2019-04-29 23:04:15","Exit Invoice [Invoice No: 119881] updated by Imran  Khan on 29/04/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("5912","3","5","2019-04-29 23:52:35","Exit Invoice [Invoice No: 119882] updated by Imran  Khan on 29/04/2019 at 11:52 PM");
INSERT INTO crm_audit_log VALUES("5913","3","5","2019-04-29 23:53:12","Exit Invoice [Invoice No: 119883] updated by Imran  Khan on 29/04/2019 at 11:53 PM");
INSERT INTO crm_audit_log VALUES("5914","3","5","2019-04-29 23:54:11","Exit Invoice [Invoice No: 119884] updated by Imran  Khan on 29/04/2019 at 11:54 PM");
INSERT INTO crm_audit_log VALUES("5915","2","4","2019-04-29 23:54:36","Entry Invoice [Invoice No: 21426] updated by Yasir  Rahman on 29/04/2019 at 11:54 PM");
INSERT INTO crm_audit_log VALUES("5916","2","4","2019-04-29 23:55:46","Entry Invoice [Invoice No: 21427] updated by Yasir  Rahman on 29/04/2019 at 11:55 PM");
INSERT INTO crm_audit_log VALUES("5917","2","4","2019-04-29 23:56:52","Entry Invoice [Invoice No: 21428] updated by Yasir  Rahman on 29/04/2019 at 11:56 PM");
INSERT INTO crm_audit_log VALUES("5918","3","5","2019-04-30 00:34:26","Exit Invoice [Invoice No: 119885] updated by Imran  Khan on 30/04/2019 at 12:34 AM");
INSERT INTO crm_audit_log VALUES("5919","3","5","2019-04-30 02:35:09","Exit Invoice [Invoice No: 119886] updated by Imran  Khan on 30/04/2019 at 02:35 AM");
INSERT INTO crm_audit_log VALUES("5920","3","5","2019-04-30 04:53:21","Exit Invoice [Invoice No: 119887] updated by Imran  Khan on 30/04/2019 at 04:53 AM");
INSERT INTO crm_audit_log VALUES("5921","3","5","2019-04-30 05:34:07","Exit Invoice [Invoice No: 119888] updated by Imran  Khan on 30/04/2019 at 05:34 AM");
INSERT INTO crm_audit_log VALUES("5922","3","15","2019-04-30 08:05:01","Exit Invoice [Invoice No: 119889] updated by Abdul Rasheed on 30/04/2019 at 08:05 AM");
INSERT INTO crm_audit_log VALUES("5923","2","7","2019-04-30 08:54:49","Entry Invoice [Invoice No: 21429] updated by ALSED ABU SHAMA on 30/04/2019 at 08:54 AM");
INSERT INTO crm_audit_log VALUES("5924","3","4","2019-04-30 08:57:48","Exit Invoice [Invoice No: 119890] updated by Yasir  Rahman on 30/04/2019 at 08:57 AM");
INSERT INTO crm_audit_log VALUES("5925","3","4","2019-04-30 09:01:41","Exit Invoice [Invoice No: 119891] updated by Yasir  Rahman on 30/04/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("5926","3","4","2019-04-30 09:48:05","Exit Invoice [Invoice No: 119892] updated by Yasir  Rahman on 30/04/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("5927","2","7","2019-04-30 10:25:05","Entry Invoice [Invoice No: 21430] updated by ALSED ABU SHAMA on 30/04/2019 at 10:25 AM");
INSERT INTO crm_audit_log VALUES("5928","3","15","2019-04-30 10:45:04","Exit Invoice [Invoice No: 119893] updated by Abdul Rasheed on 30/04/2019 at 10:45 AM");
INSERT INTO crm_audit_log VALUES("5929","2","7","2019-04-30 11:17:10","Entry Invoice [Invoice No: 21431] updated by ALSED ABU SHAMA on 30/04/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("5930","2","7","2019-04-30 11:17:50","Entry Invoice [Invoice No: 21432] updated by ALSED ABU SHAMA on 30/04/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("5931","3","15","2019-04-30 11:31:26","Exit Invoice [Invoice No: 119894] updated by Abdul Rasheed on 30/04/2019 at 11:31 AM");
INSERT INTO crm_audit_log VALUES("5932","2","7","2019-04-30 13:19:13","Entry Invoice [Invoice No: 21433] updated by ALSED ABU SHAMA on 30/04/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("5933","2","7","2019-04-30 13:55:06","Entry Invoice [Invoice No: 21434] updated by ALSED ABU SHAMA on 30/04/2019 at 01:55 PM");
INSERT INTO crm_audit_log VALUES("5934","2","7","2019-04-30 13:59:29","Entry Invoice [Invoice No: 21435] updated by ALSED ABU SHAMA on 30/04/2019 at 01:59 PM");
INSERT INTO crm_audit_log VALUES("5935","3","15","2019-04-30 14:47:47","Exit Invoice [Invoice No: 119895] updated by Abdul Rasheed on 30/04/2019 at 02:47 PM");
INSERT INTO crm_audit_log VALUES("5936","2","7","2019-04-30 14:49:05","Entry Invoice [Invoice No: 21436] updated by ALSED ABU SHAMA on 30/04/2019 at 02:49 PM");
INSERT INTO crm_audit_log VALUES("5937","2","7","2019-04-30 15:50:11","Entry Invoice [Invoice No: 21437] updated by ALSED ABU SHAMA on 30/04/2019 at 03:50 PM");
INSERT INTO crm_audit_log VALUES("5938","2","7","2019-04-30 15:51:32","Entry Invoice [Invoice No: 21438] updated by ALSED ABU SHAMA on 30/04/2019 at 03:51 PM");
INSERT INTO crm_audit_log VALUES("5939","2","7","2019-04-30 15:52:23","Entry Invoice [Invoice No: 21439] updated by ALSED ABU SHAMA on 30/04/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("5940","3","5","2019-04-30 20:05:38","Exit Invoice [Invoice No: 119896] updated by Imran  Khan on 30/04/2019 at 08:05 PM");
INSERT INTO crm_audit_log VALUES("5941","2","4","2019-04-30 21:53:39","Entry Invoice [Invoice No: 21440] updated by Yasir  Rahman on 30/04/2019 at 09:53 PM");
INSERT INTO crm_audit_log VALUES("5942","2","4","2019-04-30 21:56:48","Entry Invoice [Invoice No: 21441] updated by Yasir  Rahman on 30/04/2019 at 09:56 PM");
INSERT INTO crm_audit_log VALUES("5943","3","5","2019-04-30 23:51:19","Exit Invoice [Invoice No: 119897] updated by Imran  Khan on 30/04/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("5944","3","5","2019-05-01 00:57:55","Exit Invoice [Invoice No: 119898] updated by Imran  Khan on 01/05/2019 at 12:57 AM");
INSERT INTO crm_audit_log VALUES("5945","3","5","2019-05-01 01:30:53","Exit Invoice [Invoice No: 119899] updated by Imran  Khan on 01/05/2019 at 01:30 AM");
INSERT INTO crm_audit_log VALUES("5946","3","5","2019-05-01 02:13:14","Exit Invoice [Invoice No: 119900] updated by Imran  Khan on 01/05/2019 at 02:13 AM");
INSERT INTO crm_audit_log VALUES("5947","3","4","2019-05-01 03:09:55","Exit Invoice [Invoice No: 119901] updated by Yasir  Rahman on 01/05/2019 at 03:09 AM");
INSERT INTO crm_audit_log VALUES("5948","3","5","2019-05-01 05:11:06","Exit Invoice [Invoice No: 119902] updated by Imran  Khan on 01/05/2019 at 05:11 AM");
INSERT INTO crm_audit_log VALUES("5949","3","5","2019-05-01 07:25:20","Exit Invoice [Invoice No: 119903] updated by Imran  Khan on 01/05/2019 at 07:25 AM");
INSERT INTO crm_audit_log VALUES("5950","2","4","2019-05-01 07:36:08","Entry Invoice [Invoice No: 21442] updated by Yasir  Rahman on 01/05/2019 at 07:36 AM");
INSERT INTO crm_audit_log VALUES("5951","3","15","2019-05-01 09:14:41","Exit Invoice [Invoice No: 119904] updated by Abdul Rasheed on 01/05/2019 at 09:14 AM");
INSERT INTO crm_audit_log VALUES("5952","3","15","2019-05-01 10:26:19","Exit Invoice [Invoice No: 119905] updated by Abdul Rasheed on 01/05/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("5953","3","15","2019-05-01 10:28:39","Exit Invoice [Invoice No: 119906] updated by Abdul Rasheed on 01/05/2019 at 10:28 AM");
INSERT INTO crm_audit_log VALUES("5954","3","15","2019-05-01 11:14:13","Exit Invoice [Invoice No: 119907] updated by Abdul Rasheed on 01/05/2019 at 11:14 AM");
INSERT INTO crm_audit_log VALUES("5955","1","6","2019-05-01 11:25:27","Customer [Customer No: 439] updated by ASHRAF  M K on 01/05/2019 at 11:25 AM");
INSERT INTO crm_audit_log VALUES("5956","2","7","2019-05-01 11:29:45","Entry Invoice [Invoice No: 21443] updated by ALSED ABU SHAMA on 01/05/2019 at 11:29 AM");
INSERT INTO crm_audit_log VALUES("5957","2","7","2019-05-01 12:03:27","Entry Invoice [Invoice No: 21444] updated by ALSED ABU SHAMA on 01/05/2019 at 12:03 PM");
INSERT INTO crm_audit_log VALUES("5958","3","15","2019-05-01 12:50:49","Exit Invoice [Invoice No: 119908] updated by Abdul Rasheed on 01/05/2019 at 12:50 PM");
INSERT INTO crm_audit_log VALUES("5959","1","6","2019-05-01 14:26:59","Customer [Customer No: 440] updated by ASHRAF  M K on 01/05/2019 at 02:26 PM");
INSERT INTO crm_audit_log VALUES("5960","1","6","2019-05-01 14:28:07","Customer [Customer No: 441] updated by ASHRAF  M K on 01/05/2019 at 02:28 PM");
INSERT INTO crm_audit_log VALUES("5961","1","6","2019-05-01 14:29:39","Customer [Customer No: 442] updated by ASHRAF  M K on 01/05/2019 at 02:29 PM");
INSERT INTO crm_audit_log VALUES("5962","1","6","2019-05-01 14:31:01","Customer [Customer No: 443] updated by ASHRAF  M K on 01/05/2019 at 02:31 PM");
INSERT INTO crm_audit_log VALUES("5963","1","6","2019-05-01 14:32:12","Customer [Customer No: 444] updated by ASHRAF  M K on 01/05/2019 at 02:32 PM");
INSERT INTO crm_audit_log VALUES("5964","1","6","2019-05-01 14:33:20","Customer [Customer No: 445] updated by ASHRAF  M K on 01/05/2019 at 02:33 PM");
INSERT INTO crm_audit_log VALUES("5965","1","6","2019-05-01 14:34:34","Customer [Customer No: 446] updated by ASHRAF  M K on 01/05/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("5966","3","4","2019-05-01 16:56:37","Exit Invoice [Invoice No: 119909] updated by Yasir  Rahman on 01/05/2019 at 04:56 PM");
INSERT INTO crm_audit_log VALUES("5967","2","7","2019-05-01 17:14:39","Entry Invoice [Invoice No: 21445] updated by ALSED ABU SHAMA on 01/05/2019 at 05:14 PM");
INSERT INTO crm_audit_log VALUES("5968","2","7","2019-05-01 18:08:05","Entry Invoice [Invoice No: 21446] updated by ALSED ABU SHAMA on 01/05/2019 at 06:08 PM");
INSERT INTO crm_audit_log VALUES("5969","3","4","2019-05-01 18:47:15","Exit Invoice [Invoice No: 119910] updated by Yasir  Rahman on 01/05/2019 at 06:47 PM");
INSERT INTO crm_audit_log VALUES("5970","3","4","2019-05-01 18:56:47","Exit Invoice [Invoice No: 119911] updated by Yasir  Rahman on 01/05/2019 at 06:56 PM");
INSERT INTO crm_audit_log VALUES("5971","3","15","2019-05-01 19:58:24","Exit Invoice [Invoice No: 119912] updated by Abdul Rasheed on 01/05/2019 at 07:58 PM");
INSERT INTO crm_audit_log VALUES("5972","2","4","2019-05-01 21:47:57","Entry Invoice [Invoice No: 21447] updated by Yasir  Rahman on 01/05/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("5973","2","4","2019-05-01 21:55:38","Entry Invoice [Invoice No: 21448] updated by Yasir  Rahman on 01/05/2019 at 09:55 PM");
INSERT INTO crm_audit_log VALUES("5974","2","4","2019-05-01 21:56:48","Entry Invoice [Invoice No: 21449] updated by Yasir  Rahman on 01/05/2019 at 09:56 PM");
INSERT INTO crm_audit_log VALUES("5975","3","4","2019-05-01 23:02:36","Exit Invoice [Invoice No: 119913] updated by Yasir  Rahman on 01/05/2019 at 11:02 PM");
INSERT INTO crm_audit_log VALUES("5976","2","4","2019-05-01 23:48:51","Entry Invoice [Invoice No: 21450] updated by Yasir  Rahman on 01/05/2019 at 11:48 PM");
INSERT INTO crm_audit_log VALUES("5977","3","4","2019-05-01 23:53:12","Exit Invoice [Invoice No: 119914] updated by Yasir  Rahman on 01/05/2019 at 11:53 PM");
INSERT INTO crm_audit_log VALUES("5978","2","4","2019-05-01 23:55:51","Entry Invoice [Invoice No: 21451] updated by Yasir  Rahman on 01/05/2019 at 11:55 PM");
INSERT INTO crm_audit_log VALUES("5979","2","4","2019-05-02 00:39:50","Entry Invoice [Invoice No: 21452] updated by Yasir  Rahman on 02/05/2019 at 12:39 AM");
INSERT INTO crm_audit_log VALUES("5980","3","4","2019-05-02 01:25:33","Exit Invoice [Invoice No: 119915] updated by Yasir  Rahman on 02/05/2019 at 01:25 AM");
INSERT INTO crm_audit_log VALUES("5981","3","4","2019-05-02 01:28:30","Exit Invoice [Invoice No: 119916] updated by Yasir  Rahman on 02/05/2019 at 01:28 AM");
INSERT INTO crm_audit_log VALUES("5982","2","4","2019-05-02 02:04:59","Entry Invoice [Invoice No: 21453] updated by Yasir  Rahman on 02/05/2019 at 02:04 AM");
INSERT INTO crm_audit_log VALUES("5983","3","4","2019-05-02 03:32:41","Exit Invoice [Invoice No: 119917] updated by Yasir  Rahman on 02/05/2019 at 03:32 AM");
INSERT INTO crm_audit_log VALUES("5984","3","4","2019-05-02 05:59:07","Exit Invoice [Invoice No: 119918] updated by Yasir  Rahman on 02/05/2019 at 05:59 AM");
INSERT INTO crm_audit_log VALUES("5985","3","4","2019-05-02 07:19:37","Exit Invoice [Invoice No: 119919] updated by Yasir  Rahman on 02/05/2019 at 07:19 AM");
INSERT INTO crm_audit_log VALUES("5986","2","4","2019-05-02 07:31:25","Entry Invoice [Invoice No: 21454] updated by Yasir  Rahman on 02/05/2019 at 07:31 AM");
INSERT INTO crm_audit_log VALUES("5987","3","15","2019-05-02 12:49:25","Exit Invoice [Invoice No: 119920] updated by Abdul Rasheed on 02/05/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("5988","3","15","2019-05-02 12:51:32","Exit Invoice [Invoice No: 119921] updated by Abdul Rasheed on 02/05/2019 at 12:51 PM");
INSERT INTO crm_audit_log VALUES("5989","2","6","2019-05-02 13:15:29","Entry Invoice [Invoice No: 21455] updated by ASHRAF  M K on 02/05/2019 at 01:15 PM");
INSERT INTO crm_audit_log VALUES("5990","2","6","2019-05-02 13:22:41","Entry Invoice [Invoice No: 21456] updated by ASHRAF  M K on 02/05/2019 at 01:22 PM");
INSERT INTO crm_audit_log VALUES("5991","2","6","2019-05-02 13:22:55","Entry Invoice [Invoice No: 21456] updated by ASHRAF  M K on 02/05/2019 at 01:22 PM");
INSERT INTO crm_audit_log VALUES("5992","2","6","2019-05-02 13:46:56","Entry Invoice [Invoice No: 21457] updated by ASHRAF  M K on 02/05/2019 at 01:46 PM");
INSERT INTO crm_audit_log VALUES("5993","3","15","2019-05-02 13:47:27","Exit Invoice [Invoice No: 119922] updated by Abdul Rasheed on 02/05/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("5994","2","6","2019-05-02 13:57:02","Entry Invoice [Invoice No: 21458] updated by ASHRAF  M K on 02/05/2019 at 01:57 PM");
INSERT INTO crm_audit_log VALUES("5995","3","6","2019-05-02 14:52:43","Exit Invoice [Invoice No: 119922] updated by ASHRAF  M K on 02/05/2019 at 02:52 PM");
INSERT INTO crm_audit_log VALUES("5996","2","7","2019-05-02 14:55:49","Entry Invoice [Invoice No: 21459] updated by ALSED ABU SHAMA on 02/05/2019 at 02:55 PM");
INSERT INTO crm_audit_log VALUES("5997","2","7","2019-05-02 14:56:56","Entry Invoice [Invoice No: 21460] updated by ALSED ABU SHAMA on 02/05/2019 at 02:56 PM");
INSERT INTO crm_audit_log VALUES("5998","2","7","2019-05-02 14:57:56","Entry Invoice [Invoice No: 21461] updated by ALSED ABU SHAMA on 02/05/2019 at 02:57 PM");
INSERT INTO crm_audit_log VALUES("5999","2","7","2019-05-02 14:58:42","Entry Invoice [Invoice No: 21462] updated by ALSED ABU SHAMA on 02/05/2019 at 02:58 PM");
INSERT INTO crm_audit_log VALUES("6000","2","7","2019-05-02 16:17:58","Entry Invoice [Invoice No: 21463] updated by ALSED ABU SHAMA on 02/05/2019 at 04:17 PM");
INSERT INTO crm_audit_log VALUES("6001","3","4","2019-05-02 17:45:58","Exit Invoice [Invoice No: 119923] updated by Yasir  Rahman on 02/05/2019 at 05:45 PM");
INSERT INTO crm_audit_log VALUES("6002","3","4","2019-05-02 18:09:26","Exit Invoice [Invoice No: 119924] updated by Yasir  Rahman on 02/05/2019 at 06:09 PM");
INSERT INTO crm_audit_log VALUES("6003","3","4","2019-05-02 18:42:05","Exit Invoice [Invoice No: 119925] updated by Yasir  Rahman on 02/05/2019 at 06:42 PM");
INSERT INTO crm_audit_log VALUES("6004","3","4","2019-05-02 18:43:35","Exit Invoice [Invoice No: 119926] updated by Yasir  Rahman on 02/05/2019 at 06:43 PM");
INSERT INTO crm_audit_log VALUES("6005","2","7","2019-05-02 19:05:02","Entry Invoice [Invoice No: 21464] updated by ALSED ABU SHAMA on 02/05/2019 at 07:05 PM");
INSERT INTO crm_audit_log VALUES("6006","3","4","2019-05-02 19:23:09","Exit Invoice [Invoice No: 119927] updated by Yasir  Rahman on 02/05/2019 at 07:23 PM");
INSERT INTO crm_audit_log VALUES("6007","3","5","2019-05-02 21:13:21","Exit Invoice [Invoice No: 119928] updated by Imran  Khan on 02/05/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("6008","3","5","2019-05-02 21:17:59","Exit Invoice [Invoice No: 119929] updated by Imran  Khan on 02/05/2019 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("6009","2","4","2019-05-02 21:46:07","Entry Invoice [Invoice No: 21465] updated by Yasir  Rahman on 02/05/2019 at 09:46 PM");
INSERT INTO crm_audit_log VALUES("6010","2","4","2019-05-02 21:47:25","Entry Invoice [Invoice No: 21466] updated by Yasir  Rahman on 02/05/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("6011","2","4","2019-05-02 22:01:12","Entry Invoice [Invoice No: 21467] updated by Yasir  Rahman on 02/05/2019 at 10:01 PM");
INSERT INTO crm_audit_log VALUES("6012","3","5","2019-05-02 23:35:15","Exit Invoice [Invoice No: 119930] updated by Imran  Khan on 02/05/2019 at 11:35 PM");
INSERT INTO crm_audit_log VALUES("6013","2","4","2019-05-02 23:39:20","Entry Invoice [Invoice No: 21468] updated by Yasir  Rahman on 02/05/2019 at 11:39 PM");
INSERT INTO crm_audit_log VALUES("6014","2","4","2019-05-02 23:42:34","Entry Invoice [Invoice No: 21469] updated by Yasir  Rahman on 02/05/2019 at 11:42 PM");
INSERT INTO crm_audit_log VALUES("6015","2","4","2019-05-02 23:44:01","Entry Invoice [Invoice No: 21470] updated by Yasir  Rahman on 02/05/2019 at 11:44 PM");
INSERT INTO crm_audit_log VALUES("6016","2","4","2019-05-02 23:45:32","Entry Invoice [Invoice No: 21471] updated by Yasir  Rahman on 02/05/2019 at 11:45 PM");
INSERT INTO crm_audit_log VALUES("6017","2","4","2019-05-02 23:46:50","Entry Invoice [Invoice No: 21472] updated by Yasir  Rahman on 02/05/2019 at 11:46 PM");
INSERT INTO crm_audit_log VALUES("6018","2","4","2019-05-02 23:48:31","Entry Invoice [Invoice No: 21473] updated by Yasir  Rahman on 02/05/2019 at 11:48 PM");
INSERT INTO crm_audit_log VALUES("6019","2","4","2019-05-02 23:49:58","Entry Invoice [Invoice No: 21474] updated by Yasir  Rahman on 02/05/2019 at 11:49 PM");
INSERT INTO crm_audit_log VALUES("6020","2","4","2019-05-02 23:51:35","Entry Invoice [Invoice No: 21475] updated by Yasir  Rahman on 02/05/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("6021","3","5","2019-05-03 01:57:33","Exit Invoice [Invoice No: 119931] updated by Imran  Khan on 03/05/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("6022","3","5","2019-05-03 03:22:36","Exit Invoice [Invoice No: 119932] updated by Imran  Khan on 03/05/2019 at 03:22 AM");
INSERT INTO crm_audit_log VALUES("6023","3","5","2019-05-03 03:23:08","Exit Invoice [Invoice No: 119933] updated by Imran  Khan on 03/05/2019 at 03:23 AM");
INSERT INTO crm_audit_log VALUES("6024","3","5","2019-05-03 03:23:48","Exit Invoice [Invoice No: 119934] updated by Imran  Khan on 03/05/2019 at 03:23 AM");
INSERT INTO crm_audit_log VALUES("6025","3","4","2019-05-03 04:10:29","Exit Invoice [Invoice No: 119935] updated by Yasir  Rahman on 03/05/2019 at 04:10 AM");
INSERT INTO crm_audit_log VALUES("6026","3","15","2019-05-03 08:23:04","Exit Invoice [Invoice No: 119936] updated by Abdul Rasheed on 03/05/2019 at 08:23 AM");
INSERT INTO crm_audit_log VALUES("6027","3","15","2019-05-03 08:38:41","Exit Invoice [Invoice No: 119937] updated by Abdul Rasheed on 03/05/2019 at 08:38 AM");
INSERT INTO crm_audit_log VALUES("6028","3","15","2019-05-03 09:42:18","Exit Invoice [Invoice No: 119938] updated by Abdul Rasheed on 03/05/2019 at 09:42 AM");
INSERT INTO crm_audit_log VALUES("6029","3","15","2019-05-03 09:59:46","Exit Invoice [Invoice No: 119939] updated by Abdul Rasheed on 03/05/2019 at 09:59 AM");
INSERT INTO crm_audit_log VALUES("6030","3","15","2019-05-03 10:01:03","Exit Invoice [Invoice No: 119940] updated by Abdul Rasheed on 03/05/2019 at 10:01 AM");
INSERT INTO crm_audit_log VALUES("6031","3","15","2019-05-03 11:38:41","Exit Invoice [Invoice No: 119941] updated by Abdul Rasheed on 03/05/2019 at 11:38 AM");
INSERT INTO crm_audit_log VALUES("6032","3","15","2019-05-03 11:41:03","Exit Invoice [Invoice No: 119942] updated by Abdul Rasheed on 03/05/2019 at 11:41 AM");
INSERT INTO crm_audit_log VALUES("6033","3","15","2019-05-03 14:11:41","Exit Invoice [Invoice No: 119943] updated by Abdul Rasheed on 03/05/2019 at 02:11 PM");
INSERT INTO crm_audit_log VALUES("6034","3","4","2019-05-03 16:05:34","Exit Invoice [Invoice No: 119944] updated by Yasir  Rahman on 03/05/2019 at 04:05 PM");
INSERT INTO crm_audit_log VALUES("6035","3","4","2019-05-03 17:15:40","Exit Invoice [Invoice No: 119945] updated by Yasir  Rahman on 03/05/2019 at 05:15 PM");
INSERT INTO crm_audit_log VALUES("6036","3","4","2019-05-03 19:06:49","Exit Invoice [Invoice No: 119946] updated by Yasir  Rahman on 03/05/2019 at 07:06 PM");
INSERT INTO crm_audit_log VALUES("6037","3","4","2019-05-03 19:08:59","Exit Invoice [Invoice No: 119947] updated by Yasir  Rahman on 03/05/2019 at 07:08 PM");
INSERT INTO crm_audit_log VALUES("6038","3","4","2019-05-03 19:10:37","Exit Invoice [Invoice No: 119948] updated by Yasir  Rahman on 03/05/2019 at 07:10 PM");
INSERT INTO crm_audit_log VALUES("6039","3","4","2019-05-03 19:11:49","Exit Invoice [Invoice No: 119949] updated by Yasir  Rahman on 03/05/2019 at 07:11 PM");
INSERT INTO crm_audit_log VALUES("6040","3","4","2019-05-03 19:12:45","Exit Invoice [Invoice No: 119950] updated by Yasir  Rahman on 03/05/2019 at 07:12 PM");
INSERT INTO crm_audit_log VALUES("6041","3","4","2019-05-03 19:49:05","Exit Invoice [Invoice No: 119951] updated by Yasir  Rahman on 03/05/2019 at 07:49 PM");
INSERT INTO crm_audit_log VALUES("6042","2","4","2019-05-03 20:37:07","Entry Invoice [Invoice No: 21476] updated by Yasir  Rahman on 03/05/2019 at 08:37 PM");
INSERT INTO crm_audit_log VALUES("6043","2","4","2019-05-03 20:48:03","Entry Invoice [Invoice No: 21477] updated by Yasir  Rahman on 03/05/2019 at 08:48 PM");
INSERT INTO crm_audit_log VALUES("6044","2","4","2019-05-03 20:49:11","Entry Invoice [Invoice No: 21478] updated by Yasir  Rahman on 03/05/2019 at 08:49 PM");
INSERT INTO crm_audit_log VALUES("6045","2","4","2019-05-03 21:36:14","Entry Invoice [Invoice No: 21479] updated by Yasir  Rahman on 03/05/2019 at 09:36 PM");
INSERT INTO crm_audit_log VALUES("6046","2","4","2019-05-03 21:37:37","Entry Invoice [Invoice No: 21480] updated by Yasir  Rahman on 03/05/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("6047","2","4","2019-05-03 21:39:01","Entry Invoice [Invoice No: 21481] updated by Yasir  Rahman on 03/05/2019 at 09:39 PM");
INSERT INTO crm_audit_log VALUES("6048","2","4","2019-05-03 21:40:42","Entry Invoice [Invoice No: 21482] updated by Yasir  Rahman on 03/05/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("6049","3","5","2019-05-03 22:50:02","Exit Invoice [Invoice No: 119952] updated by Imran  Khan on 03/05/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("6050","3","5","2019-05-04 01:10:15","Exit Invoice [Invoice No: 119953] updated by Imran  Khan on 04/05/2019 at 01:10 AM");
INSERT INTO crm_audit_log VALUES("6051","3","5","2019-05-04 01:13:35","Exit Invoice [Invoice No: 119954] updated by Imran  Khan on 04/05/2019 at 01:13 AM");
INSERT INTO crm_audit_log VALUES("6052","2","4","2019-05-04 01:35:28","Entry Invoice [Invoice No: 21483] updated by Yasir  Rahman on 04/05/2019 at 01:35 AM");
INSERT INTO crm_audit_log VALUES("6053","3","4","2019-05-04 05:34:02","Exit Invoice [Invoice No: 119955] updated by Yasir  Rahman on 04/05/2019 at 05:34 AM");
INSERT INTO crm_audit_log VALUES("6054","3","4","2019-05-04 06:03:19","Exit Invoice [Invoice No: 119956] updated by Yasir  Rahman on 04/05/2019 at 06:03 AM");
INSERT INTO crm_audit_log VALUES("6055","2","7","2019-05-04 11:30:46","Entry Invoice [Invoice No: 21484] updated by ALSED ABU SHAMA on 04/05/2019 at 11:30 AM");
INSERT INTO crm_audit_log VALUES("6056","3","15","2019-05-04 12:07:46","Exit Invoice [Invoice No: 119957] updated by Abdul Rasheed on 04/05/2019 at 12:07 PM");
INSERT INTO crm_audit_log VALUES("6057","2","7","2019-05-04 16:34:46","Entry Invoice [Invoice No: 21485] updated by ALSED ABU SHAMA on 04/05/2019 at 04:34 PM");
INSERT INTO crm_audit_log VALUES("6058","3","4","2019-05-04 16:35:03","Exit Invoice [Invoice No: 119958] updated by Yasir  Rahman on 04/05/2019 at 04:35 PM");
INSERT INTO crm_audit_log VALUES("6059","2","7","2019-05-04 16:44:43","Entry Invoice [Invoice No: 21486] updated by ALSED ABU SHAMA on 04/05/2019 at 04:44 PM");
INSERT INTO crm_audit_log VALUES("6060","2","7","2019-05-04 16:45:28","Entry Invoice [Invoice No: 21487] updated by ALSED ABU SHAMA on 04/05/2019 at 04:45 PM");
INSERT INTO crm_audit_log VALUES("6061","2","7","2019-05-04 16:46:14","Entry Invoice [Invoice No: 21488] updated by ALSED ABU SHAMA on 04/05/2019 at 04:46 PM");
INSERT INTO crm_audit_log VALUES("6062","2","7","2019-05-04 16:46:58","Entry Invoice [Invoice No: 21489] updated by ALSED ABU SHAMA on 04/05/2019 at 04:46 PM");
INSERT INTO crm_audit_log VALUES("6063","2","7","2019-05-04 16:48:02","Entry Invoice [Invoice No: 21490] updated by ALSED ABU SHAMA on 04/05/2019 at 04:48 PM");
INSERT INTO crm_audit_log VALUES("6064","2","7","2019-05-04 16:48:40","Entry Invoice [Invoice No: 21491] updated by ALSED ABU SHAMA on 04/05/2019 at 04:48 PM");
INSERT INTO crm_audit_log VALUES("6065","3","5","2019-05-04 20:43:35","Exit Invoice [Invoice No: 119959] updated by Imran  Khan on 04/05/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("6066","3","5","2019-05-04 21:00:05","Exit Invoice [Invoice No: 119960] updated by Imran  Khan on 04/05/2019 at 09:00 PM");
INSERT INTO crm_audit_log VALUES("6067","2","4","2019-05-04 21:17:13","Entry Invoice [Invoice No: 21492] updated by Yasir  Rahman on 04/05/2019 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("6068","2","4","2019-05-04 21:19:11","Entry Invoice [Invoice No: 21493] updated by Yasir  Rahman on 04/05/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("6069","2","4","2019-05-04 21:21:21","Entry Invoice [Invoice No: 21494] updated by Yasir  Rahman on 04/05/2019 at 09:21 PM");
INSERT INTO crm_audit_log VALUES("6070","2","4","2019-05-04 21:24:20","Entry Invoice [Invoice No: 21495] updated by Yasir  Rahman on 04/05/2019 at 09:24 PM");
INSERT INTO crm_audit_log VALUES("6071","2","4","2019-05-04 21:26:23","Entry Invoice [Invoice No: 21496] updated by Yasir  Rahman on 04/05/2019 at 09:26 PM");
INSERT INTO crm_audit_log VALUES("6072","2","4","2019-05-04 21:30:05","Entry Invoice [Invoice No: 21497] updated by Yasir  Rahman on 04/05/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("6073","2","4","2019-05-04 21:32:19","Entry Invoice [Invoice No: 21498] updated by Yasir  Rahman on 04/05/2019 at 09:32 PM");
INSERT INTO crm_audit_log VALUES("6074","3","5","2019-05-04 21:54:04","Exit Invoice [Invoice No: 119961] updated by Imran  Khan on 04/05/2019 at 09:54 PM");
INSERT INTO crm_audit_log VALUES("6075","3","5","2019-05-04 23:39:48","Exit Invoice [Invoice No: 119962] updated by Imran  Khan on 04/05/2019 at 11:39 PM");
INSERT INTO crm_audit_log VALUES("6076","3","5","2019-05-05 03:27:04","Exit Invoice [Invoice No: 119963] updated by Imran  Khan on 05/05/2019 at 03:27 AM");
INSERT INTO crm_audit_log VALUES("6077","2","4","2019-05-05 07:20:44","Entry Invoice [Invoice No: 21499] updated by Yasir  Rahman on 05/05/2019 at 07:20 AM");
INSERT INTO crm_audit_log VALUES("6078","2","4","2019-05-05 07:22:44","Entry Invoice [Invoice No: 21500] updated by Yasir  Rahman on 05/05/2019 at 07:22 AM");
INSERT INTO crm_audit_log VALUES("6079","2","7","2019-05-05 09:01:07","Entry Invoice [Invoice No: 21501] updated by ALSED ABU SHAMA on 05/05/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("6080","2","7","2019-05-05 10:21:26","Entry Invoice [Invoice No: 21502] updated by ALSED ABU SHAMA on 05/05/2019 at 10:21 AM");
INSERT INTO crm_audit_log VALUES("6081","2","7","2019-05-05 10:29:51","Entry Invoice [Invoice No: 21503] updated by ALSED ABU SHAMA on 05/05/2019 at 10:29 AM");
INSERT INTO crm_audit_log VALUES("6082","2","7","2019-05-05 10:58:30","Entry Invoice [Invoice No: 21504] updated by ALSED ABU SHAMA on 05/05/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("6083","2","6","2019-05-05 12:13:28","Entry Invoice [Invoice No: 21505] updated by ASHRAF  M K on 05/05/2019 at 12:13 PM");
INSERT INTO crm_audit_log VALUES("6084","2","7","2019-05-05 13:45:21","Entry Invoice [Invoice No: 21506] updated by ALSED ABU SHAMA on 05/05/2019 at 01:45 PM");
INSERT INTO crm_audit_log VALUES("6085","2","6","2019-05-05 14:02:10","Entry Invoice [Invoice No: 21507] updated by ASHRAF  M K on 05/05/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("6086","2","6","2019-05-05 14:10:36","Entry Invoice [Invoice No: 21508] updated by ASHRAF  M K on 05/05/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("6087","3","15","2019-05-05 14:32:24","Exit Invoice [Invoice No: 119964] updated by Abdul Rasheed on 05/05/2019 at 02:32 PM");
INSERT INTO crm_audit_log VALUES("6088","2","6","2019-05-05 15:33:31","Entry Invoice [Invoice No: 21509] updated by ASHRAF  M K on 05/05/2019 at 03:33 PM");
INSERT INTO crm_audit_log VALUES("6089","2","7","2019-05-05 16:53:27","Entry Invoice [Invoice No: 21510] updated by ALSED ABU SHAMA on 05/05/2019 at 04:53 PM");
INSERT INTO crm_audit_log VALUES("6090","3","4","2019-05-05 17:08:09","Exit Invoice [Invoice No: 119965] updated by Yasir  Rahman on 05/05/2019 at 05:08 PM");
INSERT INTO crm_audit_log VALUES("6091","2","7","2019-05-05 19:43:28","Entry Invoice [Invoice No: 21511] updated by ALSED ABU SHAMA on 05/05/2019 at 07:43 PM");
INSERT INTO crm_audit_log VALUES("6092","3","4","2019-05-05 20:57:27","Exit Invoice [Invoice No: 119966] updated by Yasir  Rahman on 05/05/2019 at 08:57 PM");
INSERT INTO crm_audit_log VALUES("6093","3","4","2019-05-05 20:59:31","Exit Invoice [Invoice No: 119967] updated by Yasir  Rahman on 05/05/2019 at 08:59 PM");
INSERT INTO crm_audit_log VALUES("6094","2","4","2019-05-05 21:07:35","Entry Invoice [Invoice No: 21512] updated by Yasir  Rahman on 05/05/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("6095","3","4","2019-05-05 21:43:07","Exit Invoice [Invoice No: 119968] updated by Yasir  Rahman on 05/05/2019 at 09:43 PM");
INSERT INTO crm_audit_log VALUES("6096","3","5","2019-05-06 00:45:49","Exit Invoice [Invoice No: 119969] updated by Imran  Khan on 06/05/2019 at 12:45 AM");
INSERT INTO crm_audit_log VALUES("6097","3","5","2019-05-06 00:46:26","Exit Invoice [Invoice No: 119970] updated by Imran  Khan on 06/05/2019 at 12:46 AM");
INSERT INTO crm_audit_log VALUES("6098","2","4","2019-05-06 01:09:47","Entry Invoice [Invoice No: 21513] updated by Yasir  Rahman on 06/05/2019 at 01:09 AM");
INSERT INTO crm_audit_log VALUES("6099","2","4","2019-05-06 01:35:17","Entry Invoice [Invoice No: 21514] updated by Yasir  Rahman on 06/05/2019 at 01:35 AM");
INSERT INTO crm_audit_log VALUES("6100","3","5","2019-05-06 04:33:24","Exit Invoice [Invoice No: 119971] updated by Imran  Khan on 06/05/2019 at 04:33 AM");
INSERT INTO crm_audit_log VALUES("6101","2","4","2019-05-06 07:31:07","Entry Invoice [Invoice No: 21515] updated by Yasir  Rahman on 06/05/2019 at 07:31 AM");
INSERT INTO crm_audit_log VALUES("6102","2","4","2019-05-06 07:33:12","Entry Invoice [Invoice No: 21516] updated by Yasir  Rahman on 06/05/2019 at 07:33 AM");
INSERT INTO crm_audit_log VALUES("6103","3","15","2019-05-06 10:44:39","Exit Invoice [Invoice No: 119972] updated by Abdul Rasheed on 06/05/2019 at 10:44 AM");
INSERT INTO crm_audit_log VALUES("6104","3","15","2019-05-06 10:46:11","Exit Invoice [Invoice No: 119973] updated by Abdul Rasheed on 06/05/2019 at 10:46 AM");
INSERT INTO crm_audit_log VALUES("6105","3","15","2019-05-06 10:47:30","Exit Invoice [Invoice No: 119974] updated by Abdul Rasheed on 06/05/2019 at 10:47 AM");
INSERT INTO crm_audit_log VALUES("6106","3","15","2019-05-06 13:47:07","Exit Invoice [Invoice No: 119975] updated by Abdul Rasheed on 06/05/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("6107","3","15","2019-05-06 13:49:05","Exit Invoice [Invoice No: 119976] updated by Abdul Rasheed on 06/05/2019 at 01:49 PM");
INSERT INTO crm_audit_log VALUES("6108","2","7","2019-05-06 14:52:40","Entry Invoice [Invoice No: 21517] updated by ALSED ABU SHAMA on 06/05/2019 at 02:52 PM");
INSERT INTO crm_audit_log VALUES("6109","2","6","2019-05-06 15:02:13","Entry Invoice [Invoice No: 21518] updated by ASHRAF  M K on 06/05/2019 at 03:02 PM");
INSERT INTO crm_audit_log VALUES("6110","2","6","2019-05-06 15:04:09","Entry Invoice [Invoice No: 21519] updated by ASHRAF  M K on 06/05/2019 at 03:04 PM");
INSERT INTO crm_audit_log VALUES("6111","2","6","2019-05-06 15:06:29","Entry Invoice [Invoice No: 21520] updated by ASHRAF  M K on 06/05/2019 at 03:06 PM");
INSERT INTO crm_audit_log VALUES("6112","2","6","2019-05-06 15:08:08","Entry Invoice [Invoice No: 21521] updated by ASHRAF  M K on 06/05/2019 at 03:08 PM");
INSERT INTO crm_audit_log VALUES("6113","2","6","2019-05-06 15:10:06","Entry Invoice [Invoice No: 21522] updated by ASHRAF  M K on 06/05/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("6114","3","15","2019-05-06 15:10:08","Exit Invoice [Invoice No: 119977] updated by Abdul Rasheed on 06/05/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("6115","3","15","2019-05-06 15:12:38","Exit Invoice [Invoice No: 119978] updated by Abdul Rasheed on 06/05/2019 at 03:12 PM");
INSERT INTO crm_audit_log VALUES("6116","3","15","2019-05-06 15:21:45","Exit Invoice [Invoice No: 119979] updated by Abdul Rasheed on 06/05/2019 at 03:21 PM");
INSERT INTO crm_audit_log VALUES("6117","2","7","2019-05-06 15:46:53","Entry Invoice [Invoice No: 21523] updated by ALSED ABU SHAMA on 06/05/2019 at 03:46 PM");
INSERT INTO crm_audit_log VALUES("6118","2","6","2019-05-06 15:48:33","Entry Invoice [Invoice No: 21523] updated by ASHRAF  M K on 06/05/2019 at 03:48 PM");
INSERT INTO crm_audit_log VALUES("6119","2","7","2019-05-06 15:48:36","Entry Invoice [Invoice No: 21524] updated by ALSED ABU SHAMA on 06/05/2019 at 03:48 PM");
INSERT INTO crm_audit_log VALUES("6120","2","7","2019-05-06 15:49:47","Entry Invoice [Invoice No: 21525] updated by ALSED ABU SHAMA on 06/05/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("6121","2","7","2019-05-06 15:50:32","Entry Invoice [Invoice No: 21526] updated by ALSED ABU SHAMA on 06/05/2019 at 03:50 PM");
INSERT INTO crm_audit_log VALUES("6122","2","7","2019-05-06 15:51:24","Entry Invoice [Invoice No: 21527] updated by ALSED ABU SHAMA on 06/05/2019 at 03:51 PM");
INSERT INTO crm_audit_log VALUES("6123","2","7","2019-05-06 15:52:28","Entry Invoice [Invoice No: 21528] updated by ALSED ABU SHAMA on 06/05/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("6124","2","6","2019-05-06 15:56:37","Entry Invoice [Invoice No: 21527] updated by ASHRAF  M K on 06/05/2019 at 03:56 PM");
INSERT INTO crm_audit_log VALUES("6125","3","4","2019-05-06 21:09:37","Exit Invoice [Invoice No: 119980] updated by Yasir  Rahman on 06/05/2019 at 09:09 PM");
INSERT INTO crm_audit_log VALUES("6126","3","4","2019-05-06 21:12:12","Exit Invoice [Invoice No: 119981] updated by Yasir  Rahman on 06/05/2019 at 09:12 PM");
INSERT INTO crm_audit_log VALUES("6127","3","5","2019-05-06 22:15:47","Exit Invoice [Invoice No: 119982] updated by Imran  Khan on 06/05/2019 at 10:15 PM");
INSERT INTO crm_audit_log VALUES("6128","3","5","2019-05-06 22:16:28","Exit Invoice [Invoice No: 119983] updated by Imran  Khan on 06/05/2019 at 10:16 PM");
INSERT INTO crm_audit_log VALUES("6129","3","5","2019-05-06 23:10:13","Exit Invoice [Invoice No: 119984] updated by Imran  Khan on 06/05/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("6130","3","5","2019-05-06 23:16:01","Exit Invoice [Invoice No: 119985] updated by Imran  Khan on 06/05/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("6131","2","4","2019-05-06 23:49:26","Entry Invoice [Invoice No: 21529] updated by Yasir  Rahman on 06/05/2019 at 11:49 PM");
INSERT INTO crm_audit_log VALUES("6132","2","4","2019-05-06 23:51:46","Entry Invoice [Invoice No: 21530] updated by Yasir  Rahman on 06/05/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("6133","2","4","2019-05-06 23:56:55","Entry Invoice [Invoice No: 21531] updated by Yasir  Rahman on 06/05/2019 at 11:56 PM");
INSERT INTO crm_audit_log VALUES("6134","2","4","2019-05-06 23:58:00","Entry Invoice [Invoice No: 21532] updated by Yasir  Rahman on 06/05/2019 at 11:58 PM");
INSERT INTO crm_audit_log VALUES("6135","2","4","2019-05-07 00:05:14","Entry Invoice [Invoice No: 21533] updated by Yasir  Rahman on 07/05/2019 at 12:05 AM");
INSERT INTO crm_audit_log VALUES("6136","3","5","2019-05-07 00:08:48","Exit Invoice [Invoice No: 119986] updated by Imran  Khan on 07/05/2019 at 12:08 AM");
INSERT INTO crm_audit_log VALUES("6137","3","5","2019-05-07 00:09:31","Exit Invoice [Invoice No: 119987] updated by Imran  Khan on 07/05/2019 at 12:09 AM");
INSERT INTO crm_audit_log VALUES("6138","3","5","2019-05-07 01:18:53","Exit Invoice [Invoice No: 119988] updated by Imran  Khan on 07/05/2019 at 01:18 AM");
INSERT INTO crm_audit_log VALUES("6139","2","4","2019-05-07 01:25:07","Entry Invoice [Invoice No: 21534] updated by Yasir  Rahman on 07/05/2019 at 01:25 AM");
INSERT INTO crm_audit_log VALUES("6140","3","5","2019-05-07 03:20:33","Exit Invoice [Invoice No: 119989] updated by Imran  Khan on 07/05/2019 at 03:20 AM");
INSERT INTO crm_audit_log VALUES("6141","2","4","2019-05-07 04:26:16","Entry Invoice [Invoice No: 21535] updated by Yasir  Rahman on 07/05/2019 at 04:26 AM");
INSERT INTO crm_audit_log VALUES("6142","3","5","2019-05-07 05:43:14","Exit Invoice [Invoice No: 119990] updated by Imran  Khan on 07/05/2019 at 05:43 AM");
INSERT INTO crm_audit_log VALUES("6143","3","5","2019-05-07 05:44:33","Exit Invoice [Invoice No: 119991] updated by Imran  Khan on 07/05/2019 at 05:44 AM");
INSERT INTO crm_audit_log VALUES("6144","2","7","2019-05-07 09:25:42","Entry Invoice [Invoice No: 21536] updated by ALSED ABU SHAMA on 07/05/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("6145","2","7","2019-05-07 10:32:48","Entry Invoice [Invoice No: 21537] updated by ALSED ABU SHAMA on 07/05/2019 at 10:32 AM");
INSERT INTO crm_audit_log VALUES("6146","2","7","2019-05-07 10:45:37","Entry Invoice [Invoice No: 21538] updated by ALSED ABU SHAMA on 07/05/2019 at 10:45 AM");
INSERT INTO crm_audit_log VALUES("6147","2","15","2019-05-07 13:42:02","Entry Invoice [Invoice No: 21539] updated by Abdul Rasheed on 07/05/2019 at 01:42 PM");
INSERT INTO crm_audit_log VALUES("6148","2","15","2019-05-07 14:25:14","Entry Invoice [Invoice No: 21540] updated by Abdul Rasheed on 07/05/2019 at 02:25 PM");
INSERT INTO crm_audit_log VALUES("6149","3","4","2019-05-07 14:27:06","Exit Invoice [Invoice No: 119992] updated by Yasir  Rahman on 07/05/2019 at 02:27 PM");
INSERT INTO crm_audit_log VALUES("6150","3","4","2019-05-07 14:31:29","Exit Invoice [Invoice No: 119993] updated by Yasir  Rahman on 07/05/2019 at 02:31 PM");
INSERT INTO crm_audit_log VALUES("6151","2","15","2019-05-07 15:28:29","Entry Invoice [Invoice No: 21541] updated by Abdul Rasheed on 07/05/2019 at 03:28 PM");
INSERT INTO crm_audit_log VALUES("6152","3","4","2019-05-07 15:48:39","Exit Invoice [Invoice No: 119994] updated by Yasir  Rahman on 07/05/2019 at 03:48 PM");
INSERT INTO crm_audit_log VALUES("6153","3","4","2019-05-07 15:52:03","Exit Invoice [Invoice No: 119995] updated by Yasir  Rahman on 07/05/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("6154","2","15","2019-05-07 15:52:41","Entry Invoice [Invoice No: 21542] updated by Abdul Rasheed on 07/05/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("6155","3","4","2019-05-07 15:52:53","Exit Invoice [Invoice No: 119996] updated by Yasir  Rahman on 07/05/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("6156","3","4","2019-05-07 15:53:39","Exit Invoice [Invoice No: 119997] updated by Yasir  Rahman on 07/05/2019 at 03:53 PM");
INSERT INTO crm_audit_log VALUES("6157","2","15","2019-05-07 15:58:15","Entry Invoice [Invoice No: 21543] updated by Abdul Rasheed on 07/05/2019 at 03:58 PM");
INSERT INTO crm_audit_log VALUES("6158","3","4","2019-05-07 17:19:51","Exit Invoice [Invoice No: 119998] updated by Yasir  Rahman on 07/05/2019 at 05:19 PM");
INSERT INTO crm_audit_log VALUES("6159","3","5","2019-05-07 21:30:25","Exit Invoice [Invoice No: 119999] updated by Imran  Khan on 07/05/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("6160","3","5","2019-05-07 22:26:06","Exit Invoice [Invoice No: 120000] updated by Imran  Khan on 07/05/2019 at 10:26 PM");
INSERT INTO crm_audit_log VALUES("6161","3","5","2019-05-08 00:01:02","Exit Invoice [Invoice No: 120001] updated by Imran  Khan on 08/05/2019 at 12:01 AM");
INSERT INTO crm_audit_log VALUES("6162","3","5","2019-05-08 00:29:06","Exit Invoice [Invoice No: 120002] updated by Imran  Khan on 08/05/2019 at 12:29 AM");
INSERT INTO crm_audit_log VALUES("6163","3","5","2019-05-08 00:29:42","Exit Invoice [Invoice No: 120003] updated by Imran  Khan on 08/05/2019 at 12:29 AM");
INSERT INTO crm_audit_log VALUES("6164","2","4","2019-05-08 01:29:40","Entry Invoice [Invoice No: 21544] updated by Yasir  Rahman on 08/05/2019 at 01:29 AM");
INSERT INTO crm_audit_log VALUES("6165","2","4","2019-05-08 01:42:17","Entry Invoice [Invoice No: 21545] updated by Yasir  Rahman on 08/05/2019 at 01:42 AM");
INSERT INTO crm_audit_log VALUES("6166","2","4","2019-05-08 01:44:31","Entry Invoice [Invoice No: 21546] updated by Yasir  Rahman on 08/05/2019 at 01:44 AM");
INSERT INTO crm_audit_log VALUES("6167","2","4","2019-05-08 01:53:19","Entry Invoice [Invoice No: 21547] updated by Yasir  Rahman on 08/05/2019 at 01:53 AM");
INSERT INTO crm_audit_log VALUES("6168","2","4","2019-05-08 01:54:54","Entry Invoice [Invoice No: 21548] updated by Yasir  Rahman on 08/05/2019 at 01:54 AM");
INSERT INTO crm_audit_log VALUES("6169","2","4","2019-05-08 01:56:24","Entry Invoice [Invoice No: 21549] updated by Yasir  Rahman on 08/05/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("6170","2","4","2019-05-08 01:57:42","Entry Invoice [Invoice No: 21550] updated by Yasir  Rahman on 08/05/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("6171","3","5","2019-05-08 02:13:25","Exit Invoice [Invoice No: 120004] updated by Imran  Khan on 08/05/2019 at 02:13 AM");
INSERT INTO crm_audit_log VALUES("6172","3","4","2019-05-08 07:18:34","Exit Invoice [Invoice No: 120005] updated by Yasir  Rahman on 08/05/2019 at 07:18 AM");
INSERT INTO crm_audit_log VALUES("6173","3","4","2019-05-08 07:20:19","Exit Invoice [Invoice No: 120006] updated by Yasir  Rahman on 08/05/2019 at 07:20 AM");
INSERT INTO crm_audit_log VALUES("6174","3","4","2019-05-08 07:21:33","Exit Invoice [Invoice No: 120007] updated by Yasir  Rahman on 08/05/2019 at 07:21 AM");
INSERT INTO crm_audit_log VALUES("6175","2","4","2019-05-08 07:25:57","Entry Invoice [Invoice No: 21551] updated by Yasir  Rahman on 08/05/2019 at 07:25 AM");
INSERT INTO crm_audit_log VALUES("6176","2","4","2019-05-08 07:30:03","Entry Invoice [Invoice No: 21552] updated by Yasir  Rahman on 08/05/2019 at 07:30 AM");
INSERT INTO crm_audit_log VALUES("6177","2","4","2019-05-08 07:32:06","Entry Invoice [Invoice No: 21553] updated by Yasir  Rahman on 08/05/2019 at 07:32 AM");
INSERT INTO crm_audit_log VALUES("6178","2","4","2019-05-08 07:34:05","Entry Invoice [Invoice No: 21554] updated by Yasir  Rahman on 08/05/2019 at 07:34 AM");
INSERT INTO crm_audit_log VALUES("6179","2","4","2019-05-08 07:35:30","Entry Invoice [Invoice No: 21555] updated by Yasir  Rahman on 08/05/2019 at 07:35 AM");
INSERT INTO crm_audit_log VALUES("6180","2","4","2019-05-08 07:40:39","Entry Invoice [Invoice No: 21556] updated by Yasir  Rahman on 08/05/2019 at 07:40 AM");
INSERT INTO crm_audit_log VALUES("6181","2","4","2019-05-08 07:43:44","Entry Invoice [Invoice No: 21557] updated by Yasir  Rahman on 08/05/2019 at 07:43 AM");
INSERT INTO crm_audit_log VALUES("6182","3","15","2019-05-08 11:13:07","Exit Invoice [Invoice No: 120008] updated by Abdul Rasheed on 08/05/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("6183","3","15","2019-05-08 11:36:42","Exit Invoice [Invoice No: 120009] updated by Abdul Rasheed on 08/05/2019 at 11:36 AM");
INSERT INTO crm_audit_log VALUES("6184","2","7","2019-05-08 13:25:05","Entry Invoice [Invoice No: 21558] updated by ALSED ABU SHAMA on 08/05/2019 at 01:25 PM");
INSERT INTO crm_audit_log VALUES("6185","2","7","2019-05-08 13:26:09","Entry Invoice [Invoice No: 21559] updated by ALSED ABU SHAMA on 08/05/2019 at 01:26 PM");
INSERT INTO crm_audit_log VALUES("6186","2","7","2019-05-08 13:26:56","Entry Invoice [Invoice No: 21560] updated by ALSED ABU SHAMA on 08/05/2019 at 01:26 PM");
INSERT INTO crm_audit_log VALUES("6187","3","15","2019-05-08 13:50:51","Exit Invoice [Invoice No: 120010] updated by Abdul Rasheed on 08/05/2019 at 01:50 PM");
INSERT INTO crm_audit_log VALUES("6188","3","15","2019-05-08 13:53:13","Exit Invoice [Invoice No: 120011] updated by Abdul Rasheed on 08/05/2019 at 01:53 PM");
INSERT INTO crm_audit_log VALUES("6189","2","7","2019-05-08 15:46:37","Entry Invoice [Invoice No: 21561] updated by ALSED ABU SHAMA on 08/05/2019 at 03:46 PM");
INSERT INTO crm_audit_log VALUES("6190","3","4","2019-05-08 16:33:52","Exit Invoice [Invoice No: 120012] updated by Yasir  Rahman on 08/05/2019 at 04:33 PM");
INSERT INTO crm_audit_log VALUES("6191","3","4","2019-05-08 16:52:07","Exit Invoice [Invoice No: 120013] updated by Yasir  Rahman on 08/05/2019 at 04:52 PM");
INSERT INTO crm_audit_log VALUES("6192","3","4","2019-05-08 17:24:38","Exit Invoice [Invoice No: 120014] updated by Yasir  Rahman on 08/05/2019 at 05:24 PM");
INSERT INTO crm_audit_log VALUES("6193","2","7","2019-05-08 18:22:11","Entry Invoice [Invoice No: 21562] updated by ALSED ABU SHAMA on 08/05/2019 at 06:22 PM");
INSERT INTO crm_audit_log VALUES("6194","3","5","2019-05-08 21:32:51","Exit Invoice [Invoice No: 120015] updated by Imran  Khan on 08/05/2019 at 09:32 PM");
INSERT INTO crm_audit_log VALUES("6195","3","5","2019-05-08 21:33:43","Exit Invoice [Invoice No: 120016] updated by Imran  Khan on 08/05/2019 at 09:33 PM");
INSERT INTO crm_audit_log VALUES("6196","3","5","2019-05-08 21:34:24","Exit Invoice [Invoice No: 120017] updated by Imran  Khan on 08/05/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("6197","2","4","2019-05-08 21:46:57","Entry Invoice [Invoice No: 21563] updated by Yasir  Rahman on 08/05/2019 at 09:46 PM");
INSERT INTO crm_audit_log VALUES("6198","2","4","2019-05-08 22:38:19","Entry Invoice [Invoice No: 21564] updated by Yasir  Rahman on 08/05/2019 at 10:38 PM");
INSERT INTO crm_audit_log VALUES("6199","2","4","2019-05-09 00:22:29","Entry Invoice [Invoice No: 21565] updated by Yasir  Rahman on 09/05/2019 at 12:22 AM");
INSERT INTO crm_audit_log VALUES("6200","3","5","2019-05-09 01:24:16","Exit Invoice [Invoice No: 120018] updated by Imran  Khan on 09/05/2019 at 01:24 AM");
INSERT INTO crm_audit_log VALUES("6201","3","5","2019-05-09 02:18:41","Exit Invoice [Invoice No: 120019] updated by Imran  Khan on 09/05/2019 at 02:18 AM");
INSERT INTO crm_audit_log VALUES("6202","3","5","2019-05-09 02:20:32","Exit Invoice [Invoice No: 120020] updated by Imran  Khan on 09/05/2019 at 02:20 AM");
INSERT INTO crm_audit_log VALUES("6203","3","5","2019-05-09 02:22:33","Exit Invoice [Invoice No: 120021] updated by Imran  Khan on 09/05/2019 at 02:22 AM");
INSERT INTO crm_audit_log VALUES("6204","3","5","2019-05-09 02:23:05","Exit Invoice [Invoice No: 120022] updated by Imran  Khan on 09/05/2019 at 02:23 AM");
INSERT INTO crm_audit_log VALUES("6205","3","5","2019-05-09 02:23:53","Exit Invoice [Invoice No: 120023] updated by Imran  Khan on 09/05/2019 at 02:23 AM");
INSERT INTO crm_audit_log VALUES("6206","3","5","2019-05-09 02:27:52","Exit Invoice [Invoice No: 120024] updated by Imran  Khan on 09/05/2019 at 02:27 AM");
INSERT INTO crm_audit_log VALUES("6207","3","5","2019-05-09 02:56:12","Exit Invoice [Invoice No: 120025] updated by Imran  Khan on 09/05/2019 at 02:56 AM");
INSERT INTO crm_audit_log VALUES("6208","3","5","2019-05-09 02:57:40","Exit Invoice [Invoice No: 120026] updated by Imran  Khan on 09/05/2019 at 02:57 AM");
INSERT INTO crm_audit_log VALUES("6209","3","4","2019-05-09 06:28:06","Exit Invoice [Invoice No: 120027] updated by Yasir  Rahman on 09/05/2019 at 06:28 AM");
INSERT INTO crm_audit_log VALUES("6210","3","4","2019-05-09 06:44:42","Exit Invoice [Invoice No: 120028] updated by Yasir  Rahman on 09/05/2019 at 06:44 AM");
INSERT INTO crm_audit_log VALUES("6211","2","4","2019-05-09 07:54:18","Entry Invoice [Invoice No: 21566] updated by Yasir  Rahman on 09/05/2019 at 07:54 AM");
INSERT INTO crm_audit_log VALUES("6212","3","15","2019-05-09 11:39:31","Exit Invoice [Invoice No: 120029] updated by Abdul Rasheed on 09/05/2019 at 11:39 AM");
INSERT INTO crm_audit_log VALUES("6213","2","7","2019-05-09 12:05:37","Entry Invoice [Invoice No: 21567] updated by ALSED ABU SHAMA on 09/05/2019 at 12:05 PM");
INSERT INTO crm_audit_log VALUES("6214","2","7","2019-05-09 12:06:51","Entry Invoice [Invoice No: 21568] updated by ALSED ABU SHAMA on 09/05/2019 at 12:06 PM");
INSERT INTO crm_audit_log VALUES("6215","2","7","2019-05-09 12:07:36","Entry Invoice [Invoice No: 21569] updated by ALSED ABU SHAMA on 09/05/2019 at 12:07 PM");
INSERT INTO crm_audit_log VALUES("6216","2","7","2019-05-09 15:51:47","Entry Invoice [Invoice No: 21570] updated by ALSED ABU SHAMA on 09/05/2019 at 03:51 PM");
INSERT INTO crm_audit_log VALUES("6217","2","7","2019-05-09 16:24:43","Entry Invoice [Invoice No: 21571] updated by ALSED ABU SHAMA on 09/05/2019 at 04:24 PM");
INSERT INTO crm_audit_log VALUES("6218","3","4","2019-05-09 17:28:58","Exit Invoice [Invoice No: 120030] updated by Yasir  Rahman on 09/05/2019 at 05:28 PM");
INSERT INTO crm_audit_log VALUES("6219","3","5","2019-05-09 20:48:16","Exit Invoice [Invoice No: 120031] updated by Imran  Khan on 09/05/2019 at 08:48 PM");
INSERT INTO crm_audit_log VALUES("6220","2","4","2019-05-09 23:37:46","Entry Invoice [Invoice No: 21572] updated by Yasir  Rahman on 09/05/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("6221","3","5","2019-05-09 23:54:48","Exit Invoice [Invoice No: 120032] updated by Imran  Khan on 09/05/2019 at 11:54 PM");
INSERT INTO crm_audit_log VALUES("6222","3","5","2019-05-10 00:00:37","Exit Invoice [Invoice No: 120033] updated by Imran  Khan on 10/05/2019 at 12:00 AM");
INSERT INTO crm_audit_log VALUES("6223","2","4","2019-05-10 01:38:35","Entry Invoice [Invoice No: 21573] updated by Yasir  Rahman on 10/05/2019 at 01:38 AM");
INSERT INTO crm_audit_log VALUES("6224","3","5","2019-05-10 02:22:18","Exit Invoice [Invoice No: 120034] updated by Imran  Khan on 10/05/2019 at 02:22 AM");
INSERT INTO crm_audit_log VALUES("6225","3","5","2019-05-10 02:23:16","Exit Invoice [Invoice No: 120035] updated by Imran  Khan on 10/05/2019 at 02:23 AM");
INSERT INTO crm_audit_log VALUES("6226","3","5","2019-05-10 02:33:27","Exit Invoice [Invoice No: 120036] updated by Imran  Khan on 10/05/2019 at 02:33 AM");
INSERT INTO crm_audit_log VALUES("6227","3","5","2019-05-10 02:34:03","Exit Invoice [Invoice No: 120037] updated by Imran  Khan on 10/05/2019 at 02:34 AM");
INSERT INTO crm_audit_log VALUES("6228","3","5","2019-05-10 02:38:04","Exit Invoice [Invoice No: 120038] updated by Imran  Khan on 10/05/2019 at 02:38 AM");
INSERT INTO crm_audit_log VALUES("6229","3","4","2019-05-10 07:32:04","Exit Invoice [Invoice No: 120039] updated by Yasir  Rahman on 10/05/2019 at 07:32 AM");
INSERT INTO crm_audit_log VALUES("6230","3","4","2019-05-10 07:33:28","Exit Invoice [Invoice No: 120040] updated by Yasir  Rahman on 10/05/2019 at 07:33 AM");
INSERT INTO crm_audit_log VALUES("6231","2","7","2019-05-10 11:25:20","Entry Invoice [Invoice No: 21574] updated by ALSED ABU SHAMA on 10/05/2019 at 11:25 AM");
INSERT INTO crm_audit_log VALUES("6232","2","7","2019-05-10 12:19:16","Entry Invoice [Invoice No: 21575] updated by ALSED ABU SHAMA on 10/05/2019 at 12:19 PM");
INSERT INTO crm_audit_log VALUES("6233","3","15","2019-05-10 14:37:18","Exit Invoice [Invoice No: 120041] updated by Abdul Rasheed on 10/05/2019 at 02:37 PM");
INSERT INTO crm_audit_log VALUES("6234","2","7","2019-05-10 14:37:26","Entry Invoice [Invoice No: 21576] updated by ALSED ABU SHAMA on 10/05/2019 at 02:37 PM");
INSERT INTO crm_audit_log VALUES("6235","2","7","2019-05-10 14:39:22","Entry Invoice [Invoice No: 21577] updated by ALSED ABU SHAMA on 10/05/2019 at 02:39 PM");
INSERT INTO crm_audit_log VALUES("6236","2","7","2019-05-10 14:41:28","Entry Invoice [Invoice No: 21578] updated by ALSED ABU SHAMA on 10/05/2019 at 02:41 PM");
INSERT INTO crm_audit_log VALUES("6237","2","6","2019-05-10 14:41:44","Entry Invoice [Invoice No: 21577] updated by ASHRAF  M K on 10/05/2019 at 02:41 PM");
INSERT INTO crm_audit_log VALUES("6238","2","7","2019-05-10 14:45:09","Entry Invoice [Invoice No: 21579] updated by ALSED ABU SHAMA on 10/05/2019 at 02:45 PM");
INSERT INTO crm_audit_log VALUES("6239","3","15","2019-05-10 15:06:03","Exit Invoice [Invoice No: 120042] updated by Abdul Rasheed on 10/05/2019 at 03:06 PM");
INSERT INTO crm_audit_log VALUES("6240","3","4","2019-05-10 16:06:28","Exit Invoice [Invoice No: 120043] updated by Yasir  Rahman on 10/05/2019 at 04:06 PM");
INSERT INTO crm_audit_log VALUES("6241","2","7","2019-05-10 17:59:40","Entry Invoice [Invoice No: 21580] updated by ALSED ABU SHAMA on 10/05/2019 at 05:59 PM");
INSERT INTO crm_audit_log VALUES("6242","3","4","2019-05-10 18:57:42","Exit Invoice [Invoice No: 120044] updated by Yasir  Rahman on 10/05/2019 at 06:57 PM");
INSERT INTO crm_audit_log VALUES("6243","3","4","2019-05-10 18:59:13","Exit Invoice [Invoice No: 120045] updated by Yasir  Rahman on 10/05/2019 at 06:59 PM");
INSERT INTO crm_audit_log VALUES("6244","3","4","2019-05-10 20:10:11","Exit Invoice [Invoice No: 120046] updated by Yasir  Rahman on 10/05/2019 at 08:10 PM");
INSERT INTO crm_audit_log VALUES("6245","3","5","2019-05-10 21:30:22","Exit Invoice [Invoice No: 120047] updated by Imran  Khan on 10/05/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("6246","2","4","2019-05-10 22:02:34","Entry Invoice [Invoice No: 21581] updated by Yasir  Rahman on 10/05/2019 at 10:02 PM");
INSERT INTO crm_audit_log VALUES("6247","3","5","2019-05-10 22:11:30","Exit Invoice [Invoice No: 120048] updated by Imran  Khan on 10/05/2019 at 10:11 PM");
INSERT INTO crm_audit_log VALUES("6248","3","5","2019-05-10 22:12:07","Exit Invoice [Invoice No: 120049] updated by Imran  Khan on 10/05/2019 at 10:12 PM");
INSERT INTO crm_audit_log VALUES("6249","2","4","2019-05-10 22:16:45","Entry Invoice [Invoice No: 21582] updated by Yasir  Rahman on 10/05/2019 at 10:16 PM");
INSERT INTO crm_audit_log VALUES("6250","3","5","2019-05-10 22:55:16","Exit Invoice [Invoice No: 120050] updated by Imran  Khan on 10/05/2019 at 10:55 PM");
INSERT INTO crm_audit_log VALUES("6251","3","5","2019-05-10 23:16:10","Exit Invoice [Invoice No: 120051] updated by Imran  Khan on 10/05/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("6252","3","5","2019-05-11 01:16:26","Exit Invoice [Invoice No: 120052] updated by Imran  Khan on 11/05/2019 at 01:16 AM");
INSERT INTO crm_audit_log VALUES("6253","3","5","2019-05-11 01:17:05","Exit Invoice [Invoice No: 120053] updated by Imran  Khan on 11/05/2019 at 01:17 AM");
INSERT INTO crm_audit_log VALUES("6254","2","4","2019-05-11 01:18:07","Entry Invoice [Invoice No: 21583] updated by Yasir  Rahman on 11/05/2019 at 01:18 AM");
INSERT INTO crm_audit_log VALUES("6255","3","5","2019-05-11 01:26:58","Exit Invoice [Invoice No: 120054] updated by Imran  Khan on 11/05/2019 at 01:26 AM");
INSERT INTO crm_audit_log VALUES("6256","2","4","2019-05-11 01:32:46","Entry Invoice [Invoice No: 21584] updated by Yasir  Rahman on 11/05/2019 at 01:32 AM");
INSERT INTO crm_audit_log VALUES("6257","3","5","2019-05-11 01:57:46","Exit Invoice [Invoice No: 120055] updated by Imran  Khan on 11/05/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("6258","3","5","2019-05-11 04:10:12","Exit Invoice [Invoice No: 120056] updated by Imran  Khan on 11/05/2019 at 04:10 AM");
INSERT INTO crm_audit_log VALUES("6259","3","5","2019-05-11 04:10:50","Exit Invoice [Invoice No: 120057] updated by Imran  Khan on 11/05/2019 at 04:10 AM");
INSERT INTO crm_audit_log VALUES("6260","3","5","2019-05-11 04:39:12","Exit Invoice [Invoice No: 120058] updated by Imran  Khan on 11/05/2019 at 04:39 AM");
INSERT INTO crm_audit_log VALUES("6261","2","4","2019-05-11 06:25:12","Entry Invoice [Invoice No: 21585] updated by Yasir  Rahman on 11/05/2019 at 06:25 AM");
INSERT INTO crm_audit_log VALUES("6262","3","4","2019-05-11 06:34:39","Exit Invoice [Invoice No: 120059] updated by Yasir  Rahman on 11/05/2019 at 06:34 AM");
INSERT INTO crm_audit_log VALUES("6263","3","4","2019-05-11 06:35:33","Exit Invoice [Invoice No: 120060] updated by Yasir  Rahman on 11/05/2019 at 06:35 AM");
INSERT INTO crm_audit_log VALUES("6264","3","15","2019-05-11 08:54:20","Exit Invoice [Invoice No: 120061] updated by Abdul Rasheed on 11/05/2019 at 08:54 AM");
INSERT INTO crm_audit_log VALUES("6265","3","15","2019-05-11 09:02:41","Exit Invoice [Invoice No: 120062] updated by Abdul Rasheed on 11/05/2019 at 09:02 AM");
INSERT INTO crm_audit_log VALUES("6266","3","15","2019-05-11 09:15:09","Exit Invoice [Invoice No: 120063] updated by Abdul Rasheed on 11/05/2019 at 09:15 AM");
INSERT INTO crm_audit_log VALUES("6267","3","15","2019-05-11 10:23:40","Exit Invoice [Invoice No: 120064] updated by Abdul Rasheed on 11/05/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("6268","2","6","2019-05-11 11:41:52","Entry Invoice [Invoice No: 21586] updated by ASHRAF  M K on 11/05/2019 at 11:41 AM");
INSERT INTO crm_audit_log VALUES("6269","2","7","2019-05-11 13:17:57","Entry Invoice [Invoice No: 21587] updated by ALSED ABU SHAMA on 11/05/2019 at 01:17 PM");
INSERT INTO crm_audit_log VALUES("6270","2","7","2019-05-11 13:30:55","Entry Invoice [Invoice No: 21588] updated by ALSED ABU SHAMA on 11/05/2019 at 01:30 PM");
INSERT INTO crm_audit_log VALUES("6271","2","7","2019-05-11 13:34:11","Entry Invoice [Invoice No: 21589] updated by ALSED ABU SHAMA on 11/05/2019 at 01:34 PM");
INSERT INTO crm_audit_log VALUES("6272","2","7","2019-05-11 13:42:43","Entry Invoice [Invoice No: 21590] updated by ALSED ABU SHAMA on 11/05/2019 at 01:42 PM");
INSERT INTO crm_audit_log VALUES("6273","2","7","2019-05-11 13:43:32","Entry Invoice [Invoice No: 21591] updated by ALSED ABU SHAMA on 11/05/2019 at 01:43 PM");
INSERT INTO crm_audit_log VALUES("6274","2","7","2019-05-11 13:44:18","Entry Invoice [Invoice No: 21592] updated by ALSED ABU SHAMA on 11/05/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("6275","3","15","2019-05-11 13:52:59","Exit Invoice [Invoice No: 120065] updated by Abdul Rasheed on 11/05/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("6276","2","7","2019-05-11 14:20:02","Entry Invoice [Invoice No: 21593] updated by ALSED ABU SHAMA on 11/05/2019 at 02:20 PM");
INSERT INTO crm_audit_log VALUES("6277","3","15","2019-05-11 15:12:34","Exit Invoice [Invoice No: 120066] updated by Abdul Rasheed on 11/05/2019 at 03:12 PM");
INSERT INTO crm_audit_log VALUES("6278","3","15","2019-05-11 15:44:52","Exit Invoice [Invoice No: 120067] updated by Abdul Rasheed on 11/05/2019 at 03:44 PM");
INSERT INTO crm_audit_log VALUES("6279","3","15","2019-05-11 15:52:20","Exit Invoice [Invoice No: 120068] updated by Abdul Rasheed on 11/05/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("6280","2","7","2019-05-11 16:35:30","Entry Invoice [Invoice No: 21594] updated by ALSED ABU SHAMA on 11/05/2019 at 04:35 PM");
INSERT INTO crm_audit_log VALUES("6281","3","5","2019-05-11 21:27:50","Exit Invoice [Invoice No: 120069] updated by Imran  Khan on 11/05/2019 at 09:27 PM");
INSERT INTO crm_audit_log VALUES("6282","2","4","2019-05-11 23:45:46","Entry Invoice [Invoice No: 21595] updated by Yasir  Rahman on 11/05/2019 at 11:45 PM");
INSERT INTO crm_audit_log VALUES("6283","2","4","2019-05-11 23:47:26","Entry Invoice [Invoice No: 21596] updated by Yasir  Rahman on 11/05/2019 at 11:47 PM");
INSERT INTO crm_audit_log VALUES("6284","2","4","2019-05-11 23:48:43","Entry Invoice [Invoice No: 21597] updated by Yasir  Rahman on 11/05/2019 at 11:48 PM");
INSERT INTO crm_audit_log VALUES("6285","3","5","2019-05-11 23:55:46","Exit Invoice [Invoice No: 120070] updated by Imran  Khan on 11/05/2019 at 11:55 PM");
INSERT INTO crm_audit_log VALUES("6286","3","5","2019-05-12 00:34:44","Exit Invoice [Invoice No: 120071] updated by Imran  Khan on 12/05/2019 at 12:34 AM");
INSERT INTO crm_audit_log VALUES("6287","3","5","2019-05-12 01:21:13","Exit Invoice [Invoice No: 120072] updated by Imran  Khan on 12/05/2019 at 01:21 AM");
INSERT INTO crm_audit_log VALUES("6288","2","4","2019-05-12 01:39:39","Entry Invoice [Invoice No: 21598] updated by Yasir  Rahman on 12/05/2019 at 01:39 AM");
INSERT INTO crm_audit_log VALUES("6289","1","4","2019-05-12 04:39:56","Customer [Customer No: 122] updated by Yasir  Rahman on 12/05/2019 at 04:39 AM");
INSERT INTO crm_audit_log VALUES("6290","2","4","2019-05-12 04:41:02","Entry Invoice [Invoice No: 21599] updated by Yasir  Rahman on 12/05/2019 at 04:41 AM");
INSERT INTO crm_audit_log VALUES("6291","3","4","2019-05-12 07:10:07","Exit Invoice [Invoice No: 120073] updated by Yasir  Rahman on 12/05/2019 at 07:10 AM");
INSERT INTO crm_audit_log VALUES("6292","3","15","2019-05-12 09:07:34","Exit Invoice [Invoice No: 120074] updated by Abdul Rasheed on 12/05/2019 at 09:07 AM");
INSERT INTO crm_audit_log VALUES("6293","2","6","2019-05-12 09:11:54","Entry Invoice [Invoice No: 21595] updated by ASHRAF  M K on 12/05/2019 at 09:11 AM");
INSERT INTO crm_audit_log VALUES("6294","3","15","2019-05-12 11:15:29","Exit Invoice [Invoice No: 120075] updated by Abdul Rasheed on 12/05/2019 at 11:15 AM");
INSERT INTO crm_audit_log VALUES("6295","3","15","2019-05-12 11:17:02","Exit Invoice [Invoice No: 120076] updated by Abdul Rasheed on 12/05/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("6296","3","15","2019-05-12 11:45:25","Exit Invoice [Invoice No: 120077] updated by Abdul Rasheed on 12/05/2019 at 11:45 AM");
INSERT INTO crm_audit_log VALUES("6297","2","7","2019-05-12 13:19:48","Entry Invoice [Invoice No: 21600] updated by ALSED ABU SHAMA on 12/05/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("6298","2","7","2019-05-12 13:24:28","Entry Invoice [Invoice No: 21601] updated by ALSED ABU SHAMA on 12/05/2019 at 01:24 PM");
INSERT INTO crm_audit_log VALUES("6299","2","7","2019-05-12 13:28:29","Entry Invoice [Invoice No: 21602] updated by ALSED ABU SHAMA on 12/05/2019 at 01:28 PM");
INSERT INTO crm_audit_log VALUES("6300","2","7","2019-05-12 13:32:07","Entry Invoice [Invoice No: 21603] updated by ALSED ABU SHAMA on 12/05/2019 at 01:32 PM");
INSERT INTO crm_audit_log VALUES("6301","2","7","2019-05-12 14:37:05","Entry Invoice [Invoice No: 21604] updated by ALSED ABU SHAMA on 12/05/2019 at 02:37 PM");
INSERT INTO crm_audit_log VALUES("6302","2","7","2019-05-12 14:40:49","Entry Invoice [Invoice No: 21605] updated by ALSED ABU SHAMA on 12/05/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("6303","3","15","2019-05-12 14:41:25","Exit Invoice [Invoice No: 120078] updated by Abdul Rasheed on 12/05/2019 at 02:41 PM");
INSERT INTO crm_audit_log VALUES("6304","2","7","2019-05-12 14:44:57","Entry Invoice [Invoice No: 21606] updated by ALSED ABU SHAMA on 12/05/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("6305","3","15","2019-05-12 14:48:31","Exit Invoice [Invoice No: 120079] updated by Abdul Rasheed on 12/05/2019 at 02:48 PM");
INSERT INTO crm_audit_log VALUES("6306","2","7","2019-05-12 14:59:02","Entry Invoice [Invoice No: 21607] updated by ALSED ABU SHAMA on 12/05/2019 at 02:59 PM");
INSERT INTO crm_audit_log VALUES("6307","2","7","2019-05-12 16:06:30","Entry Invoice [Invoice No: 21608] updated by ALSED ABU SHAMA on 12/05/2019 at 04:06 PM");
INSERT INTO crm_audit_log VALUES("6308","3","5","2019-05-12 21:37:33","Exit Invoice [Invoice No: 120080] updated by Imran  Khan on 12/05/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("6309","2","4","2019-05-12 21:48:20","Entry Invoice [Invoice No: 21609] updated by Yasir  Rahman on 12/05/2019 at 09:48 PM");
INSERT INTO crm_audit_log VALUES("6310","2","4","2019-05-12 21:53:49","Entry Invoice [Invoice No: 21610] updated by Yasir  Rahman on 12/05/2019 at 09:53 PM");
INSERT INTO crm_audit_log VALUES("6311","3","5","2019-05-12 22:29:02","Exit Invoice [Invoice No: 120081] updated by Imran  Khan on 12/05/2019 at 10:29 PM");
INSERT INTO crm_audit_log VALUES("6312","3","5","2019-05-12 22:30:24","Exit Invoice [Invoice No: 120082] updated by Imran  Khan on 12/05/2019 at 10:30 PM");
INSERT INTO crm_audit_log VALUES("6313","3","5","2019-05-12 22:31:10","Exit Invoice [Invoice No: 120083] updated by Imran  Khan on 12/05/2019 at 10:31 PM");
INSERT INTO crm_audit_log VALUES("6314","2","4","2019-05-12 22:44:46","Entry Invoice [Invoice No: 21611] updated by Yasir  Rahman on 12/05/2019 at 10:44 PM");
INSERT INTO crm_audit_log VALUES("6315","3","5","2019-05-12 23:01:15","Exit Invoice [Invoice No: 120084] updated by Imran  Khan on 12/05/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("6316","2","4","2019-05-12 23:53:11","Entry Invoice [Invoice No: 21612] updated by Yasir  Rahman on 12/05/2019 at 11:53 PM");
INSERT INTO crm_audit_log VALUES("6317","3","5","2019-05-13 03:25:18","Exit Invoice [Invoice No: 120085] updated by Imran  Khan on 13/05/2019 at 03:25 AM");
INSERT INTO crm_audit_log VALUES("6318","2","4","2019-05-13 07:55:48","Entry Invoice [Invoice No: 21613] updated by Yasir  Rahman on 13/05/2019 at 07:55 AM");
INSERT INTO crm_audit_log VALUES("6319","2","4","2019-05-13 07:58:19","Entry Invoice [Invoice No: 21614] updated by Yasir  Rahman on 13/05/2019 at 07:58 AM");
INSERT INTO crm_audit_log VALUES("6320","2","4","2019-05-13 07:59:57","Entry Invoice [Invoice No: 21615] updated by Yasir  Rahman on 13/05/2019 at 07:59 AM");
INSERT INTO crm_audit_log VALUES("6321","2","4","2019-05-13 08:02:01","Entry Invoice [Invoice No: 21616] updated by Yasir  Rahman on 13/05/2019 at 08:02 AM");
INSERT INTO crm_audit_log VALUES("6322","2","4","2019-05-13 08:05:37","Entry Invoice [Invoice No: 21617] updated by Yasir  Rahman on 13/05/2019 at 08:05 AM");
INSERT INTO crm_audit_log VALUES("6323","2","4","2019-05-13 08:08:09","Entry Invoice [Invoice No: 21618] updated by Yasir  Rahman on 13/05/2019 at 08:08 AM");
INSERT INTO crm_audit_log VALUES("6324","2","4","2019-05-13 08:09:46","Entry Invoice [Invoice No: 21619] updated by Yasir  Rahman on 13/05/2019 at 08:09 AM");
INSERT INTO crm_audit_log VALUES("6325","3","15","2019-05-13 09:38:35","Exit Invoice [Invoice No: 120086] updated by Abdul Rasheed on 13/05/2019 at 09:38 AM");
INSERT INTO crm_audit_log VALUES("6326","3","15","2019-05-13 09:39:59","Exit Invoice [Invoice No: 120087] updated by Abdul Rasheed on 13/05/2019 at 09:39 AM");
INSERT INTO crm_audit_log VALUES("6327","3","15","2019-05-13 09:48:54","Exit Invoice [Invoice No: 120088] updated by Abdul Rasheed on 13/05/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("6328","2","7","2019-05-13 10:29:39","Entry Invoice [Invoice No: 21620] updated by ALSED ABU SHAMA on 13/05/2019 at 10:29 AM");
INSERT INTO crm_audit_log VALUES("6329","2","7","2019-05-13 13:03:29","Entry Invoice [Invoice No: 21621] updated by ALSED ABU SHAMA on 13/05/2019 at 01:03 PM");
INSERT INTO crm_audit_log VALUES("6330","2","7","2019-05-13 13:05:57","Entry Invoice [Invoice No: 21622] updated by ALSED ABU SHAMA on 13/05/2019 at 01:05 PM");
INSERT INTO crm_audit_log VALUES("6331","2","7","2019-05-13 13:08:50","Entry Invoice [Invoice No: 21623] updated by ALSED ABU SHAMA on 13/05/2019 at 01:08 PM");
INSERT INTO crm_audit_log VALUES("6332","3","15","2019-05-13 13:23:42","Exit Invoice [Invoice No: 120089] updated by Abdul Rasheed on 13/05/2019 at 01:23 PM");
INSERT INTO crm_audit_log VALUES("6333","2","7","2019-05-13 14:54:51","Entry Invoice [Invoice No: 21624] updated by ALSED ABU SHAMA on 13/05/2019 at 02:54 PM");
INSERT INTO crm_audit_log VALUES("6334","2","7","2019-05-13 15:00:58","Entry Invoice [Invoice No: 21625] updated by ALSED ABU SHAMA on 13/05/2019 at 03:00 PM");
INSERT INTO crm_audit_log VALUES("6335","2","7","2019-05-13 15:22:55","Entry Invoice [Invoice No: 21626] updated by ALSED ABU SHAMA on 13/05/2019 at 03:22 PM");
INSERT INTO crm_audit_log VALUES("6336","3","15","2019-05-13 15:50:07","Exit Invoice [Invoice No: 120090] updated by Abdul Rasheed on 13/05/2019 at 03:50 PM");
INSERT INTO crm_audit_log VALUES("6337","3","4","2019-05-13 18:46:10","Exit Invoice [Invoice No: 120091] updated by Yasir  Rahman on 13/05/2019 at 06:46 PM");
INSERT INTO crm_audit_log VALUES("6338","3","4","2019-05-13 21:42:07","Exit Invoice [Invoice No: 120092] updated by Yasir  Rahman on 13/05/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("6339","3","4","2019-05-13 23:42:16","Exit Invoice [Invoice No: 120093] updated by Yasir  Rahman on 13/05/2019 at 11:42 PM");
INSERT INTO crm_audit_log VALUES("6340","2","4","2019-05-14 00:38:58","Entry Invoice [Invoice No: 21627] updated by Yasir  Rahman on 14/05/2019 at 12:38 AM");
INSERT INTO crm_audit_log VALUES("6341","2","4","2019-05-14 01:53:59","Entry Invoice [Invoice No: 21628] updated by Yasir  Rahman on 14/05/2019 at 01:53 AM");
INSERT INTO crm_audit_log VALUES("6342","2","4","2019-05-14 02:46:15","Entry Invoice [Invoice No: 21629] updated by Yasir  Rahman on 14/05/2019 at 02:46 AM");
INSERT INTO crm_audit_log VALUES("6343","2","4","2019-05-14 02:48:28","Entry Invoice [Invoice No: 21630] updated by Yasir  Rahman on 14/05/2019 at 02:48 AM");
INSERT INTO crm_audit_log VALUES("6344","3","4","2019-05-14 05:24:41","Exit Invoice [Invoice No: 120094] updated by Yasir  Rahman on 14/05/2019 at 05:24 AM");
INSERT INTO crm_audit_log VALUES("6345","2","4","2019-05-14 07:43:29","Entry Invoice [Invoice No: 21631] updated by Yasir  Rahman on 14/05/2019 at 07:43 AM");
INSERT INTO crm_audit_log VALUES("6346","2","4","2019-05-14 08:05:43","Entry Invoice [Invoice No: 21632] updated by Yasir  Rahman on 14/05/2019 at 08:05 AM");
INSERT INTO crm_audit_log VALUES("6347","2","4","2019-05-14 09:23:14","Entry Invoice [Invoice No: 21633] updated by Yasir  Rahman on 14/05/2019 at 09:23 AM");
INSERT INTO crm_audit_log VALUES("6348","2","4","2019-05-14 09:24:19","Entry Invoice [Invoice No: 21634] updated by Yasir  Rahman on 14/05/2019 at 09:24 AM");
INSERT INTO crm_audit_log VALUES("6349","2","4","2019-05-14 09:25:11","Entry Invoice [Invoice No: 21635] updated by Yasir  Rahman on 14/05/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("6350","2","4","2019-05-14 09:26:20","Entry Invoice [Invoice No: 21636] updated by Yasir  Rahman on 14/05/2019 at 09:26 AM");
INSERT INTO crm_audit_log VALUES("6351","3","15","2019-05-14 10:39:35","Exit Invoice [Invoice No: 120095] updated by Abdul Rasheed on 14/05/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("6352","3","15","2019-05-14 10:54:56","Exit Invoice [Invoice No: 120096] updated by Abdul Rasheed on 14/05/2019 at 10:54 AM");
INSERT INTO crm_audit_log VALUES("6353","2","7","2019-05-14 10:55:26","Entry Invoice [Invoice No: 21637] updated by ALSED ABU SHAMA on 14/05/2019 at 10:55 AM");
INSERT INTO crm_audit_log VALUES("6354","2","7","2019-05-14 10:56:23","Entry Invoice [Invoice No: 21638] updated by ALSED ABU SHAMA on 14/05/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("6355","2","7","2019-05-14 12:30:08","Entry Invoice [Invoice No: 21639] updated by ALSED ABU SHAMA on 14/05/2019 at 12:30 PM");
INSERT INTO crm_audit_log VALUES("6356","2","7","2019-05-14 13:36:07","Entry Invoice [Invoice No: 21640] updated by ALSED ABU SHAMA on 14/05/2019 at 01:36 PM");
INSERT INTO crm_audit_log VALUES("6357","3","15","2019-05-14 13:44:28","Exit Invoice [Invoice No: 120097] updated by Abdul Rasheed on 14/05/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("6358","3","15","2019-05-14 13:46:18","Exit Invoice [Invoice No: 120098] updated by Abdul Rasheed on 14/05/2019 at 01:46 PM");
INSERT INTO crm_audit_log VALUES("6359","3","4","2019-05-14 16:58:01","Exit Invoice [Invoice No: 120099] updated by Yasir  Rahman on 14/05/2019 at 04:58 PM");
INSERT INTO crm_audit_log VALUES("6360","3","5","2019-05-14 20:35:14","Exit Invoice [Invoice No: 120100] updated by Imran  Khan on 14/05/2019 at 08:35 PM");
INSERT INTO crm_audit_log VALUES("6361","3","5","2019-05-14 20:45:58","Exit Invoice [Invoice No: 120101] updated by Imran  Khan on 14/05/2019 at 08:45 PM");
INSERT INTO crm_audit_log VALUES("6362","3","5","2019-05-14 22:13:03","Exit Invoice [Invoice No: 120102] updated by Imran  Khan on 14/05/2019 at 10:13 PM");
INSERT INTO crm_audit_log VALUES("6363","3","5","2019-05-14 22:13:36","Exit Invoice [Invoice No: 120103] updated by Imran  Khan on 14/05/2019 at 10:13 PM");
INSERT INTO crm_audit_log VALUES("6364","3","5","2019-05-14 22:14:21","Exit Invoice [Invoice No: 120104] updated by Imran  Khan on 14/05/2019 at 10:14 PM");
INSERT INTO crm_audit_log VALUES("6365","3","5","2019-05-14 22:47:51","Exit Invoice [Invoice No: 120105] updated by Imran  Khan on 14/05/2019 at 10:47 PM");
INSERT INTO crm_audit_log VALUES("6366","3","5","2019-05-14 23:33:45","Exit Invoice [Invoice No: 120106] updated by Imran  Khan on 14/05/2019 at 11:33 PM");
INSERT INTO crm_audit_log VALUES("6367","2","4","2019-05-15 01:12:09","Entry Invoice [Invoice No: 21641] updated by Yasir  Rahman on 15/05/2019 at 01:12 AM");
INSERT INTO crm_audit_log VALUES("6368","3","5","2019-05-15 02:42:46","Exit Invoice [Invoice No: 120107] updated by Imran  Khan on 15/05/2019 at 02:42 AM");
INSERT INTO crm_audit_log VALUES("6369","3","5","2019-05-15 02:43:23","Exit Invoice [Invoice No: 120108] updated by Imran  Khan on 15/05/2019 at 02:43 AM");
INSERT INTO crm_audit_log VALUES("6370","3","4","2019-05-15 05:34:33","Exit Invoice [Invoice No: 120109] updated by Yasir  Rahman on 15/05/2019 at 05:34 AM");
INSERT INTO crm_audit_log VALUES("6371","2","4","2019-05-15 08:07:33","Entry Invoice [Invoice No: 21642] updated by Yasir  Rahman on 15/05/2019 at 08:07 AM");
INSERT INTO crm_audit_log VALUES("6372","2","4","2019-05-15 08:08:47","Entry Invoice [Invoice No: 21643] updated by Yasir  Rahman on 15/05/2019 at 08:08 AM");
INSERT INTO crm_audit_log VALUES("6373","2","4","2019-05-15 08:10:12","Entry Invoice [Invoice No: 21644] updated by Yasir  Rahman on 15/05/2019 at 08:10 AM");
INSERT INTO crm_audit_log VALUES("6374","2","4","2019-05-15 08:11:23","Entry Invoice [Invoice No: 21645] updated by Yasir  Rahman on 15/05/2019 at 08:11 AM");
INSERT INTO crm_audit_log VALUES("6375","2","4","2019-05-15 08:12:45","Entry Invoice [Invoice No: 21646] updated by Yasir  Rahman on 15/05/2019 at 08:12 AM");
INSERT INTO crm_audit_log VALUES("6376","2","4","2019-05-15 08:13:44","Entry Invoice [Invoice No: 21647] updated by Yasir  Rahman on 15/05/2019 at 08:13 AM");
INSERT INTO crm_audit_log VALUES("6377","2","4","2019-05-15 08:15:00","Entry Invoice [Invoice No: 21648] updated by Yasir  Rahman on 15/05/2019 at 08:15 AM");
INSERT INTO crm_audit_log VALUES("6378","2","4","2019-05-15 08:17:21","Entry Invoice [Invoice No: 21649] updated by Yasir  Rahman on 15/05/2019 at 08:17 AM");
INSERT INTO crm_audit_log VALUES("6379","2","7","2019-05-15 09:31:14","Entry Invoice [Invoice No: 21650] updated by ALSED ABU SHAMA on 15/05/2019 at 09:31 AM");
INSERT INTO crm_audit_log VALUES("6380","3","15","2019-05-15 10:08:18","Exit Invoice [Invoice No: 120110] updated by Abdul Rasheed on 15/05/2019 at 10:08 AM");
INSERT INTO crm_audit_log VALUES("6381","2","6","2019-05-15 10:08:43","Entry Invoice [Invoice No: 21623] updated by ASHRAF  M K on 15/05/2019 at 10:08 AM");
INSERT INTO crm_audit_log VALUES("6382","3","15","2019-05-15 10:09:31","Exit Invoice [Invoice No: 120111] updated by Abdul Rasheed on 15/05/2019 at 10:09 AM");
INSERT INTO crm_audit_log VALUES("6383","3","15","2019-05-15 10:11:04","Exit Invoice [Invoice No: 120112] updated by Abdul Rasheed on 15/05/2019 at 10:11 AM");
INSERT INTO crm_audit_log VALUES("6384","2","6","2019-05-15 10:16:07","Entry Invoice [Invoice No: 21633] updated by ASHRAF  M K on 15/05/2019 at 10:16 AM");
INSERT INTO crm_audit_log VALUES("6385","2","6","2019-05-15 10:16:51","Entry Invoice [Invoice No: 21634] updated by ASHRAF  M K on 15/05/2019 at 10:16 AM");
INSERT INTO crm_audit_log VALUES("6386","3","15","2019-05-15 11:08:32","Exit Invoice [Invoice No: 120113] updated by Abdul Rasheed on 15/05/2019 at 11:08 AM");
INSERT INTO crm_audit_log VALUES("6387","3","15","2019-05-15 11:11:04","Exit Invoice [Invoice No: 120114] updated by Abdul Rasheed on 15/05/2019 at 11:11 AM");
INSERT INTO crm_audit_log VALUES("6388","2","6","2019-05-15 11:13:43","Entry Invoice [Invoice No: 21592] updated by ASHRAF  M K on 15/05/2019 at 11:13 AM");
INSERT INTO crm_audit_log VALUES("6389","2","6","2019-05-15 11:54:54","Entry Invoice [Invoice No: 21651] updated by ASHRAF  M K on 15/05/2019 at 11:54 AM");
INSERT INTO crm_audit_log VALUES("6390","3","15","2019-05-15 11:59:13","Exit Invoice [Invoice No: 120115] updated by Abdul Rasheed on 15/05/2019 at 11:59 AM");
INSERT INTO crm_audit_log VALUES("6391","3","15","2019-05-15 12:07:40","Exit Invoice [Invoice No: 120116] updated by Abdul Rasheed on 15/05/2019 at 12:07 PM");
INSERT INTO crm_audit_log VALUES("6392","3","15","2019-05-15 12:09:08","Exit Invoice [Invoice No: 120117] updated by Abdul Rasheed on 15/05/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("6393","2","6","2019-05-15 12:32:14","Entry Invoice [Invoice No: 21652] updated by ASHRAF  M K on 15/05/2019 at 12:32 PM");
INSERT INTO crm_audit_log VALUES("6394","3","15","2019-05-15 13:10:08","Exit Invoice [Invoice No: 120118] updated by Abdul Rasheed on 15/05/2019 at 01:10 PM");
INSERT INTO crm_audit_log VALUES("6395","2","7","2019-05-15 14:14:02","Entry Invoice [Invoice No: 21653] updated by ALSED ABU SHAMA on 15/05/2019 at 02:14 PM");
INSERT INTO crm_audit_log VALUES("6396","2","7","2019-05-15 14:16:24","Entry Invoice [Invoice No: 21654] updated by ALSED ABU SHAMA on 15/05/2019 at 02:16 PM");
INSERT INTO crm_audit_log VALUES("6397","2","6","2019-05-15 14:29:01","Entry Invoice [Invoice No: 21655] updated by ASHRAF  M K on 15/05/2019 at 02:29 PM");
INSERT INTO crm_audit_log VALUES("6398","2","7","2019-05-15 14:39:01","Entry Invoice [Invoice No: 21656] updated by ALSED ABU SHAMA on 15/05/2019 at 02:39 PM");
INSERT INTO crm_audit_log VALUES("6399","2","7","2019-05-15 14:40:55","Entry Invoice [Invoice No: 21657] updated by ALSED ABU SHAMA on 15/05/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("6400","2","7","2019-05-15 14:42:44","Entry Invoice [Invoice No: 21658] updated by ALSED ABU SHAMA on 15/05/2019 at 02:42 PM");
INSERT INTO crm_audit_log VALUES("6401","2","7","2019-05-15 14:44:27","Entry Invoice [Invoice No: 21659] updated by ALSED ABU SHAMA on 15/05/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("6402","2","7","2019-05-15 14:46:49","Entry Invoice [Invoice No: 21660] updated by ALSED ABU SHAMA on 15/05/2019 at 02:46 PM");
INSERT INTO crm_audit_log VALUES("6403","2","7","2019-05-15 14:50:43","Entry Invoice [Invoice No: 21661] updated by ALSED ABU SHAMA on 15/05/2019 at 02:50 PM");
INSERT INTO crm_audit_log VALUES("6404","3","15","2019-05-15 15:34:07","Exit Invoice [Invoice No: 120119] updated by Abdul Rasheed on 15/05/2019 at 03:34 PM");
INSERT INTO crm_audit_log VALUES("6405","3","15","2019-05-15 15:35:19","Exit Invoice [Invoice No: 120120] updated by Abdul Rasheed on 15/05/2019 at 03:35 PM");
INSERT INTO crm_audit_log VALUES("6406","3","15","2019-05-15 15:36:25","Exit Invoice [Invoice No: 120121] updated by Abdul Rasheed on 15/05/2019 at 03:36 PM");
INSERT INTO crm_audit_log VALUES("6407","3","15","2019-05-15 15:40:04","Exit Invoice [Invoice No: 120122] updated by Abdul Rasheed on 15/05/2019 at 03:40 PM");
INSERT INTO crm_audit_log VALUES("6408","3","4","2019-05-15 18:06:36","Exit Invoice [Invoice No: 120123] updated by Yasir  Rahman on 15/05/2019 at 06:06 PM");
INSERT INTO crm_audit_log VALUES("6409","3","4","2019-05-15 18:07:41","Exit Invoice [Invoice No: 120124] updated by Yasir  Rahman on 15/05/2019 at 06:07 PM");
INSERT INTO crm_audit_log VALUES("6410","3","5","2019-05-16 00:03:54","Exit Invoice [Invoice No: 120125] updated by Imran  Khan on 16/05/2019 at 12:03 AM");
INSERT INTO crm_audit_log VALUES("6411","2","4","2019-05-16 01:05:34","Entry Invoice [Invoice No: 21662] updated by Yasir  Rahman on 16/05/2019 at 01:05 AM");
INSERT INTO crm_audit_log VALUES("6412","3","5","2019-05-16 01:30:00","Exit Invoice [Invoice No: 120126] updated by Imran  Khan on 16/05/2019 at 01:30 AM");
INSERT INTO crm_audit_log VALUES("6413","3","5","2019-05-16 01:30:36","Exit Invoice [Invoice No: 120127] updated by Imran  Khan on 16/05/2019 at 01:30 AM");
INSERT INTO crm_audit_log VALUES("6414","3","5","2019-05-16 01:31:16","Exit Invoice [Invoice No: 120128] updated by Imran  Khan on 16/05/2019 at 01:31 AM");
INSERT INTO crm_audit_log VALUES("6415","3","5","2019-05-16 01:31:56","Exit Invoice [Invoice No: 120129] updated by Imran  Khan on 16/05/2019 at 01:31 AM");
INSERT INTO crm_audit_log VALUES("6416","3","15","2019-05-16 08:41:38","Exit Invoice [Invoice No: 120130] updated by Abdul Rasheed on 16/05/2019 at 08:41 AM");
INSERT INTO crm_audit_log VALUES("6417","3","15","2019-05-16 09:18:56","Exit Invoice [Invoice No: 120131] updated by Abdul Rasheed on 16/05/2019 at 09:18 AM");
INSERT INTO crm_audit_log VALUES("6418","3","15","2019-05-16 09:20:36","Exit Invoice [Invoice No: 120132] updated by Abdul Rasheed on 16/05/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("6419","3","15","2019-05-16 09:21:58","Exit Invoice [Invoice No: 120133] updated by Abdul Rasheed on 16/05/2019 at 09:21 AM");
INSERT INTO crm_audit_log VALUES("6420","3","15","2019-05-16 09:50:43","Exit Invoice [Invoice No: 120134] updated by Abdul Rasheed on 16/05/2019 at 09:50 AM");
INSERT INTO crm_audit_log VALUES("6421","3","15","2019-05-16 10:42:45","Exit Invoice [Invoice No: 120135] updated by Abdul Rasheed on 16/05/2019 at 10:42 AM");
INSERT INTO crm_audit_log VALUES("6422","2","7","2019-05-16 13:39:43","Entry Invoice [Invoice No: 21663] updated by ALSED ABU SHAMA on 16/05/2019 at 01:39 PM");
INSERT INTO crm_audit_log VALUES("6423","2","7","2019-05-16 13:59:51","Entry Invoice [Invoice No: 21664] updated by ALSED ABU SHAMA on 16/05/2019 at 01:59 PM");
INSERT INTO crm_audit_log VALUES("6424","2","7","2019-05-16 14:00:38","Entry Invoice [Invoice No: 21665] updated by ALSED ABU SHAMA on 16/05/2019 at 02:00 PM");
INSERT INTO crm_audit_log VALUES("6425","2","7","2019-05-16 14:01:21","Entry Invoice [Invoice No: 21666] updated by ALSED ABU SHAMA on 16/05/2019 at 02:01 PM");
INSERT INTO crm_audit_log VALUES("6426","2","7","2019-05-16 14:07:28","Entry Invoice [Invoice No: 21667] updated by ALSED ABU SHAMA on 16/05/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("6427","2","7","2019-05-16 14:08:13","Entry Invoice [Invoice No: 21668] updated by ALSED ABU SHAMA on 16/05/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("6428","2","7","2019-05-16 14:08:50","Entry Invoice [Invoice No: 21669] updated by ALSED ABU SHAMA on 16/05/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("6429","3","4","2019-05-16 17:24:58","Exit Invoice [Invoice No: 120136] updated by Yasir  Rahman on 16/05/2019 at 05:24 PM");
INSERT INTO crm_audit_log VALUES("6430","3","5","2019-05-16 20:25:17","Exit Invoice [Invoice No: 120137] updated by Imran  Khan on 16/05/2019 at 08:25 PM");
INSERT INTO crm_audit_log VALUES("6431","3","5","2019-05-16 20:26:08","Exit Invoice [Invoice No: 120138] updated by Imran  Khan on 16/05/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("6432","3","5","2019-05-16 20:26:56","Exit Invoice [Invoice No: 120139] updated by Imran  Khan on 16/05/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("6433","3","5","2019-05-16 21:13:21","Exit Invoice [Invoice No: 120140] updated by Imran  Khan on 16/05/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("6434","2","4","2019-05-16 23:09:07","Entry Invoice [Invoice No: 21670] updated by Yasir  Rahman on 16/05/2019 at 11:09 PM");
INSERT INTO crm_audit_log VALUES("6435","3","5","2019-05-16 23:36:49","Exit Invoice [Invoice No: 120141] updated by Imran  Khan on 16/05/2019 at 11:36 PM");
INSERT INTO crm_audit_log VALUES("6436","3","5","2019-05-17 00:38:06","Exit Invoice [Invoice No: 120142] updated by Imran  Khan on 17/05/2019 at 12:38 AM");
INSERT INTO crm_audit_log VALUES("6437","3","5","2019-05-17 02:37:37","Exit Invoice [Invoice No: 120143] updated by Imran  Khan on 17/05/2019 at 02:37 AM");
INSERT INTO crm_audit_log VALUES("6438","3","5","2019-05-17 04:14:00","Exit Invoice [Invoice No: 120144] updated by Imran  Khan on 17/05/2019 at 04:14 AM");
INSERT INTO crm_audit_log VALUES("6439","2","4","2019-05-17 04:31:07","Entry Invoice [Invoice No: 21671] updated by Yasir  Rahman on 17/05/2019 at 04:31 AM");
INSERT INTO crm_audit_log VALUES("6440","2","4","2019-05-17 04:34:03","Entry Invoice [Invoice No: 21672] updated by Yasir  Rahman on 17/05/2019 at 04:34 AM");
INSERT INTO crm_audit_log VALUES("6441","1","4","2019-05-17 04:34:31","Customer [Customer No: 51] updated by Yasir  Rahman on 17/05/2019 at 04:34 AM");
INSERT INTO crm_audit_log VALUES("6442","2","4","2019-05-17 04:37:25","Entry Invoice [Invoice No: 21673] updated by Yasir  Rahman on 17/05/2019 at 04:37 AM");
INSERT INTO crm_audit_log VALUES("6443","2","4","2019-05-17 04:39:54","Entry Invoice [Invoice No: 21674] updated by Yasir  Rahman on 17/05/2019 at 04:39 AM");
INSERT INTO crm_audit_log VALUES("6444","2","4","2019-05-17 04:42:11","Entry Invoice [Invoice No: 21675] updated by Yasir  Rahman on 17/05/2019 at 04:42 AM");
INSERT INTO crm_audit_log VALUES("6445","2","4","2019-05-17 05:32:07","Entry Invoice [Invoice No: 21676] updated by Yasir  Rahman on 17/05/2019 at 05:32 AM");
INSERT INTO crm_audit_log VALUES("6446","3","5","2019-05-17 07:56:59","Exit Invoice [Invoice No: 120145] updated by Imran  Khan on 17/05/2019 at 07:56 AM");
INSERT INTO crm_audit_log VALUES("6447","3","5","2019-05-17 07:57:43","Exit Invoice [Invoice No: 120146] updated by Imran  Khan on 17/05/2019 at 07:57 AM");
INSERT INTO crm_audit_log VALUES("6448","2","7","2019-05-17 09:51:12","Entry Invoice [Invoice No: 21677] updated by ALSED ABU SHAMA on 17/05/2019 at 09:51 AM");
INSERT INTO crm_audit_log VALUES("6449","3","15","2019-05-17 09:55:45","Exit Invoice [Invoice No: 120147] updated by Abdul Rasheed on 17/05/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("6450","3","15","2019-05-17 13:37:14","Exit Invoice [Invoice No: 120148] updated by Abdul Rasheed on 17/05/2019 at 01:37 PM");
INSERT INTO crm_audit_log VALUES("6451","3","6","2019-05-17 13:41:08","Exit Invoice [Invoice No: 120148] updated by ASHRAF  M K on 17/05/2019 at 01:41 PM");
INSERT INTO crm_audit_log VALUES("6452","3","6","2019-05-17 13:54:19","Exit Invoice [Invoice No: 120149] updated by ASHRAF  M K on 17/05/2019 at 01:54 PM");
INSERT INTO crm_audit_log VALUES("6453","3","6","2019-05-17 14:56:54","Exit Invoice [Invoice No: 120150] updated by ASHRAF  M K on 17/05/2019 at 02:56 PM");
INSERT INTO crm_audit_log VALUES("6454","3","4","2019-05-17 19:02:27","Exit Invoice [Invoice No: 120151] updated by Yasir  Rahman on 17/05/2019 at 07:02 PM");
INSERT INTO crm_audit_log VALUES("6455","2","4","2019-05-17 22:51:11","Entry Invoice [Invoice No: 21678] updated by Yasir  Rahman on 17/05/2019 at 10:51 PM");
INSERT INTO crm_audit_log VALUES("6456","3","5","2019-05-17 23:41:59","Exit Invoice [Invoice No: 120152] updated by Imran  Khan on 17/05/2019 at 11:41 PM");
INSERT INTO crm_audit_log VALUES("6457","3","5","2019-05-18 00:05:35","Exit Invoice [Invoice No: 120153] updated by Imran  Khan on 18/05/2019 at 12:05 AM");
INSERT INTO crm_audit_log VALUES("6458","2","4","2019-05-18 00:07:53","Entry Invoice [Invoice No: 21679] updated by Yasir  Rahman on 18/05/2019 at 12:07 AM");
INSERT INTO crm_audit_log VALUES("6459","3","5","2019-05-18 00:20:57","Exit Invoice [Invoice No: 120154] updated by Imran  Khan on 18/05/2019 at 12:20 AM");
INSERT INTO crm_audit_log VALUES("6460","3","5","2019-05-18 00:21:52","Exit Invoice [Invoice No: 120155] updated by Imran  Khan on 18/05/2019 at 12:21 AM");
INSERT INTO crm_audit_log VALUES("6461","2","4","2019-05-18 01:07:31","Entry Invoice [Invoice No: 21680] updated by Yasir  Rahman on 18/05/2019 at 01:07 AM");
INSERT INTO crm_audit_log VALUES("6462","2","4","2019-05-18 06:12:13","Entry Invoice [Invoice No: 21681] updated by Yasir  Rahman on 18/05/2019 at 06:12 AM");
INSERT INTO crm_audit_log VALUES("6463","2","4","2019-05-18 06:13:52","Entry Invoice [Invoice No: 21682] updated by Yasir  Rahman on 18/05/2019 at 06:13 AM");
INSERT INTO crm_audit_log VALUES("6464","2","4","2019-05-18 06:16:44","Entry Invoice [Invoice No: 21683] updated by Yasir  Rahman on 18/05/2019 at 06:16 AM");
INSERT INTO crm_audit_log VALUES("6465","3","4","2019-05-18 06:18:43","Exit Invoice [Invoice No: 120156] updated by Yasir  Rahman on 18/05/2019 at 06:18 AM");
INSERT INTO crm_audit_log VALUES("6466","3","6","2019-05-18 08:32:00","Exit Invoice [Invoice No: 120155] updated by ASHRAF  M K on 18/05/2019 at 08:32 AM");
INSERT INTO crm_audit_log VALUES("6467","3","6","2019-05-18 08:32:11","Exit Invoice [Invoice No: 120154] updated by ASHRAF  M K on 18/05/2019 at 08:32 AM");
INSERT INTO crm_audit_log VALUES("6468","3","6","2019-05-18 08:32:22","Exit Invoice [Invoice No: 120153] updated by ASHRAF  M K on 18/05/2019 at 08:32 AM");
INSERT INTO crm_audit_log VALUES("6469","3","15","2019-05-18 13:41:43","Exit Invoice [Invoice No: 120157] updated by Abdul Rasheed on 18/05/2019 at 01:41 PM");
INSERT INTO crm_audit_log VALUES("6470","3","6","2019-05-18 13:44:07","Exit Invoice [Invoice No: 120157] updated by ASHRAF  M K on 18/05/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("6471","3","6","2019-05-18 14:19:03","Exit Invoice [Invoice No: 120157] updated by ASHRAF  M K on 18/05/2019 at 02:19 PM");
INSERT INTO crm_audit_log VALUES("6472","3","15","2019-05-18 14:53:32","Exit Invoice [Invoice No: 120158] updated by Abdul Rasheed on 18/05/2019 at 02:53 PM");
INSERT INTO crm_audit_log VALUES("6473","3","15","2019-05-18 15:11:35","Exit Invoice [Invoice No: 120159] updated by Abdul Rasheed on 18/05/2019 at 03:11 PM");
INSERT INTO crm_audit_log VALUES("6474","2","7","2019-05-18 15:54:28","Entry Invoice [Invoice No: 21684] updated by ALSED ABU SHAMA on 18/05/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("6475","2","7","2019-05-18 15:55:14","Entry Invoice [Invoice No: 21685] updated by ALSED ABU SHAMA on 18/05/2019 at 03:55 PM");
INSERT INTO crm_audit_log VALUES("6476","2","7","2019-05-18 18:07:34","Entry Invoice [Invoice No: 21686] updated by ALSED ABU SHAMA on 18/05/2019 at 06:07 PM");
INSERT INTO crm_audit_log VALUES("6477","3","5","2019-05-18 23:04:59","Exit Invoice [Invoice No: 120160] updated by Imran  Khan on 18/05/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("6478","2","4","2019-05-18 23:46:12","Entry Invoice [Invoice No: 21687] updated by Yasir  Rahman on 18/05/2019 at 11:46 PM");
INSERT INTO crm_audit_log VALUES("6479","2","4","2019-05-19 02:08:33","Entry Invoice [Invoice No: 21688] updated by Yasir  Rahman on 19/05/2019 at 02:08 AM");
INSERT INTO crm_audit_log VALUES("6480","2","4","2019-05-19 02:10:01","Entry Invoice [Invoice No: 21689] updated by Yasir  Rahman on 19/05/2019 at 02:10 AM");
INSERT INTO crm_audit_log VALUES("6481","2","4","2019-05-19 02:21:49","Entry Invoice [Invoice No: 21690] updated by Yasir  Rahman on 19/05/2019 at 02:21 AM");
INSERT INTO crm_audit_log VALUES("6482","2","4","2019-05-19 02:24:38","Entry Invoice [Invoice No: 21691] updated by Yasir  Rahman on 19/05/2019 at 02:24 AM");
INSERT INTO crm_audit_log VALUES("6483","2","4","2019-05-19 02:25:30","Entry Invoice [Invoice No: 21692] updated by Yasir  Rahman on 19/05/2019 at 02:25 AM");
INSERT INTO crm_audit_log VALUES("6484","2","4","2019-05-19 02:26:52","Entry Invoice [Invoice No: 21693] updated by Yasir  Rahman on 19/05/2019 at 02:26 AM");
INSERT INTO crm_audit_log VALUES("6485","2","4","2019-05-19 02:27:57","Entry Invoice [Invoice No: 21694] updated by Yasir  Rahman on 19/05/2019 at 02:27 AM");
INSERT INTO crm_audit_log VALUES("6486","2","4","2019-05-19 02:29:17","Entry Invoice [Invoice No: 21695] updated by Yasir  Rahman on 19/05/2019 at 02:29 AM");
INSERT INTO crm_audit_log VALUES("6487","3","5","2019-05-19 02:50:38","Exit Invoice [Invoice No: 120161] updated by Imran  Khan on 19/05/2019 at 02:50 AM");
INSERT INTO crm_audit_log VALUES("6488","3","5","2019-05-19 03:54:13","Exit Invoice [Invoice No: 120162] updated by Imran  Khan on 19/05/2019 at 03:54 AM");
INSERT INTO crm_audit_log VALUES("6489","3","4","2019-05-19 05:16:01","Exit Invoice [Invoice No: 120163] updated by Yasir  Rahman on 19/05/2019 at 05:16 AM");
INSERT INTO crm_audit_log VALUES("6490","3","15","2019-05-19 11:40:37","Exit Invoice [Invoice No: 120164] updated by Abdul Rasheed on 19/05/2019 at 11:40 AM");
INSERT INTO crm_audit_log VALUES("6491","2","7","2019-05-19 11:54:50","Entry Invoice [Invoice No: 21696] updated by ALSED ABU SHAMA on 19/05/2019 at 11:54 AM");
INSERT INTO crm_audit_log VALUES("6492","2","7","2019-05-19 11:55:34","Entry Invoice [Invoice No: 21697] updated by ALSED ABU SHAMA on 19/05/2019 at 11:55 AM");
INSERT INTO crm_audit_log VALUES("6493","3","15","2019-05-19 12:24:10","Exit Invoice [Invoice No: 120165] updated by Abdul Rasheed on 19/05/2019 at 12:24 PM");
INSERT INTO crm_audit_log VALUES("6494","3","15","2019-05-19 13:32:52","Exit Invoice [Invoice No: 120166] updated by Abdul Rasheed on 19/05/2019 at 01:32 PM");
INSERT INTO crm_audit_log VALUES("6495","3","15","2019-05-19 14:24:24","Exit Invoice [Invoice No: 120167] updated by Abdul Rasheed on 19/05/2019 at 02:24 PM");
INSERT INTO crm_audit_log VALUES("6496","3","15","2019-05-19 14:29:51","Exit Invoice [Invoice No: 120168] updated by Abdul Rasheed on 19/05/2019 at 02:29 PM");
INSERT INTO crm_audit_log VALUES("6497","3","4","2019-05-19 17:14:03","Exit Invoice [Invoice No: 120169] updated by Yasir  Rahman on 19/05/2019 at 05:14 PM");
INSERT INTO crm_audit_log VALUES("6498","3","4","2019-05-19 21:59:59","Exit Invoice [Invoice No: 120170] updated by Yasir  Rahman on 19/05/2019 at 09:59 PM");
INSERT INTO crm_audit_log VALUES("6499","3","4","2019-05-19 23:04:17","Exit Invoice [Invoice No: 120171] updated by Yasir  Rahman on 19/05/2019 at 11:04 PM");
INSERT INTO crm_audit_log VALUES("6500","3","4","2019-05-19 23:08:20","Exit Invoice [Invoice No: 120172] updated by Yasir  Rahman on 19/05/2019 at 11:08 PM");
INSERT INTO crm_audit_log VALUES("6501","3","4","2019-05-19 23:09:17","Exit Invoice [Invoice No: 120173] updated by Yasir  Rahman on 19/05/2019 at 11:09 PM");
INSERT INTO crm_audit_log VALUES("6502","3","5","2019-05-20 00:15:15","Exit Invoice [Invoice No: 120174] updated by Imran  Khan on 20/05/2019 at 12:15 AM");
INSERT INTO crm_audit_log VALUES("6503","3","5","2019-05-20 00:44:49","Exit Invoice [Invoice No: 120175] updated by Imran  Khan on 20/05/2019 at 12:44 AM");
INSERT INTO crm_audit_log VALUES("6504","3","5","2019-05-20 00:45:41","Exit Invoice [Invoice No: 120176] updated by Imran  Khan on 20/05/2019 at 12:45 AM");
INSERT INTO crm_audit_log VALUES("6505","3","5","2019-05-20 00:47:29","Exit Invoice [Invoice No: 120177] updated by Imran  Khan on 20/05/2019 at 12:47 AM");
INSERT INTO crm_audit_log VALUES("6506","3","5","2019-05-20 03:49:53","Exit Invoice [Invoice No: 120178] updated by Imran  Khan on 20/05/2019 at 03:49 AM");
INSERT INTO crm_audit_log VALUES("6507","3","5","2019-05-20 03:50:42","Exit Invoice [Invoice No: 120179] updated by Imran  Khan on 20/05/2019 at 03:50 AM");
INSERT INTO crm_audit_log VALUES("6508","2","4","2019-05-20 05:39:45","Entry Invoice [Invoice No: 21698] updated by Yasir  Rahman on 20/05/2019 at 05:39 AM");
INSERT INTO crm_audit_log VALUES("6509","3","15","2019-05-20 10:53:31","Exit Invoice [Invoice No: 120180] updated by Abdul Rasheed on 20/05/2019 at 10:53 AM");
INSERT INTO crm_audit_log VALUES("6510","3","15","2019-05-20 14:33:12","Exit Invoice [Invoice No: 120181] updated by Abdul Rasheed on 20/05/2019 at 02:33 PM");
INSERT INTO crm_audit_log VALUES("6511","3","15","2019-05-20 14:51:45","Exit Invoice [Invoice No: 120182] updated by Abdul Rasheed on 20/05/2019 at 02:51 PM");
INSERT INTO crm_audit_log VALUES("6512","3","6","2019-05-20 14:53:33","Exit Invoice [Invoice No: 120182] updated by ASHRAF  M K on 20/05/2019 at 02:53 PM");
INSERT INTO crm_audit_log VALUES("6513","2","7","2019-05-20 15:37:09","Entry Invoice [Invoice No: 21699] updated by ALSED ABU SHAMA on 20/05/2019 at 03:37 PM");
INSERT INTO crm_audit_log VALUES("6514","2","7","2019-05-20 16:07:59","Entry Invoice [Invoice No: 21700] updated by ALSED ABU SHAMA on 20/05/2019 at 04:07 PM");
INSERT INTO crm_audit_log VALUES("6515","3","4","2019-05-20 18:04:05","Exit Invoice [Invoice No: 120183] updated by Yasir  Rahman on 20/05/2019 at 06:04 PM");
INSERT INTO crm_audit_log VALUES("6516","2","7","2019-05-20 18:06:17","Entry Invoice [Invoice No: 21701] updated by ALSED ABU SHAMA on 20/05/2019 at 06:06 PM");
INSERT INTO crm_audit_log VALUES("6517","2","7","2019-05-20 18:07:06","Entry Invoice [Invoice No: 21702] updated by ALSED ABU SHAMA on 20/05/2019 at 06:07 PM");
INSERT INTO crm_audit_log VALUES("6518","3","4","2019-05-20 18:38:23","Exit Invoice [Invoice No: 120184] updated by Yasir  Rahman on 20/05/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("6519","2","4","2019-05-20 20:53:49","Entry Invoice [Invoice No: 21703] updated by Yasir  Rahman on 20/05/2019 at 08:53 PM");
INSERT INTO crm_audit_log VALUES("6520","3","4","2019-05-20 21:23:29","Exit Invoice [Invoice No: 120185] updated by Yasir  Rahman on 20/05/2019 at 09:23 PM");
INSERT INTO crm_audit_log VALUES("6521","2","4","2019-05-20 21:34:30","Entry Invoice [Invoice No: 21704] updated by Yasir  Rahman on 20/05/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("6522","3","5","2019-05-21 00:56:02","Exit Invoice [Invoice No: 120186] updated by Imran  Khan on 21/05/2019 at 12:56 AM");
INSERT INTO crm_audit_log VALUES("6523","2","4","2019-05-21 01:41:43","Entry Invoice [Invoice No: 21705] updated by Yasir  Rahman on 21/05/2019 at 01:41 AM");
INSERT INTO crm_audit_log VALUES("6524","2","4","2019-05-21 01:42:57","Entry Invoice [Invoice No: 21706] updated by Yasir  Rahman on 21/05/2019 at 01:42 AM");
INSERT INTO crm_audit_log VALUES("6525","2","4","2019-05-21 01:43:58","Entry Invoice [Invoice No: 21707] updated by Yasir  Rahman on 21/05/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("6526","2","4","2019-05-21 01:44:46","Entry Invoice [Invoice No: 21708] updated by Yasir  Rahman on 21/05/2019 at 01:44 AM");
INSERT INTO crm_audit_log VALUES("6527","2","4","2019-05-21 01:45:34","Entry Invoice [Invoice No: 21709] updated by Yasir  Rahman on 21/05/2019 at 01:45 AM");
INSERT INTO crm_audit_log VALUES("6528","2","4","2019-05-21 01:46:18","Entry Invoice [Invoice No: 21710] updated by Yasir  Rahman on 21/05/2019 at 01:46 AM");
INSERT INTO crm_audit_log VALUES("6529","2","4","2019-05-21 01:47:19","Entry Invoice [Invoice No: 21711] updated by Yasir  Rahman on 21/05/2019 at 01:47 AM");
INSERT INTO crm_audit_log VALUES("6530","2","4","2019-05-21 01:48:08","Entry Invoice [Invoice No: 21712] updated by Yasir  Rahman on 21/05/2019 at 01:48 AM");
INSERT INTO crm_audit_log VALUES("6531","2","4","2019-05-21 01:53:13","Entry Invoice [Invoice No: 21713] updated by Yasir  Rahman on 21/05/2019 at 01:53 AM");
INSERT INTO crm_audit_log VALUES("6532","2","4","2019-05-21 01:55:22","Entry Invoice [Invoice No: 21714] updated by Yasir  Rahman on 21/05/2019 at 01:55 AM");
INSERT INTO crm_audit_log VALUES("6533","2","4","2019-05-21 01:56:48","Entry Invoice [Invoice No: 21715] updated by Yasir  Rahman on 21/05/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("6534","3","5","2019-05-21 02:59:59","Exit Invoice [Invoice No: 120187] updated by Imran  Khan on 21/05/2019 at 02:59 AM");
INSERT INTO crm_audit_log VALUES("6535","3","5","2019-05-21 04:53:54","Exit Invoice [Invoice No: 120188] updated by Imran  Khan on 21/05/2019 at 04:53 AM");
INSERT INTO crm_audit_log VALUES("6536","2","4","2019-05-21 04:57:15","Entry Invoice [Invoice No: 21716] updated by Yasir  Rahman on 21/05/2019 at 04:57 AM");
INSERT INTO crm_audit_log VALUES("6537","2","4","2019-05-21 04:59:19","Entry Invoice [Invoice No: 21717] updated by Yasir  Rahman on 21/05/2019 at 04:59 AM");
INSERT INTO crm_audit_log VALUES("6538","2","4","2019-05-21 05:01:24","Entry Invoice [Invoice No: 21718] updated by Yasir  Rahman on 21/05/2019 at 05:01 AM");
INSERT INTO crm_audit_log VALUES("6539","2","4","2019-05-21 05:02:53","Entry Invoice [Invoice No: 21719] updated by Yasir  Rahman on 21/05/2019 at 05:02 AM");
INSERT INTO crm_audit_log VALUES("6540","2","4","2019-05-21 05:04:25","Entry Invoice [Invoice No: 21720] updated by Yasir  Rahman on 21/05/2019 at 05:04 AM");
INSERT INTO crm_audit_log VALUES("6541","2","4","2019-05-21 05:06:01","Entry Invoice [Invoice No: 21721] updated by Yasir  Rahman on 21/05/2019 at 05:06 AM");
INSERT INTO crm_audit_log VALUES("6542","2","4","2019-05-21 05:07:44","Entry Invoice [Invoice No: 21722] updated by Yasir  Rahman on 21/05/2019 at 05:07 AM");
INSERT INTO crm_audit_log VALUES("6543","2","4","2019-05-21 05:33:02","Entry Invoice [Invoice No: 21723] updated by Yasir  Rahman on 21/05/2019 at 05:33 AM");
INSERT INTO crm_audit_log VALUES("6544","3","15","2019-05-21 08:56:47","Exit Invoice [Invoice No: 120189] updated by Abdul Rasheed on 21/05/2019 at 08:56 AM");
INSERT INTO crm_audit_log VALUES("6545","3","6","2019-05-21 08:57:54","Exit Invoice [Invoice No: 120188] updated by ASHRAF  M K on 21/05/2019 at 08:57 AM");
INSERT INTO crm_audit_log VALUES("6546","2","6","2019-05-21 10:01:30","Entry Invoice [Invoice No: 21717] updated by ASHRAF  M K on 21/05/2019 at 10:01 AM");
INSERT INTO crm_audit_log VALUES("6547","2","6","2019-05-21 10:12:51","Entry Invoice [Invoice No: 21705] updated by ASHRAF  M K on 21/05/2019 at 10:12 AM");
INSERT INTO crm_audit_log VALUES("6548","2","6","2019-05-21 10:14:40","Entry Invoice [Invoice No: 21706] updated by ASHRAF  M K on 21/05/2019 at 10:14 AM");
INSERT INTO crm_audit_log VALUES("6549","2","6","2019-05-21 10:19:03","Entry Invoice [Invoice No: 21724] updated by ASHRAF  M K on 21/05/2019 at 10:19 AM");
INSERT INTO crm_audit_log VALUES("6550","3","15","2019-05-21 11:06:39","Exit Invoice [Invoice No: 120190] updated by Abdul Rasheed on 21/05/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("6551","2","7","2019-05-21 11:53:08","Entry Invoice [Invoice No: 21725] updated by ALSED ABU SHAMA on 21/05/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("6552","3","15","2019-05-21 12:46:29","Exit Invoice [Invoice No: 120191] updated by Abdul Rasheed on 21/05/2019 at 12:46 PM");
INSERT INTO crm_audit_log VALUES("6553","3","15","2019-05-21 12:51:49","Exit Invoice [Invoice No: 120192] updated by Abdul Rasheed on 21/05/2019 at 12:51 PM");
INSERT INTO crm_audit_log VALUES("6554","3","15","2019-05-21 12:53:18","Exit Invoice [Invoice No: 120193] updated by Abdul Rasheed on 21/05/2019 at 12:53 PM");
INSERT INTO crm_audit_log VALUES("6555","3","15","2019-05-21 13:08:57","Exit Invoice [Invoice No: 120194] updated by Abdul Rasheed on 21/05/2019 at 01:08 PM");
INSERT INTO crm_audit_log VALUES("6556","2","6","2019-05-21 14:00:04","Entry Invoice [Invoice No: 21726] updated by ASHRAF  M K on 21/05/2019 at 02:00 PM");
INSERT INTO crm_audit_log VALUES("6557","2","7","2019-05-21 14:14:37","Entry Invoice [Invoice No: 21727] updated by ALSED ABU SHAMA on 21/05/2019 at 02:14 PM");
INSERT INTO crm_audit_log VALUES("6558","2","7","2019-05-21 14:15:28","Entry Invoice [Invoice No: 21728] updated by ALSED ABU SHAMA on 21/05/2019 at 02:15 PM");
INSERT INTO crm_audit_log VALUES("6559","2","7","2019-05-21 14:22:22","Entry Invoice [Invoice No: 21729] updated by ALSED ABU SHAMA on 21/05/2019 at 02:22 PM");
INSERT INTO crm_audit_log VALUES("6560","2","7","2019-05-21 14:34:24","Entry Invoice [Invoice No: 21730] updated by ALSED ABU SHAMA on 21/05/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("6561","3","15","2019-05-21 14:46:49","Exit Invoice [Invoice No: 120195] updated by Abdul Rasheed on 21/05/2019 at 02:46 PM");
INSERT INTO crm_audit_log VALUES("6562","2","7","2019-05-21 15:21:07","Entry Invoice [Invoice No: 21731] updated by ALSED ABU SHAMA on 21/05/2019 at 03:21 PM");
INSERT INTO crm_audit_log VALUES("6563","2","7","2019-05-21 17:11:07","Entry Invoice [Invoice No: 21732] updated by ALSED ABU SHAMA on 21/05/2019 at 05:11 PM");
INSERT INTO crm_audit_log VALUES("6564","3","4","2019-05-21 17:19:49","Exit Invoice [Invoice No: 120196] updated by Yasir  Rahman on 21/05/2019 at 05:19 PM");
INSERT INTO crm_audit_log VALUES("6565","3","4","2019-05-21 17:20:39","Exit Invoice [Invoice No: 120197] updated by Yasir  Rahman on 21/05/2019 at 05:20 PM");
INSERT INTO crm_audit_log VALUES("6566","2","7","2019-05-21 17:41:43","Entry Invoice [Invoice No: 21733] updated by ALSED ABU SHAMA on 21/05/2019 at 05:41 PM");
INSERT INTO crm_audit_log VALUES("6567","2","7","2019-05-21 17:54:36","Entry Invoice [Invoice No: 21734] updated by ALSED ABU SHAMA on 21/05/2019 at 05:54 PM");
INSERT INTO crm_audit_log VALUES("6568","2","7","2019-05-21 17:56:15","Entry Invoice [Invoice No: 21735] updated by ALSED ABU SHAMA on 21/05/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("6569","2","7","2019-05-21 18:24:08","Entry Invoice [Invoice No: 21736] updated by ALSED ABU SHAMA on 21/05/2019 at 06:24 PM");
INSERT INTO crm_audit_log VALUES("6570","3","5","2019-05-21 21:04:04","Exit Invoice [Invoice No: 120198] updated by Imran  Khan on 21/05/2019 at 09:04 PM");
INSERT INTO crm_audit_log VALUES("6571","3","5","2019-05-21 21:22:28","Exit Invoice [Invoice No: 120199] updated by Imran  Khan on 21/05/2019 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("6572","2","4","2019-05-21 21:58:02","Entry Invoice [Invoice No: 21737] updated by Yasir  Rahman on 21/05/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("6573","2","4","2019-05-21 22:28:04","Entry Invoice [Invoice No: 21738] updated by Yasir  Rahman on 21/05/2019 at 10:28 PM");
INSERT INTO crm_audit_log VALUES("6574","3","5","2019-05-22 00:08:11","Exit Invoice [Invoice No: 120200] updated by Imran  Khan on 22/05/2019 at 12:08 AM");
INSERT INTO crm_audit_log VALUES("6575","2","4","2019-05-22 00:22:45","Entry Invoice [Invoice No: 21739] updated by Yasir  Rahman on 22/05/2019 at 12:22 AM");
INSERT INTO crm_audit_log VALUES("6576","3","5","2019-05-22 01:54:56","Exit Invoice [Invoice No: 120201] updated by Imran  Khan on 22/05/2019 at 01:54 AM");
INSERT INTO crm_audit_log VALUES("6577","3","5","2019-05-22 01:55:31","Exit Invoice [Invoice No: 120202] updated by Imran  Khan on 22/05/2019 at 01:55 AM");
INSERT INTO crm_audit_log VALUES("6578","3","5","2019-05-22 01:56:05","Exit Invoice [Invoice No: 120203] updated by Imran  Khan on 22/05/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("6579","2","4","2019-05-22 04:10:39","Entry Invoice [Invoice No: 21740] updated by Yasir  Rahman on 22/05/2019 at 04:10 AM");
INSERT INTO crm_audit_log VALUES("6580","2","4","2019-05-22 04:12:18","Entry Invoice [Invoice No: 21741] updated by Yasir  Rahman on 22/05/2019 at 04:12 AM");
INSERT INTO crm_audit_log VALUES("6581","2","4","2019-05-22 04:37:26","Entry Invoice [Invoice No: 21742] updated by Yasir  Rahman on 22/05/2019 at 04:37 AM");
INSERT INTO crm_audit_log VALUES("6582","3","5","2019-05-22 04:47:54","Exit Invoice [Invoice No: 120204] updated by Imran  Khan on 22/05/2019 at 04:47 AM");
INSERT INTO crm_audit_log VALUES("6583","3","5","2019-05-22 04:48:59","Exit Invoice [Invoice No: 120205] updated by Imran  Khan on 22/05/2019 at 04:48 AM");
INSERT INTO crm_audit_log VALUES("6584","3","5","2019-05-22 04:49:34","Exit Invoice [Invoice No: 120206] updated by Imran  Khan on 22/05/2019 at 04:49 AM");
INSERT INTO crm_audit_log VALUES("6585","3","5","2019-05-22 04:50:07","Exit Invoice [Invoice No: 120207] updated by Imran  Khan on 22/05/2019 at 04:50 AM");
INSERT INTO crm_audit_log VALUES("6586","3","15","2019-05-22 10:30:22","Exit Invoice [Invoice No: 120208] updated by Abdul Rasheed on 22/05/2019 at 10:30 AM");
INSERT INTO crm_audit_log VALUES("6587","3","15","2019-05-22 10:32:13","Exit Invoice [Invoice No: 120209] updated by Abdul Rasheed on 22/05/2019 at 10:32 AM");
INSERT INTO crm_audit_log VALUES("6588","3","15","2019-05-22 10:33:40","Exit Invoice [Invoice No: 120210] updated by Abdul Rasheed on 22/05/2019 at 10:33 AM");
INSERT INTO crm_audit_log VALUES("6589","3","15","2019-05-22 10:35:00","Exit Invoice [Invoice No: 120211] updated by Abdul Rasheed on 22/05/2019 at 10:35 AM");
INSERT INTO crm_audit_log VALUES("6590","2","6","2019-05-22 11:38:08","Entry Invoice [Invoice No: 21722] updated by ASHRAF  M K on 22/05/2019 at 11:38 AM");
INSERT INTO crm_audit_log VALUES("6591","2","6","2019-05-22 11:42:00","Entry Invoice [Invoice No: 21743] updated by ASHRAF  M K on 22/05/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("6592","3","15","2019-05-22 12:27:28","Exit Invoice [Invoice No: 120212] updated by Abdul Rasheed on 22/05/2019 at 12:27 PM");
INSERT INTO crm_audit_log VALUES("6593","3","15","2019-05-22 12:29:44","Exit Invoice [Invoice No: 120213] updated by Abdul Rasheed on 22/05/2019 at 12:29 PM");
INSERT INTO crm_audit_log VALUES("6594","2","7","2019-05-22 13:06:41","Entry Invoice [Invoice No: 21744] updated by ALSED ABU SHAMA on 22/05/2019 at 01:06 PM");
INSERT INTO crm_audit_log VALUES("6595","2","7","2019-05-22 13:07:35","Entry Invoice [Invoice No: 21745] updated by ALSED ABU SHAMA on 22/05/2019 at 01:07 PM");
INSERT INTO crm_audit_log VALUES("6596","2","7","2019-05-22 13:08:51","Entry Invoice [Invoice No: 21746] updated by ALSED ABU SHAMA on 22/05/2019 at 01:08 PM");
INSERT INTO crm_audit_log VALUES("6597","2","7","2019-05-22 13:10:21","Entry Invoice [Invoice No: 21747] updated by ALSED ABU SHAMA on 22/05/2019 at 01:10 PM");
INSERT INTO crm_audit_log VALUES("6598","2","7","2019-05-22 13:11:45","Entry Invoice [Invoice No: 21748] updated by ALSED ABU SHAMA on 22/05/2019 at 01:11 PM");
INSERT INTO crm_audit_log VALUES("6599","2","7","2019-05-22 13:16:29","Entry Invoice [Invoice No: 21749] updated by ALSED ABU SHAMA on 22/05/2019 at 01:16 PM");
INSERT INTO crm_audit_log VALUES("6600","2","6","2019-05-22 13:19:30","Entry Invoice [Invoice No: 21749] updated by ASHRAF  M K on 22/05/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("6601","3","15","2019-05-22 14:44:27","Exit Invoice [Invoice No: 120214] updated by Abdul Rasheed on 22/05/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("6602","3","15","2019-05-22 14:50:40","Exit Invoice [Invoice No: 120215] updated by Abdul Rasheed on 22/05/2019 at 02:50 PM");
INSERT INTO crm_audit_log VALUES("6603","2","7","2019-05-22 14:57:18","Entry Invoice [Invoice No: 21750] updated by ALSED ABU SHAMA on 22/05/2019 at 02:57 PM");
INSERT INTO crm_audit_log VALUES("6604","2","7","2019-05-22 14:58:09","Entry Invoice [Invoice No: 21751] updated by ALSED ABU SHAMA on 22/05/2019 at 02:58 PM");
INSERT INTO crm_audit_log VALUES("6605","3","15","2019-05-22 15:05:26","Exit Invoice [Invoice No: 120216] updated by Abdul Rasheed on 22/05/2019 at 03:05 PM");
INSERT INTO crm_audit_log VALUES("6606","3","4","2019-05-22 16:03:08","Exit Invoice [Invoice No: 120217] updated by Yasir  Rahman on 22/05/2019 at 04:03 PM");
INSERT INTO crm_audit_log VALUES("6607","2","7","2019-05-22 16:40:44","Entry Invoice [Invoice No: 21752] updated by ALSED ABU SHAMA on 22/05/2019 at 04:40 PM");
INSERT INTO crm_audit_log VALUES("6608","2","7","2019-05-22 16:41:30","Entry Invoice [Invoice No: 21753] updated by ALSED ABU SHAMA on 22/05/2019 at 04:41 PM");
INSERT INTO crm_audit_log VALUES("6609","3","4","2019-05-22 16:43:41","Exit Invoice [Invoice No: 120218] updated by Yasir  Rahman on 22/05/2019 at 04:43 PM");
INSERT INTO crm_audit_log VALUES("6610","3","4","2019-05-22 18:36:00","Exit Invoice [Invoice No: 120219] updated by Yasir  Rahman on 22/05/2019 at 06:36 PM");
INSERT INTO crm_audit_log VALUES("6611","3","5","2019-05-22 21:22:25","Exit Invoice [Invoice No: 120220] updated by Imran  Khan on 22/05/2019 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("6612","3","5","2019-05-22 21:23:02","Exit Invoice [Invoice No: 120221] updated by Imran  Khan on 22/05/2019 at 09:23 PM");
INSERT INTO crm_audit_log VALUES("6613","3","5","2019-05-22 21:30:12","Exit Invoice [Invoice No: 120222] updated by Imran  Khan on 22/05/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("6614","2","4","2019-05-22 22:14:14","Entry Invoice [Invoice No: 21754] updated by Yasir  Rahman on 22/05/2019 at 10:14 PM");
INSERT INTO crm_audit_log VALUES("6615","2","4","2019-05-22 22:24:12","Entry Invoice [Invoice No: 21755] updated by Yasir  Rahman on 22/05/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("6616","2","4","2019-05-22 22:26:13","Entry Invoice [Invoice No: 21756] updated by Yasir  Rahman on 22/05/2019 at 10:26 PM");
INSERT INTO crm_audit_log VALUES("6617","2","4","2019-05-22 22:31:47","Entry Invoice [Invoice No: 21757] updated by Yasir  Rahman on 22/05/2019 at 10:31 PM");
INSERT INTO crm_audit_log VALUES("6618","2","4","2019-05-22 22:33:15","Entry Invoice [Invoice No: 21758] updated by Yasir  Rahman on 22/05/2019 at 10:33 PM");
INSERT INTO crm_audit_log VALUES("6619","2","4","2019-05-23 00:10:41","Entry Invoice [Invoice No: 21759] updated by Yasir  Rahman on 23/05/2019 at 12:10 AM");
INSERT INTO crm_audit_log VALUES("6620","3","5","2019-05-23 00:16:06","Exit Invoice [Invoice No: 120223] updated by Imran  Khan on 23/05/2019 at 12:16 AM");
INSERT INTO crm_audit_log VALUES("6621","3","5","2019-05-23 00:16:50","Exit Invoice [Invoice No: 120224] updated by Imran  Khan on 23/05/2019 at 12:16 AM");
INSERT INTO crm_audit_log VALUES("6622","3","5","2019-05-23 00:42:27","Exit Invoice [Invoice No: 120225] updated by Imran  Khan on 23/05/2019 at 12:42 AM");
INSERT INTO crm_audit_log VALUES("6623","3","5","2019-05-23 01:22:26","Exit Invoice [Invoice No: 120226] updated by Imran  Khan on 23/05/2019 at 01:22 AM");
INSERT INTO crm_audit_log VALUES("6624","3","5","2019-05-23 01:23:03","Exit Invoice [Invoice No: 120227] updated by Imran  Khan on 23/05/2019 at 01:23 AM");
INSERT INTO crm_audit_log VALUES("6625","3","5","2019-05-23 01:24:30","Exit Invoice [Invoice No: 120228] updated by Imran  Khan on 23/05/2019 at 01:24 AM");
INSERT INTO crm_audit_log VALUES("6626","3","5","2019-05-23 02:28:40","Exit Invoice [Invoice No: 120229] updated by Imran  Khan on 23/05/2019 at 02:28 AM");
INSERT INTO crm_audit_log VALUES("6627","3","5","2019-05-23 02:36:07","Exit Invoice [Invoice No: 120230] updated by Imran  Khan on 23/05/2019 at 02:36 AM");
INSERT INTO crm_audit_log VALUES("6628","2","4","2019-05-23 02:45:38","Entry Invoice [Invoice No: 21760] updated by Yasir  Rahman on 23/05/2019 at 02:45 AM");
INSERT INTO crm_audit_log VALUES("6629","2","4","2019-05-23 02:56:37","Entry Invoice [Invoice No: 21761] updated by Yasir  Rahman on 23/05/2019 at 02:56 AM");
INSERT INTO crm_audit_log VALUES("6630","2","4","2019-05-23 02:58:18","Entry Invoice [Invoice No: 21762] updated by Yasir  Rahman on 23/05/2019 at 02:58 AM");
INSERT INTO crm_audit_log VALUES("6631","3","5","2019-05-23 04:09:22","Exit Invoice [Invoice No: 120231] updated by Imran  Khan on 23/05/2019 at 04:09 AM");
INSERT INTO crm_audit_log VALUES("6632","3","5","2019-05-23 04:27:20","Exit Invoice [Invoice No: 120232] updated by Imran  Khan on 23/05/2019 at 04:27 AM");
INSERT INTO crm_audit_log VALUES("6633","3","5","2019-05-23 05:18:04","Exit Invoice [Invoice No: 120233] updated by Imran  Khan on 23/05/2019 at 05:18 AM");
INSERT INTO crm_audit_log VALUES("6634","3","5","2019-05-23 07:36:56","Exit Invoice [Invoice No: 120234] updated by Imran  Khan on 23/05/2019 at 07:36 AM");
INSERT INTO crm_audit_log VALUES("6635","3","15","2019-05-23 08:37:43","Exit Invoice [Invoice No: 120235] updated by Abdul Rasheed on 23/05/2019 at 08:37 AM");
INSERT INTO crm_audit_log VALUES("6636","3","15","2019-05-23 09:54:21","Exit Invoice [Invoice No: 120236] updated by Abdul Rasheed on 23/05/2019 at 09:54 AM");
INSERT INTO crm_audit_log VALUES("6637","3","6","2019-05-23 10:32:30","Exit Invoice [Invoice No: 120236] updated by ASHRAF  M K on 23/05/2019 at 10:32 AM");
INSERT INTO crm_audit_log VALUES("6638","3","15","2019-05-23 11:20:05","Exit Invoice [Invoice No: 120237] updated by Abdul Rasheed on 23/05/2019 at 11:20 AM");
INSERT INTO crm_audit_log VALUES("6639","3","15","2019-05-23 12:03:16","Exit Invoice [Invoice No: 120238] updated by Abdul Rasheed on 23/05/2019 at 12:03 PM");
INSERT INTO crm_audit_log VALUES("6640","3","15","2019-05-23 12:41:03","Exit Invoice [Invoice No: 120239] updated by Abdul Rasheed on 23/05/2019 at 12:41 PM");
INSERT INTO crm_audit_log VALUES("6641","2","7","2019-05-23 12:54:06","Entry Invoice [Invoice No: 21763] updated by ALSED ABU SHAMA on 23/05/2019 at 12:54 PM");
INSERT INTO crm_audit_log VALUES("6642","3","6","2019-05-23 15:18:44","Exit Invoice [Invoice No: 120228] updated by ASHRAF  M K on 23/05/2019 at 03:18 PM");
INSERT INTO crm_audit_log VALUES("6643","3","6","2019-05-23 15:19:20","Exit Invoice [Invoice No: 120227] updated by ASHRAF  M K on 23/05/2019 at 03:19 PM");
INSERT INTO crm_audit_log VALUES("6644","3","6","2019-05-23 15:19:51","Exit Invoice [Invoice No: 120226] updated by ASHRAF  M K on 23/05/2019 at 03:19 PM");
INSERT INTO crm_audit_log VALUES("6645","2","7","2019-05-23 16:33:48","Entry Invoice [Invoice No: 21764] updated by ALSED ABU SHAMA on 23/05/2019 at 04:33 PM");
INSERT INTO crm_audit_log VALUES("6646","2","7","2019-05-23 16:36:16","Entry Invoice [Invoice No: 21765] updated by ALSED ABU SHAMA on 23/05/2019 at 04:36 PM");
INSERT INTO crm_audit_log VALUES("6647","2","7","2019-05-23 16:42:48","Entry Invoice [Invoice No: 21766] updated by ALSED ABU SHAMA on 23/05/2019 at 04:42 PM");
INSERT INTO crm_audit_log VALUES("6648","3","4","2019-05-23 18:28:00","Exit Invoice [Invoice No: 120240] updated by Yasir  Rahman on 23/05/2019 at 06:28 PM");
INSERT INTO crm_audit_log VALUES("6649","3","4","2019-05-23 18:29:06","Exit Invoice [Invoice No: 120241] updated by Yasir  Rahman on 23/05/2019 at 06:29 PM");
INSERT INTO crm_audit_log VALUES("6650","3","5","2019-05-23 20:36:46","Exit Invoice [Invoice No: 120242] updated by Imran  Khan on 23/05/2019 at 08:36 PM");
INSERT INTO crm_audit_log VALUES("6651","3","5","2019-05-23 22:49:07","Exit Invoice [Invoice No: 120243] updated by Imran  Khan on 23/05/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("6652","3","5","2019-05-23 22:49:44","Exit Invoice [Invoice No: 120244] updated by Imran  Khan on 23/05/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("6653","3","5","2019-05-23 22:50:27","Exit Invoice [Invoice No: 120245] updated by Imran  Khan on 23/05/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("6654","3","5","2019-05-23 22:51:05","Exit Invoice [Invoice No: 120246] updated by Imran  Khan on 23/05/2019 at 10:51 PM");
INSERT INTO crm_audit_log VALUES("6655","3","5","2019-05-23 23:51:10","Exit Invoice [Invoice No: 120247] updated by Imran  Khan on 23/05/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("6656","3","5","2019-05-23 23:51:46","Exit Invoice [Invoice No: 120248] updated by Imran  Khan on 23/05/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("6657","3","5","2019-05-23 23:52:30","Exit Invoice [Invoice No: 120249] updated by Imran  Khan on 23/05/2019 at 11:52 PM");
INSERT INTO crm_audit_log VALUES("6658","3","5","2019-05-23 23:57:50","Exit Invoice [Invoice No: 120250] updated by Imran  Khan on 23/05/2019 at 11:57 PM");
INSERT INTO crm_audit_log VALUES("6659","3","5","2019-05-24 01:59:34","Exit Invoice [Invoice No: 120251] updated by Imran  Khan on 24/05/2019 at 01:59 AM");
INSERT INTO crm_audit_log VALUES("6660","3","5","2019-05-24 02:00:11","Exit Invoice [Invoice No: 120252] updated by Imran  Khan on 24/05/2019 at 02:00 AM");
INSERT INTO crm_audit_log VALUES("6661","3","5","2019-05-24 02:00:58","Exit Invoice [Invoice No: 120253] updated by Imran  Khan on 24/05/2019 at 02:00 AM");
INSERT INTO crm_audit_log VALUES("6662","3","5","2019-05-24 02:21:06","Exit Invoice [Invoice No: 120254] updated by Imran  Khan on 24/05/2019 at 02:21 AM");
INSERT INTO crm_audit_log VALUES("6663","3","5","2019-05-24 02:21:40","Exit Invoice [Invoice No: 120255] updated by Imran  Khan on 24/05/2019 at 02:21 AM");
INSERT INTO crm_audit_log VALUES("6664","3","5","2019-05-24 03:45:08","Exit Invoice [Invoice No: 120256] updated by Imran  Khan on 24/05/2019 at 03:45 AM");
INSERT INTO crm_audit_log VALUES("6665","3","5","2019-05-24 03:45:51","Exit Invoice [Invoice No: 120257] updated by Imran  Khan on 24/05/2019 at 03:45 AM");
INSERT INTO crm_audit_log VALUES("6666","3","5","2019-05-24 03:47:32","Exit Invoice [Invoice No: 120258] updated by Imran  Khan on 24/05/2019 at 03:47 AM");
INSERT INTO crm_audit_log VALUES("6667","3","5","2019-05-24 04:18:24","Exit Invoice [Invoice No: 120259] updated by Imran  Khan on 24/05/2019 at 04:18 AM");
INSERT INTO crm_audit_log VALUES("6668","3","5","2019-05-24 04:22:43","Exit Invoice [Invoice No: 120260] updated by Imran  Khan on 24/05/2019 at 04:22 AM");
INSERT INTO crm_audit_log VALUES("6669","2","4","2019-05-24 07:02:30","Entry Invoice [Invoice No: 21767] updated by Yasir  Rahman on 24/05/2019 at 07:02 AM");
INSERT INTO crm_audit_log VALUES("6670","2","4","2019-05-24 07:05:36","Entry Invoice [Invoice No: 21768] updated by Yasir  Rahman on 24/05/2019 at 07:05 AM");
INSERT INTO crm_audit_log VALUES("6671","2","4","2019-05-24 07:07:27","Entry Invoice [Invoice No: 21769] updated by Yasir  Rahman on 24/05/2019 at 07:07 AM");
INSERT INTO crm_audit_log VALUES("6672","2","4","2019-05-24 07:09:31","Entry Invoice [Invoice No: 21770] updated by Yasir  Rahman on 24/05/2019 at 07:09 AM");
INSERT INTO crm_audit_log VALUES("6673","2","6","2019-05-24 09:41:41","Entry Invoice [Invoice No: 21771] updated by ASHRAF  M K on 24/05/2019 at 09:41 AM");
INSERT INTO crm_audit_log VALUES("6674","2","6","2019-05-24 11:07:34","Entry Invoice [Invoice No: 21772] updated by ASHRAF  M K on 24/05/2019 at 11:07 AM");
INSERT INTO crm_audit_log VALUES("6675","3","15","2019-05-24 11:07:51","Exit Invoice [Invoice No: 120261] updated by Abdul Rasheed on 24/05/2019 at 11:07 AM");
INSERT INTO crm_audit_log VALUES("6676","2","6","2019-05-24 11:08:25","Entry Invoice [Invoice No: 21772] updated by ASHRAF  M K on 24/05/2019 at 11:08 AM");
INSERT INTO crm_audit_log VALUES("6677","2","6","2019-05-24 11:08:54","Entry Invoice [Invoice No: 21772] updated by ASHRAF  M K on 24/05/2019 at 11:08 AM");
INSERT INTO crm_audit_log VALUES("6678","3","15","2019-05-24 11:09:08","Exit Invoice [Invoice No: 120262] updated by Abdul Rasheed on 24/05/2019 at 11:09 AM");
INSERT INTO crm_audit_log VALUES("6679","2","6","2019-05-24 11:11:02","Entry Invoice [Invoice No: 21773] updated by ASHRAF  M K on 24/05/2019 at 11:11 AM");
INSERT INTO crm_audit_log VALUES("6680","2","6","2019-05-24 11:14:16","Entry Invoice [Invoice No: 21774] updated by ASHRAF  M K on 24/05/2019 at 11:14 AM");
INSERT INTO crm_audit_log VALUES("6681","2","6","2019-05-24 11:17:48","Entry Invoice [Invoice No: 21775] updated by ASHRAF  M K on 24/05/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("6682","3","15","2019-05-24 11:18:10","Exit Invoice [Invoice No: 120263] updated by Abdul Rasheed on 24/05/2019 at 11:18 AM");
INSERT INTO crm_audit_log VALUES("6683","2","6","2019-05-24 11:44:09","Entry Invoice [Invoice No: 21776] updated by ASHRAF  M K on 24/05/2019 at 11:44 AM");
INSERT INTO crm_audit_log VALUES("6684","3","15","2019-05-24 13:57:44","Exit Invoice [Invoice No: 120264] updated by Abdul Rasheed on 24/05/2019 at 01:57 PM");
INSERT INTO crm_audit_log VALUES("6685","3","15","2019-05-24 15:22:21","Exit Invoice [Invoice No: 120265] updated by Abdul Rasheed on 24/05/2019 at 03:22 PM");
INSERT INTO crm_audit_log VALUES("6686","3","15","2019-05-24 15:23:59","Exit Invoice [Invoice No: 120266] updated by Abdul Rasheed on 24/05/2019 at 03:23 PM");
INSERT INTO crm_audit_log VALUES("6687","3","15","2019-05-24 15:25:41","Exit Invoice [Invoice No: 120267] updated by Abdul Rasheed on 24/05/2019 at 03:25 PM");
INSERT INTO crm_audit_log VALUES("6688","3","6","2019-05-24 15:29:15","Exit Invoice [Invoice No: 120267] updated by ASHRAF  M K on 24/05/2019 at 03:29 PM");
INSERT INTO crm_audit_log VALUES("6689","2","7","2019-05-24 16:17:46","Entry Invoice [Invoice No: 21777] updated by ALSED ABU SHAMA on 24/05/2019 at 04:17 PM");
INSERT INTO crm_audit_log VALUES("6690","3","5","2019-05-24 20:21:32","Exit Invoice [Invoice No: 120268] updated by Imran  Khan on 24/05/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("6691","3","5","2019-05-24 22:49:04","Exit Invoice [Invoice No: 120269] updated by Imran  Khan on 24/05/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("6692","2","4","2019-05-24 23:14:11","Entry Invoice [Invoice No: 21778] updated by Yasir  Rahman on 24/05/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("6693","2","4","2019-05-24 23:15:47","Entry Invoice [Invoice No: 21779] updated by Yasir  Rahman on 24/05/2019 at 11:15 PM");
INSERT INTO crm_audit_log VALUES("6694","3","5","2019-05-24 23:16:57","Exit Invoice [Invoice No: 120270] updated by Imran  Khan on 24/05/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("6695","2","4","2019-05-25 02:37:29","Entry Invoice [Invoice No: 21780] updated by Yasir  Rahman on 25/05/2019 at 02:37 AM");
INSERT INTO crm_audit_log VALUES("6696","2","4","2019-05-25 02:52:32","Entry Invoice [Invoice No: 21781] updated by Yasir  Rahman on 25/05/2019 at 02:52 AM");
INSERT INTO crm_audit_log VALUES("6697","2","4","2019-05-25 02:54:42","Entry Invoice [Invoice No: 21782] updated by Yasir  Rahman on 25/05/2019 at 02:54 AM");
INSERT INTO crm_audit_log VALUES("6698","2","4","2019-05-25 02:56:44","Entry Invoice [Invoice No: 21783] updated by Yasir  Rahman on 25/05/2019 at 02:56 AM");
INSERT INTO crm_audit_log VALUES("6699","3","5","2019-05-25 04:23:52","Exit Invoice [Invoice No: 120271] updated by Imran  Khan on 25/05/2019 at 04:23 AM");
INSERT INTO crm_audit_log VALUES("6700","1","4","2019-05-25 07:35:49","Customer [Customer No: 365] updated by Yasir  Rahman on 25/05/2019 at 07:35 AM");
INSERT INTO crm_audit_log VALUES("6701","2","6","2019-05-25 10:11:19","Entry Invoice [Invoice No: 21771] updated by ASHRAF  M K on 25/05/2019 at 10:11 AM");
INSERT INTO crm_audit_log VALUES("6702","2","7","2019-05-25 11:02:51","Entry Invoice [Invoice No: 21784] updated by ALSED ABU SHAMA on 25/05/2019 at 11:02 AM");
INSERT INTO crm_audit_log VALUES("6703","1","6","2019-05-25 12:00:17","Customer [Customer No: 447] updated by ASHRAF  M K on 25/05/2019 at 12:00 PM");
INSERT INTO crm_audit_log VALUES("6704","2","6","2019-05-25 12:02:34","Entry Invoice [Invoice No: 21785] updated by ASHRAF  M K on 25/05/2019 at 12:02 PM");
INSERT INTO crm_audit_log VALUES("6705","3","15","2019-05-25 12:57:33","Exit Invoice [Invoice No: 120272] updated by Abdul Rasheed on 25/05/2019 at 12:57 PM");
INSERT INTO crm_audit_log VALUES("6706","3","15","2019-05-25 14:35:49","Exit Invoice [Invoice No: 120273] updated by Abdul Rasheed on 25/05/2019 at 02:35 PM");
INSERT INTO crm_audit_log VALUES("6707","3","15","2019-05-25 14:40:57","Exit Invoice [Invoice No: 120274] updated by Abdul Rasheed on 25/05/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("6708","2","7","2019-05-25 16:52:33","Entry Invoice [Invoice No: 21786] updated by ALSED ABU SHAMA on 25/05/2019 at 04:52 PM");
INSERT INTO crm_audit_log VALUES("6709","2","7","2019-05-25 17:52:38","Entry Invoice [Invoice No: 21787] updated by ALSED ABU SHAMA on 25/05/2019 at 05:52 PM");
INSERT INTO crm_audit_log VALUES("6710","3","4","2019-05-25 22:31:14","Exit Invoice [Invoice No: 120275] updated by Yasir  Rahman on 25/05/2019 at 10:31 PM");
INSERT INTO crm_audit_log VALUES("6711","3","4","2019-05-25 23:43:10","Exit Invoice [Invoice No: 120276] updated by Yasir  Rahman on 25/05/2019 at 11:43 PM");
INSERT INTO crm_audit_log VALUES("6712","3","4","2019-05-25 23:58:23","Exit Invoice [Invoice No: 120277] updated by Yasir  Rahman on 25/05/2019 at 11:58 PM");
INSERT INTO crm_audit_log VALUES("6713","3","4","2019-05-26 00:17:58","Exit Invoice [Invoice No: 120278] updated by Yasir  Rahman on 26/05/2019 at 12:17 AM");
INSERT INTO crm_audit_log VALUES("6714","2","4","2019-05-26 00:59:44","Entry Invoice [Invoice No: 21788] updated by Yasir  Rahman on 26/05/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("6715","2","4","2019-05-26 01:03:09","Entry Invoice [Invoice No: 21789] updated by Yasir  Rahman on 26/05/2019 at 01:03 AM");
INSERT INTO crm_audit_log VALUES("6716","3","4","2019-05-26 01:08:14","Exit Invoice [Invoice No: 120279] updated by Yasir  Rahman on 26/05/2019 at 01:08 AM");
INSERT INTO crm_audit_log VALUES("6717","3","4","2019-05-26 01:10:06","Exit Invoice [Invoice No: 120280] updated by Yasir  Rahman on 26/05/2019 at 01:10 AM");
INSERT INTO crm_audit_log VALUES("6718","3","4","2019-05-26 01:45:55","Exit Invoice [Invoice No: 120281] updated by Yasir  Rahman on 26/05/2019 at 01:45 AM");
INSERT INTO crm_audit_log VALUES("6719","3","4","2019-05-26 03:16:18","Exit Invoice [Invoice No: 120282] updated by Yasir  Rahman on 26/05/2019 at 03:16 AM");
INSERT INTO crm_audit_log VALUES("6720","3","4","2019-05-26 03:23:03","Exit Invoice [Invoice No: 120283] updated by Yasir  Rahman on 26/05/2019 at 03:23 AM");
INSERT INTO crm_audit_log VALUES("6721","3","4","2019-05-26 03:23:45","Exit Invoice [Invoice No: 120284] updated by Yasir  Rahman on 26/05/2019 at 03:23 AM");
INSERT INTO crm_audit_log VALUES("6722","3","4","2019-05-26 03:24:26","Exit Invoice [Invoice No: 120285] updated by Yasir  Rahman on 26/05/2019 at 03:24 AM");
INSERT INTO crm_audit_log VALUES("6723","2","4","2019-05-26 06:17:01","Entry Invoice [Invoice No: 21790] updated by Yasir  Rahman on 26/05/2019 at 06:17 AM");
INSERT INTO crm_audit_log VALUES("6724","2","4","2019-05-26 06:19:33","Entry Invoice [Invoice No: 21791] updated by Yasir  Rahman on 26/05/2019 at 06:19 AM");
INSERT INTO crm_audit_log VALUES("6725","2","4","2019-05-26 06:22:10","Entry Invoice [Invoice No: 21792] updated by Yasir  Rahman on 26/05/2019 at 06:22 AM");
INSERT INTO crm_audit_log VALUES("6726","2","4","2019-05-26 06:24:44","Entry Invoice [Invoice No: 21793] updated by Yasir  Rahman on 26/05/2019 at 06:24 AM");
INSERT INTO crm_audit_log VALUES("6727","2","4","2019-05-26 06:32:32","Entry Invoice [Invoice No: 21794] updated by Yasir  Rahman on 26/05/2019 at 06:32 AM");
INSERT INTO crm_audit_log VALUES("6728","2","4","2019-05-26 06:35:35","Entry Invoice [Invoice No: 21795] updated by Yasir  Rahman on 26/05/2019 at 06:35 AM");
INSERT INTO crm_audit_log VALUES("6729","2","4","2019-05-26 06:38:41","Entry Invoice [Invoice No: 21796] updated by Yasir  Rahman on 26/05/2019 at 06:38 AM");
INSERT INTO crm_audit_log VALUES("6730","2","4","2019-05-26 06:41:46","Entry Invoice [Invoice No: 21797] updated by Yasir  Rahman on 26/05/2019 at 06:41 AM");
INSERT INTO crm_audit_log VALUES("6731","2","4","2019-05-26 06:44:46","Entry Invoice [Invoice No: 21798] updated by Yasir  Rahman on 26/05/2019 at 06:44 AM");
INSERT INTO crm_audit_log VALUES("6732","2","4","2019-05-26 06:49:00","Entry Invoice [Invoice No: 21799] updated by Yasir  Rahman on 26/05/2019 at 06:49 AM");
INSERT INTO crm_audit_log VALUES("6733","2","4","2019-05-26 06:51:08","Entry Invoice [Invoice No: 21800] updated by Yasir  Rahman on 26/05/2019 at 06:51 AM");
INSERT INTO crm_audit_log VALUES("6734","2","4","2019-05-26 06:52:53","Entry Invoice [Invoice No: 21801] updated by Yasir  Rahman on 26/05/2019 at 06:52 AM");
INSERT INTO crm_audit_log VALUES("6735","2","6","2019-05-26 07:01:22","Entry Invoice [Invoice No: 21790] updated by ASHRAF  M K on 26/05/2019 at 07:01 AM");
INSERT INTO crm_audit_log VALUES("6736","2","6","2019-05-26 07:01:54","Entry Invoice [Invoice No: 21791] updated by ASHRAF  M K on 26/05/2019 at 07:01 AM");
INSERT INTO crm_audit_log VALUES("6737","2","6","2019-05-26 07:02:30","Entry Invoice [Invoice No: 21792] updated by ASHRAF  M K on 26/05/2019 at 07:02 AM");
INSERT INTO crm_audit_log VALUES("6738","2","6","2019-05-26 07:02:53","Entry Invoice [Invoice No: 21793] updated by ASHRAF  M K on 26/05/2019 at 07:02 AM");
INSERT INTO crm_audit_log VALUES("6739","2","6","2019-05-26 07:03:16","Entry Invoice [Invoice No: 21794] updated by ASHRAF  M K on 26/05/2019 at 07:03 AM");
INSERT INTO crm_audit_log VALUES("6740","2","6","2019-05-26 07:03:44","Entry Invoice [Invoice No: 21795] updated by ASHRAF  M K on 26/05/2019 at 07:03 AM");
INSERT INTO crm_audit_log VALUES("6741","2","6","2019-05-26 07:04:10","Entry Invoice [Invoice No: 21796] updated by ASHRAF  M K on 26/05/2019 at 07:04 AM");
INSERT INTO crm_audit_log VALUES("6742","2","6","2019-05-26 07:04:42","Entry Invoice [Invoice No: 21797] updated by ASHRAF  M K on 26/05/2019 at 07:04 AM");
INSERT INTO crm_audit_log VALUES("6743","3","15","2019-05-26 09:54:55","Exit Invoice [Invoice No: 120286] updated by Abdul Rasheed on 26/05/2019 at 09:54 AM");
INSERT INTO crm_audit_log VALUES("6744","3","15","2019-05-26 10:53:07","Exit Invoice [Invoice No: 120287] updated by Abdul Rasheed on 26/05/2019 at 10:53 AM");
INSERT INTO crm_audit_log VALUES("6745","3","15","2019-05-26 10:54:25","Exit Invoice [Invoice No: 120288] updated by Abdul Rasheed on 26/05/2019 at 10:54 AM");
INSERT INTO crm_audit_log VALUES("6746","3","15","2019-05-26 10:55:22","Exit Invoice [Invoice No: 120289] updated by Abdul Rasheed on 26/05/2019 at 10:55 AM");
INSERT INTO crm_audit_log VALUES("6747","3","15","2019-05-26 12:06:02","Exit Invoice [Invoice No: 120290] updated by Abdul Rasheed on 26/05/2019 at 12:06 PM");
INSERT INTO crm_audit_log VALUES("6748","3","15","2019-05-26 12:08:30","Exit Invoice [Invoice No: 120291] updated by Abdul Rasheed on 26/05/2019 at 12:08 PM");
INSERT INTO crm_audit_log VALUES("6749","2","7","2019-05-26 12:09:34","Entry Invoice [Invoice No: 21802] updated by ALSED ABU SHAMA on 26/05/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("6750","3","15","2019-05-26 12:09:43","Exit Invoice [Invoice No: 120292] updated by Abdul Rasheed on 26/05/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("6751","2","7","2019-05-26 12:24:40","Entry Invoice [Invoice No: 21803] updated by ALSED ABU SHAMA on 26/05/2019 at 12:24 PM");
INSERT INTO crm_audit_log VALUES("6752","3","15","2019-05-26 12:56:04","Exit Invoice [Invoice No: 120293] updated by Abdul Rasheed on 26/05/2019 at 12:56 PM");
INSERT INTO crm_audit_log VALUES("6753","3","15","2019-05-26 13:22:52","Exit Invoice [Invoice No: 120294] updated by Abdul Rasheed on 26/05/2019 at 01:22 PM");
INSERT INTO crm_audit_log VALUES("6754","3","15","2019-05-26 13:56:03","Exit Invoice [Invoice No: 120295] updated by Abdul Rasheed on 26/05/2019 at 01:56 PM");
INSERT INTO crm_audit_log VALUES("6755","3","6","2019-05-26 14:04:36","Exit Invoice [Invoice No: 120277] updated by ASHRAF  M K on 26/05/2019 at 02:04 PM");
INSERT INTO crm_audit_log VALUES("6756","3","6","2019-05-26 14:07:31","Exit Invoice [Invoice No: 120296] updated by ASHRAF  M K on 26/05/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("6757","2","7","2019-05-26 15:28:25","Entry Invoice [Invoice No: 21804] updated by ALSED ABU SHAMA on 26/05/2019 at 03:28 PM");
INSERT INTO crm_audit_log VALUES("6758","3","15","2019-05-26 16:06:08","Exit Invoice [Invoice No: 120297] updated by Abdul Rasheed on 26/05/2019 at 04:06 PM");
INSERT INTO crm_audit_log VALUES("6759","3","4","2019-05-26 17:38:04","Exit Invoice [Invoice No: 120298] updated by Yasir  Rahman on 26/05/2019 at 05:38 PM");
INSERT INTO crm_audit_log VALUES("6760","3","5","2019-05-26 21:21:13","Exit Invoice [Invoice No: 120299] updated by Imran  Khan on 26/05/2019 at 09:21 PM");
INSERT INTO crm_audit_log VALUES("6761","3","5","2019-05-26 21:22:05","Exit Invoice [Invoice No: 120300] updated by Imran  Khan on 26/05/2019 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("6762","3","5","2019-05-26 21:22:43","Exit Invoice [Invoice No: 120301] updated by Imran  Khan on 26/05/2019 at 09:22 PM");
INSERT INTO crm_audit_log VALUES("6763","3","5","2019-05-26 21:23:23","Exit Invoice [Invoice No: 120302] updated by Imran  Khan on 26/05/2019 at 09:23 PM");
INSERT INTO crm_audit_log VALUES("6764","2","4","2019-05-26 22:23:44","Entry Invoice [Invoice No: 21805] updated by Yasir  Rahman on 26/05/2019 at 10:23 PM");
INSERT INTO crm_audit_log VALUES("6765","3","5","2019-05-27 00:33:06","Exit Invoice [Invoice No: 120303] updated by Imran  Khan on 27/05/2019 at 12:33 AM");
INSERT INTO crm_audit_log VALUES("6766","3","5","2019-05-27 00:50:36","Exit Invoice [Invoice No: 120304] updated by Imran  Khan on 27/05/2019 at 12:50 AM");
INSERT INTO crm_audit_log VALUES("6767","2","4","2019-05-27 01:13:19","Entry Invoice [Invoice No: 21806] updated by Yasir  Rahman on 27/05/2019 at 01:13 AM");
INSERT INTO crm_audit_log VALUES("6768","3","5","2019-05-27 01:33:51","Exit Invoice [Invoice No: 120305] updated by Imran  Khan on 27/05/2019 at 01:33 AM");
INSERT INTO crm_audit_log VALUES("6769","2","4","2019-05-27 02:49:02","Entry Invoice [Invoice No: 21807] updated by Yasir  Rahman on 27/05/2019 at 02:49 AM");
INSERT INTO crm_audit_log VALUES("6770","3","4","2019-05-27 07:23:15","Exit Invoice [Invoice No: 120306] updated by Yasir  Rahman on 27/05/2019 at 07:23 AM");
INSERT INTO crm_audit_log VALUES("6771","2","4","2019-05-27 07:32:24","Entry Invoice [Invoice No: 21808] updated by Yasir  Rahman on 27/05/2019 at 07:32 AM");
INSERT INTO crm_audit_log VALUES("6772","2","4","2019-05-27 07:36:20","Entry Invoice [Invoice No: 21809] updated by Yasir  Rahman on 27/05/2019 at 07:36 AM");
INSERT INTO crm_audit_log VALUES("6773","2","4","2019-05-27 07:39:50","Entry Invoice [Invoice No: 21810] updated by Yasir  Rahman on 27/05/2019 at 07:39 AM");
INSERT INTO crm_audit_log VALUES("6774","3","4","2019-05-27 09:23:07","Exit Invoice [Invoice No: 120307] updated by Yasir  Rahman on 27/05/2019 at 09:23 AM");
INSERT INTO crm_audit_log VALUES("6775","3","4","2019-05-27 09:39:25","Exit Invoice [Invoice No: 120308] updated by Yasir  Rahman on 27/05/2019 at 09:39 AM");
INSERT INTO crm_audit_log VALUES("6776","2","7","2019-05-27 10:01:42","Entry Invoice [Invoice No: 21811] updated by ALSED ABU SHAMA on 27/05/2019 at 10:01 AM");
INSERT INTO crm_audit_log VALUES("6777","2","6","2019-05-27 11:19:01","Entry Invoice [Invoice No: 21808] updated by ASHRAF  M K on 27/05/2019 at 11:19 AM");
INSERT INTO crm_audit_log VALUES("6778","3","4","2019-05-27 12:11:42","Exit Invoice [Invoice No: 120309] updated by Yasir  Rahman on 27/05/2019 at 12:11 PM");
INSERT INTO crm_audit_log VALUES("6779","3","4","2019-05-27 12:14:08","Exit Invoice [Invoice No: 120310] updated by Yasir  Rahman on 27/05/2019 at 12:14 PM");
INSERT INTO crm_audit_log VALUES("6780","3","4","2019-05-27 12:15:20","Exit Invoice [Invoice No: 120311] updated by Yasir  Rahman on 27/05/2019 at 12:15 PM");
INSERT INTO crm_audit_log VALUES("6781","2","7","2019-05-27 12:48:49","Entry Invoice [Invoice No: 21812] updated by ALSED ABU SHAMA on 27/05/2019 at 12:48 PM");
INSERT INTO crm_audit_log VALUES("6782","2","7","2019-05-27 14:04:59","Entry Invoice [Invoice No: 21813] updated by ALSED ABU SHAMA on 27/05/2019 at 02:04 PM");
INSERT INTO crm_audit_log VALUES("6783","3","4","2019-05-27 19:57:16","Exit Invoice [Invoice No: 120312] updated by Yasir  Rahman on 27/05/2019 at 07:57 PM");
INSERT INTO crm_audit_log VALUES("6784","3","4","2019-05-27 19:58:23","Exit Invoice [Invoice No: 120313] updated by Yasir  Rahman on 27/05/2019 at 07:58 PM");
INSERT INTO crm_audit_log VALUES("6785","3","4","2019-05-27 22:15:07","Exit Invoice [Invoice No: 120314] updated by Yasir  Rahman on 27/05/2019 at 10:15 PM");
INSERT INTO crm_audit_log VALUES("6786","3","4","2019-05-27 22:42:12","Exit Invoice [Invoice No: 120315] updated by Yasir  Rahman on 27/05/2019 at 10:42 PM");
INSERT INTO crm_audit_log VALUES("6787","3","4","2019-05-27 22:42:59","Exit Invoice [Invoice No: 120316] updated by Yasir  Rahman on 27/05/2019 at 10:42 PM");
INSERT INTO crm_audit_log VALUES("6788","2","4","2019-05-27 23:19:10","Entry Invoice [Invoice No: 21814] updated by Yasir  Rahman on 27/05/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("6789","3","5","2019-05-27 23:36:46","Exit Invoice [Invoice No: 120317] updated by Imran  Khan on 27/05/2019 at 11:36 PM");
INSERT INTO crm_audit_log VALUES("6790","3","5","2019-05-27 23:51:54","Exit Invoice [Invoice No: 120318] updated by Imran  Khan on 27/05/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("6791","2","4","2019-05-28 00:19:17","Entry Invoice [Invoice No: 21815] updated by Yasir  Rahman on 28/05/2019 at 12:19 AM");
INSERT INTO crm_audit_log VALUES("6792","2","4","2019-05-28 00:20:20","Entry Invoice [Invoice No: 21816] updated by Yasir  Rahman on 28/05/2019 at 12:20 AM");
INSERT INTO crm_audit_log VALUES("6793","3","5","2019-05-28 03:09:39","Exit Invoice [Invoice No: 120319] updated by Imran  Khan on 28/05/2019 at 03:09 AM");
INSERT INTO crm_audit_log VALUES("6794","3","15","2019-05-28 11:37:02","Exit Invoice [Invoice No: 120320] updated by Abdul Rasheed on 28/05/2019 at 11:37 AM");
INSERT INTO crm_audit_log VALUES("6795","2","7","2019-05-28 12:16:15","Entry Invoice [Invoice No: 21817] updated by ALSED ABU SHAMA on 28/05/2019 at 12:16 PM");
INSERT INTO crm_audit_log VALUES("6796","2","7","2019-05-28 12:21:00","Entry Invoice [Invoice No: 21818] updated by ALSED ABU SHAMA on 28/05/2019 at 12:21 PM");
INSERT INTO crm_audit_log VALUES("6797","2","7","2019-05-28 12:21:42","Entry Invoice [Invoice No: 21819] updated by ALSED ABU SHAMA on 28/05/2019 at 12:21 PM");
INSERT INTO crm_audit_log VALUES("6798","2","7","2019-05-28 12:22:18","Entry Invoice [Invoice No: 21820] updated by ALSED ABU SHAMA on 28/05/2019 at 12:22 PM");
INSERT INTO crm_audit_log VALUES("6799","2","7","2019-05-28 12:22:53","Entry Invoice [Invoice No: 21821] updated by ALSED ABU SHAMA on 28/05/2019 at 12:22 PM");
INSERT INTO crm_audit_log VALUES("6800","2","7","2019-05-28 12:23:29","Entry Invoice [Invoice No: 21822] updated by ALSED ABU SHAMA on 28/05/2019 at 12:23 PM");
INSERT INTO crm_audit_log VALUES("6801","2","7","2019-05-28 12:24:05","Entry Invoice [Invoice No: 21823] updated by ALSED ABU SHAMA on 28/05/2019 at 12:24 PM");
INSERT INTO crm_audit_log VALUES("6802","2","7","2019-05-28 12:35:27","Entry Invoice [Invoice No: 21824] updated by ALSED ABU SHAMA on 28/05/2019 at 12:35 PM");
INSERT INTO crm_audit_log VALUES("6803","2","7","2019-05-28 12:59:27","Entry Invoice [Invoice No: 21825] updated by ALSED ABU SHAMA on 28/05/2019 at 12:59 PM");
INSERT INTO crm_audit_log VALUES("6804","3","4","2019-05-28 15:40:08","Exit Invoice [Invoice No: 120321] updated by Yasir  Rahman on 28/05/2019 at 03:40 PM");
INSERT INTO crm_audit_log VALUES("6805","3","4","2019-05-28 17:24:06","Exit Invoice [Invoice No: 120322] updated by Yasir  Rahman on 28/05/2019 at 05:24 PM");
INSERT INTO crm_audit_log VALUES("6806","3","4","2019-05-28 17:24:58","Exit Invoice [Invoice No: 120323] updated by Yasir  Rahman on 28/05/2019 at 05:24 PM");
INSERT INTO crm_audit_log VALUES("6807","3","4","2019-05-28 17:43:28","Exit Invoice [Invoice No: 120324] updated by Yasir  Rahman on 28/05/2019 at 05:43 PM");
INSERT INTO crm_audit_log VALUES("6808","2","7","2019-05-28 18:29:16","Entry Invoice [Invoice No: 21826] updated by ALSED ABU SHAMA on 28/05/2019 at 06:29 PM");
INSERT INTO crm_audit_log VALUES("6809","3","4","2019-05-28 19:57:53","Exit Invoice [Invoice No: 120325] updated by Yasir  Rahman on 28/05/2019 at 07:57 PM");
INSERT INTO crm_audit_log VALUES("6810","3","4","2019-05-28 20:10:43","Exit Invoice [Invoice No: 120326] updated by Yasir  Rahman on 28/05/2019 at 08:10 PM");
INSERT INTO crm_audit_log VALUES("6811","2","4","2019-05-28 20:55:50","Entry Invoice [Invoice No: 21827] updated by Yasir  Rahman on 28/05/2019 at 08:55 PM");
INSERT INTO crm_audit_log VALUES("6812","2","4","2019-05-28 20:57:03","Entry Invoice [Invoice No: 21828] updated by Yasir  Rahman on 28/05/2019 at 08:57 PM");
INSERT INTO crm_audit_log VALUES("6813","2","4","2019-05-28 21:32:06","Entry Invoice [Invoice No: 21829] updated by Yasir  Rahman on 28/05/2019 at 09:32 PM");
INSERT INTO crm_audit_log VALUES("6814","3","5","2019-05-28 21:33:39","Exit Invoice [Invoice No: 120327] updated by Imran  Khan on 28/05/2019 at 09:33 PM");
INSERT INTO crm_audit_log VALUES("6815","2","4","2019-05-28 21:46:47","Entry Invoice [Invoice No: 21830] updated by Yasir  Rahman on 28/05/2019 at 09:46 PM");
INSERT INTO crm_audit_log VALUES("6816","2","4","2019-05-28 23:02:47","Entry Invoice [Invoice No: 21831] updated by Yasir  Rahman on 28/05/2019 at 11:02 PM");
INSERT INTO crm_audit_log VALUES("6817","3","5","2019-05-28 23:08:47","Exit Invoice [Invoice No: 120328] updated by Imran  Khan on 28/05/2019 at 11:08 PM");
INSERT INTO crm_audit_log VALUES("6818","3","5","2019-05-29 00:00:38","Exit Invoice [Invoice No: 120329] updated by Imran  Khan on 29/05/2019 at 12:00 AM");
INSERT INTO crm_audit_log VALUES("6819","3","5","2019-05-29 00:03:16","Exit Invoice [Invoice No: 120330] updated by Imran  Khan on 29/05/2019 at 12:03 AM");
INSERT INTO crm_audit_log VALUES("6820","2","4","2019-05-29 00:04:37","Entry Invoice [Invoice No: 21832] updated by Yasir  Rahman on 29/05/2019 at 12:04 AM");
INSERT INTO crm_audit_log VALUES("6821","3","5","2019-05-29 00:39:13","Exit Invoice [Invoice No: 120331] updated by Imran  Khan on 29/05/2019 at 12:39 AM");
INSERT INTO crm_audit_log VALUES("6822","2","4","2019-05-29 00:41:27","Entry Invoice [Invoice No: 21833] updated by Yasir  Rahman on 29/05/2019 at 12:41 AM");
INSERT INTO crm_audit_log VALUES("6823","2","4","2019-05-29 00:57:14","Entry Invoice [Invoice No: 21834] updated by Yasir  Rahman on 29/05/2019 at 12:57 AM");
INSERT INTO crm_audit_log VALUES("6824","2","4","2019-05-29 01:28:01","Entry Invoice [Invoice No: 21835] updated by Yasir  Rahman on 29/05/2019 at 01:28 AM");
INSERT INTO crm_audit_log VALUES("6825","3","5","2019-05-29 02:06:08","Exit Invoice [Invoice No: 120332] updated by Imran  Khan on 29/05/2019 at 02:06 AM");
INSERT INTO crm_audit_log VALUES("6826","2","4","2019-05-29 02:41:44","Entry Invoice [Invoice No: 21836] updated by Yasir  Rahman on 29/05/2019 at 02:41 AM");
INSERT INTO crm_audit_log VALUES("6827","3","5","2019-05-29 04:12:55","Exit Invoice [Invoice No: 120333] updated by Imran  Khan on 29/05/2019 at 04:12 AM");
INSERT INTO crm_audit_log VALUES("6828","2","4","2019-05-29 05:04:58","Entry Invoice [Invoice No: 21837] updated by Yasir  Rahman on 29/05/2019 at 05:04 AM");
INSERT INTO crm_audit_log VALUES("6829","3","5","2019-05-29 07:48:53","Exit Invoice [Invoice No: 120334] updated by Imran  Khan on 29/05/2019 at 07:48 AM");
INSERT INTO crm_audit_log VALUES("6830","3","15","2019-05-29 10:04:26","Exit Invoice [Invoice No: 120335] updated by Abdul Rasheed on 29/05/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("6831","3","15","2019-05-29 10:25:07","Exit Invoice [Invoice No: 120336] updated by Abdul Rasheed on 29/05/2019 at 10:25 AM");
INSERT INTO crm_audit_log VALUES("6832","3","15","2019-05-29 11:17:09","Exit Invoice [Invoice No: 120337] updated by Abdul Rasheed on 29/05/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("6833","2","7","2019-05-29 11:21:02","Entry Invoice [Invoice No: 21838] updated by ALSED ABU SHAMA on 29/05/2019 at 11:21 AM");
INSERT INTO crm_audit_log VALUES("6834","2","7","2019-05-29 11:27:35","Entry Invoice [Invoice No: 21839] updated by ALSED ABU SHAMA on 29/05/2019 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("6835","2","7","2019-05-29 11:29:03","Entry Invoice [Invoice No: 21840] updated by ALSED ABU SHAMA on 29/05/2019 at 11:29 AM");
INSERT INTO crm_audit_log VALUES("6836","3","15","2019-05-29 11:42:01","Exit Invoice [Invoice No: 120338] updated by Abdul Rasheed on 29/05/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("6837","3","15","2019-05-29 12:22:09","Exit Invoice [Invoice No: 120339] updated by Abdul Rasheed on 29/05/2019 at 12:22 PM");
INSERT INTO crm_audit_log VALUES("6838","3","15","2019-05-29 12:29:01","Exit Invoice [Invoice No: 120340] updated by Abdul Rasheed on 29/05/2019 at 12:29 PM");
INSERT INTO crm_audit_log VALUES("6839","2","7","2019-05-29 13:23:19","Entry Invoice [Invoice No: 21841] updated by ALSED ABU SHAMA on 29/05/2019 at 01:23 PM");
INSERT INTO crm_audit_log VALUES("6840","2","7","2019-05-29 13:28:18","Entry Invoice [Invoice No: 21842] updated by ALSED ABU SHAMA on 29/05/2019 at 01:28 PM");
INSERT INTO crm_audit_log VALUES("6841","1","15","2019-05-29 14:48:52","Customer [Customer No: 448] updated by Abdul Rasheed on 29/05/2019 at 02:48 PM");
INSERT INTO crm_audit_log VALUES("6842","3","15","2019-05-29 14:50:20","Exit Invoice [Invoice No: 120341] updated by Abdul Rasheed on 29/05/2019 at 02:50 PM");
INSERT INTO crm_audit_log VALUES("6843","2","7","2019-05-29 15:35:04","Entry Invoice [Invoice No: 21843] updated by ALSED ABU SHAMA on 29/05/2019 at 03:35 PM");
INSERT INTO crm_audit_log VALUES("6844","2","7","2019-05-29 15:38:37","Entry Invoice [Invoice No: 21844] updated by ALSED ABU SHAMA on 29/05/2019 at 03:38 PM");
INSERT INTO crm_audit_log VALUES("6845","2","7","2019-05-29 15:52:55","Entry Invoice [Invoice No: 21845] updated by ALSED ABU SHAMA on 29/05/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("6846","2","7","2019-05-29 15:53:43","Entry Invoice [Invoice No: 21846] updated by ALSED ABU SHAMA on 29/05/2019 at 03:53 PM");
INSERT INTO crm_audit_log VALUES("6847","2","7","2019-05-29 15:54:41","Entry Invoice [Invoice No: 21847] updated by ALSED ABU SHAMA on 29/05/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("6848","2","7","2019-05-29 15:55:14","Entry Invoice [Invoice No: 21848] updated by ALSED ABU SHAMA on 29/05/2019 at 03:55 PM");
INSERT INTO crm_audit_log VALUES("6849","3","15","2019-05-29 15:58:10","Exit Invoice [Invoice No: 120342] updated by Abdul Rasheed on 29/05/2019 at 03:58 PM");
INSERT INTO crm_audit_log VALUES("6850","3","4","2019-05-29 16:46:28","Exit Invoice [Invoice No: 120343] updated by Yasir  Rahman on 29/05/2019 at 04:46 PM");
INSERT INTO crm_audit_log VALUES("6851","2","6","2019-05-29 17:09:09","Entry Invoice [Invoice No: 21849] updated by ASHRAF  M K on 29/05/2019 at 05:09 PM");
INSERT INTO crm_audit_log VALUES("6852","2","7","2019-05-29 17:45:58","Entry Invoice [Invoice No: 21850] updated by ALSED ABU SHAMA on 29/05/2019 at 05:45 PM");
INSERT INTO crm_audit_log VALUES("6853","2","4","2019-05-29 21:50:59","Entry Invoice [Invoice No: 21851] updated by Yasir  Rahman on 29/05/2019 at 09:50 PM");
INSERT INTO crm_audit_log VALUES("6854","3","4","2019-05-29 22:20:15","Exit Invoice [Invoice No: 120344] updated by Yasir  Rahman on 29/05/2019 at 10:20 PM");
INSERT INTO crm_audit_log VALUES("6855","3","5","2019-05-29 23:28:43","Exit Invoice [Invoice No: 120345] updated by Imran  Khan on 29/05/2019 at 11:28 PM");
INSERT INTO crm_audit_log VALUES("6856","2","4","2019-05-29 23:30:48","Entry Invoice [Invoice No: 21852] updated by Yasir  Rahman on 29/05/2019 at 11:30 PM");
INSERT INTO crm_audit_log VALUES("6857","2","4","2019-05-30 00:14:45","Entry Invoice [Invoice No: 21853] updated by Yasir  Rahman on 30/05/2019 at 12:14 AM");
INSERT INTO crm_audit_log VALUES("6858","2","4","2019-05-30 00:16:44","Entry Invoice [Invoice No: 21854] updated by Yasir  Rahman on 30/05/2019 at 12:16 AM");
INSERT INTO crm_audit_log VALUES("6859","2","4","2019-05-30 00:18:28","Entry Invoice [Invoice No: 21855] updated by Yasir  Rahman on 30/05/2019 at 12:18 AM");
INSERT INTO crm_audit_log VALUES("6860","2","4","2019-05-30 00:20:18","Entry Invoice [Invoice No: 21856] updated by Yasir  Rahman on 30/05/2019 at 12:20 AM");
INSERT INTO crm_audit_log VALUES("6861","2","4","2019-05-30 00:21:50","Entry Invoice [Invoice No: 21857] updated by Yasir  Rahman on 30/05/2019 at 12:21 AM");
INSERT INTO crm_audit_log VALUES("6862","3","5","2019-05-30 00:37:46","Exit Invoice [Invoice No: 120346] updated by Imran  Khan on 30/05/2019 at 12:37 AM");
INSERT INTO crm_audit_log VALUES("6863","3","5","2019-05-30 00:38:23","Exit Invoice [Invoice No: 120347] updated by Imran  Khan on 30/05/2019 at 12:38 AM");
INSERT INTO crm_audit_log VALUES("6864","2","4","2019-05-30 02:06:16","Entry Invoice [Invoice No: 21858] updated by Yasir  Rahman on 30/05/2019 at 02:06 AM");
INSERT INTO crm_audit_log VALUES("6865","3","5","2019-05-30 04:15:10","Exit Invoice [Invoice No: 120348] updated by Imran  Khan on 30/05/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("6866","3","5","2019-05-30 05:25:24","Exit Invoice [Invoice No: 120349] updated by Imran  Khan on 30/05/2019 at 05:25 AM");
INSERT INTO crm_audit_log VALUES("6867","3","5","2019-05-30 05:44:31","Exit Invoice [Invoice No: 120350] updated by Imran  Khan on 30/05/2019 at 05:44 AM");
INSERT INTO crm_audit_log VALUES("6868","3","5","2019-05-30 06:28:46","Exit Invoice [Invoice No: 120351] updated by Imran  Khan on 30/05/2019 at 06:28 AM");
INSERT INTO crm_audit_log VALUES("6869","3","5","2019-05-30 06:31:20","Exit Invoice [Invoice No: 120352] updated by Imran  Khan on 30/05/2019 at 06:31 AM");
INSERT INTO crm_audit_log VALUES("6870","2","4","2019-05-30 06:33:52","Entry Invoice [Invoice No: 21859] updated by Yasir  Rahman on 30/05/2019 at 06:33 AM");
INSERT INTO crm_audit_log VALUES("6871","3","6","2019-05-30 08:25:22","Exit Invoice [Invoice No: 120352] updated by ASHRAF  M K on 30/05/2019 at 08:25 AM");
INSERT INTO crm_audit_log VALUES("6872","3","6","2019-05-30 09:02:57","Exit Invoice [Invoice No: 120353] updated by ASHRAF  M K on 30/05/2019 at 09:02 AM");
INSERT INTO crm_audit_log VALUES("6873","3","6","2019-05-30 09:05:35","Exit Invoice [Invoice No: 120354] updated by ASHRAF  M K on 30/05/2019 at 09:05 AM");
INSERT INTO crm_audit_log VALUES("6874","2","6","2019-05-30 10:51:33","Entry Invoice [Invoice No: 21860] updated by ASHRAF  M K on 30/05/2019 at 10:51 AM");
INSERT INTO crm_audit_log VALUES("6875","2","6","2019-05-30 13:31:06","Entry Invoice [Invoice No: 21808] updated by ASHRAF  M K on 30/05/2019 at 01:31 PM");
INSERT INTO crm_audit_log VALUES("6876","2","7","2019-05-30 13:47:19","Entry Invoice [Invoice No: 21861] updated by ALSED ABU SHAMA on 30/05/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("6877","2","7","2019-05-30 13:47:54","Entry Invoice [Invoice No: 21862] updated by ALSED ABU SHAMA on 30/05/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("6878","2","6","2019-05-30 14:24:43","Entry Invoice [Invoice No: 21863] updated by ASHRAF  M K on 30/05/2019 at 02:24 PM");
INSERT INTO crm_audit_log VALUES("6879","3","15","2019-05-30 14:48:01","Exit Invoice [Invoice No: 120355] updated by Abdul Rasheed on 30/05/2019 at 02:48 PM");
INSERT INTO crm_audit_log VALUES("6880","3","15","2019-05-30 14:50:51","Exit Invoice [Invoice No: 120356] updated by Abdul Rasheed on 30/05/2019 at 02:50 PM");
INSERT INTO crm_audit_log VALUES("6881","2","6","2019-05-30 15:46:34","Entry Invoice [Invoice No: 21864] updated by ASHRAF  M K on 30/05/2019 at 03:46 PM");
INSERT INTO crm_audit_log VALUES("6882","3","4","2019-05-30 15:59:29","Exit Invoice [Invoice No: 120357] updated by Yasir  Rahman on 30/05/2019 at 03:59 PM");
INSERT INTO crm_audit_log VALUES("6883","3","4","2019-05-30 20:01:55","Exit Invoice [Invoice No: 120358] updated by Yasir  Rahman on 30/05/2019 at 08:01 PM");
INSERT INTO crm_audit_log VALUES("6884","3","4","2019-05-30 20:02:52","Exit Invoice [Invoice No: 120359] updated by Yasir  Rahman on 30/05/2019 at 08:02 PM");
INSERT INTO crm_audit_log VALUES("6885","2","4","2019-05-30 21:32:22","Entry Invoice [Invoice No: 21865] updated by Yasir  Rahman on 30/05/2019 at 09:32 PM");
INSERT INTO crm_audit_log VALUES("6886","2","4","2019-05-30 21:39:54","Entry Invoice [Invoice No: 21866] updated by Yasir  Rahman on 30/05/2019 at 09:39 PM");
INSERT INTO crm_audit_log VALUES("6887","2","4","2019-05-30 21:44:17","Entry Invoice [Invoice No: 21867] updated by Yasir  Rahman on 30/05/2019 at 09:44 PM");
INSERT INTO crm_audit_log VALUES("6888","3","5","2019-05-30 22:58:33","Exit Invoice [Invoice No: 120360] updated by Imran  Khan on 30/05/2019 at 10:58 PM");
INSERT INTO crm_audit_log VALUES("6889","3","5","2019-05-30 22:59:15","Exit Invoice [Invoice No: 120361] updated by Imran  Khan on 30/05/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("6890","3","5","2019-05-30 22:59:49","Exit Invoice [Invoice No: 120362] updated by Imran  Khan on 30/05/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("6891","3","5","2019-05-30 23:00:32","Exit Invoice [Invoice No: 120363] updated by Imran  Khan on 30/05/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("6892","3","5","2019-05-31 00:59:04","Exit Invoice [Invoice No: 120364] updated by Imran  Khan on 31/05/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("6893","2","4","2019-05-31 01:26:23","Entry Invoice [Invoice No: 21868] updated by Yasir  Rahman on 31/05/2019 at 01:26 AM");
INSERT INTO crm_audit_log VALUES("6894","2","4","2019-05-31 01:30:04","Entry Invoice [Invoice No: 21869] updated by Yasir  Rahman on 31/05/2019 at 01:30 AM");
INSERT INTO crm_audit_log VALUES("6895","3","5","2019-05-31 06:03:30","Exit Invoice [Invoice No: 120365] updated by Imran  Khan on 31/05/2019 at 06:03 AM");
INSERT INTO crm_audit_log VALUES("6896","2","4","2019-05-31 06:45:02","Entry Invoice [Invoice No: 21870] updated by Yasir  Rahman on 31/05/2019 at 06:45 AM");
INSERT INTO crm_audit_log VALUES("6897","2","4","2019-05-31 06:50:10","Entry Invoice [Invoice No: 21871] updated by Yasir  Rahman on 31/05/2019 at 06:50 AM");
INSERT INTO crm_audit_log VALUES("6898","2","4","2019-05-31 06:53:32","Entry Invoice [Invoice No: 21872] updated by Yasir  Rahman on 31/05/2019 at 06:53 AM");
INSERT INTO crm_audit_log VALUES("6899","2","4","2019-05-31 06:56:24","Entry Invoice [Invoice No: 21873] updated by Yasir  Rahman on 31/05/2019 at 06:56 AM");
INSERT INTO crm_audit_log VALUES("6900","2","4","2019-05-31 07:01:30","Entry Invoice [Invoice No: 21874] updated by Yasir  Rahman on 31/05/2019 at 07:01 AM");
INSERT INTO crm_audit_log VALUES("6901","2","7","2019-05-31 10:32:42","Entry Invoice [Invoice No: 21875] updated by ALSED ABU SHAMA on 31/05/2019 at 10:32 AM");
INSERT INTO crm_audit_log VALUES("6902","3","15","2019-05-31 11:09:12","Exit Invoice [Invoice No: 120366] updated by Abdul Rasheed on 31/05/2019 at 11:09 AM");
INSERT INTO crm_audit_log VALUES("6903","3","15","2019-05-31 11:10:20","Exit Invoice [Invoice No: 120367] updated by Abdul Rasheed on 31/05/2019 at 11:10 AM");
INSERT INTO crm_audit_log VALUES("6904","3","15","2019-05-31 11:23:09","Exit Invoice [Invoice No: 120368] updated by Abdul Rasheed on 31/05/2019 at 11:23 AM");
INSERT INTO crm_audit_log VALUES("6905","3","15","2019-05-31 11:29:49","Exit Invoice [Invoice No: 120369] updated by Abdul Rasheed on 31/05/2019 at 11:29 AM");
INSERT INTO crm_audit_log VALUES("6906","3","15","2019-05-31 11:31:11","Exit Invoice [Invoice No: 120370] updated by Abdul Rasheed on 31/05/2019 at 11:31 AM");
INSERT INTO crm_audit_log VALUES("6907","2","7","2019-05-31 13:36:59","Entry Invoice [Invoice No: 21876] updated by ALSED ABU SHAMA on 31/05/2019 at 01:36 PM");
INSERT INTO crm_audit_log VALUES("6908","3","4","2019-05-31 17:01:17","Exit Invoice [Invoice No: 120371] updated by Yasir  Rahman on 31/05/2019 at 05:01 PM");
INSERT INTO crm_audit_log VALUES("6909","2","7","2019-05-31 18:29:52","Entry Invoice [Invoice No: 21877] updated by ALSED ABU SHAMA on 31/05/2019 at 06:29 PM");
INSERT INTO crm_audit_log VALUES("6910","2","4","2019-05-31 22:50:40","Entry Invoice [Invoice No: 21878] updated by Yasir  Rahman on 31/05/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("6911","2","4","2019-06-01 00:34:52","Entry Invoice [Invoice No: 21879] updated by Yasir  Rahman on 01/06/2019 at 12:34 AM");
INSERT INTO crm_audit_log VALUES("6912","2","4","2019-06-01 00:44:19","Entry Invoice [Invoice No: 21880] updated by Yasir  Rahman on 01/06/2019 at 12:44 AM");
INSERT INTO crm_audit_log VALUES("6913","2","4","2019-06-01 00:47:31","Entry Invoice [Invoice No: 21881] updated by Yasir  Rahman on 01/06/2019 at 12:47 AM");
INSERT INTO crm_audit_log VALUES("6914","2","4","2019-06-01 02:56:32","Entry Invoice [Invoice No: 21882] updated by Yasir  Rahman on 01/06/2019 at 02:56 AM");
INSERT INTO crm_audit_log VALUES("6915","2","4","2019-06-01 02:58:28","Entry Invoice [Invoice No: 21883] updated by Yasir  Rahman on 01/06/2019 at 02:58 AM");
INSERT INTO crm_audit_log VALUES("6916","2","4","2019-06-01 03:06:52","Entry Invoice [Invoice No: 21884] updated by Yasir  Rahman on 01/06/2019 at 03:06 AM");
INSERT INTO crm_audit_log VALUES("6917","3","5","2019-06-01 03:49:01","Exit Invoice [Invoice No: 120372] updated by Imran  Khan on 01/06/2019 at 03:49 AM");
INSERT INTO crm_audit_log VALUES("6918","3","4","2019-06-01 09:05:33","Exit Invoice [Invoice No: 120373] updated by Yasir  Rahman on 01/06/2019 at 09:05 AM");
INSERT INTO crm_audit_log VALUES("6919","2","7","2019-06-01 10:16:50","Entry Invoice [Invoice No: 21885] updated by ALSED ABU SHAMA on 01/06/2019 at 10:16 AM");
INSERT INTO crm_audit_log VALUES("6920","2","7","2019-06-01 11:21:18","Entry Invoice [Invoice No: 21886] updated by ALSED ABU SHAMA on 01/06/2019 at 11:21 AM");
INSERT INTO crm_audit_log VALUES("6921","2","7","2019-06-01 11:28:47","Entry Invoice [Invoice No: 21887] updated by ALSED ABU SHAMA on 01/06/2019 at 11:28 AM");
INSERT INTO crm_audit_log VALUES("6922","3","15","2019-06-01 11:34:47","Exit Invoice [Invoice No: 120374] updated by Abdul Rasheed on 01/06/2019 at 11:34 AM");
INSERT INTO crm_audit_log VALUES("6923","2","7","2019-06-01 14:53:19","Entry Invoice [Invoice No: 21888] updated by ALSED ABU SHAMA on 01/06/2019 at 02:53 PM");
INSERT INTO crm_audit_log VALUES("6924","2","7","2019-06-01 14:54:55","Entry Invoice [Invoice No: 21889] updated by ALSED ABU SHAMA on 01/06/2019 at 02:54 PM");
INSERT INTO crm_audit_log VALUES("6925","2","7","2019-06-01 17:42:03","Entry Invoice [Invoice No: 21890] updated by ALSED ABU SHAMA on 01/06/2019 at 05:42 PM");
INSERT INTO crm_audit_log VALUES("6926","2","7","2019-06-01 18:04:55","Entry Invoice [Invoice No: 21891] updated by ALSED ABU SHAMA on 01/06/2019 at 06:04 PM");
INSERT INTO crm_audit_log VALUES("6927","2","4","2019-06-02 00:42:14","Entry Invoice [Invoice No: 21892] updated by Yasir  Rahman on 02/06/2019 at 12:42 AM");
INSERT INTO crm_audit_log VALUES("6928","2","4","2019-06-02 02:03:13","Entry Invoice [Invoice No: 21893] updated by Yasir  Rahman on 02/06/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("6929","2","4","2019-06-02 02:06:53","Entry Invoice [Invoice No: 21894] updated by Yasir  Rahman on 02/06/2019 at 02:06 AM");
INSERT INTO crm_audit_log VALUES("6930","2","4","2019-06-02 02:09:28","Entry Invoice [Invoice No: 21895] updated by Yasir  Rahman on 02/06/2019 at 02:09 AM");
INSERT INTO crm_audit_log VALUES("6931","2","4","2019-06-02 02:46:45","Entry Invoice [Invoice No: 21896] updated by Yasir  Rahman on 02/06/2019 at 02:46 AM");
INSERT INTO crm_audit_log VALUES("6932","3","5","2019-06-02 04:02:41","Exit Invoice [Invoice No: 120375] updated by Imran  Khan on 02/06/2019 at 04:02 AM");
INSERT INTO crm_audit_log VALUES("6933","3","4","2019-06-02 10:30:54","Exit Invoice [Invoice No: 120376] updated by Yasir  Rahman on 02/06/2019 at 10:30 AM");
INSERT INTO crm_audit_log VALUES("6934","2","7","2019-06-02 10:31:06","Entry Invoice [Invoice No: 21897] updated by ALSED ABU SHAMA on 02/06/2019 at 10:31 AM");
INSERT INTO crm_audit_log VALUES("6935","3","4","2019-06-02 10:59:37","Exit Invoice [Invoice No: 120377] updated by Yasir  Rahman on 02/06/2019 at 10:59 AM");
INSERT INTO crm_audit_log VALUES("6936","2","7","2019-06-02 14:15:22","Entry Invoice [Invoice No: 21898] updated by ALSED ABU SHAMA on 02/06/2019 at 02:15 PM");
INSERT INTO crm_audit_log VALUES("6937","3","15","2019-06-02 14:25:27","Exit Invoice [Invoice No: 120378] updated by Abdul Rasheed on 02/06/2019 at 02:25 PM");
INSERT INTO crm_audit_log VALUES("6938","2","7","2019-06-02 14:46:09","Entry Invoice [Invoice No: 21899] updated by ALSED ABU SHAMA on 02/06/2019 at 02:46 PM");
INSERT INTO crm_audit_log VALUES("6939","2","7","2019-06-02 14:51:08","Entry Invoice [Invoice No: 21900] updated by ALSED ABU SHAMA on 02/06/2019 at 02:51 PM");
INSERT INTO crm_audit_log VALUES("6940","2","7","2019-06-02 15:02:55","Entry Invoice [Invoice No: 21901] updated by ALSED ABU SHAMA on 02/06/2019 at 03:02 PM");
INSERT INTO crm_audit_log VALUES("6941","3","7","2019-06-02 17:20:18","Exit Invoice [Invoice No: 120379] updated by ALSED ABU SHAMA on 02/06/2019 at 05:20 PM");
INSERT INTO crm_audit_log VALUES("6942","3","7","2019-06-02 17:25:38","Exit Invoice [Invoice No: 120380] updated by ALSED ABU SHAMA on 02/06/2019 at 05:25 PM");
INSERT INTO crm_audit_log VALUES("6943","3","7","2019-06-02 17:27:59","Exit Invoice [Invoice No: 120381] updated by ALSED ABU SHAMA on 02/06/2019 at 05:27 PM");
INSERT INTO crm_audit_log VALUES("6944","3","7","2019-06-02 17:34:24","Exit Invoice [Invoice No: 120382] updated by ALSED ABU SHAMA on 02/06/2019 at 05:34 PM");
INSERT INTO crm_audit_log VALUES("6945","3","4","2019-06-02 21:12:42","Exit Invoice [Invoice No: 120383] updated by Yasir  Rahman on 02/06/2019 at 09:12 PM");
INSERT INTO crm_audit_log VALUES("6946","3","6","2019-06-02 22:40:42","Exit Invoice [Invoice No: 120377] updated by ASHRAF  M K on 02/06/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("6947","2","15","2019-06-02 23:10:15","Entry Invoice [Invoice No: 21902] updated by Abdul Rasheed on 02/06/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("6948","3","5","2019-06-03 01:23:26","Exit Invoice [Invoice No: 120384] updated by Imran  Khan on 03/06/2019 at 01:23 AM");
INSERT INTO crm_audit_log VALUES("6949","2","4","2019-06-03 01:39:47","Entry Invoice [Invoice No: 21903] updated by Yasir  Rahman on 03/06/2019 at 01:39 AM");
INSERT INTO crm_audit_log VALUES("6950","3","5","2019-06-03 02:24:33","Exit Invoice [Invoice No: 120385] updated by Imran  Khan on 03/06/2019 at 02:24 AM");
INSERT INTO crm_audit_log VALUES("6951","2","4","2019-06-03 05:48:25","Entry Invoice [Invoice No: 21904] updated by Yasir  Rahman on 03/06/2019 at 05:48 AM");
INSERT INTO crm_audit_log VALUES("6952","3","4","2019-06-03 06:31:11","Exit Invoice [Invoice No: 120386] updated by Yasir  Rahman on 03/06/2019 at 06:31 AM");
INSERT INTO crm_audit_log VALUES("6953","2","7","2019-06-03 09:04:35","Entry Invoice [Invoice No: 21905] updated by ALSED ABU SHAMA on 03/06/2019 at 09:04 AM");
INSERT INTO crm_audit_log VALUES("6954","2","7","2019-06-03 09:05:20","Entry Invoice [Invoice No: 21906] updated by ALSED ABU SHAMA on 03/06/2019 at 09:05 AM");
INSERT INTO crm_audit_log VALUES("6955","2","7","2019-06-03 09:06:37","Entry Invoice [Invoice No: 21907] updated by ALSED ABU SHAMA on 03/06/2019 at 09:06 AM");
INSERT INTO crm_audit_log VALUES("6956","2","7","2019-06-03 09:07:25","Entry Invoice [Invoice No: 21908] updated by ALSED ABU SHAMA on 03/06/2019 at 09:07 AM");
INSERT INTO crm_audit_log VALUES("6957","2","7","2019-06-03 09:08:09","Entry Invoice [Invoice No: 21909] updated by ALSED ABU SHAMA on 03/06/2019 at 09:08 AM");
INSERT INTO crm_audit_log VALUES("6958","2","7","2019-06-03 09:09:02","Entry Invoice [Invoice No: 21910] updated by ALSED ABU SHAMA on 03/06/2019 at 09:09 AM");
INSERT INTO crm_audit_log VALUES("6959","2","7","2019-06-03 09:10:02","Entry Invoice [Invoice No: 21911] updated by ALSED ABU SHAMA on 03/06/2019 at 09:10 AM");
INSERT INTO crm_audit_log VALUES("6960","2","7","2019-06-03 09:10:51","Entry Invoice [Invoice No: 21912] updated by ALSED ABU SHAMA on 03/06/2019 at 09:10 AM");
INSERT INTO crm_audit_log VALUES("6961","2","7","2019-06-03 09:11:37","Entry Invoice [Invoice No: 21913] updated by ALSED ABU SHAMA on 03/06/2019 at 09:11 AM");
INSERT INTO crm_audit_log VALUES("6962","2","7","2019-06-03 09:12:20","Entry Invoice [Invoice No: 21914] updated by ALSED ABU SHAMA on 03/06/2019 at 09:12 AM");
INSERT INTO crm_audit_log VALUES("6963","2","7","2019-06-03 09:13:27","Entry Invoice [Invoice No: 21915] updated by ALSED ABU SHAMA on 03/06/2019 at 09:13 AM");
INSERT INTO crm_audit_log VALUES("6964","2","7","2019-06-03 09:14:35","Entry Invoice [Invoice No: 21916] updated by ALSED ABU SHAMA on 03/06/2019 at 09:14 AM");
INSERT INTO crm_audit_log VALUES("6965","3","6","2019-06-03 10:43:50","Exit Invoice [Invoice No: 120378] updated by ASHRAF  M K on 03/06/2019 at 10:43 AM");
INSERT INTO crm_audit_log VALUES("6966","3","15","2019-06-03 11:25:19","Exit Invoice [Invoice No: 120387] updated by Abdul Rasheed on 03/06/2019 at 11:25 AM");
INSERT INTO crm_audit_log VALUES("6967","3","15","2019-06-03 11:26:54","Exit Invoice [Invoice No: 120388] updated by Abdul Rasheed on 03/06/2019 at 11:26 AM");
INSERT INTO crm_audit_log VALUES("6968","2","6","2019-06-03 12:01:19","Entry Invoice [Invoice No: 21917] updated by ASHRAF  M K on 03/06/2019 at 12:01 PM");
INSERT INTO crm_audit_log VALUES("6969","2","7","2019-06-03 12:02:21","Entry Invoice [Invoice No: 21918] updated by ALSED ABU SHAMA on 03/06/2019 at 12:02 PM");
INSERT INTO crm_audit_log VALUES("6970","2","7","2019-06-03 12:03:06","Entry Invoice [Invoice No: 21919] updated by ALSED ABU SHAMA on 03/06/2019 at 12:03 PM");
INSERT INTO crm_audit_log VALUES("6971","2","6","2019-06-03 15:30:19","Entry Invoice [Invoice No: 21920] updated by ASHRAF  M K on 03/06/2019 at 03:30 PM");
INSERT INTO crm_audit_log VALUES("6972","3","4","2019-06-03 17:38:34","Exit Invoice [Invoice No: 120389] updated by Yasir  Rahman on 03/06/2019 at 05:38 PM");
INSERT INTO crm_audit_log VALUES("6973","2","4","2019-06-03 21:40:18","Entry Invoice [Invoice No: 21921] updated by Yasir  Rahman on 03/06/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("6974","2","4","2019-06-03 22:42:16","Entry Invoice [Invoice No: 21922] updated by Yasir  Rahman on 03/06/2019 at 10:42 PM");
INSERT INTO crm_audit_log VALUES("6975","2","4","2019-06-03 23:26:38","Entry Invoice [Invoice No: 21923] updated by Yasir  Rahman on 03/06/2019 at 11:26 PM");
INSERT INTO crm_audit_log VALUES("6976","2","4","2019-06-03 23:29:17","Entry Invoice [Invoice No: 21924] updated by Yasir  Rahman on 03/06/2019 at 11:29 PM");
INSERT INTO crm_audit_log VALUES("6977","2","4","2019-06-03 23:31:20","Entry Invoice [Invoice No: 21925] updated by Yasir  Rahman on 03/06/2019 at 11:31 PM");
INSERT INTO crm_audit_log VALUES("6978","2","4","2019-06-04 03:16:14","Entry Invoice [Invoice No: 21926] updated by Yasir  Rahman on 04/06/2019 at 03:16 AM");
INSERT INTO crm_audit_log VALUES("6979","2","7","2019-06-04 16:33:44","Entry Invoice [Invoice No: 21927] updated by ALSED ABU SHAMA on 04/06/2019 at 04:33 PM");
INSERT INTO crm_audit_log VALUES("6980","2","7","2019-06-04 16:35:30","Entry Invoice [Invoice No: 21928] updated by ALSED ABU SHAMA on 04/06/2019 at 04:35 PM");
INSERT INTO crm_audit_log VALUES("6981","2","7","2019-06-04 16:36:24","Entry Invoice [Invoice No: 21929] updated by ALSED ABU SHAMA on 04/06/2019 at 04:36 PM");
INSERT INTO crm_audit_log VALUES("6982","3","5","2019-06-04 21:12:33","Exit Invoice [Invoice No: 120390] updated by Imran  Khan on 04/06/2019 at 09:12 PM");
INSERT INTO crm_audit_log VALUES("6983","2","4","2019-06-05 02:17:19","Entry Invoice [Invoice No: 21930] updated by Yasir  Rahman on 05/06/2019 at 02:17 AM");
INSERT INTO crm_audit_log VALUES("6984","3","15","2019-06-05 14:58:56","Exit Invoice [Invoice No: 120391] updated by Abdul Rasheed on 05/06/2019 at 02:58 PM");
INSERT INTO crm_audit_log VALUES("6985","2","6","2019-06-05 19:24:17","Entry Invoice [Invoice No: 21931] updated by ASHRAF  M K on 05/06/2019 at 07:24 PM");
INSERT INTO crm_audit_log VALUES("6986","2","6","2019-06-05 19:25:17","Entry Invoice [Invoice No: 21932] updated by ASHRAF  M K on 05/06/2019 at 07:25 PM");
INSERT INTO crm_audit_log VALUES("6987","2","6","2019-06-05 19:26:20","Entry Invoice [Invoice No: 21933] updated by ASHRAF  M K on 05/06/2019 at 07:26 PM");
INSERT INTO crm_audit_log VALUES("6988","2","4","2019-06-05 21:37:51","Entry Invoice [Invoice No: 21934] updated by Yasir  Rahman on 05/06/2019 at 09:37 PM");
INSERT INTO crm_audit_log VALUES("6989","2","4","2019-06-05 22:39:59","Entry Invoice [Invoice No: 21935] updated by Yasir  Rahman on 05/06/2019 at 10:39 PM");
INSERT INTO crm_audit_log VALUES("6990","2","4","2019-06-05 22:40:00","Entry Invoice [Invoice No: 21936] updated by Yasir  Rahman on 05/06/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("6991","2","4","2019-06-05 22:40:01","Entry Invoice [Invoice No: 21937] updated by Yasir  Rahman on 05/06/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("6992","2","4","2019-06-05 22:40:02","Entry Invoice [Invoice No: 21938] updated by Yasir  Rahman on 05/06/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("6993","2","4","2019-06-05 22:40:02","Entry Invoice [Invoice No: 21939] updated by Yasir  Rahman on 05/06/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("6994","2","4","2019-06-05 22:40:03","Entry Invoice [Invoice No: 21940] updated by Yasir  Rahman on 05/06/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("6995","2","4","2019-06-05 22:40:04","Entry Invoice [Invoice No: 21941] updated by Yasir  Rahman on 05/06/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("6996","3","5","2019-06-06 00:39:44","Exit Invoice [Invoice No: 120392] updated by Imran  Khan on 06/06/2019 at 12:39 AM");
INSERT INTO crm_audit_log VALUES("6997","3","5","2019-06-06 00:59:10","Exit Invoice [Invoice No: 120393] updated by Imran  Khan on 06/06/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("6998","2","6","2019-06-06 08:33:42","Entry Invoice [Invoice No: 21935] updated by ASHRAF  M K on 06/06/2019 at 08:33 AM");
INSERT INTO crm_audit_log VALUES("6999","2","6","2019-06-06 08:35:20","Entry Invoice [Invoice No: 21936] updated by ASHRAF  M K on 06/06/2019 at 08:35 AM");
INSERT INTO crm_audit_log VALUES("7000","2","6","2019-06-06 08:35:36","Entry Invoice [Invoice No: 21937] updated by ASHRAF  M K on 06/06/2019 at 08:35 AM");
INSERT INTO crm_audit_log VALUES("7001","2","6","2019-06-06 08:36:19","Entry Invoice [Invoice No: 21938] updated by ASHRAF  M K on 06/06/2019 at 08:36 AM");
INSERT INTO crm_audit_log VALUES("7002","2","6","2019-06-06 08:36:48","Entry Invoice [Invoice No: 21939] updated by ASHRAF  M K on 06/06/2019 at 08:36 AM");
INSERT INTO crm_audit_log VALUES("7003","2","6","2019-06-06 08:37:00","Entry Invoice [Invoice No: 21940] updated by ASHRAF  M K on 06/06/2019 at 08:37 AM");
INSERT INTO crm_audit_log VALUES("7004","2","6","2019-06-06 08:37:15","Entry Invoice [Invoice No: 21941] updated by ASHRAF  M K on 06/06/2019 at 08:37 AM");
INSERT INTO crm_audit_log VALUES("7005","2","6","2019-06-06 11:19:50","Entry Invoice [Invoice No: 21936] updated by ASHRAF  M K on 06/06/2019 at 11:19 AM");
INSERT INTO crm_audit_log VALUES("7006","2","6","2019-06-06 12:24:22","Entry Invoice [Invoice No: 21937] updated by ASHRAF  M K on 06/06/2019 at 12:24 PM");
INSERT INTO crm_audit_log VALUES("7007","3","4","2019-06-06 16:35:34","Exit Invoice [Invoice No: 120394] updated by Yasir  Rahman on 06/06/2019 at 04:35 PM");
INSERT INTO crm_audit_log VALUES("7008","3","4","2019-06-06 16:43:50","Exit Invoice [Invoice No: 120395] updated by Yasir  Rahman on 06/06/2019 at 04:43 PM");
INSERT INTO crm_audit_log VALUES("7009","2","6","2019-06-06 17:14:07","Entry Invoice [Invoice No: 21938] updated by ASHRAF  M K on 06/06/2019 at 05:14 PM");
INSERT INTO crm_audit_log VALUES("7010","2","6","2019-06-06 17:38:48","Entry Invoice [Invoice No: 21939] updated by ASHRAF  M K on 06/06/2019 at 05:38 PM");
INSERT INTO crm_audit_log VALUES("7011","2","6","2019-06-06 19:20:32","Entry Invoice [Invoice No: 21940] updated by ASHRAF  M K on 06/06/2019 at 07:20 PM");
INSERT INTO crm_audit_log VALUES("7012","2","6","2019-06-06 19:21:34","Entry Invoice [Invoice No: 21941] updated by ASHRAF  M K on 06/06/2019 at 07:21 PM");
INSERT INTO crm_audit_log VALUES("7013","2","6","2019-06-06 19:22:36","Entry Invoice [Invoice No: 21942] updated by ASHRAF  M K on 06/06/2019 at 07:22 PM");
INSERT INTO crm_audit_log VALUES("7014","2","4","2019-06-07 07:08:52","Entry Invoice [Invoice No: 21943] updated by Yasir  Rahman on 07/06/2019 at 07:08 AM");
INSERT INTO crm_audit_log VALUES("7015","2","4","2019-06-07 07:10:04","Entry Invoice [Invoice No: 21944] updated by Yasir  Rahman on 07/06/2019 at 07:10 AM");
INSERT INTO crm_audit_log VALUES("7016","2","4","2019-06-07 07:11:10","Entry Invoice [Invoice No: 21945] updated by Yasir  Rahman on 07/06/2019 at 07:11 AM");
INSERT INTO crm_audit_log VALUES("7017","2","4","2019-06-07 07:12:19","Entry Invoice [Invoice No: 21946] updated by Yasir  Rahman on 07/06/2019 at 07:12 AM");
INSERT INTO crm_audit_log VALUES("7018","2","4","2019-06-07 07:13:53","Entry Invoice [Invoice No: 21947] updated by Yasir  Rahman on 07/06/2019 at 07:13 AM");
INSERT INTO crm_audit_log VALUES("7019","2","4","2019-06-07 07:15:00","Entry Invoice [Invoice No: 21948] updated by Yasir  Rahman on 07/06/2019 at 07:15 AM");
INSERT INTO crm_audit_log VALUES("7020","2","4","2019-06-07 07:16:19","Entry Invoice [Invoice No: 21949] updated by Yasir  Rahman on 07/06/2019 at 07:16 AM");
INSERT INTO crm_audit_log VALUES("7021","2","4","2019-06-07 07:17:26","Entry Invoice [Invoice No: 21950] updated by Yasir  Rahman on 07/06/2019 at 07:17 AM");
INSERT INTO crm_audit_log VALUES("7022","2","4","2019-06-07 07:18:47","Entry Invoice [Invoice No: 21951] updated by Yasir  Rahman on 07/06/2019 at 07:18 AM");
INSERT INTO crm_audit_log VALUES("7023","2","4","2019-06-07 07:20:02","Entry Invoice [Invoice No: 21952] updated by Yasir  Rahman on 07/06/2019 at 07:20 AM");
INSERT INTO crm_audit_log VALUES("7024","2","4","2019-06-07 07:20:58","Entry Invoice [Invoice No: 21953] updated by Yasir  Rahman on 07/06/2019 at 07:20 AM");
INSERT INTO crm_audit_log VALUES("7025","3","4","2019-06-07 08:51:15","Exit Invoice [Invoice No: 120396] updated by Yasir  Rahman on 07/06/2019 at 08:51 AM");
INSERT INTO crm_audit_log VALUES("7026","3","4","2019-06-07 13:42:41","Exit Invoice [Invoice No: 120397] updated by Yasir  Rahman on 07/06/2019 at 01:42 PM");
INSERT INTO crm_audit_log VALUES("7027","3","4","2019-06-07 13:43:35","Exit Invoice [Invoice No: 120398] updated by Yasir  Rahman on 07/06/2019 at 01:43 PM");
INSERT INTO crm_audit_log VALUES("7028","3","4","2019-06-07 13:44:29","Exit Invoice [Invoice No: 120399] updated by Yasir  Rahman on 07/06/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("7029","2","7","2019-06-07 15:43:56","Entry Invoice [Invoice No: 21954] updated by ALSED ABU SHAMA on 07/06/2019 at 03:43 PM");
INSERT INTO crm_audit_log VALUES("7030","3","4","2019-06-07 19:06:03","Exit Invoice [Invoice No: 120400] updated by Yasir  Rahman on 07/06/2019 at 07:06 PM");
INSERT INTO crm_audit_log VALUES("7031","2","4","2019-06-07 20:43:43","Entry Invoice [Invoice No: 21955] updated by Yasir  Rahman on 07/06/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("7032","3","4","2019-06-08 02:14:54","Exit Invoice [Invoice No: 120401] updated by Yasir  Rahman on 08/06/2019 at 02:14 AM");
INSERT INTO crm_audit_log VALUES("7033","3","4","2019-06-08 06:59:58","Exit Invoice [Invoice No: 120402] updated by Yasir  Rahman on 08/06/2019 at 06:59 AM");
INSERT INTO crm_audit_log VALUES("7034","3","4","2019-06-08 07:01:03","Exit Invoice [Invoice No: 120403] updated by Yasir  Rahman on 08/06/2019 at 07:01 AM");
INSERT INTO crm_audit_log VALUES("7035","1","6","2019-06-08 09:08:59","Customer [Customer No: 445] updated by ASHRAF  M K on 08/06/2019 at 09:08 AM");
INSERT INTO crm_audit_log VALUES("7036","1","6","2019-06-08 09:09:16","Customer [Customer No: 444] updated by ASHRAF  M K on 08/06/2019 at 09:09 AM");
INSERT INTO crm_audit_log VALUES("7037","2","7","2019-06-08 15:07:41","Entry Invoice [Invoice No: 21956] updated by ALSED ABU SHAMA on 08/06/2019 at 03:07 PM");
INSERT INTO crm_audit_log VALUES("7038","2","7","2019-06-08 17:12:20","Entry Invoice [Invoice No: 21957] updated by ALSED ABU SHAMA on 08/06/2019 at 05:12 PM");
INSERT INTO crm_audit_log VALUES("7039","2","7","2019-06-08 17:14:32","Entry Invoice [Invoice No: 21958] updated by ALSED ABU SHAMA on 08/06/2019 at 05:14 PM");
INSERT INTO crm_audit_log VALUES("7040","3","4","2019-06-08 21:16:15","Exit Invoice [Invoice No: 120404] updated by Yasir  Rahman on 08/06/2019 at 09:16 PM");
INSERT INTO crm_audit_log VALUES("7041","3","4","2019-06-08 21:17:18","Exit Invoice [Invoice No: 120405] updated by Yasir  Rahman on 08/06/2019 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("7042","2","4","2019-06-08 23:11:00","Entry Invoice [Invoice No: 21959] updated by Yasir  Rahman on 08/06/2019 at 11:11 PM");
INSERT INTO crm_audit_log VALUES("7043","2","4","2019-06-08 23:12:02","Entry Invoice [Invoice No: 21960] updated by Yasir  Rahman on 08/06/2019 at 11:12 PM");
INSERT INTO crm_audit_log VALUES("7044","3","4","2019-06-08 23:34:54","Exit Invoice [Invoice No: 120406] updated by Yasir  Rahman on 08/06/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("7045","3","4","2019-06-09 09:15:21","Exit Invoice [Invoice No: 120407] updated by Yasir  Rahman on 09/06/2019 at 09:15 AM");
INSERT INTO crm_audit_log VALUES("7046","3","15","2019-06-09 12:37:29","Exit Invoice [Invoice No: 120408] updated by Abdul Rasheed on 09/06/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("7047","3","6","2019-06-09 12:44:32","Exit Invoice [Invoice No: 120408] updated by ASHRAF  M K on 09/06/2019 at 12:44 PM");
INSERT INTO crm_audit_log VALUES("7048","3","15","2019-06-09 16:04:24","Exit Invoice [Invoice No: 120409] updated by Abdul Rasheed on 09/06/2019 at 04:04 PM");
INSERT INTO crm_audit_log VALUES("7049","2","7","2019-06-09 16:04:48","Entry Invoice [Invoice No: 21961] updated by ALSED ABU SHAMA on 09/06/2019 at 04:04 PM");
INSERT INTO crm_audit_log VALUES("7050","3","4","2019-06-09 19:23:57","Exit Invoice [Invoice No: 120410] updated by Yasir  Rahman on 09/06/2019 at 07:23 PM");
INSERT INTO crm_audit_log VALUES("7051","2","4","2019-06-09 21:20:55","Entry Invoice [Invoice No: 21962] updated by Yasir  Rahman on 09/06/2019 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("7052","2","4","2019-06-09 21:23:29","Entry Invoice [Invoice No: 21963] updated by Yasir  Rahman on 09/06/2019 at 09:23 PM");
INSERT INTO crm_audit_log VALUES("7053","2","4","2019-06-09 21:28:42","Entry Invoice [Invoice No: 21964] updated by Yasir  Rahman on 09/06/2019 at 09:28 PM");
INSERT INTO crm_audit_log VALUES("7054","2","4","2019-06-09 21:31:51","Entry Invoice [Invoice No: 21965] updated by Yasir  Rahman on 09/06/2019 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("7055","3","5","2019-06-10 02:16:05","Exit Invoice [Invoice No: 120411] updated by Imran  Khan on 10/06/2019 at 02:16 AM");
INSERT INTO crm_audit_log VALUES("7056","3","5","2019-06-10 02:17:18","Exit Invoice [Invoice No: 120412] updated by Imran  Khan on 10/06/2019 at 02:17 AM");
INSERT INTO crm_audit_log VALUES("7057","3","5","2019-06-10 02:55:00","Exit Invoice [Invoice No: 120413] updated by Imran  Khan on 10/06/2019 at 02:55 AM");
INSERT INTO crm_audit_log VALUES("7058","3","5","2019-06-10 02:55:42","Exit Invoice [Invoice No: 120414] updated by Imran  Khan on 10/06/2019 at 02:55 AM");
INSERT INTO crm_audit_log VALUES("7059","3","5","2019-06-10 04:04:34","Exit Invoice [Invoice No: 120415] updated by Imran  Khan on 10/06/2019 at 04:04 AM");
INSERT INTO crm_audit_log VALUES("7060","3","5","2019-06-10 06:14:47","Exit Invoice [Invoice No: 120416] updated by Imran  Khan on 10/06/2019 at 06:14 AM");
INSERT INTO crm_audit_log VALUES("7061","3","5","2019-06-10 06:15:57","Exit Invoice [Invoice No: 120417] updated by Imran  Khan on 10/06/2019 at 06:15 AM");
INSERT INTO crm_audit_log VALUES("7062","3","6","2019-06-10 09:13:00","Exit Invoice [Invoice No: 120413] updated by ASHRAF  M K on 10/06/2019 at 09:13 AM");
INSERT INTO crm_audit_log VALUES("7063","3","6","2019-06-10 09:19:36","Exit Invoice [Invoice No: 120418] updated by ASHRAF  M K on 10/06/2019 at 09:19 AM");
INSERT INTO crm_audit_log VALUES("7064","3","6","2019-06-10 09:20:47","Exit Invoice [Invoice No: 120417] updated by ASHRAF  M K on 10/06/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("7065","2","7","2019-06-10 12:20:52","Entry Invoice [Invoice No: 21966] updated by ALSED ABU SHAMA on 10/06/2019 at 12:20 PM");
INSERT INTO crm_audit_log VALUES("7066","3","4","2019-06-10 12:42:01","Exit Invoice [Invoice No: 120419] updated by Yasir  Rahman on 10/06/2019 at 12:42 PM");
INSERT INTO crm_audit_log VALUES("7067","3","4","2019-06-10 12:49:06","Exit Invoice [Invoice No: 120420] updated by Yasir  Rahman on 10/06/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("7068","3","15","2019-06-10 14:21:44","Exit Invoice [Invoice No: 120421] updated by Abdul Rasheed on 10/06/2019 at 02:21 PM");
INSERT INTO crm_audit_log VALUES("7069","3","15","2019-06-10 14:28:40","Exit Invoice [Invoice No: 120422] updated by Abdul Rasheed on 10/06/2019 at 02:28 PM");
INSERT INTO crm_audit_log VALUES("7070","2","7","2019-06-10 15:48:48","Entry Invoice [Invoice No: 21967] updated by ALSED ABU SHAMA on 10/06/2019 at 03:48 PM");
INSERT INTO crm_audit_log VALUES("7071","3","15","2019-06-10 15:56:10","Exit Invoice [Invoice No: 120423] updated by Abdul Rasheed on 10/06/2019 at 03:56 PM");
INSERT INTO crm_audit_log VALUES("7072","2","7","2019-06-10 18:08:38","Entry Invoice [Invoice No: 21968] updated by ALSED ABU SHAMA on 10/06/2019 at 06:08 PM");
INSERT INTO crm_audit_log VALUES("7073","3","4","2019-06-10 19:48:10","Exit Invoice [Invoice No: 120424] updated by Yasir  Rahman on 10/06/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("7074","3","4","2019-06-10 19:49:14","Exit Invoice [Invoice No: 120425] updated by Yasir  Rahman on 10/06/2019 at 07:49 PM");
INSERT INTO crm_audit_log VALUES("7075","3","4","2019-06-10 21:38:31","Exit Invoice [Invoice No: 120426] updated by Yasir  Rahman on 10/06/2019 at 09:38 PM");
INSERT INTO crm_audit_log VALUES("7076","3","4","2019-06-10 21:40:12","Exit Invoice [Invoice No: 120427] updated by Yasir  Rahman on 10/06/2019 at 09:40 PM");
INSERT INTO crm_audit_log VALUES("7077","3","4","2019-06-10 22:10:04","Exit Invoice [Invoice No: 120428] updated by Yasir  Rahman on 10/06/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("7078","3","4","2019-06-10 22:10:47","Exit Invoice [Invoice No: 120429] updated by Yasir  Rahman on 10/06/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("7079","3","4","2019-06-10 23:01:54","Exit Invoice [Invoice No: 120430] updated by Yasir  Rahman on 10/06/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("7080","3","4","2019-06-10 23:16:42","Exit Invoice [Invoice No: 120431] updated by Yasir  Rahman on 10/06/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("7081","3","4","2019-06-10 23:17:28","Exit Invoice [Invoice No: 120432] updated by Yasir  Rahman on 10/06/2019 at 11:17 PM");
INSERT INTO crm_audit_log VALUES("7082","3","4","2019-06-10 23:18:04","Exit Invoice [Invoice No: 120433] updated by Yasir  Rahman on 10/06/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("7083","2","4","2019-06-10 23:48:57","Entry Invoice [Invoice No: 21969] updated by Yasir  Rahman on 10/06/2019 at 11:48 PM");
INSERT INTO crm_audit_log VALUES("7084","2","4","2019-06-10 23:50:01","Entry Invoice [Invoice No: 21970] updated by Yasir  Rahman on 10/06/2019 at 11:50 PM");
INSERT INTO crm_audit_log VALUES("7085","2","4","2019-06-11 01:14:48","Entry Invoice [Invoice No: 21971] updated by Yasir  Rahman on 11/06/2019 at 01:14 AM");
INSERT INTO crm_audit_log VALUES("7086","2","4","2019-06-11 02:48:33","Entry Invoice [Invoice No: 21972] updated by Yasir  Rahman on 11/06/2019 at 02:48 AM");
INSERT INTO crm_audit_log VALUES("7087","2","4","2019-06-11 02:55:14","Entry Invoice [Invoice No: 21973] updated by Yasir  Rahman on 11/06/2019 at 02:55 AM");
INSERT INTO crm_audit_log VALUES("7088","2","4","2019-06-11 03:07:44","Entry Invoice [Invoice No: 21974] updated by Yasir  Rahman on 11/06/2019 at 03:07 AM");
INSERT INTO crm_audit_log VALUES("7089","2","4","2019-06-11 03:11:11","Entry Invoice [Invoice No: 21975] updated by Yasir  Rahman on 11/06/2019 at 03:11 AM");
INSERT INTO crm_audit_log VALUES("7090","3","5","2019-06-11 03:34:07","Exit Invoice [Invoice No: 120434] updated by Imran  Khan on 11/06/2019 at 03:34 AM");
INSERT INTO crm_audit_log VALUES("7091","3","5","2019-06-11 04:07:10","Exit Invoice [Invoice No: 120435] updated by Imran  Khan on 11/06/2019 at 04:07 AM");
INSERT INTO crm_audit_log VALUES("7092","1","15","2019-06-11 09:12:28","Customer [Customer No: 449] updated by Abdul Rasheed on 11/06/2019 at 09:12 AM");
INSERT INTO crm_audit_log VALUES("7093","3","15","2019-06-11 09:14:30","Exit Invoice [Invoice No: 120436] updated by Abdul Rasheed on 11/06/2019 at 09:14 AM");
INSERT INTO crm_audit_log VALUES("7094","3","15","2019-06-11 09:31:58","Exit Invoice [Invoice No: 120437] updated by Abdul Rasheed on 11/06/2019 at 09:31 AM");
INSERT INTO crm_audit_log VALUES("7095","3","15","2019-06-11 09:33:40","Exit Invoice [Invoice No: 120438] updated by Abdul Rasheed on 11/06/2019 at 09:33 AM");
INSERT INTO crm_audit_log VALUES("7096","3","15","2019-06-11 10:26:28","Exit Invoice [Invoice No: 120439] updated by Abdul Rasheed on 11/06/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("7097","3","15","2019-06-11 11:06:17","Exit Invoice [Invoice No: 120440] updated by Abdul Rasheed on 11/06/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("7098","3","15","2019-06-11 12:14:44","Exit Invoice [Invoice No: 120441] updated by Abdul Rasheed on 11/06/2019 at 12:14 PM");
INSERT INTO crm_audit_log VALUES("7099","2","7","2019-06-11 15:42:12","Entry Invoice [Invoice No: 21976] updated by ALSED ABU SHAMA on 11/06/2019 at 03:42 PM");
INSERT INTO crm_audit_log VALUES("7100","3","15","2019-06-11 15:56:59","Exit Invoice [Invoice No: 120442] updated by Abdul Rasheed on 11/06/2019 at 03:56 PM");
INSERT INTO crm_audit_log VALUES("7101","3","15","2019-06-11 16:13:07","Exit Invoice [Invoice No: 120443] updated by Abdul Rasheed on 11/06/2019 at 04:13 PM");
INSERT INTO crm_audit_log VALUES("7102","3","15","2019-06-11 16:14:19","Exit Invoice [Invoice No: 120444] updated by Abdul Rasheed on 11/06/2019 at 04:14 PM");
INSERT INTO crm_audit_log VALUES("7103","3","4","2019-06-11 16:49:28","Exit Invoice [Invoice No: 120445] updated by Yasir  Rahman on 11/06/2019 at 04:49 PM");
INSERT INTO crm_audit_log VALUES("7104","2","7","2019-06-11 17:16:27","Entry Invoice [Invoice No: 21977] updated by ALSED ABU SHAMA on 11/06/2019 at 05:16 PM");
INSERT INTO crm_audit_log VALUES("7105","3","4","2019-06-11 17:28:22","Exit Invoice [Invoice No: 120446] updated by Yasir  Rahman on 11/06/2019 at 05:28 PM");
INSERT INTO crm_audit_log VALUES("7106","2","7","2019-06-11 17:56:43","Entry Invoice [Invoice No: 21978] updated by ALSED ABU SHAMA on 11/06/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("7107","2","7","2019-06-11 17:57:27","Entry Invoice [Invoice No: 21979] updated by ALSED ABU SHAMA on 11/06/2019 at 05:57 PM");
INSERT INTO crm_audit_log VALUES("7108","2","7","2019-06-11 17:58:02","Entry Invoice [Invoice No: 21980] updated by ALSED ABU SHAMA on 11/06/2019 at 05:58 PM");
INSERT INTO crm_audit_log VALUES("7109","2","7","2019-06-11 17:58:42","Entry Invoice [Invoice No: 21981] updated by ALSED ABU SHAMA on 11/06/2019 at 05:58 PM");
INSERT INTO crm_audit_log VALUES("7110","2","7","2019-06-11 17:59:17","Entry Invoice [Invoice No: 21982] updated by ALSED ABU SHAMA on 11/06/2019 at 05:59 PM");
INSERT INTO crm_audit_log VALUES("7111","2","7","2019-06-11 17:59:52","Entry Invoice [Invoice No: 21983] updated by ALSED ABU SHAMA on 11/06/2019 at 05:59 PM");
INSERT INTO crm_audit_log VALUES("7112","2","4","2019-06-11 20:53:33","Entry Invoice [Invoice No: 21984] updated by Yasir  Rahman on 11/06/2019 at 08:53 PM");
INSERT INTO crm_audit_log VALUES("7113","2","4","2019-06-11 20:55:27","Entry Invoice [Invoice No: 21985] updated by Yasir  Rahman on 11/06/2019 at 08:55 PM");
INSERT INTO crm_audit_log VALUES("7114","3","4","2019-06-11 21:07:04","Exit Invoice [Invoice No: 120447] updated by Yasir  Rahman on 11/06/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("7115","2","4","2019-06-11 22:46:48","Entry Invoice [Invoice No: 21986] updated by Yasir  Rahman on 11/06/2019 at 10:46 PM");
INSERT INTO crm_audit_log VALUES("7116","3","5","2019-06-12 00:15:22","Exit Invoice [Invoice No: 120448] updated by Imran  Khan on 12/06/2019 at 12:15 AM");
INSERT INTO crm_audit_log VALUES("7117","2","4","2019-06-12 01:17:47","Entry Invoice [Invoice No: 21987] updated by Yasir  Rahman on 12/06/2019 at 01:17 AM");
INSERT INTO crm_audit_log VALUES("7118","2","4","2019-06-12 01:19:01","Entry Invoice [Invoice No: 21988] updated by Yasir  Rahman on 12/06/2019 at 01:19 AM");
INSERT INTO crm_audit_log VALUES("7119","3","5","2019-06-12 05:27:38","Exit Invoice [Invoice No: 120449] updated by Imran  Khan on 12/06/2019 at 05:27 AM");
INSERT INTO crm_audit_log VALUES("7120","3","5","2019-06-12 05:28:28","Exit Invoice [Invoice No: 120450] updated by Imran  Khan on 12/06/2019 at 05:28 AM");
INSERT INTO crm_audit_log VALUES("7121","3","15","2019-06-12 09:50:03","Exit Invoice [Invoice No: 120451] updated by Abdul Rasheed on 12/06/2019 at 09:50 AM");
INSERT INTO crm_audit_log VALUES("7122","2","7","2019-06-12 16:26:19","Entry Invoice [Invoice No: 21989] updated by ALSED ABU SHAMA on 12/06/2019 at 04:26 PM");
INSERT INTO crm_audit_log VALUES("7123","3","4","2019-06-12 17:59:57","Exit Invoice [Invoice No: 120452] updated by Yasir  Rahman on 12/06/2019 at 05:59 PM");
INSERT INTO crm_audit_log VALUES("7124","2","7","2019-06-12 19:19:17","Entry Invoice [Invoice No: 21990] updated by ALSED ABU SHAMA on 12/06/2019 at 07:19 PM");
INSERT INTO crm_audit_log VALUES("7125","2","7","2019-06-12 19:20:48","Entry Invoice [Invoice No: 21991] updated by ALSED ABU SHAMA on 12/06/2019 at 07:20 PM");
INSERT INTO crm_audit_log VALUES("7126","2","7","2019-06-12 19:21:41","Entry Invoice [Invoice No: 21992] updated by ALSED ABU SHAMA on 12/06/2019 at 07:21 PM");
INSERT INTO crm_audit_log VALUES("7127","2","7","2019-06-12 19:22:27","Entry Invoice [Invoice No: 21993] updated by ALSED ABU SHAMA on 12/06/2019 at 07:22 PM");
INSERT INTO crm_audit_log VALUES("7128","2","7","2019-06-12 19:23:10","Entry Invoice [Invoice No: 21994] updated by ALSED ABU SHAMA on 12/06/2019 at 07:23 PM");
INSERT INTO crm_audit_log VALUES("7129","2","7","2019-06-12 19:23:50","Entry Invoice [Invoice No: 21995] updated by ALSED ABU SHAMA on 12/06/2019 at 07:23 PM");
INSERT INTO crm_audit_log VALUES("7130","3","4","2019-06-12 20:50:42","Exit Invoice [Invoice No: 120453] updated by Yasir  Rahman on 12/06/2019 at 08:50 PM");
INSERT INTO crm_audit_log VALUES("7131","2","4","2019-06-12 20:52:30","Entry Invoice [Invoice No: 21996] updated by Yasir  Rahman on 12/06/2019 at 08:52 PM");
INSERT INTO crm_audit_log VALUES("7132","2","4","2019-06-12 20:54:08","Entry Invoice [Invoice No: 21997] updated by Yasir  Rahman on 12/06/2019 at 08:54 PM");
INSERT INTO crm_audit_log VALUES("7133","3","4","2019-06-12 22:00:37","Exit Invoice [Invoice No: 120454] updated by Yasir  Rahman on 12/06/2019 at 10:00 PM");
INSERT INTO crm_audit_log VALUES("7134","3","4","2019-06-12 22:22:34","Exit Invoice [Invoice No: 120455] updated by Yasir  Rahman on 12/06/2019 at 10:22 PM");
INSERT INTO crm_audit_log VALUES("7135","3","4","2019-06-12 22:44:48","Exit Invoice [Invoice No: 120456] updated by Yasir  Rahman on 12/06/2019 at 10:44 PM");
INSERT INTO crm_audit_log VALUES("7136","3","4","2019-06-12 22:45:37","Exit Invoice [Invoice No: 120457] updated by Yasir  Rahman on 12/06/2019 at 10:45 PM");
INSERT INTO crm_audit_log VALUES("7137","2","4","2019-06-13 01:18:22","Entry Invoice [Invoice No: 21998] updated by Yasir  Rahman on 13/06/2019 at 01:18 AM");
INSERT INTO crm_audit_log VALUES("7138","3","5","2019-06-13 03:29:53","Exit Invoice [Invoice No: 120458] updated by Imran  Khan on 13/06/2019 at 03:29 AM");
INSERT INTO crm_audit_log VALUES("7139","3","5","2019-06-13 04:32:59","Exit Invoice [Invoice No: 120459] updated by Imran  Khan on 13/06/2019 at 04:32 AM");
INSERT INTO crm_audit_log VALUES("7140","3","5","2019-06-13 04:52:09","Exit Invoice [Invoice No: 120460] updated by Imran  Khan on 13/06/2019 at 04:52 AM");
INSERT INTO crm_audit_log VALUES("7141","2","4","2019-06-13 07:15:55","Entry Invoice [Invoice No: 21999] updated by Yasir  Rahman on 13/06/2019 at 07:15 AM");
INSERT INTO crm_audit_log VALUES("7142","2","4","2019-06-13 07:16:58","Entry Invoice [Invoice No: 22000] updated by Yasir  Rahman on 13/06/2019 at 07:16 AM");
INSERT INTO crm_audit_log VALUES("7143","2","4","2019-06-13 07:18:35","Entry Invoice [Invoice No: 22001] updated by Yasir  Rahman on 13/06/2019 at 07:18 AM");
INSERT INTO crm_audit_log VALUES("7144","3","6","2019-06-13 07:58:34","Exit Invoice [Invoice No: 120458] updated by ASHRAF  M K on 13/06/2019 at 07:58 AM");
INSERT INTO crm_audit_log VALUES("7145","3","15","2019-06-13 09:06:20","Exit Invoice [Invoice No: 120461] updated by Abdul Rasheed on 13/06/2019 at 09:06 AM");
INSERT INTO crm_audit_log VALUES("7146","3","15","2019-06-13 09:25:18","Exit Invoice [Invoice No: 120462] updated by Abdul Rasheed on 13/06/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("7147","3","15","2019-06-13 09:27:10","Exit Invoice [Invoice No: 120463] updated by Abdul Rasheed on 13/06/2019 at 09:27 AM");
INSERT INTO crm_audit_log VALUES("7148","3","15","2019-06-13 10:14:56","Exit Invoice [Invoice No: 120464] updated by Abdul Rasheed on 13/06/2019 at 10:14 AM");
INSERT INTO crm_audit_log VALUES("7149","3","15","2019-06-13 13:38:17","Exit Invoice [Invoice No: 120465] updated by Abdul Rasheed on 13/06/2019 at 01:38 PM");
INSERT INTO crm_audit_log VALUES("7150","3","15","2019-06-13 14:03:42","Exit Invoice [Invoice No: 120466] updated by Abdul Rasheed on 13/06/2019 at 02:03 PM");
INSERT INTO crm_audit_log VALUES("7151","2","7","2019-06-13 14:41:01","Entry Invoice [Invoice No: 22002] updated by ALSED ABU SHAMA on 13/06/2019 at 02:41 PM");
INSERT INTO crm_audit_log VALUES("7152","3","15","2019-06-13 14:50:15","Exit Invoice [Invoice No: 120467] updated by Abdul Rasheed on 13/06/2019 at 02:50 PM");
INSERT INTO crm_audit_log VALUES("7153","3","15","2019-06-13 14:51:22","Exit Invoice [Invoice No: 120468] updated by Abdul Rasheed on 13/06/2019 at 02:51 PM");
INSERT INTO crm_audit_log VALUES("7154","3","4","2019-06-13 18:08:01","Exit Invoice [Invoice No: 120469] updated by Yasir  Rahman on 13/06/2019 at 06:08 PM");
INSERT INTO crm_audit_log VALUES("7155","3","4","2019-06-13 20:24:18","Exit Invoice [Invoice No: 120470] updated by Yasir  Rahman on 13/06/2019 at 08:24 PM");
INSERT INTO crm_audit_log VALUES("7156","3","4","2019-06-13 21:49:32","Exit Invoice [Invoice No: 120471] updated by Yasir  Rahman on 13/06/2019 at 09:49 PM");
INSERT INTO crm_audit_log VALUES("7157","3","4","2019-06-13 23:20:27","Exit Invoice [Invoice No: 120472] updated by Yasir  Rahman on 13/06/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("7158","3","4","2019-06-13 23:23:09","Exit Invoice [Invoice No: 120473] updated by Yasir  Rahman on 13/06/2019 at 11:23 PM");
INSERT INTO crm_audit_log VALUES("7159","2","4","2019-06-13 23:36:33","Entry Invoice [Invoice No: 22003] updated by Yasir  Rahman on 13/06/2019 at 11:36 PM");
INSERT INTO crm_audit_log VALUES("7160","3","4","2019-06-13 23:57:16","Exit Invoice [Invoice No: 120474] updated by Yasir  Rahman on 13/06/2019 at 11:57 PM");
INSERT INTO crm_audit_log VALUES("7161","3","5","2019-06-14 01:09:14","Exit Invoice [Invoice No: 120475] updated by Imran  Khan on 14/06/2019 at 01:09 AM");
INSERT INTO crm_audit_log VALUES("7162","3","5","2019-06-14 02:03:23","Exit Invoice [Invoice No: 120476] updated by Imran  Khan on 14/06/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("7163","2","4","2019-06-14 04:21:10","Entry Invoice [Invoice No: 22004] updated by Yasir  Rahman on 14/06/2019 at 04:21 AM");
INSERT INTO crm_audit_log VALUES("7164","3","5","2019-06-14 04:29:33","Exit Invoice [Invoice No: 120477] updated by Imran  Khan on 14/06/2019 at 04:29 AM");
INSERT INTO crm_audit_log VALUES("7165","2","6","2019-06-14 08:29:48","Entry Invoice [Invoice No: 22005] updated by ASHRAF  M K on 14/06/2019 at 08:29 AM");
INSERT INTO crm_audit_log VALUES("7166","2","7","2019-06-14 09:04:16","Entry Invoice [Invoice No: 22006] updated by ALSED ABU SHAMA on 14/06/2019 at 09:04 AM");
INSERT INTO crm_audit_log VALUES("7167","2","7","2019-06-14 09:05:02","Entry Invoice [Invoice No: 22007] updated by ALSED ABU SHAMA on 14/06/2019 at 09:05 AM");
INSERT INTO crm_audit_log VALUES("7168","2","7","2019-06-14 09:05:47","Entry Invoice [Invoice No: 22008] updated by ALSED ABU SHAMA on 14/06/2019 at 09:05 AM");
INSERT INTO crm_audit_log VALUES("7169","2","7","2019-06-14 09:06:33","Entry Invoice [Invoice No: 22009] updated by ALSED ABU SHAMA on 14/06/2019 at 09:06 AM");
INSERT INTO crm_audit_log VALUES("7170","2","7","2019-06-14 09:07:20","Entry Invoice [Invoice No: 22010] updated by ALSED ABU SHAMA on 14/06/2019 at 09:07 AM");
INSERT INTO crm_audit_log VALUES("7171","2","7","2019-06-14 09:08:26","Entry Invoice [Invoice No: 22011] updated by ALSED ABU SHAMA on 14/06/2019 at 09:08 AM");
INSERT INTO crm_audit_log VALUES("7172","2","7","2019-06-14 09:09:11","Entry Invoice [Invoice No: 22012] updated by ALSED ABU SHAMA on 14/06/2019 at 09:09 AM");
INSERT INTO crm_audit_log VALUES("7173","2","7","2019-06-14 09:09:58","Entry Invoice [Invoice No: 22013] updated by ALSED ABU SHAMA on 14/06/2019 at 09:09 AM");
INSERT INTO crm_audit_log VALUES("7174","3","15","2019-06-14 10:11:50","Exit Invoice [Invoice No: 120478] updated by Abdul Rasheed on 14/06/2019 at 10:11 AM");
INSERT INTO crm_audit_log VALUES("7175","3","15","2019-06-14 11:19:32","Exit Invoice [Invoice No: 120479] updated by Abdul Rasheed on 14/06/2019 at 11:19 AM");
INSERT INTO crm_audit_log VALUES("7176","3","15","2019-06-14 13:45:38","Exit Invoice [Invoice No: 120480] updated by Abdul Rasheed on 14/06/2019 at 01:45 PM");
INSERT INTO crm_audit_log VALUES("7177","3","15","2019-06-14 13:51:35","Exit Invoice [Invoice No: 120481] updated by Abdul Rasheed on 14/06/2019 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("7178","2","7","2019-06-14 15:27:10","Entry Invoice [Invoice No: 22014] updated by ALSED ABU SHAMA on 14/06/2019 at 03:27 PM");
INSERT INTO crm_audit_log VALUES("7179","2","4","2019-06-14 20:38:16","Entry Invoice [Invoice No: 22015] updated by Yasir  Rahman on 14/06/2019 at 08:38 PM");
INSERT INTO crm_audit_log VALUES("7180","3","4","2019-06-14 20:49:43","Exit Invoice [Invoice No: 120482] updated by Yasir  Rahman on 14/06/2019 at 08:49 PM");
INSERT INTO crm_audit_log VALUES("7181","2","4","2019-06-14 21:17:55","Entry Invoice [Invoice No: 22016] updated by Yasir  Rahman on 14/06/2019 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("7182","3","4","2019-06-14 22:06:41","Exit Invoice [Invoice No: 120483] updated by Yasir  Rahman on 14/06/2019 at 10:06 PM");
INSERT INTO crm_audit_log VALUES("7183","2","4","2019-06-15 03:04:59","Entry Invoice [Invoice No: 22017] updated by Yasir  Rahman on 15/06/2019 at 03:04 AM");
INSERT INTO crm_audit_log VALUES("7184","2","4","2019-06-15 06:16:50","Entry Invoice [Invoice No: 22018] updated by Yasir  Rahman on 15/06/2019 at 06:16 AM");
INSERT INTO crm_audit_log VALUES("7185","3","15","2019-06-15 10:35:37","Exit Invoice [Invoice No: 120484] updated by Abdul Rasheed on 15/06/2019 at 10:35 AM");
INSERT INTO crm_audit_log VALUES("7186","3","15","2019-06-15 10:45:36","Exit Invoice [Invoice No: 120485] updated by Abdul Rasheed on 15/06/2019 at 10:45 AM");
INSERT INTO crm_audit_log VALUES("7187","2","7","2019-06-15 13:16:26","Entry Invoice [Invoice No: 22019] updated by ALSED ABU SHAMA on 15/06/2019 at 01:16 PM");
INSERT INTO crm_audit_log VALUES("7188","2","7","2019-06-15 13:17:11","Entry Invoice [Invoice No: 22020] updated by ALSED ABU SHAMA on 15/06/2019 at 01:17 PM");
INSERT INTO crm_audit_log VALUES("7189","2","7","2019-06-15 13:18:12","Entry Invoice [Invoice No: 22021] updated by ALSED ABU SHAMA on 15/06/2019 at 01:18 PM");
INSERT INTO crm_audit_log VALUES("7190","2","7","2019-06-15 13:19:05","Entry Invoice [Invoice No: 22022] updated by ALSED ABU SHAMA on 15/06/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("7191","2","7","2019-06-15 15:10:10","Entry Invoice [Invoice No: 22023] updated by ALSED ABU SHAMA on 15/06/2019 at 03:10 PM");
INSERT INTO crm_audit_log VALUES("7192","2","7","2019-06-15 17:13:23","Entry Invoice [Invoice No: 22024] updated by ALSED ABU SHAMA on 15/06/2019 at 05:13 PM");
INSERT INTO crm_audit_log VALUES("7193","2","7","2019-06-15 17:27:52","Entry Invoice [Invoice No: 22025] updated by ALSED ABU SHAMA on 15/06/2019 at 05:27 PM");
INSERT INTO crm_audit_log VALUES("7194","3","4","2019-06-15 17:47:33","Exit Invoice [Invoice No: 120486] updated by Yasir  Rahman on 15/06/2019 at 05:47 PM");
INSERT INTO crm_audit_log VALUES("7195","2","7","2019-06-15 17:56:19","Entry Invoice [Invoice No: 22026] updated by ALSED ABU SHAMA on 15/06/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("7196","2","4","2019-06-15 20:34:32","Entry Invoice [Invoice No: 22027] updated by Yasir  Rahman on 15/06/2019 at 08:34 PM");
INSERT INTO crm_audit_log VALUES("7197","2","4","2019-06-15 20:44:05","Entry Invoice [Invoice No: 22028] updated by Yasir  Rahman on 15/06/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("7198","2","6","2019-06-15 20:51:23","Entry Invoice [Invoice No: 22028] updated by ASHRAF  M K on 15/06/2019 at 08:51 PM");
INSERT INTO crm_audit_log VALUES("7199","3","4","2019-06-15 21:34:19","Exit Invoice [Invoice No: 120487] updated by Yasir  Rahman on 15/06/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("7200","3","5","2019-06-16 02:22:45","Exit Invoice [Invoice No: 120488] updated by Imran  Khan on 16/06/2019 at 02:22 AM");
INSERT INTO crm_audit_log VALUES("7201","2","4","2019-06-16 07:03:08","Entry Invoice [Invoice No: 22029] updated by Yasir  Rahman on 16/06/2019 at 07:03 AM");
INSERT INTO crm_audit_log VALUES("7202","2","4","2019-06-16 07:04:45","Entry Invoice [Invoice No: 22030] updated by Yasir  Rahman on 16/06/2019 at 07:04 AM");
INSERT INTO crm_audit_log VALUES("7203","2","4","2019-06-16 07:06:33","Entry Invoice [Invoice No: 22031] updated by Yasir  Rahman on 16/06/2019 at 07:06 AM");
INSERT INTO crm_audit_log VALUES("7204","2","4","2019-06-16 07:28:34","Entry Invoice [Invoice No: 22032] updated by Yasir  Rahman on 16/06/2019 at 07:28 AM");
INSERT INTO crm_audit_log VALUES("7205","2","7","2019-06-16 10:58:15","Entry Invoice [Invoice No: 22033] updated by ALSED ABU SHAMA on 16/06/2019 at 10:58 AM");
INSERT INTO crm_audit_log VALUES("7206","2","7","2019-06-16 11:04:38","Entry Invoice [Invoice No: 22034] updated by ALSED ABU SHAMA on 16/06/2019 at 11:04 AM");
INSERT INTO crm_audit_log VALUES("7207","3","15","2019-06-16 11:18:08","Exit Invoice [Invoice No: 120489] updated by Abdul Rasheed on 16/06/2019 at 11:18 AM");
INSERT INTO crm_audit_log VALUES("7208","3","15","2019-06-16 11:19:32","Exit Invoice [Invoice No: 120490] updated by Abdul Rasheed on 16/06/2019 at 11:19 AM");
INSERT INTO crm_audit_log VALUES("7209","3","15","2019-06-16 15:04:44","Exit Invoice [Invoice No: 120491] updated by Abdul Rasheed on 16/06/2019 at 03:04 PM");
INSERT INTO crm_audit_log VALUES("7210","3","4","2019-06-16 16:46:56","Exit Invoice [Invoice No: 120492] updated by Yasir  Rahman on 16/06/2019 at 04:46 PM");
INSERT INTO crm_audit_log VALUES("7211","3","4","2019-06-16 17:01:56","Exit Invoice [Invoice No: 120493] updated by Yasir  Rahman on 16/06/2019 at 05:01 PM");
INSERT INTO crm_audit_log VALUES("7212","3","4","2019-06-16 17:40:58","Exit Invoice [Invoice No: 120494] updated by Yasir  Rahman on 16/06/2019 at 05:40 PM");
INSERT INTO crm_audit_log VALUES("7213","3","4","2019-06-16 21:08:22","Exit Invoice [Invoice No: 120495] updated by Yasir  Rahman on 16/06/2019 at 09:08 PM");
INSERT INTO crm_audit_log VALUES("7214","2","4","2019-06-16 21:44:28","Entry Invoice [Invoice No: 22035] updated by Yasir  Rahman on 16/06/2019 at 09:44 PM");
INSERT INTO crm_audit_log VALUES("7215","2","4","2019-06-16 21:58:53","Entry Invoice [Invoice No: 22036] updated by Yasir  Rahman on 16/06/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("7216","3","5","2019-06-17 01:47:06","Exit Invoice [Invoice No: 120496] updated by Imran  Khan on 17/06/2019 at 01:47 AM");
INSERT INTO crm_audit_log VALUES("7217","3","5","2019-06-17 02:05:39","Exit Invoice [Invoice No: 120497] updated by Imran  Khan on 17/06/2019 at 02:05 AM");
INSERT INTO crm_audit_log VALUES("7218","3","5","2019-06-17 03:21:06","Exit Invoice [Invoice No: 120498] updated by Imran  Khan on 17/06/2019 at 03:21 AM");
INSERT INTO crm_audit_log VALUES("7219","3","5","2019-06-17 03:24:56","Exit Invoice [Invoice No: 120499] updated by Imran  Khan on 17/06/2019 at 03:24 AM");
INSERT INTO crm_audit_log VALUES("7220","3","5","2019-06-17 04:38:43","Exit Invoice [Invoice No: 120500] updated by Imran  Khan on 17/06/2019 at 04:38 AM");
INSERT INTO crm_audit_log VALUES("7221","3","15","2019-06-17 08:45:45","Exit Invoice [Invoice No: 120501] updated by Abdul Rasheed on 17/06/2019 at 08:45 AM");
INSERT INTO crm_audit_log VALUES("7222","3","15","2019-06-17 08:55:30","Exit Invoice [Invoice No: 120502] updated by Abdul Rasheed on 17/06/2019 at 08:55 AM");
INSERT INTO crm_audit_log VALUES("7223","2","6","2019-06-17 09:05:38","Entry Invoice [Invoice No: 22037] updated by ASHRAF  M K on 17/06/2019 at 09:05 AM");
INSERT INTO crm_audit_log VALUES("7224","2","6","2019-06-17 09:06:56","Entry Invoice [Invoice No: 22037] updated by ASHRAF  M K on 17/06/2019 at 09:06 AM");
INSERT INTO crm_audit_log VALUES("7225","2","6","2019-06-17 09:08:05","Entry Invoice [Invoice No: 22037] updated by ASHRAF  M K on 17/06/2019 at 09:08 AM");
INSERT INTO crm_audit_log VALUES("7226","2","7","2019-06-17 09:20:14","Entry Invoice [Invoice No: 22038] updated by ALSED ABU SHAMA on 17/06/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("7227","2","7","2019-06-17 09:25:15","Entry Invoice [Invoice No: 22039] updated by ALSED ABU SHAMA on 17/06/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("7228","2","7","2019-06-17 09:26:46","Entry Invoice [Invoice No: 22040] updated by ALSED ABU SHAMA on 17/06/2019 at 09:26 AM");
INSERT INTO crm_audit_log VALUES("7229","3","15","2019-06-17 13:08:28","Exit Invoice [Invoice No: 120503] updated by Abdul Rasheed on 17/06/2019 at 01:08 PM");
INSERT INTO crm_audit_log VALUES("7230","3","4","2019-06-17 16:59:07","Exit Invoice [Invoice No: 120504] updated by Yasir  Rahman on 17/06/2019 at 04:59 PM");
INSERT INTO crm_audit_log VALUES("7231","2","4","2019-06-17 20:34:41","Entry Invoice [Invoice No: 22041] updated by Yasir  Rahman on 17/06/2019 at 08:34 PM");
INSERT INTO crm_audit_log VALUES("7232","3","4","2019-06-17 20:44:50","Exit Invoice [Invoice No: 120505] updated by Yasir  Rahman on 17/06/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("7233","2","4","2019-06-17 21:58:21","Entry Invoice [Invoice No: 22042] updated by Yasir  Rahman on 17/06/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("7234","2","4","2019-06-18 01:35:19","Entry Invoice [Invoice No: 22043] updated by Yasir  Rahman on 18/06/2019 at 01:35 AM");
INSERT INTO crm_audit_log VALUES("7235","3","5","2019-06-18 02:05:36","Exit Invoice [Invoice No: 120506] updated by Imran  Khan on 18/06/2019 at 02:05 AM");
INSERT INTO crm_audit_log VALUES("7236","3","5","2019-06-18 02:12:58","Exit Invoice [Invoice No: 120507] updated by Imran  Khan on 18/06/2019 at 02:12 AM");
INSERT INTO crm_audit_log VALUES("7237","2","4","2019-06-18 03:02:39","Entry Invoice [Invoice No: 22044] updated by Yasir  Rahman on 18/06/2019 at 03:02 AM");
INSERT INTO crm_audit_log VALUES("7238","2","4","2019-06-18 06:10:33","Entry Invoice [Invoice No: 22045] updated by Yasir  Rahman on 18/06/2019 at 06:10 AM");
INSERT INTO crm_audit_log VALUES("7239","2","4","2019-06-18 06:12:35","Entry Invoice [Invoice No: 22046] updated by Yasir  Rahman on 18/06/2019 at 06:12 AM");
INSERT INTO crm_audit_log VALUES("7240","2","6","2019-06-18 09:28:14","Entry Invoice [Invoice No: 22047] updated by ASHRAF  M K on 18/06/2019 at 09:28 AM");
INSERT INTO crm_audit_log VALUES("7241","2","11","2019-06-18 09:36:31","Entry Invoice [Invoice No: 22048] updated by GAREEB GAREEB on 18/06/2019 at 09:36 AM");
INSERT INTO crm_audit_log VALUES("7242","2","11","2019-06-18 09:38:04","Entry Invoice [Invoice No: 22049] updated by GAREEB GAREEB on 18/06/2019 at 09:38 AM");
INSERT INTO crm_audit_log VALUES("7243","2","11","2019-06-18 09:41:32","Entry Invoice [Invoice No: 22050] updated by GAREEB GAREEB on 18/06/2019 at 09:41 AM");
INSERT INTO crm_audit_log VALUES("7244","3","15","2019-06-18 10:38:57","Exit Invoice [Invoice No: 120508] updated by Abdul Rasheed on 18/06/2019 at 10:38 AM");
INSERT INTO crm_audit_log VALUES("7245","3","15","2019-06-18 11:14:29","Exit Invoice [Invoice No: 120509] updated by Abdul Rasheed on 18/06/2019 at 11:14 AM");
INSERT INTO crm_audit_log VALUES("7246","3","15","2019-06-18 12:32:42","Exit Invoice [Invoice No: 120510] updated by Abdul Rasheed on 18/06/2019 at 12:32 PM");
INSERT INTO crm_audit_log VALUES("7247","1","6","2019-06-18 12:43:57","Customer [Customer No: 356] updated by ASHRAF  M K on 18/06/2019 at 12:43 PM");
INSERT INTO crm_audit_log VALUES("7248","1","6","2019-06-18 12:49:09","Customer [Customer No: 450] updated by ASHRAF  M K on 18/06/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("7249","1","6","2019-06-18 13:19:41","Customer [Customer No: 450] updated by ASHRAF  M K on 18/06/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("7250","3","6","2019-06-18 13:21:04","Exit Invoice [Invoice No: 120511] updated by ASHRAF  M K on 18/06/2019 at 01:21 PM");
INSERT INTO crm_audit_log VALUES("7251","3","6","2019-06-18 13:45:58","Exit Invoice [Invoice No: 120512] updated by ASHRAF  M K on 18/06/2019 at 01:45 PM");
INSERT INTO crm_audit_log VALUES("7252","2","11","2019-06-18 14:16:29","Entry Invoice [Invoice No: 22051] updated by GAREEB GAREEB on 18/06/2019 at 02:16 PM");
INSERT INTO crm_audit_log VALUES("7253","3","15","2019-06-18 14:36:59","Exit Invoice [Invoice No: 120513] updated by Abdul Rasheed on 18/06/2019 at 02:36 PM");
INSERT INTO crm_audit_log VALUES("7254","2","11","2019-06-18 16:54:39","Entry Invoice [Invoice No: 22052] updated by GAREEB GAREEB on 18/06/2019 at 04:54 PM");
INSERT INTO crm_audit_log VALUES("7255","3","4","2019-06-18 16:56:24","Exit Invoice [Invoice No: 120514] updated by Yasir  Rahman on 18/06/2019 at 04:56 PM");
INSERT INTO crm_audit_log VALUES("7256","2","11","2019-06-18 18:49:19","Entry Invoice [Invoice No: 22053] updated by GAREEB GAREEB on 18/06/2019 at 06:49 PM");
INSERT INTO crm_audit_log VALUES("7257","3","4","2019-06-18 19:48:19","Exit Invoice [Invoice No: 120515] updated by Yasir  Rahman on 18/06/2019 at 07:48 PM");
INSERT INTO crm_audit_log VALUES("7258","3","4","2019-06-18 19:49:09","Exit Invoice [Invoice No: 120516] updated by Yasir  Rahman on 18/06/2019 at 07:49 PM");
INSERT INTO crm_audit_log VALUES("7259","2","4","2019-06-18 21:11:40","Entry Invoice [Invoice No: 22054] updated by Yasir  Rahman on 18/06/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("7260","3","4","2019-06-18 21:12:09","Exit Invoice [Invoice No: 120517] updated by Yasir  Rahman on 18/06/2019 at 09:12 PM");
INSERT INTO crm_audit_log VALUES("7261","3","4","2019-06-18 21:52:44","Exit Invoice [Invoice No: 120518] updated by Yasir  Rahman on 18/06/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("7262","3","4","2019-06-18 23:47:32","Exit Invoice [Invoice No: 120519] updated by Yasir  Rahman on 18/06/2019 at 11:47 PM");
INSERT INTO crm_audit_log VALUES("7263","2","4","2019-06-18 23:53:24","Entry Invoice [Invoice No: 22055] updated by Yasir  Rahman on 18/06/2019 at 11:53 PM");
INSERT INTO crm_audit_log VALUES("7264","2","4","2019-06-19 01:36:04","Entry Invoice [Invoice No: 22056] updated by Yasir  Rahman on 19/06/2019 at 01:36 AM");
INSERT INTO crm_audit_log VALUES("7265","3","5","2019-06-19 03:50:09","Exit Invoice [Invoice No: 120520] updated by Imran  Khan on 19/06/2019 at 03:50 AM");
INSERT INTO crm_audit_log VALUES("7266","3","5","2019-06-19 07:14:14","Exit Invoice [Invoice No: 120521] updated by Imran  Khan on 19/06/2019 at 07:14 AM");
INSERT INTO crm_audit_log VALUES("7267","3","5","2019-06-19 07:20:40","Exit Invoice [Invoice No: 120522] updated by Imran  Khan on 19/06/2019 at 07:20 AM");
INSERT INTO crm_audit_log VALUES("7268","3","15","2019-06-19 08:44:58","Exit Invoice [Invoice No: 120523] updated by Abdul Rasheed on 19/06/2019 at 08:44 AM");
INSERT INTO crm_audit_log VALUES("7269","2","11","2019-06-19 09:25:12","Entry Invoice [Invoice No: 22057] updated by GAREEB GAREEB on 19/06/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("7270","2","11","2019-06-19 09:26:45","Entry Invoice [Invoice No: 22058] updated by GAREEB GAREEB on 19/06/2019 at 09:26 AM");
INSERT INTO crm_audit_log VALUES("7271","2","11","2019-06-19 09:30:27","Entry Invoice [Invoice No: 22059] updated by GAREEB GAREEB on 19/06/2019 at 09:30 AM");
INSERT INTO crm_audit_log VALUES("7272","3","15","2019-06-19 10:01:18","Exit Invoice [Invoice No: 120524] updated by Abdul Rasheed on 19/06/2019 at 10:01 AM");
INSERT INTO crm_audit_log VALUES("7273","3","15","2019-06-19 10:14:25","Exit Invoice [Invoice No: 120525] updated by Abdul Rasheed on 19/06/2019 at 10:14 AM");
INSERT INTO crm_audit_log VALUES("7274","2","11","2019-06-19 11:14:58","Entry Invoice [Invoice No: 22060] updated by GAREEB GAREEB on 19/06/2019 at 11:14 AM");
INSERT INTO crm_audit_log VALUES("7275","2","11","2019-06-19 12:39:52","Entry Invoice [Invoice No: 22061] updated by GAREEB GAREEB on 19/06/2019 at 12:39 PM");
INSERT INTO crm_audit_log VALUES("7276","2","11","2019-06-19 12:41:05","Entry Invoice [Invoice No: 22062] updated by GAREEB GAREEB on 19/06/2019 at 12:41 PM");
INSERT INTO crm_audit_log VALUES("7277","3","15","2019-06-19 13:29:15","Exit Invoice [Invoice No: 120526] updated by Abdul Rasheed on 19/06/2019 at 01:29 PM");
INSERT INTO crm_audit_log VALUES("7278","2","11","2019-06-19 13:45:11","Entry Invoice [Invoice No: 22063] updated by GAREEB GAREEB on 19/06/2019 at 01:45 PM");
INSERT INTO crm_audit_log VALUES("7279","3","15","2019-06-19 14:11:20","Exit Invoice [Invoice No: 120527] updated by Abdul Rasheed on 19/06/2019 at 02:11 PM");
INSERT INTO crm_audit_log VALUES("7280","2","11","2019-06-19 18:23:24","Entry Invoice [Invoice No: 22064] updated by GAREEB GAREEB on 19/06/2019 at 06:23 PM");
INSERT INTO crm_audit_log VALUES("7281","3","4","2019-06-19 20:43:27","Exit Invoice [Invoice No: 120528] updated by Yasir  Rahman on 19/06/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("7282","3","4","2019-06-19 23:02:09","Exit Invoice [Invoice No: 120529] updated by Yasir  Rahman on 19/06/2019 at 11:02 PM");
INSERT INTO crm_audit_log VALUES("7283","2","4","2019-06-20 01:44:07","Entry Invoice [Invoice No: 22065] updated by Yasir  Rahman on 20/06/2019 at 01:44 AM");
INSERT INTO crm_audit_log VALUES("7284","3","5","2019-06-20 01:56:19","Exit Invoice [Invoice No: 120530] updated by Imran  Khan on 20/06/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("7285","3","5","2019-06-20 03:23:26","Exit Invoice [Invoice No: 120531] updated by Imran  Khan on 20/06/2019 at 03:23 AM");
INSERT INTO crm_audit_log VALUES("7286","3","5","2019-06-20 04:14:17","Exit Invoice [Invoice No: 120532] updated by Imran  Khan on 20/06/2019 at 04:14 AM");
INSERT INTO crm_audit_log VALUES("7287","3","5","2019-06-20 04:14:52","Exit Invoice [Invoice No: 120533] updated by Imran  Khan on 20/06/2019 at 04:14 AM");
INSERT INTO crm_audit_log VALUES("7288","3","5","2019-06-20 04:15:25","Exit Invoice [Invoice No: 120534] updated by Imran  Khan on 20/06/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("7289","3","5","2019-06-20 06:26:34","Exit Invoice [Invoice No: 120535] updated by Imran  Khan on 20/06/2019 at 06:26 AM");
INSERT INTO crm_audit_log VALUES("7290","2","4","2019-06-20 07:21:35","Entry Invoice [Invoice No: 22066] updated by Yasir  Rahman on 20/06/2019 at 07:21 AM");
INSERT INTO crm_audit_log VALUES("7291","2","4","2019-06-20 07:23:03","Entry Invoice [Invoice No: 22067] updated by Yasir  Rahman on 20/06/2019 at 07:23 AM");
INSERT INTO crm_audit_log VALUES("7292","2","4","2019-06-20 07:24:33","Entry Invoice [Invoice No: 22068] updated by Yasir  Rahman on 20/06/2019 at 07:24 AM");
INSERT INTO crm_audit_log VALUES("7293","2","4","2019-06-20 07:25:28","Entry Invoice [Invoice No: 22069] updated by Yasir  Rahman on 20/06/2019 at 07:25 AM");
INSERT INTO crm_audit_log VALUES("7294","2","4","2019-06-20 07:26:54","Entry Invoice [Invoice No: 22070] updated by Yasir  Rahman on 20/06/2019 at 07:26 AM");
INSERT INTO crm_audit_log VALUES("7295","2","11","2019-06-20 09:14:24","Entry Invoice [Invoice No: 22071] updated by GAREEB GAREEB on 20/06/2019 at 09:14 AM");
INSERT INTO crm_audit_log VALUES("7296","3","15","2019-06-20 09:41:14","Exit Invoice [Invoice No: 120536] updated by Abdul Rasheed on 20/06/2019 at 09:41 AM");
INSERT INTO crm_audit_log VALUES("7297","3","6","2019-06-20 10:08:32","Exit Invoice [Invoice No: 120531] updated by ASHRAF  M K on 20/06/2019 at 10:08 AM");
INSERT INTO crm_audit_log VALUES("7298","3","6","2019-06-20 10:11:04","Exit Invoice [Invoice No: 120537] updated by ASHRAF  M K on 20/06/2019 at 10:11 AM");
INSERT INTO crm_audit_log VALUES("7299","3","6","2019-06-20 10:40:41","Exit Invoice [Invoice No: 120538] updated by ASHRAF  M K on 20/06/2019 at 10:40 AM");
INSERT INTO crm_audit_log VALUES("7300","3","6","2019-06-20 10:46:49","Exit Invoice [Invoice No: 120539] updated by ASHRAF  M K on 20/06/2019 at 10:46 AM");
INSERT INTO crm_audit_log VALUES("7301","3","6","2019-06-20 11:03:24","Exit Invoice [Invoice No: 120540] updated by ASHRAF  M K on 20/06/2019 at 11:03 AM");
INSERT INTO crm_audit_log VALUES("7302","3","6","2019-06-20 11:52:26","Exit Invoice [Invoice No: 120541] updated by ASHRAF  M K on 20/06/2019 at 11:52 AM");
INSERT INTO crm_audit_log VALUES("7303","2","11","2019-06-20 12:11:45","Entry Invoice [Invoice No: 22072] updated by GAREEB GAREEB on 20/06/2019 at 12:11 PM");
INSERT INTO crm_audit_log VALUES("7304","3","6","2019-06-20 12:12:34","Exit Invoice [Invoice No: 120542] updated by ASHRAF  M K on 20/06/2019 at 12:12 PM");
INSERT INTO crm_audit_log VALUES("7305","2","11","2019-06-20 12:15:05","Entry Invoice [Invoice No: 22073] updated by GAREEB GAREEB on 20/06/2019 at 12:15 PM");
INSERT INTO crm_audit_log VALUES("7306","2","11","2019-06-20 12:16:25","Entry Invoice [Invoice No: 22074] updated by GAREEB GAREEB on 20/06/2019 at 12:16 PM");
INSERT INTO crm_audit_log VALUES("7307","3","6","2019-06-20 12:26:07","Exit Invoice [Invoice No: 120543] updated by ASHRAF  M K on 20/06/2019 at 12:26 PM");
INSERT INTO crm_audit_log VALUES("7308","3","6","2019-06-20 12:27:59","Exit Invoice [Invoice No: 120544] updated by ASHRAF  M K on 20/06/2019 at 12:27 PM");
INSERT INTO crm_audit_log VALUES("7309","3","6","2019-06-20 12:37:52","Exit Invoice [Invoice No: 120545] updated by ASHRAF  M K on 20/06/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("7310","3","15","2019-06-20 14:35:20","Exit Invoice [Invoice No: 120546] updated by Abdul Rasheed on 20/06/2019 at 02:35 PM");
INSERT INTO crm_audit_log VALUES("7311","3","15","2019-06-20 15:06:48","Exit Invoice [Invoice No: 120547] updated by Abdul Rasheed on 20/06/2019 at 03:06 PM");
INSERT INTO crm_audit_log VALUES("7312","3","6","2019-06-20 15:07:32","Exit Invoice [Invoice No: 120547] updated by ASHRAF  M K on 20/06/2019 at 03:07 PM");
INSERT INTO crm_audit_log VALUES("7313","2","11","2019-06-20 15:07:47","Entry Invoice [Invoice No: 22075] updated by GAREEB GAREEB on 20/06/2019 at 03:07 PM");
INSERT INTO crm_audit_log VALUES("7314","3","4","2019-06-20 17:55:53","Exit Invoice [Invoice No: 120548] updated by Yasir  Rahman on 20/06/2019 at 05:55 PM");
INSERT INTO crm_audit_log VALUES("7315","1","11","2019-06-20 18:44:06","Customer [Customer No: 451] updated by GAREEB GAREEB on 20/06/2019 at 06:44 PM");
INSERT INTO crm_audit_log VALUES("7316","3","4","2019-06-20 18:46:10","Exit Invoice [Invoice No: 120549] updated by Yasir  Rahman on 20/06/2019 at 06:46 PM");
INSERT INTO crm_audit_log VALUES("7317","2","4","2019-06-20 22:23:39","Entry Invoice [Invoice No: 22076] updated by Yasir  Rahman on 20/06/2019 at 10:23 PM");
INSERT INTO crm_audit_log VALUES("7318","2","4","2019-06-20 22:24:53","Entry Invoice [Invoice No: 22077] updated by Yasir  Rahman on 20/06/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("7319","2","4","2019-06-20 22:26:20","Entry Invoice [Invoice No: 22078] updated by Yasir  Rahman on 20/06/2019 at 10:26 PM");
INSERT INTO crm_audit_log VALUES("7320","2","4","2019-06-20 22:28:07","Entry Invoice [Invoice No: 22079] updated by Yasir  Rahman on 20/06/2019 at 10:28 PM");
INSERT INTO crm_audit_log VALUES("7321","3","4","2019-06-20 23:13:18","Exit Invoice [Invoice No: 120550] updated by Yasir  Rahman on 20/06/2019 at 11:13 PM");
INSERT INTO crm_audit_log VALUES("7322","2","4","2019-06-21 00:34:22","Entry Invoice [Invoice No: 22080] updated by Yasir  Rahman on 21/06/2019 at 12:34 AM");
INSERT INTO crm_audit_log VALUES("7323","3","5","2019-06-21 00:43:11","Exit Invoice [Invoice No: 120551] updated by Imran  Khan on 21/06/2019 at 12:43 AM");
INSERT INTO crm_audit_log VALUES("7324","3","5","2019-06-21 00:44:13","Exit Invoice [Invoice No: 120552] updated by Imran  Khan on 21/06/2019 at 12:44 AM");
INSERT INTO crm_audit_log VALUES("7325","3","5","2019-06-21 00:44:56","Exit Invoice [Invoice No: 120553] updated by Imran  Khan on 21/06/2019 at 12:44 AM");
INSERT INTO crm_audit_log VALUES("7326","3","5","2019-06-21 00:53:45","Exit Invoice [Invoice No: 120554] updated by Imran  Khan on 21/06/2019 at 12:53 AM");
INSERT INTO crm_audit_log VALUES("7327","2","4","2019-06-21 01:46:14","Entry Invoice [Invoice No: 22081] updated by Yasir  Rahman on 21/06/2019 at 01:46 AM");
INSERT INTO crm_audit_log VALUES("7328","3","5","2019-06-21 02:30:48","Exit Invoice [Invoice No: 120555] updated by Imran  Khan on 21/06/2019 at 02:30 AM");
INSERT INTO crm_audit_log VALUES("7329","3","5","2019-06-21 02:32:54","Exit Invoice [Invoice No: 120556] updated by Imran  Khan on 21/06/2019 at 02:32 AM");
INSERT INTO crm_audit_log VALUES("7330","3","5","2019-06-21 04:25:46","Exit Invoice [Invoice No: 120557] updated by Imran  Khan on 21/06/2019 at 04:25 AM");
INSERT INTO crm_audit_log VALUES("7331","3","5","2019-06-21 04:26:47","Exit Invoice [Invoice No: 120558] updated by Imran  Khan on 21/06/2019 at 04:26 AM");
INSERT INTO crm_audit_log VALUES("7332","3","5","2019-06-21 05:03:34","Exit Invoice [Invoice No: 120559] updated by Imran  Khan on 21/06/2019 at 05:03 AM");
INSERT INTO crm_audit_log VALUES("7333","2","4","2019-06-21 06:09:54","Entry Invoice [Invoice No: 22082] updated by Yasir  Rahman on 21/06/2019 at 06:09 AM");
INSERT INTO crm_audit_log VALUES("7334","2","4","2019-06-21 06:11:42","Entry Invoice [Invoice No: 22083] updated by Yasir  Rahman on 21/06/2019 at 06:11 AM");
INSERT INTO crm_audit_log VALUES("7335","2","11","2019-06-21 09:20:21","Entry Invoice [Invoice No: 22084] updated by GAREEB GAREEB on 21/06/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("7336","2","11","2019-06-21 09:24:04","Entry Invoice [Invoice No: 22085] updated by GAREEB GAREEB on 21/06/2019 at 09:24 AM");
INSERT INTO crm_audit_log VALUES("7337","2","11","2019-06-21 09:28:00","Entry Invoice [Invoice No: 22086] updated by GAREEB GAREEB on 21/06/2019 at 09:28 AM");
INSERT INTO crm_audit_log VALUES("7338","2","11","2019-06-21 09:34:07","Entry Invoice [Invoice No: 22087] updated by GAREEB GAREEB on 21/06/2019 at 09:34 AM");
INSERT INTO crm_audit_log VALUES("7339","2","11","2019-06-21 09:36:40","Entry Invoice [Invoice No: 22088] updated by GAREEB GAREEB on 21/06/2019 at 09:36 AM");
INSERT INTO crm_audit_log VALUES("7340","2","11","2019-06-21 09:38:18","Entry Invoice [Invoice No: 22089] updated by GAREEB GAREEB on 21/06/2019 at 09:38 AM");
INSERT INTO crm_audit_log VALUES("7341","2","11","2019-06-21 09:40:20","Entry Invoice [Invoice No: 22090] updated by GAREEB GAREEB on 21/06/2019 at 09:40 AM");
INSERT INTO crm_audit_log VALUES("7342","2","11","2019-06-21 09:42:05","Entry Invoice [Invoice No: 22091] updated by GAREEB GAREEB on 21/06/2019 at 09:42 AM");
INSERT INTO crm_audit_log VALUES("7343","2","11","2019-06-21 09:43:42","Entry Invoice [Invoice No: 22092] updated by GAREEB GAREEB on 21/06/2019 at 09:43 AM");
INSERT INTO crm_audit_log VALUES("7344","3","15","2019-06-21 09:59:24","Exit Invoice [Invoice No: 120560] updated by Abdul Rasheed on 21/06/2019 at 09:59 AM");
INSERT INTO crm_audit_log VALUES("7345","3","15","2019-06-21 10:00:43","Exit Invoice [Invoice No: 120561] updated by Abdul Rasheed on 21/06/2019 at 10:00 AM");
INSERT INTO crm_audit_log VALUES("7346","3","15","2019-06-21 10:04:39","Exit Invoice [Invoice No: 120562] updated by Abdul Rasheed on 21/06/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("7347","3","6","2019-06-21 10:10:58","Exit Invoice [Invoice No: 120558] updated by ASHRAF  M K on 21/06/2019 at 10:10 AM");
INSERT INTO crm_audit_log VALUES("7348","3","6","2019-06-21 10:11:33","Exit Invoice [Invoice No: 120559] updated by ASHRAF  M K on 21/06/2019 at 10:11 AM");
INSERT INTO crm_audit_log VALUES("7349","3","6","2019-06-21 10:12:01","Exit Invoice [Invoice No: 120557] updated by ASHRAF  M K on 21/06/2019 at 10:12 AM");
INSERT INTO crm_audit_log VALUES("7350","3","6","2019-06-21 10:12:30","Exit Invoice [Invoice No: 120555] updated by ASHRAF  M K on 21/06/2019 at 10:12 AM");
INSERT INTO crm_audit_log VALUES("7351","3","15","2019-06-21 10:32:24","Exit Invoice [Invoice No: 120563] updated by Abdul Rasheed on 21/06/2019 at 10:32 AM");
INSERT INTO crm_audit_log VALUES("7352","3","15","2019-06-21 10:49:12","Exit Invoice [Invoice No: 120564] updated by Abdul Rasheed on 21/06/2019 at 10:49 AM");
INSERT INTO crm_audit_log VALUES("7353","3","15","2019-06-21 11:10:22","Exit Invoice [Invoice No: 120565] updated by Abdul Rasheed on 21/06/2019 at 11:10 AM");
INSERT INTO crm_audit_log VALUES("7354","3","15","2019-06-21 11:17:49","Exit Invoice [Invoice No: 120566] updated by Abdul Rasheed on 21/06/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("7355","1","6","2019-06-21 13:27:33","Customer [Customer No: 451] updated by ASHRAF  M K on 21/06/2019 at 01:27 PM");
INSERT INTO crm_audit_log VALUES("7356","3","15","2019-06-21 14:25:46","Exit Invoice [Invoice No: 120567] updated by Abdul Rasheed on 21/06/2019 at 02:25 PM");
INSERT INTO crm_audit_log VALUES("7357","3","15","2019-06-21 14:53:10","Exit Invoice [Invoice No: 120568] updated by Abdul Rasheed on 21/06/2019 at 02:53 PM");
INSERT INTO crm_audit_log VALUES("7358","3","4","2019-06-21 17:13:50","Exit Invoice [Invoice No: 120569] updated by Yasir  Rahman on 21/06/2019 at 05:13 PM");
INSERT INTO crm_audit_log VALUES("7359","3","4","2019-06-21 17:15:21","Exit Invoice [Invoice No: 120570] updated by Yasir  Rahman on 21/06/2019 at 05:15 PM");
INSERT INTO crm_audit_log VALUES("7360","3","4","2019-06-21 17:31:50","Exit Invoice [Invoice No: 120571] updated by Yasir  Rahman on 21/06/2019 at 05:31 PM");
INSERT INTO crm_audit_log VALUES("7361","3","4","2019-06-21 17:47:11","Exit Invoice [Invoice No: 120572] updated by Yasir  Rahman on 21/06/2019 at 05:47 PM");
INSERT INTO crm_audit_log VALUES("7362","3","4","2019-06-21 17:59:47","Exit Invoice [Invoice No: 120573] updated by Yasir  Rahman on 21/06/2019 at 05:59 PM");
INSERT INTO crm_audit_log VALUES("7363","2","11","2019-06-21 18:36:24","Entry Invoice [Invoice No: 22093] updated by GAREEB GAREEB on 21/06/2019 at 06:36 PM");
INSERT INTO crm_audit_log VALUES("7364","3","4","2019-06-21 18:41:35","Exit Invoice [Invoice No: 120574] updated by Yasir  Rahman on 21/06/2019 at 06:41 PM");
INSERT INTO crm_audit_log VALUES("7365","3","4","2019-06-21 18:50:01","Exit Invoice [Invoice No: 120575] updated by Yasir  Rahman on 21/06/2019 at 06:50 PM");
INSERT INTO crm_audit_log VALUES("7366","3","4","2019-06-21 19:25:09","Exit Invoice [Invoice No: 120576] updated by Yasir  Rahman on 21/06/2019 at 07:25 PM");
INSERT INTO crm_audit_log VALUES("7367","3","6","2019-06-21 21:11:22","Exit Invoice [Invoice No: 120570] updated by ASHRAF  M K on 21/06/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("7368","3","6","2019-06-21 21:11:52","Exit Invoice [Invoice No: 120569] updated by ASHRAF  M K on 21/06/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("7369","3","6","2019-06-21 21:12:40","Exit Invoice [Invoice No: 120573] updated by ASHRAF  M K on 21/06/2019 at 09:12 PM");
INSERT INTO crm_audit_log VALUES("7370","3","6","2019-06-21 21:13:25","Exit Invoice [Invoice No: 120574] updated by ASHRAF  M K on 21/06/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("7371","3","6","2019-06-21 21:13:51","Exit Invoice [Invoice No: 120576] updated by ASHRAF  M K on 21/06/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("7372","3","6","2019-06-21 21:14:23","Exit Invoice [Invoice No: 120575] updated by ASHRAF  M K on 21/06/2019 at 09:14 PM");
INSERT INTO crm_audit_log VALUES("7373","3","6","2019-06-21 21:15:26","Exit Invoice [Invoice No: 120571] updated by ASHRAF  M K on 21/06/2019 at 09:15 PM");
INSERT INTO crm_audit_log VALUES("7374","3","6","2019-06-21 21:17:31","Exit Invoice [Invoice No: 120572] updated by ASHRAF  M K on 21/06/2019 at 09:17 PM");
INSERT INTO crm_audit_log VALUES("7375","2","4","2019-06-21 21:20:49","Entry Invoice [Invoice No: 22094] updated by Yasir  Rahman on 21/06/2019 at 09:20 PM");
INSERT INTO crm_audit_log VALUES("7376","3","6","2019-06-21 21:55:12","Exit Invoice [Invoice No: 120572] updated by ASHRAF  M K on 21/06/2019 at 09:55 PM");
INSERT INTO crm_audit_log VALUES("7377","3","4","2019-06-21 21:56:39","Exit Invoice [Invoice No: 120577] updated by Yasir  Rahman on 21/06/2019 at 09:56 PM");
INSERT INTO crm_audit_log VALUES("7378","3","4","2019-06-21 21:57:27","Exit Invoice [Invoice No: 120578] updated by Yasir  Rahman on 21/06/2019 at 09:57 PM");
INSERT INTO crm_audit_log VALUES("7379","2","4","2019-06-21 22:01:51","Entry Invoice [Invoice No: 22095] updated by Yasir  Rahman on 21/06/2019 at 10:01 PM");
INSERT INTO crm_audit_log VALUES("7380","3","4","2019-06-21 22:19:30","Exit Invoice [Invoice No: 120579] updated by Yasir  Rahman on 21/06/2019 at 10:19 PM");
INSERT INTO crm_audit_log VALUES("7381","2","4","2019-06-21 22:49:08","Entry Invoice [Invoice No: 22096] updated by Yasir  Rahman on 21/06/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("7382","2","4","2019-06-21 22:50:27","Entry Invoice [Invoice No: 22097] updated by Yasir  Rahman on 21/06/2019 at 10:50 PM");
INSERT INTO crm_audit_log VALUES("7383","2","4","2019-06-21 22:52:04","Entry Invoice [Invoice No: 22098] updated by Yasir  Rahman on 21/06/2019 at 10:52 PM");
INSERT INTO crm_audit_log VALUES("7384","3","5","2019-06-22 01:55:05","Exit Invoice [Invoice No: 120580] updated by Imran  Khan on 22/06/2019 at 01:55 AM");
INSERT INTO crm_audit_log VALUES("7385","3","5","2019-06-22 01:56:23","Exit Invoice [Invoice No: 120581] updated by Imran  Khan on 22/06/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("7386","3","4","2019-06-22 03:31:14","Exit Invoice [Invoice No: 120582] updated by Yasir  Rahman on 22/06/2019 at 03:31 AM");
INSERT INTO crm_audit_log VALUES("7387","2","4","2019-06-22 04:31:23","Entry Invoice [Invoice No: 22099] updated by Yasir  Rahman on 22/06/2019 at 04:31 AM");
INSERT INTO crm_audit_log VALUES("7388","2","4","2019-06-22 04:33:48","Entry Invoice [Invoice No: 22100] updated by Yasir  Rahman on 22/06/2019 at 04:33 AM");
INSERT INTO crm_audit_log VALUES("7389","3","5","2019-06-22 05:05:03","Exit Invoice [Invoice No: 120583] updated by Imran  Khan on 22/06/2019 at 05:05 AM");
INSERT INTO crm_audit_log VALUES("7390","3","5","2019-06-22 05:05:57","Exit Invoice [Invoice No: 120584] updated by Imran  Khan on 22/06/2019 at 05:05 AM");
INSERT INTO crm_audit_log VALUES("7391","2","11","2019-06-22 09:37:05","Entry Invoice [Invoice No: 22101] updated by GAREEB GAREEB on 22/06/2019 at 09:37 AM");
INSERT INTO crm_audit_log VALUES("7392","2","11","2019-06-22 09:45:17","Entry Invoice [Invoice No: 22102] updated by GAREEB GAREEB on 22/06/2019 at 09:45 AM");
INSERT INTO crm_audit_log VALUES("7393","3","15","2019-06-22 10:47:58","Exit Invoice [Invoice No: 120585] updated by Abdul Rasheed on 22/06/2019 at 10:47 AM");
INSERT INTO crm_audit_log VALUES("7394","3","15","2019-06-22 12:25:06","Exit Invoice [Invoice No: 120586] updated by Abdul Rasheed on 22/06/2019 at 12:25 PM");
INSERT INTO crm_audit_log VALUES("7395","2","11","2019-06-22 15:40:38","Entry Invoice [Invoice No: 22103] updated by GAREEB GAREEB on 22/06/2019 at 03:40 PM");
INSERT INTO crm_audit_log VALUES("7396","2","11","2019-06-22 15:41:42","Entry Invoice [Invoice No: 22104] updated by GAREEB GAREEB on 22/06/2019 at 03:41 PM");
INSERT INTO crm_audit_log VALUES("7397","2","11","2019-06-22 15:54:23","Entry Invoice [Invoice No: 22105] updated by GAREEB GAREEB on 22/06/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("7398","3","6","2019-06-22 16:32:26","Exit Invoice [Invoice No: 120571] updated by ASHRAF  M K on 22/06/2019 at 04:32 PM");
INSERT INTO crm_audit_log VALUES("7399","3","4","2019-06-22 17:50:21","Exit Invoice [Invoice No: 120587] updated by Yasir  Rahman on 22/06/2019 at 05:50 PM");
INSERT INTO crm_audit_log VALUES("7400","2","4","2019-06-22 20:20:53","Entry Invoice [Invoice No: 22106] updated by Yasir  Rahman on 22/06/2019 at 08:20 PM");
INSERT INTO crm_audit_log VALUES("7401","2","4","2019-06-22 22:10:25","Entry Invoice [Invoice No: 22107] updated by Yasir  Rahman on 22/06/2019 at 10:10 PM");
INSERT INTO crm_audit_log VALUES("7402","3","4","2019-06-22 23:44:40","Exit Invoice [Invoice No: 120588] updated by Yasir  Rahman on 22/06/2019 at 11:44 PM");
INSERT INTO crm_audit_log VALUES("7403","3","4","2019-06-23 00:59:37","Exit Invoice [Invoice No: 120589] updated by Yasir  Rahman on 23/06/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("7404","3","4","2019-06-23 05:00:10","Exit Invoice [Invoice No: 120590] updated by Yasir  Rahman on 23/06/2019 at 05:00 AM");
INSERT INTO crm_audit_log VALUES("7405","3","4","2019-06-23 07:37:31","Exit Invoice [Invoice No: 120591] updated by Yasir  Rahman on 23/06/2019 at 07:37 AM");
INSERT INTO crm_audit_log VALUES("7406","2","6","2019-06-23 08:55:54","Entry Invoice [Invoice No: 22107] updated by ASHRAF  M K on 23/06/2019 at 08:55 AM");
INSERT INTO crm_audit_log VALUES("7407","2","6","2019-06-23 08:56:54","Entry Invoice [Invoice No: 22107] updated by ASHRAF  M K on 23/06/2019 at 08:56 AM");
INSERT INTO crm_audit_log VALUES("7408","2","6","2019-06-23 08:58:35","Entry Invoice [Invoice No: 22107] updated by ASHRAF  M K on 23/06/2019 at 08:58 AM");
INSERT INTO crm_audit_log VALUES("7409","3","15","2019-06-23 09:13:46","Exit Invoice [Invoice No: 120592] updated by Abdul Rasheed on 23/06/2019 at 09:13 AM");
INSERT INTO crm_audit_log VALUES("7410","2","11","2019-06-23 09:43:29","Entry Invoice [Invoice No: 22108] updated by GAREEB GAREEB on 23/06/2019 at 09:43 AM");
INSERT INTO crm_audit_log VALUES("7411","2","11","2019-06-23 09:45:05","Entry Invoice [Invoice No: 22109] updated by GAREEB GAREEB on 23/06/2019 at 09:45 AM");
INSERT INTO crm_audit_log VALUES("7412","2","11","2019-06-23 09:47:03","Entry Invoice [Invoice No: 22110] updated by GAREEB GAREEB on 23/06/2019 at 09:47 AM");
INSERT INTO crm_audit_log VALUES("7413","2","11","2019-06-23 09:49:00","Entry Invoice [Invoice No: 22111] updated by GAREEB GAREEB on 23/06/2019 at 09:49 AM");
INSERT INTO crm_audit_log VALUES("7414","2","11","2019-06-23 10:05:56","Entry Invoice [Invoice No: 22112] updated by GAREEB GAREEB on 23/06/2019 at 10:05 AM");
INSERT INTO crm_audit_log VALUES("7415","3","15","2019-06-23 10:10:35","Exit Invoice [Invoice No: 120593] updated by Abdul Rasheed on 23/06/2019 at 10:10 AM");
INSERT INTO crm_audit_log VALUES("7416","3","15","2019-06-23 10:12:38","Exit Invoice [Invoice No: 120594] updated by Abdul Rasheed on 23/06/2019 at 10:12 AM");
INSERT INTO crm_audit_log VALUES("7417","3","15","2019-06-23 10:23:05","Exit Invoice [Invoice No: 120595] updated by Abdul Rasheed on 23/06/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("7418","3","15","2019-06-23 11:03:14","Exit Invoice [Invoice No: 120596] updated by Abdul Rasheed on 23/06/2019 at 11:03 AM");
INSERT INTO crm_audit_log VALUES("7419","3","15","2019-06-23 11:11:05","Exit Invoice [Invoice No: 120597] updated by Abdul Rasheed on 23/06/2019 at 11:11 AM");
INSERT INTO crm_audit_log VALUES("7420","3","15","2019-06-23 11:39:55","Exit Invoice [Invoice No: 120598] updated by Abdul Rasheed on 23/06/2019 at 11:39 AM");
INSERT INTO crm_audit_log VALUES("7421","3","15","2019-06-23 12:36:14","Exit Invoice [Invoice No: 120599] updated by Abdul Rasheed on 23/06/2019 at 12:36 PM");
INSERT INTO crm_audit_log VALUES("7422","2","11","2019-06-23 13:47:27","Entry Invoice [Invoice No: 22113] updated by GAREEB GAREEB on 23/06/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("7423","2","11","2019-06-23 13:58:24","Entry Invoice [Invoice No: 22114] updated by GAREEB GAREEB on 23/06/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("7424","2","11","2019-06-23 14:02:20","Entry Invoice [Invoice No: 22115] updated by GAREEB GAREEB on 23/06/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("7425","3","15","2019-06-23 14:02:45","Exit Invoice [Invoice No: 120600] updated by Abdul Rasheed on 23/06/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("7426","1","11","2019-06-23 15:02:48","Customer [Customer No: 452] updated by GAREEB GAREEB on 23/06/2019 at 03:02 PM");
INSERT INTO crm_audit_log VALUES("7427","2","11","2019-06-23 15:04:00","Entry Invoice [Invoice No: 22116] updated by GAREEB GAREEB on 23/06/2019 at 03:04 PM");
INSERT INTO crm_audit_log VALUES("7428","2","6","2019-06-23 15:05:29","Entry Invoice [Invoice No: 22116] updated by ASHRAF  M K on 23/06/2019 at 03:05 PM");
INSERT INTO crm_audit_log VALUES("7429","2","11","2019-06-23 15:54:56","Entry Invoice [Invoice No: 22117] updated by GAREEB GAREEB on 23/06/2019 at 03:54 PM");
INSERT INTO crm_audit_log VALUES("7430","2","11","2019-06-23 16:32:13","Entry Invoice [Invoice No: 22118] updated by GAREEB GAREEB on 23/06/2019 at 04:32 PM");
INSERT INTO crm_audit_log VALUES("7431","3","4","2019-06-23 18:59:21","Exit Invoice [Invoice No: 120601] updated by Yasir  Rahman on 23/06/2019 at 06:59 PM");
INSERT INTO crm_audit_log VALUES("7432","3","4","2019-06-23 20:23:39","Exit Invoice [Invoice No: 120602] updated by Yasir  Rahman on 23/06/2019 at 08:23 PM");
INSERT INTO crm_audit_log VALUES("7433","3","6","2019-06-23 22:09:20","Exit Invoice [Invoice No: 120603] updated by ASHRAF  M K on 23/06/2019 at 10:09 PM");
INSERT INTO crm_audit_log VALUES("7434","3","4","2019-06-23 23:24:15","Exit Invoice [Invoice No: 120604] updated by Yasir  Rahman on 23/06/2019 at 11:24 PM");
INSERT INTO crm_audit_log VALUES("7435","3","4","2019-06-23 23:36:04","Exit Invoice [Invoice No: 120605] updated by Yasir  Rahman on 23/06/2019 at 11:36 PM");
INSERT INTO crm_audit_log VALUES("7436","2","4","2019-06-23 23:51:14","Entry Invoice [Invoice No: 22119] updated by Yasir  Rahman on 23/06/2019 at 11:51 PM");
INSERT INTO crm_audit_log VALUES("7437","3","5","2019-06-24 00:52:46","Exit Invoice [Invoice No: 120606] updated by Imran  Khan on 24/06/2019 at 12:52 AM");
INSERT INTO crm_audit_log VALUES("7438","3","5","2019-06-24 05:04:25","Exit Invoice [Invoice No: 120607] updated by Imran  Khan on 24/06/2019 at 05:04 AM");
INSERT INTO crm_audit_log VALUES("7439","3","5","2019-06-24 05:05:11","Exit Invoice [Invoice No: 120608] updated by Imran  Khan on 24/06/2019 at 05:05 AM");
INSERT INTO crm_audit_log VALUES("7440","2","4","2019-06-24 06:51:46","Entry Invoice [Invoice No: 22120] updated by Yasir  Rahman on 24/06/2019 at 06:51 AM");
INSERT INTO crm_audit_log VALUES("7441","2","4","2019-06-24 06:53:43","Entry Invoice [Invoice No: 22121] updated by Yasir  Rahman on 24/06/2019 at 06:53 AM");
INSERT INTO crm_audit_log VALUES("7442","2","4","2019-06-24 06:55:44","Entry Invoice [Invoice No: 22122] updated by Yasir  Rahman on 24/06/2019 at 06:55 AM");
INSERT INTO crm_audit_log VALUES("7443","1","6","2019-06-24 08:57:17","Customer [Customer No: 453] updated by ASHRAF  M K on 24/06/2019 at 08:57 AM");
INSERT INTO crm_audit_log VALUES("7444","2","6","2019-06-24 09:01:35","Entry Invoice [Invoice No: 22117] updated by ASHRAF  M K on 24/06/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("7445","3","15","2019-06-24 09:55:36","Exit Invoice [Invoice No: 120609] updated by Abdul Rasheed on 24/06/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("7446","2","6","2019-06-24 11:00:38","Entry Invoice [Invoice No: 22123] updated by ASHRAF  M K on 24/06/2019 at 11:00 AM");
INSERT INTO crm_audit_log VALUES("7447","3","15","2019-06-24 11:59:49","Exit Invoice [Invoice No: 120610] updated by Abdul Rasheed on 24/06/2019 at 11:59 AM");
INSERT INTO crm_audit_log VALUES("7448","3","15","2019-06-24 12:52:43","Exit Invoice [Invoice No: 120611] updated by Abdul Rasheed on 24/06/2019 at 12:52 PM");
INSERT INTO crm_audit_log VALUES("7449","3","15","2019-06-24 14:13:11","Exit Invoice [Invoice No: 120612] updated by Abdul Rasheed on 24/06/2019 at 02:13 PM");
INSERT INTO crm_audit_log VALUES("7450","3","15","2019-06-24 15:16:13","Exit Invoice [Invoice No: 120613] updated by Abdul Rasheed on 24/06/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("7451","3","15","2019-06-24 15:23:04","Exit Invoice [Invoice No: 120614] updated by Abdul Rasheed on 24/06/2019 at 03:23 PM");
INSERT INTO crm_audit_log VALUES("7452","3","15","2019-06-24 15:33:52","Exit Invoice [Invoice No: 120615] updated by Abdul Rasheed on 24/06/2019 at 03:33 PM");
INSERT INTO crm_audit_log VALUES("7453","3","15","2019-06-24 15:44:52","Exit Invoice [Invoice No: 120616] updated by Abdul Rasheed on 24/06/2019 at 03:44 PM");
INSERT INTO crm_audit_log VALUES("7454","3","15","2019-06-24 15:53:36","Exit Invoice [Invoice No: 120617] updated by Abdul Rasheed on 24/06/2019 at 03:53 PM");
INSERT INTO crm_audit_log VALUES("7455","3","4","2019-06-24 17:33:43","Exit Invoice [Invoice No: 120618] updated by Yasir  Rahman on 24/06/2019 at 05:33 PM");
INSERT INTO crm_audit_log VALUES("7456","3","4","2019-06-24 17:34:43","Exit Invoice [Invoice No: 120619] updated by Yasir  Rahman on 24/06/2019 at 05:34 PM");
INSERT INTO crm_audit_log VALUES("7457","3","4","2019-06-24 18:06:01","Exit Invoice [Invoice No: 120620] updated by Yasir  Rahman on 24/06/2019 at 06:06 PM");
INSERT INTO crm_audit_log VALUES("7458","2","11","2019-06-24 18:13:29","Entry Invoice [Invoice No: 22124] updated by GAREEB GAREEB on 24/06/2019 at 06:13 PM");
INSERT INTO crm_audit_log VALUES("7459","3","4","2019-06-24 19:18:45","Exit Invoice [Invoice No: 120621] updated by Yasir  Rahman on 24/06/2019 at 07:18 PM");
INSERT INTO crm_audit_log VALUES("7460","3","4","2019-06-24 20:25:17","Exit Invoice [Invoice No: 120622] updated by Yasir  Rahman on 24/06/2019 at 08:25 PM");
INSERT INTO crm_audit_log VALUES("7461","2","4","2019-06-24 21:06:48","Entry Invoice [Invoice No: 22125] updated by Yasir  Rahman on 24/06/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("7462","3","4","2019-06-24 21:42:43","Exit Invoice [Invoice No: 120623] updated by Yasir  Rahman on 24/06/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("7463","2","4","2019-06-24 21:42:52","Entry Invoice [Invoice No: 22126] updated by Yasir  Rahman on 24/06/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("7464","3","4","2019-06-24 21:44:01","Exit Invoice [Invoice No: 120624] updated by Yasir  Rahman on 24/06/2019 at 09:44 PM");
INSERT INTO crm_audit_log VALUES("7465","2","4","2019-06-24 21:44:02","Entry Invoice [Invoice No: 22127] updated by Yasir  Rahman on 24/06/2019 at 09:44 PM");
INSERT INTO crm_audit_log VALUES("7466","3","4","2019-06-24 22:02:41","Exit Invoice [Invoice No: 120625] updated by Yasir  Rahman on 24/06/2019 at 10:02 PM");
INSERT INTO crm_audit_log VALUES("7467","2","4","2019-06-24 23:17:14","Entry Invoice [Invoice No: 22128] updated by Yasir  Rahman on 24/06/2019 at 11:17 PM");
INSERT INTO crm_audit_log VALUES("7468","2","4","2019-06-24 23:19:14","Entry Invoice [Invoice No: 22129] updated by Yasir  Rahman on 24/06/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("7469","3","5","2019-06-25 00:49:16","Exit Invoice [Invoice No: 120626] updated by Imran  Khan on 25/06/2019 at 12:49 AM");
INSERT INTO crm_audit_log VALUES("7470","3","5","2019-06-25 01:22:26","Exit Invoice [Invoice No: 120627] updated by Imran  Khan on 25/06/2019 at 01:22 AM");
INSERT INTO crm_audit_log VALUES("7471","3","5","2019-06-25 01:23:07","Exit Invoice [Invoice No: 120628] updated by Imran  Khan on 25/06/2019 at 01:23 AM");
INSERT INTO crm_audit_log VALUES("7472","3","5","2019-06-25 03:02:21","Exit Invoice [Invoice No: 120629] updated by Imran  Khan on 25/06/2019 at 03:02 AM");
INSERT INTO crm_audit_log VALUES("7473","3","5","2019-06-25 05:36:57","Exit Invoice [Invoice No: 120630] updated by Imran  Khan on 25/06/2019 at 05:36 AM");
INSERT INTO crm_audit_log VALUES("7474","3","5","2019-06-25 05:49:30","Exit Invoice [Invoice No: 120631] updated by Imran  Khan on 25/06/2019 at 05:49 AM");
INSERT INTO crm_audit_log VALUES("7475","3","5","2019-06-25 07:40:36","Exit Invoice [Invoice No: 120632] updated by Imran  Khan on 25/06/2019 at 07:40 AM");
INSERT INTO crm_audit_log VALUES("7476","3","4","2019-06-25 11:21:22","Exit Invoice [Invoice No: 120633] updated by Yasir  Rahman on 25/06/2019 at 11:21 AM");
INSERT INTO crm_audit_log VALUES("7477","3","4","2019-06-25 11:23:02","Exit Invoice [Invoice No: 120634] updated by Yasir  Rahman on 25/06/2019 at 11:23 AM");
INSERT INTO crm_audit_log VALUES("7478","3","4","2019-06-25 11:24:41","Exit Invoice [Invoice No: 120635] updated by Yasir  Rahman on 25/06/2019 at 11:24 AM");
INSERT INTO crm_audit_log VALUES("7479","2","6","2019-06-25 12:20:45","Entry Invoice [Invoice No: 22130] updated by ASHRAF  M K on 25/06/2019 at 12:20 PM");
INSERT INTO crm_audit_log VALUES("7480","3","13","2019-06-25 12:21:04","Exit Invoice [Invoice No: 120636] updated by MUHAMMED HASHIM on 25/06/2019 at 12:21 PM");
INSERT INTO crm_audit_log VALUES("7481","2","6","2019-06-25 12:21:45","Entry Invoice [Invoice No: 22131] updated by ASHRAF  M K on 25/06/2019 at 12:21 PM");
INSERT INTO crm_audit_log VALUES("7482","3","13","2019-06-25 12:37:04","Exit Invoice [Invoice No: 120637] updated by MUHAMMED HASHIM on 25/06/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("7483","3","13","2019-06-25 13:32:47","Exit Invoice [Invoice No: 120638] updated by MUHAMMED HASHIM on 25/06/2019 at 01:32 PM");
INSERT INTO crm_audit_log VALUES("7484","2","6","2019-06-25 13:46:35","Entry Invoice [Invoice No: 22132] updated by ASHRAF  M K on 25/06/2019 at 01:46 PM");
INSERT INTO crm_audit_log VALUES("7485","2","6","2019-06-25 13:49:13","Entry Invoice [Invoice No: 22133] updated by ASHRAF  M K on 25/06/2019 at 01:49 PM");
INSERT INTO crm_audit_log VALUES("7486","3","13","2019-06-25 14:07:13","Exit Invoice [Invoice No: 120639] updated by MUHAMMED HASHIM on 25/06/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("7487","3","13","2019-06-25 14:40:09","Exit Invoice [Invoice No: 120640] updated by MUHAMMED HASHIM on 25/06/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("7488","3","13","2019-06-25 14:51:47","Exit Invoice [Invoice No: 120641] updated by MUHAMMED HASHIM on 25/06/2019 at 02:51 PM");
INSERT INTO crm_audit_log VALUES("7489","3","13","2019-06-25 15:04:34","Exit Invoice [Invoice No: 120642] updated by MUHAMMED HASHIM on 25/06/2019 at 03:04 PM");
INSERT INTO crm_audit_log VALUES("7490","2","6","2019-06-25 15:18:03","Entry Invoice [Invoice No: 22134] updated by ASHRAF  M K on 25/06/2019 at 03:18 PM");
INSERT INTO crm_audit_log VALUES("7491","3","4","2019-06-25 16:39:13","Exit Invoice [Invoice No: 120643] updated by Yasir  Rahman on 25/06/2019 at 04:39 PM");
INSERT INTO crm_audit_log VALUES("7492","3","4","2019-06-25 16:40:09","Exit Invoice [Invoice No: 120644] updated by Yasir  Rahman on 25/06/2019 at 04:40 PM");
INSERT INTO crm_audit_log VALUES("7493","3","4","2019-06-25 16:52:01","Exit Invoice [Invoice No: 120645] updated by Yasir  Rahman on 25/06/2019 at 04:52 PM");
INSERT INTO crm_audit_log VALUES("7494","3","4","2019-06-25 17:00:33","Exit Invoice [Invoice No: 120646] updated by Yasir  Rahman on 25/06/2019 at 05:00 PM");
INSERT INTO crm_audit_log VALUES("7495","3","4","2019-06-25 17:15:45","Exit Invoice [Invoice No: 120647] updated by Yasir  Rahman on 25/06/2019 at 05:15 PM");
INSERT INTO crm_audit_log VALUES("7496","3","4","2019-06-25 17:22:51","Exit Invoice [Invoice No: 120648] updated by Yasir  Rahman on 25/06/2019 at 05:22 PM");
INSERT INTO crm_audit_log VALUES("7497","3","4","2019-06-25 17:30:46","Exit Invoice [Invoice No: 120649] updated by Yasir  Rahman on 25/06/2019 at 05:30 PM");
INSERT INTO crm_audit_log VALUES("7498","3","4","2019-06-25 17:37:00","Exit Invoice [Invoice No: 120650] updated by Yasir  Rahman on 25/06/2019 at 05:37 PM");
INSERT INTO crm_audit_log VALUES("7499","3","4","2019-06-25 17:44:56","Exit Invoice [Invoice No: 120651] updated by Yasir  Rahman on 25/06/2019 at 05:44 PM");
INSERT INTO crm_audit_log VALUES("7500","3","4","2019-06-25 18:34:22","Exit Invoice [Invoice No: 120652] updated by Yasir  Rahman on 25/06/2019 at 06:34 PM");
INSERT INTO crm_audit_log VALUES("7501","3","4","2019-06-25 18:46:10","Exit Invoice [Invoice No: 120653] updated by Yasir  Rahman on 25/06/2019 at 06:46 PM");
INSERT INTO crm_audit_log VALUES("7502","2","6","2019-06-25 19:09:45","Entry Invoice [Invoice No: 22135] updated by ASHRAF  M K on 25/06/2019 at 07:09 PM");
INSERT INTO crm_audit_log VALUES("7503","3","4","2019-06-25 19:19:59","Exit Invoice [Invoice No: 120654] updated by Yasir  Rahman on 25/06/2019 at 07:19 PM");
INSERT INTO crm_audit_log VALUES("7504","3","6","2019-06-25 20:09:39","Exit Invoice [Invoice No: 120638] updated by ASHRAF  M K on 25/06/2019 at 08:09 PM");
INSERT INTO crm_audit_log VALUES("7505","3","6","2019-06-25 20:20:26","Exit Invoice [Invoice No: 120655] updated by ASHRAF  M K on 25/06/2019 at 08:20 PM");
INSERT INTO crm_audit_log VALUES("7506","3","6","2019-06-25 20:20:57","Exit Invoice [Invoice No: 120654] updated by ASHRAF  M K on 25/06/2019 at 08:20 PM");
INSERT INTO crm_audit_log VALUES("7507","3","6","2019-06-25 20:21:23","Exit Invoice [Invoice No: 120652] updated by ASHRAF  M K on 25/06/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("7508","3","6","2019-06-25 20:21:33","Exit Invoice [Invoice No: 120651] updated by ASHRAF  M K on 25/06/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("7509","3","6","2019-06-25 20:21:42","Exit Invoice [Invoice No: 120650] updated by ASHRAF  M K on 25/06/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("7510","3","6","2019-06-25 20:21:53","Exit Invoice [Invoice No: 120649] updated by ASHRAF  M K on 25/06/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("7511","3","6","2019-06-25 20:22:03","Exit Invoice [Invoice No: 120648] updated by ASHRAF  M K on 25/06/2019 at 08:22 PM");
INSERT INTO crm_audit_log VALUES("7512","3","6","2019-06-25 20:22:13","Exit Invoice [Invoice No: 120647] updated by ASHRAF  M K on 25/06/2019 at 08:22 PM");
INSERT INTO crm_audit_log VALUES("7513","3","6","2019-06-25 20:22:24","Exit Invoice [Invoice No: 120646] updated by ASHRAF  M K on 25/06/2019 at 08:22 PM");
INSERT INTO crm_audit_log VALUES("7514","3","6","2019-06-25 20:22:41","Exit Invoice [Invoice No: 120645] updated by ASHRAF  M K on 25/06/2019 at 08:22 PM");
INSERT INTO crm_audit_log VALUES("7515","3","6","2019-06-25 20:22:54","Exit Invoice [Invoice No: 120644] updated by ASHRAF  M K on 25/06/2019 at 08:22 PM");
INSERT INTO crm_audit_log VALUES("7516","3","6","2019-06-25 20:23:05","Exit Invoice [Invoice No: 120643] updated by ASHRAF  M K on 25/06/2019 at 08:23 PM");
INSERT INTO crm_audit_log VALUES("7517","2","4","2019-06-25 22:49:48","Entry Invoice [Invoice No: 22136] updated by Yasir  Rahman on 25/06/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("7518","2","4","2019-06-25 22:56:36","Entry Invoice [Invoice No: 22137] updated by Yasir  Rahman on 25/06/2019 at 10:56 PM");
INSERT INTO crm_audit_log VALUES("7519","2","4","2019-06-25 22:58:23","Entry Invoice [Invoice No: 22138] updated by Yasir  Rahman on 25/06/2019 at 10:58 PM");
INSERT INTO crm_audit_log VALUES("7520","3","4","2019-06-25 22:58:46","Exit Invoice [Invoice No: 120656] updated by Yasir  Rahman on 25/06/2019 at 10:58 PM");
INSERT INTO crm_audit_log VALUES("7521","2","4","2019-06-25 22:59:23","Entry Invoice [Invoice No: 22139] updated by Yasir  Rahman on 25/06/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("7522","2","4","2019-06-25 23:00:46","Entry Invoice [Invoice No: 22140] updated by Yasir  Rahman on 25/06/2019 at 11:00 PM");
INSERT INTO crm_audit_log VALUES("7523","2","4","2019-06-25 23:01:40","Entry Invoice [Invoice No: 22141] updated by Yasir  Rahman on 25/06/2019 at 11:01 PM");
INSERT INTO crm_audit_log VALUES("7524","3","4","2019-06-25 23:09:29","Exit Invoice [Invoice No: 120657] updated by Yasir  Rahman on 25/06/2019 at 11:09 PM");
INSERT INTO crm_audit_log VALUES("7525","2","4","2019-06-25 23:11:41","Entry Invoice [Invoice No: 22142] updated by Yasir  Rahman on 25/06/2019 at 11:11 PM");
INSERT INTO crm_audit_log VALUES("7526","3","5","2019-06-26 00:47:40","Exit Invoice [Invoice No: 120658] updated by Imran  Khan on 26/06/2019 at 12:47 AM");
INSERT INTO crm_audit_log VALUES("7527","3","5","2019-06-26 01:43:39","Exit Invoice [Invoice No: 120659] updated by Imran  Khan on 26/06/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("7528","2","4","2019-06-26 02:28:46","Entry Invoice [Invoice No: 22143] updated by Yasir  Rahman on 26/06/2019 at 02:28 AM");
INSERT INTO crm_audit_log VALUES("7529","2","4","2019-06-26 02:30:38","Entry Invoice [Invoice No: 22144] updated by Yasir  Rahman on 26/06/2019 at 02:30 AM");
INSERT INTO crm_audit_log VALUES("7530","2","4","2019-06-26 02:37:33","Entry Invoice [Invoice No: 22145] updated by Yasir  Rahman on 26/06/2019 at 02:37 AM");
INSERT INTO crm_audit_log VALUES("7531","2","4","2019-06-26 02:38:58","Entry Invoice [Invoice No: 22146] updated by Yasir  Rahman on 26/06/2019 at 02:38 AM");
INSERT INTO crm_audit_log VALUES("7532","2","4","2019-06-26 02:40:25","Entry Invoice [Invoice No: 22147] updated by Yasir  Rahman on 26/06/2019 at 02:40 AM");
INSERT INTO crm_audit_log VALUES("7533","2","4","2019-06-26 02:44:25","Entry Invoice [Invoice No: 22148] updated by Yasir  Rahman on 26/06/2019 at 02:44 AM");
INSERT INTO crm_audit_log VALUES("7534","2","4","2019-06-26 02:45:52","Entry Invoice [Invoice No: 22149] updated by Yasir  Rahman on 26/06/2019 at 02:45 AM");
INSERT INTO crm_audit_log VALUES("7535","3","4","2019-06-26 02:55:55","Exit Invoice [Invoice No: 120660] updated by Yasir  Rahman on 26/06/2019 at 02:55 AM");
INSERT INTO crm_audit_log VALUES("7536","3","4","2019-06-26 07:46:50","Exit Invoice [Invoice No: 120661] updated by Yasir  Rahman on 26/06/2019 at 07:46 AM");
INSERT INTO crm_audit_log VALUES("7537","3","4","2019-06-26 08:29:30","Exit Invoice [Invoice No: 120662] updated by Yasir  Rahman on 26/06/2019 at 08:29 AM");
INSERT INTO crm_audit_log VALUES("7538","3","4","2019-06-26 08:59:15","Exit Invoice [Invoice No: 120663] updated by Yasir  Rahman on 26/06/2019 at 08:59 AM");
INSERT INTO crm_audit_log VALUES("7539","3","15","2019-06-26 10:30:47","Exit Invoice [Invoice No: 120664] updated by Abdul Rasheed on 26/06/2019 at 10:30 AM");
INSERT INTO crm_audit_log VALUES("7540","3","15","2019-06-26 10:54:27","Exit Invoice [Invoice No: 120665] updated by Abdul Rasheed on 26/06/2019 at 10:54 AM");
INSERT INTO crm_audit_log VALUES("7541","3","15","2019-06-26 10:56:10","Exit Invoice [Invoice No: 120666] updated by Abdul Rasheed on 26/06/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("7542","3","15","2019-06-26 11:00:47","Exit Invoice [Invoice No: 120667] updated by Abdul Rasheed on 26/06/2019 at 11:00 AM");
INSERT INTO crm_audit_log VALUES("7543","3","15","2019-06-26 11:51:17","Exit Invoice [Invoice No: 120668] updated by Abdul Rasheed on 26/06/2019 at 11:51 AM");
INSERT INTO crm_audit_log VALUES("7544","2","11","2019-06-26 11:56:06","Entry Invoice [Invoice No: 22150] updated by GAREEB GAREEB on 26/06/2019 at 11:56 AM");
INSERT INTO crm_audit_log VALUES("7545","3","15","2019-06-26 11:57:35","Exit Invoice [Invoice No: 120669] updated by Abdul Rasheed on 26/06/2019 at 11:57 AM");
INSERT INTO crm_audit_log VALUES("7546","3","15","2019-06-26 12:08:03","Exit Invoice [Invoice No: 120670] updated by Abdul Rasheed on 26/06/2019 at 12:08 PM");
INSERT INTO crm_audit_log VALUES("7547","3","15","2019-06-26 12:54:27","Exit Invoice [Invoice No: 120671] updated by Abdul Rasheed on 26/06/2019 at 12:54 PM");
INSERT INTO crm_audit_log VALUES("7548","3","15","2019-06-26 13:45:34","Exit Invoice [Invoice No: 120672] updated by Abdul Rasheed on 26/06/2019 at 01:45 PM");
INSERT INTO crm_audit_log VALUES("7549","3","15","2019-06-26 14:00:17","Exit Invoice [Invoice No: 120673] updated by Abdul Rasheed on 26/06/2019 at 02:00 PM");
INSERT INTO crm_audit_log VALUES("7550","3","15","2019-06-26 14:09:27","Exit Invoice [Invoice No: 120674] updated by Abdul Rasheed on 26/06/2019 at 02:09 PM");
INSERT INTO crm_audit_log VALUES("7551","3","15","2019-06-26 14:15:04","Exit Invoice [Invoice No: 120675] updated by Abdul Rasheed on 26/06/2019 at 02:15 PM");
INSERT INTO crm_audit_log VALUES("7552","3","15","2019-06-26 14:53:21","Exit Invoice [Invoice No: 120676] updated by Abdul Rasheed on 26/06/2019 at 02:53 PM");
INSERT INTO crm_audit_log VALUES("7553","3","6","2019-06-26 15:01:06","Exit Invoice [Invoice No: 120659] updated by ASHRAF  M K on 26/06/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("7554","3","6","2019-06-26 15:01:26","Exit Invoice [Invoice No: 120658] updated by ASHRAF  M K on 26/06/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("7555","3","15","2019-06-26 15:50:26","Exit Invoice [Invoice No: 120677] updated by Abdul Rasheed on 26/06/2019 at 03:50 PM");
INSERT INTO crm_audit_log VALUES("7556","3","4","2019-06-26 16:58:15","Exit Invoice [Invoice No: 120678] updated by Yasir  Rahman on 26/06/2019 at 04:58 PM");
INSERT INTO crm_audit_log VALUES("7557","3","4","2019-06-26 17:18:43","Exit Invoice [Invoice No: 120679] updated by Yasir  Rahman on 26/06/2019 at 05:18 PM");
INSERT INTO crm_audit_log VALUES("7558","3","4","2019-06-26 17:30:02","Exit Invoice [Invoice No: 120680] updated by Yasir  Rahman on 26/06/2019 at 05:30 PM");
INSERT INTO crm_audit_log VALUES("7559","3","4","2019-06-26 19:23:54","Exit Invoice [Invoice No: 120681] updated by Yasir  Rahman on 26/06/2019 at 07:23 PM");
INSERT INTO crm_audit_log VALUES("7560","3","4","2019-06-26 21:56:56","Exit Invoice [Invoice No: 120682] updated by Yasir  Rahman on 26/06/2019 at 09:56 PM");
INSERT INTO crm_audit_log VALUES("7561","3","4","2019-06-26 21:57:46","Exit Invoice [Invoice No: 120683] updated by Yasir  Rahman on 26/06/2019 at 09:57 PM");
INSERT INTO crm_audit_log VALUES("7562","3","4","2019-06-26 21:58:49","Exit Invoice [Invoice No: 120684] updated by Yasir  Rahman on 26/06/2019 at 09:58 PM");
INSERT INTO crm_audit_log VALUES("7563","3","4","2019-06-26 21:59:48","Exit Invoice [Invoice No: 120685] updated by Yasir  Rahman on 26/06/2019 at 09:59 PM");
INSERT INTO crm_audit_log VALUES("7564","3","5","2019-06-27 00:28:56","Exit Invoice [Invoice No: 120686] updated by Imran  Khan on 27/06/2019 at 12:28 AM");
INSERT INTO crm_audit_log VALUES("7565","2","4","2019-06-27 02:04:09","Entry Invoice [Invoice No: 22151] updated by Yasir  Rahman on 27/06/2019 at 02:04 AM");
INSERT INTO crm_audit_log VALUES("7566","3","5","2019-06-27 04:40:50","Exit Invoice [Invoice No: 120687] updated by Imran  Khan on 27/06/2019 at 04:40 AM");
INSERT INTO crm_audit_log VALUES("7567","2","4","2019-06-27 05:16:10","Entry Invoice [Invoice No: 22152] updated by Yasir  Rahman on 27/06/2019 at 05:16 AM");
INSERT INTO crm_audit_log VALUES("7568","2","11","2019-06-27 09:11:29","Entry Invoice [Invoice No: 22153] updated by GAREEB GAREEB on 27/06/2019 at 09:11 AM");
INSERT INTO crm_audit_log VALUES("7569","3","15","2019-06-27 09:14:35","Exit Invoice [Invoice No: 120688] updated by Abdul Rasheed on 27/06/2019 at 09:14 AM");
INSERT INTO crm_audit_log VALUES("7570","3","15","2019-06-27 09:15:52","Exit Invoice [Invoice No: 120689] updated by Abdul Rasheed on 27/06/2019 at 09:15 AM");
INSERT INTO crm_audit_log VALUES("7571","3","15","2019-06-27 09:18:28","Exit Invoice [Invoice No: 120690] updated by Abdul Rasheed on 27/06/2019 at 09:18 AM");
INSERT INTO crm_audit_log VALUES("7572","3","15","2019-06-27 09:20:41","Exit Invoice [Invoice No: 120691] updated by Abdul Rasheed on 27/06/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("7573","3","6","2019-06-27 09:25:12","Exit Invoice [Invoice No: 120689] updated by ASHRAF  M K on 27/06/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("7574","3","6","2019-06-27 09:43:20","Exit Invoice [Invoice No: 120692] updated by ASHRAF  M K on 27/06/2019 at 09:43 AM");
INSERT INTO crm_audit_log VALUES("7575","3","6","2019-06-27 10:00:07","Exit Invoice [Invoice No: 120693] updated by ASHRAF  M K on 27/06/2019 at 10:00 AM");
INSERT INTO crm_audit_log VALUES("7576","3","6","2019-06-27 10:21:51","Exit Invoice [Invoice No: 120694] updated by ASHRAF  M K on 27/06/2019 at 10:21 AM");
INSERT INTO crm_audit_log VALUES("7577","2","13","2019-06-27 10:31:44","Entry Invoice [Invoice No: 22154] updated by MUHAMMED HASHIM on 27/06/2019 at 10:31 AM");
INSERT INTO crm_audit_log VALUES("7578","3","6","2019-06-27 10:39:58","Exit Invoice [Invoice No: 120695] updated by ASHRAF  M K on 27/06/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("7579","3","6","2019-06-27 11:19:14","Exit Invoice [Invoice No: 120696] updated by ASHRAF  M K on 27/06/2019 at 11:19 AM");
INSERT INTO crm_audit_log VALUES("7580","2","11","2019-06-27 11:19:30","Entry Invoice [Invoice No: 22155] updated by GAREEB GAREEB on 27/06/2019 at 11:19 AM");
INSERT INTO crm_audit_log VALUES("7581","3","6","2019-06-27 11:27:53","Exit Invoice [Invoice No: 120697] updated by ASHRAF  M K on 27/06/2019 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("7582","3","6","2019-06-27 11:40:18","Exit Invoice [Invoice No: 120698] updated by ASHRAF  M K on 27/06/2019 at 11:40 AM");
INSERT INTO crm_audit_log VALUES("7583","3","6","2019-06-27 11:52:56","Exit Invoice [Invoice No: 120699] updated by ASHRAF  M K on 27/06/2019 at 11:52 AM");
INSERT INTO crm_audit_log VALUES("7584","1","6","2019-06-27 12:12:25","Customer [Customer No: 454] updated by ASHRAF  M K on 27/06/2019 at 12:12 PM");
INSERT INTO crm_audit_log VALUES("7585","1","6","2019-06-27 12:12:52","Customer [Customer No: 454] updated by ASHRAF  M K on 27/06/2019 at 12:12 PM");
INSERT INTO crm_audit_log VALUES("7586","3","6","2019-06-27 12:14:31","Exit Invoice [Invoice No: 120700] updated by ASHRAF  M K on 27/06/2019 at 12:14 PM");
INSERT INTO crm_audit_log VALUES("7587","3","6","2019-06-27 12:24:52","Exit Invoice [Invoice No: 120701] updated by ASHRAF  M K on 27/06/2019 at 12:24 PM");
INSERT INTO crm_audit_log VALUES("7588","3","6","2019-06-27 12:49:16","Exit Invoice [Invoice No: 120702] updated by ASHRAF  M K on 27/06/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("7589","3","6","2019-06-27 13:08:26","Exit Invoice [Invoice No: 120703] updated by ASHRAF  M K on 27/06/2019 at 01:08 PM");
INSERT INTO crm_audit_log VALUES("7590","3","6","2019-06-27 13:16:39","Exit Invoice [Invoice No: 120704] updated by ASHRAF  M K on 27/06/2019 at 01:16 PM");
INSERT INTO crm_audit_log VALUES("7591","3","6","2019-06-27 13:22:52","Exit Invoice [Invoice No: 120705] updated by ASHRAF  M K on 27/06/2019 at 01:22 PM");
INSERT INTO crm_audit_log VALUES("7592","3","6","2019-06-27 13:35:34","Exit Invoice [Invoice No: 120706] updated by ASHRAF  M K on 27/06/2019 at 01:35 PM");
INSERT INTO crm_audit_log VALUES("7593","3","15","2019-06-27 16:02:59","Exit Invoice [Invoice No: 120707] updated by Abdul Rasheed on 27/06/2019 at 04:02 PM");
INSERT INTO crm_audit_log VALUES("7594","3","4","2019-06-27 17:13:46","Exit Invoice [Invoice No: 120708] updated by Yasir  Rahman on 27/06/2019 at 05:13 PM");
INSERT INTO crm_audit_log VALUES("7595","2","11","2019-06-27 17:51:16","Entry Invoice [Invoice No: 22156] updated by GAREEB GAREEB on 27/06/2019 at 05:51 PM");
INSERT INTO crm_audit_log VALUES("7596","3","4","2019-06-27 17:56:31","Exit Invoice [Invoice No: 120709] updated by Yasir  Rahman on 27/06/2019 at 05:56 PM");
INSERT INTO crm_audit_log VALUES("7597","3","4","2019-06-27 18:25:11","Exit Invoice [Invoice No: 120710] updated by Yasir  Rahman on 27/06/2019 at 06:25 PM");
INSERT INTO crm_audit_log VALUES("7598","3","4","2019-06-27 18:32:58","Exit Invoice [Invoice No: 120711] updated by Yasir  Rahman on 27/06/2019 at 06:32 PM");
INSERT INTO crm_audit_log VALUES("7599","3","4","2019-06-27 18:43:22","Exit Invoice [Invoice No: 120712] updated by Yasir  Rahman on 27/06/2019 at 06:43 PM");
INSERT INTO crm_audit_log VALUES("7600","3","4","2019-06-27 18:52:46","Exit Invoice [Invoice No: 120713] updated by Yasir  Rahman on 27/06/2019 at 06:52 PM");
INSERT INTO crm_audit_log VALUES("7601","3","4","2019-06-27 18:59:23","Exit Invoice [Invoice No: 120714] updated by Yasir  Rahman on 27/06/2019 at 06:59 PM");
INSERT INTO crm_audit_log VALUES("7602","3","4","2019-06-27 19:09:35","Exit Invoice [Invoice No: 120715] updated by Yasir  Rahman on 27/06/2019 at 07:09 PM");
INSERT INTO crm_audit_log VALUES("7603","3","4","2019-06-27 19:22:26","Exit Invoice [Invoice No: 120716] updated by Yasir  Rahman on 27/06/2019 at 07:22 PM");
INSERT INTO crm_audit_log VALUES("7604","3","4","2019-06-27 19:35:11","Exit Invoice [Invoice No: 120717] updated by Yasir  Rahman on 27/06/2019 at 07:35 PM");
INSERT INTO crm_audit_log VALUES("7605","3","4","2019-06-27 19:56:26","Exit Invoice [Invoice No: 120718] updated by Yasir  Rahman on 27/06/2019 at 07:56 PM");
INSERT INTO crm_audit_log VALUES("7606","3","4","2019-06-27 20:18:54","Exit Invoice [Invoice No: 120719] updated by Yasir  Rahman on 27/06/2019 at 08:18 PM");
INSERT INTO crm_audit_log VALUES("7607","2","4","2019-06-27 20:43:54","Entry Invoice [Invoice No: 22157] updated by Yasir  Rahman on 27/06/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("7608","3","4","2019-06-27 21:07:07","Exit Invoice [Invoice No: 120720] updated by Yasir  Rahman on 27/06/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("7609","2","4","2019-06-27 23:16:20","Entry Invoice [Invoice No: 22158] updated by Yasir  Rahman on 27/06/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("7610","3","4","2019-06-27 23:27:19","Exit Invoice [Invoice No: 120721] updated by Yasir  Rahman on 27/06/2019 at 11:27 PM");
INSERT INTO crm_audit_log VALUES("7611","3","4","2019-06-27 23:38:05","Exit Invoice [Invoice No: 120722] updated by Yasir  Rahman on 27/06/2019 at 11:38 PM");
INSERT INTO crm_audit_log VALUES("7612","3","4","2019-06-27 23:57:55","Exit Invoice [Invoice No: 120723] updated by Yasir  Rahman on 27/06/2019 at 11:57 PM");
INSERT INTO crm_audit_log VALUES("7613","3","4","2019-06-28 00:19:13","Exit Invoice [Invoice No: 120724] updated by Yasir  Rahman on 28/06/2019 at 12:19 AM");
INSERT INTO crm_audit_log VALUES("7614","3","5","2019-06-28 01:40:55","Exit Invoice [Invoice No: 120725] updated by Imran  Khan on 28/06/2019 at 01:40 AM");
INSERT INTO crm_audit_log VALUES("7615","3","5","2019-06-28 01:41:41","Exit Invoice [Invoice No: 120726] updated by Imran  Khan on 28/06/2019 at 01:41 AM");
INSERT INTO crm_audit_log VALUES("7616","3","4","2019-06-28 02:13:23","Exit Invoice [Invoice No: 120727] updated by Yasir  Rahman on 28/06/2019 at 02:13 AM");
INSERT INTO crm_audit_log VALUES("7617","3","4","2019-06-28 02:15:25","Exit Invoice [Invoice No: 120728] updated by Yasir  Rahman on 28/06/2019 at 02:15 AM");
INSERT INTO crm_audit_log VALUES("7618","3","5","2019-06-28 03:33:49","Exit Invoice [Invoice No: 120729] updated by Imran  Khan on 28/06/2019 at 03:33 AM");
INSERT INTO crm_audit_log VALUES("7619","2","4","2019-06-28 04:57:42","Entry Invoice [Invoice No: 22159] updated by Yasir  Rahman on 28/06/2019 at 04:57 AM");
INSERT INTO crm_audit_log VALUES("7620","2","4","2019-06-28 05:02:02","Entry Invoice [Invoice No: 22160] updated by Yasir  Rahman on 28/06/2019 at 05:02 AM");
INSERT INTO crm_audit_log VALUES("7621","3","5","2019-06-28 06:39:57","Exit Invoice [Invoice No: 120730] updated by Imran  Khan on 28/06/2019 at 06:39 AM");
INSERT INTO crm_audit_log VALUES("7622","2","4","2019-06-28 07:28:42","Entry Invoice [Invoice No: 22161] updated by Yasir  Rahman on 28/06/2019 at 07:28 AM");
INSERT INTO crm_audit_log VALUES("7623","2","4","2019-06-28 07:31:47","Entry Invoice [Invoice No: 22162] updated by Yasir  Rahman on 28/06/2019 at 07:31 AM");
INSERT INTO crm_audit_log VALUES("7624","2","4","2019-06-28 07:33:20","Entry Invoice [Invoice No: 22163] updated by Yasir  Rahman on 28/06/2019 at 07:33 AM");
INSERT INTO crm_audit_log VALUES("7625","2","4","2019-06-28 07:43:07","Entry Invoice [Invoice No: 22164] updated by Yasir  Rahman on 28/06/2019 at 07:43 AM");
INSERT INTO crm_audit_log VALUES("7626","3","4","2019-06-28 07:50:02","Exit Invoice [Invoice No: 120731] updated by Yasir  Rahman on 28/06/2019 at 07:50 AM");
INSERT INTO crm_audit_log VALUES("7627","3","6","2019-06-28 08:16:28","Exit Invoice [Invoice No: 120731] updated by ASHRAF  M K on 28/06/2019 at 08:16 AM");
INSERT INTO crm_audit_log VALUES("7628","3","15","2019-06-28 08:48:00","Exit Invoice [Invoice No: 120732] updated by Abdul Rasheed on 28/06/2019 at 08:48 AM");
INSERT INTO crm_audit_log VALUES("7629","3","15","2019-06-28 08:49:14","Exit Invoice [Invoice No: 120733] updated by Abdul Rasheed on 28/06/2019 at 08:49 AM");
INSERT INTO crm_audit_log VALUES("7630","3","15","2019-06-28 09:13:55","Exit Invoice [Invoice No: 120734] updated by Abdul Rasheed on 28/06/2019 at 09:13 AM");
INSERT INTO crm_audit_log VALUES("7631","3","15","2019-06-28 09:15:28","Exit Invoice [Invoice No: 120735] updated by Abdul Rasheed on 28/06/2019 at 09:15 AM");
INSERT INTO crm_audit_log VALUES("7632","3","15","2019-06-28 09:37:34","Exit Invoice [Invoice No: 120736] updated by Abdul Rasheed on 28/06/2019 at 09:37 AM");
INSERT INTO crm_audit_log VALUES("7633","3","15","2019-06-28 09:56:57","Exit Invoice [Invoice No: 120737] updated by Abdul Rasheed on 28/06/2019 at 09:56 AM");
INSERT INTO crm_audit_log VALUES("7634","3","15","2019-06-28 10:03:07","Exit Invoice [Invoice No: 120738] updated by Abdul Rasheed on 28/06/2019 at 10:03 AM");
INSERT INTO crm_audit_log VALUES("7635","2","11","2019-06-28 10:04:48","Entry Invoice [Invoice No: 22165] updated by GAREEB GAREEB on 28/06/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("7636","2","11","2019-06-28 10:06:23","Entry Invoice [Invoice No: 22166] updated by GAREEB GAREEB on 28/06/2019 at 10:06 AM");
INSERT INTO crm_audit_log VALUES("7637","3","15","2019-06-28 10:43:55","Exit Invoice [Invoice No: 120739] updated by Abdul Rasheed on 28/06/2019 at 10:43 AM");
INSERT INTO crm_audit_log VALUES("7638","3","15","2019-06-28 10:51:10","Exit Invoice [Invoice No: 120740] updated by Abdul Rasheed on 28/06/2019 at 10:51 AM");
INSERT INTO crm_audit_log VALUES("7639","3","15","2019-06-28 11:28:20","Exit Invoice [Invoice No: 120741] updated by Abdul Rasheed on 28/06/2019 at 11:28 AM");
INSERT INTO crm_audit_log VALUES("7640","3","15","2019-06-28 11:42:56","Exit Invoice [Invoice No: 120742] updated by Abdul Rasheed on 28/06/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("7641","3","15","2019-06-28 11:53:05","Exit Invoice [Invoice No: 120743] updated by Abdul Rasheed on 28/06/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("7642","3","15","2019-06-28 13:40:39","Exit Invoice [Invoice No: 120744] updated by Abdul Rasheed on 28/06/2019 at 01:40 PM");
INSERT INTO crm_audit_log VALUES("7643","3","15","2019-06-28 13:47:14","Exit Invoice [Invoice No: 120745] updated by Abdul Rasheed on 28/06/2019 at 01:47 PM");
INSERT INTO crm_audit_log VALUES("7644","3","15","2019-06-28 13:51:27","Exit Invoice [Invoice No: 120746] updated by Abdul Rasheed on 28/06/2019 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("7645","3","15","2019-06-28 13:59:19","Exit Invoice [Invoice No: 120747] updated by Abdul Rasheed on 28/06/2019 at 01:59 PM");
INSERT INTO crm_audit_log VALUES("7646","3","15","2019-06-28 14:05:39","Exit Invoice [Invoice No: 120748] updated by Abdul Rasheed on 28/06/2019 at 02:05 PM");
INSERT INTO crm_audit_log VALUES("7647","3","15","2019-06-28 14:31:25","Exit Invoice [Invoice No: 120749] updated by Abdul Rasheed on 28/06/2019 at 02:31 PM");
INSERT INTO crm_audit_log VALUES("7648","3","15","2019-06-28 14:48:05","Exit Invoice [Invoice No: 120750] updated by Abdul Rasheed on 28/06/2019 at 02:48 PM");
INSERT INTO crm_audit_log VALUES("7649","2","11","2019-06-28 15:16:10","Entry Invoice [Invoice No: 22167] updated by GAREEB GAREEB on 28/06/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("7650","2","11","2019-06-28 15:25:47","Entry Invoice [Invoice No: 22168] updated by GAREEB GAREEB on 28/06/2019 at 03:25 PM");
INSERT INTO crm_audit_log VALUES("7651","2","11","2019-06-28 15:38:14","Entry Invoice [Invoice No: 22169] updated by GAREEB GAREEB on 28/06/2019 at 03:38 PM");
INSERT INTO crm_audit_log VALUES("7652","2","11","2019-06-28 15:48:50","Entry Invoice [Invoice No: 22170] updated by GAREEB GAREEB on 28/06/2019 at 03:48 PM");
INSERT INTO crm_audit_log VALUES("7653","3","15","2019-06-28 16:00:09","Exit Invoice [Invoice No: 120751] updated by Abdul Rasheed on 28/06/2019 at 04:00 PM");
INSERT INTO crm_audit_log VALUES("7654","2","11","2019-06-28 16:02:19","Entry Invoice [Invoice No: 22171] updated by GAREEB GAREEB on 28/06/2019 at 04:02 PM");
INSERT INTO crm_audit_log VALUES("7655","3","15","2019-06-28 16:10:54","Exit Invoice [Invoice No: 120752] updated by Abdul Rasheed on 28/06/2019 at 04:10 PM");
INSERT INTO crm_audit_log VALUES("7656","2","11","2019-06-28 16:32:16","Entry Invoice [Invoice No: 22172] updated by GAREEB GAREEB on 28/06/2019 at 04:32 PM");
INSERT INTO crm_audit_log VALUES("7657","2","11","2019-06-28 16:41:01","Entry Invoice [Invoice No: 22173] updated by GAREEB GAREEB on 28/06/2019 at 04:41 PM");
INSERT INTO crm_audit_log VALUES("7658","2","11","2019-06-28 16:59:08","Entry Invoice [Invoice No: 22174] updated by GAREEB GAREEB on 28/06/2019 at 04:59 PM");
INSERT INTO crm_audit_log VALUES("7659","3","4","2019-06-28 17:23:39","Exit Invoice [Invoice No: 120753] updated by Yasir  Rahman on 28/06/2019 at 05:23 PM");
INSERT INTO crm_audit_log VALUES("7660","3","4","2019-06-28 17:44:25","Exit Invoice [Invoice No: 120754] updated by Yasir  Rahman on 28/06/2019 at 05:44 PM");
INSERT INTO crm_audit_log VALUES("7661","3","4","2019-06-28 18:07:12","Exit Invoice [Invoice No: 120755] updated by Yasir  Rahman on 28/06/2019 at 06:07 PM");
INSERT INTO crm_audit_log VALUES("7662","3","4","2019-06-28 18:22:56","Exit Invoice [Invoice No: 120756] updated by Yasir  Rahman on 28/06/2019 at 06:22 PM");
INSERT INTO crm_audit_log VALUES("7663","3","4","2019-06-28 18:43:05","Exit Invoice [Invoice No: 120757] updated by Yasir  Rahman on 28/06/2019 at 06:43 PM");
INSERT INTO crm_audit_log VALUES("7664","2","11","2019-06-28 19:14:15","Entry Invoice [Invoice No: 22175] updated by GAREEB GAREEB on 28/06/2019 at 07:14 PM");
INSERT INTO crm_audit_log VALUES("7665","3","15","2019-06-28 19:49:35","Exit Invoice [Invoice No: 120758] updated by Abdul Rasheed on 28/06/2019 at 07:49 PM");
INSERT INTO crm_audit_log VALUES("7666","3","15","2019-06-28 20:02:10","Exit Invoice [Invoice No: 120759] updated by Abdul Rasheed on 28/06/2019 at 08:02 PM");
INSERT INTO crm_audit_log VALUES("7667","3","15","2019-06-28 20:53:12","Exit Invoice [Invoice No: 120760] updated by Abdul Rasheed on 28/06/2019 at 08:53 PM");
INSERT INTO crm_audit_log VALUES("7668","3","15","2019-06-28 21:01:14","Exit Invoice [Invoice No: 120761] updated by Abdul Rasheed on 28/06/2019 at 09:01 PM");
INSERT INTO crm_audit_log VALUES("7669","3","15","2019-06-28 21:09:13","Exit Invoice [Invoice No: 120762] updated by Abdul Rasheed on 28/06/2019 at 09:09 PM");
INSERT INTO crm_audit_log VALUES("7670","3","15","2019-06-28 21:11:42","Exit Invoice [Invoice No: 120763] updated by Abdul Rasheed on 28/06/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("7671","3","15","2019-06-28 21:26:42","Exit Invoice [Invoice No: 120764] updated by Abdul Rasheed on 28/06/2019 at 09:26 PM");
INSERT INTO crm_audit_log VALUES("7672","2","4","2019-06-28 21:42:03","Entry Invoice [Invoice No: 22176] updated by Yasir  Rahman on 28/06/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("7673","3","4","2019-06-28 22:13:04","Exit Invoice [Invoice No: 120765] updated by Yasir  Rahman on 28/06/2019 at 10:13 PM");
INSERT INTO crm_audit_log VALUES("7674","2","4","2019-06-28 22:37:24","Entry Invoice [Invoice No: 22177] updated by Yasir  Rahman on 28/06/2019 at 10:37 PM");
INSERT INTO crm_audit_log VALUES("7675","2","4","2019-06-28 22:38:49","Entry Invoice [Invoice No: 22178] updated by Yasir  Rahman on 28/06/2019 at 10:38 PM");
INSERT INTO crm_audit_log VALUES("7676","3","4","2019-06-28 23:10:10","Exit Invoice [Invoice No: 120766] updated by Yasir  Rahman on 28/06/2019 at 11:10 PM");
INSERT INTO crm_audit_log VALUES("7677","3","4","2019-06-28 23:43:12","Exit Invoice [Invoice No: 120767] updated by Yasir  Rahman on 28/06/2019 at 11:43 PM");
INSERT INTO crm_audit_log VALUES("7678","2","4","2019-06-29 01:48:52","Entry Invoice [Invoice No: 22179] updated by Yasir  Rahman on 29/06/2019 at 01:48 AM");
INSERT INTO crm_audit_log VALUES("7679","2","4","2019-06-29 02:14:41","Entry Invoice [Invoice No: 22180] updated by Yasir  Rahman on 29/06/2019 at 02:14 AM");
INSERT INTO crm_audit_log VALUES("7680","2","4","2019-06-29 02:19:38","Entry Invoice [Invoice No: 22181] updated by Yasir  Rahman on 29/06/2019 at 02:19 AM");
INSERT INTO crm_audit_log VALUES("7681","2","4","2019-06-29 02:45:04","Entry Invoice [Invoice No: 22182] updated by Yasir  Rahman on 29/06/2019 at 02:45 AM");
INSERT INTO crm_audit_log VALUES("7682","3","5","2019-06-29 04:12:18","Exit Invoice [Invoice No: 120768] updated by Imran  Khan on 29/06/2019 at 04:12 AM");
INSERT INTO crm_audit_log VALUES("7683","3","5","2019-06-29 04:15:28","Exit Invoice [Invoice No: 120769] updated by Imran  Khan on 29/06/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("7684","3","15","2019-06-29 08:59:44","Exit Invoice [Invoice No: 120770] updated by Abdul Rasheed on 29/06/2019 at 08:59 AM");
INSERT INTO crm_audit_log VALUES("7685","3","15","2019-06-29 09:17:37","Exit Invoice [Invoice No: 120771] updated by Abdul Rasheed on 29/06/2019 at 09:17 AM");
INSERT INTO crm_audit_log VALUES("7686","3","15","2019-06-29 09:18:57","Exit Invoice [Invoice No: 120772] updated by Abdul Rasheed on 29/06/2019 at 09:18 AM");
INSERT INTO crm_audit_log VALUES("7687","3","15","2019-06-29 09:27:04","Exit Invoice [Invoice No: 120773] updated by Abdul Rasheed on 29/06/2019 at 09:27 AM");
INSERT INTO crm_audit_log VALUES("7688","3","15","2019-06-29 09:29:04","Exit Invoice [Invoice No: 120774] updated by Abdul Rasheed on 29/06/2019 at 09:29 AM");
INSERT INTO crm_audit_log VALUES("7689","3","15","2019-06-29 10:20:02","Exit Invoice [Invoice No: 120775] updated by Abdul Rasheed on 29/06/2019 at 10:20 AM");
INSERT INTO crm_audit_log VALUES("7690","3","6","2019-06-29 10:26:30","Exit Invoice [Invoice No: 120775] updated by ASHRAF  M K on 29/06/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("7691","2","6","2019-06-29 10:32:32","Entry Invoice [Invoice No: 22183] updated by ASHRAF  M K on 29/06/2019 at 10:32 AM");
INSERT INTO crm_audit_log VALUES("7692","2","6","2019-06-29 10:53:30","Entry Invoice [Invoice No: 22184] updated by ASHRAF  M K on 29/06/2019 at 10:53 AM");
INSERT INTO crm_audit_log VALUES("7693","2","6","2019-06-29 10:55:19","Entry Invoice [Invoice No: 22185] updated by ASHRAF  M K on 29/06/2019 at 10:55 AM");
INSERT INTO crm_audit_log VALUES("7694","2","11","2019-06-29 13:01:50","Entry Invoice [Invoice No: 22186] updated by GAREEB GAREEB on 29/06/2019 at 01:01 PM");
INSERT INTO crm_audit_log VALUES("7695","1","6","2019-06-29 13:06:45","Customer [Customer No: 455] updated by ASHRAF  M K on 29/06/2019 at 01:06 PM");
INSERT INTO crm_audit_log VALUES("7696","3","6","2019-06-29 13:08:19","Exit Invoice [Invoice No: 120767] updated by ASHRAF  M K on 29/06/2019 at 01:08 PM");
INSERT INTO crm_audit_log VALUES("7697","2","6","2019-06-29 13:28:35","Entry Invoice [Invoice No: 22184] updated by ASHRAF  M K on 29/06/2019 at 01:28 PM");
INSERT INTO crm_audit_log VALUES("7698","2","6","2019-06-29 13:28:53","Entry Invoice [Invoice No: 22185] updated by ASHRAF  M K on 29/06/2019 at 01:28 PM");
INSERT INTO crm_audit_log VALUES("7699","2","11","2019-06-29 15:12:24","Entry Invoice [Invoice No: 22187] updated by GAREEB GAREEB on 29/06/2019 at 03:12 PM");
INSERT INTO crm_audit_log VALUES("7700","2","11","2019-06-29 18:25:10","Entry Invoice [Invoice No: 22188] updated by GAREEB GAREEB on 29/06/2019 at 06:25 PM");
INSERT INTO crm_audit_log VALUES("7701","2","11","2019-06-29 18:26:23","Entry Invoice [Invoice No: 22189] updated by GAREEB GAREEB on 29/06/2019 at 06:26 PM");
INSERT INTO crm_audit_log VALUES("7702","2","4","2019-06-29 20:40:59","Entry Invoice [Invoice No: 22190] updated by Yasir  Rahman on 29/06/2019 at 08:40 PM");
INSERT INTO crm_audit_log VALUES("7703","2","4","2019-06-29 20:44:28","Entry Invoice [Invoice No: 22191] updated by Yasir  Rahman on 29/06/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("7704","2","4","2019-06-29 20:52:46","Entry Invoice [Invoice No: 22192] updated by Yasir  Rahman on 29/06/2019 at 08:52 PM");
INSERT INTO crm_audit_log VALUES("7705","2","4","2019-06-29 21:05:41","Entry Invoice [Invoice No: 22193] updated by Yasir  Rahman on 29/06/2019 at 09:05 PM");
INSERT INTO crm_audit_log VALUES("7706","3","4","2019-06-29 21:54:39","Exit Invoice [Invoice No: 120776] updated by Yasir  Rahman on 29/06/2019 at 09:54 PM");
INSERT INTO crm_audit_log VALUES("7707","3","5","2019-06-30 00:38:51","Exit Invoice [Invoice No: 120777] updated by Imran  Khan on 30/06/2019 at 12:38 AM");
INSERT INTO crm_audit_log VALUES("7708","3","5","2019-06-30 00:58:11","Exit Invoice [Invoice No: 120778] updated by Imran  Khan on 30/06/2019 at 12:58 AM");
INSERT INTO crm_audit_log VALUES("7709","2","4","2019-06-30 02:03:20","Entry Invoice [Invoice No: 22194] updated by Yasir  Rahman on 30/06/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("7710","2","4","2019-06-30 02:05:06","Entry Invoice [Invoice No: 22195] updated by Yasir  Rahman on 30/06/2019 at 02:05 AM");
INSERT INTO crm_audit_log VALUES("7711","2","4","2019-06-30 02:09:34","Entry Invoice [Invoice No: 22196] updated by Yasir  Rahman on 30/06/2019 at 02:09 AM");
INSERT INTO crm_audit_log VALUES("7712","2","4","2019-06-30 02:11:29","Entry Invoice [Invoice No: 22197] updated by Yasir  Rahman on 30/06/2019 at 02:11 AM");
INSERT INTO crm_audit_log VALUES("7713","2","4","2019-06-30 04:01:23","Entry Invoice [Invoice No: 22198] updated by Yasir  Rahman on 30/06/2019 at 04:01 AM");
INSERT INTO crm_audit_log VALUES("7714","3","5","2019-06-30 04:11:36","Exit Invoice [Invoice No: 120779] updated by Imran  Khan on 30/06/2019 at 04:11 AM");
INSERT INTO crm_audit_log VALUES("7715","3","5","2019-06-30 04:15:13","Exit Invoice [Invoice No: 120780] updated by Imran  Khan on 30/06/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("7716","2","4","2019-06-30 04:37:50","Entry Invoice [Invoice No: 22199] updated by Yasir  Rahman on 30/06/2019 at 04:37 AM");
INSERT INTO crm_audit_log VALUES("7717","3","5","2019-06-30 05:04:26","Exit Invoice [Invoice No: 120781] updated by Imran  Khan on 30/06/2019 at 05:04 AM");
INSERT INTO crm_audit_log VALUES("7718","3","5","2019-06-30 06:44:16","Exit Invoice [Invoice No: 120782] updated by Imran  Khan on 30/06/2019 at 06:44 AM");
INSERT INTO crm_audit_log VALUES("7719","2","6","2019-06-30 08:26:02","Entry Invoice [Invoice No: 22192] updated by ASHRAF  M K on 30/06/2019 at 08:26 AM");
INSERT INTO crm_audit_log VALUES("7720","3","15","2019-06-30 08:58:11","Exit Invoice [Invoice No: 120783] updated by Abdul Rasheed on 30/06/2019 at 08:58 AM");
INSERT INTO crm_audit_log VALUES("7721","3","15","2019-06-30 09:04:26","Exit Invoice [Invoice No: 120784] updated by Abdul Rasheed on 30/06/2019 at 09:04 AM");
INSERT INTO crm_audit_log VALUES("7722","3","15","2019-06-30 09:55:51","Exit Invoice [Invoice No: 120785] updated by Abdul Rasheed on 30/06/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("7723","3","15","2019-06-30 10:04:48","Exit Invoice [Invoice No: 120786] updated by Abdul Rasheed on 30/06/2019 at 10:04 AM");
INSERT INTO crm_audit_log VALUES("7724","3","15","2019-06-30 11:29:28","Exit Invoice [Invoice No: 120787] updated by Abdul Rasheed on 30/06/2019 at 11:29 AM");
INSERT INTO crm_audit_log VALUES("7725","2","6","2019-06-30 11:38:46","Entry Invoice [Invoice No: 22200] updated by ASHRAF  M K on 30/06/2019 at 11:38 AM");
INSERT INTO crm_audit_log VALUES("7726","3","15","2019-06-30 11:42:05","Exit Invoice [Invoice No: 120788] updated by Abdul Rasheed on 30/06/2019 at 11:42 AM");
INSERT INTO crm_audit_log VALUES("7727","3","15","2019-06-30 12:35:01","Exit Invoice [Invoice No: 120789] updated by Abdul Rasheed on 30/06/2019 at 12:35 PM");
INSERT INTO crm_audit_log VALUES("7728","3","15","2019-06-30 12:40:19","Exit Invoice [Invoice No: 120790] updated by Abdul Rasheed on 30/06/2019 at 12:40 PM");
INSERT INTO crm_audit_log VALUES("7729","3","15","2019-06-30 13:29:19","Exit Invoice [Invoice No: 120791] updated by Abdul Rasheed on 30/06/2019 at 01:29 PM");
INSERT INTO crm_audit_log VALUES("7730","2","11","2019-06-30 13:51:23","Entry Invoice [Invoice No: 22201] updated by GAREEB GAREEB on 30/06/2019 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("7731","3","15","2019-06-30 14:00:06","Exit Invoice [Invoice No: 120792] updated by Abdul Rasheed on 30/06/2019 at 02:00 PM");
INSERT INTO crm_audit_log VALUES("7732","3","15","2019-06-30 14:10:42","Exit Invoice [Invoice No: 120793] updated by Abdul Rasheed on 30/06/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("7733","2","11","2019-06-30 16:27:39","Entry Invoice [Invoice No: 22202] updated by GAREEB GAREEB on 30/06/2019 at 04:27 PM");
INSERT INTO crm_audit_log VALUES("7734","3","4","2019-06-30 19:09:06","Exit Invoice [Invoice No: 120794] updated by Yasir  Rahman on 30/06/2019 at 07:09 PM");
INSERT INTO crm_audit_log VALUES("7735","3","4","2019-06-30 21:39:20","Exit Invoice [Invoice No: 120795] updated by Yasir  Rahman on 30/06/2019 at 09:39 PM");
INSERT INTO crm_audit_log VALUES("7736","3","4","2019-06-30 21:41:44","Exit Invoice [Invoice No: 120796] updated by Yasir  Rahman on 30/06/2019 at 09:41 PM");
INSERT INTO crm_audit_log VALUES("7737","3","4","2019-06-30 22:12:32","Exit Invoice [Invoice No: 120797] updated by Yasir  Rahman on 30/06/2019 at 10:12 PM");
INSERT INTO crm_audit_log VALUES("7738","3","4","2019-06-30 23:11:19","Exit Invoice [Invoice No: 120798] updated by Yasir  Rahman on 30/06/2019 at 11:11 PM");
INSERT INTO crm_audit_log VALUES("7739","2","4","2019-06-30 23:12:47","Entry Invoice [Invoice No: 22203] updated by Yasir  Rahman on 30/06/2019 at 11:12 PM");
INSERT INTO crm_audit_log VALUES("7740","2","4","2019-06-30 23:14:06","Entry Invoice [Invoice No: 22204] updated by Yasir  Rahman on 30/06/2019 at 11:14 PM");
INSERT INTO crm_audit_log VALUES("7741","3","4","2019-06-30 23:37:00","Exit Invoice [Invoice No: 120799] updated by Yasir  Rahman on 30/06/2019 at 11:37 PM");
INSERT INTO crm_audit_log VALUES("7742","3","4","2019-07-01 00:15:14","Exit Invoice [Invoice No: 120800] updated by Yasir  Rahman on 01/07/2019 at 12:15 AM");
INSERT INTO crm_audit_log VALUES("7743","3","4","2019-07-01 00:54:05","Exit Invoice [Invoice No: 120801] updated by Yasir  Rahman on 01/07/2019 at 12:54 AM");
INSERT INTO crm_audit_log VALUES("7744","3","5","2019-07-01 02:09:34","Exit Invoice [Invoice No: 120802] updated by Imran  Khan on 01/07/2019 at 02:09 AM");
INSERT INTO crm_audit_log VALUES("7745","3","5","2019-07-01 02:10:33","Exit Invoice [Invoice No: 120803] updated by Imran  Khan on 01/07/2019 at 02:10 AM");
INSERT INTO crm_audit_log VALUES("7746","2","4","2019-07-01 02:38:44","Entry Invoice [Invoice No: 22205] updated by Yasir  Rahman on 01/07/2019 at 02:38 AM");
INSERT INTO crm_audit_log VALUES("7747","3","5","2019-07-01 05:11:42","Exit Invoice [Invoice No: 120804] updated by Imran  Khan on 01/07/2019 at 05:11 AM");
INSERT INTO crm_audit_log VALUES("7748","2","4","2019-07-01 06:42:42","Entry Invoice [Invoice No: 22206] updated by Yasir  Rahman on 01/07/2019 at 06:42 AM");
INSERT INTO crm_audit_log VALUES("7749","2","4","2019-07-01 06:44:14","Entry Invoice [Invoice No: 22207] updated by Yasir  Rahman on 01/07/2019 at 06:44 AM");
INSERT INTO crm_audit_log VALUES("7750","3","5","2019-07-01 06:45:12","Exit Invoice [Invoice No: 120805] updated by Imran  Khan on 01/07/2019 at 06:45 AM");
INSERT INTO crm_audit_log VALUES("7751","2","4","2019-07-01 06:46:37","Entry Invoice [Invoice No: 22208] updated by Yasir  Rahman on 01/07/2019 at 06:46 AM");
INSERT INTO crm_audit_log VALUES("7752","2","4","2019-07-01 06:48:41","Entry Invoice [Invoice No: 22209] updated by Yasir  Rahman on 01/07/2019 at 06:48 AM");
INSERT INTO crm_audit_log VALUES("7753","2","4","2019-07-01 06:50:41","Entry Invoice [Invoice No: 22210] updated by Yasir  Rahman on 01/07/2019 at 06:50 AM");
INSERT INTO crm_audit_log VALUES("7754","3","5","2019-07-01 07:26:37","Exit Invoice [Invoice No: 120806] updated by Imran  Khan on 01/07/2019 at 07:26 AM");
INSERT INTO crm_audit_log VALUES("7755","3","5","2019-07-01 07:28:12","Exit Invoice [Invoice No: 120807] updated by Imran  Khan on 01/07/2019 at 07:28 AM");
INSERT INTO crm_audit_log VALUES("7756","3","5","2019-07-01 07:29:07","Exit Invoice [Invoice No: 120808] updated by Imran  Khan on 01/07/2019 at 07:29 AM");
INSERT INTO crm_audit_log VALUES("7757","3","15","2019-07-01 08:56:07","Exit Invoice [Invoice No: 120809] updated by Abdul Rasheed on 01/07/2019 at 08:56 AM");
INSERT INTO crm_audit_log VALUES("7758","3","15","2019-07-01 09:21:12","Exit Invoice [Invoice No: 120810] updated by Abdul Rasheed on 01/07/2019 at 09:21 AM");
INSERT INTO crm_audit_log VALUES("7759","3","15","2019-07-01 09:48:54","Exit Invoice [Invoice No: 120811] updated by Abdul Rasheed on 01/07/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("7760","2","6","2019-07-01 10:25:08","Entry Invoice [Invoice No: 22211] updated by ASHRAF  M K on 01/07/2019 at 10:25 AM");
INSERT INTO crm_audit_log VALUES("7761","2","6","2019-07-01 10:42:38","Entry Invoice [Invoice No: 22212] updated by ASHRAF  M K on 01/07/2019 at 10:42 AM");
INSERT INTO crm_audit_log VALUES("7762","2","6","2019-07-01 10:47:45","Entry Invoice [Invoice No: 22213] updated by ASHRAF  M K on 01/07/2019 at 10:47 AM");
INSERT INTO crm_audit_log VALUES("7763","3","15","2019-07-01 10:59:17","Exit Invoice [Invoice No: 120812] updated by Abdul Rasheed on 01/07/2019 at 10:59 AM");
INSERT INTO crm_audit_log VALUES("7764","3","15","2019-07-01 11:34:03","Exit Invoice [Invoice No: 120813] updated by Abdul Rasheed on 01/07/2019 at 11:34 AM");
INSERT INTO crm_audit_log VALUES("7765","3","15","2019-07-01 11:58:11","Exit Invoice [Invoice No: 120814] updated by Abdul Rasheed on 01/07/2019 at 11:58 AM");
INSERT INTO crm_audit_log VALUES("7766","1","6","2019-07-01 12:34:23","Customer [Customer No: 385] updated by ASHRAF  M K on 01/07/2019 at 12:34 PM");
INSERT INTO crm_audit_log VALUES("7767","3","15","2019-07-01 12:42:43","Exit Invoice [Invoice No: 120815] updated by Abdul Rasheed on 01/07/2019 at 12:42 PM");
INSERT INTO crm_audit_log VALUES("7768","3","15","2019-07-01 12:49:18","Exit Invoice [Invoice No: 120816] updated by Abdul Rasheed on 01/07/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("7769","3","15","2019-07-01 12:52:22","Exit Invoice [Invoice No: 120817] updated by Abdul Rasheed on 01/07/2019 at 12:52 PM");
INSERT INTO crm_audit_log VALUES("7770","3","15","2019-07-01 13:35:32","Exit Invoice [Invoice No: 120818] updated by Abdul Rasheed on 01/07/2019 at 01:35 PM");
INSERT INTO crm_audit_log VALUES("7771","2","6","2019-07-01 14:22:38","Entry Invoice [Invoice No: 22214] updated by ASHRAF  M K on 01/07/2019 at 02:22 PM");
INSERT INTO crm_audit_log VALUES("7772","3","15","2019-07-01 14:31:33","Exit Invoice [Invoice No: 120819] updated by Abdul Rasheed on 01/07/2019 at 02:31 PM");
INSERT INTO crm_audit_log VALUES("7773","3","15","2019-07-01 14:57:32","Exit Invoice [Invoice No: 120820] updated by Abdul Rasheed on 01/07/2019 at 02:57 PM");
INSERT INTO crm_audit_log VALUES("7774","3","15","2019-07-01 15:07:00","Exit Invoice [Invoice No: 120821] updated by Abdul Rasheed on 01/07/2019 at 03:07 PM");
INSERT INTO crm_audit_log VALUES("7775","3","15","2019-07-01 15:11:58","Exit Invoice [Invoice No: 120822] updated by Abdul Rasheed on 01/07/2019 at 03:11 PM");
INSERT INTO crm_audit_log VALUES("7776","3","6","2019-07-01 15:30:33","Exit Invoice [Invoice No: 120816] updated by ASHRAF  M K on 01/07/2019 at 03:30 PM");
INSERT INTO crm_audit_log VALUES("7777","3","4","2019-07-01 16:57:46","Exit Invoice [Invoice No: 120823] updated by Yasir  Rahman on 01/07/2019 at 04:57 PM");
INSERT INTO crm_audit_log VALUES("7778","2","11","2019-07-01 17:05:37","Entry Invoice [Invoice No: 22215] updated by GAREEB GAREEB on 01/07/2019 at 05:05 PM");
INSERT INTO crm_audit_log VALUES("7779","3","4","2019-07-01 18:36:16","Exit Invoice [Invoice No: 120824] updated by Yasir  Rahman on 01/07/2019 at 06:36 PM");
INSERT INTO crm_audit_log VALUES("7780","2","4","2019-07-01 20:26:05","Entry Invoice [Invoice No: 22216] updated by Yasir  Rahman on 01/07/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("7781","3","4","2019-07-01 20:35:00","Exit Invoice [Invoice No: 120825] updated by Yasir  Rahman on 01/07/2019 at 08:35 PM");
INSERT INTO crm_audit_log VALUES("7782","3","4","2019-07-01 21:11:15","Exit Invoice [Invoice No: 120826] updated by Yasir  Rahman on 01/07/2019 at 09:11 PM");
INSERT INTO crm_audit_log VALUES("7783","3","4","2019-07-01 22:49:31","Exit Invoice [Invoice No: 120827] updated by Yasir  Rahman on 01/07/2019 at 10:49 PM");
INSERT INTO crm_audit_log VALUES("7784","3","5","2019-07-02 01:32:46","Exit Invoice [Invoice No: 120828] updated by Imran  Khan on 02/07/2019 at 01:32 AM");
INSERT INTO crm_audit_log VALUES("7785","3","5","2019-07-02 02:39:17","Exit Invoice [Invoice No: 120829] updated by Imran  Khan on 02/07/2019 at 02:39 AM");
INSERT INTO crm_audit_log VALUES("7786","3","5","2019-07-02 03:50:36","Exit Invoice [Invoice No: 120830] updated by Imran  Khan on 02/07/2019 at 03:50 AM");
INSERT INTO crm_audit_log VALUES("7787","3","5","2019-07-02 06:30:05","Exit Invoice [Invoice No: 120831] updated by Imran  Khan on 02/07/2019 at 06:30 AM");
INSERT INTO crm_audit_log VALUES("7788","2","4","2019-07-02 07:35:57","Entry Invoice [Invoice No: 22217] updated by Yasir  Rahman on 02/07/2019 at 07:35 AM");
INSERT INTO crm_audit_log VALUES("7789","2","4","2019-07-02 07:36:56","Entry Invoice [Invoice No: 22218] updated by Yasir  Rahman on 02/07/2019 at 07:36 AM");
INSERT INTO crm_audit_log VALUES("7790","3","15","2019-07-02 08:47:06","Exit Invoice [Invoice No: 120832] updated by Abdul Rasheed on 02/07/2019 at 08:47 AM");
INSERT INTO crm_audit_log VALUES("7791","3","6","2019-07-02 09:53:38","Exit Invoice [Invoice No: 120829] updated by ASHRAF  M K on 02/07/2019 at 09:53 AM");
INSERT INTO crm_audit_log VALUES("7792","3","15","2019-07-02 12:17:04","Exit Invoice [Invoice No: 120833] updated by Abdul Rasheed on 02/07/2019 at 12:17 PM");
INSERT INTO crm_audit_log VALUES("7793","3","15","2019-07-02 12:29:44","Exit Invoice [Invoice No: 120834] updated by Abdul Rasheed on 02/07/2019 at 12:29 PM");
INSERT INTO crm_audit_log VALUES("7794","3","15","2019-07-02 12:49:03","Exit Invoice [Invoice No: 120835] updated by Abdul Rasheed on 02/07/2019 at 12:49 PM");
INSERT INTO crm_audit_log VALUES("7795","3","15","2019-07-02 13:23:27","Exit Invoice [Invoice No: 120836] updated by Abdul Rasheed on 02/07/2019 at 01:23 PM");
INSERT INTO crm_audit_log VALUES("7796","3","15","2019-07-02 13:36:27","Exit Invoice [Invoice No: 120837] updated by Abdul Rasheed on 02/07/2019 at 01:36 PM");
INSERT INTO crm_audit_log VALUES("7797","1","6","2019-07-02 15:07:31","Customer [Customer No: 114] updated by ASHRAF  M K on 02/07/2019 at 03:07 PM");
INSERT INTO crm_audit_log VALUES("7798","3","15","2019-07-02 15:18:19","Exit Invoice [Invoice No: 120838] updated by Abdul Rasheed on 02/07/2019 at 03:18 PM");
INSERT INTO crm_audit_log VALUES("7799","3","15","2019-07-02 15:49:49","Exit Invoice [Invoice No: 120839] updated by Abdul Rasheed on 02/07/2019 at 03:49 PM");
INSERT INTO crm_audit_log VALUES("7800","3","15","2019-07-02 15:52:35","Exit Invoice [Invoice No: 120840] updated by Abdul Rasheed on 02/07/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("7801","2","11","2019-07-02 16:30:32","Entry Invoice [Invoice No: 22219] updated by GAREEB GAREEB on 02/07/2019 at 04:30 PM");
INSERT INTO crm_audit_log VALUES("7802","3","4","2019-07-02 16:57:23","Exit Invoice [Invoice No: 120841] updated by Yasir  Rahman on 02/07/2019 at 04:57 PM");
INSERT INTO crm_audit_log VALUES("7803","3","4","2019-07-02 17:04:52","Exit Invoice [Invoice No: 120842] updated by Yasir  Rahman on 02/07/2019 at 05:04 PM");
INSERT INTO crm_audit_log VALUES("7804","3","4","2019-07-02 17:19:43","Exit Invoice [Invoice No: 120843] updated by Yasir  Rahman on 02/07/2019 at 05:19 PM");
INSERT INTO crm_audit_log VALUES("7805","3","4","2019-07-02 17:49:24","Exit Invoice [Invoice No: 120844] updated by Yasir  Rahman on 02/07/2019 at 05:49 PM");
INSERT INTO crm_audit_log VALUES("7806","2","11","2019-07-02 18:55:34","Entry Invoice [Invoice No: 22220] updated by GAREEB GAREEB on 02/07/2019 at 06:55 PM");
INSERT INTO crm_audit_log VALUES("7807","3","4","2019-07-02 19:01:43","Exit Invoice [Invoice No: 120845] updated by Yasir  Rahman on 02/07/2019 at 07:01 PM");
INSERT INTO crm_audit_log VALUES("7808","2","4","2019-07-02 20:43:42","Entry Invoice [Invoice No: 22221] updated by Yasir  Rahman on 02/07/2019 at 08:43 PM");
INSERT INTO crm_audit_log VALUES("7809","2","4","2019-07-02 20:46:14","Entry Invoice [Invoice No: 22222] updated by Yasir  Rahman on 02/07/2019 at 08:46 PM");
INSERT INTO crm_audit_log VALUES("7810","2","4","2019-07-02 22:58:45","Entry Invoice [Invoice No: 22223] updated by Yasir  Rahman on 02/07/2019 at 10:58 PM");
INSERT INTO crm_audit_log VALUES("7811","3","5","2019-07-03 01:48:36","Exit Invoice [Invoice No: 120846] updated by Imran  Khan on 03/07/2019 at 01:48 AM");
INSERT INTO crm_audit_log VALUES("7812","3","5","2019-07-03 02:15:32","Exit Invoice [Invoice No: 120847] updated by Imran  Khan on 03/07/2019 at 02:15 AM");
INSERT INTO crm_audit_log VALUES("7813","2","4","2019-07-03 06:13:21","Entry Invoice [Invoice No: 22224] updated by Yasir  Rahman on 03/07/2019 at 06:13 AM");
INSERT INTO crm_audit_log VALUES("7814","2","4","2019-07-03 06:15:00","Entry Invoice [Invoice No: 22225] updated by Yasir  Rahman on 03/07/2019 at 06:15 AM");
INSERT INTO crm_audit_log VALUES("7815","2","4","2019-07-03 06:17:38","Entry Invoice [Invoice No: 22226] updated by Yasir  Rahman on 03/07/2019 at 06:17 AM");
INSERT INTO crm_audit_log VALUES("7816","2","4","2019-07-03 06:20:55","Entry Invoice [Invoice No: 22227] updated by Yasir  Rahman on 03/07/2019 at 06:20 AM");
INSERT INTO crm_audit_log VALUES("7817","2","4","2019-07-03 06:21:50","Entry Invoice [Invoice No: 22228] updated by Yasir  Rahman on 03/07/2019 at 06:21 AM");
INSERT INTO crm_audit_log VALUES("7818","2","4","2019-07-03 06:22:45","Entry Invoice [Invoice No: 22229] updated by Yasir  Rahman on 03/07/2019 at 06:22 AM");
INSERT INTO crm_audit_log VALUES("7819","3","13","2019-07-03 08:49:31","Exit Invoice [Invoice No: 120848] updated by MUHAMMED HASHIM on 03/07/2019 at 08:49 AM");
INSERT INTO crm_audit_log VALUES("7820","3","13","2019-07-03 09:19:03","Exit Invoice [Invoice No: 120849] updated by MUHAMMED HASHIM on 03/07/2019 at 09:19 AM");
INSERT INTO crm_audit_log VALUES("7821","2","11","2019-07-03 09:35:35","Entry Invoice [Invoice No: 22230] updated by GAREEB GAREEB on 03/07/2019 at 09:35 AM");
INSERT INTO crm_audit_log VALUES("7822","2","11","2019-07-03 10:20:27","Entry Invoice [Invoice No: 22231] updated by GAREEB GAREEB on 03/07/2019 at 10:20 AM");
INSERT INTO crm_audit_log VALUES("7823","3","13","2019-07-03 11:18:00","Exit Invoice [Invoice No: 120850] updated by MUHAMMED HASHIM on 03/07/2019 at 11:18 AM");
INSERT INTO crm_audit_log VALUES("7824","3","13","2019-07-03 11:19:07","Exit Invoice [Invoice No: 120851] updated by MUHAMMED HASHIM on 03/07/2019 at 11:19 AM");
INSERT INTO crm_audit_log VALUES("7825","3","13","2019-07-03 11:45:35","Exit Invoice [Invoice No: 120852] updated by MUHAMMED HASHIM on 03/07/2019 at 11:45 AM");
INSERT INTO crm_audit_log VALUES("7826","3","13","2019-07-03 11:48:23","Exit Invoice [Invoice No: 120853] updated by MUHAMMED HASHIM on 03/07/2019 at 11:48 AM");
INSERT INTO crm_audit_log VALUES("7827","3","13","2019-07-03 12:53:22","Exit Invoice [Invoice No: 120854] updated by MUHAMMED HASHIM on 03/07/2019 at 12:53 PM");
INSERT INTO crm_audit_log VALUES("7828","3","13","2019-07-03 14:05:04","Exit Invoice [Invoice No: 120855] updated by MUHAMMED HASHIM on 03/07/2019 at 02:05 PM");
INSERT INTO crm_audit_log VALUES("7829","2","11","2019-07-03 14:08:36","Entry Invoice [Invoice No: 22232] updated by GAREEB GAREEB on 03/07/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("7830","3","13","2019-07-03 14:09:24","Exit Invoice [Invoice No: 120856] updated by MUHAMMED HASHIM on 03/07/2019 at 02:09 PM");
INSERT INTO crm_audit_log VALUES("7831","3","13","2019-07-03 14:10:55","Exit Invoice [Invoice No: 120857] updated by MUHAMMED HASHIM on 03/07/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("7832","3","13","2019-07-03 15:30:43","Exit Invoice [Invoice No: 120858] updated by MUHAMMED HASHIM on 03/07/2019 at 03:30 PM");
INSERT INTO crm_audit_log VALUES("7833","3","13","2019-07-03 15:31:59","Exit Invoice [Invoice No: 120859] updated by MUHAMMED HASHIM on 03/07/2019 at 03:31 PM");
INSERT INTO crm_audit_log VALUES("7834","2","11","2019-07-03 16:56:31","Entry Invoice [Invoice No: 22233] updated by GAREEB GAREEB on 03/07/2019 at 04:56 PM");
INSERT INTO crm_audit_log VALUES("7835","2","11","2019-07-03 17:05:27","Entry Invoice [Invoice No: 22234] updated by GAREEB GAREEB on 03/07/2019 at 05:05 PM");
INSERT INTO crm_audit_log VALUES("7836","3","4","2019-07-03 17:44:37","Exit Invoice [Invoice No: 120860] updated by Yasir  Rahman on 03/07/2019 at 05:44 PM");
INSERT INTO crm_audit_log VALUES("7837","3","4","2019-07-03 17:46:07","Exit Invoice [Invoice No: 120861] updated by Yasir  Rahman on 03/07/2019 at 05:46 PM");
INSERT INTO crm_audit_log VALUES("7838","3","4","2019-07-03 18:06:47","Exit Invoice [Invoice No: 120862] updated by Yasir  Rahman on 03/07/2019 at 06:06 PM");
INSERT INTO crm_audit_log VALUES("7839","3","4","2019-07-03 18:24:01","Exit Invoice [Invoice No: 120863] updated by Yasir  Rahman on 03/07/2019 at 06:24 PM");
INSERT INTO crm_audit_log VALUES("7840","2","11","2019-07-03 19:53:50","Entry Invoice [Invoice No: 22235] updated by GAREEB GAREEB on 03/07/2019 at 07:53 PM");
INSERT INTO crm_audit_log VALUES("7841","2","11","2019-07-03 19:56:11","Entry Invoice [Invoice No: 22236] updated by GAREEB GAREEB on 03/07/2019 at 07:56 PM");
INSERT INTO crm_audit_log VALUES("7842","2","11","2019-07-03 19:58:54","Entry Invoice [Invoice No: 22237] updated by GAREEB GAREEB on 03/07/2019 at 07:58 PM");
INSERT INTO crm_audit_log VALUES("7843","3","4","2019-07-03 20:03:57","Exit Invoice [Invoice No: 120864] updated by Yasir  Rahman on 03/07/2019 at 08:03 PM");
INSERT INTO crm_audit_log VALUES("7844","3","4","2019-07-03 20:05:43","Exit Invoice [Invoice No: 120865] updated by Yasir  Rahman on 03/07/2019 at 08:05 PM");
INSERT INTO crm_audit_log VALUES("7845","3","4","2019-07-03 21:09:51","Exit Invoice [Invoice No: 120866] updated by Yasir  Rahman on 03/07/2019 at 09:09 PM");
INSERT INTO crm_audit_log VALUES("7846","3","4","2019-07-04 00:26:50","Exit Invoice [Invoice No: 120867] updated by Yasir  Rahman on 04/07/2019 at 12:26 AM");
INSERT INTO crm_audit_log VALUES("7847","3","5","2019-07-04 01:56:01","Exit Invoice [Invoice No: 120868] updated by Imran  Khan on 04/07/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("7848","3","5","2019-07-04 02:23:36","Exit Invoice [Invoice No: 120869] updated by Imran  Khan on 04/07/2019 at 02:23 AM");
INSERT INTO crm_audit_log VALUES("7849","3","5","2019-07-04 02:26:42","Exit Invoice [Invoice No: 120870] updated by Imran  Khan on 04/07/2019 at 02:26 AM");
INSERT INTO crm_audit_log VALUES("7850","3","5","2019-07-04 06:27:26","Exit Invoice [Invoice No: 120871] updated by Imran  Khan on 04/07/2019 at 06:27 AM");
INSERT INTO crm_audit_log VALUES("7851","2","4","2019-07-04 07:26:38","Entry Invoice [Invoice No: 22238] updated by Yasir  Rahman on 04/07/2019 at 07:26 AM");
INSERT INTO crm_audit_log VALUES("7852","2","4","2019-07-04 07:27:40","Entry Invoice [Invoice No: 22239] updated by Yasir  Rahman on 04/07/2019 at 07:27 AM");
INSERT INTO crm_audit_log VALUES("7853","2","4","2019-07-04 07:28:51","Entry Invoice [Invoice No: 22240] updated by Yasir  Rahman on 04/07/2019 at 07:28 AM");
INSERT INTO crm_audit_log VALUES("7854","3","15","2019-07-04 08:29:57","Exit Invoice [Invoice No: 120872] updated by Abdul Rasheed on 04/07/2019 at 08:29 AM");
INSERT INTO crm_audit_log VALUES("7855","3","15","2019-07-04 09:01:04","Exit Invoice [Invoice No: 120873] updated by Abdul Rasheed on 04/07/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("7856","3","15","2019-07-04 09:31:06","Exit Invoice [Invoice No: 120874] updated by Abdul Rasheed on 04/07/2019 at 09:31 AM");
INSERT INTO crm_audit_log VALUES("7857","3","15","2019-07-04 10:39:28","Exit Invoice [Invoice No: 120875] updated by Abdul Rasheed on 04/07/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("7858","3","15","2019-07-04 10:43:38","Exit Invoice [Invoice No: 120876] updated by Abdul Rasheed on 04/07/2019 at 10:43 AM");
INSERT INTO crm_audit_log VALUES("7859","3","15","2019-07-04 11:05:31","Exit Invoice [Invoice No: 120877] updated by Abdul Rasheed on 04/07/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("7860","3","15","2019-07-04 11:06:32","Exit Invoice [Invoice No: 120878] updated by Abdul Rasheed on 04/07/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("7861","3","15","2019-07-04 11:16:09","Exit Invoice [Invoice No: 120879] updated by Abdul Rasheed on 04/07/2019 at 11:16 AM");
INSERT INTO crm_audit_log VALUES("7862","3","15","2019-07-04 11:27:49","Exit Invoice [Invoice No: 120880] updated by Abdul Rasheed on 04/07/2019 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("7863","3","15","2019-07-04 14:25:47","Exit Invoice [Invoice No: 120881] updated by Abdul Rasheed on 04/07/2019 at 02:25 PM");
INSERT INTO crm_audit_log VALUES("7864","2","6","2019-07-04 14:40:01","Entry Invoice [Invoice No: 22241] updated by ASHRAF  M K on 04/07/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("7865","1","15","2019-07-04 14:54:17","Customer [Customer No: 456] updated by Abdul Rasheed on 04/07/2019 at 02:54 PM");
INSERT INTO crm_audit_log VALUES("7866","3","15","2019-07-04 14:55:58","Exit Invoice [Invoice No: 120882] updated by Abdul Rasheed on 04/07/2019 at 02:55 PM");
INSERT INTO crm_audit_log VALUES("7867","3","4","2019-07-04 16:27:00","Exit Invoice [Invoice No: 120883] updated by Yasir  Rahman on 04/07/2019 at 04:27 PM");
INSERT INTO crm_audit_log VALUES("7868","3","4","2019-07-04 18:22:27","Exit Invoice [Invoice No: 120884] updated by Yasir  Rahman on 04/07/2019 at 06:22 PM");
INSERT INTO crm_audit_log VALUES("7869","3","4","2019-07-04 18:24:11","Exit Invoice [Invoice No: 120885] updated by Yasir  Rahman on 04/07/2019 at 06:24 PM");
INSERT INTO crm_audit_log VALUES("7870","3","4","2019-07-04 18:30:33","Exit Invoice [Invoice No: 120886] updated by Yasir  Rahman on 04/07/2019 at 06:30 PM");
INSERT INTO crm_audit_log VALUES("7871","3","4","2019-07-04 19:15:55","Exit Invoice [Invoice No: 120887] updated by Yasir  Rahman on 04/07/2019 at 07:15 PM");
INSERT INTO crm_audit_log VALUES("7872","3","4","2019-07-04 21:23:07","Exit Invoice [Invoice No: 120888] updated by Yasir  Rahman on 04/07/2019 at 09:23 PM");
INSERT INTO crm_audit_log VALUES("7873","3","4","2019-07-04 21:31:54","Exit Invoice [Invoice No: 120889] updated by Yasir  Rahman on 04/07/2019 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("7874","3","4","2019-07-04 21:42:38","Exit Invoice [Invoice No: 120890] updated by Yasir  Rahman on 04/07/2019 at 09:42 PM");
INSERT INTO crm_audit_log VALUES("7875","3","4","2019-07-04 22:25:13","Exit Invoice [Invoice No: 120891] updated by Yasir  Rahman on 04/07/2019 at 10:25 PM");
INSERT INTO crm_audit_log VALUES("7876","3","4","2019-07-04 22:51:44","Exit Invoice [Invoice No: 120892] updated by Yasir  Rahman on 04/07/2019 at 10:51 PM");
INSERT INTO crm_audit_log VALUES("7877","2","4","2019-07-05 01:09:58","Entry Invoice [Invoice No: 22242] updated by Yasir  Rahman on 05/07/2019 at 01:09 AM");
INSERT INTO crm_audit_log VALUES("7878","2","4","2019-07-05 01:35:56","Entry Invoice [Invoice No: 22243] updated by Yasir  Rahman on 05/07/2019 at 01:35 AM");
INSERT INTO crm_audit_log VALUES("7879","3","5","2019-07-05 03:07:55","Exit Invoice [Invoice No: 120893] updated by Imran  Khan on 05/07/2019 at 03:07 AM");
INSERT INTO crm_audit_log VALUES("7880","2","4","2019-07-05 05:15:24","Entry Invoice [Invoice No: 22244] updated by Yasir  Rahman on 05/07/2019 at 05:15 AM");
INSERT INTO crm_audit_log VALUES("7881","2","4","2019-07-05 05:17:49","Entry Invoice [Invoice No: 22245] updated by Yasir  Rahman on 05/07/2019 at 05:17 AM");
INSERT INTO crm_audit_log VALUES("7882","3","5","2019-07-05 05:41:45","Exit Invoice [Invoice No: 120894] updated by Imran  Khan on 05/07/2019 at 05:41 AM");
INSERT INTO crm_audit_log VALUES("7883","2","4","2019-07-05 05:44:12","Entry Invoice [Invoice No: 22246] updated by Yasir  Rahman on 05/07/2019 at 05:44 AM");
INSERT INTO crm_audit_log VALUES("7884","2","4","2019-07-05 05:46:22","Entry Invoice [Invoice No: 22247] updated by Yasir  Rahman on 05/07/2019 at 05:46 AM");
INSERT INTO crm_audit_log VALUES("7885","2","4","2019-07-05 05:48:27","Entry Invoice [Invoice No: 22248] updated by Yasir  Rahman on 05/07/2019 at 05:48 AM");
INSERT INTO crm_audit_log VALUES("7886","2","4","2019-07-05 05:50:12","Entry Invoice [Invoice No: 22249] updated by Yasir  Rahman on 05/07/2019 at 05:50 AM");
INSERT INTO crm_audit_log VALUES("7887","2","6","2019-07-05 07:57:17","Entry Invoice [Invoice No: 22248] updated by ASHRAF  M K on 05/07/2019 at 07:57 AM");
INSERT INTO crm_audit_log VALUES("7888","3","15","2019-07-05 09:10:46","Exit Invoice [Invoice No: 120895] updated by Abdul Rasheed on 05/07/2019 at 09:10 AM");
INSERT INTO crm_audit_log VALUES("7889","3","6","2019-07-05 09:11:34","Exit Invoice [Invoice No: 120895] updated by ASHRAF  M K on 05/07/2019 at 09:11 AM");
INSERT INTO crm_audit_log VALUES("7890","2","11","2019-07-05 09:22:19","Entry Invoice [Invoice No: 22250] updated by GAREEB GAREEB on 05/07/2019 at 09:22 AM");
INSERT INTO crm_audit_log VALUES("7891","2","11","2019-07-05 10:27:52","Entry Invoice [Invoice No: 22251] updated by GAREEB GAREEB on 05/07/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("7892","3","15","2019-07-05 10:51:31","Exit Invoice [Invoice No: 120896] updated by Abdul Rasheed on 05/07/2019 at 10:51 AM");
INSERT INTO crm_audit_log VALUES("7893","2","11","2019-07-05 11:17:14","Entry Invoice [Invoice No: 22252] updated by GAREEB GAREEB on 05/07/2019 at 11:17 AM");
INSERT INTO crm_audit_log VALUES("7894","3","15","2019-07-05 13:29:10","Exit Invoice [Invoice No: 120897] updated by Abdul Rasheed on 05/07/2019 at 01:29 PM");
INSERT INTO crm_audit_log VALUES("7895","3","15","2019-07-05 13:39:08","Exit Invoice [Invoice No: 120898] updated by Abdul Rasheed on 05/07/2019 at 01:39 PM");
INSERT INTO crm_audit_log VALUES("7896","3","15","2019-07-05 13:49:31","Exit Invoice [Invoice No: 120899] updated by Abdul Rasheed on 05/07/2019 at 01:49 PM");
INSERT INTO crm_audit_log VALUES("7897","3","15","2019-07-05 14:16:01","Exit Invoice [Invoice No: 120900] updated by Abdul Rasheed on 05/07/2019 at 02:16 PM");
INSERT INTO crm_audit_log VALUES("7898","3","15","2019-07-05 14:32:10","Exit Invoice [Invoice No: 120901] updated by Abdul Rasheed on 05/07/2019 at 02:32 PM");
INSERT INTO crm_audit_log VALUES("7899","3","15","2019-07-05 14:47:34","Exit Invoice [Invoice No: 120902] updated by Abdul Rasheed on 05/07/2019 at 02:47 PM");
INSERT INTO crm_audit_log VALUES("7900","2","11","2019-07-05 14:56:47","Entry Invoice [Invoice No: 22253] updated by GAREEB GAREEB on 05/07/2019 at 02:56 PM");
INSERT INTO crm_audit_log VALUES("7901","3","15","2019-07-05 15:11:01","Exit Invoice [Invoice No: 120903] updated by Abdul Rasheed on 05/07/2019 at 03:11 PM");
INSERT INTO crm_audit_log VALUES("7902","3","4","2019-07-05 16:45:38","Exit Invoice [Invoice No: 120904] updated by Yasir  Rahman on 05/07/2019 at 04:45 PM");
INSERT INTO crm_audit_log VALUES("7903","3","4","2019-07-05 17:09:34","Exit Invoice [Invoice No: 120905] updated by Yasir  Rahman on 05/07/2019 at 05:09 PM");
INSERT INTO crm_audit_log VALUES("7904","3","4","2019-07-05 17:30:44","Exit Invoice [Invoice No: 120906] updated by Yasir  Rahman on 05/07/2019 at 05:30 PM");
INSERT INTO crm_audit_log VALUES("7905","2","11","2019-07-05 18:07:13","Entry Invoice [Invoice No: 22254] updated by GAREEB GAREEB on 05/07/2019 at 06:07 PM");
INSERT INTO crm_audit_log VALUES("7906","3","4","2019-07-05 18:08:49","Exit Invoice [Invoice No: 120907] updated by Yasir  Rahman on 05/07/2019 at 06:08 PM");
INSERT INTO crm_audit_log VALUES("7907","2","11","2019-07-05 18:53:58","Entry Invoice [Invoice No: 22255] updated by GAREEB GAREEB on 05/07/2019 at 06:53 PM");
INSERT INTO crm_audit_log VALUES("7908","3","4","2019-07-05 20:57:15","Exit Invoice [Invoice No: 120908] updated by Yasir  Rahman on 05/07/2019 at 08:57 PM");
INSERT INTO crm_audit_log VALUES("7909","2","4","2019-07-05 21:03:03","Entry Invoice [Invoice No: 22256] updated by Yasir  Rahman on 05/07/2019 at 09:03 PM");
INSERT INTO crm_audit_log VALUES("7910","3","4","2019-07-05 21:06:50","Exit Invoice [Invoice No: 120909] updated by Yasir  Rahman on 05/07/2019 at 09:06 PM");
INSERT INTO crm_audit_log VALUES("7911","3","4","2019-07-05 22:55:55","Exit Invoice [Invoice No: 120910] updated by Yasir  Rahman on 05/07/2019 at 10:55 PM");
INSERT INTO crm_audit_log VALUES("7912","2","4","2019-07-05 22:59:37","Entry Invoice [Invoice No: 22257] updated by Yasir  Rahman on 05/07/2019 at 10:59 PM");
INSERT INTO crm_audit_log VALUES("7913","3","4","2019-07-06 00:30:38","Exit Invoice [Invoice No: 120911] updated by Yasir  Rahman on 06/07/2019 at 12:30 AM");
INSERT INTO crm_audit_log VALUES("7914","2","4","2019-07-06 01:13:17","Entry Invoice [Invoice No: 22258] updated by Yasir  Rahman on 06/07/2019 at 01:13 AM");
INSERT INTO crm_audit_log VALUES("7915","3","4","2019-07-06 02:33:10","Exit Invoice [Invoice No: 120912] updated by Yasir  Rahman on 06/07/2019 at 02:33 AM");
INSERT INTO crm_audit_log VALUES("7916","3","4","2019-07-06 02:34:50","Exit Invoice [Invoice No: 120913] updated by Yasir  Rahman on 06/07/2019 at 02:34 AM");
INSERT INTO crm_audit_log VALUES("7917","3","4","2019-07-06 02:49:56","Exit Invoice [Invoice No: 120914] updated by Yasir  Rahman on 06/07/2019 at 02:49 AM");
INSERT INTO crm_audit_log VALUES("7918","3","4","2019-07-06 03:13:31","Exit Invoice [Invoice No: 120915] updated by Yasir  Rahman on 06/07/2019 at 03:13 AM");
INSERT INTO crm_audit_log VALUES("7919","2","4","2019-07-06 06:28:23","Entry Invoice [Invoice No: 22259] updated by Yasir  Rahman on 06/07/2019 at 06:28 AM");
INSERT INTO crm_audit_log VALUES("7920","2","4","2019-07-06 06:31:23","Entry Invoice [Invoice No: 22260] updated by Yasir  Rahman on 06/07/2019 at 06:31 AM");
INSERT INTO crm_audit_log VALUES("7921","2","4","2019-07-06 06:33:12","Entry Invoice [Invoice No: 22261] updated by Yasir  Rahman on 06/07/2019 at 06:33 AM");
INSERT INTO crm_audit_log VALUES("7922","2","4","2019-07-06 06:34:37","Entry Invoice [Invoice No: 22262] updated by Yasir  Rahman on 06/07/2019 at 06:34 AM");
INSERT INTO crm_audit_log VALUES("7923","3","13","2019-07-06 09:19:38","Exit Invoice [Invoice No: 120916] updated by MUHAMMED HASHIM on 06/07/2019 at 09:19 AM");
INSERT INTO crm_audit_log VALUES("7924","3","13","2019-07-06 09:20:15","Exit Invoice [Invoice No: 120917] updated by MUHAMMED HASHIM on 06/07/2019 at 09:20 AM");
INSERT INTO crm_audit_log VALUES("7925","3","13","2019-07-06 09:56:28","Exit Invoice [Invoice No: 120918] updated by MUHAMMED HASHIM on 06/07/2019 at 09:56 AM");
INSERT INTO crm_audit_log VALUES("7926","3","13","2019-07-06 09:57:15","Exit Invoice [Invoice No: 120919] updated by MUHAMMED HASHIM on 06/07/2019 at 09:57 AM");
INSERT INTO crm_audit_log VALUES("7927","3","13","2019-07-06 10:13:20","Exit Invoice [Invoice No: 120920] updated by MUHAMMED HASHIM on 06/07/2019 at 10:13 AM");
INSERT INTO crm_audit_log VALUES("7928","2","11","2019-07-06 11:35:24","Entry Invoice [Invoice No: 22263] updated by GAREEB GAREEB on 06/07/2019 at 11:35 AM");
INSERT INTO crm_audit_log VALUES("7929","3","13","2019-07-06 12:24:54","Exit Invoice [Invoice No: 120921] updated by MUHAMMED HASHIM on 06/07/2019 at 12:24 PM");
INSERT INTO crm_audit_log VALUES("7930","2","11","2019-07-06 13:53:57","Entry Invoice [Invoice No: 22264] updated by GAREEB GAREEB on 06/07/2019 at 01:53 PM");
INSERT INTO crm_audit_log VALUES("7931","2","11","2019-07-06 15:46:19","Entry Invoice [Invoice No: 22265] updated by GAREEB GAREEB on 06/07/2019 at 03:46 PM");
INSERT INTO crm_audit_log VALUES("7932","3","4","2019-07-06 16:28:53","Exit Invoice [Invoice No: 120922] updated by Yasir  Rahman on 06/07/2019 at 04:28 PM");
INSERT INTO crm_audit_log VALUES("7933","3","4","2019-07-06 20:10:57","Exit Invoice [Invoice No: 120923] updated by Yasir  Rahman on 06/07/2019 at 08:10 PM");
INSERT INTO crm_audit_log VALUES("7934","3","4","2019-07-06 20:11:47","Exit Invoice [Invoice No: 120924] updated by Yasir  Rahman on 06/07/2019 at 08:11 PM");
INSERT INTO crm_audit_log VALUES("7935","3","6","2019-07-06 22:08:47","Exit Invoice [Invoice No: 120919] updated by ASHRAF  M K on 06/07/2019 at 10:08 PM");
INSERT INTO crm_audit_log VALUES("7936","3","6","2019-07-06 22:09:05","Exit Invoice [Invoice No: 120918] updated by ASHRAF  M K on 06/07/2019 at 10:09 PM");
INSERT INTO crm_audit_log VALUES("7937","3","4","2019-07-06 22:46:17","Exit Invoice [Invoice No: 120925] updated by Yasir  Rahman on 06/07/2019 at 10:46 PM");
INSERT INTO crm_audit_log VALUES("7938","3","4","2019-07-06 23:16:10","Exit Invoice [Invoice No: 120926] updated by Yasir  Rahman on 06/07/2019 at 11:16 PM");
INSERT INTO crm_audit_log VALUES("7939","3","4","2019-07-07 01:49:25","Exit Invoice [Invoice No: 120927] updated by Yasir  Rahman on 07/07/2019 at 01:49 AM");
INSERT INTO crm_audit_log VALUES("7940","3","4","2019-07-07 01:50:32","Exit Invoice [Invoice No: 120928] updated by Yasir  Rahman on 07/07/2019 at 01:50 AM");
INSERT INTO crm_audit_log VALUES("7941","2","4","2019-07-07 06:06:03","Entry Invoice [Invoice No: 22266] updated by Yasir  Rahman on 07/07/2019 at 06:06 AM");
INSERT INTO crm_audit_log VALUES("7942","3","4","2019-07-07 06:40:57","Exit Invoice [Invoice No: 120929] updated by Yasir  Rahman on 07/07/2019 at 06:40 AM");
INSERT INTO crm_audit_log VALUES("7943","3","15","2019-07-07 09:12:53","Exit Invoice [Invoice No: 120930] updated by Abdul Rasheed on 07/07/2019 at 09:12 AM");
INSERT INTO crm_audit_log VALUES("7944","2","11","2019-07-07 10:56:25","Entry Invoice [Invoice No: 22267] updated by GAREEB GAREEB on 07/07/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("7945","3","15","2019-07-07 12:39:27","Exit Invoice [Invoice No: 120931] updated by Abdul Rasheed on 07/07/2019 at 12:39 PM");
INSERT INTO crm_audit_log VALUES("7946","3","15","2019-07-07 13:26:41","Exit Invoice [Invoice No: 120932] updated by Abdul Rasheed on 07/07/2019 at 01:26 PM");
INSERT INTO crm_audit_log VALUES("7947","3","15","2019-07-07 13:32:36","Exit Invoice [Invoice No: 120933] updated by Abdul Rasheed on 07/07/2019 at 01:32 PM");
INSERT INTO crm_audit_log VALUES("7948","3","15","2019-07-07 13:42:09","Exit Invoice [Invoice No: 120934] updated by Abdul Rasheed on 07/07/2019 at 01:42 PM");
INSERT INTO crm_audit_log VALUES("7949","3","15","2019-07-07 13:49:04","Exit Invoice [Invoice No: 120935] updated by Abdul Rasheed on 07/07/2019 at 01:49 PM");
INSERT INTO crm_audit_log VALUES("7950","3","15","2019-07-07 14:28:51","Exit Invoice [Invoice No: 120936] updated by Abdul Rasheed on 07/07/2019 at 02:28 PM");
INSERT INTO crm_audit_log VALUES("7951","3","4","2019-07-07 16:34:22","Exit Invoice [Invoice No: 120937] updated by Yasir  Rahman on 07/07/2019 at 04:34 PM");
INSERT INTO crm_audit_log VALUES("7952","2","11","2019-07-07 17:57:32","Entry Invoice [Invoice No: 22268] updated by GAREEB GAREEB on 07/07/2019 at 05:57 PM");
INSERT INTO crm_audit_log VALUES("7953","3","4","2019-07-07 18:24:43","Exit Invoice [Invoice No: 120938] updated by Yasir  Rahman on 07/07/2019 at 06:24 PM");
INSERT INTO crm_audit_log VALUES("7954","3","4","2019-07-07 18:25:44","Exit Invoice [Invoice No: 120939] updated by Yasir  Rahman on 07/07/2019 at 06:25 PM");
INSERT INTO crm_audit_log VALUES("7955","1","4","2019-07-07 21:50:20","Customer [Customer No: 457] updated by Yasir  Rahman on 07/07/2019 at 09:50 PM");
INSERT INTO crm_audit_log VALUES("7956","2","4","2019-07-07 21:52:06","Entry Invoice [Invoice No: 22269] updated by Yasir  Rahman on 07/07/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("7957","3","4","2019-07-07 22:29:52","Exit Invoice [Invoice No: 120940] updated by Yasir  Rahman on 07/07/2019 at 10:29 PM");
INSERT INTO crm_audit_log VALUES("7958","3","4","2019-07-07 22:35:38","Exit Invoice [Invoice No: 120941] updated by Yasir  Rahman on 07/07/2019 at 10:35 PM");
INSERT INTO crm_audit_log VALUES("7959","3","4","2019-07-07 22:40:52","Exit Invoice [Invoice No: 120942] updated by Yasir  Rahman on 07/07/2019 at 10:40 PM");
INSERT INTO crm_audit_log VALUES("7960","3","4","2019-07-08 01:37:23","Exit Invoice [Invoice No: 120943] updated by Yasir  Rahman on 08/07/2019 at 01:37 AM");
INSERT INTO crm_audit_log VALUES("7961","3","4","2019-07-08 01:55:48","Exit Invoice [Invoice No: 120944] updated by Yasir  Rahman on 08/07/2019 at 01:55 AM");
INSERT INTO crm_audit_log VALUES("7962","3","4","2019-07-08 02:12:48","Exit Invoice [Invoice No: 120945] updated by Yasir  Rahman on 08/07/2019 at 02:12 AM");
INSERT INTO crm_audit_log VALUES("7963","3","4","2019-07-08 04:22:22","Exit Invoice [Invoice No: 120946] updated by Yasir  Rahman on 08/07/2019 at 04:22 AM");
INSERT INTO crm_audit_log VALUES("7964","3","4","2019-07-08 04:23:47","Exit Invoice [Invoice No: 120947] updated by Yasir  Rahman on 08/07/2019 at 04:23 AM");
INSERT INTO crm_audit_log VALUES("7965","2","4","2019-07-08 05:59:59","Entry Invoice [Invoice No: 22270] updated by Yasir  Rahman on 08/07/2019 at 05:59 AM");
INSERT INTO crm_audit_log VALUES("7966","2","4","2019-07-08 06:01:10","Entry Invoice [Invoice No: 22271] updated by Yasir  Rahman on 08/07/2019 at 06:01 AM");
INSERT INTO crm_audit_log VALUES("7967","2","11","2019-07-08 09:07:48","Entry Invoice [Invoice No: 22272] updated by GAREEB GAREEB on 08/07/2019 at 09:07 AM");
INSERT INTO crm_audit_log VALUES("7968","2","11","2019-07-08 09:09:48","Entry Invoice [Invoice No: 22273] updated by GAREEB GAREEB on 08/07/2019 at 09:09 AM");
INSERT INTO crm_audit_log VALUES("7969","3","15","2019-07-08 09:21:59","Exit Invoice [Invoice No: 120948] updated by Abdul Rasheed on 08/07/2019 at 09:21 AM");
INSERT INTO crm_audit_log VALUES("7970","3","15","2019-07-08 09:51:28","Exit Invoice [Invoice No: 120949] updated by Abdul Rasheed on 08/07/2019 at 09:51 AM");
INSERT INTO crm_audit_log VALUES("7971","3","15","2019-07-08 11:51:02","Exit Invoice [Invoice No: 120950] updated by Abdul Rasheed on 08/07/2019 at 11:51 AM");
INSERT INTO crm_audit_log VALUES("7972","3","15","2019-07-08 12:01:40","Exit Invoice [Invoice No: 120951] updated by Abdul Rasheed on 08/07/2019 at 12:01 PM");
INSERT INTO crm_audit_log VALUES("7973","2","11","2019-07-08 13:20:35","Entry Invoice [Invoice No: 22274] updated by GAREEB GAREEB on 08/07/2019 at 01:20 PM");
INSERT INTO crm_audit_log VALUES("7974","3","4","2019-07-08 15:42:36","Exit Invoice [Invoice No: 120952] updated by Yasir  Rahman on 08/07/2019 at 03:42 PM");
INSERT INTO crm_audit_log VALUES("7975","3","4","2019-07-08 16:44:56","Exit Invoice [Invoice No: 120953] updated by Yasir  Rahman on 08/07/2019 at 04:44 PM");
INSERT INTO crm_audit_log VALUES("7976","3","4","2019-07-08 16:46:33","Exit Invoice [Invoice No: 120954] updated by Yasir  Rahman on 08/07/2019 at 04:46 PM");
INSERT INTO crm_audit_log VALUES("7977","2","4","2019-07-08 21:19:36","Entry Invoice [Invoice No: 22275] updated by Yasir  Rahman on 08/07/2019 at 09:19 PM");
INSERT INTO crm_audit_log VALUES("7978","2","4","2019-07-08 21:27:54","Entry Invoice [Invoice No: 22276] updated by Yasir  Rahman on 08/07/2019 at 09:27 PM");
INSERT INTO crm_audit_log VALUES("7979","2","4","2019-07-08 21:30:39","Entry Invoice [Invoice No: 22277] updated by Yasir  Rahman on 08/07/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("7980","3","4","2019-07-09 01:54:50","Exit Invoice [Invoice No: 120955] updated by Yasir  Rahman on 09/07/2019 at 01:54 AM");
INSERT INTO crm_audit_log VALUES("7981","2","4","2019-07-09 01:57:16","Entry Invoice [Invoice No: 22278] updated by Yasir  Rahman on 09/07/2019 at 01:57 AM");
INSERT INTO crm_audit_log VALUES("7982","3","4","2019-07-09 03:33:09","Exit Invoice [Invoice No: 120956] updated by Yasir  Rahman on 09/07/2019 at 03:33 AM");
INSERT INTO crm_audit_log VALUES("7983","3","4","2019-07-09 04:14:22","Exit Invoice [Invoice No: 120957] updated by Yasir  Rahman on 09/07/2019 at 04:14 AM");
INSERT INTO crm_audit_log VALUES("7984","3","4","2019-07-09 05:43:59","Exit Invoice [Invoice No: 120958] updated by Yasir  Rahman on 09/07/2019 at 05:43 AM");
INSERT INTO crm_audit_log VALUES("7985","3","4","2019-07-09 05:45:13","Exit Invoice [Invoice No: 120959] updated by Yasir  Rahman on 09/07/2019 at 05:45 AM");
INSERT INTO crm_audit_log VALUES("7986","2","4","2019-07-09 06:12:32","Entry Invoice [Invoice No: 22279] updated by Yasir  Rahman on 09/07/2019 at 06:12 AM");
INSERT INTO crm_audit_log VALUES("7987","2","4","2019-07-09 06:13:50","Entry Invoice [Invoice No: 22280] updated by Yasir  Rahman on 09/07/2019 at 06:13 AM");
INSERT INTO crm_audit_log VALUES("7988","2","4","2019-07-09 06:15:25","Entry Invoice [Invoice No: 22281] updated by Yasir  Rahman on 09/07/2019 at 06:15 AM");
INSERT INTO crm_audit_log VALUES("7989","3","6","2019-07-09 08:53:44","Exit Invoice [Invoice No: 120955] updated by ASHRAF  M K on 09/07/2019 at 08:53 AM");
INSERT INTO crm_audit_log VALUES("7990","3","6","2019-07-09 08:55:02","Exit Invoice [Invoice No: 120960] updated by ASHRAF  M K on 09/07/2019 at 08:55 AM");
INSERT INTO crm_audit_log VALUES("7991","3","6","2019-07-09 08:58:20","Exit Invoice [Invoice No: 120959] updated by ASHRAF  M K on 09/07/2019 at 08:58 AM");
INSERT INTO crm_audit_log VALUES("7992","3","6","2019-07-09 08:59:06","Exit Invoice [Invoice No: 120958] updated by ASHRAF  M K on 09/07/2019 at 08:59 AM");
INSERT INTO crm_audit_log VALUES("7993","3","15","2019-07-09 09:33:37","Exit Invoice [Invoice No: 120961] updated by Abdul Rasheed on 09/07/2019 at 09:33 AM");
INSERT INTO crm_audit_log VALUES("7994","3","15","2019-07-09 10:20:54","Exit Invoice [Invoice No: 120962] updated by Abdul Rasheed on 09/07/2019 at 10:20 AM");
INSERT INTO crm_audit_log VALUES("7995","2","11","2019-07-09 10:24:21","Entry Invoice [Invoice No: 22282] updated by GAREEB GAREEB on 09/07/2019 at 10:24 AM");
INSERT INTO crm_audit_log VALUES("7996","3","15","2019-07-09 10:28:18","Exit Invoice [Invoice No: 120963] updated by Abdul Rasheed on 09/07/2019 at 10:28 AM");
INSERT INTO crm_audit_log VALUES("7997","3","15","2019-07-09 10:37:05","Exit Invoice [Invoice No: 120964] updated by Abdul Rasheed on 09/07/2019 at 10:37 AM");
INSERT INTO crm_audit_log VALUES("7998","3","15","2019-07-09 10:42:45","Exit Invoice [Invoice No: 120965] updated by Abdul Rasheed on 09/07/2019 at 10:42 AM");
INSERT INTO crm_audit_log VALUES("7999","3","15","2019-07-09 10:46:14","Exit Invoice [Invoice No: 120966] updated by Abdul Rasheed on 09/07/2019 at 10:46 AM");
INSERT INTO crm_audit_log VALUES("8000","3","15","2019-07-09 11:49:11","Exit Invoice [Invoice No: 120967] updated by Abdul Rasheed on 09/07/2019 at 11:49 AM");
INSERT INTO crm_audit_log VALUES("8001","3","15","2019-07-09 12:02:04","Exit Invoice [Invoice No: 120968] updated by Abdul Rasheed on 09/07/2019 at 12:02 PM");
INSERT INTO crm_audit_log VALUES("8002","2","11","2019-07-09 12:37:17","Entry Invoice [Invoice No: 22283] updated by GAREEB GAREEB on 09/07/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("8003","3","15","2019-07-09 13:52:01","Exit Invoice [Invoice No: 120969] updated by Abdul Rasheed on 09/07/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("8004","3","15","2019-07-09 13:53:04","Exit Invoice [Invoice No: 120970] updated by Abdul Rasheed on 09/07/2019 at 01:53 PM");
INSERT INTO crm_audit_log VALUES("8005","3","15","2019-07-09 13:55:01","Exit Invoice [Invoice No: 120971] updated by Abdul Rasheed on 09/07/2019 at 01:55 PM");
INSERT INTO crm_audit_log VALUES("8006","3","15","2019-07-09 14:23:51","Exit Invoice [Invoice No: 120972] updated by Abdul Rasheed on 09/07/2019 at 02:23 PM");
INSERT INTO crm_audit_log VALUES("8007","2","11","2019-07-09 15:27:07","Entry Invoice [Invoice No: 22284] updated by GAREEB GAREEB on 09/07/2019 at 03:27 PM");
INSERT INTO crm_audit_log VALUES("8008","2","11","2019-07-09 15:50:43","Entry Invoice [Invoice No: 22285] updated by GAREEB GAREEB on 09/07/2019 at 03:50 PM");
INSERT INTO crm_audit_log VALUES("8009","3","4","2019-07-09 17:28:05","Exit Invoice [Invoice No: 120973] updated by Yasir  Rahman on 09/07/2019 at 05:28 PM");
INSERT INTO crm_audit_log VALUES("8010","2","11","2019-07-09 18:28:16","Entry Invoice [Invoice No: 22286] updated by GAREEB GAREEB on 09/07/2019 at 06:28 PM");
INSERT INTO crm_audit_log VALUES("8011","2","11","2019-07-09 18:38:19","Entry Invoice [Invoice No: 22287] updated by GAREEB GAREEB on 09/07/2019 at 06:38 PM");
INSERT INTO crm_audit_log VALUES("8012","3","4","2019-07-09 18:52:53","Exit Invoice [Invoice No: 120974] updated by Yasir  Rahman on 09/07/2019 at 06:52 PM");
INSERT INTO crm_audit_log VALUES("8013","3","4","2019-07-09 19:17:46","Exit Invoice [Invoice No: 120975] updated by Yasir  Rahman on 09/07/2019 at 07:17 PM");
INSERT INTO crm_audit_log VALUES("8014","3","4","2019-07-09 21:46:02","Exit Invoice [Invoice No: 120976] updated by Yasir  Rahman on 09/07/2019 at 09:46 PM");
INSERT INTO crm_audit_log VALUES("8015","3","4","2019-07-09 21:47:24","Exit Invoice [Invoice No: 120977] updated by Yasir  Rahman on 09/07/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("8016","2","4","2019-07-09 21:54:21","Entry Invoice [Invoice No: 22288] updated by Yasir  Rahman on 09/07/2019 at 09:54 PM");
INSERT INTO crm_audit_log VALUES("8017","2","4","2019-07-09 21:57:41","Entry Invoice [Invoice No: 22289] updated by Yasir  Rahman on 09/07/2019 at 09:57 PM");
INSERT INTO crm_audit_log VALUES("8018","3","4","2019-07-09 23:18:10","Exit Invoice [Invoice No: 120978] updated by Yasir  Rahman on 09/07/2019 at 11:18 PM");
INSERT INTO crm_audit_log VALUES("8019","3","4","2019-07-09 23:20:46","Exit Invoice [Invoice No: 120979] updated by Yasir  Rahman on 09/07/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("8020","1","4","2019-07-09 23:27:13","Customer [Customer No: 458] updated by Yasir  Rahman on 09/07/2019 at 11:27 PM");
INSERT INTO crm_audit_log VALUES("8021","3","4","2019-07-09 23:28:29","Exit Invoice [Invoice No: 120980] updated by Yasir  Rahman on 09/07/2019 at 11:28 PM");
INSERT INTO crm_audit_log VALUES("8022","2","4","2019-07-09 23:30:43","Entry Invoice [Invoice No: 22290] updated by Yasir  Rahman on 09/07/2019 at 11:30 PM");
INSERT INTO crm_audit_log VALUES("8023","3","5","2019-07-10 00:42:25","Exit Invoice [Invoice No: 120981] updated by Imran  Khan on 10/07/2019 at 12:42 AM");
INSERT INTO crm_audit_log VALUES("8024","3","5","2019-07-10 00:42:59","Exit Invoice [Invoice No: 120982] updated by Imran  Khan on 10/07/2019 at 12:42 AM");
INSERT INTO crm_audit_log VALUES("8025","3","5","2019-07-10 02:11:49","Exit Invoice [Invoice No: 120983] updated by Imran  Khan on 10/07/2019 at 02:11 AM");
INSERT INTO crm_audit_log VALUES("8026","3","5","2019-07-10 03:08:12","Exit Invoice [Invoice No: 120984] updated by Imran  Khan on 10/07/2019 at 03:08 AM");
INSERT INTO crm_audit_log VALUES("8027","3","5","2019-07-10 03:53:21","Exit Invoice [Invoice No: 120985] updated by Imran  Khan on 10/07/2019 at 03:53 AM");
INSERT INTO crm_audit_log VALUES("8028","3","5","2019-07-10 06:35:58","Exit Invoice [Invoice No: 120986] updated by Imran  Khan on 10/07/2019 at 06:35 AM");
INSERT INTO crm_audit_log VALUES("8029","3","6","2019-07-10 08:25:33","Exit Invoice [Invoice No: 120978] updated by ASHRAF  M K on 10/07/2019 at 08:25 AM");
INSERT INTO crm_audit_log VALUES("8030","2","11","2019-07-10 09:01:06","Entry Invoice [Invoice No: 22291] updated by GAREEB GAREEB on 10/07/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("8031","3","15","2019-07-10 09:44:47","Exit Invoice [Invoice No: 120987] updated by Abdul Rasheed on 10/07/2019 at 09:44 AM");
INSERT INTO crm_audit_log VALUES("8032","3","15","2019-07-10 10:17:19","Exit Invoice [Invoice No: 120988] updated by Abdul Rasheed on 10/07/2019 at 10:17 AM");
INSERT INTO crm_audit_log VALUES("8033","3","6","2019-07-10 10:24:38","Exit Invoice [Invoice No: 120987] updated by ASHRAF  M K on 10/07/2019 at 10:24 AM");
INSERT INTO crm_audit_log VALUES("8034","3","6","2019-07-10 10:27:13","Exit Invoice [Invoice No: 120987] updated by ASHRAF  M K on 10/07/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("8035","3","6","2019-07-10 10:27:59","Exit Invoice [Invoice No: 120987] updated by ASHRAF  M K on 10/07/2019 at 10:27 AM");
INSERT INTO crm_audit_log VALUES("8036","3","15","2019-07-10 11:05:38","Exit Invoice [Invoice No: 120989] updated by Abdul Rasheed on 10/07/2019 at 11:05 AM");
INSERT INTO crm_audit_log VALUES("8037","3","15","2019-07-10 11:27:35","Exit Invoice [Invoice No: 120990] updated by Abdul Rasheed on 10/07/2019 at 11:27 AM");
INSERT INTO crm_audit_log VALUES("8038","3","15","2019-07-10 12:12:56","Exit Invoice [Invoice No: 120991] updated by Abdul Rasheed on 10/07/2019 at 12:12 PM");
INSERT INTO crm_audit_log VALUES("8039","2","11","2019-07-10 13:11:01","Entry Invoice [Invoice No: 22292] updated by GAREEB GAREEB on 10/07/2019 at 01:11 PM");
INSERT INTO crm_audit_log VALUES("8040","3","15","2019-07-10 13:52:28","Exit Invoice [Invoice No: 120992] updated by Abdul Rasheed on 10/07/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("8041","3","15","2019-07-10 15:03:23","Exit Invoice [Invoice No: 120993] updated by Abdul Rasheed on 10/07/2019 at 03:03 PM");
INSERT INTO crm_audit_log VALUES("8042","2","11","2019-07-10 15:20:23","Entry Invoice [Invoice No: 22293] updated by GAREEB GAREEB on 10/07/2019 at 03:20 PM");
INSERT INTO crm_audit_log VALUES("8043","3","15","2019-07-10 15:32:51","Exit Invoice [Invoice No: 120994] updated by Abdul Rasheed on 10/07/2019 at 03:32 PM");
INSERT INTO crm_audit_log VALUES("8044","3","15","2019-07-10 15:58:23","Exit Invoice [Invoice No: 120995] updated by Abdul Rasheed on 10/07/2019 at 03:58 PM");
INSERT INTO crm_audit_log VALUES("8045","3","4","2019-07-10 16:29:44","Exit Invoice [Invoice No: 120996] updated by Yasir  Rahman on 10/07/2019 at 04:29 PM");
INSERT INTO crm_audit_log VALUES("8046","3","4","2019-07-10 17:42:49","Exit Invoice [Invoice No: 120997] updated by Yasir  Rahman on 10/07/2019 at 05:42 PM");
INSERT INTO crm_audit_log VALUES("8047","3","4","2019-07-10 19:36:57","Exit Invoice [Invoice No: 120998] updated by Yasir  Rahman on 10/07/2019 at 07:36 PM");
INSERT INTO crm_audit_log VALUES("8048","2","4","2019-07-10 21:25:17","Entry Invoice [Invoice No: 22294] updated by Yasir  Rahman on 10/07/2019 at 09:25 PM");
INSERT INTO crm_audit_log VALUES("8049","2","4","2019-07-10 21:26:29","Entry Invoice [Invoice No: 22295] updated by Yasir  Rahman on 10/07/2019 at 09:26 PM");
INSERT INTO crm_audit_log VALUES("8050","3","5","2019-07-11 01:00:06","Exit Invoice [Invoice No: 120999] updated by Imran  Khan on 11/07/2019 at 01:00 AM");
INSERT INTO crm_audit_log VALUES("8051","3","5","2019-07-11 01:09:27","Exit Invoice [Invoice No: 121000] updated by Imran  Khan on 11/07/2019 at 01:09 AM");
INSERT INTO crm_audit_log VALUES("8052","3","5","2019-07-11 01:32:35","Exit Invoice [Invoice No: 121001] updated by Imran  Khan on 11/07/2019 at 01:32 AM");
INSERT INTO crm_audit_log VALUES("8053","3","5","2019-07-11 02:18:35","Exit Invoice [Invoice No: 121002] updated by Imran  Khan on 11/07/2019 at 02:18 AM");
INSERT INTO crm_audit_log VALUES("8054","3","5","2019-07-11 02:41:44","Exit Invoice [Invoice No: 121003] updated by Imran  Khan on 11/07/2019 at 02:41 AM");
INSERT INTO crm_audit_log VALUES("8055","2","4","2019-07-11 04:13:42","Entry Invoice [Invoice No: 22296] updated by Yasir  Rahman on 11/07/2019 at 04:13 AM");
INSERT INTO crm_audit_log VALUES("8056","2","4","2019-07-11 04:34:42","Entry Invoice [Invoice No: 22297] updated by Yasir  Rahman on 11/07/2019 at 04:34 AM");
INSERT INTO crm_audit_log VALUES("8057","2","4","2019-07-11 04:36:03","Entry Invoice [Invoice No: 22298] updated by Yasir  Rahman on 11/07/2019 at 04:36 AM");
INSERT INTO crm_audit_log VALUES("8058","3","5","2019-07-11 06:01:35","Exit Invoice [Invoice No: 121004] updated by Imran  Khan on 11/07/2019 at 06:01 AM");
INSERT INTO crm_audit_log VALUES("8059","3","6","2019-07-11 10:34:58","Exit Invoice [Invoice No: 121005] updated by ASHRAF  M K on 11/07/2019 at 10:34 AM");
INSERT INTO crm_audit_log VALUES("8060","3","6","2019-07-11 10:36:48","Exit Invoice [Invoice No: 121005] updated by ASHRAF  M K on 11/07/2019 at 10:36 AM");
INSERT INTO crm_audit_log VALUES("8061","3","6","2019-07-11 10:39:04","Exit Invoice [Invoice No: 121006] updated by ASHRAF  M K on 11/07/2019 at 10:39 AM");
INSERT INTO crm_audit_log VALUES("8062","3","6","2019-07-11 10:56:49","Exit Invoice [Invoice No: 121007] updated by ASHRAF  M K on 11/07/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("8063","3","6","2019-07-11 12:08:16","Exit Invoice [Invoice No: 121008] updated by ASHRAF  M K on 11/07/2019 at 12:08 PM");
INSERT INTO crm_audit_log VALUES("8064","3","6","2019-07-11 12:09:23","Exit Invoice [Invoice No: 121009] updated by ASHRAF  M K on 11/07/2019 at 12:09 PM");
INSERT INTO crm_audit_log VALUES("8065","3","6","2019-07-11 12:10:55","Exit Invoice [Invoice No: 121010] updated by ASHRAF  M K on 11/07/2019 at 12:10 PM");
INSERT INTO crm_audit_log VALUES("8066","3","6","2019-07-11 12:11:46","Exit Invoice [Invoice No: 121011] updated by ASHRAF  M K on 11/07/2019 at 12:11 PM");
INSERT INTO crm_audit_log VALUES("8067","3","6","2019-07-11 13:16:52","Exit Invoice [Invoice No: 121012] updated by ASHRAF  M K on 11/07/2019 at 01:16 PM");
INSERT INTO crm_audit_log VALUES("8068","3","6","2019-07-11 13:19:28","Exit Invoice [Invoice No: 121013] updated by ASHRAF  M K on 11/07/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("8069","3","6","2019-07-11 13:20:34","Exit Invoice [Invoice No: 121013] updated by ASHRAF  M K on 11/07/2019 at 01:20 PM");
INSERT INTO crm_audit_log VALUES("8070","3","6","2019-07-11 13:37:02","Exit Invoice [Invoice No: 121014] updated by ASHRAF  M K on 11/07/2019 at 01:37 PM");
INSERT INTO crm_audit_log VALUES("8071","1","6","2019-07-11 14:07:36","Customer [Customer No: 459] updated by ASHRAF  M K on 11/07/2019 at 02:07 PM");
INSERT INTO crm_audit_log VALUES("8072","1","6","2019-07-11 14:08:33","Customer [Customer No: 460] updated by ASHRAF  M K on 11/07/2019 at 02:08 PM");
INSERT INTO crm_audit_log VALUES("8073","3","6","2019-07-11 14:11:23","Exit Invoice [Invoice No: 121015] updated by ASHRAF  M K on 11/07/2019 at 02:11 PM");
INSERT INTO crm_audit_log VALUES("8074","3","6","2019-07-11 14:19:57","Exit Invoice [Invoice No: 121016] updated by ASHRAF  M K on 11/07/2019 at 02:19 PM");
INSERT INTO crm_audit_log VALUES("8075","3","6","2019-07-11 14:24:36","Exit Invoice [Invoice No: 121017] updated by ASHRAF  M K on 11/07/2019 at 02:24 PM");
INSERT INTO crm_audit_log VALUES("8076","2","11","2019-07-11 14:27:58","Entry Invoice [Invoice No: 22299] updated by GAREEB GAREEB on 11/07/2019 at 02:27 PM");
INSERT INTO crm_audit_log VALUES("8077","2","11","2019-07-11 14:34:50","Entry Invoice [Invoice No: 22300] updated by GAREEB GAREEB on 11/07/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("8078","3","6","2019-07-11 14:49:35","Exit Invoice [Invoice No: 121015] updated by ASHRAF  M K on 11/07/2019 at 02:49 PM");
INSERT INTO crm_audit_log VALUES("8079","3","6","2019-07-11 15:01:18","Exit Invoice [Invoice No: 121017] updated by ASHRAF  M K on 11/07/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("8080","3","6","2019-07-11 15:18:40","Exit Invoice [Invoice No: 121018] updated by ASHRAF  M K on 11/07/2019 at 03:18 PM");
INSERT INTO crm_audit_log VALUES("8081","2","11","2019-07-11 15:22:40","Entry Invoice [Invoice No: 22301] updated by GAREEB GAREEB on 11/07/2019 at 03:22 PM");
INSERT INTO crm_audit_log VALUES("8082","3","6","2019-07-11 15:34:31","Exit Invoice [Invoice No: 121019] updated by ASHRAF  M K on 11/07/2019 at 03:34 PM");
INSERT INTO crm_audit_log VALUES("8083","3","4","2019-07-11 17:46:17","Exit Invoice [Invoice No: 121020] updated by Yasir  Rahman on 11/07/2019 at 05:46 PM");
INSERT INTO crm_audit_log VALUES("8084","3","4","2019-07-11 17:48:33","Exit Invoice [Invoice No: 121021] updated by Yasir  Rahman on 11/07/2019 at 05:48 PM");
INSERT INTO crm_audit_log VALUES("8085","2","11","2019-07-11 17:50:34","Entry Invoice [Invoice No: 22302] updated by GAREEB GAREEB on 11/07/2019 at 05:50 PM");
INSERT INTO crm_audit_log VALUES("8086","3","4","2019-07-11 19:40:34","Exit Invoice [Invoice No: 121022] updated by Yasir  Rahman on 11/07/2019 at 07:40 PM");
INSERT INTO crm_audit_log VALUES("8087","3","4","2019-07-11 21:23:09","Exit Invoice [Invoice No: 121023] updated by Yasir  Rahman on 11/07/2019 at 09:23 PM");
INSERT INTO crm_audit_log VALUES("8088","3","4","2019-07-11 21:26:50","Exit Invoice [Invoice No: 121024] updated by Yasir  Rahman on 11/07/2019 at 09:26 PM");
INSERT INTO crm_audit_log VALUES("8089","3","4","2019-07-11 21:54:58","Exit Invoice [Invoice No: 121025] updated by Yasir  Rahman on 11/07/2019 at 09:54 PM");
INSERT INTO crm_audit_log VALUES("8090","3","4","2019-07-11 23:25:35","Exit Invoice [Invoice No: 121026] updated by Yasir  Rahman on 11/07/2019 at 11:25 PM");
INSERT INTO crm_audit_log VALUES("8091","3","5","2019-07-12 00:09:05","Exit Invoice [Invoice No: 121027] updated by Imran  Khan on 12/07/2019 at 12:09 AM");
INSERT INTO crm_audit_log VALUES("8092","3","5","2019-07-12 00:49:09","Exit Invoice [Invoice No: 121028] updated by Imran  Khan on 12/07/2019 at 12:49 AM");
INSERT INTO crm_audit_log VALUES("8093","2","4","2019-07-12 01:33:27","Entry Invoice [Invoice No: 22303] updated by Yasir  Rahman on 12/07/2019 at 01:33 AM");
INSERT INTO crm_audit_log VALUES("8094","2","4","2019-07-12 01:38:31","Entry Invoice [Invoice No: 22304] updated by Yasir  Rahman on 12/07/2019 at 01:38 AM");
INSERT INTO crm_audit_log VALUES("8095","3","5","2019-07-12 01:51:04","Exit Invoice [Invoice No: 121029] updated by Imran  Khan on 12/07/2019 at 01:51 AM");
INSERT INTO crm_audit_log VALUES("8096","3","4","2019-07-12 03:17:28","Exit Invoice [Invoice No: 121030] updated by Yasir  Rahman on 12/07/2019 at 03:17 AM");
INSERT INTO crm_audit_log VALUES("8097","3","4","2019-07-12 03:22:13","Exit Invoice [Invoice No: 121031] updated by Yasir  Rahman on 12/07/2019 at 03:22 AM");
INSERT INTO crm_audit_log VALUES("8098","3","5","2019-07-12 04:22:47","Exit Invoice [Invoice No: 121032] updated by Imran  Khan on 12/07/2019 at 04:22 AM");
INSERT INTO crm_audit_log VALUES("8099","2","4","2019-07-12 06:31:22","Entry Invoice [Invoice No: 22305] updated by Yasir  Rahman on 12/07/2019 at 06:31 AM");
INSERT INTO crm_audit_log VALUES("8100","3","5","2019-07-12 06:32:57","Exit Invoice [Invoice No: 121033] updated by Imran  Khan on 12/07/2019 at 06:32 AM");
INSERT INTO crm_audit_log VALUES("8101","2","4","2019-07-12 06:33:35","Entry Invoice [Invoice No: 22306] updated by Yasir  Rahman on 12/07/2019 at 06:33 AM");
INSERT INTO crm_audit_log VALUES("8102","2","4","2019-07-12 07:52:59","Entry Invoice [Invoice No: 22307] updated by Yasir  Rahman on 12/07/2019 at 07:52 AM");
INSERT INTO crm_audit_log VALUES("8103","2","11","2019-07-12 08:46:10","Entry Invoice [Invoice No: 22308] updated by GAREEB GAREEB on 12/07/2019 at 08:46 AM");
INSERT INTO crm_audit_log VALUES("8104","3","15","2019-07-12 08:48:34","Exit Invoice [Invoice No: 121034] updated by Abdul Rasheed on 12/07/2019 at 08:48 AM");
INSERT INTO crm_audit_log VALUES("8105","2","11","2019-07-12 09:02:36","Entry Invoice [Invoice No: 22309] updated by GAREEB GAREEB on 12/07/2019 at 09:02 AM");
INSERT INTO crm_audit_log VALUES("8106","2","11","2019-07-12 09:04:17","Entry Invoice [Invoice No: 22310] updated by GAREEB GAREEB on 12/07/2019 at 09:04 AM");
INSERT INTO crm_audit_log VALUES("8107","3","6","2019-07-12 10:17:01","Exit Invoice [Invoice No: 121034] updated by ASHRAF  M K on 12/07/2019 at 10:17 AM");
INSERT INTO crm_audit_log VALUES("8108","3","6","2019-07-12 10:49:35","Exit Invoice [Invoice No: 121035] updated by ASHRAF  M K on 12/07/2019 at 10:49 AM");
INSERT INTO crm_audit_log VALUES("8109","3","6","2019-07-12 11:01:24","Exit Invoice [Invoice No: 121036] updated by ASHRAF  M K on 12/07/2019 at 11:01 AM");
INSERT INTO crm_audit_log VALUES("8110","3","6","2019-07-12 11:15:04","Exit Invoice [Invoice No: 121037] updated by ASHRAF  M K on 12/07/2019 at 11:15 AM");
INSERT INTO crm_audit_log VALUES("8111","3","6","2019-07-12 11:33:33","Exit Invoice [Invoice No: 121038] updated by ASHRAF  M K on 12/07/2019 at 11:33 AM");
INSERT INTO crm_audit_log VALUES("8112","1","6","2019-07-12 11:34:29","Customer [Customer No: 203] updated by ASHRAF  M K on 12/07/2019 at 11:34 AM");
INSERT INTO crm_audit_log VALUES("8113","1","6","2019-07-12 11:34:51","Customer [Customer No: 296] updated by ASHRAF  M K on 12/07/2019 at 11:34 AM");
INSERT INTO crm_audit_log VALUES("8114","3","6","2019-07-12 11:37:46","Exit Invoice [Invoice No: 121036] updated by ASHRAF  M K on 12/07/2019 at 11:37 AM");
INSERT INTO crm_audit_log VALUES("8115","2","6","2019-07-12 11:50:29","Entry Invoice [Invoice No: 22307] updated by ASHRAF  M K on 12/07/2019 at 11:50 AM");
INSERT INTO crm_audit_log VALUES("8116","3","15","2019-07-12 13:44:35","Exit Invoice [Invoice No: 121039] updated by Abdul Rasheed on 12/07/2019 at 01:44 PM");
INSERT INTO crm_audit_log VALUES("8117","3","15","2019-07-12 13:55:59","Exit Invoice [Invoice No: 121040] updated by Abdul Rasheed on 12/07/2019 at 01:55 PM");
INSERT INTO crm_audit_log VALUES("8118","3","15","2019-07-12 14:10:24","Exit Invoice [Invoice No: 121041] updated by Abdul Rasheed on 12/07/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("8119","3","6","2019-07-12 14:17:56","Exit Invoice [Invoice No: 121041] updated by ASHRAF  M K on 12/07/2019 at 02:17 PM");
INSERT INTO crm_audit_log VALUES("8120","3","6","2019-07-12 14:38:41","Exit Invoice [Invoice No: 121042] updated by ASHRAF  M K on 12/07/2019 at 02:38 PM");
INSERT INTO crm_audit_log VALUES("8121","2","11","2019-07-12 15:12:38","Entry Invoice [Invoice No: 22311] updated by GAREEB GAREEB on 12/07/2019 at 03:12 PM");
INSERT INTO crm_audit_log VALUES("8122","3","4","2019-07-12 16:22:08","Exit Invoice [Invoice No: 121043] updated by Yasir  Rahman on 12/07/2019 at 04:22 PM");
INSERT INTO crm_audit_log VALUES("8123","3","4","2019-07-12 18:00:32","Exit Invoice [Invoice No: 121044] updated by Yasir  Rahman on 12/07/2019 at 06:00 PM");
INSERT INTO crm_audit_log VALUES("8124","2","11","2019-07-12 18:19:19","Entry Invoice [Invoice No: 22312] updated by GAREEB GAREEB on 12/07/2019 at 06:19 PM");
INSERT INTO crm_audit_log VALUES("8125","3","4","2019-07-12 20:20:51","Exit Invoice [Invoice No: 121045] updated by Yasir  Rahman on 12/07/2019 at 08:20 PM");
INSERT INTO crm_audit_log VALUES("8126","2","4","2019-07-12 20:34:58","Entry Invoice [Invoice No: 22313] updated by Yasir  Rahman on 12/07/2019 at 08:34 PM");
INSERT INTO crm_audit_log VALUES("8127","2","4","2019-07-12 21:13:43","Entry Invoice [Invoice No: 22314] updated by Yasir  Rahman on 12/07/2019 at 09:13 PM");
INSERT INTO crm_audit_log VALUES("8128","3","4","2019-07-12 21:30:06","Exit Invoice [Invoice No: 121046] updated by Yasir  Rahman on 12/07/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("8129","3","5","2019-07-13 00:49:15","Exit Invoice [Invoice No: 121047] updated by Imran  Khan on 13/07/2019 at 12:49 AM");
INSERT INTO crm_audit_log VALUES("8130","3","5","2019-07-13 00:59:44","Exit Invoice [Invoice No: 121048] updated by Imran  Khan on 13/07/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("8131","3","5","2019-07-13 03:50:58","Exit Invoice [Invoice No: 121049] updated by Imran  Khan on 13/07/2019 at 03:50 AM");
INSERT INTO crm_audit_log VALUES("8132","3","5","2019-07-13 04:10:57","Exit Invoice [Invoice No: 121050] updated by Imran  Khan on 13/07/2019 at 04:10 AM");
INSERT INTO crm_audit_log VALUES("8133","2","4","2019-07-13 04:11:30","Entry Invoice [Invoice No: 22315] updated by Yasir  Rahman on 13/07/2019 at 04:11 AM");
INSERT INTO crm_audit_log VALUES("8134","2","4","2019-07-13 04:17:19","Entry Invoice [Invoice No: 22316] updated by Yasir  Rahman on 13/07/2019 at 04:17 AM");
INSERT INTO crm_audit_log VALUES("8135","3","5","2019-07-13 04:19:23","Exit Invoice [Invoice No: 121051] updated by Imran  Khan on 13/07/2019 at 04:19 AM");
INSERT INTO crm_audit_log VALUES("8136","2","4","2019-07-13 04:19:44","Entry Invoice [Invoice No: 22317] updated by Yasir  Rahman on 13/07/2019 at 04:19 AM");
INSERT INTO crm_audit_log VALUES("8137","3","5","2019-07-13 04:20:04","Exit Invoice [Invoice No: 121052] updated by Imran  Khan on 13/07/2019 at 04:20 AM");
INSERT INTO crm_audit_log VALUES("8138","3","5","2019-07-13 06:26:41","Exit Invoice [Invoice No: 121053] updated by Imran  Khan on 13/07/2019 at 06:26 AM");
INSERT INTO crm_audit_log VALUES("8139","2","6","2019-07-13 09:30:45","Entry Invoice [Invoice No: 22315] updated by ASHRAF  M K on 13/07/2019 at 09:30 AM");
INSERT INTO crm_audit_log VALUES("8140","3","15","2019-07-13 10:55:42","Exit Invoice [Invoice No: 121054] updated by Abdul Rasheed on 13/07/2019 at 10:55 AM");
INSERT INTO crm_audit_log VALUES("8141","3","15","2019-07-13 11:06:13","Exit Invoice [Invoice No: 121055] updated by Abdul Rasheed on 13/07/2019 at 11:06 AM");
INSERT INTO crm_audit_log VALUES("8142","3","15","2019-07-13 11:34:06","Exit Invoice [Invoice No: 121056] updated by Abdul Rasheed on 13/07/2019 at 11:34 AM");
INSERT INTO crm_audit_log VALUES("8143","3","15","2019-07-13 12:33:42","Exit Invoice [Invoice No: 121057] updated by Abdul Rasheed on 13/07/2019 at 12:33 PM");
INSERT INTO crm_audit_log VALUES("8144","2","11","2019-07-13 12:37:31","Entry Invoice [Invoice No: 22318] updated by GAREEB GAREEB on 13/07/2019 at 12:37 PM");
INSERT INTO crm_audit_log VALUES("8145","2","11","2019-07-13 13:19:58","Entry Invoice [Invoice No: 22319] updated by GAREEB GAREEB on 13/07/2019 at 01:19 PM");
INSERT INTO crm_audit_log VALUES("8146","3","15","2019-07-13 13:51:08","Exit Invoice [Invoice No: 121058] updated by Abdul Rasheed on 13/07/2019 at 01:51 PM");
INSERT INTO crm_audit_log VALUES("8147","3","15","2019-07-13 13:52:04","Exit Invoice [Invoice No: 121059] updated by Abdul Rasheed on 13/07/2019 at 01:52 PM");
INSERT INTO crm_audit_log VALUES("8148","2","11","2019-07-13 14:46:05","Entry Invoice [Invoice No: 22320] updated by GAREEB GAREEB on 13/07/2019 at 02:46 PM");
INSERT INTO crm_audit_log VALUES("8149","2","4","2019-07-13 21:31:43","Entry Invoice [Invoice No: 22321] updated by Yasir  Rahman on 13/07/2019 at 09:31 PM");
INSERT INTO crm_audit_log VALUES("8150","2","4","2019-07-13 23:20:28","Entry Invoice [Invoice No: 22322] updated by Yasir  Rahman on 13/07/2019 at 11:20 PM");
INSERT INTO crm_audit_log VALUES("8151","3","5","2019-07-14 00:18:12","Exit Invoice [Invoice No: 121060] updated by Imran  Khan on 14/07/2019 at 12:18 AM");
INSERT INTO crm_audit_log VALUES("8152","3","5","2019-07-14 01:12:22","Exit Invoice [Invoice No: 121061] updated by Imran  Khan on 14/07/2019 at 01:12 AM");
INSERT INTO crm_audit_log VALUES("8153","3","5","2019-07-14 04:15:55","Exit Invoice [Invoice No: 121062] updated by Imran  Khan on 14/07/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("8154","3","5","2019-07-14 04:54:24","Exit Invoice [Invoice No: 121063] updated by Imran  Khan on 14/07/2019 at 04:54 AM");
INSERT INTO crm_audit_log VALUES("8155","3","5","2019-07-14 04:55:03","Exit Invoice [Invoice No: 121064] updated by Imran  Khan on 14/07/2019 at 04:55 AM");
INSERT INTO crm_audit_log VALUES("8156","3","5","2019-07-14 04:56:41","Exit Invoice [Invoice No: 121065] updated by Imran  Khan on 14/07/2019 at 04:56 AM");
INSERT INTO crm_audit_log VALUES("8157","2","4","2019-07-14 05:14:38","Entry Invoice [Invoice No: 22323] updated by Yasir  Rahman on 14/07/2019 at 05:14 AM");
INSERT INTO crm_audit_log VALUES("8158","2","4","2019-07-14 05:17:11","Entry Invoice [Invoice No: 22324] updated by Yasir  Rahman on 14/07/2019 at 05:17 AM");
INSERT INTO crm_audit_log VALUES("8159","2","4","2019-07-14 05:58:30","Entry Invoice [Invoice No: 22325] updated by Yasir  Rahman on 14/07/2019 at 05:58 AM");
INSERT INTO crm_audit_log VALUES("8160","2","11","2019-07-14 09:40:47","Entry Invoice [Invoice No: 22326] updated by GAREEB GAREEB on 14/07/2019 at 09:40 AM");
INSERT INTO crm_audit_log VALUES("8161","3","15","2019-07-14 12:25:36","Exit Invoice [Invoice No: 121066] updated by Abdul Rasheed on 14/07/2019 at 12:25 PM");
INSERT INTO crm_audit_log VALUES("8162","3","15","2019-07-14 12:27:06","Exit Invoice [Invoice No: 121067] updated by Abdul Rasheed on 14/07/2019 at 12:27 PM");
INSERT INTO crm_audit_log VALUES("8163","2","11","2019-07-14 12:30:07","Entry Invoice [Invoice No: 22327] updated by GAREEB GAREEB on 14/07/2019 at 12:30 PM");
INSERT INTO crm_audit_log VALUES("8164","2","11","2019-07-14 15:02:10","Entry Invoice [Invoice No: 22328] updated by GAREEB GAREEB on 14/07/2019 at 03:02 PM");
INSERT INTO crm_audit_log VALUES("8165","3","4","2019-07-14 16:31:42","Exit Invoice [Invoice No: 121068] updated by Yasir  Rahman on 14/07/2019 at 04:31 PM");
INSERT INTO crm_audit_log VALUES("8166","3","4","2019-07-14 16:54:39","Exit Invoice [Invoice No: 121069] updated by Yasir  Rahman on 14/07/2019 at 04:54 PM");
INSERT INTO crm_audit_log VALUES("8167","3","4","2019-07-14 19:37:26","Exit Invoice [Invoice No: 121070] updated by Yasir  Rahman on 14/07/2019 at 07:37 PM");
INSERT INTO crm_audit_log VALUES("8168","3","4","2019-07-14 20:18:50","Exit Invoice [Invoice No: 121071] updated by Yasir  Rahman on 14/07/2019 at 08:18 PM");
INSERT INTO crm_audit_log VALUES("8169","3","4","2019-07-14 21:07:57","Exit Invoice [Invoice No: 121072] updated by Yasir  Rahman on 14/07/2019 at 09:07 PM");
INSERT INTO crm_audit_log VALUES("8170","3","15","2019-07-15 08:29:53","Exit Invoice [Invoice No: 121073] updated by Abdul Rasheed on 15/07/2019 at 08:29 AM");
INSERT INTO crm_audit_log VALUES("8171","3","15","2019-07-15 08:31:13","Exit Invoice [Invoice No: 121074] updated by Abdul Rasheed on 15/07/2019 at 08:31 AM");
INSERT INTO crm_audit_log VALUES("8172","3","15","2019-07-15 08:36:07","Exit Invoice [Invoice No: 121075] updated by Abdul Rasheed on 15/07/2019 at 08:36 AM");
INSERT INTO crm_audit_log VALUES("8173","3","15","2019-07-15 09:18:07","Exit Invoice [Invoice No: 121076] updated by Abdul Rasheed on 15/07/2019 at 09:18 AM");
INSERT INTO crm_audit_log VALUES("8174","3","15","2019-07-15 09:22:05","Exit Invoice [Invoice No: 121077] updated by Abdul Rasheed on 15/07/2019 at 09:22 AM");
INSERT INTO crm_audit_log VALUES("8175","3","15","2019-07-15 09:25:40","Exit Invoice [Invoice No: 121078] updated by Abdul Rasheed on 15/07/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("8176","3","15","2019-07-15 09:28:49","Exit Invoice [Invoice No: 121079] updated by Abdul Rasheed on 15/07/2019 at 09:28 AM");
INSERT INTO crm_audit_log VALUES("8177","3","15","2019-07-15 09:41:54","Exit Invoice [Invoice No: 121080] updated by Abdul Rasheed on 15/07/2019 at 09:41 AM");
INSERT INTO crm_audit_log VALUES("8178","2","11","2019-07-15 10:18:09","Entry Invoice [Invoice No: 22329] updated by GAREEB GAREEB on 15/07/2019 at 10:18 AM");
INSERT INTO crm_audit_log VALUES("8179","2","11","2019-07-15 10:22:04","Entry Invoice [Invoice No: 22330] updated by GAREEB GAREEB on 15/07/2019 at 10:22 AM");
INSERT INTO crm_audit_log VALUES("8180","2","11","2019-07-15 10:23:15","Entry Invoice [Invoice No: 22331] updated by GAREEB GAREEB on 15/07/2019 at 10:23 AM");
INSERT INTO crm_audit_log VALUES("8181","2","11","2019-07-15 10:24:27","Entry Invoice [Invoice No: 22332] updated by GAREEB GAREEB on 15/07/2019 at 10:24 AM");
INSERT INTO crm_audit_log VALUES("8182","3","15","2019-07-15 11:44:46","Exit Invoice [Invoice No: 121081] updated by Abdul Rasheed on 15/07/2019 at 11:44 AM");
INSERT INTO crm_audit_log VALUES("8183","3","15","2019-07-15 12:41:57","Exit Invoice [Invoice No: 121082] updated by Abdul Rasheed on 15/07/2019 at 12:41 PM");
INSERT INTO crm_audit_log VALUES("8184","3","15","2019-07-15 12:46:31","Exit Invoice [Invoice No: 121083] updated by Abdul Rasheed on 15/07/2019 at 12:46 PM");
INSERT INTO crm_audit_log VALUES("8185","3","6","2019-07-15 13:02:13","Exit Invoice [Invoice No: 121081] updated by ASHRAF  M K on 15/07/2019 at 01:02 PM");
INSERT INTO crm_audit_log VALUES("8186","3","6","2019-07-15 13:25:06","Exit Invoice [Invoice No: 121084] updated by ASHRAF  M K on 15/07/2019 at 01:25 PM");
INSERT INTO crm_audit_log VALUES("8187","2","11","2019-07-15 14:44:43","Entry Invoice [Invoice No: 22333] updated by GAREEB GAREEB on 15/07/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("8188","3","15","2019-07-15 15:08:07","Exit Invoice [Invoice No: 121085] updated by Abdul Rasheed on 15/07/2019 at 03:08 PM");
INSERT INTO crm_audit_log VALUES("8189","3","4","2019-07-15 16:31:47","Exit Invoice [Invoice No: 121086] updated by Yasir  Rahman on 15/07/2019 at 04:31 PM");
INSERT INTO crm_audit_log VALUES("8190","3","4","2019-07-15 16:33:05","Exit Invoice [Invoice No: 121087] updated by Yasir  Rahman on 15/07/2019 at 04:33 PM");
INSERT INTO crm_audit_log VALUES("8191","3","4","2019-07-15 16:34:26","Exit Invoice [Invoice No: 121088] updated by Yasir  Rahman on 15/07/2019 at 04:34 PM");
INSERT INTO crm_audit_log VALUES("8192","3","4","2019-07-15 16:35:47","Exit Invoice [Invoice No: 121089] updated by Yasir  Rahman on 15/07/2019 at 04:35 PM");
INSERT INTO crm_audit_log VALUES("8193","3","4","2019-07-15 16:36:38","Exit Invoice [Invoice No: 121090] updated by Yasir  Rahman on 15/07/2019 at 04:36 PM");
INSERT INTO crm_audit_log VALUES("8194","3","4","2019-07-15 17:00:12","Exit Invoice [Invoice No: 121091] updated by Yasir  Rahman on 15/07/2019 at 05:00 PM");
INSERT INTO crm_audit_log VALUES("8195","3","4","2019-07-15 17:53:20","Exit Invoice [Invoice No: 121092] updated by Yasir  Rahman on 15/07/2019 at 05:53 PM");
INSERT INTO crm_audit_log VALUES("8196","2","11","2019-07-15 18:36:41","Entry Invoice [Invoice No: 22334] updated by GAREEB GAREEB on 15/07/2019 at 06:36 PM");
INSERT INTO crm_audit_log VALUES("8197","2","11","2019-07-15 18:55:48","Entry Invoice [Invoice No: 22335] updated by GAREEB GAREEB on 15/07/2019 at 06:55 PM");
INSERT INTO crm_audit_log VALUES("8198","3","4","2019-07-15 19:37:33","Exit Invoice [Invoice No: 121093] updated by Yasir  Rahman on 15/07/2019 at 07:37 PM");
INSERT INTO crm_audit_log VALUES("8199","3","4","2019-07-15 23:43:20","Exit Invoice [Invoice No: 121094] updated by Yasir  Rahman on 15/07/2019 at 11:43 PM");
INSERT INTO crm_audit_log VALUES("8200","3","5","2019-07-16 00:53:07","Exit Invoice [Invoice No: 121095] updated by Imran  Khan on 16/07/2019 at 12:53 AM");
INSERT INTO crm_audit_log VALUES("8201","3","5","2019-07-16 01:56:36","Exit Invoice [Invoice No: 121096] updated by Imran  Khan on 16/07/2019 at 01:56 AM");
INSERT INTO crm_audit_log VALUES("8202","3","5","2019-07-16 02:09:34","Exit Invoice [Invoice No: 121097] updated by Imran  Khan on 16/07/2019 at 02:09 AM");
INSERT INTO crm_audit_log VALUES("8203","3","5","2019-07-16 03:04:34","Exit Invoice [Invoice No: 121098] updated by Imran  Khan on 16/07/2019 at 03:04 AM");
INSERT INTO crm_audit_log VALUES("8204","2","4","2019-07-16 06:42:15","Entry Invoice [Invoice No: 22336] updated by Yasir  Rahman on 16/07/2019 at 06:42 AM");
INSERT INTO crm_audit_log VALUES("8205","2","4","2019-07-16 06:43:22","Entry Invoice [Invoice No: 22337] updated by Yasir  Rahman on 16/07/2019 at 06:43 AM");
INSERT INTO crm_audit_log VALUES("8206","2","4","2019-07-16 06:44:52","Entry Invoice [Invoice No: 22338] updated by Yasir  Rahman on 16/07/2019 at 06:44 AM");
INSERT INTO crm_audit_log VALUES("8207","2","4","2019-07-16 06:45:58","Entry Invoice [Invoice No: 22339] updated by Yasir  Rahman on 16/07/2019 at 06:45 AM");
INSERT INTO crm_audit_log VALUES("8208","3","5","2019-07-16 07:14:03","Exit Invoice [Invoice No: 121099] updated by Imran  Khan on 16/07/2019 at 07:14 AM");
INSERT INTO crm_audit_log VALUES("8209","3","5","2019-07-16 07:58:38","Exit Invoice [Invoice No: 121100] updated by Imran  Khan on 16/07/2019 at 07:58 AM");
INSERT INTO crm_audit_log VALUES("8210","2","6","2019-07-16 08:16:40","Entry Invoice [Invoice No: 22337] updated by ASHRAF  M K on 16/07/2019 at 08:16 AM");
INSERT INTO crm_audit_log VALUES("8211","2","6","2019-07-16 08:17:08","Entry Invoice [Invoice No: 22336] updated by ASHRAF  M K on 16/07/2019 at 08:17 AM");
INSERT INTO crm_audit_log VALUES("8212","1","6","2019-07-16 08:29:31","Customer [Customer No: 163] updated by ASHRAF  M K on 16/07/2019 at 08:29 AM");
INSERT INTO crm_audit_log VALUES("8213","3","6","2019-07-16 09:00:54","Exit Invoice [Invoice No: 121099] updated by ASHRAF  M K on 16/07/2019 at 09:00 AM");
INSERT INTO crm_audit_log VALUES("8214","3","6","2019-07-16 09:01:48","Exit Invoice [Invoice No: 121101] updated by ASHRAF  M K on 16/07/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("8215","3","6","2019-07-16 09:08:29","Exit Invoice [Invoice No: 121102] updated by ASHRAF  M K on 16/07/2019 at 09:08 AM");
INSERT INTO crm_audit_log VALUES("8216","3","6","2019-07-16 09:43:36","Exit Invoice [Invoice No: 121096] updated by ASHRAF  M K on 16/07/2019 at 09:43 AM");
INSERT INTO crm_audit_log VALUES("8217","3","15","2019-07-16 11:15:32","Exit Invoice [Invoice No: 121103] updated by Abdul Rasheed on 16/07/2019 at 11:15 AM");
INSERT INTO crm_audit_log VALUES("8218","3","15","2019-07-16 11:30:05","Exit Invoice [Invoice No: 121104] updated by Abdul Rasheed on 16/07/2019 at 11:30 AM");
INSERT INTO crm_audit_log VALUES("8219","3","15","2019-07-16 12:06:46","Exit Invoice [Invoice No: 121105] updated by Abdul Rasheed on 16/07/2019 at 12:06 PM");
INSERT INTO crm_audit_log VALUES("8220","1","6","2019-07-16 14:20:34","Customer [Customer No: 71] updated by ASHRAF  M K on 16/07/2019 at 02:20 PM");
INSERT INTO crm_audit_log VALUES("8221","3","15","2019-07-16 14:34:32","Exit Invoice [Invoice No: 121106] updated by Abdul Rasheed on 16/07/2019 at 02:34 PM");
INSERT INTO crm_audit_log VALUES("8222","2","6","2019-07-16 15:17:05","Entry Invoice [Invoice No: 22340] updated by ASHRAF  M K on 16/07/2019 at 03:17 PM");
INSERT INTO crm_audit_log VALUES("8223","3","15","2019-07-16 15:18:58","Exit Invoice [Invoice No: 121107] updated by Abdul Rasheed on 16/07/2019 at 03:18 PM");
INSERT INTO crm_audit_log VALUES("8224","3","15","2019-07-16 15:44:23","Exit Invoice [Invoice No: 121108] updated by Abdul Rasheed on 16/07/2019 at 03:44 PM");
INSERT INTO crm_audit_log VALUES("8225","3","4","2019-07-16 17:21:06","Exit Invoice [Invoice No: 121109] updated by Yasir  Rahman on 16/07/2019 at 05:21 PM");
INSERT INTO crm_audit_log VALUES("8226","3","4","2019-07-16 18:02:40","Exit Invoice [Invoice No: 121110] updated by Yasir  Rahman on 16/07/2019 at 06:02 PM");
INSERT INTO crm_audit_log VALUES("8227","3","6","2019-07-16 18:07:56","Exit Invoice [Invoice No: 121109] updated by ASHRAF  M K on 16/07/2019 at 06:07 PM");
INSERT INTO crm_audit_log VALUES("8228","3","4","2019-07-16 18:17:12","Exit Invoice [Invoice No: 121111] updated by Yasir  Rahman on 16/07/2019 at 06:17 PM");
INSERT INTO crm_audit_log VALUES("8229","2","11","2019-07-16 18:44:14","Entry Invoice [Invoice No: 22341] updated by GAREEB GAREEB on 16/07/2019 at 06:44 PM");
INSERT INTO crm_audit_log VALUES("8230","3","4","2019-07-16 18:54:46","Exit Invoice [Invoice No: 121112] updated by Yasir  Rahman on 16/07/2019 at 06:54 PM");
INSERT INTO crm_audit_log VALUES("8231","3","4","2019-07-16 19:23:25","Exit Invoice [Invoice No: 121113] updated by Yasir  Rahman on 16/07/2019 at 07:23 PM");
INSERT INTO crm_audit_log VALUES("8232","3","4","2019-07-16 21:30:22","Exit Invoice [Invoice No: 121114] updated by Yasir  Rahman on 16/07/2019 at 09:30 PM");
INSERT INTO crm_audit_log VALUES("8233","3","4","2019-07-16 21:46:24","Exit Invoice [Invoice No: 121115] updated by Yasir  Rahman on 16/07/2019 at 09:46 PM");
INSERT INTO crm_audit_log VALUES("8234","2","4","2019-07-16 21:50:06","Entry Invoice [Invoice No: 22342] updated by Yasir  Rahman on 16/07/2019 at 09:50 PM");
INSERT INTO crm_audit_log VALUES("8235","3","4","2019-07-16 22:47:36","Exit Invoice [Invoice No: 121116] updated by Yasir  Rahman on 16/07/2019 at 10:47 PM");
INSERT INTO crm_audit_log VALUES("8236","2","4","2019-07-17 00:49:52","Entry Invoice [Invoice No: 22343] updated by Yasir  Rahman on 17/07/2019 at 12:49 AM");
INSERT INTO crm_audit_log VALUES("8237","3","5","2019-07-17 01:05:01","Exit Invoice [Invoice No: 121117] updated by Imran  Khan on 17/07/2019 at 01:05 AM");
INSERT INTO crm_audit_log VALUES("8238","3","4","2019-07-17 05:33:12","Exit Invoice [Invoice No: 121118] updated by Yasir  Rahman on 17/07/2019 at 05:33 AM");
INSERT INTO crm_audit_log VALUES("8239","3","4","2019-07-17 05:54:17","Exit Invoice [Invoice No: 121119] updated by Yasir  Rahman on 17/07/2019 at 05:54 AM");
INSERT INTO crm_audit_log VALUES("8240","3","15","2019-07-17 09:23:42","Exit Invoice [Invoice No: 121120] updated by Abdul Rasheed on 17/07/2019 at 09:23 AM");
INSERT INTO crm_audit_log VALUES("8241","3","15","2019-07-17 09:32:12","Exit Invoice [Invoice No: 121121] updated by Abdul Rasheed on 17/07/2019 at 09:32 AM");
INSERT INTO crm_audit_log VALUES("8242","2","11","2019-07-17 11:16:04","Entry Invoice [Invoice No: 22344] updated by GAREEB GAREEB on 17/07/2019 at 11:16 AM");
INSERT INTO crm_audit_log VALUES("8243","3","15","2019-07-17 12:11:41","Exit Invoice [Invoice No: 121122] updated by Abdul Rasheed on 17/07/2019 at 12:11 PM");
INSERT INTO crm_audit_log VALUES("8244","2","11","2019-07-17 12:20:23","Entry Invoice [Invoice No: 22345] updated by GAREEB GAREEB on 17/07/2019 at 12:20 PM");
INSERT INTO crm_audit_log VALUES("8245","3","15","2019-07-17 13:17:08","Exit Invoice [Invoice No: 121123] updated by Abdul Rasheed on 17/07/2019 at 01:17 PM");
INSERT INTO crm_audit_log VALUES("8246","3","15","2019-07-17 13:33:42","Exit Invoice [Invoice No: 121124] updated by Abdul Rasheed on 17/07/2019 at 01:33 PM");
INSERT INTO crm_audit_log VALUES("8247","3","15","2019-07-17 13:39:38","Exit Invoice [Invoice No: 121125] updated by Abdul Rasheed on 17/07/2019 at 01:39 PM");
INSERT INTO crm_audit_log VALUES("8248","2","11","2019-07-17 14:10:55","Entry Invoice [Invoice No: 22346] updated by GAREEB GAREEB on 17/07/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("8249","3","15","2019-07-17 14:23:56","Exit Invoice [Invoice No: 121126] updated by Abdul Rasheed on 17/07/2019 at 02:23 PM");
INSERT INTO crm_audit_log VALUES("8250","3","15","2019-07-17 14:29:45","Exit Invoice [Invoice No: 121127] updated by Abdul Rasheed on 17/07/2019 at 02:29 PM");
INSERT INTO crm_audit_log VALUES("8251","2","11","2019-07-17 15:27:21","Entry Invoice [Invoice No: 22347] updated by GAREEB GAREEB on 17/07/2019 at 03:27 PM");
INSERT INTO crm_audit_log VALUES("8252","2","11","2019-07-17 16:56:33","Entry Invoice [Invoice No: 22348] updated by GAREEB GAREEB on 17/07/2019 at 04:56 PM");
INSERT INTO crm_audit_log VALUES("8253","3","4","2019-07-17 17:07:28","Exit Invoice [Invoice No: 121128] updated by Yasir  Rahman on 17/07/2019 at 05:07 PM");
INSERT INTO crm_audit_log VALUES("8254","2","11","2019-07-17 17:13:20","Entry Invoice [Invoice No: 22349] updated by GAREEB GAREEB on 17/07/2019 at 05:13 PM");
INSERT INTO crm_audit_log VALUES("8255","3","4","2019-07-17 18:31:23","Exit Invoice [Invoice No: 121129] updated by Yasir  Rahman on 17/07/2019 at 06:31 PM");
INSERT INTO crm_audit_log VALUES("8256","3","4","2019-07-17 20:47:43","Exit Invoice [Invoice No: 121130] updated by Yasir  Rahman on 17/07/2019 at 08:47 PM");
INSERT INTO crm_audit_log VALUES("8257","3","4","2019-07-17 20:50:07","Exit Invoice [Invoice No: 121131] updated by Yasir  Rahman on 17/07/2019 at 08:50 PM");
INSERT INTO crm_audit_log VALUES("8258","2","4","2019-07-17 22:22:22","Entry Invoice [Invoice No: 22350] updated by Yasir  Rahman on 17/07/2019 at 10:22 PM");
INSERT INTO crm_audit_log VALUES("8259","2","4","2019-07-17 22:24:11","Entry Invoice [Invoice No: 22351] updated by Yasir  Rahman on 17/07/2019 at 10:24 PM");
INSERT INTO crm_audit_log VALUES("8260","2","4","2019-07-17 22:26:12","Entry Invoice [Invoice No: 22352] updated by Yasir  Rahman on 17/07/2019 at 10:26 PM");
INSERT INTO crm_audit_log VALUES("8261","3","4","2019-07-17 23:31:29","Exit Invoice [Invoice No: 121132] updated by Yasir  Rahman on 17/07/2019 at 11:31 PM");
INSERT INTO crm_audit_log VALUES("8262","3","4","2019-07-17 23:32:16","Exit Invoice [Invoice No: 121133] updated by Yasir  Rahman on 17/07/2019 at 11:32 PM");
INSERT INTO crm_audit_log VALUES("8263","3","4","2019-07-17 23:34:07","Exit Invoice [Invoice No: 121134] updated by Yasir  Rahman on 17/07/2019 at 11:34 PM");
INSERT INTO crm_audit_log VALUES("8264","3","4","2019-07-17 23:35:44","Exit Invoice [Invoice No: 121135] updated by Yasir  Rahman on 17/07/2019 at 11:35 PM");
INSERT INTO crm_audit_log VALUES("8265","3","4","2019-07-17 23:38:10","Exit Invoice [Invoice No: 121136] updated by Yasir  Rahman on 17/07/2019 at 11:38 PM");
INSERT INTO crm_audit_log VALUES("8266","3","4","2019-07-18 00:22:01","Exit Invoice [Invoice No: 121137] updated by Yasir  Rahman on 18/07/2019 at 12:22 AM");
INSERT INTO crm_audit_log VALUES("8267","3","4","2019-07-18 00:39:28","Exit Invoice [Invoice No: 121138] updated by Yasir  Rahman on 18/07/2019 at 12:39 AM");
INSERT INTO crm_audit_log VALUES("8268","2","4","2019-07-18 01:10:01","Entry Invoice [Invoice No: 22353] updated by Yasir  Rahman on 18/07/2019 at 01:10 AM");
INSERT INTO crm_audit_log VALUES("8269","2","4","2019-07-18 01:12:32","Entry Invoice [Invoice No: 22354] updated by Yasir  Rahman on 18/07/2019 at 01:12 AM");
INSERT INTO crm_audit_log VALUES("8270","3","5","2019-07-18 03:05:05","Exit Invoice [Invoice No: 121139] updated by Imran  Khan on 18/07/2019 at 03:05 AM");
INSERT INTO crm_audit_log VALUES("8271","3","5","2019-07-18 03:10:34","Exit Invoice [Invoice No: 121140] updated by Imran  Khan on 18/07/2019 at 03:10 AM");
INSERT INTO crm_audit_log VALUES("8272","3","5","2019-07-18 03:24:08","Exit Invoice [Invoice No: 121141] updated by Imran  Khan on 18/07/2019 at 03:24 AM");
INSERT INTO crm_audit_log VALUES("8273","3","5","2019-07-18 07:09:51","Exit Invoice [Invoice No: 121142] updated by Imran  Khan on 18/07/2019 at 07:09 AM");
INSERT INTO crm_audit_log VALUES("8274","3","5","2019-07-18 07:12:57","Exit Invoice [Invoice No: 121143] updated by Imran  Khan on 18/07/2019 at 07:12 AM");
INSERT INTO crm_audit_log VALUES("8275","3","15","2019-07-18 08:46:45","Exit Invoice [Invoice No: 121144] updated by Abdul Rasheed on 18/07/2019 at 08:46 AM");
INSERT INTO crm_audit_log VALUES("8276","3","15","2019-07-18 08:59:10","Exit Invoice [Invoice No: 121145] updated by Abdul Rasheed on 18/07/2019 at 08:59 AM");
INSERT INTO crm_audit_log VALUES("8277","3","6","2019-07-18 09:01:11","Exit Invoice [Invoice No: 121145] updated by ASHRAF  M K on 18/07/2019 at 09:01 AM");
INSERT INTO crm_audit_log VALUES("8278","3","15","2019-07-18 10:24:20","Exit Invoice [Invoice No: 121146] updated by Abdul Rasheed on 18/07/2019 at 10:24 AM");
INSERT INTO crm_audit_log VALUES("8279","3","15","2019-07-18 10:42:55","Exit Invoice [Invoice No: 121147] updated by Abdul Rasheed on 18/07/2019 at 10:42 AM");
INSERT INTO crm_audit_log VALUES("8280","3","15","2019-07-18 10:53:09","Exit Invoice [Invoice No: 121148] updated by Abdul Rasheed on 18/07/2019 at 10:53 AM");
INSERT INTO crm_audit_log VALUES("8281","2","11","2019-07-18 10:54:35","Entry Invoice [Invoice No: 22355] updated by GAREEB GAREEB on 18/07/2019 at 10:54 AM");
INSERT INTO crm_audit_log VALUES("8282","3","15","2019-07-18 11:30:28","Exit Invoice [Invoice No: 121149] updated by Abdul Rasheed on 18/07/2019 at 11:30 AM");
INSERT INTO crm_audit_log VALUES("8283","3","15","2019-07-18 11:36:04","Exit Invoice [Invoice No: 121150] updated by Abdul Rasheed on 18/07/2019 at 11:36 AM");
INSERT INTO crm_audit_log VALUES("8284","3","15","2019-07-18 11:46:44","Exit Invoice [Invoice No: 121151] updated by Abdul Rasheed on 18/07/2019 at 11:46 AM");
INSERT INTO crm_audit_log VALUES("8285","2","11","2019-07-18 11:53:58","Entry Invoice [Invoice No: 22356] updated by GAREEB GAREEB on 18/07/2019 at 11:53 AM");
INSERT INTO crm_audit_log VALUES("8286","3","15","2019-07-18 14:02:49","Exit Invoice [Invoice No: 121152] updated by Abdul Rasheed on 18/07/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("8287","3","6","2019-07-18 14:10:00","Exit Invoice [Invoice No: 121147] updated by ASHRAF  M K on 18/07/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("8288","2","11","2019-07-18 14:40:59","Entry Invoice [Invoice No: 22357] updated by GAREEB GAREEB on 18/07/2019 at 02:40 PM");
INSERT INTO crm_audit_log VALUES("8289","2","11","2019-07-18 14:42:40","Entry Invoice [Invoice No: 22358] updated by GAREEB GAREEB on 18/07/2019 at 02:42 PM");
INSERT INTO crm_audit_log VALUES("8290","2","11","2019-07-18 14:44:14","Entry Invoice [Invoice No: 22359] updated by GAREEB GAREEB on 18/07/2019 at 02:44 PM");
INSERT INTO crm_audit_log VALUES("8291","3","15","2019-07-18 15:07:25","Exit Invoice [Invoice No: 121153] updated by Abdul Rasheed on 18/07/2019 at 03:07 PM");
INSERT INTO crm_audit_log VALUES("8292","3","15","2019-07-18 15:08:25","Exit Invoice [Invoice No: 121154] updated by Abdul Rasheed on 18/07/2019 at 03:08 PM");
INSERT INTO crm_audit_log VALUES("8293","2","11","2019-07-18 16:49:54","Entry Invoice [Invoice No: 22360] updated by GAREEB GAREEB on 18/07/2019 at 04:49 PM");
INSERT INTO crm_audit_log VALUES("8294","2","11","2019-07-18 16:51:06","Entry Invoice [Invoice No: 22361] updated by GAREEB GAREEB on 18/07/2019 at 04:51 PM");
INSERT INTO crm_audit_log VALUES("8295","3","4","2019-07-18 20:46:43","Exit Invoice [Invoice No: 121155] updated by Yasir  Rahman on 18/07/2019 at 08:46 PM");
INSERT INTO crm_audit_log VALUES("8296","3","4","2019-07-18 21:34:07","Exit Invoice [Invoice No: 121156] updated by Yasir  Rahman on 18/07/2019 at 09:34 PM");
INSERT INTO crm_audit_log VALUES("8297","2","4","2019-07-18 21:52:25","Entry Invoice [Invoice No: 22362] updated by Yasir  Rahman on 18/07/2019 at 09:52 PM");
INSERT INTO crm_audit_log VALUES("8298","3","4","2019-07-18 23:13:05","Exit Invoice [Invoice No: 121157] updated by Yasir  Rahman on 18/07/2019 at 11:13 PM");
INSERT INTO crm_audit_log VALUES("8299","3","4","2019-07-18 23:17:57","Exit Invoice [Invoice No: 121158] updated by Yasir  Rahman on 18/07/2019 at 11:17 PM");
INSERT INTO crm_audit_log VALUES("8300","3","4","2019-07-18 23:19:51","Exit Invoice [Invoice No: 121159] updated by Yasir  Rahman on 18/07/2019 at 11:19 PM");
INSERT INTO crm_audit_log VALUES("8301","2","4","2019-07-19 00:07:16","Entry Invoice [Invoice No: 22363] updated by Yasir  Rahman on 19/07/2019 at 12:07 AM");
INSERT INTO crm_audit_log VALUES("8302","3","5","2019-07-19 00:20:32","Exit Invoice [Invoice No: 121160] updated by Imran  Khan on 19/07/2019 at 12:20 AM");
INSERT INTO crm_audit_log VALUES("8303","3","5","2019-07-19 00:21:28","Exit Invoice [Invoice No: 121161] updated by Imran  Khan on 19/07/2019 at 12:21 AM");
INSERT INTO crm_audit_log VALUES("8304","3","5","2019-07-19 00:59:24","Exit Invoice [Invoice No: 121162] updated by Imran  Khan on 19/07/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("8305","3","5","2019-07-19 01:15:52","Exit Invoice [Invoice No: 121163] updated by Imran  Khan on 19/07/2019 at 01:15 AM");
INSERT INTO crm_audit_log VALUES("8306","2","4","2019-07-19 01:50:10","Entry Invoice [Invoice No: 22364] updated by Yasir  Rahman on 19/07/2019 at 01:50 AM");
INSERT INTO crm_audit_log VALUES("8307","3","5","2019-07-19 03:46:03","Exit Invoice [Invoice No: 121164] updated by Imran  Khan on 19/07/2019 at 03:46 AM");
INSERT INTO crm_audit_log VALUES("8308","3","5","2019-07-19 07:29:48","Exit Invoice [Invoice No: 121165] updated by Imran  Khan on 19/07/2019 at 07:29 AM");
INSERT INTO crm_audit_log VALUES("8309","2","4","2019-07-19 07:33:15","Entry Invoice [Invoice No: 22365] updated by Yasir  Rahman on 19/07/2019 at 07:33 AM");
INSERT INTO crm_audit_log VALUES("8310","2","11","2019-07-19 09:42:22","Entry Invoice [Invoice No: 22366] updated by GAREEB GAREEB on 19/07/2019 at 09:42 AM");
INSERT INTO crm_audit_log VALUES("8311","3","15","2019-07-19 09:44:57","Exit Invoice [Invoice No: 121166] updated by Abdul Rasheed on 19/07/2019 at 09:44 AM");
INSERT INTO crm_audit_log VALUES("8312","2","6","2019-07-19 10:26:14","Entry Invoice [Invoice No: 22367] updated by ASHRAF  M K on 19/07/2019 at 10:26 AM");
INSERT INTO crm_audit_log VALUES("8313","2","6","2019-07-19 10:45:40","Entry Invoice [Invoice No: 22368] updated by ASHRAF  M K on 19/07/2019 at 10:45 AM");
INSERT INTO crm_audit_log VALUES("8314","2","11","2019-07-19 11:11:20","Entry Invoice [Invoice No: 22369] updated by GAREEB GAREEB on 19/07/2019 at 11:11 AM");
INSERT INTO crm_audit_log VALUES("8315","3","15","2019-07-19 11:46:28","Exit Invoice [Invoice No: 121167] updated by Abdul Rasheed on 19/07/2019 at 11:46 AM");
INSERT INTO crm_audit_log VALUES("8316","3","15","2019-07-19 13:33:53","Exit Invoice [Invoice No: 121168] updated by Abdul Rasheed on 19/07/2019 at 01:33 PM");
INSERT INTO crm_audit_log VALUES("8317","3","15","2019-07-19 13:56:57","Exit Invoice [Invoice No: 121169] updated by Abdul Rasheed on 19/07/2019 at 01:56 PM");
INSERT INTO crm_audit_log VALUES("8318","3","15","2019-07-19 14:39:43","Exit Invoice [Invoice No: 121170] updated by Abdul Rasheed on 19/07/2019 at 02:39 PM");
INSERT INTO crm_audit_log VALUES("8319","3","6","2019-07-19 15:01:41","Exit Invoice [Invoice No: 121166] updated by ASHRAF  M K on 19/07/2019 at 03:01 PM");
INSERT INTO crm_audit_log VALUES("8320","3","4","2019-07-19 16:36:01","Exit Invoice [Invoice No: 121171] updated by Yasir  Rahman on 19/07/2019 at 04:36 PM");
INSERT INTO crm_audit_log VALUES("8321","3","4","2019-07-19 16:39:29","Exit Invoice [Invoice No: 121172] updated by Yasir  Rahman on 19/07/2019 at 04:39 PM");
INSERT INTO crm_audit_log VALUES("8322","3","4","2019-07-19 16:41:06","Exit Invoice [Invoice No: 121173] updated by Yasir  Rahman on 19/07/2019 at 04:41 PM");
INSERT INTO crm_audit_log VALUES("8323","3","4","2019-07-19 16:42:25","Exit Invoice [Invoice No: 121174] updated by Yasir  Rahman on 19/07/2019 at 04:42 PM");
INSERT INTO crm_audit_log VALUES("8324","3","4","2019-07-19 17:17:48","Exit Invoice [Invoice No: 121175] updated by Yasir  Rahman on 19/07/2019 at 05:17 PM");
INSERT INTO crm_audit_log VALUES("8325","3","4","2019-07-19 17:22:00","Exit Invoice [Invoice No: 121176] updated by Yasir  Rahman on 19/07/2019 at 05:22 PM");
INSERT INTO crm_audit_log VALUES("8326","3","4","2019-07-19 17:23:26","Exit Invoice [Invoice No: 121177] updated by Yasir  Rahman on 19/07/2019 at 05:23 PM");
INSERT INTO crm_audit_log VALUES("8327","3","4","2019-07-19 17:36:18","Exit Invoice [Invoice No: 121178] updated by Yasir  Rahman on 19/07/2019 at 05:36 PM");
INSERT INTO crm_audit_log VALUES("8328","2","11","2019-07-19 19:09:01","Entry Invoice [Invoice No: 22370] updated by GAREEB GAREEB on 19/07/2019 at 07:09 PM");
INSERT INTO crm_audit_log VALUES("8329","3","4","2019-07-19 20:21:46","Exit Invoice [Invoice No: 121179] updated by Yasir  Rahman on 19/07/2019 at 08:21 PM");
INSERT INTO crm_audit_log VALUES("8330","3","4","2019-07-19 21:01:17","Exit Invoice [Invoice No: 121180] updated by Yasir  Rahman on 19/07/2019 at 09:01 PM");
INSERT INTO crm_audit_log VALUES("8331","3","4","2019-07-19 21:47:55","Exit Invoice [Invoice No: 121181] updated by Yasir  Rahman on 19/07/2019 at 09:47 PM");
INSERT INTO crm_audit_log VALUES("8332","3","4","2019-07-19 21:51:39","Exit Invoice [Invoice No: 121182] updated by Yasir  Rahman on 19/07/2019 at 09:51 PM");
INSERT INTO crm_audit_log VALUES("8333","3","4","2019-07-19 23:09:57","Exit Invoice [Invoice No: 121183] updated by Yasir  Rahman on 19/07/2019 at 11:09 PM");
INSERT INTO crm_audit_log VALUES("8334","3","4","2019-07-19 23:47:53","Exit Invoice [Invoice No: 121184] updated by Yasir  Rahman on 19/07/2019 at 11:47 PM");
INSERT INTO crm_audit_log VALUES("8335","3","5","2019-07-20 01:05:38","Exit Invoice [Invoice No: 121185] updated by Imran  Khan on 20/07/2019 at 01:05 AM");
INSERT INTO crm_audit_log VALUES("8336","3","5","2019-07-20 01:09:38","Exit Invoice [Invoice No: 121186] updated by Imran  Khan on 20/07/2019 at 01:09 AM");
INSERT INTO crm_audit_log VALUES("8337","3","15","2019-07-20 09:36:05","Exit Invoice [Invoice No: 121187] updated by Abdul Rasheed on 20/07/2019 at 09:36 AM");
INSERT INTO crm_audit_log VALUES("8338","2","11","2019-07-20 10:16:46","Entry Invoice [Invoice No: 22371] updated by GAREEB GAREEB on 20/07/2019 at 10:16 AM");
INSERT INTO crm_audit_log VALUES("8339","2","11","2019-07-20 10:18:08","Entry Invoice [Invoice No: 22372] updated by GAREEB GAREEB on 20/07/2019 at 10:18 AM");
INSERT INTO crm_audit_log VALUES("8340","2","11","2019-07-20 10:19:22","Entry Invoice [Invoice No: 22373] updated by GAREEB GAREEB on 20/07/2019 at 10:19 AM");
INSERT INTO crm_audit_log VALUES("8341","2","11","2019-07-20 10:20:34","Entry Invoice [Invoice No: 22374] updated by GAREEB GAREEB on 20/07/2019 at 10:20 AM");
INSERT INTO crm_audit_log VALUES("8342","3","15","2019-07-20 10:50:20","Exit Invoice [Invoice No: 121188] updated by Abdul Rasheed on 20/07/2019 at 10:50 AM");
INSERT INTO crm_audit_log VALUES("8343","3","15","2019-07-20 11:20:38","Exit Invoice [Invoice No: 121189] updated by Abdul Rasheed on 20/07/2019 at 11:20 AM");
INSERT INTO crm_audit_log VALUES("8344","3","15","2019-07-20 11:52:11","Exit Invoice [Invoice No: 121190] updated by Abdul Rasheed on 20/07/2019 at 11:52 AM");
INSERT INTO crm_audit_log VALUES("8345","3","4","2019-07-20 16:42:12","Exit Invoice [Invoice No: 121191] updated by Yasir  Rahman on 20/07/2019 at 04:42 PM");
INSERT INTO crm_audit_log VALUES("8346","2","11","2019-07-20 17:03:40","Entry Invoice [Invoice No: 22375] updated by GAREEB GAREEB on 20/07/2019 at 05:03 PM");
INSERT INTO crm_audit_log VALUES("8347","2","11","2019-07-20 19:05:34","Entry Invoice [Invoice No: 22376] updated by GAREEB GAREEB on 20/07/2019 at 07:05 PM");
INSERT INTO crm_audit_log VALUES("8348","2","4","2019-07-20 20:57:08","Entry Invoice [Invoice No: 22377] updated by Yasir  Rahman on 20/07/2019 at 08:57 PM");
INSERT INTO crm_audit_log VALUES("8349","3","4","2019-07-21 01:03:50","Exit Invoice [Invoice No: 121192] updated by Yasir  Rahman on 21/07/2019 at 01:03 AM");
INSERT INTO crm_audit_log VALUES("8350","3","4","2019-07-21 01:04:58","Exit Invoice [Invoice No: 121193] updated by Yasir  Rahman on 21/07/2019 at 01:04 AM");
INSERT INTO crm_audit_log VALUES("8351","3","4","2019-07-21 01:21:43","Exit Invoice [Invoice No: 121194] updated by Yasir  Rahman on 21/07/2019 at 01:21 AM");
INSERT INTO crm_audit_log VALUES("8352","1","4","2019-07-21 02:39:21","Customer [Customer No: 461] updated by Yasir  Rahman on 21/07/2019 at 02:39 AM");
INSERT INTO crm_audit_log VALUES("8353","3","4","2019-07-21 02:41:11","Exit Invoice [Invoice No: 121195] updated by Yasir  Rahman on 21/07/2019 at 02:41 AM");
INSERT INTO crm_audit_log VALUES("8354","3","15","2019-07-21 09:07:23","Exit Invoice [Invoice No: 121196] updated by Abdul Rasheed on 21/07/2019 at 09:07 AM");
INSERT INTO crm_audit_log VALUES("8355","3","15","2019-07-21 09:16:06","Exit Invoice [Invoice No: 121197] updated by Abdul Rasheed on 21/07/2019 at 09:16 AM");
INSERT INTO crm_audit_log VALUES("8356","3","6","2019-07-21 09:17:19","Exit Invoice [Invoice No: 121196] updated by ASHRAF  M K on 21/07/2019 at 09:17 AM");
INSERT INTO crm_audit_log VALUES("8357","3","15","2019-07-21 09:25:45","Exit Invoice [Invoice No: 121198] updated by Abdul Rasheed on 21/07/2019 at 09:25 AM");
INSERT INTO crm_audit_log VALUES("8358","3","15","2019-07-21 10:36:34","Exit Invoice [Invoice No: 121199] updated by Abdul Rasheed on 21/07/2019 at 10:36 AM");
INSERT INTO crm_audit_log VALUES("8359","3","15","2019-07-21 10:44:18","Exit Invoice [Invoice No: 121200] updated by Abdul Rasheed on 21/07/2019 at 10:44 AM");
INSERT INTO crm_audit_log VALUES("8360","3","15","2019-07-21 10:56:22","Exit Invoice [Invoice No: 121201] updated by Abdul Rasheed on 21/07/2019 at 10:56 AM");
INSERT INTO crm_audit_log VALUES("8361","3","15","2019-07-21 11:40:35","Exit Invoice [Invoice No: 121202] updated by Abdul Rasheed on 21/07/2019 at 11:40 AM");
INSERT INTO crm_audit_log VALUES("8362","3","15","2019-07-21 12:01:15","Exit Invoice [Invoice No: 121203] updated by Abdul Rasheed on 21/07/2019 at 12:01 PM");
INSERT INTO crm_audit_log VALUES("8363","2","6","2019-07-21 12:06:49","Entry Invoice [Invoice No: 22378] updated by ASHRAF  M K on 21/07/2019 at 12:06 PM");
INSERT INTO crm_audit_log VALUES("8364","2","11","2019-07-21 12:56:29","Entry Invoice [Invoice No: 22379] updated by GAREEB GAREEB on 21/07/2019 at 12:56 PM");
INSERT INTO crm_audit_log VALUES("8365","2","11","2019-07-21 13:12:49","Entry Invoice [Invoice No: 22380] updated by GAREEB GAREEB on 21/07/2019 at 01:12 PM");
INSERT INTO crm_audit_log VALUES("8366","2","11","2019-07-21 13:57:20","Entry Invoice [Invoice No: 22381] updated by GAREEB GAREEB on 21/07/2019 at 01:57 PM");
INSERT INTO crm_audit_log VALUES("8367","2","11","2019-07-21 13:58:31","Entry Invoice [Invoice No: 22382] updated by GAREEB GAREEB on 21/07/2019 at 01:58 PM");
INSERT INTO crm_audit_log VALUES("8368","2","11","2019-07-21 14:05:23","Entry Invoice [Invoice No: 22383] updated by GAREEB GAREEB on 21/07/2019 at 02:05 PM");
INSERT INTO crm_audit_log VALUES("8369","3","15","2019-07-21 14:20:07","Exit Invoice [Invoice No: 121204] updated by Abdul Rasheed on 21/07/2019 at 02:20 PM");
INSERT INTO crm_audit_log VALUES("8370","2","11","2019-07-21 17:27:17","Entry Invoice [Invoice No: 22384] updated by GAREEB GAREEB on 21/07/2019 at 05:27 PM");
INSERT INTO crm_audit_log VALUES("8371","2","11","2019-07-21 17:28:38","Entry Invoice [Invoice No: 22385] updated by GAREEB GAREEB on 21/07/2019 at 05:28 PM");
INSERT INTO crm_audit_log VALUES("8372","2","11","2019-07-21 18:33:31","Entry Invoice [Invoice No: 22386] updated by GAREEB GAREEB on 21/07/2019 at 06:33 PM");
INSERT INTO crm_audit_log VALUES("8373","3","4","2019-07-21 18:37:52","Exit Invoice [Invoice No: 121205] updated by Yasir  Rahman on 21/07/2019 at 06:37 PM");
INSERT INTO crm_audit_log VALUES("8374","3","4","2019-07-21 18:50:48","Exit Invoice [Invoice No: 121206] updated by Yasir  Rahman on 21/07/2019 at 06:50 PM");
INSERT INTO crm_audit_log VALUES("8375","3","4","2019-07-21 19:11:48","Exit Invoice [Invoice No: 121207] updated by Yasir  Rahman on 21/07/2019 at 07:11 PM");
INSERT INTO crm_audit_log VALUES("8376","3","4","2019-07-21 19:43:08","Exit Invoice [Invoice No: 121208] updated by Yasir  Rahman on 21/07/2019 at 07:43 PM");
INSERT INTO crm_audit_log VALUES("8377","3","4","2019-07-21 20:57:51","Exit Invoice [Invoice No: 121209] updated by Yasir  Rahman on 21/07/2019 at 08:57 PM");
INSERT INTO crm_audit_log VALUES("8378","3","4","2019-07-21 22:05:55","Exit Invoice [Invoice No: 121210] updated by Yasir  Rahman on 21/07/2019 at 10:05 PM");
INSERT INTO crm_audit_log VALUES("8379","3","4","2019-07-21 22:41:41","Exit Invoice [Invoice No: 121211] updated by Yasir  Rahman on 21/07/2019 at 10:41 PM");
INSERT INTO crm_audit_log VALUES("8380","3","5","2019-07-22 00:45:04","Exit Invoice [Invoice No: 121212] updated by Imran  Khan on 22/07/2019 at 12:45 AM");
INSERT INTO crm_audit_log VALUES("8381","3","5","2019-07-22 02:03:11","Exit Invoice [Invoice No: 121213] updated by Imran  Khan on 22/07/2019 at 02:03 AM");
INSERT INTO crm_audit_log VALUES("8382","3","5","2019-07-22 02:38:16","Exit Invoice [Invoice No: 121214] updated by Imran  Khan on 22/07/2019 at 02:38 AM");
INSERT INTO crm_audit_log VALUES("8383","3","5","2019-07-22 07:06:33","Exit Invoice [Invoice No: 121215] updated by Imran  Khan on 22/07/2019 at 07:06 AM");
INSERT INTO crm_audit_log VALUES("8384","3","5","2019-07-22 07:07:45","Exit Invoice [Invoice No: 121216] updated by Imran  Khan on 22/07/2019 at 07:07 AM");
INSERT INTO crm_audit_log VALUES("8385","3","4","2019-07-22 09:11:26","Exit Invoice [Invoice No: 121217] updated by Yasir  Rahman on 22/07/2019 at 09:11 AM");
INSERT INTO crm_audit_log VALUES("8386","3","4","2019-07-22 09:55:59","Exit Invoice [Invoice No: 121218] updated by Yasir  Rahman on 22/07/2019 at 09:55 AM");
INSERT INTO crm_audit_log VALUES("8387","3","4","2019-07-22 10:55:37","Exit Invoice [Invoice No: 121219] updated by Yasir  Rahman on 22/07/2019 at 10:55 AM");
INSERT INTO crm_audit_log VALUES("8388","3","4","2019-07-22 11:02:24","Exit Invoice [Invoice No: 121220] updated by Yasir  Rahman on 22/07/2019 at 11:02 AM");
INSERT INTO crm_audit_log VALUES("8389","3","4","2019-07-22 11:07:19","Exit Invoice [Invoice No: 121221] updated by Yasir  Rahman on 22/07/2019 at 11:07 AM");
INSERT INTO crm_audit_log VALUES("8390","2","11","2019-07-22 11:32:18","Entry Invoice [Invoice No: 22387] updated by GAREEB GAREEB on 22/07/2019 at 11:32 AM");
INSERT INTO crm_audit_log VALUES("8391","3","4","2019-07-22 11:33:05","Exit Invoice [Invoice No: 121222] updated by Yasir  Rahman on 22/07/2019 at 11:33 AM");
INSERT INTO crm_audit_log VALUES("8392","2","11","2019-07-22 11:33:45","Entry Invoice [Invoice No: 22388] updated by GAREEB GAREEB on 22/07/2019 at 11:33 AM");
INSERT INTO crm_audit_log VALUES("8393","3","4","2019-07-22 12:28:45","Exit Invoice [Invoice No: 121223] updated by Yasir  Rahman on 22/07/2019 at 12:28 PM");
INSERT INTO crm_audit_log VALUES("8394","2","11","2019-07-22 12:33:28","Entry Invoice [Invoice No: 22389] updated by GAREEB GAREEB on 22/07/2019 at 12:33 PM");
INSERT INTO crm_audit_log VALUES("8395","3","4","2019-07-22 12:46:28","Exit Invoice [Invoice No: 121224] updated by Yasir  Rahman on 22/07/2019 at 12:46 PM");
INSERT INTO crm_audit_log VALUES("8396","3","4","2019-07-22 13:08:43","Exit Invoice [Invoice No: 121225] updated by Yasir  Rahman on 22/07/2019 at 01:08 PM");
INSERT INTO crm_audit_log VALUES("8397","3","4","2019-07-22 14:58:07","Exit Invoice [Invoice No: 121226] updated by Yasir  Rahman on 22/07/2019 at 02:58 PM");
INSERT INTO crm_audit_log VALUES("8398","3","4","2019-07-22 15:21:22","Exit Invoice [Invoice No: 121227] updated by Yasir  Rahman on 22/07/2019 at 03:21 PM");
INSERT INTO crm_audit_log VALUES("8399","3","4","2019-07-22 15:29:29","Exit Invoice [Invoice No: 121228] updated by Yasir  Rahman on 22/07/2019 at 03:29 PM");
INSERT INTO crm_audit_log VALUES("8400","3","4","2019-07-22 15:41:09","Exit Invoice [Invoice No: 121229] updated by Yasir  Rahman on 22/07/2019 at 03:41 PM");
INSERT INTO crm_audit_log VALUES("8401","2","6","2019-07-22 15:52:30","Entry Invoice [Invoice No: 22390] updated by ASHRAF  M K on 22/07/2019 at 03:52 PM");
INSERT INTO crm_audit_log VALUES("8402","2","11","2019-07-22 18:22:47","Entry Invoice [Invoice No: 22391] updated by GAREEB GAREEB on 22/07/2019 at 06:22 PM");
INSERT INTO crm_audit_log VALUES("8403","2","11","2019-07-22 19:10:03","Entry Invoice [Invoice No: 22392] updated by GAREEB GAREEB on 22/07/2019 at 07:10 PM");
INSERT INTO crm_audit_log VALUES("8404","2","4","2019-07-22 20:26:50","Entry Invoice [Invoice No: 22393] updated by Yasir  Rahman on 22/07/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("8405","3","4","2019-07-22 22:04:59","Exit Invoice [Invoice No: 121230] updated by Yasir  Rahman on 22/07/2019 at 10:04 PM");
INSERT INTO crm_audit_log VALUES("8406","3","5","2019-07-23 00:59:57","Exit Invoice [Invoice No: 121231] updated by Imran  Khan on 23/07/2019 at 12:59 AM");
INSERT INTO crm_audit_log VALUES("8407","3","5","2019-07-23 01:36:20","Exit Invoice [Invoice No: 121232] updated by Imran  Khan on 23/07/2019 at 01:36 AM");
INSERT INTO crm_audit_log VALUES("8408","3","5","2019-07-23 02:19:50","Exit Invoice [Invoice No: 121233] updated by Imran  Khan on 23/07/2019 at 02:19 AM");
INSERT INTO crm_audit_log VALUES("8409","3","5","2019-07-23 02:20:31","Exit Invoice [Invoice No: 121234] updated by Imran  Khan on 23/07/2019 at 02:20 AM");
INSERT INTO crm_audit_log VALUES("8410","3","5","2019-07-23 02:41:38","Exit Invoice [Invoice No: 121235] updated by Imran  Khan on 23/07/2019 at 02:41 AM");
INSERT INTO crm_audit_log VALUES("8411","3","4","2019-07-23 03:51:58","Exit Invoice [Invoice No: 121236] updated by Yasir  Rahman on 23/07/2019 at 03:51 AM");
INSERT INTO crm_audit_log VALUES("8412","3","5","2019-07-23 05:46:32","Exit Invoice [Invoice No: 121237] updated by Imran  Khan on 23/07/2019 at 05:46 AM");
INSERT INTO crm_audit_log VALUES("8413","3","4","2019-07-23 10:00:25","Exit Invoice [Invoice No: 121238] updated by Yasir  Rahman on 23/07/2019 at 10:00 AM");
INSERT INTO crm_audit_log VALUES("8414","3","4","2019-07-23 10:40:38","Exit Invoice [Invoice No: 121239] updated by Yasir  Rahman on 23/07/2019 at 10:40 AM");
INSERT INTO crm_audit_log VALUES("8415","2","13","2019-07-23 12:18:22","Entry Invoice [Invoice No: 22394] updated by MUHAMMED HASHIM on 23/07/2019 at 12:18 PM");
INSERT INTO crm_audit_log VALUES("8416","2","13","2019-07-23 12:19:58","Entry Invoice [Invoice No: 22395] updated by MUHAMMED HASHIM on 23/07/2019 at 12:19 PM");
INSERT INTO crm_audit_log VALUES("8417","3","4","2019-07-23 13:03:24","Exit Invoice [Invoice No: 121240] updated by Yasir  Rahman on 23/07/2019 at 01:03 PM");
INSERT INTO crm_audit_log VALUES("8418","3","4","2019-07-23 13:05:34","Exit Invoice [Invoice No: 121241] updated by Yasir  Rahman on 23/07/2019 at 01:05 PM");
INSERT INTO crm_audit_log VALUES("8419","3","4","2019-07-23 13:08:56","Exit Invoice [Invoice No: 121242] updated by Yasir  Rahman on 23/07/2019 at 01:08 PM");
INSERT INTO crm_audit_log VALUES("8420","3","4","2019-07-23 13:10:31","Exit Invoice [Invoice No: 121243] updated by Yasir  Rahman on 23/07/2019 at 01:10 PM");
INSERT INTO crm_audit_log VALUES("8421","3","4","2019-07-23 13:59:57","Exit Invoice [Invoice No: 121244] updated by Yasir  Rahman on 23/07/2019 at 01:59 PM");
INSERT INTO crm_audit_log VALUES("8422","3","4","2019-07-23 14:02:21","Exit Invoice [Invoice No: 121245] updated by Yasir  Rahman on 23/07/2019 at 02:02 PM");
INSERT INTO crm_audit_log VALUES("8423","2","11","2019-07-23 14:10:51","Entry Invoice [Invoice No: 22396] updated by GAREEB GAREEB on 23/07/2019 at 02:10 PM");
INSERT INTO crm_audit_log VALUES("8424","2","11","2019-07-23 14:15:17","Entry Invoice [Invoice No: 22397] updated by GAREEB GAREEB on 23/07/2019 at 02:15 PM");
INSERT INTO crm_audit_log VALUES("8425","3","4","2019-07-23 14:15:59","Exit Invoice [Invoice No: 121246] updated by Yasir  Rahman on 23/07/2019 at 02:15 PM");
INSERT INTO crm_audit_log VALUES("8426","3","4","2019-07-23 14:17:16","Exit Invoice [Invoice No: 121247] updated by Yasir  Rahman on 23/07/2019 at 02:17 PM");
INSERT INTO crm_audit_log VALUES("8427","2","11","2019-07-23 14:18:36","Entry Invoice [Invoice No: 22398] updated by GAREEB GAREEB on 23/07/2019 at 02:18 PM");
INSERT INTO crm_audit_log VALUES("8428","2","11","2019-07-23 14:26:43","Entry Invoice [Invoice No: 22399] updated by GAREEB GAREEB on 23/07/2019 at 02:26 PM");
INSERT INTO crm_audit_log VALUES("8429","2","11","2019-07-23 14:31:23","Entry Invoice [Invoice No: 22400] updated by GAREEB GAREEB on 23/07/2019 at 02:31 PM");
INSERT INTO crm_audit_log VALUES("8430","2","11","2019-07-23 14:36:06","Entry Invoice [Invoice No: 22401] updated by GAREEB GAREEB on 23/07/2019 at 02:36 PM");
INSERT INTO crm_audit_log VALUES("8431","2","11","2019-07-23 15:07:48","Entry Invoice [Invoice No: 22402] updated by GAREEB GAREEB on 23/07/2019 at 03:07 PM");
INSERT INTO crm_audit_log VALUES("8432","3","4","2019-07-23 17:07:39","Exit Invoice [Invoice No: 121248] updated by Yasir  Rahman on 23/07/2019 at 05:07 PM");
INSERT INTO crm_audit_log VALUES("8433","3","4","2019-07-23 17:42:56","Exit Invoice [Invoice No: 121249] updated by Yasir  Rahman on 23/07/2019 at 05:42 PM");
INSERT INTO crm_audit_log VALUES("8434","2","4","2019-07-23 20:26:23","Entry Invoice [Invoice No: 22403] updated by Yasir  Rahman on 23/07/2019 at 08:26 PM");
INSERT INTO crm_audit_log VALUES("8435","3","4","2019-07-23 22:11:27","Exit Invoice [Invoice No: 121250] updated by Yasir  Rahman on 23/07/2019 at 10:11 PM");
INSERT INTO crm_audit_log VALUES("8436","2","4","2019-07-24 00:42:24","Entry Invoice [Invoice No: 22404] updated by Yasir  Rahman on 24/07/2019 at 12:42 AM");
INSERT INTO crm_audit_log VALUES("8437","3","5","2019-07-24 01:47:23","Exit Invoice [Invoice No: 121251] updated by Imran  Khan on 24/07/2019 at 01:47 AM");
INSERT INTO crm_audit_log VALUES("8438","3","5","2019-07-24 02:41:47","Exit Invoice [Invoice No: 121252] updated by Imran  Khan on 24/07/2019 at 02:41 AM");
INSERT INTO crm_audit_log VALUES("8439","3","5","2019-07-24 02:42:48","Exit Invoice [Invoice No: 121253] updated by Imran  Khan on 24/07/2019 at 02:42 AM");
INSERT INTO crm_audit_log VALUES("8440","3","5","2019-07-24 07:23:23","Exit Invoice [Invoice No: 121254] updated by Imran  Khan on 24/07/2019 at 07:23 AM");
INSERT INTO crm_audit_log VALUES("8441","3","4","2019-07-24 09:48:42","Exit Invoice [Invoice No: 121255] updated by Yasir  Rahman on 24/07/2019 at 09:48 AM");
INSERT INTO crm_audit_log VALUES("8442","3","4","2019-07-24 09:50:05","Exit Invoice [Invoice No: 121256] updated by Yasir  Rahman on 24/07/2019 at 09:50 AM");
INSERT INTO crm_audit_log VALUES("8443","2","11","2019-07-24 10:08:51","Entry Invoice [Invoice No: 22405] updated by GAREEB GAREEB on 24/07/2019 at 10:08 AM");
INSERT INTO crm_audit_log VALUES("8444","3","4","2019-07-24 10:15:12","Exit Invoice [Invoice No: 121257] updated by Yasir  Rahman on 24/07/2019 at 10:15 AM");
INSERT INTO crm_audit_log VALUES("8445","3","4","2019-07-24 11:21:05","Exit Invoice [Invoice No: 121258] updated by Yasir  Rahman on 24/07/2019 at 11:21 AM");
INSERT INTO crm_audit_log VALUES("8446","2","11","2019-07-24 11:33:28","Entry Invoice [Invoice No: 22406] updated by GAREEB GAREEB on 24/07/2019 at 11:33 AM");
INSERT INTO crm_audit_log VALUES("8447","3","4","2019-07-24 12:22:19","Exit Invoice [Invoice No: 121259] updated by Yasir  Rahman on 24/07/2019 at 12:22 PM");
INSERT INTO crm_audit_log VALUES("8448","3","4","2019-07-24 12:25:45","Exit Invoice [Invoice No: 121260] updated by Yasir  Rahman on 24/07/2019 at 12:25 PM");
INSERT INTO crm_audit_log VALUES("8449","3","4","2019-07-24 12:39:23","Exit Invoice [Invoice No: 121261] updated by Yasir  Rahman on 24/07/2019 at 12:39 PM");
INSERT INTO crm_audit_log VALUES("8450","3","4","2019-07-24 12:41:08","Exit Invoice [Invoice No: 121262] updated by Yasir  Rahman on 24/07/2019 at 12:41 PM");
INSERT INTO crm_audit_log VALUES("8451","3","4","2019-07-24 12:43:07","Exit Invoice [Invoice No: 121263] updated by Yasir  Rahman on 24/07/2019 at 12:43 PM");
INSERT INTO crm_audit_log VALUES("8452","3","4","2019-07-24 13:03:59","Exit Invoice [Invoice No: 121264] updated by Yasir  Rahman on 24/07/2019 at 01:03 PM");
INSERT INTO crm_audit_log VALUES("8453","3","4","2019-07-24 13:41:09","Exit Invoice [Invoice No: 121265] updated by Yasir  Rahman on 24/07/2019 at 01:41 PM");
INSERT INTO crm_audit_log VALUES("8454","2","11","2019-07-24 14:32:06","Entry Invoice [Invoice No: 22407] updated by GAREEB GAREEB on 24/07/2019 at 02:32 PM");
INSERT INTO crm_audit_log VALUES("8455","2","11","2019-07-24 14:33:44","Entry Invoice [Invoice No: 22408] updated by GAREEB GAREEB on 24/07/2019 at 02:33 PM");
INSERT INTO crm_audit_log VALUES("8456","2","11","2019-07-24 15:11:30","Entry Invoice [Invoice No: 22409] updated by GAREEB GAREEB on 24/07/2019 at 03:11 PM");
INSERT INTO crm_audit_log VALUES("8457","3","4","2019-07-24 15:15:36","Exit Invoice [Invoice No: 121266] updated by Yasir  Rahman on 24/07/2019 at 03:15 PM");
INSERT INTO crm_audit_log VALUES("8458","3","4","2019-07-24 15:16:36","Exit Invoice [Invoice No: 121267] updated by Yasir  Rahman on 24/07/2019 at 03:16 PM");
INSERT INTO crm_audit_log VALUES("8459","3","4","2019-07-24 15:24:06","Exit Invoice [Invoice No: 121268] updated by Yasir  Rahman on 24/07/2019 at 03:24 PM");
INSERT INTO crm_audit_log VALUES("8460","3","4","2019-07-24 15:41:16","Exit Invoice [Invoice No: 121269] updated by Yasir  Rahman on 24/07/2019 at 03:41 PM");
INSERT INTO crm_audit_log VALUES("8461","3","4","2019-07-24 15:50:46","Exit Invoice [Invoice No: 121270] updated by Yasir  Rahman on 24/07/2019 at 03:50 PM");
INSERT INTO crm_audit_log VALUES("8462","2","11","2019-07-24 16:49:39","Entry Invoice [Invoice No: 22410] updated by GAREEB GAREEB on 24/07/2019 at 04:49 PM");
INSERT INTO crm_audit_log VALUES("8463","2","11","2019-07-24 16:50:57","Entry Invoice [Invoice No: 22411] updated by GAREEB GAREEB on 24/07/2019 at 04:50 PM");
INSERT INTO crm_audit_log VALUES("8464","3","4","2019-07-24 17:18:07","Exit Invoice [Invoice No: 121271] updated by Yasir  Rahman on 24/07/2019 at 05:18 PM");
INSERT INTO crm_audit_log VALUES("8465","3","4","2019-07-24 17:18:57","Exit Invoice [Invoice No: 121272] updated by Yasir  Rahman on 24/07/2019 at 05:18 PM");
INSERT INTO crm_audit_log VALUES("8466","1","4","2019-07-24 17:37:37","Customer [Customer No: 462] updated by Yasir  Rahman on 24/07/2019 at 05:37 PM");
INSERT INTO crm_audit_log VALUES("8467","3","4","2019-07-24 17:45:06","Exit Invoice [Invoice No: 121273] updated by Yasir  Rahman on 24/07/2019 at 05:45 PM");
INSERT INTO crm_audit_log VALUES("8468","3","4","2019-07-24 19:40:26","Exit Invoice [Invoice No: 121274] updated by Yasir  Rahman on 24/07/2019 at 07:40 PM");
INSERT INTO crm_audit_log VALUES("8469","3","4","2019-07-24 20:24:34","Exit Invoice [Invoice No: 121275] updated by Yasir  Rahman on 24/07/2019 at 08:24 PM");
INSERT INTO crm_audit_log VALUES("8470","3","4","2019-07-24 20:36:04","Exit Invoice [Invoice No: 121276] updated by Yasir  Rahman on 24/07/2019 at 08:36 PM");
INSERT INTO crm_audit_log VALUES("8471","1","4","2019-07-24 20:44:23","Customer [Customer No: 463] updated by Yasir  Rahman on 24/07/2019 at 08:44 PM");
INSERT INTO crm_audit_log VALUES("8472","3","4","2019-07-24 20:46:25","Exit Invoice [Invoice No: 121277] updated by Yasir  Rahman on 24/07/2019 at 08:46 PM");
INSERT INTO crm_audit_log VALUES("8473","1","4","2019-07-24 20:50:15","Customer [Customer No: 464] updated by Yasir  Rahman on 24/07/2019 at 08:50 PM");
INSERT INTO crm_audit_log VALUES("8474","3","4","2019-07-24 20:51:35","Exit Invoice [Invoice No: 121278] updated by Yasir  Rahman on 24/07/2019 at 08:51 PM");
INSERT INTO crm_audit_log VALUES("8475","2","4","2019-07-24 21:00:04","Entry Invoice [Invoice No: 22412] updated by Yasir  Rahman on 24/07/2019 at 09:00 PM");
INSERT INTO crm_audit_log VALUES("8476","3","4","2019-07-25 00:37:50","Exit Invoice [Invoice No: 121279] updated by Yasir  Rahman on 25/07/2019 at 12:37 AM");
INSERT INTO crm_audit_log VALUES("8477","3","4","2019-07-25 00:51:36","Exit Invoice [Invoice No: 121280] updated by Yasir  Rahman on 25/07/2019 at 12:51 AM");
INSERT INTO crm_audit_log VALUES("8478","3","4","2019-07-25 01:25:41","Exit Invoice [Invoice No: 121281] updated by Yasir  Rahman on 25/07/2019 at 01:25 AM");
INSERT INTO crm_audit_log VALUES("8479","3","4","2019-07-25 01:27:50","Exit Invoice [Invoice No: 121282] updated by Yasir  Rahman on 25/07/2019 at 01:27 AM");
INSERT INTO crm_audit_log VALUES("8480","2","4","2019-07-25 01:43:36","Entry Invoice [Invoice No: 22413] updated by Yasir  Rahman on 25/07/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("8481","2","4","2019-07-25 01:43:37","Entry Invoice [Invoice No: 22414] updated by Yasir  Rahman on 25/07/2019 at 01:43 AM");
INSERT INTO crm_audit_log VALUES("8482","2","4","2019-07-25 01:45:07","Entry Invoice [Invoice No: 22415] updated by Yasir  Rahman on 25/07/2019 at 01:45 AM");
INSERT INTO crm_audit_log VALUES("8483","2","4","2019-07-25 01:46:22","Entry Invoice [Invoice No: 22416] updated by Yasir  Rahman on 25/07/2019 at 01:46 AM");
INSERT INTO crm_audit_log VALUES("8484","3","4","2019-07-25 02:28:41","Exit Invoice [Invoice No: 121283] updated by Yasir  Rahman on 25/07/2019 at 02:28 AM");
INSERT INTO crm_audit_log VALUES("8485","3","4","2019-07-25 04:15:53","Exit Invoice [Invoice No: 121284] updated by Yasir  Rahman on 25/07/2019 at 04:15 AM");
INSERT INTO crm_audit_log VALUES("8486","3","4","2019-07-25 04:31:56","Exit Invoice [Invoice No: 121285] updated by Yasir  Rahman on 25/07/2019 at 04:31 AM");
INSERT INTO crm_audit_log VALUES("8487","3","4","2019-07-25 04:33:00","Exit Invoice [Invoice No: 121286] updated by Yasir  Rahman on 25/07/2019 at 04:33 AM");
INSERT INTO crm_audit_log VALUES("8488","2","4","2019-07-25 04:53:10","Entry Invoice [Invoice No: 22417] updated by Yasir  Rahman on 25/07/2019 at 04:53 AM");
INSERT INTO crm_audit_log VALUES("8489","3","4","2019-07-25 05:42:13","Exit Invoice [Invoice No: 121287] updated by Yasir  Rahman on 25/07/2019 at 05:42 AM");
INSERT INTO crm_audit_log VALUES("8490","3","4"