<?php 
    $items = array(new Stock);
    if( $boe != ""){
        $items = Stock::model()->with('warehouseDetails', 'deliverynote')->findAll( array( 'condition' => 'quantity > 0 AND deliverynote.isDelivered = "N" AND t.bill_of_entry="'.$boe.'" AND warehouseDetails.isDefault="N"' ) );
    }
?>
<table class="table table-hover table-bordered personal-task" id="delivery_item_table" >       
    <tr>
        <th class="bg-info" style="width:1%">No</th>            
        <th class="bg-info" style="width:10%">Item</th>
        <th class="bg-info" style="width:15%">Description</th>     
        <th class="bg-info" style="width:10%">Qty</th>            
        <th class="bg-info" style="width:10%">UoM</th>      
        <th class="bg-info" style="width:10%">Net Wt</th> 
        <th class="bg-info" style="width:10%">Gross Wt</th> 
        <th class="bg-info" style="width:10%">CBM</th>       
        <th class="bg-success" style="width:15%">Warehouse</th>    
        <th class="bg-success" style="width:10%">Quantity</th>
    </tr>
    <?php if( !empty($items) ){ ?>
        <?php foreach( $items as $i => $each ){ ?>
            <?php 
                $model = new WarehouseTransferHistory;
                $model->available_quantity = $each->quantity;
                $model->from_warehouse = $each->warehouse;
                $model->from_stock_id = $each->id;
            ?>
            <tr>                
                <td class="bg-info"><label><?php echo ($i+1); ?></label></td>
                <td class="bg-info"><?php echo $each->part_number ?></td>
                <td class="bg-info">
                    <?php echo CHtml::activehiddenField($model, "[".$i."]from_warehouse").CHtml::activehiddenField($model, "[".$i."]from_stock_id");  ?> 
                    <?php echo $each->description ?>
                </td>
                <td class="bg-info"><?php echo CHtml::activetextField($model, "[".$i."]available_quantity", array('class'=>'form-control go', 'readonly' => true)); ?></td>
                <td class="bg-info"><?php echo $each->inboundRelation->inb_quantity_unit; ?></td>
                <td class="bg-info"><?php echo $each->inboundRelation->inb_net_wt ?></td>
                <td class="bg-info"><?php echo $each->inboundRelation->inb_gross_wt ?></td>
                <td class="bg-info"><?php echo $each->inboundRelation->inb_cbm ?></td>
                <td class="bg-success"><?php echo CHtml::activedropdownlist($model, "[".$i."]to_warehouse", Warehouses::getWarehouses_wo_dedicated(),array('class'=>'form-control go')); ?></td>
                <td class="bg-success"><?php echo CHtml::activetextField($model, "[".$i."]quantity", array('class'=>'form-control go', 'onkeypress' => 'return isPositiveNumber(event)' , 'onkeyup' => 'validateQuantity(this.id, this.value);')); ?></td>
            </tr>      
        <?php } ?>
    <?php }else{ ?>
        <tr>
            <td colspan="10" class="text-center">No data</td>
        </tr>
    <?php } ?>
</table>