<?php

/**
 * This is the model class for table "{{server_config}}".
 *
 * The followings are the available columns in table '{{server_config}}':
 * @property string $tag
 * @property string $server
 * @property string $username
 * @property string $password
 * @property string $file_path
 * @property string $archive_path
 * @property string $isDefault
 */
class Server extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{server_config}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tag, server, username, password, file_path, archive_path', 'required'),
			array('tag, server, username, password, file_path, archive_path', 'length', 'max'=>255),
			array('isDefault', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('tag, server, username, password, file_path, archive_path, isDefault', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tag' => 'Tag',
			'server' => 'Server',
			'username' => 'Username',
			'password' => 'Password',
			'file_path' => 'File Path',
			'archive_path' => 'Archive Path',
			'isDefault' => 'Is Default',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tag',$this->tag,true);
		$criteria->compare('server',$this->server,true);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('file_path',$this->file_path,true);
		$criteria->compare('archive_path',$this->archive_path,true);
		$criteria->compare('isDefault',$this->isDefault,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Server the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getServer(){
		return self::model()->find(array('condition' => 'isDefault="Y"'));
	}
}
