<?php

/**
 * This is the model class for table "{{ledger}}".
 *
 * The followings are the available columns in table '{{ledger}}':
 * @property integer $id
 * @property integer $stock_id
 * @property string $part_number
 * @property string $description
 * @property string $delivery_note
 * @property string $shipment_reference
 * @property string $shipment_date
 * @property string $invoice_rate
 * @property string $gross_wt
 * @property string $in_quantity
 * @property string $out_quantity
 * @property string $type
 * @property string $created_date
 */
class Ledger extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ledger}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('stock_id, part_number, description, delivery_note, shipment_reference, shipment_date, in_invoice_rate, in_gross_wt, in_quantity, out_invoice_rate, out_gross_wt, out_quantity, type, created_date', 'required'),
			array('stock_id', 'numerical', 'integerOnly'=>true),
			array('part_number, delivery_note, shipment_reference', 'length', 'max'=>255),
			array('in_invoice_rate, in_gross_wt, in_quantity, out_invoice_rate, out_gross_wt, out_quantity', 'length', 'max'=>15),
			array('type', 'length', 'max'=>3),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, stock_id, part_number, description, delivery_note, shipment_reference, shipment_date, in_invoice_rate, in_gross_wt, in_quantity, out_invoice_rate, out_gross_wt, out_quantity, type, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'stock_id' => 'Stock',
			'part_number' => 'Part Number',
			'description' => 'Description',
			'delivery_note' => 'Delivery Note',
			'shipment_reference' => 'bill o entry or exit',
			'shipment_date' => 'Shipment Date',
			'invoice_rate' => 'Invoice Rate',
			'gross_wt' => 'Gross Wt',
			'in_quantity' => 'In Quantity',
			'out_quantity' => 'Out Quantity',
			'type' => 'Type',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('stock_id',$this->stock_id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('delivery_note',$this->delivery_note,true);
		$criteria->compare('shipment_reference',$this->shipment_reference,true);
		$criteria->compare('shipment_date',$this->shipment_date,true);
		$criteria->compare('invoice_rate',$this->invoice_rate,true);
		$criteria->compare('gross_wt',$this->gross_wt,true);
		$criteria->compare('in_quantity',$this->in_quantity,true);
		$criteria->compare('out_quantity',$this->out_quantity,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Ledger the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
