<?php

class QueryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Indetails', 'Outdetails', 'Downloadindetails','Loadinboundtable', 'Outview', 
                                   'Downloadoutdetails', 'Loadoutboundtable', 'Inview'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndetails() {
        $this->render('indetails');
    }

    public function actionOutdetails() {
        $this->render('outdetails');
    }
    
    
      public function actionDownloadindetails(){
        
        $deliverynote = Yii::app()->request->getParam('deliverynote');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $bill_of_entry = Yii::app()->request->getParam('bill_of_entry');
        $bill_from_date = Yii::app()->request->getParam('bill_from_date');
        $bill_to_date = Yii::app()->request->getParam('bill_to_date');
        $product = Yii::app()->request->getParam('product');
        $hs_code = Yii::app()->request->getParam('hs_code');
       
        $condition = 'parent.is_transfer_entry="N"';
        if( $deliverynote != "" )
            $condition .= ' AND t.inb_delivery_note_no = "'.trim($deliverynote).'"';
        if( $from_date != "")
            $condition .= ' AND parent.inb_added_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($from_date)))).'"';
        if( $to_date != "" )
            $condition .= ' AND parent.inb_added_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($to_date)))).'"';
        if( $bill_of_entry != "")
            $condition .= ' AND parent.inb_bill_of_entry_no = "'.trim($bill_of_entry).'"';
        if( $bill_from_date != "")
            $condition .= ' AND parent.inb_bill_of_entry_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_from_date)))).'"';
        if( $bill_to_date != "" )
            $condition .= ' AND parent.inb_bill_of_entry_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_to_date)))).'"';
        if( $product != "" )
            $condition .= ' AND t.inb_part_number = "'.trim($product).'"';
        if( $hs_code != "" )
            $condition .= ' AND t.inb_hs_code = "'.trim($hs_code).'"';

        $InboundItems = InboundItems::model()->with('parent')->findAll(array('condition' => $condition ));
        $filename = "indetails.xls";

           $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
                                <th class="head">Part No</th>
                                <th class="head">Description</th>
                                <th class="head">Brand</th>
                                <th class="head">Category</th>
                                <th class="head">Delivery Note</th>
                                <th class="head">GRN#</th>
                                <th class="head">Date</th>
                                <th class="head">BOE</th>
                                <th class="head">BOE Date</th>
                                <th class="head">Quantity</th>
                                <th class="head">Net Wt</th>
                                <th class="head">Gross Wt</th>
                                <th class="head">Cbm</th>
                                <th class="head">Price</th>
                                <th class="head">Country</th>
                                <th class="head">HS Code</th>
                                <th class="head">Total CIF Value</th>
                                <th class="head">Freight</th>
                                <th class="head">Freight Currency</th>
                                <th class="head">Total Containers</th>
                                <th class="head">Container Type</th>
                                <th class="head">Department</th>
                            </thead>
                            <tbody>';
        
        foreach ($InboundItems as $i => $item) {
            
            $stock = Stock::model()->find(array('condition' => 'deliverynote_item_id='.$item->id));
            $qty = ( $stock->id > 0 ) ? $stock->quantity  : $item->inb_quantity;
            $bill_date = ( $item->parent->inb_bill_of_entry_date != "0000-00-00") ? date('d/m/Y',strtotime($item->parent->inb_bill_of_entry_date)) : '';
            
            $data .= '<tr>
                        <td>'.($i+1). '</td>
                        <td>'.$item->inb_part_number.'</td>
                        <td>'.$item->inb_description. '</td>
                        <td>'.$item->brand->brand_name. '</td>
                        <td>'.$item->category->category_name. '</td>
                        <td>'.$item->inb_delivery_note_no. '</td> 
                        <td>'.$item->parent->inb_grn_no. '</td>
                        <td>'.date('d/m/Y',strtotime($item->parent->inb_added_date)) . '</td>
                        <td>'.$item->parent->inb_bill_of_entry_no. '</td>
                        <td>'.$bill_date . '</td>
                        <td>'.$item->inb_quantity. '</td>
                        <td>'.$item->inb_net_wt. '</td>
                        <td>'.$item->inb_gross_wt. '</td>
                        <td>'.$item->inb_cbm. '</td>
                        <td>'.$item->inb_invoice_rate. '</td>
                        <td>'.$item->inb_contry_of_origin. '</td>
                        <td>'.$item->inb_hs_code.'</td>
                        <td>'.$item->inb_total_cif_value. '</td>
                        <td>'.$item->parent->inb_frieght. '</td>
                        <td>'.$item->parent->inb_frieght_currency. '</td>
                        <td>'.$item->parent->inb_total_containers.'</td> 
                        <td>'.$item->parent->inb_container_type.'</td> 
                        <td>'.$item->parent->inb_department.'</td> 
                     </tr>';
            
            }

            $data .= '      </tbody>
                    </table>
                </body>
            </html>';
        
        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
        
    }
    
    /*public function actionDownloadindetails(){
        
        $deliverynote = Yii::app()->request->getParam('deliverynote');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $bill_of_entry = Yii::app()->request->getParam('bill_of_entry');
        $bill_from_date = Yii::app()->request->getParam('bill_from_date');
        $bill_to_date = Yii::app()->request->getParam('bill_to_date');
        $product = Yii::app()->request->getParam('product');
        $hs_code = Yii::app()->request->getParam('hs_code');
       
        $condition = 'parent.is_transfer_entry="N"';
        if( $deliverynote != "" )
            $condition .= ' AND t.inb_delivery_note_no = "'.trim($deliverynote).'"';
        if( $from_date != "")
            $condition .= ' AND parent.inb_added_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($from_date)))).'"';
        if( $to_date != "" )
            $condition .= ' AND parent.inb_added_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($to_date)))).'"';
        if( $bill_of_entry != "")
            $condition .= ' AND parent.inb_bill_of_entry_no = "'.trim($bill_of_entry).'"';
        if( $bill_from_date != "")
            $condition .= ' AND parent.inb_bill_of_entry_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_from_date)))).'"';
        if( $bill_to_date != "" )
            $condition .= ' AND parent.inb_bill_of_entry_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_to_date)))).'"';
        if( $product != "" )
            $condition .= ' AND t.inb_part_number = "'.trim($product).'"';
        if( $hs_code != "" )
            $condition .= ' AND t.inb_hs_code = "'.trim($hs_code).'"';

        $InboundItems = InboundItems::model()->with('parent')->findAll(array('condition' => $condition ));
        $filename = "indetails.xls";

           $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
                                <th class="head">Part No</th>
                                <th class="head">Description</th>
                                <th class="head">Delivery Note</th>
                                <th class="head">Date</th>
                                <th class="head">BOE</th>
                                <th class="head">BOE Date</th>
                                <th class="head">Quantity</th>
                                <th class="head">Net Wt</th>
                                <th class="head">Gross Wt</th>
                                <th class="head">Cbm</th>
                                <th class="head">Price</th>
                                <th class="head">Country</th>
                                <th class="head">HS Code</th>
                            </thead>
                            <tbody>';
        
        foreach ($InboundItems as $i => $item) {
            
            $stock = Stock::model()->find(array('condition' => 'deliverynote_item_id='.$item->id));
            $qty = ( $stock->id > 0 ) ? $stock->quantity  : $item->inb_quantity;
            $bill_date = ( $item->parent->inb_bill_of_entry_date != "0000-00-00") ? date('d/m/Y',strtotime($item->parent->inb_bill_of_entry_date)) : '';
            
            $data .= '<tr>
                        <td>'.($i+1). '</td>
                        <td>'.$item->inb_part_number.'</td>
                        <td>'.$item->inb_description. '</td>
                        <td>'.$item->inb_delivery_note_no. '</td> 
                        <td>'.date('d/m/Y',strtotime($item->parent->inb_added_date)) . '</td>
                        <td>'.$item->parent->inb_bill_of_entry_no. '</td>
                        <td>'.$bill_date . '</td>
                        <td>'.$item->inb_quantity. '</td>
                        <td>'.$item->inb_net_wt. '</td>
                        <td>'.$item->inb_gross_wt. '</td>
                        <td>'.$item->inb_cbm. '</td>
                        <td>'.$item->inb_invoice_rate. '</td>
                        <td>'.$item->inb_contry_of_origin. '</td>
                        <td>'.$item->inb_hs_code.'</td>
                     </tr>';
            
            }

            $data .= '      </tbody>
                    </table>
                </body>
            </html>';
        
        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
        
    }*/

    public function actionLoadinboundtable(){
        
        $deliverynote = $_POST['deliverynote']; 
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date']; 
        $bill_of_entry = $_POST['bill_of_entry'];
        $bill_from_date = $_POST['bill_from_date']; 
        $bill_to_date = $_POST['bill_to_date']; 
        $product = $_POST['product'];
        $hs_code = $_POST['hs_code'];

        $condition = '1=1';
        if( $deliverynote != "" )
            $condition .= ' AND t.inb_delivery_note_no = "'.trim($deliverynote).'"';
        if( $from_date != "")
            $condition .= ' AND parent.inb_added_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($from_date)))).'"';
        if( $to_date != "" )
            $condition .= ' AND parent.inb_added_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($to_date)))).'"';
        if( $bill_of_entry != "")
            $condition .= ' AND parent.inb_bill_of_entry_no = "'.trim($bill_of_entry).'"';
        if( $bill_from_date != "")
            $condition .= ' AND parent.inb_bill_of_entry_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_from_date)))).'"';
        if( $bill_to_date != "" )
            $condition .= ' AND parent.inb_bill_of_entry_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_to_date)))).'"';
        if( $product != "" )
            $condition .= ' AND t.inb_part_number = "'.trim($product).'"';
        if( $hs_code != "" )
            $condition .= ' AND t.inb_hs_code = "'.trim($hs_code).'"';

        $InboundItems = InboundItems::model()->with('parent')->findAll(array('condition' => $condition ));

        
        $data .= '<thead><tr>';
                $data .= '<th>Part No</th>';
                $data .= '<th>Description</th>';
                $data .= '<th>Delivery Note</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>BOE</th>';
                $data .= '<th>BOE Date</th>';
                $data .= '<th>Qty</th>';
                $data .= '<th>Wt</th>';
                $data .= '<th>Price</th>';
                // $data .= '<th>Country<th>';
                // $data .= '<th>HSC<th>';
                $data .= '<th>Balance</th>';
                $data .= '<th><i class="fa fa-eye"></i></th>';
        $data .= '</tr></thead>';

        foreach ($InboundItems as $i => $item) {
            
            
            $bill_date = ( $item->parent->inb_bill_of_entry_date != "0000-00-00") ? date('d/m/Y',strtotime($item->parent->inb_bill_of_entry_date)) : '';
            $data .= '<tbody><tr>';
                $data .= '<td>'.$item->inb_part_number.'</td>';
                $data .= '<td>'.$item->inb_description.'</td>';
                $data .= '<td>'.$item->inb_delivery_note_no.'</td>';
                $data .= '<td>'.date('d/m/Y',strtotime($item->parent->inb_added_date)).'</td>';
                $data .= '<td>'.$item->parent->inb_bill_of_entry_no.'</td>';
                $data .= '<td>'.$bill_date.'</td>';
                $data .= '<td>'.$item->inb_quantity.'</td>';
                $data .= '<td>'.$item->inb_gross_wt.'</td>';
                $data .= '<td>'.$item->inb_invoice_rate.'</td>';
                // $data .= '<td>'.$item->inb_contry_of_origin.'<td>';
                // $data .= '<td>'.$item->inb_hs_code.'<td>';
                $stock = Stock::model()->find(array('condition' => 'deliverynote_item_id='.$item->id));
                $data .= '<td>'.$stock->quantity.'</td>';
                $data .= '<td><button class="btn btn-primary btn-xs" title="out details" onclick="loadPopupModal(\'query/outview&id='.$stock->id.'\',\''.$item->inb_part_number.' : '.$item->inb_description.'\',\'lg\')"><i class="fa fa-eye"></i></button></td>';
            $data .= '</tr></tbody>';
            
        }
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('table',array( 'data' => $data));
    }

    public function actionOutview(){
         $id = Yii::app()->request->getParam('id');
            $data .= '<thead><tr>';
                $data .= '<th>DN</th>';
                $data .= '<th>BOE</th>';
                $data .= '<th>BOE Date</th>';
                $data .= '<th>Qty</th>';
                $data .= '<th>Wt</th>';
            $data .= '</tr></thead>';
         if( (int) $id > 0 ){
            $items = Ledger::model()->findAll( array('condition' =>'type="OUT" AND stock_id='.$id) );
            if( !empty($items) ){
                foreach ( $items as $each ){
                    $data .= '<tbody><tr>';
                        $data .= '<td>'.$each->delivery_note.'</td>';
                        $data .= '<td>'.$each->shipment_reference.'</td>';
                        $data .= '<td>'.date('d/m/Y',strtotime($each->shipment_date)).'</td>';
                        $data .= '<td>'.$each->out_quantity.'</td>';
                        $data .= '<td>'.$each->out_gross_wt.'</td>';
                    $data .= '</tr></tbody>';
                }
            }else{
                $data .= '<tr><td colspan="7" class="text-center">No Data</td></tr>';
            }   
         }
         
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('table',array( 'data' => $data));
    }

     public function actionDownloadoutdetails(){
        
        $deliverynote = Yii::app()->request->getParam('deliverynote');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $bill_of_entry = Yii::app()->request->getParam('bill_of_entry');
        $bill_from_date = Yii::app()->request->getParam('bill_from_date');
        $bill_to_date = Yii::app()->request->getParam('bill_to_date');
        $product = Yii::app()->request->getParam('product');
        $hs_code = Yii::app()->request->getParam('hs_code');
       
        $condition = '1=1';
        if( $deliverynote != "" )
            $condition .= ' AND t.outb_delivery_note_no = "'.trim($deliverynote).'"';
        if( $from_date != "")
            $condition .= ' AND parent.outb_added_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($from_date)))).'"';
        if( $to_date != "" )
            $condition .= ' AND parent.outb_added_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($to_date)))).'"';
        if( $bill_of_entry != "")
            $condition .= ' AND parent.outb_bill_of_exit_no = "'.trim($bill_of_entry).'"';
        if( $bill_from_date != "")
            $condition .= ' AND parent.outb_bill_of_exit_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_from_date)))).'"';
        if( $bill_to_date != "" )
            $condition .= ' AND parent.outb_bill_of_exit_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_to_date)))).'"';
        if( $product != "" )
            $condition .= ' AND t.outb_part_number = "'.trim($product).'"';
        if( $hs_code != "" )
            $condition .= ' AND t.outb_hs_code = "'.trim($hs_code).'"';

        $OutboundItems = OutboundItems::model()->with('parent')->findAll(array('condition' => $condition ));
        $filename = "outdetails.xls";

             $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
                                <th class="head">Part No</th>
                                <th class="head">Description</th>
                                <th class="head">Delivery Note</th>
                                <th class="head">Date</th>
                                <th class="head">Bill of Entry</th>
                                <th class="head">Brand</th>
                                <th class="head">Category</th>
                                <th class="head">Customer Name</th>
                                <th class="head">Transfer To</th>
                                <th class="head">LPO</th>
                                <th class="head">Invoice No.</th>
                                <th class="head">BOE</th>
                                <th class="head">BOE Date</th>
                                <th class="head">Quantity</th>
                                <th class="head">Net Wt</th>
                                <th class="head">Gross Wt</th>
                                <th class="head">Cbm</th>
                                <th class="head">Price</th>
                                <th class="head">Country</th>
                                <th class="head">HS Code</th>
                                <th class="head">status</th>
                            </thead>
                            <tbody>';
        
        
        foreach ($OutboundItems as $i => $item) {
            $bill_date = ( $item->parent->outb_bill_of_exit_date != "0000-00-00") ? date('d/m/Y',strtotime($item->parent->outb_bill_of_exit_date)) : '';
            $font = (  $item->outb_posted == 'Y' ) ? '&#10003' : '&#10005';
            $style = (  $item->outb_posted == 'Y' ) ? '' : 'style="background-color:red"';
            $data .= '<tr>
                        <td '.$style.' >'.($i+1). '</td>
                        <td '.$style.' >'.$item->outb_part_number.'</td>
                        <td '.$style.' >'.$item->outb_description. '</td>
                        <td '.$style.' >'.$item->outb_delivery_note_no. '</td> 
                        <td '.$style.' >'.date('d/m/Y',strtotime($item->parent->outb_added_date)) . '</td>
                        <td '.$style.' >'.$item->currentStock->bill_of_entry . '</td>
                        <td '.$style.' >'.$item->brand->brand_name . '</td>
                        <td '.$style.' >'.$item->category->category_name . '</td>
                        <td '.$style.' >'.$item->parent->cus_original->name . '</td>
                        <td '.$style.' >'.$item->parent->cus->name . '</td>
                        <td '.$style.' >'.$item->parent->outb_packed_by . '</td>
                        <td '.$style.' >'.$item->parent->outb_invoice_no . '</td>
                        <td '.$style.' >'.$item->parent->outb_bill_of_exit_no. '</td>
                        <td '.$style.' >'.$bill_date . '</td>
                        <td '.$style.' >'.$item->outb_quantity. '</td>
                        <td '.$style.' >'.$item->outb_net_wt. '</td>
                        <td '.$style.' >'.$item->outb_gross_wt. '</td>
                        <td '.$style.' >'.$item->outb_cbm. '</td>
                        <td '.$style.' >'.$item->outb_invoice_rate. '</td>
                        <td '.$style.' >'.$item->outb_contry_of_origin. '</td>
                        <td '.$style.' >'.$item->outb_hs_code.'</td>
                        <td '.$style.' >'.$font.'</td>
                     </tr>';
            
            }
        
         $data .= '      </tbody>
                    </table>
                </body>
            </html>';
        
        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
        
    }

    public function actionLoadoutboundtable(){
        
        $deliverynote = $_POST['deliverynote']; 
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date']; 
        $bill_of_entry = $_POST['bill_of_entry'];
        $bill_from_date = $_POST['bill_from_date']; 
        $bill_to_date = $_POST['bill_to_date']; 
        $product = $_POST['product'];
        $hs_code = $_POST['hs_code'];

        $condition = '1=1';
        if( $deliverynote != "" )
            $condition .= ' AND t.outb_delivery_note_no = "'.trim($deliverynote).'"';
        if( $from_date != "")
            $condition .= ' AND parent.outb_added_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($from_date)))).'"';
        if( $to_date != "" )
            $condition .= ' AND parent.outb_added_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($to_date)))).'"';
        if( $bill_of_entry != "")
            $condition .= ' AND parent.outb_bill_of_exit_no = "'.trim($bill_of_entry).'"';
        if( $bill_from_date != "")
            $condition .= ' AND parent.outb_bill_of_exit_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_from_date)))).'"';
        if( $bill_to_date != "" )
            $condition .= ' AND parent.outb_bill_of_exit_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_to_date)))).'"';
        if( $product != "" )
            $condition .= ' AND t.outb_part_number = "'.trim($product).'"';
        if( $hs_code != "" )
            $condition .= ' AND t.outb_hs_code = "'.trim($hs_code).'"';

        $OutboundItems = OutboundItems::model()->with('parent')->findAll(array('condition' => $condition ));

        
        $data .= '<thead><tr>';
                $data .= '<th>Part No</th>';
                $data .= '<th>Description</th>';
                $data .= '<th>Delivery Note</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>BOE</th>';
                $data .= '<th>BOE Date</th>';
                $data .= '<th>Qty</th>';
                $data .= '<th>Wt</th>';
                $data .= '<th>Price</th>';
                // $data .= '<th>Country<th>';
                // $data .= '<th>HSC<th>';
                $data .= '<th><i class="fa fa-eye"></i></th>';
        $data .= '</tr></thead>';

        foreach ($OutboundItems as $i => $item) {
            
            
            $bill_date = ( $item->parent->outb_bill_of_exit_date != "0000-00-00") ? date('d/m/Y',strtotime($item->parent->outb_bill_of_exit_date)) : '';
            
            $data .= '<tbody><tr>';
                $data .= '<td>'.$item->outb_part_number.'</td>';
                $data .= '<td>'.$item->outb_description.'</td>';
                $data .= '<td>'.$item->outb_delivery_note_no.'</td>';
                $data .= '<td>'.date('d/m/Y',strtotime($item->parent->outb_added_date)).'</td>';
                $data .= '<td>'.$item->parent->outb_bill_of_exit_no.'</td>';
                $data .= '<td>'.$bill_date.'</td>';
                $data .= '<td>'.$item->outb_quantity.'</td>';
                $data .= '<td>'.$item->outb_gross_wt.'</td>';
                $data .= '<td>'.$item->outb_invoice_rate.'</td>';
                // $data .= '<td>'.$item->outb_contry_of_origin.'<td>';
                // $data .= '<td>'.$item->outb_hs_code.'<td>';
                $data .= '<td><button class="btn btn-primary btn-xs" title="Inbound details" onclick="loadPopupModal(\'query/inview&id='.$item->id.'\',\''.$item->outb_part_number.' : '.$item->outb_description.'\',\'lg\')"><i class="fa fa-eye"></i></button></td>';
            $data .= '</tr></tbody>';
            
        }
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('table',array( 'data' => $data));
    }

    public function actionInview(){
         $id = Yii::app()->request->getParam('id');
            $data .= '<thead><tr>';
                $data .= '<th>DN</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>BOE</th>';
                $data .= '<th>BOE Date</th>';
                $data .= '<th>HSC</th>';
                $data .= '<th>Qty</th>';
                $data .= '<th>Bal</th>';
                $data .= '<th>Wt</th>';
            $data .= '</tr></thead>';
         if( (int) $id > 0 ){
            $items = Ledger::model()->findAll(array( 'condition' => 'master_id ='.$id.' AND type="OUT"'));
            if( !empty($items) ){
                foreach ( $items as $each ){
                    $stock = Stock::model()->findBypk($each->stock_id);
                    $data .= '<tbody><tr>';
                        $data .= '<td>'.$stock->deliverynote.'</td>';
                        $data .= '<td>'.date('d/m/Y',strtotime($stock->inboundRelation->parent->inb_added_date)).'</td>';
                        $data .= '<td>'.$stock->bill_of_entry.'</td>';
                        $data .= '<td>'.date('d/m/Y',strtotime($stock->bill_of_entry_date)).'</td>';
                        $data .= '<td>'.$stock->inboundRelation->inb_hs_code.'</td>';
                        $data .= '<td>'.$stock->inboundRelation->inb_quantity.'</td>';
                        $data .= '<td>'.$stock->quantity.'</td>';
                        $data .= '<td>'.$stock->inboundRelation->inb_gross_wt.'</td>';
                    $data .= '</tr></tbody>';
                }
            }else{
                $data .= '<tr><td colspan="7" class="text-center">No Data</td></tr>';
            }   
         }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('table',array( 'data' => $data));
    }
    
}