<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '
        $(document).ready(function() {
            var table_id ="#tbl_warehouses";
            var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                data.from_date = $("#start_date").val();
                data.to_date = $("#end_date").val();
                return data;
            }).DataTable({
                scrollY         : "500px",
                pageLength      : 50,
                ajax: {
                    url: "' . Yii::app()->createUrl('inbound/getWarehouses') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                order: [[ 1, "desc" ]],
            
            });
            $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);



?>

    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-university"></i> Warehouses
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('inbound/newwarehouse','Add New Warehouse','md')"><i class="fa fa-plus"></i></button>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_warehouses">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
