<?php

$cs = Yii::app()->getClientScript();

$cs->registerScript("load", '

        $(document).ready(function() {

            var table_id ="#tbl_items";

            var table = $(table_id).on("preXhr.dt", function (e, settings, data) {

                return data;

            }).DataTable({

                scrollY         : "380px",

                pageLength      : 50,

                ajax: {

                    url: "' . Yii::app()->createUrl('inbound/getItems') . '",

                    type: "POST",

                    cache : false,

                "data": function ( params ) {

                    params.YII_CSRF_TOKEN = "'.Yii::app()->request->csrfToken.'";

                }

                },

                serverSide:     true,

                fixedColumns:   true,

                processing: true,

                order: [[ 0, "desc" ]],

            

            });

            $(".dataTables_scrollFoot").hide();

    });', CClientScript::POS_HEAD);



?>



    <section class="panel">

        <header class="panel-heading clearfix panel-theame">

            <i class="fa fa-file"></i> Item Master

            <div class="pull-right">

                <?php

                if (Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn['inventory_import_stock'])) {

                ?>

                <?php if( $show_btn ) : ?>

                    <!--<button class="btn btn-sm btn-theme" title="Import opening stock" onclick="loadPopupModal('inbound/import_opening','Import','md')"><i class="fa fa-download"></i> Opening</button>-->

                <?php endif; ?>

                <?php }

                if (Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn['inventory_import_item'])) {

                    ?>      

                <!--<button class="btn btn-sm btn-theme" title="Import Item master" onclick="loadPopupModal('inbound/import_items','Import','md')"><i class="fa fa-download"></i> Import</button>-->

                <?php }

//                if (Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn['inventory_import_item'])) {

                    ?>      

                <!--<button class="btn btn-sm btn-theme" title="Export Item master" onclick="InventoryImportItem()"><i class="fa fa-download"></i> Export</button>-->

                <button class="btn btn-sm btn-theme" title="Add New Item" onclick="loadPopupModal('inbound/add_product','New','lg')"><i class="fa fa-plus"></i> Add</button>

                <?php // }

                ?>

            </div>

        </header>

        <div class="panel-body">

            <div class="custom-data-table">

                <table class="table table-hover table-bordered personal-task" id="tbl_items">

                    <thead>

                        <tr>

                            <th>Part Number</th>

                            <th>Base Code</th>

                            <th>Category</th>

                            <th>Description</th>

                            <!-- <th>UPC Code</th> -->

                            <th>HS Code</th>

                            <th>Price</th>

                            <th>Actions</th>

                        </tr>

                    </thead>

                </table>

            </div>

        </div>

    </section>

<?php 

$cs = Yii::app()->getClientScript(); 

$cs->registerScript("InventoryImportItem", "function InventoryImportItem(){

window.open($('#liveSite').val()+'index.php?r=inbound/ExportInventory', '_blank');

}", CClientScript::POS_HEAD);

?>