<?php

class TransferController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'Create', 'Getdeliverylist', 'Preview'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetlist(){
        $model  = new Transfers();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'delivery_notes',
            2 => 'ta_no', 
            3 => 'bill_of_exit', 
            4 => 'created_datetime', 
            5 => 'isInernal', 
            // 6 => 'id', 
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir']; 
        $orderBy   = $filterColumn." ".$filterOrder;
        $from_date = ( count(explode('/',$_POST['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])))  : date('Y-m-01');
        $to_date = ( count(explode('/',$_POST['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])))  : date('Y-m-t');
        $condition = 'DATE(created_datetime) BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
        if(isset($_POST['search']['value']) && trim($_POST['search']['value']) !="")
        {
            $searchString = trim($_POST['search']['value']);
            $condition.=" AND (delivery_notes LIKE '%".$searchString."%' OR ta_no LIKE '%".$searchString."%' OR bill_of_exit LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData=array();
        $m=1;
        foreach ($model as $eachItem)
        {
           
            // $div  = '<div class="btn-wrap text-center">';
            // $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'outbound/create&dn='.$eachItem['outb_delivery_note_no'].'\',\'TA : '.$eachItem['outb_ta_number'].'/ DN : '.$eachItem['outb_delivery_note_no'].'\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            // $div .= '</div>';
            $eachItemData[]=array($eachItem['id'],$eachItem['delivery_notes'],$eachItem['ta_no'],$eachItem['bill_of_exit'],date('d/m/Y',strtotime($eachItem['created_datetime'])),($eachItem['isInernal'] == "Y") ? 'Yes' : 'No');
          
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionCreate(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('transfer');
    }

    public function actionGetdeliverylist(){
        $type = $_POST['type'];
        $data = ( $type == 'N' ) ? Outbound::getDeliverylist('third_party') : Outbound::getDeliverylist('internal');
        $drop = CHtml::activedropdownlist(new Transfers,'delivery_notes', $data ,array('data-label'=>'Delivery Notes', 'multiple' => true, 'onchange' => 'buildTree();'));
        echo json_encode( array( 'delivery_drops'=> $drop) );
    }

    public function actionPreview(){
        //($i == 0 ) ? true : false,
        $deliveryNotes = Yii::app()->request->getParam('data');
        $response = array();
        if( $deliveryNotes != "null" ){
            $docs = Outbound::model()->findAll(array('condition'=>'outb_delivery_note_no IN ('.$deliveryNotes.')'));
            foreach ( $docs as $i => $each ){
                $childArray = array();
                $response[$i]['id'] = $each->outb_delivery_note_no;
                $response[$i]['text'] = 'DN : '.$each->outb_delivery_note_no.' | CUS : '.$each->cus->name;
                $response[$i]['state'] = array(
                    'opened' => false,
                    'disabled' => false,
                    'selected' => false,
                );
                $docItems = OutboundItems::model()->findAll( array('condition' => 'outb_delivery_note_no="'.$each->outb_delivery_note_no.'"') );
                foreach ( $docItems as $x => $eachItem ){
                    $childArray[$x] = $eachItem->outb_part_number.' | '.$eachItem->outb_description.' | '.$eachItem->outb_quantity.' '.$eachItem->outb_quantity_unit.' | '.$eachItem->outb_invoice_rate.' '.$eachItem->outb_currency_code;
                }
                $response[$i]['children'] = $childArray;
            }
        }
        echo json_encode($response);
    }

    public function actionSave(){
        function validateQuantity($deliveryNotes){
            $response = array();
            $response['convertable'] = true;
            $itemsArray = $errors = array();
            foreach ( $deliveryNotes as $each_dn ){
                $each_delivery = Outbound::model()->findBypk($each_dn);
                foreach ( $each_delivery->items as $eachItem ){
                    $itemsArray[$eachItem->outb_stock_id]['part_no'] = $eachItem->outb_part_number;; 
                    $itemsArray[$eachItem->outb_stock_id]['available'] = (float) Stock::model()->findbypk($eachItem->outb_stock_id)->quantity;
                    $itemsArray[$eachItem->outb_stock_id]['required'] = (float) $itemsArray[$eachItem->outb_stock_id]['required'] + (float) $eachItem->outb_quantity;
                }
            }
            foreach( $itemsArray as $eachItem ){
            
                if( $eachItem['available'] < $eachItem['required'] ){
                    $response['convertable'] = false;
                    $errors[] = 'Item '.$eachItem['part_no'].' Required is '.$eachItem['required'].' and Available '.$eachItem['available'];
                }
            }
            $response['errors'] = $errors;
            return $response;
        }
        if(isset($_POST)){
            $deliveryNotes = $postData = array();
            $postFlag = false;
            if( is_array($_POST['Transfers']['delivery_notes'])){
                foreach ( $_POST['Transfers']['delivery_notes'] as $i => $each ){
                    $deliveryNotes[$i] = $each;
                }
            }
            if( count($deliveryNotes) > 0 ){
                $validationResponse = validateQuantity($deliveryNotes);
                if( $validationResponse['convertable'] ){
                    $internalTransfer = ( $_POST['Transfers']['isInernal'] == 'Y' ) ? true : false;
                    $model = new Transfers;
                    $model->attributes = $_POST['Transfers'];
                    $model->delivery_notes = implode(',', $deliveryNotes);
                    $model->ta_no = MasCompany::getOutbound_ta(true);
                    $model->created_by = Yii::app()->user->id;
                    $model->created_datetime = date('Y-m-d h:i:s');
                    $model->save(false);

                    $postData['key'] = 'n8kX0h6G1Krp3c';
                    $deliveryNotelist = array();
                    foreach ( $deliveryNotes as $i => $eachDN ){
                        
                        $dNote =  Outbound::model()->findBypk($eachDN);
                        $dNote->outb_ta_number = $model->ta_no;
                        $dNote->outb_bill_of_exit_no = $model->bill_of_exit;
                        $dNote->outb_bill_of_exit_date = date('Y-m-d');
                        $dNote->save(false);

                        $postItems =array();
                        $deliveryNotelist[$i]['dn'] = $dNote->outb_delivery_note_no;
                        $deliveryNotelist[$i]['ta'] =  $dNote->outb_ta_number;
                        $deliveryNotelist[$i]['boe'] = $dNote->outb_bill_of_exit_no;
                        $deliveryNotelist[$i]['boe_d'] = $dNote->outb_bill_of_exit_date;
                        $deliveryNotelist[$i]['w_house'] = 1;  //detault
                    
                        foreach ( $dNote->items as $x => $each ){
                            $postItems[$x]['pno'] = $each->outb_part_number;
                            $postItems[$x]['des']= $each->outb_description;
                            $postItems[$x]['hsc']= $each->outb_hs_code;
                            $postItems[$x]['coo']= $each->outb_contry_of_origin;
                            $postItems[$x]['coo_c']= $each->currentStock->inboundRelation->inb_contry_of_origin_code;
                            $postItems[$x]['cco']= $each->outb_currency_code ;
                            $postItems[$x]['value']= $each->outb_invoice_rate;
                            $postItems[$x]['qty']= $each->outb_quantity;
                            $postItems[$x]['qty_u']= $each->outb_quantity_unit;
                            $postItems[$x]['nt_wt']= $each->outb_net_wt;
                            $postItems[$x]['gr_wt']= $each->outb_gross_wt;
                            $postItems[$x]['cbm']= $each->outb_cbm;
                            $postItems[$x]['remarks']= $each->outb_remarks;
                        }

                        $deliveryNotelist[$i]['items'] = $postItems;
                    }
                    $postData['data'] = $deliveryNotelist;
                    echo json_encode(
                        array(
                            'status' => 'success',
                            'postFlag' => ( $internalTransfer ) ? 'true' : 'false',
                            'postData' => $postData,
                        )
                    );
                    $this->Connect();
                }else{
                    echo json_encode($validationResponse['errors']);
                }
            }else{
                echo json_encode(array('' => 'Delivery Notes cannot blank!'));
            }
            
        }
    }

    public function Connect(){
        
        ini_set('max_execution_time', -1);
        $outbound =  Outbound::model()->findAll( array( 'condition' => 'TRIM(outb_bill_of_exit_no)!="" AND outb_delivery_note_posted="N"', 'order' => 'outb_bill_of_exit_date ASC', 'limit' => 1000 ) );
        if( !empty($outbound) ){
            foreach( $outbound as $eachOutbound ){
                // if( $eachOutbound->isDirectDelivery == 'Y' ){
                    if( !empty($eachOutbound->items) ){
                        foreach( $eachOutbound->items as $eachItem ){
                            
                            $ledger = new Ledger;
                            $ledger->stock_id = $eachItem->outb_stock_id;
                            $ledger->master_id = $eachItem->id;  //outbound
                            $ledger->warehouse_id = $eachItem->currentStock->warehouse;
                            $ledger->part_number = trim($eachItem->outb_part_number);
                            $ledger->description = $eachItem->outb_description;
                            $ledger->delivery_note =  $eachItem->outb_delivery_note_no;
                            $ledger->shipment_reference =  $eachItem->parent->outb_bill_of_exit_no;
                            $ledger->shipment_date = $eachItem->parent->outb_bill_of_exit_date;
                            $ledger->out_invoice_rate = $eachItem->outb_invoice_rate;
                            $ledger->out_net_wt = $eachItem->outb_net_wt;
                            $ledger->out_cbm = $eachItem->outb_cbm;
                            $ledger->out_gross_wt = $eachItem->outb_gross_wt;
                            $ledger->out_quantity  = $eachItem->outb_quantity;
                            $ledger->type  = 'OUT';
                            $ledger->created_date = date('Y-m-d h:i:s');
                            $ledger->save(false);

                            $eachItem->outb_posted = 'Y';
                            $eachItem->save(false);
                            
                            $updateQuery = 'UPDATE nia_current_stock SET quantity = quantity - '.(float) $eachItem->outb_quantity.' WHERE id='.$eachItem->outb_stock_id;
                            Yii::app()->db->createCommand($updateQuery)->execute();
                        }
                    }
                // }
                Outbound::model()->updatebypk($eachOutbound->outb_delivery_note_no,array( 'outb_delivery_note_posted' => 'Y' ));
            }
        }
    }
    
}